package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel("调拨单明细分页查询EXT请求参数")
public class TransferOrderReportExtReqDto {

    @ApiModelProperty("调拨单号列表")
    private List<String> transferOrderNos;

    @ApiModelProperty("渠道单号列表")
    private List<String> platformOrderNos;

    @ApiModelProperty("调出仓列表")
    private List<String> outLogicWarehouseCodes;

    @ApiModelProperty("调入仓列表")
    private List<String> inLogicWarehouseCodes;

    @ApiModelProperty("创建开始时间")
    private Date createStartTime;

    @ApiModelProperty("创建结束时间")
    private Date createEndTime;

    @ApiModelProperty("发货开始时间")
    private Date deliveryStartTime;

    @ApiModelProperty("发货结束时间")
    private Date deliveryEndTime;

    @ApiModelProperty("调拨单状态列表")
    private List<String> orderStatus;

    @ApiModelProperty("页码")
    private Integer pageNum = 1;

    @ApiModelProperty("每页大小")
    private Integer pageSize = 10;
}