package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

import com.dtyunxi.dto.BaseRespDto;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;

/**
 * 物流信息表Eo对象
 *
 * @author 宁毅
 * @since 2022-05-07
 */
@Getter
@Setter
@ApiModel(value = "CsLogisticsInfoRespDto", description = "物流信息表Eo对象")
public class CsLogisticsInfoRespDto extends BaseRespDto {
    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     * 承运商序列号，唯一索引
     */
    @ApiModelProperty(name = "carrierId", value = "承运商序列号，唯一索引")
    private String carrierId;

    /**
     * 类型
     */
    @ApiModelProperty(name = "type", value = "类型： 1物流，2快递")
    private Integer type;

    /**
     * CSP客户订单号
     */
    @ApiModelProperty(name = "cspNo", value = "CSP客户订单号")
    private String cspNo;

    /**
     * PCP订单号
     */
    @ApiModelProperty(name = "pcpNo", value = "PCP订单号")
    private String pcpNo;
    /**
     * EAS订单号
     */
    @ApiModelProperty(name = "easNo", value = "EAS订单号")
    private String easNo;
    /**
     * 承运商代码
     */
    @ApiModelProperty(name = "carrierCode", value = "承运商代码")
    private String carrierCode;
    /**
     * 承运商名称
     */
    @ApiModelProperty(name = "carrierName", value = "承运商名称")
    private String carrierName;
    /**
     * 承运商单号
     */
    @ApiModelProperty(name = "carrierNo", value = "承运商单号")
    private String carrierNo;

    @ApiModelProperty(name = "carrierType", value = "承运方式")
    private String carrierType;
    /**
     * 托运单号
     */
    @ApiModelProperty(name = "consignmentNo", value = "托运单号")
    private String consignmentNo;

    /**
     * OCS运单号
     */
    @ApiModelProperty(name = "ocsConsignmentNo", value = "OCS运单号")
    private String ocsConsignmentNo;

    /**
     * OCS运单号
     */
    @ApiModelProperty(name = "secondaryConsignmentNo", value = "副托运单号")
    private String secondaryConsignmentNo;
    /**
     * 状态 0:提交，1：捡货，2：发货，3：在途，4.签收
     */
    @ApiModelProperty(name = "status", value = "状态 0:提交，1：捡货，2：发货，3：在途，4.签收")
    private String status;
    /**
     *
     */
    @ApiModelProperty(name = "orgName", value = "")
    private String orgName;
    /**
     * 捡货时间
     */
    @ApiModelProperty(name = "deliveStartTime", value = "捡货时间")
    private Date deliveStartTime;
    /**
     * 发货时间
     */
    @ApiModelProperty(name = "shipTime", value = "发货时间")
    private Date shipTime;
    /**
     * 预计到达时间
     */
    @ApiModelProperty(name = "expectedArrivalTime", value = "预计到达时间")
    private Date expectedArrivalTime;
    /**
     * 实际到达时间
     */
    @ApiModelProperty(name = "actualArrivalTime", value = "实际到达时间")
    private Date actualArrivalTime;
    /**
     * 货损数量
     */
    @ApiModelProperty(name = "cargoDamageNum", value = "货损数量")
    private Integer cargoDamageNum;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 操作时间
     */
    @ApiModelProperty(name = "operTime", value = "操作时间")
    private Date operTime;
    /**
     * 操作地点
     */
    @ApiModelProperty(name = "operAddr", value = "操作地点")
    private String operAddr;
    /**
     * 操作人
     */
    @ApiModelProperty(name = "operPerson", value = "操作人")
    private String operPerson;
    /**
     * 操作详情
     */
    @ApiModelProperty(name = "operInfo", value = "操作详情")
    private String operInfo;
    /**
     * 回单图片地址,如果有多张图，可以用逗号分隔
     */
    @ApiModelProperty(name = "pictureUrl", value = "回单图片地址,如果有多张图，可以用逗号分隔")
    private String pictureUrl;
    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private String totalCartons;
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private String mergeQuantity;
    @ApiModelProperty(name = "warehouseName", value = "发货仓")
    private String warehouseName;
    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;

    /**
     *  车牌号
     */
    @ApiModelProperty(name = "carLicenseNo", value = "车牌号")
    private String carLicenseNo;
    /**
     *  司机名称
     */
    @ApiModelProperty(name = "driverName", value = "司机名称")
    private String driverName;
    /**
     *  司机电话
     */
    @ApiModelProperty(name = "driverPhone", value = "司机电话")
    private String driverPhone;

}
