package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author jack
 * @version 1.0
 * @date 02/09/2022 19:17
 **/
@Getter
@Setter
@ApiModel(value = "InventoryCheckEasReqDto", description = "库存校验对象")
public class InventoryCheckEasReqDto extends InventoryCheckReqDto{

    @ApiModelProperty(name = "type", value = "业务类型")
    private Type type;


    public enum Type {
        /**
         *
         */
        BB(1, "bb调拨"),
        BC(2, "bc调拨"),
        CB(3, "cb调拨"),
        INTERNAL_DEAL(4,"内部交易"),
        INTERNAL_DEAL_RETURN(5,"内部交易退"),
        INTERNAL_DEAL_RETURN_TRANSFORM(6,"销售退转内部交易"),
        ;
        private final Integer type;
        private final String desc;

        Type(Integer type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public Integer getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }
    }

}
