/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.ChannelInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.ChannelInventoryRespDto;
import com.dtyunxi.tcbj.biz.service.IChannelInventoryService;
import com.dtyunxi.tcbj.dao.das.ChannelInventoryDas;
import com.dtyunxi.tcbj.dao.eo.ChannelInventoryEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelInventoryServiceImpl
implements IChannelInventoryService {
    @Resource
    private ChannelInventoryDas channelInventoryDas;

    @Override
    public Long addChannelInventory(ChannelInventoryReqDto addReqDto) {
        ChannelInventoryEo channelInventoryEo = new ChannelInventoryEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)channelInventoryEo);
        this.channelInventoryDas.insert((BaseEo)channelInventoryEo);
        return channelInventoryEo.getId();
    }

    @Override
    public void modifyChannelInventory(ChannelInventoryReqDto modifyReqDto) {
        ChannelInventoryEo channelInventoryEo = new ChannelInventoryEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)channelInventoryEo);
        this.channelInventoryDas.updateSelective((BaseEo)channelInventoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeChannelInventory(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.channelInventoryDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ChannelInventoryRespDto queryById(Long id) {
        ChannelInventoryEo channelInventoryEo = (ChannelInventoryEo)this.channelInventoryDas.selectByPrimaryKey(id);
        ChannelInventoryRespDto channelInventoryRespDto = new ChannelInventoryRespDto();
        DtoHelper.eo2Dto((BaseEo)channelInventoryEo, (BaseVo)channelInventoryRespDto);
        return channelInventoryRespDto;
    }

    @Override
    public PageInfo<ChannelInventoryRespDto> queryByPage(ChannelInventoryReqDto filter) {
        Page channelInventoryRespVos = this.channelInventoryDas.queryByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)channelInventoryRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List channelInventoryRespVoList = channelInventoryRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)channelInventoryRespVoList)) {
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)channelInventoryRespVoList, ChannelInventoryRespDto.class);
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }
}

