/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.ReceivablesImportReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReceivablesReqDto;
import com.dtyunxi.tcbj.api.dto.response.BalanceOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReceivablesImportDto;
import com.dtyunxi.tcbj.api.dto.response.ReceivablesImportRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReceivablesRespDto;
import com.dtyunxi.tcbj.biz.enums.OrderTradeStatusEnum;
import com.dtyunxi.tcbj.biz.enums.PayStatusEnum;
import com.dtyunxi.tcbj.biz.service.IReceivablesService;
import com.dtyunxi.tcbj.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.dao.das.BalanceDas;
import com.dtyunxi.tcbj.dao.das.CreditRepayPlanDas;
import com.dtyunxi.tcbj.dao.das.CsCustomerDas;
import com.dtyunxi.tcbj.dao.das.OrderDas;
import com.dtyunxi.tcbj.dao.das.RbOrderDas;
import com.dtyunxi.tcbj.dao.das.ReceivablesDas;
import com.dtyunxi.tcbj.dao.eo.BalanceEo;
import com.dtyunxi.tcbj.dao.eo.CreditRepayPlanEo;
import com.dtyunxi.tcbj.dao.eo.CsCustomerEo;
import com.dtyunxi.tcbj.dao.eo.OrderEo;
import com.dtyunxi.tcbj.dao.eo.ReceivablesEo;
import com.dtyunxi.tcbj.dao.mapper.ReceivablesMapper;
import com.dtyunxi.tcbj.dao.vo.OrderCountAmountVo;
import com.dtyunxi.tcbj.dao.vo.OrderQueryVo;
import com.dtyunxi.tcbj.dao.vo.RbOrderVo;
import com.dtyunxi.tcbj.dao.vo.ReceivablesVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ReceivablesServiceImpl
implements IReceivablesService {
    private static Logger logger = LoggerFactory.getLogger(ReceivablesServiceImpl.class);
    private static Integer limitCount = 5000;
    @Resource
    private ReceivablesDas receivablesDas;
    @Resource
    private CsCustomerDas csCustomerDas;
    @Resource
    private CreditRepayPlanDas creditRepayPlanDas;
    @Resource
    private OrderDas orderDas;
    @Resource
    private RbOrderDas rbOrderDas;
    @Resource
    private BalanceDas balanceDas;
    @Resource
    private ReceivablesMapper receivablesMapper;
    @Resource
    private HttpServletRequest request;
    private final ExecutorService executorService = new ThreadPoolExecutor(3, 3, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(3, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public PageInfo<ReceivablesRespDto> page(ReceivablesReqDto reqDto) {
        Assert.notNull((Object)reqDto.getStartDay(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String startDay = format.format(reqDto.getStartDay());
        String endDay = format.format(reqDto.getEndDay());
        CsCustomerEo customerEo = new CsCustomerEo();
        customerEo.setType(Integer.valueOf(3));
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerName())) {
            customerEo.setName(reqDto.getCustomerName());
        }
        String orgInfoId = null;
        if (ObjectUtils.isEmpty((Object)reqDto.getOrgInfoId())) {
            orgInfoId = this.getHeaderOrgId();
            logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgInfoId);
        } else {
            orgInfoId = String.valueOf(reqDto.getOrgInfoId());
        }
        customerEo.setMerchantId(StringUtils.isBlank((CharSequence)orgInfoId) ? null : Long.valueOf(Long.parseLong(orgInfoId)));
        PageInfo customerEoPageInfo = this.csCustomerDas.selectPage((BaseEo)customerEo, reqDto.getPageNum(), reqDto.getPageSize());
        if (CollectionUtils.isEmpty((Collection)customerEoPageInfo.getList())) {
            logger.info("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f");
            return null;
        }
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)customerEoPageInfo, (Object)result, (String[])new String[]{"list"});
        List customerIds = customerEoPageInfo.getList().stream().map(BaseEo::getId).collect(Collectors.toList());
        ReceivablesEo eo = (ReceivablesEo)SqlFilterBuilder.create(ReceivablesEo.class).ge("day", (Object)startDay).le("day", (Object)endDay).in("customerId", customerIds).eo();
        List receivablesEoList = this.receivablesDas.select((BaseEo)eo);
        if (CollectionUtil.isEmpty((Collection)receivablesEoList)) {
            return null;
        }
        Map<Long, BigDecimal> terminalTotalAmount = receivablesEoList.stream().filter(o -> o.getTerminalTotalAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getTerminalTotalAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> deliveryAmount = receivablesEoList.stream().filter(o -> o.getDeliveryAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getDeliveryAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> payAmount = receivablesEoList.stream().filter(o -> o.getPayAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getPayAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> discountAmount = receivablesEoList.stream().filter(o -> o.getDiscountAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getDiscountAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> totalRebateAmount = receivablesEoList.stream().filter(o -> o.getTotalRebateAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getTotalRebateAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Calendar cal = Calendar.getInstance();
        String beginningDay = null;
        try {
            cal.setTime(format.parse(startDay));
            cal.add(5, -1);
            beginningDay = format.format(cal.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ReceivablesEo beginningEo = (ReceivablesEo)SqlFilterBuilder.create(ReceivablesEo.class).eq("day", beginningDay).in("customerId", customerIds).eo();
        List beginningResult = this.receivablesDas.select((BaseEo)beginningEo);
        Map<Long, BigDecimal> beginningTotalAmount = beginningResult.stream().filter(o -> o.getTerminalTotalAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getTerminalTotalAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        ArrayList receivablesRespDtos = Lists.newArrayList();
        for (CsCustomerEo temp : customerEoPageInfo.getList()) {
            ReceivablesRespDto dto = new ReceivablesRespDto();
            dto.setCustomerId(temp.getId());
            dto.setCustomerCode(temp.getCode());
            dto.setCustomerName(temp.getName());
            dto.setOrgInfoId(temp.getOrgInfoId());
            dto.setStartDay(startDay);
            dto.setEndDay(endDay);
            if (beginningTotalAmount.containsKey(temp.getId())) {
                dto.setBeginningTotalAmount(beginningTotalAmount.get(temp.getId()));
            }
            if (terminalTotalAmount.containsKey(temp.getId())) {
                dto.setTerminalTotalAmount(terminalTotalAmount.get(temp.getId()));
            }
            if (deliveryAmount.containsKey(temp.getId())) {
                dto.setDeliveryAmount(deliveryAmount.get(temp.getId()));
            }
            if (payAmount.containsKey(temp.getId())) {
                dto.setPayAmount(payAmount.get(temp.getId()));
            }
            if (discountAmount.containsKey(temp.getId())) {
                dto.setDiscountAmount(discountAmount.get(temp.getId()));
            }
            if (totalRebateAmount.containsKey(temp.getId())) {
                dto.setTotalRebateAmount(totalRebateAmount.get(temp.getId()));
            }
            receivablesRespDtos.add(dto);
        }
        result.setList((List)receivablesRespDtos);
        return result;
    }

    @Override
    public ReceivablesRespDto detail(ReceivablesReqDto reqDto) {
        Assert.notNull((Object)reqDto.getStartDay(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqDto.getCustomerId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String startDay = format.format(reqDto.getStartDay());
        String endDay = format.format(reqDto.getEndDay());
        CsCustomerEo customerEo = (CsCustomerEo)this.csCustomerDas.selectOne(SqlFilterBuilder.create(CsCustomerEo.class).eq("id", (Object)reqDto.getCustomerId()).eo());
        List receivablesEoList = this.receivablesDas.select(SqlFilterBuilder.create(ReceivablesEo.class).ge("day", (Object)startDay).le("day", (Object)endDay).eq("customerId", (Object)reqDto.getCustomerId()).eo());
        Map<Object, Object> terminalTotalAmount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> deliveryAmount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> payAmount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> discountAmount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> totalRebateAmount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> giftDeductionAmount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> balanceMap = new HashMap<Long, BigDecimal>();
        Map<Object, Object> recordedDiscount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> remainingDiscount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> unreviewedOrderAmount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> waitDeliverAmount = new HashMap<Long, BigDecimal>();
        Map<Object, Object> outstandingAmount = new HashMap<Long, BigDecimal>();
        if (CollectionUtil.isNotEmpty((Collection)receivablesEoList)) {
            terminalTotalAmount = receivablesEoList.stream().filter(o -> o.getTerminalTotalAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getTerminalTotalAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            deliveryAmount = receivablesEoList.stream().filter(o -> o.getDeliveryAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getDeliveryAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            payAmount = receivablesEoList.stream().filter(o -> o.getPayAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getPayAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            discountAmount = receivablesEoList.stream().filter(o -> o.getDiscountAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getDiscountAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            totalRebateAmount = receivablesEoList.stream().filter(o -> o.getTotalRebateAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getTotalRebateAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            giftDeductionAmount = receivablesEoList.stream().filter(o -> o.getGiftDeductionAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getGiftDeductionAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            balanceMap = receivablesEoList.stream().filter(o -> o.getBalance() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getBalance, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            recordedDiscount = receivablesEoList.stream().filter(o -> o.getRecordedDiscount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getRecordedDiscount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            remainingDiscount = receivablesEoList.stream().filter(o -> o.getRemainingDiscount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getRemainingDiscount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            unreviewedOrderAmount = receivablesEoList.stream().filter(o -> o.getUnreviewedOrderAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getUnreviewedOrderAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            waitDeliverAmount = receivablesEoList.stream().filter(o -> o.getWaitDeliverAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getWaitDeliverAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            outstandingAmount = receivablesEoList.stream().filter(o -> o.getOutstandingAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getOutstandingAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        } else {
            terminalTotalAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            deliveryAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            payAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            discountAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            totalRebateAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            giftDeductionAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            balanceMap.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            recordedDiscount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            remainingDiscount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            unreviewedOrderAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            waitDeliverAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
            outstandingAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
        }
        Calendar cal = Calendar.getInstance();
        String beginningDay = null;
        try {
            cal.setTime(format.parse(startDay));
            cal.add(5, -1);
            beginningDay = format.format(cal.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List beginningResult = this.receivablesDas.select(SqlFilterBuilder.create(ReceivablesEo.class).eq("day", beginningDay).eq("customerId", (Object)reqDto.getCustomerId()).eo());
        Map<Object, Object> beginningTotalAmount = new HashMap<Long, BigDecimal>();
        if (CollectionUtil.isNotEmpty((Collection)beginningResult)) {
            beginningTotalAmount = beginningResult.stream().filter(o -> o.getTerminalTotalAmount() != null).collect(Collectors.groupingBy(ReceivablesEo::getCustomerId, Collectors.mapping(ReceivablesEo::getTerminalTotalAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        } else {
            beginningTotalAmount.put(reqDto.getCustomerId(), BigDecimal.ZERO);
        }
        ReceivablesRespDto result = new ReceivablesRespDto();
        result.setOrgInfoId(customerEo.getOrgInfoId());
        result.setStartDay(startDay);
        result.setEndDay(endDay);
        result.setCustomerName(customerEo.getName());
        result.setCustomerCode(customerEo.getCode());
        result.setCustomerId(customerEo.getId());
        result.setRemainingDiscount((BigDecimal)remainingDiscount.get(reqDto.getCustomerId()));
        result.setDiscountAmount((BigDecimal)discountAmount.get(reqDto.getCustomerId()));
        result.setPayAmount((BigDecimal)payAmount.get(reqDto.getCustomerId()));
        result.setTotalRebateAmount((BigDecimal)totalRebateAmount.get(reqDto.getCustomerId()));
        result.setDeliveryAmount((BigDecimal)deliveryAmount.get(reqDto.getCustomerId()));
        result.setTerminalTotalAmount((BigDecimal)terminalTotalAmount.get(reqDto.getCustomerId()));
        result.setBeginningTotalAmount((BigDecimal)beginningTotalAmount.get(reqDto.getCustomerId()));
        result.setBalance((BigDecimal)balanceMap.get(reqDto.getCustomerId()));
        result.setGiftDeductionAmount((BigDecimal)giftDeductionAmount.get(reqDto.getCustomerId()));
        result.setOutstandingAmount((BigDecimal)outstandingAmount.get(reqDto.getCustomerId()));
        result.setRecordedDiscount((BigDecimal)recordedDiscount.get(reqDto.getCustomerId()));
        result.setWaitDeliverAmount((BigDecimal)waitDeliverAmount.get(reqDto.getCustomerId()));
        result.setUnreviewedOrderAmount((BigDecimal)unreviewedOrderAmount.get(reqDto.getCustomerId()));
        return result;
    }

    @Override
    public PageInfo<BalanceOrderRespDto> balanceOrder(ReceivablesReqDto reqDto) {
        Assert.notNull((Object)reqDto.getCustomerId(), (String)"\u5ba2\u6237id\u4e3a\u7a7a");
        ArrayList status = Lists.newArrayList((Object[])new Long[]{1L, 2L});
        List creditRepayPlanEos = this.creditRepayPlanDas.select(SqlFilterBuilder.create(CreditRepayPlanEo.class).eq("customerId", (Object)reqDto.getCustomerId()).in("creditRepayPlanStatus", (Object)StringUtils.join((Iterable)status, (String)",")).eo());
        if (CollectionUtil.isEmpty((Collection)creditRepayPlanEos)) {
            return null;
        }
        Map creditRepayPlanEoMap = creditRepayPlanEos.stream().collect(Collectors.toMap(CreditRepayPlanEo::getFormCode, Function.identity(), (v1, v2) -> v1));
        List orderNos = creditRepayPlanEos.stream().map(CreditRepayPlanEo::getFormCode).collect(Collectors.toList());
        PageInfo orderEoPageInfo = this.orderDas.selectPage(SqlFilterBuilder.create(OrderEo.class).in("orderNo", orderNos).eo(), reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)orderEoPageInfo, (Object)pageInfo, (String[])new String[]{"list"});
        ArrayList balanceOrderRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)orderEoPageInfo.getList(), (Collection)balanceOrderRespDtos, BalanceOrderRespDto.class);
        for (BalanceOrderRespDto dto : balanceOrderRespDtos) {
            if (creditRepayPlanEoMap.containsKey(dto.getOrderNo())) {
                dto.setReceivedAmount(((CreditRepayPlanEo)creditRepayPlanEoMap.get(dto.getOrderNo())).getReceivedAmount());
            }
            dto.setOrderTradeStatus(OrderTradeStatusEnum.toName(dto.getOrderTradeStatus()));
            dto.setPayStatus(PayStatusEnum.toName(dto.getPayStatus()));
        }
        pageInfo.setList((List)balanceOrderRespDtos);
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveReceivablesJob(List<Long> customerIdList) {
        int total;
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u751f\u6210\u5e94\u6536\u8d26\u6b3e");
        CsCustomerEo csCustomerEo = new CsCustomerEo();
        csCustomerEo.setType(Integer.valueOf(3));
        if (CollectionUtils.isNotEmpty(customerIdList)) {
            SqlFilterBuilder sqlFilterBuilders = new SqlFilterBuilder();
            sqlFilterBuilders.in("id", (Object)StringUtils.join(customerIdList, (String)","));
            csCustomerEo.setSqlFilters(sqlFilterBuilders.filters());
        }
        if ((total = this.csCustomerDas.count((BaseEo)csCustomerEo)) <= 0) {
            logger.info("\u5e94\u6536\u8d26\u6b3e\u7edf\u8ba1\u8c03\u5ea6,\u672a\u67e5\u8be2\u5230customerId");
            return;
        }
        Stream.iterate(1, n -> n + 1).limit(this.getCount(total).intValue()).forEach(i -> {
            PageInfo limtCustomerList = this.csCustomerDas.selectPage((BaseEo)csCustomerEo, i, Integer.valueOf(5000));
            this.executorService.execute(() -> {
                try {
                    logger.info("\u5e94\u6536\u8d26\u6b3e\u7edf\u8ba1\u66f4\u65b0");
                    this.addReceivablesBatch(limtCustomerList.getList());
                }
                catch (Exception e) {
                    logger.error("\u66f4\u65b0\u5e94\u6536\u8d26\u6b3e\u7edf\u8ba1\u5931\u8d25", (Throwable)e);
                    e.printStackTrace();
                }
            });
        });
    }

    private Integer getCount(Integer size) {
        return (limitCount + size - 1) / limitCount;
    }

    private void addReceivablesBatch(List<CsCustomerEo> customerEoList) {
        List balanceEoList;
        List rbOrderVos;
        List customerIds = customerEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String day = format.format(new Date());
        Map<Object, Object> receivablesVoMap = new HashMap();
        Map<Object, Object> rbOrderVoMap = new HashMap();
        Map<Object, Object> balanceEoMap = new HashMap();
        Map<Object, Object> unreviewedOrderMap = new HashMap();
        Map<Object, Object> waitDeliveryOrderMap = new HashMap();
        List receivablesVos = this.orderDas.selectTerminalAmountByDay(customerIds, day);
        logger.info("\u67e5\u8be2\u7edf\u8ba1\u8ba2\u5355\u5927\u5c0f={}", (Object)receivablesVos.size());
        if (CollectionUtils.isNotEmpty((Collection)receivablesVos)) {
            receivablesVoMap = receivablesVos.stream().collect(Collectors.toMap(ReceivablesVo::getCustomerId, Function.identity(), (v1, v2) -> v1));
        }
        if (CollectionUtils.isNotEmpty((Collection)(rbOrderVos = this.rbOrderDas.selectRbOrderVoByDay(customerIds, day)))) {
            rbOrderVoMap = rbOrderVos.stream().collect(Collectors.toMap(RbOrderVo::getCustomerId, Function.identity(), (v1, v2) -> v1));
        }
        if (CollectionUtils.isNotEmpty((Collection)(balanceEoList = this.balanceDas.select(SqlFilterBuilder.create(BalanceEo.class).in("userId", (Object)StringUtils.join(customerIds, (String)",")).eq("userType", (Object)"CUSTOMER").eo())))) {
            balanceEoMap = balanceEoList.stream().collect(Collectors.toMap(BalanceEo::getUserId, Function.identity(), (v1, v2) -> v1));
        }
        ArrayList waitAuditStatus = Lists.newArrayList((Object[])new String[]{"WAIT_CS_AUDIT", "WAIT_FINANCE_AUDIT"});
        OrderQueryVo orderQueryVo = new OrderQueryVo();
        orderQueryVo.setToDay(day);
        orderQueryVo.setStatusList((List)waitAuditStatus);
        List unreviewedOrderAmounts = this.orderDas.selectOrderAmountByStatus(orderQueryVo);
        if (CollectionUtils.isNotEmpty((Collection)unreviewedOrderAmounts)) {
            unreviewedOrderMap = unreviewedOrderAmounts.stream().collect(Collectors.toMap(OrderCountAmountVo::getCustomerId, OrderCountAmountVo::getSumTotalAmount, (k1, k2) -> k1));
        }
        orderQueryVo.setStatusList((List)Lists.newArrayList((Object[])new String[]{"WAIT_DELIVERY"}));
        List waitDeliveryOrderAmounts = this.orderDas.selectOrderAmountByStatus(orderQueryVo);
        if (CollectionUtils.isNotEmpty((Collection)waitDeliveryOrderAmounts)) {
            waitDeliveryOrderMap = waitDeliveryOrderAmounts.stream().collect(Collectors.toMap(OrderCountAmountVo::getCustomerId, OrderCountAmountVo::getSumTotalAmount, (k1, k2) -> k1));
        }
        ArrayList receivablesEos = Lists.newArrayList();
        for (CsCustomerEo eo : customerEoList) {
            ReceivablesEo receivablesEo = new ReceivablesEo();
            receivablesEo.setCustomerId(eo.getId());
            receivablesEo.setCustomerCode(eo.getCode());
            receivablesEo.setCustomerName(eo.getName());
            receivablesEo.setOrgInfoId(eo.getMerchantId());
            receivablesEo.setDay(day);
            if (receivablesVoMap.containsKey(eo.getId())) {
                receivablesEo.setTerminalTotalAmount(((ReceivablesVo)receivablesVoMap.get(eo.getId())).getTerminalTotalAmount());
                receivablesEo.setDeliveryAmount(((ReceivablesVo)receivablesVoMap.get(eo.getId())).getDeliveryAmount());
                receivablesEo.setPayAmount(((ReceivablesVo)receivablesVoMap.get(eo.getId())).getPayAmount());
                receivablesEo.setDiscountAmount(((ReceivablesVo)receivablesVoMap.get(eo.getId())).getDiscountAmount());
                receivablesEo.setTotalRebateAmount(((ReceivablesVo)receivablesVoMap.get(eo.getId())).getTotalRebateAmount());
                receivablesEo.setGiftDeductionAmount(((ReceivablesVo)receivablesVoMap.get(eo.getId())).getGiftDeductionAmount());
                receivablesEo.setBalance(((ReceivablesVo)receivablesVoMap.get(eo.getId())).getBalance());
            } else {
                receivablesEo.setTerminalTotalAmount(BigDecimal.ZERO);
                receivablesEo.setDeliveryAmount(BigDecimal.ZERO);
                receivablesEo.setPayAmount(BigDecimal.ZERO);
                receivablesEo.setDiscountAmount(BigDecimal.ZERO);
                receivablesEo.setTotalRebateAmount(BigDecimal.ZERO);
                receivablesEo.setGiftDeductionAmount(BigDecimal.ZERO);
                receivablesEo.setBalance(BigDecimal.ZERO);
            }
            if (rbOrderVoMap.containsKey(eo.getId())) {
                receivablesEo.setRecordedDiscount(((RbOrderVo)rbOrderVoMap.get(eo.getId())).getRecordedDiscount());
            } else {
                receivablesEo.setRecordedDiscount(BigDecimal.ZERO);
            }
            if (balanceEoMap.containsKey(eo.getId())) {
                receivablesEo.setRemainingDiscount(((BalanceEo)balanceEoMap.get(eo.getId())).getBalance());
            } else {
                receivablesEo.setRemainingDiscount(BigDecimal.ZERO);
            }
            if (unreviewedOrderMap.containsKey(eo.getId().toString())) {
                receivablesEo.setUnreviewedOrderAmount((BigDecimal)unreviewedOrderMap.get(eo.getId().toString()));
            } else {
                receivablesEo.setUnreviewedOrderAmount(BigDecimal.ZERO);
            }
            if (waitDeliveryOrderMap.containsKey(eo.getId().toString())) {
                receivablesEo.setWaitDeliverAmount((BigDecimal)waitDeliveryOrderMap.get(eo.getId().toString()));
            } else {
                receivablesEo.setWaitDeliverAmount(BigDecimal.ZERO);
            }
            BigDecimal terminalTotalAmount = receivablesEo.getTerminalTotalAmount() == null ? BigDecimal.ZERO : receivablesEo.getTerminalTotalAmount();
            BigDecimal unreviewedOrderAmount = receivablesEo.getUnreviewedOrderAmount() == null ? BigDecimal.ZERO : receivablesEo.getUnreviewedOrderAmount();
            BigDecimal waitDeliverAmount = receivablesEo.getWaitDeliverAmount() == null ? BigDecimal.ZERO : receivablesEo.getWaitDeliverAmount();
            BigDecimal remainingDiscount = receivablesEo.getRemainingDiscount() == null ? BigDecimal.ZERO : receivablesEo.getRemainingDiscount();
            receivablesEo.setOutstandingAmount(terminalTotalAmount.add(unreviewedOrderAmount).add(waitDeliverAmount).add(remainingDiscount));
            receivablesEos.add(receivablesEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)receivablesEos)) {
            if (receivablesEos.size() > 1000) {
                List partitionList = Lists.partition((List)receivablesEos, (int)1000);
                partitionList.forEach(list -> this.receivablesDas.insertBatch(list));
            } else {
                this.receivablesDas.insertBatch((List)receivablesEos);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ReceivablesImportRespDto receivablesImport(ReceivablesImportReqDto importReqDto) {
        List list;
        logger.info("\u5bfc\u5165\u5e94\u6536\u8d26\u6b3e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        ReceivablesImportRespDto resultDto = new ReceivablesImportRespDto();
        List importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, ReceivablesImportDto.class);
            importDtos = objectExcelImportResult.getList();
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5e94\u6536\u8d26\u6b3e\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        if (CollectionUtils.isEmpty((Collection)importDtos)) {
            throw new BizException("\u5bfc\u5165\u7684\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\u540e\u91cd\u65b0\u5bfc\u5165");
        }
        resultDto.setTotalSize(importDtos.size());
        List<String> customerCodeList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode())).map(ReceivablesImportDto::getCustomerCode).distinct().collect(Collectors.toList());
        Map<String, CustomerRespDto> customerDtoMap = this.getOrgCustomerMap(customerCodeList);
        HashSet<String> distinctSet = new HashSet<String>();
        for (Object importDto : importDtos) {
            if (StringUtils.isEmpty((CharSequence)importDto.getCustomerName())) {
                importDto.setErrorReason("\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a;");
                throw new BizException("\u5b58\u5728\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a\u6570\u636e,\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getCustomerCode())) {
                importDto.setErrorReason("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a;");
                throw new BizException("\u5b58\u5728\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\u6570\u636e,\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            if (customerDtoMap.isEmpty() || !customerDtoMap.containsKey(importDto.getCustomerCode())) {
                importDto.setErrorReason("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728;");
                throw new BizException("\u5ba2\u6237[" + importDto.getCustomerCode() + "]\u4fe1\u606f\u7cfb\u7edf\u672a\u627e\u5230,\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getDateStr())) {
                importDto.setErrorReason("\u65e5\u671f\u4e3a\u7a7a;");
                throw new BizException("\u5b58\u5728\u65e5\u671f\u4e3a\u7a7a\u6570\u636e,\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            if (Objects.isNull(importDto.getBeginningTotalAmount())) {
                importDto.setErrorReason("\u671f\u521d\u5e94\u6536\u4e3a\u7a7a;");
                throw new BizException("\u5b58\u5728\u671f\u521d\u5e94\u6536\u4e3a\u7a7a\u6570\u636e,\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            if (Objects.isNull(importDto.getTerminalTotalAmount())) {
                importDto.setErrorReason("\u671f\u672b\u5e94\u6536\u4e3a\u7a7a;");
                throw new BizException("\u5b58\u5728\u671f\u672b\u5e94\u6536\u4e3a\u7a7a\u6570\u636e,\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            String key = importDto.getCustomerCode() + "_" + importDto.getDateStr();
            if (distinctSet.contains(key)) {
                throw new BizException(key + "\u5b58\u5728\u91cd\u590d\u6570\u636e,\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            importDto.setOrgInfoId(customerDtoMap.get(importDto.getCustomerCode()).getMerchantId());
            importDto.setCustomerId(customerDtoMap.get(importDto.getCustomerCode()).getId());
            distinctSet.add(key);
            Date dateTime = DateUtil.parseDate((String)importDto.getDateStr(), (String)"yyyy-MM-dd");
            importDto.setDateTime(dateTime);
        }
        Map<String, List<ReceivablesImportDto>> customerGourpMap = importDtos.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.groupingBy(ReceivablesImportDto::getCustomerCode));
        for (String customerCode : customerGourpMap.keySet()) {
            List<Object> receivablesImportDtos = customerGourpMap.get(customerCode);
            receivablesImportDtos = receivablesImportDtos.stream().sorted(Comparator.comparing(ReceivablesImportDto::getDateTime)).collect(Collectors.toList());
            HashMap<Date, BigDecimal> beforeDayMap = new HashMap<Date, BigDecimal>();
            for (int i = 0; i < receivablesImportDtos.size(); ++i) {
                BigDecimal beginningTotalAmount;
                BigDecimal beforeAmount;
                beforeDayMap.put(((ReceivablesImportDto)receivablesImportDtos.get(i)).getDateTime(), ((ReceivablesImportDto)receivablesImportDtos.get(i)).getTerminalTotalAmount());
                Date dateTime = ((ReceivablesImportDto)receivablesImportDtos.get(i)).getDateTime();
                Date beforDay = DateUtil.addDays((Date)dateTime, (int)-1);
                if (i <= 0 || !beforeDayMap.containsKey(beforDay) || (beforeAmount = (BigDecimal)beforeDayMap.get(beforDay)).compareTo(beginningTotalAmount = ((ReceivablesImportDto)receivablesImportDtos.get(i)).getBeginningTotalAmount()) == 0) continue;
                String dateFormat = DateUtil.getDateFormat((Date)dateTime, (String)"yyyy-MM-dd");
                String beforDayStr = DateUtil.getDateFormat((Date)beforDay, (String)"yyyy-MM-dd");
                throw new BizException("\u5ba2\u6237[" + customerCode + "]:[" + dateFormat + "]\u671f\u521d\u4e0d\u7b49\u4e8e[" + beforDayStr + "]\u671f\u672b,\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u5bfc\u5165\u3002");
            }
        }
        List customerIdList = importDtos.stream().map(ReceivablesImportDto::getCustomerId).distinct().collect(Collectors.toList());
        List todayList = importDtos.stream().map(ReceivablesImportDto::getDateStr).distinct().collect(Collectors.toList());
        List receivablesEoList = this.receivablesDas.select(SqlFilterBuilder.create(ReceivablesEo.class).in("day", (Object)StringUtils.join(todayList, (String)",")).in("customer_id", (Object)StringUtils.join(customerIdList, (String)",")).eq("dr", (Object)0).eo());
        Map<Object, Object> receivablesEoMap = new HashMap(receivablesEoList.size() * 4 / 3 + 2);
        if (CollectionUtils.isNotEmpty((Collection)receivablesEoList)) {
            receivablesEoMap = receivablesEoList.stream().collect(Collectors.toMap(eo -> eo.getCustomerId() + "_" + eo.getDay(), Function.identity()));
        }
        ArrayList addEoList = Lists.newArrayList();
        ArrayList updateEoList = Lists.newArrayList();
        for (ReceivablesImportDto importDto : importDtos) {
            String key = importDto.getCustomerId() + "_" + importDto.getDateStr();
            if (receivablesEoMap.isEmpty() || !receivablesEoMap.containsKey(key)) {
                ReceivablesEo addEo = ReceivablesEo.newInstance();
                addEo.setCustomerId(importDto.getCustomerId());
                addEo.setCustomerCode(importDto.getCustomerCode());
                addEo.setCustomerName(importDto.getCustomerName());
                addEo.setOrgInfoId(importDto.getOrgInfoId());
                addEo.setDay(importDto.getDateStr());
                addEo.setTerminalTotalAmount(importDto.getTerminalTotalAmount());
                addEoList.add(addEo);
                continue;
            }
            ReceivablesEo receivablesEo = (ReceivablesEo)receivablesEoMap.get(key);
            if (YesNoEnum.YES.getValue().equals(importReqDto.getCoverStatus())) {
                receivablesEo.setTerminalTotalAmount(importDto.getTerminalTotalAmount());
                receivablesEo.setUpdateTime(new Date());
                updateEoList.add(receivablesEo);
                continue;
            }
            importDto.setErrorReason("\u5ba2\u6237\u65e5\u671f\u5df2\u5b58\u5728;");
        }
        Integer successNum = addEoList.size() + updateEoList.size();
        logger.info("\u5bfc\u5165\u5e94\u6536\u8d26\u6b3e\u65b0\u589e\u6570\u636e\u5927\u5c0f:{}", (Object)addEoList.size());
        if (CollectionUtils.isNotEmpty((Collection)addEoList)) {
            this.receivablesDas.insertBatch((List)addEoList);
        }
        logger.info("\u5bfc\u5165\u5e94\u6536\u8d26\u6b3e\u66f4\u65b0\u6570\u636e\u5927\u5c0f:{}", (Object)updateEoList.size());
        if (CollectionUtils.isNotEmpty((Collection)updateEoList)) {
            this.receivablesMapper.updateBatch((List)updateEoList);
        }
        if (CollectionUtils.isNotEmpty(list = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList()))) {
            String title = "\u5bfc\u5165\u5ba2\u6237\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + System.currentTimeMillis();
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(list, ReceivablesImportDto.class, title, fileName, "xlsx");
                resultDto.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        resultDto.setSuccessSize(successNum.intValue());
        resultDto.setFailSize(resultDto.getTotalSize() - successNum);
        return resultDto;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private Map<String, CustomerRespDto> getOrgCustomerMap(List<String> dealerCodeList) {
        if (CollectionUtils.isEmpty(dealerCodeList)) {
            return new HashMap<String, CustomerRespDto>();
        }
        ArrayList customerList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)customerList)) {
            return new HashMap<String, CustomerRespDto>();
        }
        Map<String, CustomerRespDto> customerMap = customerList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        return customerMap;
    }
}

