/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.request.MaterialReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrderOccupyItemReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrderOccupyItemRespDto;
import com.dtyunxi.tcbj.biz.service.query.IOrderItemReportService;
import com.dtyunxi.tcbj.dao.das.CsCustomerDas;
import com.dtyunxi.tcbj.dao.das.InCargoOccupyDas;
import com.dtyunxi.tcbj.dao.das.OrderDas;
import com.dtyunxi.tcbj.dao.das.OrganizationDas;
import com.dtyunxi.tcbj.dao.das.TradeItemDas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class IOrderItemReportServiceImpl
implements IOrderItemReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private OrderDas orderDas;
    @Resource
    private CsCustomerDas customerDas;
    @Resource
    private InCargoOccupyDas cargoOccupyDas;
    @Resource
    private OrganizationDas organizationDas;

    @Override
    public List<OrderOccupyItemRespDto> queryOrderInfoByCargoCode(OrderOccupyItemReqDto reqDto) {
        this.logger.info("\u3010\u8ba2\u5355\u4ea7\u54c1\u660e\u7ec6\u5e93\u5b58\u4f7f\u7528\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        Assert.notNull((Object)reqDto.getTenantId(), (String)"\u7ec4\u7ec7id(tenantId)\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notEmpty((Collection)reqDto.getMaterialList(), (String)"materialList\u4e0d\u80fd\u4e3a\u7a7a!");
        List codeList = reqDto.getMaterialList().stream().map(MaterialReqDto::getMaterialNo).collect(Collectors.toList());
        List tradeList = this.cargoOccupyDas.selectTradeList(codeList, reqDto.getTenantId());
        if (CollectionUtils.isEmpty((Collection)tradeList)) {
            return new ArrayList<OrderOccupyItemRespDto>();
        }
        Map customerMap = tradeList.stream().collect(Collectors.toMap(OrderOccupyItemRespDto::getOrderNo, Function.identity(), (key1, key2) -> key2));
        List orders = tradeList.stream().map(OrderOccupyItemRespDto::getOrderNo).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        this.logger.info("\u3010cargoOccupyDas.selectInventoryPreemption\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1aorders={}, codeList={}, reqDto.getDepotNo()={}, ", new Object[]{JSON.toJSONString(orders), JSON.toJSONString(codeList), JSON.toJSONString((Object)reqDto.getDepotNo())});
        List orderOccupyItemRespList = this.cargoOccupyDas.selectInventoryPreemption(orders, codeList, reqDto.getDepotNo());
        this.logger.info("\u3010cargoOccupyDas.selectInventoryPreemption\u3011\u54cd\u5e94\u53c2\u6570\u4e3a\uff1aorderOccupyItemRespList={}", (Object)JSON.toJSONString((Object)orderOccupyItemRespList));
        if (CollectionUtils.isNotEmpty((Collection)orderOccupyItemRespList)) {
            orderOccupyItemRespList.forEach(dto -> {
                OrderOccupyItemRespDto orderOccupyItemRespDto = (OrderOccupyItemRespDto)customerMap.get(dto.getOrderNo());
                dto.setParName(orderOccupyItemRespDto.getParName());
                dto.setOrgName(orderOccupyItemRespDto.getOrgName());
            });
        }
        this.logger.info("\u3010\u8ba2\u5355\u4ea7\u54c1\u660e\u7ec6\u5e93\u5b58\u4f7f\u7528\u3011\u54cd\u5e94\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)orderOccupyItemRespList));
        return orderOccupyItemRespList;
    }
}

