/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.EmployeeStatusEnum;
import com.dtyunxi.tcbj.api.dto.request.CustomerQueryByUserIdReqDto;
import com.dtyunxi.tcbj.api.dto.request.PCPCustomerSalesmanReqDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerIdsRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerSalesmanRespDto;
import com.dtyunxi.tcbj.biz.config.ApiNoticeConfig;
import com.dtyunxi.tcbj.biz.service.ICustomerSalesmanService;
import com.dtyunxi.tcbj.biz.utils.DingdingSender;
import com.dtyunxi.tcbj.dao.das.CustomerSalesmanDas;
import com.dtyunxi.tcbj.dao.eo.CustomerSalesmanEo;
import com.dtyunxi.tcbj.dao.mapper.CustomerSalesmanMapper;
import com.dtyunxi.tcbj.dao.vo.CustomerBasicInfoVo;
import com.dtyunxi.tcbj.dao.vo.ExpireEmployeeRespVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerSalesmanApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.v3.ITokenApi;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerSalesmanServiceImpl
implements ICustomerSalesmanService {
    private static Logger logger = LoggerFactory.getLogger(CustomerSalesmanServiceImpl.class);
    public static final Long INSTANCE_ID = 1254039287584232622L;
    public static final Long TENANT_ID = 1L;
    @Resource
    private CustomerSalesmanDas customerSalesmanDas;
    @Resource
    private IEmployeeApi employeeApi;
    @Autowired
    private IOrganizationApi organizationApi;
    @Autowired
    private ICustomerSalesmanApi customerSalesmanApi;
    @Resource
    private ITokenApi tokenApi;
    @Resource
    private DingdingSender dingdingSender;
    @Resource
    private ApiNoticeConfig apiNoticeConfig;
    @Resource
    private CustomerSalesmanMapper customerSalesmanMapper;

    @Override
    public Long addCustomerSalesman(PCPCustomerSalesmanReqDto addReqDto) {
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerSalesmanEo);
        this.customerSalesmanDas.insert((BaseEo)customerSalesmanEo);
        return customerSalesmanEo.getId();
    }

    @Override
    public void modifyCustomerSalesman(PCPCustomerSalesmanReqDto modifyReqDto) {
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerSalesmanEo);
        this.customerSalesmanDas.updateSelective((BaseEo)customerSalesmanEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerSalesman(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerSalesmanDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PCPCustomerSalesmanRespDto queryById(Long id) {
        CustomerSalesmanEo customerSalesmanEo = (CustomerSalesmanEo)this.customerSalesmanDas.selectByPrimaryKey(id);
        PCPCustomerSalesmanRespDto PCPCustomerSalesmanRespDto2 = new PCPCustomerSalesmanRespDto();
        DtoHelper.eo2Dto((BaseEo)customerSalesmanEo, (BaseVo)PCPCustomerSalesmanRespDto2);
        return PCPCustomerSalesmanRespDto2;
    }

    @Override
    public PageInfo<PCPCustomerSalesmanRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PCPCustomerSalesmanReqDto PCPCustomerSalesmanReqDto2 = (PCPCustomerSalesmanReqDto)JSON.parseObject((String)filter, PCPCustomerSalesmanReqDto.class);
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        DtoHelper.dto2Eo((BaseVo)PCPCustomerSalesmanReqDto2, (BaseEo)customerSalesmanEo);
        PageInfo eoPageInfo = this.customerSalesmanDas.selectPage((BaseEo)customerSalesmanEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PCPCustomerSalesmanRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void employeeExpired(ExpireEmployeeRespVo employeeRespVo, String dateStr) {
        try {
            logger.info("\u5f00\u59cb\u7981\u7528\u8fc7\u671f\u5458\u5de5:{}", (Object)employeeRespVo);
            EmployeeModifyReqDto employeeModifyReqDto = new EmployeeModifyReqDto();
            employeeModifyReqDto.setId(employeeRespVo.getId());
            employeeModifyReqDto.setStatus(EmployeeStatusEnum.DISABLE.getCode());
            String remark = (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{employeeModifyReqDto.getRemark()}) ? employeeModifyReqDto.getRemark() : "") + "[" + dateStr + "\uff1a\u4eba\u5458\u8fc7\u671f\u5b9a\u65f6\u7981\u7528]";
            if (remark.length() > 128) {
                employeeModifyReqDto.setRemark(remark.substring(remark.length() - 128));
            } else {
                employeeModifyReqDto.setRemark(remark);
            }
            employeeModifyReqDto.setInstanceId(INSTANCE_ID);
            employeeModifyReqDto.setTenantId(TENANT_ID);
            RestResponseHelper.extractData((RestResponse)this.employeeApi.modifyEmployee(employeeModifyReqDto));
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(employeeRespVo.getOrgInfoId());
            UserOrgRelationReqDto userOrgRelationReqDto = new UserOrgRelationReqDto();
            userOrgRelationReqDto.setUserId(employeeRespVo.getUserId());
            userOrgRelationReqDto.setOrgIds(orgIds);
            userOrgRelationReqDto.setInstanceId(INSTANCE_ID);
            userOrgRelationReqDto.setTenantId(TENANT_ID);
            RestResponseHelper.extractData((RestResponse)this.organizationApi.deleteUserOrgRelation(userOrgRelationReqDto));
            CustomerSalesmanReqDto reqDto = new CustomerSalesmanReqDto();
            reqDto.setUserId(employeeRespVo.getUserId());
            reqDto.setOrgInfoId(employeeRespVo.getOrgInfoId());
            reqDto.setStatus(Integer.valueOf(0));
            this.customerSalesmanApi.updateStatus(reqDto);
            logger.info("\u6210\u529f\u7981\u7528\u8fc7\u671f\u7528\u6237:{}", (Object)employeeRespVo);
        }
        catch (Exception e) {
            String str = "\u7981\u7528\u8fc7\u671f\u4eba\u5458\u5f02\u5e38:" + JSON.toJSONString((Object)employeeRespVo) + ",\u5f02\u5e38\u4fe1\u606f\u4e3a:" + e.getMessage();
            logger.info(str);
            DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
            msgReqDto.setRemindPhones(this.apiNoticeConfig.getCommonList());
            msgReqDto.setRemindType(1);
            msgReqDto.setSendMessage(str);
            this.dingdingSender.sendMessage(msgReqDto);
            e.printStackTrace();
        }
        finally {
            this.tokenApi.deleteToken(String.valueOf(employeeRespVo.getUserId()));
        }
    }

    @Override
    public CustomerIdsRespDto queryCustomerIdsByUserId(Long userId) {
        List customerIds = this.customerSalesmanMapper.queryCustomerIdsByUserId(userId);
        CustomerIdsRespDto respDto = new CustomerIdsRespDto();
        ArrayList<CustomerIdsRespDto.CustomerBasicInfoDto> customers = new ArrayList<CustomerIdsRespDto.CustomerBasicInfoDto>();
        for (Long id : customerIds) {
            CustomerIdsRespDto.CustomerBasicInfoDto customer = new CustomerIdsRespDto.CustomerBasicInfoDto();
            customer.setId(id);
            customers.add(customer);
        }
        respDto.setCustomers(customers);
        return respDto;
    }

    @Override
    public CustomerIdsRespDto queryCustomersByUserId(CustomerQueryByUserIdReqDto reqDto) {
        List customerVos = this.customerSalesmanMapper.queryCustomersByUserId(reqDto.getUserId(), reqDto.getKeyword());
        CustomerIdsRespDto respDto = new CustomerIdsRespDto();
        ArrayList<CustomerIdsRespDto.CustomerBasicInfoDto> customers = new ArrayList<CustomerIdsRespDto.CustomerBasicInfoDto>();
        for (CustomerBasicInfoVo vo : customerVos) {
            CustomerIdsRespDto.CustomerBasicInfoDto customer = new CustomerIdsRespDto.CustomerBasicInfoDto();
            customer.setId(vo.getId());
            customer.setName(vo.getName());
            customers.add(customer);
        }
        respDto.setCustomers(customers);
        return respDto;
    }
}

