/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.dtyunxi.tcbj.api.dto.request.MaterialReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrderOccupyItemReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrderOccupyItemRespDto;
import com.dtyunxi.tcbj.biz.service.query.IOrderItemReportService;
import com.dtyunxi.tcbj.dao.das.CsCustomerDas;
import com.dtyunxi.tcbj.dao.das.InCargoOccupyDas;
import com.dtyunxi.tcbj.dao.das.OrderDas;
import com.dtyunxi.tcbj.dao.das.OrganizationDas;
import com.dtyunxi.tcbj.dao.das.TradeItemDas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class IOrderItemReportServiceImpl
implements IOrderItemReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private OrderDas orderDas;
    @Resource
    private CsCustomerDas customerDas;
    @Resource
    private InCargoOccupyDas cargoOccupyDas;
    @Resource
    private OrganizationDas organizationDas;

    @Override
    public List<OrderOccupyItemRespDto> queryOrderInfoByCargoCode(OrderOccupyItemReqDto reqDto) {
        Assert.notNull((Object)reqDto.getTenantId(), (String)"\u7ec4\u7ec7id(tenantId)\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notEmpty((Collection)reqDto.getMaterialList(), (String)"materialList\u4e0d\u80fd\u4e3a\u7a7a!");
        List codeList = reqDto.getMaterialList().stream().map(MaterialReqDto::getMaterialNo).collect(Collectors.toList());
        List tradeList = this.cargoOccupyDas.selectTradeList(codeList, reqDto.getTenantId());
        if (CollectionUtils.isEmpty((Collection)tradeList)) {
            return new ArrayList<OrderOccupyItemRespDto>();
        }
        Map customerMap = tradeList.stream().collect(Collectors.toMap(OrderOccupyItemRespDto::getOrderNo, Function.identity(), (key1, key2) -> key2));
        List orders = tradeList.stream().map(OrderOccupyItemRespDto::getOrderNo).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        List orderOccupyItemRespList = this.cargoOccupyDas.selectInventoryPreemption(orders, codeList);
        if (CollectionUtils.isNotEmpty((Collection)orderOccupyItemRespList)) {
            orderOccupyItemRespList.forEach(dto -> {
                OrderOccupyItemRespDto orderOccupyItemRespDto = (OrderOccupyItemRespDto)customerMap.get(dto.getOrderNo());
                dto.setParName(orderOccupyItemRespDto.getParName());
                dto.setOrgName(orderOccupyItemRespDto.getOrgName());
            });
        }
        return orderOccupyItemRespList;
    }
}

