/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.interceptor;

import com.mysql.cj.jdbc.ClientPreparedStatement;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostPlacedFlagRealSqlStrategyUtil {
    private static final Logger log = LoggerFactory.getLogger(CostPlacedFlagRealSqlStrategyUtil.class);
    static Map<String, Function<PreparedStatement, String>> map = new HashMap<String, Function<PreparedStatement, String>>();

    public static String getSql(PreparedStatement ps) throws SQLException {
        if (ps != null && ps.getConnection() != null) {
            String dbType = ps.getConnection().getMetaData().getDatabaseProductName().toUpperCase();
            return CostPlacedFlagRealSqlStrategyUtil.getRealSqlByPreparedStatement(dbType, ps);
        }
        log.error("PreparedStatement is null ! ps = {}", (Object)ps);
        return null;
    }

    public static String getRealSqlByPreparedStatement(String dbType, PreparedStatement ps) {
        Function<PreparedStatement, String> statementStringFunction = map.get(dbType);
        if (statementStringFunction == null) {
            throw new RuntimeException("\u76ee\u524d\u53ea\u652f\u6301 " + map.keySet() + " \u6570\u636e\u6e90\uff01");
        }
        return statementStringFunction.apply(ps).replaceAll("\\s+", " ");
    }

    public static Object getPropertyValue(Object obj, String propertyName) {
        Class<?> objClass = obj.getClass();
        try {
            Field field = objClass.getDeclaredField(propertyName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        map.put("MYSQL", ps -> {
            String temp = ps.toString();
            ClientPreparedStatement clientPreparedStatement = (ClientPreparedStatement)CostPlacedFlagRealSqlStrategyUtil.getPropertyValue(ps, "delegate");
            return clientPreparedStatement.toString().substring(temp.indexOf(":") + 1);
        });
        map.put("POSTGRESQL", Object::toString);
    }
}

