/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.ActivityTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.GiftBalanceStatementTradeTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.OrderStatisticsServiceEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.RebateTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.AccountBillStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.CreditRecordDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.CreditStatementStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.FreeGiftSummaryReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrderActivityDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrderDetailStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrderItemProductRankingReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrderSaleProgressReqDto;
import com.dtyunxi.tcbj.api.dto.request.PromotionalActivitiesStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.RebateDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.RebateOrderDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReturnDetailStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.AccountBillStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.CreditRecordDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.CreditStatementStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.FreeGiftSummaryRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrderActivityDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrderCustomerSalesmanRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrderDetailBaseRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrderDetailStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrderItemProductRankingRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrderSaleProgressRespDto;
import com.dtyunxi.tcbj.api.dto.response.PromotionalActivitiesStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.RebateDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.RebateOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReportBaseRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReturnDetailStatisticsRespDto;
import com.dtyunxi.tcbj.biz.factory.OrderStatisticsFactory;
import com.dtyunxi.tcbj.biz.service.query.IDistributorReportQueryService;
import com.dtyunxi.tcbj.biz.service.query.IOrderQueryService;
import com.dtyunxi.tcbj.biz.utils.DateUtil;
import com.dtyunxi.tcbj.dao.das.AccountBillDas;
import com.dtyunxi.tcbj.dao.das.BalanceDas;
import com.dtyunxi.tcbj.dao.das.CreditRecordDas;
import com.dtyunxi.tcbj.dao.das.CreditRepayPlanDas;
import com.dtyunxi.tcbj.dao.das.CreditUsageRecordDas;
import com.dtyunxi.tcbj.dao.das.GiftBalanceRecordDas;
import com.dtyunxi.tcbj.dao.das.OrderActivityDas;
import com.dtyunxi.tcbj.dao.das.RbOrderDas;
import com.dtyunxi.tcbj.dao.das.RebateDetailDas;
import com.dtyunxi.tcbj.dao.das.ReturnItemDas;
import com.dtyunxi.tcbj.dao.das.TradeItemDas;
import com.dtyunxi.tcbj.dao.eo.CustomerSalesmanEo;
import com.dtyunxi.tcbj.dao.eo.GiftBalanceTurnoverEo;
import com.dtyunxi.tcbj.dao.eo.RCustomerSalesmanEo;
import com.dtyunxi.tcbj.dao.eo.ShopEo;
import com.dtyunxi.tcbj.dao.mapper.CustomerSalesmanMapper;
import com.dtyunxi.tcbj.dao.mapper.GiftBalanceAdvanceMapper;
import com.dtyunxi.tcbj.dao.mapper.GiftBalanceFreezeMapper;
import com.dtyunxi.tcbj.dao.mapper.GiftBalanceStatementMapper;
import com.dtyunxi.tcbj.dao.mapper.RCustomerSalesmanMapper;
import com.dtyunxi.tcbj.dao.mapper.ShopMapper;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DistributorReportQueryServiceImpl
implements IDistributorReportQueryService {
    private static final Logger logger = LoggerFactory.getLogger(DistributorReportQueryServiceImpl.class);
    @Resource
    private OrderStatisticsFactory orderStatisticsFactory;
    @Resource
    private GiftBalanceRecordDas giftBalanceRecordDas;
    @Resource
    private GiftBalanceAdvanceMapper giftBalanceAdvanceMapper;
    @Resource
    private GiftBalanceStatementMapper giftBalanceStatementMapper;
    @Resource
    private GiftBalanceFreezeMapper giftBalanceFreezeMapper;
    @Resource
    private RebateDetailDas rebateDetailDas;
    @Resource
    private RbOrderDas rbOrderDas;
    @Resource
    private CreditRepayPlanDas creditRepayPlanDas;
    @Resource
    private CreditRecordDas creditRecordDas;
    @Resource
    private AccountBillDas accountBillDas;
    @Resource
    private OrderActivityDas orderActivityDas;
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private CustomerSalesmanMapper customerSalesmanMapper;
    @Resource
    private ShopMapper shopMapper;
    @Resource
    private RCustomerSalesmanMapper rCustomerSalesmanMapper;
    @Resource
    private ReturnItemDas returnItemDas;
    @Resource
    private CreditUsageRecordDas creditUsageRecordDas;
    @Resource
    private BalanceDas balanceDas;

    @Override
    public PageInfo<OrderSaleProgressRespDto> saleProgressStatistics(OrderSaleProgressReqDto orderSaleProgressReqDto) {
        String serviceName = OrderStatisticsServiceEnum.getNameByCode((Integer)orderSaleProgressReqDto.getOrderType());
        IOrderQueryService orderQueryService = this.getServiceImpl(serviceName);
        PageHelper.startPage((int)orderSaleProgressReqDto.getPageNum(), (int)orderSaleProgressReqDto.getPageSize());
        return new PageInfo(orderQueryService.saleProgressStatistics(orderSaleProgressReqDto));
    }

    @Override
    public PageInfo<OrderItemProductRankingRespDto> productRankingStatistics(OrderItemProductRankingReqDto orderItemProductRankingReqDto) {
        String serviceName = OrderStatisticsServiceEnum.getNameByCode((Integer)orderItemProductRankingReqDto.getOrderType());
        IOrderQueryService orderQueryService = this.getServiceImpl(serviceName);
        PageHelper.startPage((int)orderItemProductRankingReqDto.getPageNum(), (int)orderItemProductRankingReqDto.getPageSize());
        return new PageInfo(orderQueryService.productRankingStatistics(orderItemProductRankingReqDto));
    }

    @Override
    public PageInfo<FreeGiftSummaryRespDto> freeGiftSummaryStatistics(FreeGiftSummaryReqDto freeGiftSummaryReqDto) {
        logger.info("\u514d\u8d39\u8d60\u54c1\u6c47\u603b\uff1a{}", (Object)JSON.toJSONString((Object)freeGiftSummaryReqDto));
        PageInfo<FreeGiftSummaryRespDto> freeGiftList = this.getFreeGiftSummaryRespDtos(freeGiftSummaryReqDto);
        if (CollectionUtils.isEmpty((Collection)freeGiftList.getList())) {
            logger.info("\u65e0\u8d26\u6237");
            return freeGiftList;
        }
        Map<Long, FreeGiftSummaryRespDto> freeGiftMap = freeGiftList.getList().stream().collect(Collectors.toMap(ReportBaseRespDto::getCustomerId, t -> t, (last, next) -> next));
        List customerIds = freeGiftList.getList().stream().map(ReportBaseRespDto::getCustomerId).collect(Collectors.toList());
        List statementList = this.giftBalanceRecordDas.getBalanceStatementByCustomerIds(customerIds, freeGiftSummaryReqDto.getPlaceTimeStart(), freeGiftSummaryReqDto.getPlaceTimeEnd());
        List freezeList = this.giftBalanceRecordDas.getBalanceFreezeByCustomerIds(customerIds, freeGiftSummaryReqDto.getPlaceTimeStart(), freeGiftSummaryReqDto.getPlaceTimeEnd());
        Map<Object, Object> freezeListMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)freezeList)) {
            freezeListMap = freezeList.stream().collect(Collectors.toMap(ReportBaseRespDto::getCustomerId, t -> t, (last, next) -> next));
        }
        List initialList = this.giftBalanceRecordDas.getGiftBalanceInitial(customerIds, freeGiftSummaryReqDto.getPlaceTimeStart());
        Map<Object, Object> initialListMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)initialList)) {
            initialListMap = initialList.stream().collect(Collectors.toMap(ReportBaseRespDto::getCustomerId, t -> t, (last, next) -> next));
        }
        statementList.forEach(statement -> {
            FreeGiftSummaryRespDto freeGiftSummary = (FreeGiftSummaryRespDto)freeGiftMap.get(statement.getCustomerId());
            if (ObjectUtils.isEmpty((Object)freeGiftSummary)) {
                return;
            }
            if (statement.getTradeType().equals(GiftBalanceStatementTradeTypeEnum.ORDER_GIFT.getStatus())) {
                freeGiftSummary.setOrderGift(statement.getTradeAmount());
            } else if (statement.getTradeType().equals(GiftBalanceStatementTradeTypeEnum.GIVE_RETURN.getStatus())) {
                freeGiftSummary.setGiveReturn(statement.getTradeAmount());
            } else if (statement.getTradeType().equals(GiftBalanceStatementTradeTypeEnum.ADVANCE_GRANT.getStatus())) {
                freeGiftSummary.setAdvanceGiftQuota(statement.getTradeAmount());
            } else if (statement.getTradeType().equals(GiftBalanceStatementTradeTypeEnum.ADVANCE_RETURN.getStatus())) {
                freeGiftSummary.setAlreadyRepaidAdvanceQuota(statement.getTradeAmount());
            } else if (statement.getTradeType().equals(GiftBalanceStatementTradeTypeEnum.ORDER_REDUCE.getStatus())) {
                freeGiftSummary.setChargebackDeductionQuota(statement.getTradeAmount());
            } else if (statement.getTradeType().equals(GiftBalanceStatementTradeTypeEnum.MANUAL_IMPORT.getStatus())) {
                freeGiftSummary.setManualImport(statement.getTradeAmount());
            } else if (statement.getTradeType().equals(GiftBalanceStatementTradeTypeEnum.ORDER_DEDUCT.getStatus())) {
                freeGiftSummary.setOrderDeduct(statement.getTradeAmount());
            } else if (statement.getTradeType().equals(GiftBalanceStatementTradeTypeEnum.ORDER_RETURN.getStatus())) {
                freeGiftSummary.setOrderReturn(statement.getTradeAmount());
            }
        });
        Map<Object, Object> finalFreezeListMap = freezeListMap;
        HashMap finalInitialListMap = initialListMap;
        freeGiftMap.values().forEach(gift -> {
            if (ObjectUtils.isNotEmpty(finalFreezeListMap.get(gift.getCustomerId()))) {
                gift.setFreezeQuota(((FreeGiftSummaryRespDto)finalFreezeListMap.get(gift.getCustomerId())).getTradeAmount());
            }
            if (ObjectUtils.isNotEmpty(finalInitialListMap.get(gift.getCustomerId()))) {
                gift.setBeginningOfPeriodQuota(((FreeGiftSummaryRespDto)finalInitialListMap.get(gift.getCustomerId())).getTradeAmount());
            }
            gift.setFreeGiftQuota(gift.getOrderGift().subtract(gift.getGiveReturn()));
            gift.setUsedGiftQuota(gift.getOrderDeduct().subtract(gift.getOrderReturn()));
            BigDecimal remainderGiftQuotaAmount = gift.getBeginningOfPeriodQuota().add(gift.getFreeGiftQuota()).add(gift.getAdvanceGiftQuota()).add(gift.getManualImport()).subtract(gift.getAlreadyRepaidAdvanceQuota()).subtract(gift.getUsedGiftQuota()).subtract(gift.getChargebackDeductionQuota());
            gift.setRemainderGiftQuota(remainderGiftQuotaAmount);
            BigDecimal allowUseQuota = remainderGiftQuotaAmount.subtract(gift.getFreezeQuota());
            gift.setAllowUseQuota(allowUseQuota);
        });
        freeGiftList.setList(new ArrayList<FreeGiftSummaryRespDto>(freeGiftMap.values()));
        return freeGiftList;
    }

    @Override
    public PageInfo<RebateDetailRespDto> discountStatistics(RebateDetailReqDto rebateDetailReqDto) {
        logger.info("\u6298\u6263\u6c47\u603b\uff1a{}", (Object)JSON.toJSONString((Object)rebateDetailReqDto));
        PageInfo<RebateDetailRespDto> balanceAccountList = this.getBalanceAccountList(rebateDetailReqDto);
        if (CollectionUtils.isEmpty((Collection)balanceAccountList.getList())) {
            logger.info("\u65e0\u8d26\u6237");
            return balanceAccountList;
        }
        List customerIds = balanceAccountList.getList().stream().map(ReportBaseRespDto::getCustomerId).collect(Collectors.toList());
        List balanceChangeDetailList = this.balanceDas.getBalanceChangeDetailList(customerIds, rebateDetailReqDto.getPlaceTimeStart(), rebateDetailReqDto.getPlaceTimeEnd());
        List balanceStartCarryover = this.balanceDas.getBalanceCarryover(customerIds, rebateDetailReqDto.getPlaceTimeStart(), null);
        Map<Object, Object> balanceStartCarryoverMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)balanceStartCarryover)) {
            balanceStartCarryoverMap = balanceStartCarryover.stream().collect(Collectors.toMap(ReportBaseRespDto::getCustomerId, t -> t, (last, next) -> next));
        }
        List balanceEndCarryover = this.balanceDas.getBalanceCarryover(customerIds, null, DateUtil.addOneDay(rebateDetailReqDto.getPlaceTimeEnd()));
        Map<Object, Object> balanceEndCarryoverMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)balanceEndCarryover)) {
            balanceEndCarryoverMap = balanceEndCarryover.stream().collect(Collectors.toMap(ReportBaseRespDto::getCustomerId, t -> t, (last, next) -> next));
        }
        Map<Object, Object> finalBalanceStartCarryoverMap = balanceStartCarryoverMap;
        HashMap finalBalanceEndCarryoverMap = balanceEndCarryoverMap;
        balanceAccountList.getList().forEach(account -> {
            balanceChangeDetailList.forEach(detail -> {
                if (detail.getCustomerId().equals(account.getCustomerId())) {
                    if (detail.getType().intValue() == RebateTypeEnum.MANUAL_REBATE.getType().intValue()) {
                        account.setDiscountPay(detail.getTradeAmount());
                    } else if (detail.getType().intValue() == RebateTypeEnum.ORDER_USE.getType().intValue()) {
                        account.setOrderUse(detail.getTradeAmount());
                    } else if (detail.getType().intValue() == RebateTypeEnum.CANCEL.getType().intValue()) {
                        account.setOrderCancel(detail.getTradeAmount());
                    } else if (detail.getType().intValue() == RebateTypeEnum.FAILURE.getType().intValue()) {
                        account.setDiscountOverdue(detail.getTradeAmount());
                    }
                }
            });
            account.setUseDiscountAmount(account.getOrderUse().subtract(account.getOrderCancel()));
            if (ObjectUtils.isNotEmpty(finalBalanceStartCarryoverMap.get(account.getCustomerId()))) {
                account.setBalanceBroughtForward(((RebateDetailRespDto)finalBalanceStartCarryoverMap.get(account.getCustomerId())).getTradeAmount());
            }
            if (ObjectUtils.isNotEmpty(finalBalanceEndCarryoverMap.get(account.getCustomerId()))) {
                account.setRemainderAllowUseDiscountAmount(((RebateDetailRespDto)finalBalanceEndCarryoverMap.get(account.getCustomerId())).getTradeAmount());
            }
        });
        return balanceAccountList;
    }

    private Map<Long, BigDecimal> getUseDisCountMapByUserId(List<Long> userIds) {
        List rebateDetailRespDtos = this.rebateDetailDas.usedDiscountStatistics(userIds);
        return rebateDetailRespDtos.stream().filter(rebateDetailRespDto -> null != rebateDetailRespDto.getUseDiscountAmount()).collect(Collectors.toMap(ReportBaseRespDto::getCustomerId, RebateDetailRespDto::getUseDiscountAmount, (old, now) -> old));
    }

    private List<String> getTradeNO(List<Long> customerIds, String status) {
        return ((List)Optional.ofNullable(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.giftBalanceStatementMapper).in(GiftBalanceTurnoverEo::getCustomerId, customerIds)).eq(GiftBalanceTurnoverEo::getTradeType, (Object)status)).list()).orElse(new ArrayList())).stream().map(GiftBalanceTurnoverEo::getTradeNo).collect(Collectors.toList());
    }

    private PageInfo<FreeGiftSummaryRespDto> getFreeGiftSummaryRespDtos(FreeGiftSummaryReqDto freeGiftSummaryReqDto) {
        PageHelper.startPage((int)freeGiftSummaryReqDto.getPageNum(), (int)freeGiftSummaryReqDto.getPageSize());
        return new PageInfo(this.giftBalanceRecordDas.FreeGiftSummaryStatistics(freeGiftSummaryReqDto));
    }

    private PageInfo<RebateDetailRespDto> getBalanceAccountList(RebateDetailReqDto rebateDetailReqDto) {
        PageHelper.startPage((int)rebateDetailReqDto.getPageNum(), (int)rebateDetailReqDto.getPageSize());
        return new PageInfo(this.balanceDas.getBalanceAccountList(rebateDetailReqDto));
    }

    private IOrderQueryService getServiceImpl(String serviceName) {
        return this.orderStatisticsFactory.getStrategy(serviceName);
    }

    @Override
    public PageInfo<CreditStatementStatisticsRespDto> creditStatementStatistics(CreditStatementStatisticsReqDto creditStatementStatisticsReqDto) {
        logger.info("\u6388\u4fe1\u8d26\u5355\u6c47\u603b\uff1a{}", (Object)JSON.toJSONString((Object)creditStatementStatisticsReqDto));
        PageHelper.startPage((int)creditStatementStatisticsReqDto.getPageNum(), (int)creditStatementStatisticsReqDto.getPageSize());
        PageInfo creditStatementList = new PageInfo(this.creditRepayPlanDas.getCreditStatementList(creditStatementStatisticsReqDto));
        return creditStatementList;
    }

    @Override
    public PageInfo<AccountBillStatisticsRespDto> accountBillStatistics(AccountBillStatisticsReqDto accountBillStatisticsReqDto) {
        logger.info("\u8d26\u671f\u6c47\u603b\uff1a{}", (Object)JSON.toJSONString((Object)accountBillStatisticsReqDto));
        PageHelper.startPage((int)accountBillStatisticsReqDto.getPageNum(), (int)accountBillStatisticsReqDto.getPageSize());
        return new PageInfo(this.accountBillDas.accountBillStatistics(accountBillStatisticsReqDto));
    }

    @Override
    public PageInfo<PromotionalActivitiesStatisticsRespDto> activityStatistics(PromotionalActivitiesStatisticsReqDto promotionalActivitiesStatisticsReqDto) {
        PageHelper.startPage((int)promotionalActivitiesStatisticsReqDto.getPageNum(), (int)promotionalActivitiesStatisticsReqDto.getPageSize());
        List dataList = this.orderActivityDas.activityStatistics(promotionalActivitiesStatisticsReqDto);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            dataList.forEach(data -> {
                if (ObjectUtils.isNotEmpty((Object)data.getItemType())) {
                    data.setItemTypeStr(SubTypeEnum.getSubTypeDesc((Integer)data.getItemType()));
                }
            });
        }
        return new PageInfo(dataList);
    }

    @Override
    public PageInfo<OrderDetailStatisticsRespDto> orderDetailStatistics(OrderDetailStatisticsReqDto orderDetailStatisticsReqDto) {
        PageHelper.startPage((int)orderDetailStatisticsReqDto.getPageNum(), (int)orderDetailStatisticsReqDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.tradeItemDas.orderDetailStatistics(orderDetailStatisticsReqDto));
        List list = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        List<Long> customerIds = list.stream().map(ReportBaseRespDto::getCustomerId).collect(Collectors.toList());
        List<Long> shopIds = list.stream().map(OrderDetailBaseRespDto::getShopId).collect(Collectors.toList());
        OrderCustomerSalesmanRespDto customerSalesman = this.getCustomerSalesman(customerIds, shopIds);
        List resultList = list.stream().peek(orderDetailStatisticsRespDto -> {
            logger.info("\u5904\u7406\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)orderDetailStatisticsRespDto));
            if (ObjectUtils.isNotEmpty((Object)orderDetailStatisticsRespDto.getItemNum()) && orderDetailStatisticsRespDto.getItemNum() > 0) {
                BigDecimal eachActivityShareAmount = orderDetailStatisticsRespDto.getActivityShareAmount().divide(new BigDecimal(orderDetailStatisticsRespDto.getItemNum()), 4, RoundingMode.CEILING);
                orderDetailStatisticsRespDto.setEachActivityShareAmount(eachActivityShareAmount);
                BigDecimal eachDiscountDeductionAmount = orderDetailStatisticsRespDto.getDiscountDeductionAmount().divide(new BigDecimal(orderDetailStatisticsRespDto.getItemNum()), 4, RoundingMode.CEILING);
                orderDetailStatisticsRespDto.setEachDiscountDeductionAmount(eachDiscountDeductionAmount);
                BigDecimal eachGiftBalanceDiscountAmount = orderDetailStatisticsRespDto.getGiftBalanceDiscountAmount().divide(new BigDecimal(orderDetailStatisticsRespDto.getItemNum()), 4, RoundingMode.CEILING);
                orderDetailStatisticsRespDto.setEachGiftBalanceDiscountAmount(eachGiftBalanceDiscountAmount);
            }
            if (customerSalesman != null && customerSalesman.getShopNameMap().size() > 0) {
                String shopName = (String)customerSalesman.getShopNameMap().get(orderDetailStatisticsRespDto.getShopId());
                orderDetailStatisticsRespDto.setCompanyName(shopName);
            }
            Optional.ofNullable(orderDetailStatisticsRespDto.getBatchNo()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(batchNo -> orderDetailStatisticsRespDto.setBatchNo(Stream.of(batchNo.split(",")).map(s -> s.split("#")[0]).collect(Collectors.joining(","))));
        }).collect(Collectors.toList());
        pageInfo.setList(resultList);
        return pageInfo;
    }

    private OrderCustomerSalesmanRespDto getCustomerSalesman(List<Long> customerIds, List<Long> shopIds) {
        List rCustomerSalesmanEos = Optional.ofNullable(((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.rCustomerSalesmanMapper).in(RCustomerSalesmanEo::getCustomerId, customerIds)).list()).orElse(new ArrayList());
        List salesmanIds = rCustomerSalesmanEos.stream().map(RCustomerSalesmanEo::getSalesmanId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(salesmanIds)) {
            return null;
        }
        Map<Long, String> customerSalesmanNameMap = ((List)Optional.ofNullable(((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.customerSalesmanMapper).in(CustomerSalesmanEo::getUserId, salesmanIds)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(CustomerSalesmanEo::getUserId, CustomerSalesmanEo::getName, (old, now) -> old));
        Map customerIdToSalesmanMap = rCustomerSalesmanEos.stream().collect(Collectors.groupingBy(RCustomerSalesmanEo::getCustomerId, Collectors.mapping(RCustomerSalesmanEo::getSalesmanId, Collectors.toList())));
        Map<Long, String> shopNameMap = ((List)Optional.ofNullable(((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.shopMapper).in(BaseEo::getId, shopIds)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, ShopEo::getName));
        return new OrderCustomerSalesmanRespDto(customerSalesmanNameMap, customerIdToSalesmanMap, shopNameMap);
    }

    @Override
    public PageInfo<ReturnDetailStatisticsRespDto> returnDetailStatistics(ReturnDetailStatisticsReqDto returnDetailStatisticsReqDto) {
        PageHelper.startPage((int)returnDetailStatisticsReqDto.getPageNum(), (int)returnDetailStatisticsReqDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.returnItemDas.returnDetailStatistics(returnDetailStatisticsReqDto));
        List list = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        List<Long> customerIds = list.stream().map(ReportBaseRespDto::getCustomerId).collect(Collectors.toList());
        List<Long> shopIds = list.stream().map(OrderDetailBaseRespDto::getShopId).collect(Collectors.toList());
        OrderCustomerSalesmanRespDto customerSalesman = this.getCustomerSalesman(customerIds, shopIds);
        List resultList = list.stream().peek(returnDetailStatisticsRespDto -> {
            if (ObjectUtils.isNotEmpty((Object)returnDetailStatisticsRespDto.getItemType())) {
                returnDetailStatisticsRespDto.setItemTypeStr(SubTypeEnum.getSubTypeDesc((Integer)returnDetailStatisticsRespDto.getItemType()));
            }
            if (customerSalesman != null) {
                List customerSalesmanIds;
                if (customerSalesman.getShopNameMap().size() > 0) {
                    String shopName = (String)customerSalesman.getShopNameMap().get(returnDetailStatisticsRespDto.getShopId());
                    returnDetailStatisticsRespDto.setCompanyName(shopName);
                }
                if (customerSalesman.getCustomerIdToSalesmanMap().size() > 0 && customerSalesman.getCustomerSalesmanNameMap().size() > 0 && CollectionUtils.isNotEmpty((Collection)(customerSalesmanIds = (List)customerSalesman.getCustomerIdToSalesmanMap().get(returnDetailStatisticsRespDto.getCustomerId())))) {
                    String customerSalesmanName = customerSalesmanIds.stream().map(customerSalesmanId -> (String)customerSalesman.getCustomerSalesmanNameMap().get(customerSalesmanId)).collect(Collectors.joining(","));
                    returnDetailStatisticsRespDto.setSalesmanName(customerSalesmanName);
                }
            }
            Optional.ofNullable(returnDetailStatisticsRespDto.getBatchNo()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(batchNo -> returnDetailStatisticsRespDto.setBatchNo(Stream.of(batchNo.split(",")).map(s -> s.split("#")[0]).collect(Collectors.joining(","))));
        }).collect(Collectors.toList());
        pageInfo.setList(resultList);
        return pageInfo;
    }

    @Override
    public PageInfo<RebateOrderDetailRespDto> rebateOrderDetailStatistics(RebateOrderDetailReqDto rebateOrderDetailReqDto) {
        PageHelper.startPage((int)rebateOrderDetailReqDto.getPageNum(), (int)rebateOrderDetailReqDto.getPageSize());
        List rebateOrderDetailRespDtoList = this.rbOrderDas.rebateOrderDetailStatistics(rebateOrderDetailReqDto);
        if (!CollectionUtils.isNotEmpty((Collection)rebateOrderDetailRespDtoList)) {
            return new PageInfo();
        }
        rebateOrderDetailRespDtoList.forEach(dto -> {
            if (StringUtils.isNotEmpty((CharSequence)dto.getStatus())) {
                switch (dto.getStatus()) {
                    case "WAIT_AUDIT": {
                        dto.setStatusStr("\u5f85\u5ba1\u6838");
                        break;
                    }
                    case "AUDIT_REJECT": {
                        dto.setStatusStr("\u5ba1\u6838\u4e0d\u901a\u8fc7");
                        break;
                    }
                    case "WAIT_ISSUE": {
                        dto.setStatusStr("\u5f85\u53d1\u653e");
                        break;
                    }
                    case "ISSUED": {
                        dto.setStatusStr("\u5df2\u53d1\u653e");
                        break;
                    }
                    case "EXPIRED": {
                        dto.setStatusStr("\u5df2\u5931\u6548");
                    }
                }
            }
        });
        return new PageInfo(rebateOrderDetailRespDtoList);
    }

    @Override
    public PageInfo<OrderActivityDetailRespDto> orderActivityDetailStatistics(OrderActivityDetailReqDto orderActivityDetailReqDto) {
        PageHelper.startPage((int)orderActivityDetailReqDto.getPageNum(), (int)orderActivityDetailReqDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.orderActivityDas.orderActivityDetailStatistics(orderActivityDetailReqDto));
        List list = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        List shopIds = list.stream().map(OrderActivityDetailRespDto::getShopId).collect(Collectors.toList());
        Map<Long, String> shopNameMap = ((List)Optional.ofNullable(((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.shopMapper).in(BaseEo::getId, shopIds)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, ShopEo::getName));
        list.forEach(orderActivityDetailRespDto -> {
            String shopName = (String)shopNameMap.get(orderActivityDetailRespDto.getShopId());
            orderActivityDetailRespDto.setShopName(shopName);
            if (StringUtils.isNotBlank((CharSequence)orderActivityDetailRespDto.getActivityStatus()) && ObjectUtils.isNotEmpty((Object)ActivityStatusEnum.getByKey((String)orderActivityDetailRespDto.getActivityStatus()))) {
                orderActivityDetailRespDto.setActivityStatusStr(ActivityStatusEnum.getByKey((String)orderActivityDetailRespDto.getActivityStatus()).getValue());
            }
            if (StringUtils.isNotBlank((CharSequence)orderActivityDetailRespDto.getType()) && StringUtils.isNotBlank((CharSequence)ActivityTypeEnum.getValueByCode((String)orderActivityDetailRespDto.getType()))) {
                orderActivityDetailRespDto.setTypeStr(ActivityTypeEnum.getValueByCode((String)orderActivityDetailRespDto.getType()));
            }
        });
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public PageInfo<CreditRecordDetailRespDto> creditRecordDetailStatistics(CreditRecordDetailReqDto creditRecordDetailReqDto) {
        PageHelper.startPage((int)creditRecordDetailReqDto.getPageNum(), (int)creditRecordDetailReqDto.getPageSize());
        return new PageInfo(this.creditUsageRecordDas.creditRecordDetailStatistics(creditRecordDetailReqDto));
    }
}

