/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl.es;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.es.EsInventoryOperateLogListPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.EsOtherStorageOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.EsOutNoticeOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.GetNoticeOrderPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseReturnOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.ProductOrderLisReq;
import com.dtyunxi.tcbj.api.dto.response.InPlannedOrderStatusCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.CsOtherStorageOrderRespVo;
import com.dtyunxi.tcbj.api.dto.response.es.EsInventoryOperateLogVO;
import com.dtyunxi.tcbj.api.dto.response.es.InNoticeOrderVO;
import com.dtyunxi.tcbj.api.dto.response.es.OutNoticeOrderVO;
import com.dtyunxi.tcbj.api.dto.response.es.ProductOrderVO;
import com.dtyunxi.tcbj.api.dto.response.es.PurchaseOrderVO;
import com.dtyunxi.tcbj.api.dto.response.es.PurchaseReturnOrderVO;
import com.dtyunxi.tcbj.biz.service.es.CsInventoryEsService;
import com.dtyunxi.tcbj.dao.das.CsInventoryEsDas;
import com.dtyunxi.tcbj.dao.das.CsOtherStorageOrderDas;
import com.dtyunxi.tcbj.dao.eo.es.CsOtherStorageOrderEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CsInventoryEsServiceImpl
implements CsInventoryEsService {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryEsServiceImpl.class);
    @Resource
    private CsInventoryEsDas csInventoryEsDas;
    @Resource
    private CsOtherStorageOrderDas csOtherStorageOrderDas;

    @Override
    public PageInfo<CsOtherStorageOrderRespVo> queryOtherStorageOrderList(EsOtherStorageOrderListPageParams dto) {
        List<String> strings;
        logger.info("\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (StringUtils.isNotBlank((CharSequence)dto.getCreateBeginTime()) && StringUtils.isNotBlank((CharSequence)dto.getCreateEndTime())) {
            String st = dto.getCreateBeginTime() + " 00:00:00";
            String et = dto.getCreateEndTime() + " 23:59:59";
            dto.setCreateBeginTime(st);
            dto.setCreateEndTime(et);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getStorageOrderNo()) && (strings = Arrays.asList(dto.getStorageOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            dto.setStorageOrderNoList(strings);
            dto.setStorageOrderNo(null);
        }
        return new PageInfo(this.csInventoryEsDas.queryOtherStorageOrderList(dto));
    }

    @Override
    public List<InPlannedOrderStatusCountRespDto> otherStorageOrderStatusCount(EsOtherStorageOrderListPageParams dto) {
        List<String> strings;
        if (StringUtils.isNotBlank((CharSequence)dto.getCreateBeginTime()) && StringUtils.isNotBlank((CharSequence)dto.getCreateEndTime())) {
            String st = dto.getCreateBeginTime() + " 00:00:00";
            String et = dto.getCreateEndTime() + " 23:59:59";
            dto.setCreateBeginTime(st);
            dto.setCreateEndTime(et);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getStorageOrderNo()) && (strings = Arrays.asList(dto.getStorageOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            dto.setStorageOrderNoList(strings);
            dto.setStorageOrderNo(null);
        }
        return this.csInventoryEsDas.otherStorageOrderStatusCount(dto);
    }

    @Override
    public PageInfo<OutNoticeOrderVO> queryOutNoticeOrderPage(EsOutNoticeOrderListPageParams dto) {
        List outNoticeOrderVOS;
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        dto.setOrderType("out");
        if (StringUtils.isNotBlank((CharSequence)dto.getStartTime()) && StringUtils.isNotBlank((CharSequence)dto.getEndTime())) {
            dto.setStartTime(dto.getStartTime() + " 00:00:00");
            dto.setEndTime(dto.getEndTime() + " 23:59:59");
        }
        if (CollectionUtil.isEmpty((Collection)(outNoticeOrderVOS = this.csInventoryEsDas.queryOutNoticeOrderPage(dto)))) {
            return new PageInfo();
        }
        List documentNos = outNoticeOrderVOS.stream().map(OutNoticeOrderVO::getDocumentNo).collect(Collectors.toList());
        HashMap<String, BigDecimal> noTotalSkuMap = new HashMap<String, BigDecimal>(documentNos.size());
        noTotalSkuMap.putAll(this.csInventoryEsDas.queryTotalSkuListByDocumentNoList(documentNos).stream().collect(Collectors.toMap(OutNoticeOrderVO::getDocumentNo, OutNoticeOrderVO::getTotalSku, (o, o1) -> o)));
        outNoticeOrderVOS.forEach(o -> {
            if (ObjectUtil.isNotEmpty((Object)o.getDocumentNo())) {
                o.setTotalSku(noTotalSkuMap.get(String.valueOf(o.getDocumentNo())) == null ? null : new BigDecimal(String.valueOf(noTotalSkuMap.get(String.valueOf(o.getDocumentNo())))));
            }
        });
        return new PageInfo(outNoticeOrderVOS);
    }

    @Override
    public PageInfo<EsInventoryOperateLogVO> queryInventoryOperateLogListPage(EsInventoryOperateLogListPageParams dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (dto.getWarehouseClassify().equals("channel") || dto.getWarehouseClassify().equals("virtual")) {
            logger.info("\u6e20\u9053\u3001\u865a\u62df\u6d41\u6c34");
            return new PageInfo(this.csInventoryEsDas.queryShareInventoryOperateLogListPage(dto));
        }
        logger.info("\u903b\u8f91,\u5728\u9014\u4ed3");
        return new PageInfo(this.csInventoryEsDas.queryInventoryOperateLogListPage(dto));
    }

    @Override
    public PageInfo<InNoticeOrderVO> queryNoticeOrderPage(GetNoticeOrderPageParams dto) {
        EsOutNoticeOrderListPageParams pageParams = new EsOutNoticeOrderListPageParams();
        CubeBeanUtils.copyProperties((Object)pageParams, (Object)dto, (String[])new String[0]);
        pageParams.setDocumentNo(dto.getOrderNo());
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        pageParams.setOrderType("in");
        if (StringUtils.isNotBlank((CharSequence)dto.getStartTime()) && StringUtils.isNotBlank((CharSequence)dto.getEndTime())) {
            String st = dto.getStartTime() + " 00:00:00";
            String et = dto.getEndTime() + " 23:59:59";
            pageParams.setStartTimeDate(DateUtil.parseDate((String)st, (String)"yyyy-MM-dd HH:mm:ss"));
            pageParams.setEndTimeDate(DateUtil.parseDate((String)et, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        PageInfo outNoticeOrderVOPageInfo = new PageInfo(this.csInventoryEsDas.queryOutNoticeOrderPage(pageParams));
        PageInfo inNoticeOrderVOPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)inNoticeOrderVOPageInfo, (Object)outNoticeOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList lists = new ArrayList();
        CubeBeanUtils.copyCollection(lists, (Collection)outNoticeOrderVOPageInfo.getList(), InNoticeOrderVO.class);
        inNoticeOrderVOPageInfo.setList(lists);
        return inNoticeOrderVOPageInfo;
    }

    @Override
    public PageInfo<PurchaseOrderVO> getPurchaseOrderListPage(GetPurchaseOrderListPageParams dto) {
        List<String> strings;
        GetPurchaseOrderListPageParams pageParams = new GetPurchaseOrderListPageParams();
        CubeBeanUtils.copyProperties((Object)pageParams, (Object)dto, (String[])new String[0]);
        pageParams.setOrderType(dto.getOrderType());
        if (StringUtils.isNotBlank((CharSequence)dto.getStartTime())) {
            pageParams.setStartTime(dto.getStartTime() + " 00:00:00");
            pageParams.setEndTime(dto.getEndTime() + " 23:59:59");
        }
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getBussinessOrderNo()) && (strings = Arrays.asList(pageParams.getBussinessOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageParams.setBussinessOrderNoList(strings);
            pageParams.setBussinessOrderNo(null);
        }
        PageInfo outNoticeOrderVOPageInfo = new PageInfo(this.csInventoryEsDas.queryInPlannedOrderList(pageParams));
        PageInfo inNoticeOrderVOPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)inNoticeOrderVOPageInfo, (Object)outNoticeOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList lists = new ArrayList();
        CubeBeanUtils.copyCollection(lists, (Collection)outNoticeOrderVOPageInfo.getList(), PurchaseOrderVO.class);
        inNoticeOrderVOPageInfo.setList(lists);
        return inNoticeOrderVOPageInfo;
    }

    @Override
    public List<InPlannedOrderStatusCountRespDto> inPlannedOrderStatusCount(GetPurchaseOrderListPageParams dto) {
        List<String> strings;
        GetPurchaseOrderListPageParams pageParams = new GetPurchaseOrderListPageParams();
        CubeBeanUtils.copyProperties((Object)pageParams, (Object)dto, (String[])new String[0]);
        pageParams.setOrderType(dto.getOrderType());
        if (StringUtils.isNotBlank((CharSequence)dto.getStartTime())) {
            pageParams.setStartTime(dto.getStartTime() + " 00:00:00");
            pageParams.setEndTime(dto.getEndTime() + " 23:59:59");
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getBussinessOrderNo()) && (strings = Arrays.asList(pageParams.getBussinessOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageParams.setBussinessOrderNoList(strings);
            pageParams.setBussinessOrderNo(null);
        }
        return this.csInventoryEsDas.inPlannedOrderStatusCount(pageParams);
    }

    @Override
    public PageInfo<PurchaseReturnOrderVO> getPurchaseReturnOrderListPage(GetPurchaseReturnOrderListPageParams dto) {
        List<String> strings;
        GetPurchaseReturnOrderListPageParams pageParams = new GetPurchaseReturnOrderListPageParams();
        String startTime = dto.getStartTime();
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            dto.setStartTime(startTime + " 00:00:00");
            dto.setEndTime(dto.getEndTime() + " 23:59:59");
        }
        CubeBeanUtils.copyProperties((Object)pageParams, (Object)dto, (String[])new String[0]);
        pageParams.setOrderType(dto.getOrderType());
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getBussinessOrderNo()) && (strings = Arrays.asList(pageParams.getBussinessOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageParams.setBussinessOrderNoList(strings);
            pageParams.setBussinessOrderNo(null);
        }
        PageInfo outNoticeOrderVOPageInfo = new PageInfo(this.csInventoryEsDas.queryOutPlannedOrderList(pageParams));
        PageInfo inNoticeOrderVOPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)inNoticeOrderVOPageInfo, (Object)outNoticeOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList lists = new ArrayList();
        CubeBeanUtils.copyCollection(lists, (Collection)outNoticeOrderVOPageInfo.getList(), PurchaseReturnOrderVO.class);
        inNoticeOrderVOPageInfo.setList(lists);
        return inNoticeOrderVOPageInfo;
    }

    @Override
    public List<InPlannedOrderStatusCountRespDto> outPlannedOrderStatusCount(GetPurchaseReturnOrderListPageParams dto) {
        List<String> strings;
        GetPurchaseReturnOrderListPageParams pageParams = new GetPurchaseReturnOrderListPageParams();
        String startTime = dto.getStartTime();
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            dto.setStartTime(startTime + " 00:00:00");
            dto.setEndTime(dto.getEndTime() + " 23:59:59");
        }
        CubeBeanUtils.copyProperties((Object)pageParams, (Object)dto, (String[])new String[0]);
        pageParams.setOrderType(dto.getOrderType());
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getBussinessOrderNo()) && (strings = Arrays.asList(pageParams.getBussinessOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageParams.setBussinessOrderNoList(strings);
            pageParams.setBussinessOrderNo(null);
        }
        return this.csInventoryEsDas.outPlannedOrderStatusCount(pageParams);
    }

    @Override
    public PageInfo<ProductOrderVO> queryProductOrderListPage(ProductOrderLisReq dto) {
        List<String> strings;
        if (StringUtils.isBlank((CharSequence)dto.getOrderType())) {
            return new PageInfo();
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getStartTime())) {
            dto.setStartTime(dto.getStartTime() + " 00:00:00");
            dto.setEndTime(dto.getEndTime() + " 23:59:59");
        }
        GetPurchaseReturnOrderListPageParams pageParams = new GetPurchaseReturnOrderListPageParams();
        pageParams.setOrderType(dto.getOrderType());
        CubeBeanUtils.copyProperties((Object)pageParams, (Object)dto, (String[])new String[0]);
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)dto.getBussinessOrderNo()) && (strings = Arrays.asList(dto.getBussinessOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            dto.setBussinessOrderNoList(strings);
            dto.setBussinessOrderNo(null);
        }
        PageInfo inNoticeOrderVOPageInfo = null;
        inNoticeOrderVOPageInfo = StringUtils.equals((CharSequence)CsPlannedOrderTypeEnum.PRODUCT_REPAIR.getCode(), (CharSequence)dto.getOrderType()) ? new PageInfo(this.csInventoryEsDas.queryProductRepariOrderListPage(dto)) : new PageInfo(this.csInventoryEsDas.queryProductOrderListPage(dto));
        return inNoticeOrderVOPageInfo;
    }

    @Override
    public List<InPlannedOrderStatusCountRespDto> productOrderStatusCount(ProductOrderLisReq dto) {
        List<String> strings;
        if (StringUtils.isNotBlank((CharSequence)dto.getStartTime())) {
            dto.setStartTime(dto.getStartTime() + " 00:00:00");
            dto.setEndTime(dto.getEndTime() + " 23:59:59");
        }
        GetPurchaseReturnOrderListPageParams pageParams = new GetPurchaseReturnOrderListPageParams();
        pageParams.setOrderType(dto.getOrderType());
        CubeBeanUtils.copyProperties((Object)pageParams, (Object)dto, (String[])new String[0]);
        if (StringUtils.isNotEmpty((CharSequence)dto.getBussinessOrderNo()) && (strings = Arrays.asList(dto.getBussinessOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            dto.setBussinessOrderNoList(strings);
            dto.setBussinessOrderNo(null);
        }
        List countRespDto = Arrays.asList(new InPlannedOrderStatusCountRespDto[0]);
        countRespDto = StringUtils.equals((CharSequence)CsPlannedOrderTypeEnum.PRODUCT_REPAIR.getCode(), (CharSequence)dto.getOrderType()) ? this.csInventoryEsDas.productRepariOrderStatusCount(dto) : this.csInventoryEsDas.productOrderStatusCount(dto);
        return countRespDto;
    }

    @Override
    public void modifyOtherOut(CsOtherStorageOrderRespVo csOtherStorageOrderRespVo) {
        CsOtherStorageOrderEo csOtherStorageOrderEo = new CsOtherStorageOrderEo();
        DtoHelper.dto2Eo((BaseVo)csOtherStorageOrderRespVo, (BaseEo)csOtherStorageOrderEo);
        if (csOtherStorageOrderRespVo.getId() != null) {
            CsOtherStorageOrderEo eo = (CsOtherStorageOrderEo)this.csOtherStorageOrderDas.selectByPrimaryKey(csOtherStorageOrderRespVo.getId());
            if (eo == null) {
                throw new BizException("\u8be5id\u4e0d\u5b58\u5728");
            }
            this.csOtherStorageOrderDas.updateSelective((BaseEo)csOtherStorageOrderEo);
        }
    }

    @Override
    public CsOtherStorageOrderRespVo queryById(Long id) {
        CsOtherStorageOrderEo csOtherStorageOrderEo = (CsOtherStorageOrderEo)this.csOtherStorageOrderDas.selectByPrimaryKey(id);
        AssertUtil.isTrue((boolean)Objects.nonNull(csOtherStorageOrderEo), (String)"\u5176\u4ed6\u51fa\u5e93\u5355\u4e0d\u5b58\u5728");
        CsOtherStorageOrderRespVo csOtherStorageOrderRespVo = new CsOtherStorageOrderRespVo();
        DtoHelper.eo2Dto((BaseEo)csOtherStorageOrderEo, (BaseVo)csOtherStorageOrderRespVo);
        return csOtherStorageOrderRespVo;
    }
}

