/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl.express;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.biz.dto.express.EMSPackageCostChargeMode;
import com.dtyunxi.tcbj.biz.dto.express.EmsTemplateDto;
import com.dtyunxi.tcbj.biz.service.impl.express.HandlerAbstractCostReportServiceImpl;
import com.dtyunxi.tcbj.dao.eo.ExpressCostAreaEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostContractEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDetailEo;
import java.math.BigDecimal;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractCostReportService_9")
public class EmsPackageTemplateServiceImpl
extends HandlerAbstractCostReportServiceImpl {
    @Override
    public ExpressCostDetailEo calculationData(ExpressCostDetailEo eo) {
        ExpressCostDetailEo returnEo = new ExpressCostDetailEo();
        BeanUtils.copyProperties((Object)eo, (Object)returnEo);
        ExpressCostContractEo contractEo = eo.getExpressCostContractEo();
        if (contractEo != null) {
            this.converWeight(returnEo, contractEo);
            this.setWeightRange(returnEo);
            if (StringUtils.isNotBlank((CharSequence)contractEo.getParams())) {
                String params = contractEo.getParams();
                EMSPackageCostChargeMode chargeModeInfo = (EMSPackageCostChargeMode)JSON.parseObject((String)params, EMSPackageCostChargeMode.class);
                this.calculationPremium(returnEo, contractEo);
                ExpressCostAreaEo expressCostAreaEo = this.getAppointArea(eo);
                if (expressCostAreaEo != null) {
                    if (ObjectUtils.isEmpty((Object)returnEo.getChargedWeight())) {
                        this.setAbnormalCauses(returnEo, "\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a");
                        return returnEo;
                    }
                    this.calculateFreight(returnEo, expressCostAreaEo, contractEo, chargeModeInfo);
                    this.setCalculationInfo(returnEo, contractEo, expressCostAreaEo);
                } else {
                    String address = eo.getProvince();
                    String city = eo.getCity();
                    String area = eo.getArea();
                    if (StringUtils.isNotBlank((CharSequence)city)) {
                        address = address + city;
                    }
                    if (StringUtils.isNotBlank((CharSequence)area)) {
                        address = address + area;
                    }
                    this.setAbnormalCauses(returnEo, String.format("\u6839\u636e\u7701\u5e02\u533a\u3010%s\u3011\u672a\u5339\u914d\u5230\u5feb\u9012\u8fd0\u8d39\u6a21\u677f\u533a\u57df", address));
                }
            } else {
                this.setAbnormalCauses(returnEo, "\u5408\u540c\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u7a7a");
            }
        } else {
            this.setAbnormalCauses(returnEo, "\u672a\u5339\u914d\u5230\u5feb\u9012\u8fd0\u8d39\u6a21\u677f");
        }
        this.calculationAmount(returnEo);
        super.calculateOcsSystemWeight(returnEo);
        return returnEo;
    }

    private void calculateFreight(ExpressCostDetailEo returnEo, ExpressCostAreaEo expressCostAreaEo, ExpressCostContractEo costContractEo, EMSPackageCostChargeMode chargeModeInfo) {
        BigDecimal weight = returnEo.getChargedWeight();
        String params = expressCostAreaEo.getParams();
        EmsTemplateDto areaDto = (EmsTemplateDto)JSON.parseObject((String)params, EmsTemplateDto.class);
        if (weight.compareTo(chargeModeInfo.getLimitsWeight()) <= 0) {
            BigDecimal firstPrice = chargeModeInfo.getLimitsWeight().multiply(areaDto.getLimitsWeight());
            returnEo.setFirstPrice(firstPrice);
            returnEo.setFirstPricePer(firstPrice);
        } else {
            BigDecimal firstPrice = chargeModeInfo.getLimitsWeight().multiply(areaDto.getFirstWeight());
            returnEo.setFirstPrice(firstPrice);
            returnEo.setFirstPricePer(firstPrice);
            BigDecimal weight1 = weight.subtract(chargeModeInfo.getLimitsWeight()).setScale(0, 0);
            BigDecimal continuedOne = weight1.multiply(areaDto.getContinuationWeightOne());
            returnEo.setContinuedOne(continuedOne);
            returnEo.setContinuedOnePer(areaDto.getContinuationWeightOne());
        }
    }
}

