/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.CsOutNoticeOrderDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.InTransitInNoticeDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsOutNoticeOrderDetailRespDto;
import com.dtyunxi.tcbj.api.vo.Batch;
import com.dtyunxi.tcbj.api.vo.InTransitInNoticeDetailVo;
import com.dtyunxi.tcbj.biz.service.ICsOutNoticeOrderDetailService;
import com.dtyunxi.tcbj.dao.das.CsOutNoticeOrderDetailDas;
import com.dtyunxi.tcbj.dao.das.OutNoticeOrderDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.eo.CsOutNoticeOrderDetailEo;
import com.dtyunxi.tcbj.dao.eo.OutNoticeOrderEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderMapper;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsOutNoticeOrderDetailServiceImpl
implements ICsOutNoticeOrderDetailService {
    private static final Logger logger = LoggerFactory.getLogger(CsOutNoticeOrderDetailServiceImpl.class);
    @Resource
    private CsOutNoticeOrderDetailDas csOutNoticeOrderDetailDas;
    @Resource
    private OutNoticeOrderDas outNoticeOrderDas;
    @Resource
    private SaleOrderMapper saleOrderMapper;
    @Resource
    private SaleOrderDas saleOrderDas;
    @Resource
    private ObjectMapper objectMapper;

    @Override
    public Long addCsOutNoticeOrderDetail(CsOutNoticeOrderDetailReqDto addReqDto) {
        CsOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = new CsOutNoticeOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csOutNoticeOrderDetailEo);
        this.csOutNoticeOrderDetailDas.insert((BaseEo)csOutNoticeOrderDetailEo);
        return csOutNoticeOrderDetailEo.getId();
    }

    @Override
    public void modifyCsOutNoticeOrderDetail(CsOutNoticeOrderDetailReqDto modifyReqDto) {
        CsOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = new CsOutNoticeOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csOutNoticeOrderDetailEo);
        this.csOutNoticeOrderDetailDas.updateSelective((BaseEo)csOutNoticeOrderDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsOutNoticeOrderDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csOutNoticeOrderDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsOutNoticeOrderDetailRespDto queryById(Long id) {
        CsOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = (CsOutNoticeOrderDetailEo)this.csOutNoticeOrderDetailDas.selectByPrimaryKey(id);
        CsOutNoticeOrderDetailRespDto csOutNoticeOrderDetailRespDto = new CsOutNoticeOrderDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)csOutNoticeOrderDetailEo, (BaseVo)csOutNoticeOrderDetailRespDto);
        return csOutNoticeOrderDetailRespDto;
    }

    @Override
    public PageInfo<CsOutNoticeOrderDetailRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CsOutNoticeOrderDetailReqDto csOutNoticeOrderDetailReqDto = (CsOutNoticeOrderDetailReqDto)JSON.parseObject((String)filter, CsOutNoticeOrderDetailReqDto.class);
        CsOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = new CsOutNoticeOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)csOutNoticeOrderDetailReqDto, (BaseEo)csOutNoticeOrderDetailEo);
        PageInfo eoPageInfo = this.csOutNoticeOrderDetailDas.selectPage((BaseEo)csOutNoticeOrderDetailEo, pageNum, pageSize);
        return this.getCsOutNoticeOrderDetailRespDtoPageInfo((PageInfo<CsOutNoticeOrderDetailEo>)eoPageInfo);
    }

    @Override
    public List<CsOutNoticeOrderDetailRespDto> queryByNos(List<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return null;
        }
        List eos = ((ExtQueryChainWrapper)this.csOutNoticeOrderDetailDas.filter().in((Object)"document_no", orderNos)).list(Integer.valueOf(10000));
        ArrayList<CsOutNoticeOrderDetailRespDto> dtoList = new ArrayList<CsOutNoticeOrderDetailRespDto>();
        DtoHelper.eoList2DtoList((Collection)eos, dtoList, CsOutNoticeOrderDetailRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<CsOutNoticeOrderDetailRespDto> queryByPagePost(CsOutNoticeOrderDetailReqDto reqDto) {
        if (Objects.equals(reqDto.getStringCodeFlag(), 1)) {
            reqDto.setRelevanceNoList(this.saleOrderMapper.loadStringCodeData());
            if (CollectionUtil.isEmpty((Collection)reqDto.getRelevanceNoList())) {
                return new PageInfo();
            }
            reqDto.setOrderNos(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().select(new String[]{"document_no"}).in(CollectionUtil.isNotEmpty((Collection)reqDto.getRelevanceNoList()), (Object)"relevance_no", (Collection)reqDto.getRelevanceNoList())).eq((Object)"order_type", (Object)"out")).list().stream().map(OutNoticeOrderEo::getDocumentNo).collect(Collectors.toList()));
        } else if (Objects.equals(reqDto.getStringCodeFlag(), 2)) {
            return this.csOutNoticeOrderDetailDas.loadSaleOrderStringCodeNoticePage(reqDto);
        }
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.csOutNoticeOrderDetailDas.filter().setEntity(BeanUtil.copyProperties((Object)reqDto, CsOutNoticeOrderDetailEo.class, (String[])new String[0]))).in(CollectionUtil.isNotEmpty((Collection)reqDto.getOrderNos()), (Object)"document_no", (Collection)reqDto.getOrderNos())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getRelevanceNoList()), (Object)"relevance_no", (Collection)reqDto.getRelevanceNoList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getExternalOrderNos()), (Object)"external_order_no", (Collection)reqDto.getExternalOrderNos())).page(reqDto.getPageNum(), reqDto.getPageSize());
        return this.getCsOutNoticeOrderDetailRespDtoPageInfo((PageInfo<CsOutNoticeOrderDetailEo>)eoPageInfo);
    }

    private PageInfo<CsOutNoticeOrderDetailRespDto> getCsOutNoticeOrderDetailRespDtoPageInfo(PageInfo<CsOutNoticeOrderDetailEo> eoPageInfo) {
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<CsOutNoticeOrderDetailRespDto> dtoList = new ArrayList<CsOutNoticeOrderDetailRespDto>();
        for (CsOutNoticeOrderDetailEo eo : eoPageInfo.getList()) {
            CsOutNoticeOrderDetailRespDto detailRespDto = new CsOutNoticeOrderDetailRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)detailRespDto);
            detailRespDto.setLongCode(eo.getSkuCode());
            dtoList.add(detailRespDto);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<InTransitInNoticeDetailVo> inTransitInNoticeDetail(InTransitInNoticeDetailReqDto reqDto) {
        PageInfo inTransitInNoticeDetailDoPageInfo = this.outNoticeOrderDas.queryInTransitInNoticeDetail(reqDto);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)inTransitInNoticeDetailDoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List dtoList = inTransitInNoticeDetailDoPageInfo.getList().stream().map(it -> {
            InTransitInNoticeDetailVo inTransitInNoticeDetailVo = new InTransitInNoticeDetailVo();
            BeanUtils.copyProperties((Object)it, (Object)inTransitInNoticeDetailVo);
            try {
                List batches = (List)this.objectMapper.readValue(it.getBatches(), (TypeReference)new TypeReference<List<Batch>>(){});
                inTransitInNoticeDetailVo.setBatches(batches);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return inTransitInNoticeDetailVo;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CsOutNoticeOrderDetailRespDto> querySaleByPagePost(CsOutNoticeOrderDetailReqDto reqDto) {
        logger.info("\u9500\u552e\u5355\u51fa\u5e93\u901a\u77e5\u660e\u7ec6\u6570\u636e\uff1a{}", (Object)JacksonUtil.toJson((Object)reqDto));
        AssertUtils.isFalse((CollectionUtil.isEmpty((Collection)reqDto.getRelevanceNoList()) && (ObjectUtil.isEmpty((Object)reqDto.getEasVerifyTimeStartDate()) || ObjectUtil.isEmpty((Object)reqDto.getEasVerifyTimeStartDate())) ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        List saleOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.saleOrderDas.filter().select(new String[]{"sale_order_no"}).in(CollectionUtil.isNotEmpty((Collection)reqDto.getRelevanceNoList()), (Object)"sale_order_no", (Collection)reqDto.getRelevanceNoList())).ge(ObjectUtil.isNotEmpty((Object)reqDto.getEasVerifyTimeStartDate()), (Object)"eas_verify_time", (Object)reqDto.getEasVerifyTimeStartDate())).le(ObjectUtil.isNotEmpty((Object)reqDto.getEasVerifyTimeEndDate()), (Object)"eas_verify_time", (Object)reqDto.getEasVerifyTimeEndDate())).list();
        if (CollectionUtil.isNotEmpty((Collection)saleOrderEos)) {
            List saleOrderNos = saleOrderEos.stream().map(SaleOrderEo::getSaleOrderNo).collect(Collectors.toList());
            List detailEoList = ((ExtQueryChainWrapper)this.csOutNoticeOrderDetailDas.filter().in((Object)"relevance_no", saleOrderNos)).list();
            ArrayList<CsOutNoticeOrderDetailRespDto> detailRespDtoList = new ArrayList<CsOutNoticeOrderDetailRespDto>();
            DtoHelper.eoList2DtoList((Collection)detailEoList, detailRespDtoList, CsOutNoticeOrderDetailRespDto.class);
            return detailRespDtoList;
        }
        return new ArrayList<CsOutNoticeOrderDetailRespDto>();
    }
}

