/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.PhysicWarehouseStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicWarehouseStatisticsExtRespDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicWarehouseStatisticsRespDto;
import com.dtyunxi.tcbj.biz.service.IHomePageStatisticsAssistService;
import com.dtyunxi.tcbj.biz.service.IPhysicWarehouseStatisticsService;
import com.dtyunxi.tcbj.dao.das.PhysicWarehouseStatisticsDas;
import com.dtyunxi.tcbj.dao.eo.PhysicWarehouseStatisticsEo;
import com.dtyunxi.tcbj.dao.vo.NumberPlatesStatisticsVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PhysicWarehouseStatisticsServiceImpl
implements IPhysicWarehouseStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(PhysicWarehouseStatisticsServiceImpl.class);
    @Resource
    private PhysicWarehouseStatisticsDas physicWarehouseStatisticsDas;
    @Resource
    private IHomePageStatisticsAssistService homePageStatisticsAssistService;
    @Value(value="${physic.warehouse.statistics.physicWarehouseCode:ZHK}")
    public String physicWarehouseCode;

    @Override
    public Long addPhysicWarehouseStatistics(PhysicWarehouseStatisticsReqDto addReqDto) {
        PhysicWarehouseStatisticsEo physicWarehouseStatisticsEo = new PhysicWarehouseStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)physicWarehouseStatisticsEo);
        this.physicWarehouseStatisticsDas.insert((BaseEo)physicWarehouseStatisticsEo);
        return physicWarehouseStatisticsEo.getId();
    }

    @Override
    public void modifyPhysicWarehouseStatistics(PhysicWarehouseStatisticsReqDto modifyReqDto) {
        PhysicWarehouseStatisticsEo physicWarehouseStatisticsEo = new PhysicWarehouseStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)physicWarehouseStatisticsEo);
        this.physicWarehouseStatisticsDas.updateSelective((BaseEo)physicWarehouseStatisticsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePhysicWarehouseStatistics(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.physicWarehouseStatisticsDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PhysicWarehouseStatisticsRespDto queryById(Long id) {
        this.syncPhysicWarehouseStatistics();
        PhysicWarehouseStatisticsEo physicWarehouseStatisticsEo = (PhysicWarehouseStatisticsEo)this.physicWarehouseStatisticsDas.selectByPrimaryKey(id);
        PhysicWarehouseStatisticsRespDto physicWarehouseStatisticsRespDto = new PhysicWarehouseStatisticsRespDto();
        DtoHelper.eo2Dto((BaseEo)physicWarehouseStatisticsEo, (BaseVo)physicWarehouseStatisticsRespDto);
        return physicWarehouseStatisticsRespDto;
    }

    @Override
    public PageInfo<PhysicWarehouseStatisticsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PhysicWarehouseStatisticsReqDto physicWarehouseStatisticsReqDto = (PhysicWarehouseStatisticsReqDto)JSON.parseObject((String)filter, PhysicWarehouseStatisticsReqDto.class);
        PhysicWarehouseStatisticsEo physicWarehouseStatisticsEo = new PhysicWarehouseStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)physicWarehouseStatisticsReqDto, (BaseEo)physicWarehouseStatisticsEo);
        PageInfo eoPageInfo = this.physicWarehouseStatisticsDas.selectPage((BaseEo)physicWarehouseStatisticsEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PhysicWarehouseStatisticsRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void syncPhysicWarehouseStatistics() {
        List<NumberPlatesStatisticsVo> voList = this.homePageStatisticsAssistService.queryNumberPlatesStatistics();
        if (CollectionUtil.isEmpty(voList)) {
            return;
        }
        List<PhysicWarehouseStatisticsEo> eoList = this.handleData(voList);
        this.save(eoList);
    }

    @Override
    public List<PhysicWarehouseStatisticsRespDto> queryPage() {
        List<NumberPlatesStatisticsVo> voList = this.homePageStatisticsAssistService.queryNumberPlatesStatistics();
        if (CollectionUtil.isEmpty(voList)) {
            return null;
        }
        List<PhysicWarehouseStatisticsEo> eoList = this.handleData(voList);
        ArrayList<PhysicWarehouseStatisticsRespDto> dtoList = new ArrayList<PhysicWarehouseStatisticsRespDto>();
        DtoHelper.eoList2DtoList(eoList, dtoList, PhysicWarehouseStatisticsRespDto.class);
        return dtoList;
    }

    @Override
    public PhysicWarehouseStatisticsExtRespDto queryPhysicWarehouseStatistics(List<String> codeList) {
        log.info("\u9996\u9875\uff0c\u7269\u7406\u4ed3\u677f\u6570\u7edf\u8ba1\u5206\u9875\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(codeList));
        List list = ((ExtQueryChainWrapper)this.physicWarehouseStatisticsDas.filter().in(CollectionUtil.isNotEmpty(codeList), (Object)"warehouse_code", codeList)).list();
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, PhysicWarehouseStatisticsRespDto.class);
        PhysicWarehouseStatisticsExtRespDto dto = new PhysicWarehouseStatisticsExtRespDto();
        Long zhSurplusTrayNum = dto.getZhSurplusTrayNum();
        Long totalInNumber = 0L;
        Long totalOutNumber = 0L;
        Long totalStockNumber = 0L;
        Long totalIntransitNumber = 0L;
        for (PhysicWarehouseStatisticsEo eo : list) {
            String warehouseCode = eo.getWarehouseCode();
            if (Objects.equals(warehouseCode, this.physicWarehouseCode)) {
                zhSurplusTrayNum = zhSurplusTrayNum - eo.getStockNumber();
            }
            totalInNumber = totalInNumber + eo.getInNumber();
            totalOutNumber = totalOutNumber + eo.getOutNumber();
            totalStockNumber = totalStockNumber + eo.getStockNumber();
            totalIntransitNumber = totalIntransitNumber + eo.getIntransitNumber();
        }
        dto.setTotalInNumber(totalInNumber);
        dto.setTotalOutNumber(totalOutNumber);
        dto.setTotalStockNumber(totalStockNumber);
        dto.setTotalIntransitNumber(totalIntransitNumber);
        dto.setZhSurplusTrayNum(zhSurplusTrayNum);
        dto.setDetails(dtoList);
        return dto;
    }

    private void save(List<PhysicWarehouseStatisticsEo> eoList) {
        List eos = ((ExtQueryChainWrapper)this.physicWarehouseStatisticsDas.filter().in((Object)"warehouse_code", (Collection)eoList.stream().map(PhysicWarehouseStatisticsEo::getWarehouseCode).collect(Collectors.toList()))).list();
        if (CollectionUtil.isEmpty((Collection)eos)) {
            log.info("insertBatch1:{}", (Object)JSON.toJSONString(eoList));
            this.physicWarehouseStatisticsDas.insertBatch(eoList);
        } else {
            ArrayList insertEos = Lists.newArrayList();
            ArrayList updateEos = Lists.newArrayList();
            this.dataClassification(eoList, eos, insertEos, updateEos);
            if (CollectionUtil.isNotEmpty((Collection)insertEos)) {
                log.info("insertBatch2:{}", (Object)JSON.toJSONString((Object)insertEos));
                this.physicWarehouseStatisticsDas.insertBatch((List)insertEos);
            }
            if (CollectionUtil.isNotEmpty((Collection)updateEos)) {
                log.info("update:{}", (Object)JSON.toJSONString((Object)updateEos));
                updateEos.forEach(i -> this.physicWarehouseStatisticsDas.update((BaseEo)i));
            }
        }
    }

    private void dataClassification(List<PhysicWarehouseStatisticsEo> eoList, List<PhysicWarehouseStatisticsEo> eos, List<PhysicWarehouseStatisticsEo> insertEos, List<PhysicWarehouseStatisticsEo> updateEos) {
        Map eoMap = eos.stream().collect(Collectors.toMap(PhysicWarehouseStatisticsEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        eoList.stream().forEach(i -> {
            String uniqueKey = i.getWarehouseCode();
            if (eoMap.containsKey(uniqueKey)) {
                PhysicWarehouseStatisticsEo eo = (PhysicWarehouseStatisticsEo)eoMap.get(uniqueKey);
                i.setId(eo.getId());
                updateEos.add((PhysicWarehouseStatisticsEo)i);
            } else {
                insertEos.add((PhysicWarehouseStatisticsEo)i);
            }
        });
    }

    private List<PhysicWarehouseStatisticsEo> handleData(List<NumberPlatesStatisticsVo> voList) {
        return voList.stream().map(i -> {
            PhysicWarehouseStatisticsEo eo = new PhysicWarehouseStatisticsEo();
            eo.setWarehouseCode(i.getWarehouseCode());
            eo.setWarehouseName(i.getWarehouseName());
            eo.setInNumber(i.getInNumber());
            eo.setOutNumber(i.getOutNumber());
            eo.setStockNumber(i.getStockNumber());
            eo.setIntransitNumber(i.getIntransitNumber());
            return eo;
        }).collect(Collectors.toList());
    }
}

