/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl.express;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.biz.dto.express.ZtoCostChargeMode;
import com.dtyunxi.tcbj.biz.dto.express.ZtoTemplateDto;
import com.dtyunxi.tcbj.biz.enums.RenewWeightRuleEnum;
import com.dtyunxi.tcbj.biz.service.impl.express.HandlerAbstractCostReportServiceImpl;
import com.dtyunxi.tcbj.dao.eo.ExpressCostAreaEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostContractEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDetailEo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractCostReportService_6")
public class ZtoTemplateServiceImpl
extends HandlerAbstractCostReportServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ZtoTemplateServiceImpl.class);

    @Override
    public ExpressCostDetailEo calculationData(ExpressCostDetailEo eo) {
        logger.info("\u6a21\u72486calculationData\uff1a{}", (Object)JSON.toJSONString((Object)eo));
        ExpressCostDetailEo returnEo = new ExpressCostDetailEo();
        BeanUtils.copyProperties((Object)eo, (Object)returnEo);
        ExpressCostContractEo contractEo = eo.getExpressCostContractEo();
        if (contractEo != null) {
            this.calculateIncrementFreight(returnEo, contractEo);
            this.converWeight(returnEo, contractEo);
            this.setWeightRange(returnEo);
            if (StringUtils.isNotBlank((CharSequence)contractEo.getParams())) {
                String params = contractEo.getParams();
                ZtoCostChargeMode chargeModeInfo = (ZtoCostChargeMode)JSON.parseObject((String)params, ZtoCostChargeMode.class);
                this.calculationPremium(returnEo, contractEo);
                ExpressCostAreaEo expressCostAreaEo = this.getAppointArea(eo);
                if (expressCostAreaEo != null) {
                    if (ObjectUtils.isEmpty((Object)returnEo.getChargedWeight())) {
                        this.setAbnormalCauses(returnEo, "\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a");
                        return returnEo;
                    }
                    this.calculateFreight(returnEo, expressCostAreaEo, contractEo, chargeModeInfo);
                    this.setCalculationInfo(returnEo, contractEo, expressCostAreaEo);
                } else {
                    String address = eo.getProvince();
                    String city = eo.getCity();
                    String area = eo.getArea();
                    if (StringUtils.isNotBlank((CharSequence)city)) {
                        address = address + city;
                    }
                    if (StringUtils.isNotBlank((CharSequence)area)) {
                        address = address + area;
                    }
                    this.setAbnormalCauses(returnEo, String.format("\u6839\u636e\u7701\u5e02\u533a\u3010%s\u3011\u672a\u5339\u914d\u5230\u5feb\u9012\u8fd0\u8d39\u6a21\u677f\u533a\u57df", address));
                }
            } else {
                this.setAbnormalCauses(returnEo, "\u5408\u540c\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u7a7a");
            }
        } else {
            this.setAbnormalCauses(returnEo, "\u6a21\u677f\u5df2\u8fc7\u671f\u6216\u672a\u5339\u914d\u5230\u6709\u6548\u7684\u5feb\u9012\u8d39\u7528\u6a21\u677f");
        }
        this.calculationAmount(returnEo);
        super.calculateOcsSystemWeight(returnEo);
        return returnEo;
    }

    private void calculateFreight(ExpressCostDetailEo returnEo, ExpressCostAreaEo expressCostAreaEo, ExpressCostContractEo costContractEo, ZtoCostChargeMode chargeModeInfo) {
        logger.info("\u6a21\u72486calculateFreight\uff1a{}", (Object)returnEo.getWeight());
        logger.info("chargeModeInfo\uff1a{}\uff0cexpressCostAreaEo\uff1a{}", (Object)JSON.toJSONString((Object)chargeModeInfo), (Object)JSON.toJSONString((Object)expressCostAreaEo));
        BigDecimal weight = returnEo.getChargedWeight();
        String params = expressCostAreaEo.getParams();
        ZtoTemplateDto areaDto = (ZtoTemplateDto)JSON.parseObject((String)params, ZtoTemplateDto.class);
        if (chargeModeInfo.getBigWeightSwitch().booleanValue() && weight.compareTo(chargeModeInfo.getBigWeight()) > 0) {
            BigDecimal firstWeightPrice = areaDto.getFirstWeightExt();
            returnEo.setFirstPrice(firstWeightPrice);
            returnEo.setFirstPricePer(firstWeightPrice);
            BigDecimal weight1 = weight.subtract(chargeModeInfo.getBigFirstWeight());
            if (StringUtils.isNotBlank((CharSequence)costContractEo.getRenewWeightRule()) && costContractEo.getRenewWeightRule().equals(RenewWeightRuleEnum.INT_UP.getCode())) {
                weight1 = weight1.setScale(0, RoundingMode.CEILING);
            }
            returnEo.setContinuedOne(weight1.multiply(areaDto.getContinuationWeight()));
            returnEo.setContinuedOnePer(areaDto.getContinuationWeight());
        } else {
            BigDecimal continuationWeightPrice = this.stepWeightPrice(weight, areaDto, chargeModeInfo);
            returnEo.setFirstPrice(continuationWeightPrice);
            returnEo.setFirstPricePer(continuationWeightPrice);
        }
    }

    private BigDecimal stepWeightPrice(BigDecimal weight, ZtoTemplateDto areaDto, ZtoCostChargeMode chargeModeInfo) {
        if (weight.compareTo(chargeModeInfo.getFirstWeight()) <= 0) {
            return areaDto.getFirstWeight();
        }
        if (ObjectUtils.isNotEmpty((Object)chargeModeInfo.getWeightOne()) && weight.compareTo(chargeModeInfo.getWeightOne()) <= 0) {
            return areaDto.getContinuationWeightOne();
        }
        if (ObjectUtils.isNotEmpty((Object)chargeModeInfo.getWeightTwo()) && weight.compareTo(chargeModeInfo.getWeightTwo()) <= 0) {
            return areaDto.getContinuationWeightTwo();
        }
        if (ObjectUtils.isNotEmpty((Object)chargeModeInfo.getWeightThree()) && weight.compareTo(chargeModeInfo.getWeightThree()) <= 0) {
            return areaDto.getContinuationWeightThree();
        }
        if (ObjectUtils.isNotEmpty((Object)chargeModeInfo.getWeightFour()) && weight.compareTo(chargeModeInfo.getWeightFour()) <= 0) {
            return areaDto.getContinuationWeightFour();
        }
        if (ObjectUtils.isNotEmpty((Object)chargeModeInfo.getWeightFive()) && weight.compareTo(chargeModeInfo.getWeightFive()) <= 0) {
            return areaDto.getContinuationWeightFive();
        }
        if (ObjectUtils.isNotEmpty((Object)chargeModeInfo.getWeightSix()) && weight.compareTo(chargeModeInfo.getWeightSix()) <= 0) {
            return areaDto.getContinuationWeightSix();
        }
        if (ObjectUtils.isNotEmpty((Object)chargeModeInfo.getWeightSeven()) && weight.compareTo(chargeModeInfo.getWeightSeven()) <= 0) {
            return areaDto.getContinuationWeightSeven();
        }
        if (ObjectUtils.isNotEmpty((Object)chargeModeInfo.getWeightEight()) && weight.compareTo(chargeModeInfo.getWeightEight()) <= 0) {
            return areaDto.getContinuationWeightEight();
        }
        if (ObjectUtils.isNotEmpty((Object)chargeModeInfo.getWeightNine()) && weight.compareTo(chargeModeInfo.getWeightNine()) <= 0) {
            return areaDto.getContinuationWeightNine();
        }
        throw new BizException("-1", "\u5339\u914d\u4e0d\u5230\u6a21\u72486\u5bf9\u5e94\u7684\u91cd\u91cf\u533a\u95f4");
    }
}

