/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderStatisticsQueryDto;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.StatisticsDetailRespDto;
import com.dtyunxi.tcbj.biz.service.IHomePageStatisticsAssistService;
import com.dtyunxi.tcbj.biz.service.ISalesOrderStatisticsService;
import com.dtyunxi.tcbj.biz.utils.DateUtils;
import com.dtyunxi.tcbj.dao.das.SalesOrderStatisticsDas;
import com.dtyunxi.tcbj.dao.eo.SalesOrderStatisticsEo;
import com.dtyunxi.tcbj.dao.vo.OutWarehouseStatisticsVo;
import com.dtyunxi.tcbj.dao.vo.QueryStatisticVo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalesOrderStatisticsServiceImpl
implements ISalesOrderStatisticsService {
    @Resource
    private SalesOrderStatisticsDas salesOrderStatisticsDas;
    @Resource
    private IHomePageStatisticsAssistService homePageStatisticsAssistService;

    @Override
    public Long addSalesOrderStatistics(SalesOrderStatisticsReqDto addReqDto) {
        SalesOrderStatisticsEo salesOrderStatisticsEo = new SalesOrderStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)salesOrderStatisticsEo);
        this.salesOrderStatisticsDas.insert((BaseEo)salesOrderStatisticsEo);
        return salesOrderStatisticsEo.getId();
    }

    @Override
    public void modifySalesOrderStatistics(SalesOrderStatisticsReqDto modifyReqDto) {
        SalesOrderStatisticsEo salesOrderStatisticsEo = new SalesOrderStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)salesOrderStatisticsEo);
        this.salesOrderStatisticsDas.updateSelective((BaseEo)salesOrderStatisticsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSalesOrderStatistics(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.salesOrderStatisticsDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SalesOrderStatisticsRespDto queryById(Long id) {
        SalesOrderStatisticsEo salesOrderStatisticsEo = (SalesOrderStatisticsEo)this.salesOrderStatisticsDas.selectByPrimaryKey(id);
        SalesOrderStatisticsRespDto salesOrderStatisticsRespDto = new SalesOrderStatisticsRespDto();
        DtoHelper.eo2Dto((BaseEo)salesOrderStatisticsEo, (BaseVo)salesOrderStatisticsRespDto);
        return salesOrderStatisticsRespDto;
    }

    @Override
    public PageInfo<SalesOrderStatisticsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SalesOrderStatisticsReqDto salesOrderStatisticsReqDto = (SalesOrderStatisticsReqDto)JSON.parseObject((String)filter, SalesOrderStatisticsReqDto.class);
        SalesOrderStatisticsEo salesOrderStatisticsEo = new SalesOrderStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)salesOrderStatisticsReqDto, (BaseEo)salesOrderStatisticsEo);
        PageInfo eoPageInfo = this.salesOrderStatisticsDas.selectPage((BaseEo)salesOrderStatisticsEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SalesOrderStatisticsRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void syncSalesOrderStatistics(Date startDate, Date endDate) {
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList allVoList = Lists.newArrayList();
        while (true) {
            QueryStatisticVo queryVo = new QueryStatisticVo();
            queryVo.setPageSize(pageSize);
            queryVo.setPageNum(pageNum);
            queryVo.setStartTime(startDate);
            queryVo.setEndTime(endDate);
            List<OutWarehouseStatisticsVo> voList = this.homePageStatisticsAssistService.querySaleOrderStatistics(queryVo);
            if (CollectionUtil.isEmpty(voList)) break;
            allVoList.addAll(voList);
            if (voList.size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        if (CollectionUtil.isNotEmpty((Collection)allVoList)) {
            List<SalesOrderStatisticsEo> eoList = this.handleData(allVoList);
            this.save(eoList);
        }
    }

    @Override
    public List<SalesOrderStatisticsDto> salesOrderPlaceOrder(SalesOrderStatisticsQueryDto queryDto) {
        List eoList;
        String date = queryDto.getDeliverGoodsDate();
        if (StringUtils.isBlank((CharSequence)date)) {
            date = DateUtil.format((Date)new Date(), (String)DatePattern.MONTH_PATTERN.getPattern());
        }
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)this.salesOrderStatisticsDas.filter().likeRight((Object)"sale_create_date", (Object)date);
        if (queryDto.getOrganizationId() != null) {
            filter.eq((Object)"organization_id", (Object)queryDto.getOrganizationId());
        }
        if (CollectionUtil.isEmpty((Collection)(eoList = filter.list()))) {
            return Lists.newArrayList();
        }
        Map<String, List<SalesOrderStatisticsEo>> eoMap = eoList.stream().collect(Collectors.groupingBy(SalesOrderStatisticsEo::getSaleCreateDate));
        HashMap map = Maps.newHashMap();
        eoMap.forEach((key, value) -> {
            Integer day = DateUtils.getDay(key);
            ArrayList eos = Lists.newArrayList();
            Map<String, List<SalesOrderStatisticsEo>> whKeyMap = value.stream().collect(Collectors.groupingBy(SalesOrderStatisticsEo::getWarehouseCode));
            whKeyMap.forEach((k, v) -> eos.add(this.getStatisticsDetailRespDto((List<SalesOrderStatisticsEo>)v)));
            map.put(day, eos);
        });
        Integer days = DateUtils.getDays(date);
        ArrayList respList = Lists.newArrayList();
        for (int i = 1; i <= days; ++i) {
            SalesOrderStatisticsDto dto = new SalesOrderStatisticsDto();
            dto.setDate(String.format("%s%s", i, "\u53f7"));
            if (map.containsKey(i)) {
                List details = (List)map.get(i);
                Long totalNumber = 0L;
                BigDecimal totalVolume = BigDecimal.ZERO;
                for (StatisticsDetailRespDto detail : details) {
                    totalNumber = totalNumber + detail.getNumber();
                    totalVolume = totalVolume.add(detail.getVolume());
                }
                dto.setTotalVolume(totalVolume);
                dto.setTotalNumber(totalNumber);
                dto.setDetail(details);
            } else {
                dto.setDetail((List)Lists.newArrayList());
            }
            respList.add(dto);
        }
        return respList;
    }

    private StatisticsDetailRespDto getStatisticsDetailRespDto(List<SalesOrderStatisticsEo> list) {
        SalesOrderStatisticsEo soEo = list.get(0);
        StatisticsDetailRespDto shsEo = new StatisticsDetailRespDto();
        shsEo.setDeliverGoodsDate(soEo.getSaleCreateDate());
        shsEo.setWarehouseCode(soEo.getWarehouseCode());
        shsEo.setWarehouseName(soEo.getWarehouseName());
        Long number = 0L;
        BigDecimal volume = BigDecimal.ZERO;
        for (SalesOrderStatisticsEo o : list) {
            number = number + o.getNumber();
            volume = volume.add(o.getVolume());
        }
        shsEo.setNumber(number);
        shsEo.setVolume(volume);
        return shsEo;
    }

    @Transactional(rollbackFor={Exception.class})
    private void save(List<SalesOrderStatisticsEo> eoList) {
        List dateList = eoList.stream().map(SalesOrderStatisticsEo::getSaleCreateDate).distinct().collect(Collectors.toList());
        this.salesOrderStatisticsDas.deleteAll(dateList);
        this.salesOrderStatisticsDas.insertBatch(eoList);
    }

    private void dataClassification(List<SalesOrderStatisticsEo> eoList, List<SalesOrderStatisticsEo> insertEos, List<SalesOrderStatisticsEo> updateEos, List<SalesOrderStatisticsEo> eos) {
        Map eoMap = eos.stream().collect(Collectors.toMap(SalesOrderStatisticsEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        eoList.stream().forEach(i -> {
            String uniqueKey = i.getUniqueKey();
            if (eoMap.containsKey(uniqueKey)) {
                SalesOrderStatisticsEo eo = (SalesOrderStatisticsEo)eoMap.get(uniqueKey);
                i.setId(eo.getId());
                updateEos.add((SalesOrderStatisticsEo)i);
            } else {
                insertEos.add((SalesOrderStatisticsEo)i);
            }
        });
    }

    private List<SalesOrderStatisticsEo> handleData(List<OutWarehouseStatisticsVo> voList) {
        return voList.stream().map(i -> {
            SalesOrderStatisticsEo eo = new SalesOrderStatisticsEo();
            eo.setNumber(Long.valueOf(i.getNum().intValue()));
            eo.setOrganizationId(i.getOrganizationId());
            eo.setOrganizationName(i.getOrganizationName());
            eo.setWarehouseCode(i.getWarehouseCode());
            eo.setWarehouseName(i.getWarehouseName());
            eo.setSaleCreateDate(i.getSaleCreateTime());
            eo.setVolume(i.getVolume());
            return eo;
        }).collect(Collectors.toList());
    }
}

