/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.tcbj.api.dto.response.DeliveryTimeLimitExtRespDto;
import com.dtyunxi.tcbj.api.dto.response.WarehouseIssueTotalStatisticsRespDto;
import com.dtyunxi.tcbj.api.query.ItemExtDto;
import com.dtyunxi.tcbj.api.vo.DatalargescreenDeliveryTimeVo;
import com.dtyunxi.tcbj.biz.service.IHomePageStatisticsAssistService;
import com.dtyunxi.tcbj.biz.utils.DateUtils;
import com.dtyunxi.tcbj.dao.das.ItemExtendDas;
import com.dtyunxi.tcbj.dao.das.LogicInventoryDas;
import com.dtyunxi.tcbj.dao.das.LogicWarehouseDas;
import com.dtyunxi.tcbj.dao.das.LogisticInTransitDas;
import com.dtyunxi.tcbj.dao.das.OutNoticeOrderDas;
import com.dtyunxi.tcbj.dao.das.OutResultOrderDas;
import com.dtyunxi.tcbj.dao.das.PcpPhysicalTrayDas;
import com.dtyunxi.tcbj.dao.das.PhysicsInventoryTotalDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.das.ShipmentEnterpriseDas;
import com.dtyunxi.tcbj.dao.eo.ItemExtendEo;
import com.dtyunxi.tcbj.dao.eo.LogicInventoryEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.PcpPhysicalTrayEo;
import com.dtyunxi.tcbj.dao.eo.PhysicsInventoryTotalEo;
import com.dtyunxi.tcbj.dao.eo.ShipmentEnterpriseEo;
import com.dtyunxi.tcbj.dao.vo.IntransitWarehouseVo;
import com.dtyunxi.tcbj.dao.vo.ItemExtendVo;
import com.dtyunxi.tcbj.dao.vo.LogicWarehouseVo;
import com.dtyunxi.tcbj.dao.vo.LogisticInTransitVo;
import com.dtyunxi.tcbj.dao.vo.NumberPlatesStatisticsVo;
import com.dtyunxi.tcbj.dao.vo.OutAndInNumberVo;
import com.dtyunxi.tcbj.dao.vo.OutWarehouseStatisticsVo;
import com.dtyunxi.tcbj.dao.vo.PhysicsWarehouseVo;
import com.dtyunxi.tcbj.dao.vo.QueryStatisticVo;
import com.dtyunxi.tcbj.dao.vo.SaleDeliveryGoodsVo;
import com.dtyunxi.tcbj.dao.vo.TmsSignForStatisticsVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HomePageStatisticsAssistServiceImpl
implements IHomePageStatisticsAssistService {
    private static final Logger log = LoggerFactory.getLogger(HomePageStatisticsAssistServiceImpl.class);
    @Resource
    private SaleOrderDas saleOrderDas;
    @Resource
    private LogicWarehouseDas logicWarehouseDas;
    @Resource
    private OutResultOrderDas outResultOrderDas;
    @Resource
    private ExecutorService statisticsExecutor;
    @Resource
    private PhysicsInventoryTotalDas physicsInventoryTotalDas;
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource
    private PcpPhysicalTrayDas pcpPhysicalTrayDas;
    @Resource
    private LogisticInTransitDas logisticInTransitDas;
    @Resource
    private LogicInventoryDas logicInventoryDas;
    @Resource
    private OutNoticeOrderDas outNoticeOrderDas;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private ShipmentEnterpriseDas shipmentEnterpriseDas;

    @Override
    public List<OutWarehouseStatisticsVo> queryOutWarehouseStatistics(QueryStatisticVo vo) {
        return this.saleOrderDas.queryOutWarehouseStatistics(vo);
    }

    @Override
    public List<OutWarehouseStatisticsVo> queryTransferOutWarehouseStatistics(QueryStatisticVo vo) {
        return this.reTransferOrderDas.queryOutWarehouseStatistics(vo);
    }

    @Override
    public List<OutWarehouseStatisticsVo> querySaleOrderStatistics(QueryStatisticVo vo) {
        List voLists = this.saleOrderDas.querySaleOrderStatistics(vo);
        HashMap statisticMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)voLists)) {
            Set logicalWarehouseCodes = voLists.stream().map(OutWarehouseStatisticsVo::getLogicalWarehouseCode).collect(Collectors.toSet());
            List whLists = this.logicWarehouseDas.selectByWarehouse((List)Lists.newArrayList(logicalWarehouseCodes), "physics");
            if (CollectionUtil.isEmpty((Collection)whLists)) {
                log.info("\u4ed3\u5e93\u51fa\u5e93\u540c\u6b65\u65f6\u5019\uff0c\u903b\u8f91\u4ed3\u5173\u8054\u7684\u7269\u7406\u4ed3\u4e3a\u7a7a");
                return null;
            }
            Map map = ((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"warehouse_code", (Collection)Lists.newArrayList(logicalWarehouseCodes))).list().stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            Map whMap = whLists.stream().collect(Collectors.toMap(LogicWarehouseVo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            voLists.stream().forEach(i -> {
                String uniqueKey;
                String logicalWarehouseCode = i.getLogicalWarehouseCode();
                if (!whMap.containsKey(logicalWarehouseCode)) {
                    return;
                }
                LogicWarehouseVo logicWarehouseVo = (LogicWarehouseVo)whMap.get(logicalWarehouseCode);
                i.setWarehouseCode(logicWarehouseVo.getRefWarehouseCode());
                i.setWarehouseName(logicWarehouseVo.getRefWarehouseName());
                if (map.containsKey(logicalWarehouseCode)) {
                    LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)map.get(logicalWarehouseCode);
                    i.setOrganizationId(logicWarehouseEo.getOrganizationId());
                    i.setOrganizationName(logicWarehouseEo.getOrganizationName());
                }
                if (statisticMap.containsKey(uniqueKey = i.getUniqueKey())) {
                    OutWarehouseStatisticsVo saleDeliveryGoodsVo = (OutWarehouseStatisticsVo)statisticMap.get(uniqueKey);
                    if (!Objects.equals(saleDeliveryGoodsVo.getSaleOrderNo(), i.getSaleOrderNo())) {
                        saleDeliveryGoodsVo.setNum(Integer.valueOf(saleDeliveryGoodsVo.getNum() + 1));
                    }
                    saleDeliveryGoodsVo.setVolume(saleDeliveryGoodsVo.getVolume().add(i.getVolume()));
                    statisticMap.put(uniqueKey, saleDeliveryGoodsVo);
                } else {
                    i.setNum(Integer.valueOf(1));
                    statisticMap.put(uniqueKey, i);
                }
            });
        }
        return new ArrayList<OutWarehouseStatisticsVo>(statisticMap.values());
    }

    @Override
    public List<SaleDeliveryGoodsVo> querySaleDeliveryGoods(QueryStatisticVo queryStatisticVo) {
        List vos = this.outResultOrderDas.querySaleDeliveryGoods(queryStatisticVo);
        HashMap map = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)vos)) {
            Set logicalWhCodes = vos.stream().map(SaleDeliveryGoodsVo::getLogicalWarehouseCode).collect(Collectors.toSet());
            Map whMap = ((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"warehouse_code", (Collection)Lists.newArrayList(logicalWhCodes))).list().stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            vos.forEach(i -> {
                String logicalWarehouseCode = i.getLogicalWarehouseCode();
                if (!whMap.containsKey(logicalWarehouseCode)) {
                    return;
                }
                LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)whMap.get(logicalWarehouseCode);
                i.setOrganizationId(logicWarehouseEo.getOrganizationId());
                i.setOrganizationName(logicWarehouseEo.getOrganizationName());
                String uniqueKey = i.getUniqueKey();
                if (map.containsKey(uniqueKey)) {
                    SaleDeliveryGoodsVo saleDeliveryGoodsVo = (SaleDeliveryGoodsVo)map.get(uniqueKey);
                    if (!Objects.equals(saleDeliveryGoodsVo.getDocumentNo(), i.getDocumentNo())) {
                        saleDeliveryGoodsVo.setNum(Long.valueOf(saleDeliveryGoodsVo.getNum() + 1L));
                    }
                    saleDeliveryGoodsVo.setVolume(saleDeliveryGoodsVo.getVolume().add(i.getVolume()));
                    map.put(uniqueKey, saleDeliveryGoodsVo);
                } else {
                    i.setNum(Long.valueOf(1L));
                    map.put(uniqueKey, i);
                }
            });
        }
        return new ArrayList<SaleDeliveryGoodsVo>(map.values());
    }

    @Override
    public List<SaleDeliveryGoodsVo> querySaleNutritionistGoods(QueryStatisticVo vo) {
        List vos = this.outResultOrderDas.querySaleNutritionistGoods(vo);
        return vos;
    }

    @Override
    public List<SaleDeliveryGoodsVo> queryOtherDeliveryOrderGoods(QueryStatisticVo vo) {
        List vos = this.outResultOrderDas.queryOtherDeliveryOrderGoods(vo);
        return vos;
    }

    @Override
    public List<NumberPlatesStatisticsVo> queryNumberPlatesStatistics() {
        ArrayList voList = Lists.newArrayList();
        List physicsWarehouse = this.logicWarehouseDas.queryPhysicsWarehouse();
        if (CollectionUtil.isEmpty((Collection)physicsWarehouse)) {
            return voList;
        }
        CubeBeanUtils.copyCollection((Collection)voList, (Collection)physicsWarehouse, NumberPlatesStatisticsVo.class);
        List<OutAndInNumberVo> outAndInNumberVos = this.asyncQueryOutAndInNum();
        List<PhysicsWarehouseVo> physicsInventoryTotalEos = this.logicInventoryDas.queryPhysicsInventoryTotal();
        physicsInventoryTotalEos = this.getInventoryList(physicsInventoryTotalEos);
        List<PhysicsWarehouseVo> intransitInventoryTotal = this.logicInventoryDas.queryIntransitInventoryTotal();
        intransitInventoryTotal = this.getInventoryList(intransitInventoryTotal);
        log.info("\u5728\u9014\u4ed3\u5e93\u5b58______________{}", (Object)JSON.toJSONString(intransitInventoryTotal));
        List<ItemExtDto> queryItemExtList = this.queryItemExtList(outAndInNumberVos);
        List<ItemExtendVo> itemExtendVos = this.queryItemBigRatioAndTrayNum(queryItemExtList);
        return this.computeTrayNum(outAndInNumberVos, itemExtendVos, physicsWarehouse, intransitInventoryTotal, physicsInventoryTotalEos);
    }

    private List<PhysicsWarehouseVo> getInventoryList(List<PhysicsWarehouseVo> inList) {
        if (CollectionUtil.isEmpty(inList)) {
            return Lists.newArrayList();
        }
        return inList;
    }

    @Override
    public List<TmsSignForStatisticsVo> queryTmsSignForStatistics() {
        List physicsWarehouseVos = this.logicWarehouseDas.queryPhysicsWarehouse();
        List<TmsSignForStatisticsVo> tmsSignForStatisticsVos = this.calculationTmsSignForNum();
        if (CollectionUtil.isEmpty(tmsSignForStatisticsVos)) {
            return physicsWarehouseVos.stream().map(i -> {
                TmsSignForStatisticsVo vo = new TmsSignForStatisticsVo();
                vo.setWarehouseCode(i.getWarehouseCode());
                vo.setWarehouseName(i.getWarehouseName());
                return vo;
            }).collect(Collectors.toList());
        }
        ArrayList<TmsSignForStatisticsVo> voList = new ArrayList<TmsSignForStatisticsVo>();
        Map<String, List<TmsSignForStatisticsVo>> map = tmsSignForStatisticsVos.stream().collect(Collectors.groupingBy(TmsSignForStatisticsVo::getWarehouseCode));
        physicsWarehouseVos.forEach(i -> {
            if (map.containsKey(i.getWarehouseCode())) {
                List list = (List)map.get(i.getWarehouseCode());
                list.forEach(j -> {
                    TmsSignForStatisticsVo vo = new TmsSignForStatisticsVo();
                    vo.setWarehouseCode(i.getWarehouseCode());
                    vo.setWarehouseName(i.getWarehouseName());
                    vo.setBillType(j.getBillType());
                    vo.setOvertimeSigned(j.getOvertimeSigned());
                    vo.setOvertimeNotSigned(j.getOvertimeNotSigned());
                    vo.setSigned(j.getSigned());
                    vo.setIntransit(j.getIntransit());
                    vo.setAbnormal(j.getAbnormal());
                    voList.add(vo);
                });
            } else {
                TmsSignForStatisticsVo vo = new TmsSignForStatisticsVo();
                vo.setWarehouseCode(i.getWarehouseCode());
                vo.setWarehouseName(i.getWarehouseName());
                voList.add(vo);
            }
        });
        return voList;
    }

    @Override
    public WarehouseIssueTotalStatisticsRespDto queryTotalStatistics() {
        List numList;
        WarehouseIssueTotalStatisticsRespDto dto = new WarehouseIssueTotalStatisticsRespDto();
        List volumeList = this.saleOrderDas.queryTotalStatisticsVolume();
        if (CollectionUtil.isNotEmpty((Collection)volumeList)) {
            volumeList.forEach(i -> {
                String status = i.getStatus();
                if (Objects.equals(status, "COMPLETE")) {
                    dto.setIssuedVolume(i.getVolume());
                }
                if (Objects.equals(status, "WAIT_DELIVERY")) {
                    dto.setNotIssuedVolume(i.getVolume());
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)(numList = this.saleOrderDas.queryTotalStatisticsNum()))) {
            numList.forEach(i -> {
                String status = i.getStatus();
                if (Objects.equals(status, "COMPLETE")) {
                    dto.setIssuedNumber(i.getNum());
                }
                if (Objects.equals(status, "WAIT_DELIVERY")) {
                    dto.setNotIssuedNum(i.getNum());
                }
            });
        }
        return dto;
    }

    @Override
    public DatalargescreenDeliveryTimeVo queryDeliveryTimeLimit(String warehouseCode) {
        DatalargescreenDeliveryTimeVo deliveryTimeLimitExtRespDto = new DatalargescreenDeliveryTimeVo();
        List<DeliveryTimeLimitExtRespDto> list = this.queryDeliveryTime();
        if (CollectionUtil.isEmpty(list)) {
            return deliveryTimeLimitExtRespDto;
        }
        Map<String, List<DatalargescreenDeliveryTimeVo>> map = list.stream().map(e -> {
            DatalargescreenDeliveryTimeVo vo = new DatalargescreenDeliveryTimeVo();
            BeanUtil.copyProperties((Object)e, (Object)vo, (String[])new String[0]);
            if (e.getPushTime() != null) {
                vo.setPushTime(DateUtil.getDateFormat((Date)e.getPushTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (e.getWarehouseTime() != null) {
                vo.setWarehouseTime(DateUtil.getDateFormat((Date)e.getWarehouseTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (e.getWarehouseTime() != null && e.getPushTime() != null) {
                Long pushTime = e.getPushTime().getTime();
                Long warehouseTime = e.getWarehouseTime().getTime();
                String str = String.format("%s", warehouseTime - pushTime);
                vo.setDeliveryTime(Double.valueOf(Double.parseDouble(str)));
            }
            return vo;
        }).collect(Collectors.groupingBy(DatalargescreenDeliveryTimeVo::getWarehouseCode));
        List<Object> dtoList = Lists.newArrayList();
        ArrayList finalDtoList = dtoList;
        map.forEach((key, value) -> {
            DatalargescreenDeliveryTimeVo dto = (DatalargescreenDeliveryTimeVo)value.get(0);
            double avDeliverTime = value.stream().mapToDouble(DatalargescreenDeliveryTimeVo::getDeliveryTime).average().getAsDouble();
            dto.setAvDeliveryTime(Double.valueOf(new BigDecimal(avDeliverTime / 8.64E7).setScale(4, RoundingMode.HALF_UP).doubleValue()));
            dto.setOrderQuantity(Integer.valueOf(value.size()));
            finalDtoList.add(dto);
        });
        dtoList = finalDtoList.stream().sorted(Comparator.comparing(DatalargescreenDeliveryTimeVo::getAvDeliveryTime).reversed()).collect(Collectors.toList());
        BigDecimal calculated = BigDecimal.ZERO;
        int totalCount = list.size();
        for (int i = 0; i < dtoList.size(); ++i) {
            DatalargescreenDeliveryTimeVo dto = (DatalargescreenDeliveryTimeVo)dtoList.get(i);
            BigDecimal proportion = BigDecimal.ZERO;
            if (i == dtoList.size() - 1) {
                proportion = BigDecimal.ONE.subtract(calculated);
            } else {
                Integer orderQuantity = dto.getOrderQuantity();
                proportion = BigDecimal.valueOf(orderQuantity.intValue()).divide(BigDecimal.valueOf(totalCount), 2, 1);
                calculated = calculated.add(proportion);
            }
            dto.setProportion(proportion.multiply(BigDecimal.valueOf(100L)).setScale(0).toString());
            if (!Objects.equals(dto.getWarehouseCode(), warehouseCode)) continue;
            deliveryTimeLimitExtRespDto = dto;
        }
        return deliveryTimeLimitExtRespDto;
    }

    private List<DeliveryTimeLimitExtRespDto> queryDeliveryTime() {
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList allVoList = Lists.newArrayList();
        while (true) {
            QueryStatisticVo queryVo = new QueryStatisticVo();
            queryVo.setPageSize(pageSize);
            queryVo.setPageNum(pageNum);
            List voList = this.outNoticeOrderDas.queryDeliveryTimeLimit(queryVo);
            if (CollectionUtil.isEmpty((Collection)voList)) break;
            allVoList.addAll(voList);
            if (voList.size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        return allVoList;
    }

    private List<TmsSignForStatisticsVo> calculationTmsSignForNum() {
        List transitVos;
        ArrayList voList = Lists.newArrayList();
        List<Object> codes = Lists.newArrayList();
        List shipmentList = ((ExtQueryChainWrapper)this.shipmentEnterpriseDas.filter().eq((Object)"shipment_enterprise_type", (Object)1)).list(Integer.valueOf(1000));
        if (CollectionUtil.isNotEmpty((Collection)shipmentList)) {
            codes = shipmentList.stream().map(ShipmentEnterpriseEo::getShipmentEnterpriseCode).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty((Collection)(transitVos = this.logisticInTransitDas.queryLogisticInTransit((List)codes)))) {
            Map<String, List<LogisticInTransitVo>> transitTypeMap = transitVos.stream().collect(Collectors.groupingBy(LogisticInTransitVo::getUniqueKey));
            for (Map.Entry<String, List<LogisticInTransitVo>> next : transitTypeMap.entrySet()) {
                voList.add(this.getTmsSignForStatisticsVo(next));
            }
        }
        return voList;
    }

    private TmsSignForStatisticsVo getTmsSignForStatisticsVo(Map.Entry<String, List<LogisticInTransitVo>> next) {
        String key = next.getKey();
        String[] keyArr = key.split(";");
        String physicsWarehouseCode = keyArr[0];
        String businessType = keyArr[1];
        TmsSignForStatisticsVo tmsVo = new TmsSignForStatisticsVo();
        tmsVo.setBillType(businessType);
        tmsVo.setWarehouseCode(physicsWarehouseCode);
        this.calculationNum(next.getValue(), tmsVo);
        return tmsVo;
    }

    private void calculationNum(List<LogisticInTransitVo> value, TmsSignForStatisticsVo tmsVo) {
        Long overtimeNotSigned = 0L;
        Long intransit = 0L;
        Long overtimeSigned = 0L;
        Long signed = 0L;
        Long abnormal = 0L;
        ArrayList list = value.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LogisticInTransitVo>(Comparator.comparing(LogisticInTransitVo::getOutResultOrderId))), ArrayList::new));
        for (LogisticInTransitVo vo : list) {
            Integer overtimeStatus = vo.getOvertimeStatus();
            if (Objects.equals(1, overtimeStatus)) {
                intransit = intransit + 1L;
                continue;
            }
            if (Objects.equals(2, overtimeStatus)) {
                abnormal = abnormal + 1L;
                continue;
            }
            if (Objects.equals(3, overtimeStatus)) {
                overtimeNotSigned = overtimeNotSigned + 1L;
                continue;
            }
            if (Objects.equals(4, overtimeStatus)) {
                overtimeSigned = overtimeSigned + 1L;
                continue;
            }
            if (!Objects.equals(5, overtimeStatus)) continue;
            signed = signed + 1L;
        }
        tmsVo.setIntransit(intransit);
        tmsVo.setOvertimeNotSigned(overtimeNotSigned);
        tmsVo.setOvertimeSigned(overtimeSigned);
        tmsVo.setSigned(signed);
        tmsVo.setAbnormal(abnormal);
    }

    private static boolean overtimeFlag(Date expectedArrivalTime, Date actualArrivalTim) {
        if (actualArrivalTim != null) {
            return expectedArrivalTime.before(actualArrivalTim);
        }
        return expectedArrivalTime.before(new Date());
    }

    private List<NumberPlatesStatisticsVo> computeTrayNum(List<OutAndInNumberVo> outAndInNumberVos, List<ItemExtendVo> itemExtendVos, List<PhysicsWarehouseVo> physicsWarehouse, List<PhysicsWarehouseVo> intransitInventoryTotal, List<PhysicsWarehouseVo> physicsInventoryTotalEos) {
        ArrayList voList = Lists.newArrayList();
        Map<Object, Object> itemExtMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(itemExtendVos)) {
            itemExtMap = itemExtendVos.stream().collect(Collectors.toMap(ItemExtendVo::getItemCode, Function.identity(), (k1, k2) -> k1));
        }
        Map<Object, Object> outAndInMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(outAndInNumberVos)) {
            outAndInMap = outAndInNumberVos.stream().collect(Collectors.groupingBy(OutAndInNumberVo::getPhysicsWarehouseCode));
        }
        Map totalPhysicsBalanceMap = physicsInventoryTotalEos.stream().collect(Collectors.toMap(PhysicsWarehouseVo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map totalIntransitBalanceMap = intransitInventoryTotal.stream().collect(Collectors.toMap(PhysicsWarehouseVo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        for (PhysicsWarehouseVo i : physicsWarehouse) {
            NumberPlatesStatisticsVo vo = new NumberPlatesStatisticsVo();
            vo.setIntransitNumber(Long.valueOf(0L));
            vo.setWarehouseCode(i.getWarehouseCode());
            vo.setWarehouseName(i.getWarehouseName());
            this.computeOutAndInTrayNum(outAndInMap, i.getWarehouseCode(), itemExtMap, vo);
            if (totalIntransitBalanceMap.containsKey(i.getWarehouseCode())) {
                PhysicsWarehouseVo warehouseVo = (PhysicsWarehouseVo)totalIntransitBalanceMap.get(i.getWarehouseCode());
                vo.setIntransitNumber(Long.valueOf(Optional.ofNullable(warehouseVo.getSumBord()).orElse(BigDecimal.ZERO).longValue()));
            } else {
                vo.setIntransitNumber(Long.valueOf(0L));
            }
            if (totalPhysicsBalanceMap.containsKey(i.getWarehouseCode())) {
                PhysicsWarehouseVo vos = (PhysicsWarehouseVo)totalPhysicsBalanceMap.get(i.getWarehouseCode());
                vo.setStockNumber(Long.valueOf(Optional.ofNullable(vos.getSumBord()).orElse(BigDecimal.ZERO).longValue()));
            } else {
                vo.setStockNumber(Long.valueOf(0L));
            }
            voList.add(vo);
        }
        return voList;
    }

    private Map<String, Long> getTotalBalanceMap(List<PhysicsWarehouseVo> list) {
        Map<String, List<PhysicsWarehouseVo>> physicsBalanceMap = list.stream().collect(Collectors.groupingBy(PhysicsWarehouseVo::getWarehouseCode));
        HashMap mapBalance = Maps.newHashMap();
        physicsBalanceMap.forEach((physicsCode, eos) -> {
            Map<String, List<PhysicsWarehouseVo>> itemGroupMap = eos.stream().collect(Collectors.groupingBy(PhysicsWarehouseVo::getCargoCode));
            AtomicReference<Long> stockNumber = new AtomicReference<Long>(0L);
            itemGroupMap.forEach((k, v) -> {
                BigDecimal balance = v.stream().map(PhysicsWarehouseVo::getSumBord).filter(sumBord -> !Objects.isNull(sumBord)).reduce(BigDecimal.ZERO, BigDecimal::add);
                stockNumber.updateAndGet(v1 -> v1 + balance.longValue());
            });
            mapBalance.put(physicsCode, stockNumber.get());
        });
        return mapBalance;
    }

    public static void main(String[] args) {
        String s = String.format("%s%s", BigDecimal.valueOf(0.88).multiply(BigDecimal.valueOf(100L)).setScale(0), "%");
        System.out.println(s);
    }

    private void inTransitTrayNum(Map<String, List<LogicInventoryEo>> map, String warehouseCode, Map<String, ItemExtendVo> itemExtMap, NumberPlatesStatisticsVo vo) {
        if (CollectionUtil.isEmpty(map)) {
            return;
        }
        Long inTransitNumber = 0L;
        if (map.containsKey(warehouseCode)) {
            List<LogicInventoryEo> logicInventoryEos = map.get(warehouseCode);
            for (LogicInventoryEo i : logicInventoryEos) {
                String cargoCode = i.getSkuCode();
                if (!itemExtMap.containsKey(cargoCode)) continue;
                ItemExtendVo itemExtendVo = itemExtMap.get(cargoCode);
                Long bigRatio = itemExtendVo.getBigBox();
                Map warehouseTrayNumMap = itemExtendVo.getWarehouseTrayNumMap();
                Long trayNum = itemExtendVo.getZhTrayNum();
                if (warehouseTrayNumMap.containsKey(warehouseCode)) {
                    trayNum = (Long)warehouseTrayNumMap.get(warehouseCode);
                }
                inTransitNumber = inTransitNumber + i.getBalance().divide(BigDecimal.valueOf(bigRatio), 5, 0).divide(BigDecimal.valueOf(trayNum), 0, 0).longValue();
            }
        }
        vo.setIntransitNumber(inTransitNumber);
    }

    private void computeOutAndInTrayNum(Map<String, List<OutAndInNumberVo>> outAndInMap, String warehouseCode, Map<String, ItemExtendVo> itemExtMap, NumberPlatesStatisticsVo vo) {
        Long inNumber = 0L;
        Long outNumber = 0L;
        if (CollectionUtil.isNotEmpty(outAndInMap) && outAndInMap.containsKey(warehouseCode)) {
            List<OutAndInNumberVo> in;
            List<OutAndInNumberVo> outAndInLists = outAndInMap.get(warehouseCode);
            Map<String, List<OutAndInNumberVo>> orderTypeMap = outAndInLists.stream().collect(Collectors.groupingBy(OutAndInNumberVo::getOrderType));
            List<OutAndInNumberVo> out = orderTypeMap.get("out");
            if (CollectionUtil.isNotEmpty(out)) {
                outNumber = (long)out.get(0).getNum();
            }
            if (CollectionUtil.isNotEmpty(in = orderTypeMap.get("in"))) {
                inNumber = (long)in.get(0).getNum();
            }
        }
        vo.setInNumber(inNumber);
        vo.setOutNumber(outNumber);
    }

    private Long computeOutOrInTrayNum(Map<String, List<OutAndInNumberVo>> outItemMap, String warehouseCode, Map<String, ItemExtendVo> finalItemExtMap) {
        Iterator<Map.Entry<String, List<OutAndInNumberVo>>> iterator = outItemMap.entrySet().iterator();
        Long number = 0L;
        while (iterator.hasNext()) {
            Map.Entry<String, List<OutAndInNumberVo>> next = iterator.next();
            List<OutAndInNumberVo> v1 = next.getValue();
            String key = next.getKey();
            Integer totalItemNum = v1.stream().collect(Collectors.summingInt(OutAndInNumberVo::getNum));
            if (!CollectionUtil.isNotEmpty(finalItemExtMap) || !finalItemExtMap.containsKey(key)) continue;
            ItemExtendVo itemExtendVo = finalItemExtMap.get(key);
            Long bigRatio = itemExtendVo.getBigBox();
            Map warehouseTrayNumMap = itemExtendVo.getWarehouseTrayNumMap();
            Long trayNum = itemExtendVo.getZhTrayNum();
            if (warehouseTrayNumMap.containsKey(warehouseCode)) {
                trayNum = (Long)warehouseTrayNumMap.get(warehouseCode);
            }
            number = number + BigDecimal.valueOf(totalItemNum.intValue()).divide(BigDecimal.valueOf(bigRatio), 5, 0).divide(BigDecimal.valueOf(trayNum), 0, 0).longValue();
        }
        return number;
    }

    private void computePhysicsBBalanceTrayNum(Map<String, List<PhysicsInventoryTotalEo>> physicsBalanceMap, String warehouseCode, Map<String, ItemExtendVo> itemExtMap, NumberPlatesStatisticsVo vo) {
        Long stockNumber = 0L;
        if (CollectionUtil.isNotEmpty(physicsBalanceMap) && physicsBalanceMap.containsKey(warehouseCode)) {
            List<PhysicsInventoryTotalEo> physicsInventory = physicsBalanceMap.get(warehouseCode);
            Map<String, List<PhysicsInventoryTotalEo>> physicsBalanceItemMap = physicsInventory.stream().collect(Collectors.groupingBy(PhysicsInventoryTotalEo::getLongCode));
            stockNumber = stockNumber + this.computePhysicsBalance(physicsBalanceItemMap, warehouseCode, itemExtMap);
        }
        vo.setStockNumber(stockNumber);
    }

    private Long computePhysicsBalance(Map<String, List<PhysicsInventoryTotalEo>> physicsBBalanceMap, String warehouseCode, Map<String, ItemExtendVo> finalItemExtMap) {
        Iterator<Map.Entry<String, List<PhysicsInventoryTotalEo>>> iterator = physicsBBalanceMap.entrySet().iterator();
        Long number = 0L;
        while (iterator.hasNext()) {
            Map.Entry<String, List<PhysicsInventoryTotalEo>> next = iterator.next();
            List<PhysicsInventoryTotalEo> v1 = next.getValue();
            String key = next.getKey();
            Integer totalItemNum = v1.stream().map(i -> i.getBalance()).reduce(BigDecimal.ZERO, BigDecimal::add).intValue();
            if (!CollectionUtil.isNotEmpty(finalItemExtMap) || !finalItemExtMap.containsKey(key)) continue;
            ItemExtendVo itemExtendVo = finalItemExtMap.get(key);
            Long bigRatio = itemExtendVo.getBigBox();
            Map warehouseTrayNumMap = itemExtendVo.getWarehouseTrayNumMap();
            Long trayNum = itemExtendVo.getZhTrayNum();
            if (warehouseTrayNumMap.containsKey(warehouseCode)) {
                trayNum = (Long)warehouseTrayNumMap.get(warehouseCode);
            }
            log.info("number:{},totalItemNum:{},bigRatio:{},trayNum:{},itemExtendVo:{}", new Object[]{number, totalItemNum, bigRatio, trayNum, JSON.toJSON((Object)itemExtendVo)});
            number = number + BigDecimal.valueOf(totalItemNum.intValue()).divide(BigDecimal.valueOf(bigRatio), 5, 0).divide(BigDecimal.valueOf(trayNum), 0, 0).longValue();
        }
        return number;
    }

    private List<ItemExtendVo> queryItemBigRatioAndTrayNum(List<ItemExtDto> queryItemExtList) {
        if (CollectionUtil.isEmpty(queryItemExtList)) {
            return null;
        }
        Set longCodes = queryItemExtList.stream().map(ItemExtDto::getItemLongCode).collect(Collectors.toSet());
        List extendEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"item_code", (Collection)Lists.newArrayList(longCodes))).gt((Object)"zh_tray_num", (Object)0)).gt((Object)"big_box", (Object)0)).list(Integer.valueOf(longCodes.size()));
        if (CollectionUtil.isEmpty((Collection)extendEos)) {
            return null;
        }
        ArrayList itemExtendVos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemExtendVos, (Collection)extendEos, ItemExtendVo.class);
        HashMap itemExtMap = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        for (ItemExtendEo extendEo : extendEos) {
            ids.add(extendEo.getId());
            itemExtMap.put(extendEo.getItemCode(), extendEo);
        }
        List physicalTrayEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pcpPhysicalTrayDas.filter().in((Object)"item_id", (Collection)ids)).gt((Object)"tray_num", (Object)0)).list(Integer.valueOf(ids.size() * 5));
        if (CollectionUtil.isEmpty((Collection)physicalTrayEos)) {
            return itemExtendVos;
        }
        Map<Long, List<PcpPhysicalTrayEo>> physicalTrayMap = physicalTrayEos.stream().collect(Collectors.groupingBy(PcpPhysicalTrayEo::getItemId));
        itemExtendVos.forEach(i -> {
            Long id = i.getId();
            if (physicalTrayMap.containsKey(id)) {
                List trayEos = (List)physicalTrayMap.get(id);
                Map<String, Long> map = trayEos.stream().collect(Collectors.toMap(PcpPhysicalTrayEo::getPhysicalWarehouseCode, PcpPhysicalTrayEo::getTrayNum));
                i.setWarehouseTrayNumMap(map);
            }
        });
        return itemExtendVos;
    }

    private List<LogicInventoryEo> queryTransitStock(Set<String> physicsCodes) {
        if (CollectionUtil.isEmpty(physicsCodes)) {
            return null;
        }
        ArrayList intransitWarehouseVoList = Lists.newArrayList();
        physicsCodes.stream().forEach(i -> {
            List intransitWarehouseVos = this.logicWarehouseDas.queryIntransitWarehouseByPhysicsCode(i);
            if (CollectionUtil.isEmpty((Collection)intransitWarehouseVos)) {
                return;
            }
            intransitWarehouseVos.forEach(j -> j.setPhysicsCode(i));
            intransitWarehouseVoList.addAll(intransitWarehouseVos);
        });
        if (CollectionUtil.isEmpty((Collection)intransitWarehouseVoList)) {
            return null;
        }
        Set<String> codes = intransitWarehouseVoList.stream().map(IntransitWarehouseVo::getIntransitCode).collect(Collectors.toSet());
        List<LogicInventoryEo> logicInventoryEos = this.asyncQueryLogicInventoryTotal(codes);
        if (CollectionUtil.isEmpty(logicInventoryEos)) {
            return null;
        }
        Map<String, String> whMap = intransitWarehouseVoList.stream().collect(Collectors.toMap(i -> i.getIntransitCode(), h -> h.getPhysicsCode(), (k1, k2) -> k1));
        logicInventoryEos.forEach(i -> {
            if (whMap.containsKey(i.getWarehouseCode())) {
                i.setPhysicsCode((String)whMap.get(i.getWarehouseCode()));
            }
        });
        return logicInventoryEos;
    }

    private List<ItemExtDto> queryItemExtList(List<OutAndInNumberVo> outAndInNumberVos) {
        HashSet queryItemExSet = Sets.newHashSet();
        if (CollectionUtil.isNotEmpty(outAndInNumberVos)) {
            queryItemExSet.addAll(outAndInNumberVos.stream().map(i -> {
                ItemExtDto dto = new ItemExtDto();
                dto.setWarehouseCode(i.getPhysicsWarehouseCode());
                dto.setItemLongCode(i.getLongCode());
                return dto;
            }).collect(Collectors.toSet()));
        }
        return Lists.newArrayList((Iterable)queryItemExSet);
    }

    private List<PhysicsInventoryTotalEo> asyncQueryPhysicsInventoryTotal() {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.getPhysicsInventoryTotal(), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u7269\u7406\u4ed3\u603b\u5e93\u5b58\u6570\u91cf\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private List<LogicInventoryEo> asyncQueryLogicInventoryTotal(Set<String> codes) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.queryLogicInventoryTotal(codes), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u7269\u7406\u4ed3\u603b\u5e93\u5b58\u6570\u91cf\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private List<LogicInventoryEo> queryLogicInventoryTotal(Set<String> codes) {
        PageInfo page;
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList eoList = Lists.newArrayList();
        while ((page = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDas.filter().in((Object)"warehouse_code", codes)).gt((Object)"balance", (Object)0)).page(pageNum, pageSize)) != null && !CollectionUtil.isEmpty((Collection)page.getList())) {
            eoList.addAll(page.getList());
            if (page.getList().size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        return eoList;
    }

    private List<PhysicsInventoryTotalEo> getPhysicsInventoryTotal() {
        PageInfo page;
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList eoList = Lists.newArrayList();
        while ((page = ((ExtQueryChainWrapper)this.physicsInventoryTotalDas.filter().isNotNull((Object)"balance")).page(pageNum, pageSize)) != null && !CollectionUtil.isEmpty((Collection)page.getList())) {
            eoList.addAll(page.getList());
            if (page.getList().size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        return eoList;
    }

    private List<OutAndInNumberVo> asyncQueryOutAndInNum() {
        try {
            QueryStatisticVo vo = new QueryStatisticVo();
            vo.setStartTime(DateUtils.getBeginDayOfYesterday());
            vo.setEndTime(DateUtils.getEndDayOfYesterday());
            CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.outResultOrderDas.queryOutAndInNum(vo), this.statisticsExecutor);
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u51fa\u5165\u5e93\u6570\u91cf\u9519\u8bef", (Throwable)e);
            return null;
        }
    }
}

