/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.FeeAttributionConfigDetailQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordExtReqDto;
import com.dtyunxi.finance.api.dto.response.FeeAttributionConfigRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkQueryRespDto;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.finance.api.query.FeeAttributionConfigApi;
import com.dtyunxi.finance.api.query.ILogisticQueryApi;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticDataTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticDocumentTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.AgainCalculateReqDto;
import com.dtyunxi.tcbj.api.dto.request.CalculationDto;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportEditReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportQueryListDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticOperateReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.api.dto.request.OutResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.DailyDeliveryFeeFilterExtConfigRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticsReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.OutNoticeOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.biz.factory.GateWayFactory;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryFeeFilterExtConfigService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticsReportService;
import com.dtyunxi.tcbj.biz.service.IOutNoticeOrderService;
import com.dtyunxi.tcbj.biz.service.IOutResultOrderService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.biz.utils.DateUtil;
import com.dtyunxi.tcbj.biz.utils.GeoAddressInfo;
import com.dtyunxi.tcbj.biz.utils.LbsUtil;
import com.dtyunxi.tcbj.dao.Constants.CsShipmentLogisticsTypeEnum;
import com.dtyunxi.tcbj.dao.das.AdjustmentInventoryDas;
import com.dtyunxi.tcbj.dao.das.CsOtherStorageOrderDas;
import com.dtyunxi.tcbj.dao.das.FeeAttributionConfigDas;
import com.dtyunxi.tcbj.dao.das.FinLogisticDetailDas;
import com.dtyunxi.tcbj.dao.das.FinLogisticsReportDas;
import com.dtyunxi.tcbj.dao.das.InventorySupplierDas;
import com.dtyunxi.tcbj.dao.das.LogicWarehouseDas;
import com.dtyunxi.tcbj.dao.das.LogisticsRecordDas;
import com.dtyunxi.tcbj.dao.das.OutPlannedOrderDas;
import com.dtyunxi.tcbj.dao.das.PcpRegionDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.das.ReWarehouseAddressDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.das.ShipmentEnterpriseDas;
import com.dtyunxi.tcbj.dao.eo.AdjustmentInventoryEo;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.CsWarehouseAddressEo;
import com.dtyunxi.tcbj.dao.eo.FeeAttributionConfigEo;
import com.dtyunxi.tcbj.dao.eo.FinLogisticDetailEo;
import com.dtyunxi.tcbj.dao.eo.FinLogisticsReportEo;
import com.dtyunxi.tcbj.dao.eo.InventorySupplierEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.LogisticsRecordEo;
import com.dtyunxi.tcbj.dao.eo.OutPlannedOrderEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderEo;
import com.dtyunxi.tcbj.dao.eo.PcpRegionEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.eo.ShipmentEnterpriseEo;
import com.dtyunxi.tcbj.dao.eo.es.CsOtherStorageOrderEo;
import com.dtyunxi.tcbj.dao.vo.OrderInfoVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportDomain;
import com.yunxi.dg.base.center.report.dto.constants.SaleBusinessTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryFeeFilterConfigMatchResultDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryReportListQueryDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryFeeFilterConfigService;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinLogisticsReportServiceImpl
implements IFinLogisticsReportService {
    private static Logger logger = LoggerFactory.getLogger(FinLogisticsReportServiceImpl.class);
    @Resource
    private ReWarehouseAddressDas reWarehouseAddressDas;
    @Resource
    private IOutNoticeOrderService outNoticeOrderService;
    @Resource
    private IOutResultOrderService outResultOrderService;
    @Resource
    private IDailyDeliveryReportService dailyDeliveryReportService;
    @Resource
    private FinLogisticsReportDas finLogisticsReportDas;
    @Resource
    private IFinLogisticDetailService finLogisticDetailService;
    @Resource
    private ILogisticQueryApi logisticQueryApi;
    @Resource
    private FeeAttributionConfigApi feeAttributionConfigApi;
    @Resource
    private IDailyDeliveryFeeFilterConfigService feeFilterService;
    @Resource
    private IDailyDeliveryFeeFilterExtConfigService dailyDeliveryFeeFilterExtConfigService;
    @Resource
    private LogicWarehouseDas logicWarehouseDas;
    @Resource
    private FeeAttributionConfigDas feeAttributionConfigDas;
    @Resource
    private CsOtherStorageOrderDas otherStorageOrderDas;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private OutPlannedOrderDas outPlannedOrderDas;
    @Resource
    private InventorySupplierDas inventorySupplierDas;
    @Resource
    private FinLogisticDetailDas finLogisticDetailDas;
    @Resource
    private LogisticsRecordDas logisticsRecordDas;
    @Resource
    private ShipmentEnterpriseDas shipmentEnterpriseDas;
    @Resource
    private SaleOrderDas saleOrderDas;
    @Resource
    private ExecutorService statisticsExecutor;
    @Resource
    private IDailyDeliveryFeeFilterConfigService dailyDeliveryFeeFilterConfigService;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private PcpRegionDas regionDas;
    @Resource
    private AdjustmentInventoryDas adjustmentInventoryDas;
    @Resource
    private IDailyDeliveryReportDomain dailyDeliveryReportDomain;
    @Resource
    private LbsUtil lbsUtil;
    private static List<String> saleOrderBusinessType = com.google.common.collect.Lists.newArrayList();
    private static List<String> transferOrderBusinessType = com.google.common.collect.Lists.newArrayList();
    private static List<String> refundOrderBusinessType = com.google.common.collect.Lists.newArrayList();
    private static List<String> otherOrderBusinessType = com.google.common.collect.Lists.newArrayList();

    @Override
    public Long addFinLogisticsReport(FinLogisticsReportReqDto addReqDto) {
        FinLogisticsReportEo finLogisticsReportEo = new FinLogisticsReportEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)finLogisticsReportEo);
        this.finLogisticsReportDas.insert((BaseEo)finLogisticsReportEo);
        return finLogisticsReportEo.getId();
    }

    @Override
    public Long addFinLogistics(FinLogisticsReportDto reportDtoList) {
        FinLogisticsReportEo finLogisticsReportEo = new FinLogisticsReportEo();
        DtoHelper.dto2Eo((BaseVo)reportDtoList, (BaseEo)finLogisticsReportEo);
        this.finLogisticsReportDas.insert((BaseEo)finLogisticsReportEo);
        return finLogisticsReportEo.getId();
    }

    public Long addFinLogisticDetail(FinLogisticDetailRespDto detailRespDto) {
        FinLogisticsReportEo finLogisticsReportEo = new FinLogisticsReportEo();
        DtoHelper.dto2Eo((BaseVo)detailRespDto, (BaseEo)finLogisticsReportEo);
        this.finLogisticsReportDas.insert((BaseEo)finLogisticsReportEo);
        logger.info("addFinLogisticDetail finLogisticsReportEo={}", (Object)JSONObject.toJSONString((Object)finLogisticsReportEo));
        return finLogisticsReportEo.getId();
    }

    @Override
    public void modifyFinLogisticsReport(FinLogisticsReportReqDto modifyReqDto) {
        FinLogisticsReportEo finLogisticsReportEo = new FinLogisticsReportEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)finLogisticsReportEo);
        this.finLogisticsReportDas.updateSelective((BaseEo)finLogisticsReportEo);
    }

    private void modifyFinLogisticsReportData(FinLogisticsReportRespDto reportRespDto) {
        FinLogisticsReportEo finLogisticsReportEo = new FinLogisticsReportEo();
        DtoHelper.dto2Eo((BaseVo)reportRespDto, (BaseEo)finLogisticsReportEo);
        logger.info("modifyFinLogisticsReportData finLogisticsReportEo={}", (Object)JSONObject.toJSONString((Object)finLogisticsReportEo));
        this.finLogisticsReportDas.updateSelective((BaseEo)finLogisticsReportEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeFinLogisticsReport(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.finLogisticsReportDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeFinLogisticsReportById(List<String> ids, String retainId) {
        for (String id : ids) {
            if (Objects.equals(id, retainId)) continue;
            this.finLogisticsReportDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeFinLogisticsReportById(Set<Long> ids) {
        for (Long id : ids) {
            this.finLogisticsReportDas.logicDeleteById(id);
        }
    }

    @Override
    public FinLogisticsReportRespDto queryById(Long id) {
        FinLogisticsReportEo finLogisticsReportEo = (FinLogisticsReportEo)this.finLogisticsReportDas.selectByPrimaryKey(id);
        FinLogisticsReportRespDto finLogisticsReportRespDto = new FinLogisticsReportRespDto();
        DtoHelper.eo2Dto((BaseEo)finLogisticsReportEo, (BaseVo)finLogisticsReportRespDto);
        return finLogisticsReportRespDto;
    }

    @Override
    public PageInfo<FinLogisticsReportRespDto> queryByPage(FinLogisticReportReqDto reportReqDto) {
        PageHelper.startPage((int)reportReqDto.getPageNum(), (int)reportReqDto.getPageSize());
        logger.info("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u5206\u9875\u67e5\u8be2 {}", (Object)JSON.toJSONString((Object)reportReqDto));
        PageInfo eoPageInfo = new PageInfo(this.finLogisticDetailDas.queryPage(reportReqDto));
        return eoPageInfo;
    }

    @Override
    public ReInsuranceBillCountDto queryLogisticsCount(FinLogisticReportReqDto reportReqDto) {
        return this.finLogisticsReportDas.queryLogisticsCount(reportReqDto);
    }

    @Override
    public Integer queryAnomalyCount() {
        return this.finLogisticsReportDas.queryAnomalyCount(Integer.valueOf(1));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long pooledData(LogisticOperateReqDto reqDto) {
        FinLogisticsReportRespDto respDto = this.queryById(Long.valueOf(reqDto.getId()));
        List<FinLogisticsReportDto> detailRespDtoList = this.finLogisticDetailService.selectById(reqDto.getDetailIds());
        if (respDto == null || CollectionUtil.isEmpty(detailRespDtoList)) {
            throw new BizException("\u6240\u9009\u5355\u636e\u4e0d\u5b58\u5728");
        }
        this.checkMergeCondition(detailRespDtoList);
        this.removeDataById(detailRespDtoList);
        FinLogisticsReportDto detailRespDto = this.setAndReCalData(detailRespDtoList);
        if (detailRespDto != null) {
            detailRespDto.setType(LogisticDocumentTypeEnum.MERGE.getCode().toString());
            detailRespDto.getFinLogisticsReportDtos().forEach(i -> {
                i.setType(LogisticDocumentTypeEnum.MERGE.getCode().toString());
                i.setId(null);
                i.setReportId(null);
            });
            detailRespDto.setId(null);
            detailRespDto.setReportId(null);
        }
        Long id = this.addFinLogistics(detailRespDto);
        List dtoList = detailRespDto.getFinLogisticsReportDtos();
        this.finLogisticDetailService.batchSave(id, dtoList);
        return respDto.getId();
    }

    private void removeDataById(List<FinLogisticsReportDto> detailRespDtoList) {
        HashSet reportIds = Sets.newHashSet();
        detailRespDtoList.forEach(i -> {
            this.finLogisticDetailDas.deleteById(i.getId());
            reportIds.add(i.getReportId());
        });
        reportIds.forEach(i -> this.finLogisticsReportDas.deleteById(i));
    }

    private void checkMergeCondition(List<FinLogisticsReportDto> list) {
        Set set = list.stream().map(i -> i.getUniqueKey()).collect(Collectors.toSet());
        if (set.size() > 1) {
            throw new BizException("\u4ec5\u652f\u6301\u540c\u4e00\u5929\u53d1\u8d27\u7684\u76f8\u540c\u7269\u7406\u4ed3\u3001\u76f8\u540c\u7269\u6d41\u516c\u53f8\u3001\u76f8\u540c\u627f\u8fd0\u65b9\u5f0f\u3001\u76f8\u540c\u7701\u5e02\u533a\u7684\u5355\u636e\u5408\u5e76");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resolutionData(LogisticOperateReqDto reqDto) {
        Long id;
        logger.info("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u62c6\u5355 {}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isTrue((boolean)ObjectUtils.isNotEmpty((Object)reqDto.getId()), (String)"\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff0cID\u4e0d\u80fd\u4e3a\u7a7a");
        FinLogisticsReportRespDto respDto = this.queryById(Long.valueOf(reqDto.getId()));
        AssertUtil.isTrue((boolean)ObjectUtils.isNotEmpty((Object)respDto), (String)"\u627e\u4e0d\u5230\u62a5\u8868\u8bb0\u5f55");
        List<FinLogisticsReportDto> detailRespDtoList = this.finLogisticDetailService.selectByReport(respDto.getId());
        AssertUtil.isTrue((boolean)ObjectUtils.isNotEmpty((Object)respDto), (String)"\u627e\u4e0d\u5230\u62a5\u8868\u8bb0\u5f55");
        this.finLogisticsReportDas.logicDeleteById(respDto.getId());
        this.finLogisticDetailDas.logicDeleteByIds(detailRespDtoList.stream().map(FinLogisticsReportDto::getId).collect(Collectors.toList()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String formatDate = simpleDateFormat.format(detailRespDtoList.get(0).getOutboundTime());
        LogisticStatisticReqDto statisticReqDto = new LogisticStatisticReqDto();
        statisticReqDto.setDocumentNos(detailRespDtoList.stream().map(FinLogisticsReportDto::getOutboundCode).collect(Collectors.toList()));
        statisticReqDto.setStartTime(formatDate + " 00:00:00");
        statisticReqDto.setEndTime(formatDate + " 23:59:59");
        List<FinLogisticsReportDto> outResultOrderList = this.selectOutResultOrder(statisticReqDto);
        AssertUtil.isTrue((CollectionUtils.isNotEmpty(outResultOrderList) || outResultOrderList.size() == detailRespDtoList.size() ? 1 : 0) != 0, (String)"\u627e\u4e0d\u5230\u539f\u59cb\u5355\u636e");
        outResultOrderList.forEach(d -> d.setIfMerge(Boolean.valueOf(false)));
        Map<String, List<FinLogisticsReportDto>> stringListMap = this.calculateData(outResultOrderList, null);
        List<FinLogisticsReportDto> nonGroupMapList = stringListMap.get(LogisticDataTypeEnum.SCATTERED.getCode());
        List<FinLogisticsReportDto> exceptionMapList = stringListMap.get(LogisticDataTypeEnum.EXCEPTION_TYPE.getCode());
        if (CollectionUtils.isNotEmpty(nonGroupMapList)) {
            logger.info("groupMapList\u96f6\u6563\u6570\u636e {}", (Object)JSON.toJSONString(nonGroupMapList));
            for (FinLogisticsReportDto reportDto : nonGroupMapList) {
                reportDto.setType(LogisticDocumentTypeEnum.ORIGINAL.getCode().toString());
                reportDto.setShareAmount(reportDto.getTotalTransportAmount());
                id = this.addFinLogistics(reportDto);
                this.finLogisticDetailService.detailSave(id, reportDto);
            }
        }
        if (CollectionUtils.isNotEmpty(exceptionMapList)) {
            logger.info("groupMapList\u5f02\u5e38\u6570\u636e {}", (Object)JSON.toJSONString(exceptionMapList));
            for (FinLogisticsReportDto reportDto : exceptionMapList) {
                reportDto.setType(LogisticDocumentTypeEnum.ORIGINAL.getCode().toString());
                reportDto.setShareAmount(reportDto.getTotalTransportAmount());
                id = this.addFinLogistics(reportDto);
                this.finLogisticDetailService.detailSave(id, reportDto);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statisticData(LogisticStatisticReqDto logisticStatisticReqDto) {
        Long id;
        logger.info("statisticData\u7269\u6d41\u8d39\u7528\u62a5\u8868\u751f\u6210 {}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        List<FinLogisticsReportDto> outResultOrderList = this.selectOutResultOrder(logisticStatisticReqDto);
        if (CollectionUtil.isEmpty(outResultOrderList)) {
            logger.info("statisticData\u65e0\u5f85\u751f\u6210\u6570\u636e");
            return;
        }
        logger.info("\u5148\u5220\u9664\u7269\u6d41\u8d39\u7528\u62a5\u8868\u6570\u636e {}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        this.finLogisticDetailDas.logicDeleteLogistic(logisticStatisticReqDto);
        logger.info("\u83b7\u53d6\u5f85\u751f\u6210\u6570\u636e {}", (Object)JSON.toJSONString(outResultOrderList));
        Map<String, List<FinLogisticsReportDto>> stringListMap = this.calculateData(outResultOrderList, null);
        List<FinLogisticsReportDto> groupMapList = stringListMap.get(LogisticDataTypeEnum.MERGE.getCode());
        List<FinLogisticsReportDto> nonGroupMapList = stringListMap.get(LogisticDataTypeEnum.SCATTERED.getCode());
        List<FinLogisticsReportDto> exceptionMapList = stringListMap.get(LogisticDataTypeEnum.EXCEPTION_TYPE.getCode());
        if (CollectionUtils.isNotEmpty(groupMapList)) {
            logger.info("groupMapList\u5408\u5e76\u6570\u636e {}", (Object)JSON.toJSONString(groupMapList));
            for (FinLogisticsReportDto reportDto : groupMapList) {
                id = this.addFinLogistics(reportDto);
                List dtoList = reportDto.getFinLogisticsReportDtos();
                this.finLogisticDetailService.batchSave(id, dtoList);
            }
        }
        if (CollectionUtils.isNotEmpty(nonGroupMapList)) {
            logger.info("groupMapList\u96f6\u6563\u6570\u636e {}", (Object)JSON.toJSONString(nonGroupMapList));
            for (FinLogisticsReportDto reportDto : nonGroupMapList) {
                reportDto.setType(LogisticDocumentTypeEnum.ORIGINAL.getCode().toString());
                reportDto.setShareAmount(reportDto.getTotalTransportAmount());
                id = this.addFinLogistics(reportDto);
                this.finLogisticDetailService.detailSave(id, reportDto);
            }
        }
        if (CollectionUtils.isNotEmpty(exceptionMapList)) {
            logger.info("groupMapList\u5f02\u5e38\u6570\u636e {}", (Object)JSON.toJSONString(exceptionMapList));
            for (FinLogisticsReportDto reportDto : exceptionMapList) {
                reportDto.setType(LogisticDocumentTypeEnum.ORIGINAL.getCode().toString());
                reportDto.setShareAmount(reportDto.getTotalTransportAmount());
                id = this.addFinLogistics(reportDto);
                this.finLogisticDetailService.detailSave(id, reportDto);
            }
        }
    }

    @Override
    public void statisticDataNew(LogisticStatisticReqDto logisticStatisticReqDto) {
        Long id;
        logger.info("statisticDataNew\u7269\u6d41\u8d39\u7528\u62a5\u8868\u751f\u6210 {}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        List<FinLogisticsReportDto> outResultOrderList = this.selectOutResultOrderNew(logisticStatisticReqDto);
        if (CollectionUtil.isEmpty(outResultOrderList)) {
            logger.info("statisticDataNew\u65e0\u5f85\u751f\u6210\u6570\u636e");
            return;
        }
        logger.info("\u5148\u5220\u9664\u7269\u6d41\u8d39\u7528\u62a5\u8868\u6570\u636e {}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        this.finLogisticDetailDas.logicDeleteLogistic(logisticStatisticReqDto);
        logger.info("\u83b7\u53d6\u5f85\u751f\u6210\u6570\u636e {}", (Object)JSON.toJSONString(outResultOrderList));
        Map<String, List<FinLogisticsReportDto>> stringListMap = this.calculateDataNew(outResultOrderList, null);
        logger.info("\u8ba1\u7b97\u540e\u5206\u7ec4\u5927\u5c0f {}", (Object)stringListMap.size());
        List<FinLogisticsReportDto> groupMapList = stringListMap.get(LogisticDataTypeEnum.MERGE.getCode());
        logger.info("\u8ba1\u7b97\u540e\u5206\u7ec4\u5927\u5c0f groupMapList.size={}", (Object)Optional.ofNullable(groupMapList).map(List::size).orElse(0));
        List<FinLogisticsReportDto> nonGroupMapList = stringListMap.get(LogisticDataTypeEnum.SCATTERED.getCode());
        logger.info("\u8ba1\u7b97\u540e\u5206\u7ec4\u5927\u5c0f nonGroupMapList.size={}", (Object)Optional.ofNullable(nonGroupMapList).map(List::size).orElse(0));
        List<FinLogisticsReportDto> exceptionMapList = stringListMap.get(LogisticDataTypeEnum.EXCEPTION_TYPE.getCode());
        logger.info("\u8ba1\u7b97\u540e\u5206\u7ec4\u5927\u5c0f exceptionMapList.size={}", (Object)Optional.ofNullable(exceptionMapList).map(List::size).orElse(0));
        if (CollectionUtils.isNotEmpty(groupMapList)) {
            logger.info("groupMapList\u5408\u5e76\u6570\u636e {}", (Object)JSON.toJSONString(groupMapList));
            for (FinLogisticsReportDto reportDto : groupMapList) {
                id = this.addFinLogistics(reportDto);
                List dtoList = reportDto.getFinLogisticsReportDtos();
                this.finLogisticDetailService.batchSave(id, dtoList);
            }
        }
        if (CollectionUtils.isNotEmpty(nonGroupMapList)) {
            logger.info("groupMapList\u96f6\u6563\u6570\u636e {}", (Object)JSON.toJSONString(nonGroupMapList));
            for (FinLogisticsReportDto reportDto : nonGroupMapList) {
                reportDto.setType(LogisticDocumentTypeEnum.ORIGINAL.getCode().toString());
                reportDto.setShareAmount(reportDto.getTotalTransportAmount());
                id = this.addFinLogistics(reportDto);
                this.finLogisticDetailService.detailSave(id, reportDto);
            }
        }
        if (CollectionUtils.isNotEmpty(exceptionMapList)) {
            logger.info("groupMapList\u5f02\u5e38\u6570\u636e {}", (Object)JSON.toJSONString(exceptionMapList));
            for (FinLogisticsReportDto reportDto : exceptionMapList) {
                reportDto.setType(LogisticDocumentTypeEnum.ORIGINAL.getCode().toString());
                reportDto.setShareAmount(reportDto.getTotalTransportAmount());
                id = this.addFinLogistics(reportDto);
                this.finLogisticDetailService.detailSave(id, reportDto);
            }
        }
    }

    @Override
    public void againCalculate(List<String> ids) {
        Long id;
        logger.info("\u66f4\u65b0\u7269\u6d41\u8d39\u7528\u8bbe\u7f6e {}", (Object)JSON.toJSONString(ids));
        ArrayList<FinLogisticsReportDto> totalDataList = new ArrayList<FinLogisticsReportDto>();
        List<FinLogisticsReportDto> outResultOrderList = this.finLogisticDetailService.selectFinLogisticsReportDto(ids);
        if (CollectionUtils.isNotEmpty(outResultOrderList)) {
            totalDataList.addAll(outResultOrderList);
        }
        Map<String, List<FinLogisticsReportDto>> stringListMap = this.calculateData(totalDataList, null);
        List<FinLogisticsReportDto> nonGroupMapList = stringListMap.get(LogisticDataTypeEnum.SCATTERED.getCode());
        List<FinLogisticsReportDto> groupMapList = stringListMap.get(LogisticDataTypeEnum.MERGE.getCode());
        List<FinLogisticsReportDto> exceptionMapList = stringListMap.get(LogisticDataTypeEnum.EXCEPTION_TYPE.getCode());
        if (CollectionUtils.isNotEmpty(groupMapList)) {
            for (FinLogisticsReportDto reportDto : groupMapList) {
                id = this.addFinLogistics(reportDto);
                List dtoList = reportDto.getFinLogisticsReportDtos();
                this.finLogisticDetailService.updateDetailList(dtoList, id);
            }
        }
        if (CollectionUtils.isNotEmpty(nonGroupMapList)) {
            for (FinLogisticsReportDto reportDto : nonGroupMapList) {
                reportDto.setId(null);
                id = this.addFinLogistics(reportDto);
                this.finLogisticDetailService.updateDetail(reportDto, id);
            }
        }
        if (CollectionUtils.isNotEmpty(exceptionMapList)) {
            for (FinLogisticsReportDto reportDto : exceptionMapList) {
                reportDto.setId(null);
                id = this.addFinLogistics(reportDto);
                this.finLogisticDetailService.updateDetail(reportDto, id);
            }
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            this.removeFinLogisticsReportById(ids, null);
        }
    }

    @Override
    public List<FinLogisticsReportRespDto> queryByList(FinLogisticsReportQueryListDto finLogisticsReportQueryListDto) {
        List eos;
        if (CollectionUtils.isEmpty((Collection)finLogisticsReportQueryListDto.getOutboundCodeList()) && CollectionUtils.isEmpty((Collection)finLogisticsReportQueryListDto.getOutNoticeCodeList())) {
            return Lists.newArrayList();
        }
        ExtQueryChainWrapper filter = this.finLogisticDetailDas.filter();
        if (CollectionUtils.isNotEmpty((Collection)finLogisticsReportQueryListDto.getOutboundCodeList())) {
            filter.in((Object)"outbound_code", (Collection)finLogisticsReportQueryListDto.getOutboundCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)finLogisticsReportQueryListDto.getOutNoticeCodeList())) {
            filter.in((Object)"out_notice_code", (Collection)finLogisticsReportQueryListDto.getOutNoticeCodeList());
        }
        if (CollectionUtil.isEmpty((Collection)(eos = filter.list(Integer.valueOf(2000))))) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        eos.forEach(detailEo -> {
            FinLogisticsReportRespDto respDto = new FinLogisticsReportRespDto();
            BeanUtils.copyProperties((Object)detailEo, (Object)respDto);
            respDto.setReportId(Long.valueOf(detailEo.getReportId()));
            respDtos.add(respDto);
        });
        return respDtos;
    }

    @Transactional(rollbackFor={Exception.class})
    public void syncAgainCalculate(AgainCalculateReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)MDC.get((String)"yes.req.requestId"))) {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        }
        logger.info("\u66f4\u65b0\u7269\u6d41\u8d39\u7528\u62a5\u8868\u7edf\u8ba1\u6570\u636e {}", (Object)JSON.toJSONString((Object)reqDto));
        LogisticStatisticReqDto createReqDto = new LogisticStatisticReqDto();
        if (ObjectUtils.isNotEmpty((Object)reqDto.getContractId())) {
            LogisticsRecordEo logisticsRecordEo = (LogisticsRecordEo)this.logisticsRecordDas.selectByPrimaryKey(reqDto.getContractId());
            AssertUtil.isTrue((boolean)ObjectUtils.isNotEmpty((Object)logisticsRecordEo), (String)"-1", (String)"\u627e\u4e0d\u5230\u7269\u6d41\u6a21\u7248\u4fe1\u606f");
            if (ObjectUtils.isEmpty((Object)reqDto.getStartDate()) || ObjectUtils.isEmpty((Object)reqDto.getEndDate())) {
                reqDto.setStartDate(logisticsRecordEo.getStartTime());
                reqDto.setEndDate(logisticsRecordEo.getEndTime());
            }
            createReqDto.setWarehouseCode(logisticsRecordEo.getWarehouseId());
            createReqDto.setShippingCompanyCode(logisticsRecordEo.getLogisticId());
            createReqDto.setShippingType(logisticsRecordEo.getTransportType());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        createReqDto.setStartTime(format.format(reqDto.getStartDate()));
        createReqDto.setEndTime(format.format(reqDto.getEndDate()));
        this.statisticDataNew(createReqDto);
    }

    @Override
    public void againCalculate(AgainCalculateReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getContractId()) && (ObjectUtils.isEmpty((Object)reqDto.getStartDate()) || ObjectUtils.isEmpty((Object)reqDto.getEndDate()))) {
            throw new BizException("-1", "\u5408\u540c\u6216\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        CompletableFuture.runAsync(() -> this.syncAgainCalculate(reqDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(FinLogisticsReportEditReqDto editReqDto) {
        if (!editReqDto.getMergeFlag().booleanValue()) {
            FinLogisticDetailEo eo = (FinLogisticDetailEo)this.finLogisticDetailDas.selectByPrimaryKey(editReqDto.getEditId());
            if (eo == null) {
                throw new BizException("\u7f16\u8f91ID\u4e0d\u6b63\u786e");
            }
            FinLogisticsReportEo reportEo = (FinLogisticsReportEo)this.finLogisticsReportDas.selectByPrimaryKey(Long.valueOf(eo.getReportId()));
            if (reportEo == null) {
                throw new BizException("\u7f16\u8f91ID\u4e0d\u6b63\u786e");
            }
            if (StringUtils.isNotBlank((CharSequence)editReqDto.getSpecialType())) {
                eo.setSpecialType(editReqDto.getSpecialType());
                reportEo.setSpecialType(editReqDto.getSpecialType());
            }
            BigDecimal totalTransportAmount = BigDecimal.ZERO;
            totalTransportAmount = reportEo.getOilPrice() != null && reportEo.getOilPrice().compareTo(BigDecimal.ZERO) > 0 ? totalTransportAmount.add(reportEo.getOilPrice()) : totalTransportAmount.add(reportEo.getTransportAmount());
            if (reportEo.getDeliveryAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportEo.getDeliveryAmount());
            }
            if (reportEo.getUnloadAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportEo.getUnloadAmount());
            }
            if (editReqDto.getSpecialAmount() != null) {
                reportEo.setTotalTransportAmount(totalTransportAmount.add(editReqDto.getSpecialAmount()));
                reportEo.setSpecialAmount(editReqDto.getSpecialAmount());
                reportEo.setShareAmount(reportEo.getTotalTransportAmount());
                eo.setTotalTransportAmount(totalTransportAmount.add(editReqDto.getSpecialAmount()));
                eo.setSpecialAmount(editReqDto.getSpecialAmount());
                eo.setShareAmount(eo.getTotalTransportAmount());
            }
            if (StringUtils.isNotBlank((CharSequence)editReqDto.getRemark())) {
                eo.setRemark(editReqDto.getRemark());
                reportEo.setRemark(editReqDto.getRemark());
            }
            this.finLogisticDetailDas.updateSelective((BaseEo)eo);
            this.finLogisticsReportDas.updateSelective((BaseEo)reportEo);
        } else {
            FinLogisticsReportEo reportEo = (FinLogisticsReportEo)this.finLogisticsReportDas.selectByPrimaryKey(editReqDto.getEditId());
            if (reportEo == null) {
                throw new BizException("\u7f16\u8f91\u5408\u5355ID\u4e0d\u6b63\u786e");
            }
            List detailEos = ((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().eq((Object)"report_id", (Object)editReqDto.getEditId())).list(Integer.valueOf(10000));
            if (CollectionUtil.isEmpty((Collection)detailEos)) {
                throw new BizException("\u7f16\u8f91\u5408\u5355ID\u4e0d\u6b63\u786e");
            }
            if (StringUtils.isNotBlank((CharSequence)editReqDto.getSpecialType())) {
                reportEo.setSpecialType(editReqDto.getSpecialType());
            }
            if (editReqDto.getSpecialAmount() != null) {
                reportEo.setSpecialAmount(editReqDto.getSpecialAmount());
            }
            if (StringUtils.isNotBlank((CharSequence)editReqDto.getRemark())) {
                reportEo.setRemark(editReqDto.getRemark());
            }
            BigDecimal totalTransportAmount = BigDecimal.ZERO;
            totalTransportAmount = reportEo.getOilPrice() != null && reportEo.getOilPrice().compareTo(BigDecimal.ZERO) > 0 ? totalTransportAmount.add(reportEo.getOilPrice()) : totalTransportAmount.add(reportEo.getTransportAmount());
            if (reportEo.getDeliveryAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportEo.getDeliveryAmount());
            }
            if (reportEo.getUnloadAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportEo.getUnloadAmount());
            }
            if (reportEo.getSpecialAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportEo.getSpecialAmount());
            }
            reportEo.setTotalTransportAmount(totalTransportAmount);
            this.shareSpecialAmount(editReqDto, detailEos);
            editReqDto.setTotalTransportAmount(totalTransportAmount);
            this.totalTransportAmount(editReqDto, detailEos);
            this.finLogisticsReportDas.updateSelective((BaseEo)reportEo);
            detailEos.forEach(i -> {
                i.setTotalTransportAmount(i.getTotalTransportAmount());
                i.setShareAmount(i.getTotalTransportAmount());
                i.setSpecialType(editReqDto.getSpecialType());
                this.finLogisticDetailDas.updateSelective((BaseEo)i);
            });
        }
    }

    private void totalTransportAmount(FinLogisticsReportEditReqDto editReqDto, List<FinLogisticDetailEo> detailEos) {
        BigDecimal totalTransportAmount = editReqDto.getTotalTransportAmount();
        if (totalTransportAmount != null) {
            BigDecimal shareAmount = BigDecimal.ZERO;
            for (int i = 0; i < detailEos.size(); ++i) {
                FinLogisticDetailEo eo = detailEos.get(i);
                if (i == detailEos.size() - 1) {
                    eo.setTotalTransportAmount(totalTransportAmount.subtract(shareAmount));
                    continue;
                }
                if (eo.getRatio() == null) continue;
                BigDecimal lineSpecialAmount = totalTransportAmount.multiply(eo.getRatio());
                eo.setTotalTransportAmount(lineSpecialAmount);
                shareAmount = shareAmount.add(lineSpecialAmount);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(String ids) {
        String[] split = ids.split(",");
        List idList = Arrays.stream(split).map(i -> Long.valueOf(i)).collect(Collectors.toList());
        List detailEos = this.finLogisticDetailDas.selectByIds(idList);
        if (CollectionUtil.isNotEmpty((Collection)detailEos)) {
            detailEos.forEach(i -> {
                this.finLogisticDetailDas.deleteById(i.getId());
                this.finLogisticsReportDas.deleteById(Long.valueOf(i.getReportId()));
            });
        }
    }

    @Override
    public void editAddress(FinLogisticsReportEditReqDto editAddress) {
        if (StringUtils.isBlank((CharSequence)editAddress.getProvince())) {
            throw new BizException("\u7f16\u8f91\u5355\u636e\u5730\u5740\u65f6\u7701\u5e02\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture.runAsync(() -> this.asyncEditAddress(editAddress));
    }

    @Override
    public void deleteDetailAndReport(LogisticStatisticReqDto reqDto) {
        logger.info("\u5220\u9664\u7269\u6d41\u8d39\u7528\u62a5\u8868\u6570\u636e {}", (Object)JSON.toJSONString((Object)reqDto));
        this.finLogisticDetailDas.deleteDetailAndReport(reqDto);
    }

    @Override
    public int updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        List masterDetailEoList;
        logger.info("\u7269\u6d41\u8d39\u7528\u5f52\u6863\u72b6\u6001\u53d8\u66f4\uff1a{}", (Object)JSON.toJSONString((Object)updateReqDto));
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)updateReqDto.getModuleRecordIdList()), (String)"moduleRecordIdList\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)updateReqDto.getPlacedFlag()), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        List detailEoList = this.finLogisticDetailDas.selectByIds(updateReqDto.getModuleRecordIdList());
        List masterMergeCodeList = detailEoList.stream().filter(f -> f.getType().equals(LogisticDocumentTypeEnum.MERGE_CHILD.getCode().toString()) && StringUtils.isNotBlank((CharSequence)f.getMergeCode())).map(FinLogisticDetailEo::getMergeCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(masterMergeCodeList) && CollectionUtils.isNotEmpty((Collection)(masterDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().in((Object)"merge_code", masterMergeCodeList)).eq((Object)"placed_flag", (Object)0)).list()))) {
            detailEoList.addAll(masterDetailEoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            detailEoList.forEach(reportEo -> {
                if (ObjectUtils.isEmpty((Object)reportEo.getPlacedFlag()) || reportEo.getPlacedFlag() != 1) {
                    FinLogisticDetailEo eo = new FinLogisticDetailEo();
                    eo.setId(reportEo.getId());
                    eo.setPlacedFlag(updateReqDto.getPlacedFlag());
                    this.finLogisticDetailDas.updateSelective((BaseEo)eo);
                }
            });
        }
        return detailEoList.size();
    }

    @Override
    public void generateLogisticStatisticDataForDailyDeliveryReport(LogisticStatisticReqDto logisticStatisticReqDto) {
        logger.info("\u751f\u6210\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u62a5\u8868\u6570\u636e\uff08\u6765\u6e90\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\uff09\uff1a{}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        AssertUtil.isFalse((ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getStartTime()) || ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getEndTime()) ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u7684\u5f00\u59cb/\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        this.delLogisticStatisticDataForDailyDeliveryReport(logisticStatisticReqDto);
        List<FinLogisticsReportDto> reportDtoList = this.buildLogisticStatisticDataForDailyDeliveryReport(logisticStatisticReqDto);
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty(reportDtoList), (String)"\u65e0\u7269\u6d41\u8d39\u7528\u6570\u636e\u9700\u8981\u751f\u6210");
        this.calculateLogisticStatisticDataForDailyDeliveryReport(reportDtoList);
        this.saveLogisticStatisticDataForDailyDeliveryReport(reportDtoList);
    }

    @Override
    public List<FinLogisticsReportDto> buildLogisticStatisticDataForDailyDeliveryReport(LogisticStatisticReqDto logisticStatisticReqDto) {
        logger.info("\u6784\u5efa\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u62a5\u8868\u6570\u636e\uff08\u6765\u6e90\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\uff09\uff1a{}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        if (ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getStartTime()) || ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getEndTime())) {
            logger.info("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff0c\u5f00\u59cb/\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return new ArrayList<FinLogisticsReportDto>();
        }
        logger.info("selectOutResultOrder\u67e5\u8be2\u7269\u6d41\u5546");
        Map<Object, Object> shipmentMap = Maps.newHashMap();
        List shipmentList = ((ExtQueryChainWrapper)this.shipmentEnterpriseDas.filter().eq((Object)"shipment_enterprise_type", (Object)1)).list(Integer.valueOf(1000));
        if (CollectionUtil.isNotEmpty((Collection)shipmentList)) {
            shipmentMap = shipmentList.stream().collect(Collectors.toMap(ShipmentEnterpriseEo::getShipmentEnterpriseCode, Function.identity(), (k1, k2) -> k1));
        }
        Map<String, PcpRegionEo> cityLevelMap = this.asyncCityLevel();
        logger.info("\u83b7\u53d6\u57ce\u5e02\u7b49\u7ea7\u4fe1\u606f {}", (Object)JSON.toJSONString(cityLevelMap));
        Map<String, List<LogisticsRecordEo>> logisticsTemplateMap = this.asyncLogisticsTemplateList();
        logger.info("\u83b7\u53d6\u7269\u6d41\u8d39\u7528\u6a21\u7248\u4fe1\u606f {}", (Object)JSON.toJSONString(logisticsTemplateMap));
        Map<String, OilLinkQueryRespDto> oilLinkMap = this.asyncOilLink(logisticStatisticReqDto.getStartTime(), logisticStatisticReqDto.getEndTime());
        logger.info("\u83b7\u53d6\u8054\u52a8\u6cb9\u4ef7 {}", (Object)JSON.toJSONString(oilLinkMap));
        List<DailyDeliveryFeeFilterExtConfigRespDto> outFilter = this.dailyDeliveryFeeFilterExtConfigService.queryModuleCode(DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode());
        logger.info("\u7269\u6d41\u5254\u9664\u8d39\u7528\u8bbe\u7f6e\uff1a{}", (Object)JSON.toJSONString(outFilter));
        DailyDeliveryReportDto reportDto = new DailyDeliveryReportDto();
        reportDto.setRelevanceNo(logisticStatisticReqDto.getRelevanceNo());
        reportDto.setOutNoticeNo(logisticStatisticReqDto.getOutNoticeNo());
        reportDto.setOutResultNo(logisticStatisticReqDto.getOutResultNo());
        reportDto.setOrderShippingTimeStart(DateTimeUtils.parseDateTime(logisticStatisticReqDto.getStartTime()));
        reportDto.setOrderShippingTimeEnd(DateTimeUtils.parseDateTime(logisticStatisticReqDto.getEndTime()));
        reportDto.setShippingCompanyList(shipmentList.stream().map(ShipmentEnterpriseEo::getShipmentEnterpriseCode).collect(Collectors.toList()));
        reportDto.setPhysicalWarehouseCodeList(logisticStatisticReqDto.getWarehouseCodeList());
        reportDto.setPageNum(Integer.valueOf(1));
        reportDto.setPageSize(Integer.valueOf(5000));
        List dailyDeliveryReportDtoList = this.dailyDeliveryReportDomain.queryLogisticsCostCharge(reportDto).getList();
        Set<String> agencyOrderNo = dailyDeliveryReportDtoList.stream().filter(e -> SaleBusinessTypeEnum.internalSalesOrderTypes().containsKey(e.getBusinessType()) || SaleBusinessTypeEnum.nutritionistOrderTypes().containsKey(e.getBusinessType())).map(DailyDeliveryReportDto::getRelevanceNo).collect(Collectors.toSet());
        Map<String, SaleOrderEo> saleOrderEoMap = this.querySaleOrder(agencyOrderNo);
        logger.info("\u67e5\u627e \u5185\u90e8\u9500\u552e\u8ba2\u5355 \u6216 \u8425\u517b\u5bb6\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(saleOrderEoMap));
        ArrayList<FinLogisticsReportDto> finLogisticsReportEos = new ArrayList<FinLogisticsReportDto>();
        while (CollectionUtil.isNotEmpty((Collection)dailyDeliveryReportDtoList) && dailyDeliveryReportDtoList.size() > 0) {
            List<String> scrapTypeOtherOrderList = this.queryScrapTypeOtherOrder(dailyDeliveryReportDtoList);
            for (DailyDeliveryReportDto respDto : dailyDeliveryReportDtoList) {
                ShipmentEnterpriseEo shipmentEnterpriseEo;
                boolean isMergeMaster = Objects.equals(respDto.getType(), "4");
                logger.info("selectOutResultOrder\u904d\u5386\u5904\u7406\u5355\u636e\u3010{}\u3011\uff1a{}", (Object)(isMergeMaster ? "\u4e3b\u5355" : "\u5b50\u5355"), (Object)JSON.toJSONString((Object)respDto));
                if (StringUtils.isNotBlank((CharSequence)respDto.getBusinessType()) && respDto.getBusinessType().equals("other_out") && StringUtils.isNotBlank((CharSequence)respDto.getRelevanceNo()) && scrapTypeOtherOrderList.contains(respDto.getRelevanceNo())) {
                    logger.info("\u62a5\u5e9f\u7c7b\u578b\u7684\u5176\u4ed6\u51fa\u5e93\u5355\u4e0d\u8ba1\u8d39");
                    continue;
                }
                FinLogisticsReportDto reportEo = new FinLogisticsReportDto();
                reportEo.setOutboundTime(respDto.getOrderShippingTime());
                reportEo.setBookkeepingDate(DateTimeUtils.formatDate(reportEo.getOutboundTime(), "yyyy-MM"));
                reportEo.setBillingDate(DateTimeUtils.formatDate(respDto.getOrderCreateTime(), "yyyy-MM-dd"));
                reportEo.setEasNo(respDto.getEasOrderNo());
                reportEo.setTransportNo(respDto.getTransportNo());
                reportEo.setWmsMergeDocumentNo(isMergeMaster ? respDto.getWmsMergeDocumentNo() : respDto.getJoinMergeDocumentNo());
                reportEo.setOutResultCode(respDto.getOutResultNo());
                reportEo.setOutNoticeCode(respDto.getOutNoticeNo());
                reportEo.setWarehouseName(respDto.getPhysicalWarehouse());
                reportEo.setWarehouseCode(respDto.getPhysicalWarehouseCode());
                reportEo.setWmsOutboundCode(respDto.getWmsOrderNo());
                reportEo.setBusinessType(respDto.getBusinessType());
                reportEo.setBusinessCode(respDto.getRelevanceNo());
                reportEo.setLogisticCompanyCode(respDto.getShippingCompany());
                reportEo.setLogisticCompany(respDto.getShippingCompanyName());
                reportEo.setTransportType(respDto.getTransportStyle());
                reportEo.setTransportCode(respDto.getConsignmentNo());
                reportEo.setShopCode(respDto.getShopCode());
                reportEo.setShopName(respDto.getShopName());
                reportEo.setBottle(respDto.getTotalQuantity());
                reportEo.setBox(respDto.getTotalCartons());
                reportEo.setVolume(respDto.getTotalVolume());
                reportEo.setWeight(respDto.getTotalWeight());
                reportEo.setTotalBox(respDto.getBillingCartons());
                reportEo.setTotalVolume(respDto.getBillingVolume());
                reportEo.setTotalWeight(respDto.getBillingWeight());
                reportEo.setProvince(respDto.getReceivingAddressProvince());
                reportEo.setProvinceCode(respDto.getReceivingAddressProvinceCode());
                reportEo.setCity(respDto.getReceivingAddressCity());
                reportEo.setCityCode(respDto.getReceivingAddressCityCode());
                reportEo.setArea(respDto.getReceivingAddressDistrict());
                reportEo.setAreaCode(respDto.getReceivingAddressDistrictCode());
                reportEo.setCustomerName(respDto.getReceivingCustomer());
                reportEo.setHarvestAddress(respDto.getReceivingAddress());
                reportEo.setHarvestPeople(respDto.getReceivingPerson());
                reportEo.setWarehouseOut(respDto.getLogicWarehouse());
                reportEo.setWarehouseOutCode(respDto.getLogicWarehouseCode());
                reportEo.setOrganizationOut(respDto.getOutInventoryOrg());
                reportEo.setWarehouseEnter(respDto.getInLogicWarehouse());
                reportEo.setWarehouseEnterCode(respDto.getInLogicWarehouseCode());
                reportEo.setOrganizationEnter(respDto.getInInventoryOrg());
                SaleOrderEo saleOrderEo = saleOrderEoMap.get(respDto.getRelevanceNo());
                reportEo.setAmountAttribution(ObjectUtils.isNotEmpty((Object)saleOrderEo) ? saleOrderEo.getOrganizationName() : respDto.getInventoryOrganizationName());
                reportEo.setType(respDto.getType());
                reportEo.setLinkDailyReportId(respDto.getId());
                reportEo.setBillingFeeFlag(respDto.getBillingFeeFlag());
                reportEo.setStatus(Integer.valueOf(0));
                reportEo.setOutboundCode(respDto.getDocumentNo());
                reportEo.setJoinMergeDocumentNo(respDto.getJoinMergeDocumentNo());
                reportEo.setRemark(respDto.getRemark());
                if (StringUtils.isNotBlank((CharSequence)reportEo.getCityCode()) && cityLevelMap.containsKey(reportEo.getCityCode())) {
                    reportEo.setCityLevel(cityLevelMap.get(reportEo.getCityCode()).getCityLevel());
                }
                if (ObjectUtils.isNotEmpty((Object)reportEo.getOutboundTime()) && StringUtils.isNotBlank((CharSequence)reportEo.getWarehouseCode()) && StringUtils.isNotBlank((CharSequence)reportEo.getLogisticCompany()) && StringUtils.isNotBlank((CharSequence)reportEo.getTransportType())) {
                    LogisticRecordQueryRespDto logisticsTemplate = this.getLogisticsTemplateList(logisticsTemplateMap, reportEo);
                    if (ObjectUtils.isNotEmpty((Object)logisticsTemplate) && ObjectUtils.isNotEmpty((Object)logisticsTemplate.getId())) {
                        logger.info("\u5339\u914d\u7269\u6d41\u8d39\u7528\u6a21\u7248\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)logisticsTemplate));
                        logger.info("\u5224\u65ad\u6240\u5728\u7701 {} \u5e02 {} \u533a {} \u662f\u5426\u5728\u6a21\u677f\u6307\u5b9a\u8303\u56f4\u5185", new Object[]{reportEo.getProvince(), reportEo.getCity(), reportEo.getArea()});
                        boolean b = true;
                        if (b) {
                            reportEo.setChargeMode(logisticsTemplate.getChargeMode().toString());
                            reportEo.setLogisticsModeId(logisticsTemplate.getId());
                            reportEo.setLogisticsTemplate(logisticsTemplate);
                            reportEo.setLogisticsTemplateId(logisticsTemplate.getId());
                            reportEo.setContractOilPrice(logisticsTemplate.getContractOilPrice());
                        } else {
                            reportEo.setStatus(Integer.valueOf(1));
                            this.setAbnormalCauses(reportEo, "\u6240\u5339\u914d\u5230\u7684\u7269\u6d41\u8fd0\u8d39\u6a21\u677f\u4e0d\u5b58\u5728\u8be5\u6307\u5b9a\u533a\u57df");
                        }
                    } else {
                        reportEo.setStatus(Integer.valueOf(1));
                        this.setAbnormalCauses(reportEo, "\u6a21\u677f\u5df2\u8fc7\u671f\u6216\u672a\u5339\u914d\u5230\u6709\u6548\u7684\u7269\u6d41\u8fd0\u8d39\u6a21\u677f");
                    }
                } else {
                    if (reportEo.getOutboundTime() == null) {
                        this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u65f6\u95f4\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)reportEo.getWarehouseCode())) {
                        this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u7269\u7406\u4ed3\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)reportEo.getLogisticCompany())) {
                        this.setAbnormalCauses(reportEo, "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)reportEo.getTransportType())) {
                        this.setAbnormalCauses(reportEo, "\u627f\u8fd0\u65b9\u5f0f\u4e3a\u7a7a");
                    }
                    reportEo.setStatus(Integer.valueOf(1));
                }
                String oilLinkKey = reportEo.getWarehouseCode() + DateUtil.formatYM(reportEo.getOutboundTime());
                if (oilLinkMap.containsKey(oilLinkKey)) {
                    reportEo.setOilLinkQueryRespDto(oilLinkMap.get(oilLinkKey));
                    if (ObjectUtils.isNotEmpty((Object)reportEo.getOilLinkQueryRespDto())) {
                        reportEo.setLinkOilPrice(reportEo.getOilLinkQueryRespDto().getAmount());
                    }
                }
                if (ObjectUtils.isNotEmpty((Object)(shipmentEnterpriseEo = (ShipmentEnterpriseEo)shipmentMap.get(reportEo.getLogisticCompanyCode()))) && StringUtils.isNotBlank((CharSequence)shipmentEnterpriseEo.getCustomerName()) && ObjectUtils.isNotEmpty((Object)reportEo.getCustomerName()) && shipmentEnterpriseEo.getCustomerName().contains(reportEo.getCustomerName())) {
                    logger.info("\u7269\u6d41\u5546\u7ba1\u7406\u5ba2\u6237\u4e0e\u5355\u636e\u5ba2\u6237\u4e00\u81f4\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u8d39\uff0c{}", (Object)respDto.getDocumentNo());
                    reportEo.setBillingFeeFlag(Integer.valueOf(0));
                    this.setNoBillReasonCauses(reportEo, "\u5ba2\u6237\u4e0e\u7269\u6d41\u5546\u6709\u5173\u8054\u5173\u7cfb");
                }
                DailyDeliveryFeeFilterExtConfigReqDto configReqDto = new DailyDeliveryFeeFilterExtConfigReqDto();
                configReqDto.setFilterPhysicalWarehouse(reportEo.getWarehouseCode());
                configReqDto.setFilterLogicWarehouse(reportEo.getWarehouseOutCode());
                configReqDto.setFilterBusinessType(reportEo.getBusinessType());
                configReqDto.setLogisticsCompany(reportEo.getLogisticCompany());
                configReqDto.setTransportStyle(reportEo.getTransportType());
                configReqDto.setFilterInventoryOrg(reportEo.getOrganizationOut());
                boolean filterApplicable = this.dailyDeliveryFeeFilterExtConfigService.isFilterApplicable(outFilter, configReqDto);
                if (filterApplicable) {
                    logger.info("\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u547d\u4e2d\uff0c\u4e0d\u9700\u8981\u8ba1\u8d39");
                    reportEo.setBillingFeeFlag(Integer.valueOf(0));
                    this.setNoBillReasonCauses(reportEo, "\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u547d\u4e2d");
                }
                if (Objects.equals(respDto.getPhysicalWarehouseCode(), respDto.getInPhysicalWarehouseCode())) {
                    logger.info("\u51fa\u5e93\u7269\u7406\u4ed3\u548c\u5165\u5e93\u7269\u7406\u4ed3\u76f8\u540c\uff0c\u4e0d\u9700\u8981\u8ba1\u8d39");
                    reportEo.setBillingFeeFlag(Integer.valueOf(0));
                    this.setNoBillReasonCauses(reportEo, "\u51fa\u5e93\u7269\u7406\u4ed3\u548c\u5165\u5e93\u7269\u7406\u4ed3\u76f8\u540c");
                }
                finLogisticsReportEos.add(reportEo);
            }
            logger.info("\u67e5\u8be2\u4e0b\u4e00\u9875\u6570\u636e");
            reportDto.setPageNum(Integer.valueOf(reportDto.getPageNum() + 1));
            dailyDeliveryReportDtoList = this.dailyDeliveryReportDomain.queryLogisticsCostCharge(reportDto).getList();
        }
        if (CollectionUtils.isEmpty(finLogisticsReportEos)) {
            return finLogisticsReportEos;
        }
        logger.info("\u67e5\u8be2\u8d39\u7528\u5f52\u5c5e");
        List<String> outCodes = finLogisticsReportEos.stream().map(FinLogisticsReportDto::getWarehouseOutCode).distinct().collect(Collectors.toList());
        List<String> inCodes = finLogisticsReportEos.stream().map(FinLogisticsReportDto::getWarehouseEnterCode).distinct().collect(Collectors.toList());
        Map<String, FeeAttributionConfigEo> feeAttributionConfigEoMap = this.asyncQueryFeeAttributionConfig(outCodes, inCodes);
        if (ObjectUtils.isNotEmpty(feeAttributionConfigEoMap)) {
            finLogisticsReportEos.forEach(i -> {
                FeeAttributionConfigEo one;
                String key;
                if (StringUtils.isNotBlank((CharSequence)i.getWarehouseEnterCode()) && StringUtils.isNotBlank((CharSequence)i.getWarehouseOutCode()) && feeAttributionConfigEoMap.containsKey(key = String.format("%s%s", i.getWarehouseOutCode(), i.getWarehouseEnterCode())) && (one = (FeeAttributionConfigEo)feeAttributionConfigEoMap.get(key)) != null) {
                    i.setAmountAttribution(one.getCostBelongOrgName());
                }
            });
        }
        this.buildLogisticsReportArea(finLogisticsReportEos);
        this.mergeChildBindingMaster(finLogisticsReportEos);
        return finLogisticsReportEos;
    }

    private List<String> queryScrapTypeOtherOrder(List<DailyDeliveryReportDto> reportDtoList) {
        List orderEoList;
        List otherOrderList = reportDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getRelevanceNo()) && StringUtils.isNotBlank((CharSequence)f.getBusinessType()) && f.getBusinessType().equals("other_out")).map(DailyDeliveryReportDto::getRelevanceNo).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(otherOrderList) && CollectionUtils.isNotEmpty((Collection)(orderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().in((Object)"storage_order_no", otherOrderList)).eq((Object)"business_type_name", (Object)"\u62a5\u5e9f\u51fa\u5e93")).list()))) {
            return orderEoList.stream().map(CsOtherStorageOrderEo::getStorageOrderNo).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private void mergeChildBindingMaster(List<FinLogisticsReportDto> reportDtoList) {
        logger.info("\u5408\u5355\u5b50\u5355\u7ed1\u5b9a\u4e3b\u5355");
        Map<String, Long> mergeMasterMap = reportDtoList.stream().filter(f -> f.getType().equals(LogisticDocumentTypeEnum.MERGE_MASTER.getCode().toString()) && StringUtils.isNotBlank((CharSequence)f.getWmsMergeDocumentNo())).collect(Collectors.toMap(FinLogisticsReportDto::getWmsMergeDocumentNo, FinLogisticsReportDto::getLinkDailyReportId, (a1, a2) -> a2));
        List mergeChildOrderList = reportDtoList.stream().filter(f -> f.getType().equals(LogisticDocumentTypeEnum.MERGE_CHILD.getCode().toString()) && StringUtils.isNotBlank((CharSequence)f.getJoinMergeDocumentNo())).map(FinLogisticsReportDto::getJoinMergeDocumentNo).collect(Collectors.toList());
        reportDtoList.forEach(report -> {
            if (report.getType().equals(LogisticDocumentTypeEnum.MERGE_MASTER.getCode().toString())) {
                if (StringUtils.isNotBlank((CharSequence)report.getWmsMergeDocumentNo()) && mergeChildOrderList.contains(report.getWmsMergeDocumentNo())) {
                    report.setMergeCode(report.getLinkDailyReportId().toString());
                } else {
                    report.setType(LogisticDocumentTypeEnum.MERGE_OTHER.getCode().toString());
                }
            }
            if (report.getType().equals(LogisticDocumentTypeEnum.MERGE_CHILD.getCode().toString()) && mergeMasterMap.containsKey(report.getJoinMergeDocumentNo())) {
                report.setMergeCode(((Long)mergeMasterMap.get(report.getJoinMergeDocumentNo())).toString());
            }
        });
    }

    @Override
    public void calculateLogisticStatisticDataForDailyDeliveryReport(List<FinLogisticsReportDto> reportDtoList) {
        if (CollectionUtils.isEmpty(reportDtoList)) {
            logger.info("\u65e0\u8ba1\u7b97\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u62a5\u8868\u6570\u636e");
            return;
        }
        logger.info("\u8ba1\u7b97\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u62a5\u8868\u6570\u636e\uff08\u6765\u6e90\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\uff09\uff1a{}", (Object)JSON.toJSONString(reportDtoList));
        HashMap reportMapDto = new HashMap();
        ArrayList finLogisticsReportDtoList = new ArrayList();
        ArrayList exceptionReportDtoList = new ArrayList();
        for (FinLogisticsReportDto reportEo : reportDtoList) {
            logger.info("\u8ba1\u7b97\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u62a5\u8868\u6570\u636e\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reportEo));
            if (Objects.equals(reportEo.getTransportType(), CsShipmentLogisticsTypeEnum.ZT.getDesc()) || Objects.equals(reportEo.getTransportType(), CsShipmentLogisticsTypeEnum.DF.getDesc()) || Objects.equals(reportEo.getLogisticCompany(), CsShipmentLogisticsTypeEnum.ZT.getDesc())) {
                logger.info("\u627f\u8fd0\u65b9\u5f0f\u4e3a \u81ea\u63d0\u3001\u5230\u4ed8 \u4e0d\u5408\u5355\u3001\u4e0d\u8ba1\u8d39");
                reportEo.setStatus(Integer.valueOf(0));
                reportEo.setAbnormalCauses(null);
                reportEo.setBillingFeeFlag(YesNoEnum.NO.getValue());
                this.calculateLogisticStatisticDefaultAmount(reportEo);
                this.setNoBillReasonCauses(reportEo, "\u627f\u8fd0\u65b9\u5f0f\u4e3a\u81ea\u63d0\u3001\u5230\u4ed8\u4e0d\u8ba1\u8d39");
                continue;
            }
            if ((Objects.equals(reportEo.getBusinessType(), "claim_reissue") || Objects.equals(reportEo.getBusinessType(), "compensation_order")) && StringUtils.isNotBlank((CharSequence)reportEo.getCustomerStr()) && StringUtils.isNotBlank((CharSequence)reportEo.getCustomerName()) && reportEo.getCustomerStr().contains(reportEo.getCustomerName())) {
                logger.info("\u7d22\u8d54\u8865\u53d1\u3001\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1\u5355\u636e\u5ba2\u6237\u540d\u79f0\u4e0e\u627f\u8fd0\u5546\u540d\u79f0\u4e00\u81f4\u4e0d\u8ba1\u8d39");
                reportEo.setStatus(Integer.valueOf(0));
                reportEo.setAbnormalCauses(null);
                reportEo.setBillingFeeFlag(YesNoEnum.NO.getValue());
                this.calculateLogisticStatisticDefaultAmount(reportEo);
                this.setNoBillReasonCauses(reportEo, "\u7d22\u8d54\u8865\u53d1\u3001\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1\u5355\u636e\u5ba2\u6237\u540d\u79f0\u4e0e\u627f\u8fd0\u5546\u540d\u79f0\u4e00\u81f4\u4e0d\u8ba1\u8d39");
                continue;
            }
            if (ObjectUtils.isNotEmpty((Object)reportEo.getBillingFeeFlag()) && reportEo.getBillingFeeFlag().equals(YesNoEnum.NO.getValue())) {
                reportEo.setStatus(YesNoEnum.NO.getValue());
                reportEo.setAbnormalCauses(null);
                logger.info("\u4e0d\u8ba1\u8d39\u5355\u636e\u4e0d\u8fdb\u884c\u8ba1\u7b97");
                continue;
            }
            if (ObjectUtils.isNotEmpty((Object)reportEo.getStatus()) && reportEo.getStatus().equals(YesNoEnum.YES.getValue())) {
                logger.info("\u5f02\u5e38\u5355\u636e\u4e0d\u8fdb\u884c\u8ba1\u7b97");
                continue;
            }
            FinLogisticsReportDto executeResult = GateWayFactory.getGateWayService(reportEo.getChargeMode()).execute(reportEo);
            BeanUtils.copyProperties((Object)executeResult, (Object)reportEo);
        }
    }

    @Override
    public void delLogisticStatisticDataForDailyDeliveryReport(LogisticStatisticReqDto logisticStatisticReqDto) {
        logger.info("\u5220\u9664\u5386\u53f2\u6570\u636e\uff08\u6765\u6e90\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\uff09\uff1a{}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().ge((Object)"outbound_time", (Object)logisticStatisticReqDto.getStartTime())).le((Object)"outbound_time", (Object)logisticStatisticReqDto.getEndTime())).in(CollectionUtil.isNotEmpty((Collection)logisticStatisticReqDto.getLinkDailyReportIds()), (Object)"link_daily_report_id", (Collection)logisticStatisticReqDto.getLinkDailyReportIds())).in(CollectionUtil.isNotEmpty((Collection)logisticStatisticReqDto.getLinkDailyReportIds()), (Object)"merge_code", (Collection)logisticStatisticReqDto.getLinkDailyReportIds())).in(CollectionUtil.isNotEmpty((Collection)logisticStatisticReqDto.getWarehouseCodeNameList()), (Object)"warehouse_name", (Collection)logisticStatisticReqDto.getWarehouseCodeNameList())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List ids = list.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.finLogisticDetailDas.logicDeleteByIds(ids);
        }
    }

    @Override
    public void saveLogisticStatisticDataForDailyDeliveryReport(List<FinLogisticsReportDto> reportDtoList) {
        logger.info("\u4fdd\u5b58\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u62a5\u8868\u6570\u636e\uff08\u6765\u6e90\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\uff09\uff1a{}", (Object)JSON.toJSONString(reportDtoList));
        List finLogisticDetailEoList = BeanUtil.copyToList(reportDtoList, FinLogisticDetailEo.class);
        this.finLogisticDetailDas.insertBatch(finLogisticDetailEoList);
    }

    @Override
    public PageInfo<FinLogisticDetailRespDto> queryByPageForDailyDeliveryReport(FinLogisticReportReqDto reqDto) {
        logger.info("\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u62a5\u8868\u6570\u636e\u5206\u9875\u67e5\u8be2\uff08\u6765\u6e90\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\uff09\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo pageInfo = this.finLogisticDetailDas.queryPageForDailyDeliveryReport(reqDto);
        if (CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return pageInfo;
        }
        List mergeCodeList = pageInfo.getList().stream().filter(f -> f.getType().equals(LogisticDocumentTypeEnum.MERGE_CHILD.getCode().toString()) && StringUtils.isNotBlank((CharSequence)f.getMergeCode())).map(FinLogisticDetailRespDto::getMergeCode).collect(Collectors.toList());
        Map masterListMap = new HashMap();
        if (CollectionUtil.isNotEmpty(mergeCodeList)) {
            List masterList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().eq((Object)"type", (Object)LogisticDocumentTypeEnum.MERGE_MASTER.getCode())).in((Object)"merge_code", mergeCodeList)).list();
            masterListMap = Optional.ofNullable(masterList).map(m -> m.stream().collect(Collectors.toMap(FinLogisticDetailEo::getMergeCode, Function.identity(), (v1, v2) -> v2))).orElse(new HashMap());
        }
        HashMap finalMasterListMap = masterListMap;
        pageInfo.getList().forEach(info -> {
            if (info.getType().equals(LogisticDocumentTypeEnum.MERGE_CHILD.getCode().toString()) && finalMasterListMap.containsKey(info.getMergeCode())) {
                FinLogisticDetailRespDto masterDetailRespDto = (FinLogisticDetailRespDto)BeanUtil.copyProperties(finalMasterListMap.get(info.getMergeCode()), FinLogisticDetailRespDto.class, (String[])new String[0]);
                if (ObjectUtils.isNotEmpty((Object)masterDetailRespDto.getSpecialAmount())) {
                    masterDetailRespDto.setTotalTransportAmount(ObjectUtils.isEmpty((Object)masterDetailRespDto.getTotalTransportAmount()) ? masterDetailRespDto.getSpecialAmount() : masterDetailRespDto.getTotalTransportAmount().add(masterDetailRespDto.getSpecialAmount()));
                }
                info.setMasterDetailRespDto(masterDetailRespDto);
            }
            if (ObjectUtils.isNotEmpty((Object)info.getSpecialAmount())) {
                info.setTotalTransportAmount(ObjectUtils.isEmpty((Object)info.getTotalTransportAmount()) ? info.getSpecialAmount() : info.getTotalTransportAmount().add(info.getSpecialAmount()));
            }
        });
        return pageInfo;
    }

    @Override
    public ReInsuranceBillCountDto queryLogisticsAbnormalCountForDailyDeliveryReport(FinLogisticReportReqDto reqDto) {
        logger.info("\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u62a5\u8868\u6570\u636e\u5206\u9875\u67e5\u8be2\u5f02\u5e38\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.finLogisticDetailDas.queryLogisticsAbnormalCount(reqDto);
    }

    @Override
    public ReInsuranceBillCountDto queryLogisticsCountForDailyDeliveryReport(FinLogisticReportReqDto reqDto) {
        logger.info("\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u62a5\u8868\u6570\u636e\u5206\u9875\u67e5\u8be2\u4f53\u79ef\uff0c\u91cd\u91cf\uff0c\u8d39\u7528\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        logger.info("\u4f53\u79ef\uff0c\u91cd\u91cf\u7edf\u8ba1");
        ReInsuranceBillCountDto resultDto = this.finLogisticDetailDas.queryLogisticsCount(reqDto);
        logger.info("\u8d39\u7528\u7edf\u8ba1");
        ReInsuranceBillCountDto reInsuranceBillCountDto = this.finLogisticDetailDas.queryLogisticsCountTotalAmount(reqDto);
        if (ObjectUtils.isNotEmpty((Object)reInsuranceBillCountDto)) {
            resultDto.setLogisticsCostTotal(reInsuranceBillCountDto.getLogisticsCostTotal());
        }
        return resultDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSpecial(FinLogisticDetailReqDto reqDto) {
        logger.info("\u66f4\u65b0\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u7279\u6b8a\u8d39\u7528\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((ObjectUtils.isEmpty((Object)reqDto.getId()) && CollectionUtil.isEmpty((Collection)reqDto.getIds()) ? 1 : 0) != 0, (String)"\u8bf7\u6c42id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((StringUtils.isBlank((CharSequence)reqDto.getSpecialType()) || ObjectUtils.isEmpty((Object)reqDto.getSpecialAmount()) ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u7279\u6b8a\u8d39\u7528\u7c7b\u578b\u3001\u7279\u6b8a\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        if (ObjectUtils.isNotEmpty((Object)reqDto.getId())) {
            reqDto.setIds((List)com.google.common.collect.Lists.newArrayList((Object[])new Long[]{reqDto.getId()}));
        }
        List detailEoList = this.finLogisticDetailDas.selectByIds(reqDto.getIds());
        detailEoList.forEach(eo -> {
            if (eo.getType().equals(LogisticDocumentTypeEnum.MERGE_CHILD.getCode().toString()) && StringUtils.isNotBlank((CharSequence)eo.getMergeCode())) {
                List masterOrder = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().eq((Object)"type", (Object)LogisticDocumentTypeEnum.MERGE_MASTER.getCode())).eq((Object)"merge_code", (Object)eo.getMergeCode())).list();
                if (CollectionUtils.isNotEmpty((Collection)masterOrder)) {
                    FinLogisticDetailEo detailEo = new FinLogisticDetailEo();
                    detailEo.setId(((FinLogisticDetailEo)masterOrder.get(0)).getId());
                    detailEo.setSpecialType(reqDto.getSpecialType());
                    detailEo.setSpecialAmount(reqDto.getSpecialAmount());
                    this.finLogisticDetailDas.updateSelective((BaseEo)detailEo);
                }
            } else {
                FinLogisticDetailEo detailEo = new FinLogisticDetailEo();
                detailEo.setId(eo.getId());
                detailEo.setSpecialType(reqDto.getSpecialType());
                detailEo.setSpecialAmount(reqDto.getSpecialAmount());
                this.finLogisticDetailDas.updateSelective((BaseEo)detailEo);
            }
        });
    }

    @Override
    public List<FinLogisticDetailRespDto> queryDetailList(FinLogisticDetailReqDto reqDto) {
        AssertUtil.isFalse((CollectionUtil.isEmpty((Collection)reqDto.getIds()) && CollectionUtil.isEmpty((Collection)reqDto.getMergeCodeList()) ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        logger.info("\u67e5\u8be2\u7269\u6d41\u8d39\u7528\u660e\u7ec6\u6570\u636equeryDetailList\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List detailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().eq(StringUtils.isNotBlank((CharSequence)reqDto.getType()), (Object)"type", (Object)reqDto.getType())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getIds()), (Object)"id", (Collection)reqDto.getIds())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getMergeCodeList()), (Object)"merge_code", (Collection)reqDto.getMergeCodeList())).list();
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            return BeanUtil.copyToList((Collection)detailEoList, FinLogisticDetailRespDto.class);
        }
        return new ArrayList<FinLogisticDetailRespDto>();
    }

    @Override
    public Long updOrIns(FinLogisticDetailReqDto reqDto) {
        logger.info("\u66f4\u65b0\u6216\u65b0\u589e\u7269\u6d41\u8d39\u7528\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtils.isNotEmpty((Object)reqDto.getId())) {
            FinLogisticDetailEo detailEo = (FinLogisticDetailEo)this.finLogisticDetailDas.selectByPrimaryKey(reqDto.getId());
            AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)detailEo), (String)"\u627e\u4e0d\u5230\u5355\u636e");
            FinLogisticDetailEo updDetailEo = (FinLogisticDetailEo)BeanUtil.copyProperties((Object)reqDto, FinLogisticDetailEo.class, (String[])new String[0]);
            updDetailEo.setId(detailEo.getId());
            this.finLogisticDetailDas.updateSelective((BaseEo)updDetailEo);
            if (StringUtils.isNotBlank((CharSequence)detailEo.getMergeCode())) {
                logger.info("\u8054\u52a8\u66f4\u65b0\u5b50\u5355\u7684\u8d39\u7528\u5f52\u5c5e");
                List cilList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().eq((Object)"merge_code", (Object)detailEo.getMergeCode())).eq((Object)"type", (Object)LogisticDocumentTypeEnum.MERGE_CHILD.getCode())).list();
                if (CollectionUtil.isNotEmpty((Collection)cilList)) {
                    logger.info("\u9700\u66f4\u65b0\u7684\u5b50\u5355\uff1a{}", (Object)JSON.toJSONString((Object)cilList));
                    cilList.forEach(cil -> {
                        cil.setAmountAttribution(updDetailEo.getAmountAttribution());
                        this.finLogisticDetailDas.updateSelective((BaseEo)cil);
                    });
                } else {
                    logger.info("\u65e0\u5b50\u5355\u9700\u66f4\u65b0");
                }
            }
            return detailEo.getId();
        }
        FinLogisticDetailEo detailEo = (FinLogisticDetailEo)BeanUtil.copyProperties((Object)reqDto, FinLogisticDetailEo.class, (String[])new String[0]);
        this.finLogisticDetailDas.insert((BaseEo)detailEo);
        return detailEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByIds(List<Long> ids) {
        logger.info("\u6839\u636eid\u5220\u9664\u7269\u6d41\u8d39\u7528\uff1a{}", ids);
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().in((Object)"id", ids)).eq((Object)"placed_flag", (Object)1)).list();
        AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)list), (String)"\u5b58\u5728\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u5220\u9664");
        this.finLogisticDetailDas.logicDeleteByIds(ids);
    }

    private void calculateLogisticStatisticDefaultAmount(FinLogisticsReportDto reportDto) {
        reportDto.setTransportPrice(BigDecimal.ZERO);
        reportDto.setTransportAmount(BigDecimal.ZERO);
        reportDto.setTotalTransportAmount(BigDecimal.ZERO);
        reportDto.setMinCharge(BigDecimal.ZERO);
        reportDto.setDeliveryAmount(BigDecimal.ZERO);
        reportDto.setUnloadAmount(BigDecimal.ZERO);
        reportDto.setOilPrice(BigDecimal.ZERO);
        reportDto.setOilTotalPrice(BigDecimal.ZERO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void asyncEditAddress(FinLogisticsReportEditReqDto editAddress) {
        logger.info("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u4fee\u6539\u5730\u5740 {}", (Object)JSON.toJSONString((Object)editAddress));
        FinLogisticDetailEo detailEo = (FinLogisticDetailEo)this.finLogisticDetailDas.selectByPrimaryKey(editAddress.getEditId());
        detailEo.setHarvestAddress(editAddress.getHarvestAddress());
        detailEo.setProvince(editAddress.getProvince());
        detailEo.setCity(editAddress.getCity());
        detailEo.setCityCode(editAddress.getCityCode());
        detailEo.setArea(editAddress.getArea());
        detailEo.setAreaCode(editAddress.getAreaCode());
        this.finLogisticDetailDas.updateSelective((BaseEo)detailEo);
    }

    private String buildNewAddress(FinLogisticsReportDto i, String oldProvince, String oldCity, String oldArea) {
        String oldAdd = oldProvince + oldCity + oldArea;
        String newAdd = i.getProvince() + i.getCity() + i.getArea();
        return i.getHarvestAddress().replaceAll(oldAdd, newAdd);
    }

    private void shareSpecialAmount(FinLogisticsReportEditReqDto editReqDto, List<FinLogisticDetailEo> detailEos) {
        BigDecimal specialAmount = editReqDto.getSpecialAmount();
        if (specialAmount == null) {
            detailEos.forEach(i -> {
                if (StringUtils.isNotBlank((CharSequence)editReqDto.getSpecialType())) {
                    i.setSpecialType(editReqDto.getSpecialType());
                }
                if (editReqDto.getSpecialAmount() != null) {
                    i.setSpecialAmount(editReqDto.getSpecialAmount());
                }
                if (StringUtils.isNotBlank((CharSequence)editReqDto.getRemark())) {
                    i.setRemark(editReqDto.getRemark());
                }
            });
        } else {
            BigDecimal shareAmount = BigDecimal.ZERO;
            for (int i2 = 0; i2 < detailEos.size(); ++i2) {
                FinLogisticDetailEo eo = detailEos.get(i2);
                if (StringUtils.isNotBlank((CharSequence)editReqDto.getSpecialType())) {
                    eo.setSpecialType(editReqDto.getSpecialType());
                }
                if (editReqDto.getSpecialAmount() != null) {
                    eo.setSpecialAmount(editReqDto.getSpecialAmount());
                }
                if (StringUtils.isNotBlank((CharSequence)editReqDto.getRemark())) {
                    eo.setRemark(editReqDto.getRemark());
                }
                if (i2 == detailEos.size() - 1) {
                    eo.setSpecialAmount(specialAmount.subtract(shareAmount));
                    continue;
                }
                if (eo.getRatio() == null) continue;
                BigDecimal lineSpecialAmount = specialAmount.multiply(eo.getRatio());
                eo.setSpecialAmount(lineSpecialAmount);
                shareAmount = shareAmount.add(lineSpecialAmount);
            }
        }
    }

    private Map<String, List<FinLogisticsReportDto>> calculateData(List<FinLogisticsReportDto> totalDataList, Long contractId) {
        logger.info("\u7269\u6d41\u8d39\u7528\u8ba1\u7b97\u3001\u5355\u636e\u5408\u5e76\u5355\u636e {}\uff0c{}", (Object)JSON.toJSONString(totalDataList), (Object)contractId);
        if (CollectionUtils.isEmpty(totalDataList)) {
            return new HashMap<String, List<FinLogisticsReportDto>>();
        }
        HashMap<String, List<FinLogisticsReportDto>> reportMapDto = new HashMap<String, List<FinLogisticsReportDto>>();
        ArrayList<FinLogisticsReportDto> finLogisticsReportDtoList = new ArrayList<FinLogisticsReportDto>();
        ArrayList<FinLogisticsReportDto> exceptionReportDtoList = new ArrayList<FinLogisticsReportDto>();
        for (FinLogisticsReportDto reportEo : totalDataList) {
            logger.info("calculateData\u5355\u636e\u5904\u7406 {}", (Object)JSON.toJSONString((Object)reportEo));
            if (1 == reportEo.getStatus()) {
                logger.info("\u5f02\u5e38\u5355\u636e\u4e0d\u8fdb\u884c\u8ba1\u7b97");
                exceptionReportDtoList.add(reportEo);
                continue;
            }
            if (reportEo.getTransportType().equals(CsShipmentLogisticsTypeEnum.ZT.getDesc()) || reportEo.getTransportType().equals(CsShipmentLogisticsTypeEnum.DF.getDesc())) {
                logger.info("\u627f\u8fd0\u65b9\u5f0f\u4e3a \u81ea\u63d0\u3001\u5230\u4ed8 \u4e0d\u5408\u5355\u3001\u4e0d\u8ba1\u8d39");
                reportEo.setStatus(Integer.valueOf(0));
                reportEo.setAbnormalCauses(null);
                reportEo.setTransportPrice(BigDecimal.ZERO);
                reportEo.setTransportAmount(BigDecimal.ZERO);
                reportEo.setTotalTransportAmount(BigDecimal.ZERO);
                reportEo.setIfMerge(Boolean.valueOf(false));
                reportEo.setMinCharge(BigDecimal.ZERO);
                reportEo.setDeliveryAmount(BigDecimal.ZERO);
                reportEo.setUnloadAmount(BigDecimal.ZERO);
                reportEo.setOilPrice(BigDecimal.ZERO);
                reportEo.setOilTotalPrice(BigDecimal.ZERO);
                finLogisticsReportDtoList.add(reportEo);
                continue;
            }
            if ((reportEo.getBusinessType().equals("claim_reissue") || reportEo.getBusinessType().equals("compensation_order")) && StringUtils.isNotBlank((CharSequence)reportEo.getCustomerStr()) && StringUtils.isNotBlank((CharSequence)reportEo.getCustomerName()) && reportEo.getCustomerStr().contains(reportEo.getCustomerName())) {
                logger.info("\u7d22\u8d54\u8865\u53d1\u3001\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1\u5355\u636e\u5ba2\u6237\u540d\u79f0\u4e0e\u627f\u8fd0\u5546\u540d\u79f0\u4e00\u81f4\uff0c\u4e0d\u5408\u5355\uff0c\u4e0d\u8ba1\u8d39");
                reportEo.setStatus(Integer.valueOf(0));
                reportEo.setAbnormalCauses(null);
                reportEo.setTransportPrice(BigDecimal.ZERO);
                reportEo.setTransportAmount(BigDecimal.ZERO);
                reportEo.setTotalTransportAmount(BigDecimal.ZERO);
                reportEo.setIfMerge(Boolean.valueOf(false));
                reportEo.setMinCharge(BigDecimal.ZERO);
                reportEo.setDeliveryAmount(BigDecimal.ZERO);
                reportEo.setUnloadAmount(BigDecimal.ZERO);
                reportEo.setOilPrice(BigDecimal.ZERO);
                reportEo.setOilTotalPrice(BigDecimal.ZERO);
                finLogisticsReportDtoList.add(reportEo);
                continue;
            }
            FinLogisticsReportDto reportDto = GateWayFactory.getGateWayService(reportEo.getChargeMode()).execute(reportEo);
            finLogisticsReportDtoList.add(reportDto);
            logger.info("\u6839\u636e\u8ba1\u7b97\u65b9\u5f0f\u8ba1\u7b97\u8d39\u7528\u7ed3\u675f");
        }
        logger.info("\u8ba1\u7b97\u540e\u8d39\u7528\u6570\u636e {}", (Object)JSON.toJSONString(finLogisticsReportDtoList));
        if (CollectionUtils.isNotEmpty(finLogisticsReportDtoList)) {
            BigDecimal confluentDistance = BigDecimal.valueOf(1000L);
            try {
                logger.info("\u67e5\u8be2\u5408\u5355\u8ddd\u79bb");
                RestResponse dict = this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "LOGISTICS_EXPENSE_ORDER");
                DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dict);
                if (dictDto != null && StringUtils.isNotBlank((CharSequence)dictDto.getValue())) {
                    confluentDistance = new BigDecimal(dictDto.getValue()).multiply(BigDecimal.valueOf(1000L));
                }
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5408\u5355\u8ddd\u79bb\u62a5\u9519", (Throwable)e);
            }
            List notMergeList = finLogisticsReportDtoList.stream().filter(f -> f.getIfMerge() == false || StringUtils.isBlank((CharSequence)f.getLngLat())).collect(Collectors.toList());
            logger.info("\u7b5b\u9009\u4e0d\u53c2\u4e0e\u5408\u5355\u5355\u636e {}", (Object)JSON.toJSONString(notMergeList));
            Map<String, List<FinLogisticsReportDto>> mapListGroupByProvince = finLogisticsReportDtoList.stream().filter(f -> f.getIfMerge() != false && StringUtils.isNotBlank((CharSequence)f.getLngLat())).collect(Collectors.groupingBy(dto -> DateTimeUtils.formatDate(dto.getOutboundTime(), "yyyy-MM-dd") + "_" + dto.getWarehouseName() + "_" + dto.getChargeMode() + "_" + dto.getLogisticCompany() + "_" + dto.getTransportType()));
            logger.info("\u7b5b\u9009\u53c2\u4e0e\u5408\u5355\u5355\u636e {}", (Object)JSON.toJSONString(mapListGroupByProvince));
            ArrayList groupMapList = new ArrayList();
            ArrayList nonGroupMapList = new ArrayList();
            BigDecimal finalConfluentDistance = confluentDistance;
            mapListGroupByProvince.forEach((name, mapByNameList) -> {
                logger.info("calculateData\u5904\u7406\u5408\u5e76\u96c6\u5408 {}\uff0c{}", name, (Object)JSON.toJSONString((Object)mapByNameList));
                Map<String, List<FinLogisticsReportDto>> stringListMap = this.calculateMergeExt((List<FinLogisticsReportDto>)mapByNameList, finalConfluentDistance);
                logger.info("calculateData\u5904\u7406\u5408\u5e76\u96c6\u5408\u7ed3\u679c {}", (Object)JSON.toJSONString(stringListMap));
                for (List<FinLogisticsReportDto> list : stringListMap.values()) {
                    if (list.size() == 1) {
                        logger.info("\u5355\u636e\u53ea\u6709\u4e00\u6761\uff0c\u8bf4\u660e\u4e0d\u5408\u5e76");
                        nonGroupMapList.addAll(list);
                        continue;
                    }
                    logger.info("\u5355\u636e\u53ea\u6709\u4e00\u6761\uff0c\u8bf4\u660e\u4e0d\u5408\u5e76");
                    FinLogisticsReportDto reportDto = this.setAndReCalData(list);
                    if (reportDto == null) continue;
                    reportDto.setType(LogisticDocumentTypeEnum.MERGE.getCode().toString());
                    reportDto.getFinLogisticsReportDtos().forEach(i -> i.setType(LogisticDocumentTypeEnum.MERGE.getCode().toString()));
                    groupMapList.add(reportDto);
                }
            });
            nonGroupMapList.addAll(notMergeList);
            reportMapDto.put(LogisticDataTypeEnum.MERGE.getCode(), groupMapList);
            reportMapDto.put(LogisticDataTypeEnum.SCATTERED.getCode(), nonGroupMapList);
        }
        if (CollectionUtils.isNotEmpty(exceptionReportDtoList)) {
            reportMapDto.put(LogisticDataTypeEnum.EXCEPTION_TYPE.getCode(), exceptionReportDtoList);
        }
        return reportMapDto;
    }

    private Map<String, List<FinLogisticsReportDto>> calculateDataNew(List<FinLogisticsReportDto> totalDataList, Long contractId) {
        logger.info("\u7269\u6d41\u8d39\u7528\u8ba1\u7b97\u3001\u5355\u636e\u5408\u5e76\u5355\u636e {}\uff0c{}", (Object)JSON.toJSONString(totalDataList), (Object)contractId);
        if (CollectionUtils.isEmpty(totalDataList)) {
            return new HashMap<String, List<FinLogisticsReportDto>>();
        }
        HashMap<String, List<FinLogisticsReportDto>> reportMapDto = new HashMap<String, List<FinLogisticsReportDto>>();
        ArrayList<FinLogisticsReportDto> finLogisticsReportDtoList = new ArrayList<FinLogisticsReportDto>();
        ArrayList<FinLogisticsReportDto> exceptionReportDtoList = new ArrayList<FinLogisticsReportDto>();
        for (FinLogisticsReportDto reportEo : totalDataList) {
            long currentTime = System.currentTimeMillis();
            try {
                logger.info("calculateDataNew\u5355\u636e\u5904\u7406 {}", (Object)JSON.toJSONString((Object)reportEo));
                if (1 == reportEo.getStatus()) {
                    logger.info("\u5f02\u5e38\u5355\u636e\u4e0d\u8fdb\u884c\u8ba1\u7b97");
                    exceptionReportDtoList.add(reportEo);
                    continue;
                }
                if (reportEo.getTransportType().equals(CsShipmentLogisticsTypeEnum.ZT.getDesc()) || reportEo.getTransportType().equals(CsShipmentLogisticsTypeEnum.DF.getDesc())) {
                    logger.info("\u627f\u8fd0\u65b9\u5f0f\u4e3a \u81ea\u63d0\u3001\u5230\u4ed8 \u4e0d\u5408\u5355\u3001\u4e0d\u8ba1\u8d39");
                    reportEo.setStatus(Integer.valueOf(0));
                    reportEo.setAbnormalCauses(null);
                    reportEo.setTransportPrice(BigDecimal.ZERO);
                    reportEo.setTransportAmount(BigDecimal.ZERO);
                    reportEo.setTotalTransportAmount(BigDecimal.ZERO);
                    reportEo.setIfMerge(Boolean.valueOf(false));
                    reportEo.setMinCharge(BigDecimal.ZERO);
                    reportEo.setDeliveryAmount(BigDecimal.ZERO);
                    reportEo.setUnloadAmount(BigDecimal.ZERO);
                    reportEo.setOilPrice(BigDecimal.ZERO);
                    reportEo.setOilTotalPrice(BigDecimal.ZERO);
                    reportEo.setBillingFeeFlag(YesNoEnum.NO.getValue());
                    this.setNoBillReasonCauses(reportEo, "\u627f\u8fd0\u65b9\u5f0f\u4e3a:\u81ea\u63d0\u3001\u5230\u4ed8 \u4e0d\u5408\u5355\u3001\u4e0d\u8ba1\u8d39");
                    finLogisticsReportDtoList.add(reportEo);
                    continue;
                }
                if ((reportEo.getBusinessType().equals("claim_reissue") || reportEo.getBusinessType().equals("compensation_order")) && StringUtils.isNotBlank((CharSequence)reportEo.getCustomerStr()) && StringUtils.isNotBlank((CharSequence)reportEo.getCustomerName()) && reportEo.getCustomerStr().contains(reportEo.getCustomerName())) {
                    logger.info("\u7d22\u8d54\u8865\u53d1\u3001\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1\u5355\u636e\u5ba2\u6237\u540d\u79f0\u4e0e\u627f\u8fd0\u5546\u540d\u79f0\u4e00\u81f4\uff0c\u4e0d\u5408\u5355\uff0c\u4e0d\u8ba1\u8d39");
                    reportEo.setStatus(Integer.valueOf(0));
                    reportEo.setAbnormalCauses(null);
                    reportEo.setTransportPrice(BigDecimal.ZERO);
                    reportEo.setTransportAmount(BigDecimal.ZERO);
                    reportEo.setTotalTransportAmount(BigDecimal.ZERO);
                    reportEo.setIfMerge(Boolean.valueOf(false));
                    reportEo.setMinCharge(BigDecimal.ZERO);
                    reportEo.setDeliveryAmount(BigDecimal.ZERO);
                    reportEo.setUnloadAmount(BigDecimal.ZERO);
                    reportEo.setOilPrice(BigDecimal.ZERO);
                    reportEo.setOilTotalPrice(BigDecimal.ZERO);
                    reportEo.setBillingFeeFlag(YesNoEnum.NO.getValue());
                    this.setNoBillReasonCauses(reportEo, "\u5355\u636e\u5ba2\u6237\u540d\u79f0\u4e0e\u627f\u8fd0\u5546\u540d\u79f0\u4e00\u81f4\uff0c\u4e0d\u5408\u5355\uff0c\u4e0d\u8ba1\u8d39");
                    finLogisticsReportDtoList.add(reportEo);
                    continue;
                }
                FinLogisticsReportDto reportDto = GateWayFactory.getGateWayService(reportEo.getChargeMode()).execute(reportEo);
                finLogisticsReportDtoList.add(reportDto);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            logger.info("\u6839\u636e\u8ba1\u7b97\u65b9\u5f0f\u8ba1\u7b97\u8d39\u7528\u7ed3\u675f \u8ba1\u7b97\u8d39\u7528\u82b1\u8d39\u65f6\u957f {} {}ms", (Object)reportEo.getOutboundCode(), (Object)(System.currentTimeMillis() - currentTime));
        }
        logger.info("\u8ba1\u7b97\u540e\u8d39\u7528\u6570\u636e {}", (Object)JSON.toJSONString(finLogisticsReportDtoList));
        if (CollectionUtils.isNotEmpty(finLogisticsReportDtoList)) {
            BigDecimal confluentDistance = BigDecimal.valueOf(1000L);
            try {
                logger.info("\u67e5\u8be2\u5408\u5355\u8ddd\u79bb");
                RestResponse dict = this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "LOGISTICS_EXPENSE_ORDER");
                DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dict);
                if (dictDto != null && StringUtils.isNotBlank((CharSequence)dictDto.getValue())) {
                    confluentDistance = new BigDecimal(dictDto.getValue()).multiply(BigDecimal.valueOf(1000L));
                }
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5408\u5355\u8ddd\u79bb\u62a5\u9519", (Throwable)e);
            }
            List notMergeList = finLogisticsReportDtoList.stream().filter(f -> f.getIfMerge() == false || StringUtils.isBlank((CharSequence)f.getLngLat())).collect(Collectors.toList());
            logger.info("\u7b5b\u9009\u4e0d\u53c2\u4e0e\u5408\u5355\u5355\u636e {}", (Object)JSON.toJSONString(notMergeList));
            Map<String, List<FinLogisticsReportDto>> mapListGroupByProvince = finLogisticsReportDtoList.stream().filter(f -> f.getIfMerge() != false && StringUtils.isNotBlank((CharSequence)f.getLngLat())).collect(Collectors.groupingBy(dto -> DateTimeUtils.formatDate(dto.getOutboundTime(), "yyyy-MM-dd") + "_" + dto.getWarehouseName() + "_" + dto.getChargeMode() + "_" + dto.getLogisticCompany() + "_" + dto.getTransportType()));
            logger.info("\u7b5b\u9009\u53c2\u4e0e\u5408\u5355\u5355\u636e {}", (Object)JSON.toJSONString(mapListGroupByProvince));
            ArrayList groupMapList = new ArrayList();
            ArrayList nonGroupMapList = new ArrayList();
            BigDecimal finalConfluentDistance = confluentDistance;
            mapListGroupByProvince.forEach((name, mapByNameList) -> {
                logger.info("calculateDataNew\u5904\u7406\u5408\u5e76\u96c6\u5408 {}\uff0c{}", name, (Object)JSON.toJSONString((Object)mapByNameList));
                Map<String, List<FinLogisticsReportDto>> stringListMap = this.calculateMergeExtNew((List<FinLogisticsReportDto>)mapByNameList, finalConfluentDistance);
                logger.info("calculateDataNew\u5904\u7406\u5408\u5e76\u96c6\u5408\u7ed3\u679c {}", (Object)JSON.toJSONString(stringListMap));
                for (List<FinLogisticsReportDto> list : stringListMap.values()) {
                    if (list.size() == 1) {
                        logger.info("\u5355\u636e\u53ea\u6709\u4e00\u6761\uff0c\u8bf4\u660e\u4e0d\u5408\u5e76");
                        nonGroupMapList.addAll(list);
                        continue;
                    }
                    long currentTime = System.currentTimeMillis();
                    logger.info("\u5355\u636e\u6709\u591a\u6761\uff0c\u9700\u8981\u5408\u5e76\u91cd\u7b97");
                    FinLogisticsReportDto reportDto = this.setAndReCalDataNew(list);
                    reportDto.setType(LogisticDocumentTypeEnum.MERGE.getCode().toString());
                    reportDto.getFinLogisticsReportDtos().forEach(i -> i.setType(LogisticDocumentTypeEnum.MERGE.getCode().toString()));
                    groupMapList.add(reportDto);
                    logger.info("\u5408\u5e76\u6570\u636e\u5b8c\u6210 \u5408\u5e76\u82b1\u8d39\u65f6\u957f {} {}ms", (Object)reportDto.getOutboundCode(), (Object)(System.currentTimeMillis() - currentTime));
                }
            });
            nonGroupMapList.addAll(notMergeList);
            reportMapDto.put(LogisticDataTypeEnum.MERGE.getCode(), groupMapList);
            reportMapDto.put(LogisticDataTypeEnum.SCATTERED.getCode(), nonGroupMapList);
        }
        if (CollectionUtils.isNotEmpty(exceptionReportDtoList)) {
            reportMapDto.put(LogisticDataTypeEnum.EXCEPTION_TYPE.getCode(), exceptionReportDtoList);
        }
        return reportMapDto;
    }

    private Map<String, List<FinLogisticsReportDto>> calculateMergeExt(List<FinLogisticsReportDto> reportDtoList, BigDecimal confluentDistance) {
        logger.info("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u6839\u636e\u8ddd\u79bb\u5408\u5355 {},{}", (Object)confluentDistance, (Object)JSON.toJSONString(reportDtoList));
        HashMap<String, List<FinLogisticsReportDto>> resultMap = new HashMap<String, List<FinLogisticsReportDto>>();
        ArrayList<String> alreadyMergeList = new ArrayList<String>();
        for (FinLogisticsReportDto dto : reportDtoList) {
            logger.info("calculateMergeExt\u5904\u7406\u5355\u636e {}", (Object)JSON.toJSONString((Object)dto));
            if (alreadyMergeList.contains(dto.soleKey())) {
                logger.info("\u5df2\u5408\u5e76\uff0c\u8df3\u8fc7");
                continue;
            }
            alreadyMergeList.add(dto.soleKey());
            ArrayList<FinLogisticsReportDto> list = new ArrayList<FinLogisticsReportDto>();
            dto.setMergeRole(Integer.valueOf(1));
            list.add(dto);
            for (FinLogisticsReportDto other : reportDtoList) {
                logger.info("calculateMergeExt\u5bf9\u6bd4\u5355\u636e {}\uff0c{}", (Object)JSON.toJSONString((Object)dto), (Object)JSON.toJSONString((Object)other));
                if (alreadyMergeList.contains(other.soleKey())) {
                    logger.info("\u5df2\u5408\u5e76\uff0c\u8df3\u8fc7");
                    continue;
                }
                if (!other.getLngLat().equals(dto.getLngLat()) && !LbsUtil.distance(other.getLngLat(), dto.getLngLat(), confluentDistance)) continue;
                alreadyMergeList.add(other.soleKey());
                other.setMergeRole(Integer.valueOf(2));
                list.add(other);
            }
            String mergeCode = UUID.randomUUID().toString();
            resultMap.put(mergeCode, list);
        }
        return resultMap;
    }

    private Map<String, List<FinLogisticsReportDto>> calculateMergeExtNew(List<FinLogisticsReportDto> reportDtoList, BigDecimal confluentDistance) {
        logger.info("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u6839\u636e\u8ddd\u79bb\u5408\u5355 {},{}", (Object)confluentDistance, (Object)JSON.toJSONString(reportDtoList));
        HashMap<String, List<FinLogisticsReportDto>> resultMap = new HashMap<String, List<FinLogisticsReportDto>>();
        ArrayList<String> alreadyMergeList = new ArrayList<String>();
        for (FinLogisticsReportDto dto : reportDtoList) {
            logger.info("calculateMergeExtNew\u5904\u7406\u5355\u636e {}", (Object)JSON.toJSONString((Object)dto));
            if (alreadyMergeList.contains(dto.soleKeyNew())) {
                logger.info("\u5df2\u5408\u5e76\uff0c\u8df3\u8fc7");
                continue;
            }
            alreadyMergeList.add(dto.soleKeyNew());
            ArrayList<FinLogisticsReportDto> list = new ArrayList<FinLogisticsReportDto>();
            dto.setMergeRole(Integer.valueOf(1));
            list.add(dto);
            for (FinLogisticsReportDto other : reportDtoList) {
                logger.info("calculateMergeExt\u5bf9\u6bd4\u5355\u636e {}\uff0c{}", (Object)JSON.toJSONString((Object)dto), (Object)JSON.toJSONString((Object)other));
                if (alreadyMergeList.contains(other.soleKeyNew())) {
                    logger.info("\u5df2\u5408\u5e76\uff0c\u8df3\u8fc7");
                    continue;
                }
                if (!Objects.equals(dto.getTransportCode(), other.getTransportCode())) continue;
                alreadyMergeList.add(other.soleKeyNew());
                other.setMergeRole(Integer.valueOf(2));
                list.add(other);
            }
            String mergeCode = UUID.randomUUID().toString();
            resultMap.put(mergeCode, list);
        }
        return resultMap;
    }

    private Map<String, List<FinLogisticsReportDto>> calculateExt(List<FinLogisticsReportDto> reportDtos, BigDecimal confluentDistance) {
        ArrayList<FinLogisticsReportDto> list = new ArrayList<FinLogisticsReportDto>();
        ArrayList<FinLogisticsReportDto> nonGroupList = new ArrayList<FinLogisticsReportDto>();
        List<FinLogisticsReportDto> groupMapList = new ArrayList<FinLogisticsReportDto>();
        for (FinLogisticsReportDto reportDto : reportDtos) {
            String lngLat = reportDto.getLngLat();
            if (StringUtils.isBlank((CharSequence)lngLat)) {
                nonGroupList.add(reportDto);
                continue;
            }
            list.add(reportDto);
        }
        if (CollectionUtil.isNotEmpty(list)) {
            HashSet mergedOrder = Sets.newHashSet();
            groupMapList = this.calculateExt(mergedOrder, list, groupMapList, confluentDistance);
            if (CollectionUtil.isNotEmpty((Collection)mergedOrder) && mergedOrder.size() != list.size()) {
                Set outBoundCodes = groupMapList.stream().map(FinLogisticsReportDto::getOutboundCode).collect(Collectors.toSet());
                list.forEach(i -> {
                    if (!outBoundCodes.contains(i.getOutboundCode())) {
                        nonGroupList.add((FinLogisticsReportDto)i);
                    }
                });
            }
        }
        HashMap<String, List<FinLogisticsReportDto>> reportMapDto = new HashMap<String, List<FinLogisticsReportDto>>();
        reportMapDto.put(LogisticDataTypeEnum.MERGE.getCode(), groupMapList);
        reportMapDto.put(LogisticDataTypeEnum.SCATTERED.getCode(), nonGroupList);
        return reportMapDto;
    }

    private List<FinLogisticsReportDto> calculateExt(Set<String> mergedOrder, List<FinLogisticsReportDto> list, List<FinLogisticsReportDto> mergeList, BigDecimal confluentDistance) {
        Map<String, List<FinLogisticsReportDto>> map = list.stream().collect(Collectors.groupingBy(FinLogisticsReportDto::getLngLat));
        CalculationDto calculationDto = new CalculationDto();
        map.keySet().forEach(i -> {
            ArrayList temporaryMergeList = com.google.common.collect.Lists.newArrayList();
            ArrayList scatteredList = com.google.common.collect.Lists.newArrayList();
            for (FinLogisticsReportDto dto : list) {
                String lngLat = dto.getLngLat();
                if (Objects.equals(i, lngLat)) {
                    temporaryMergeList.add(dto);
                    continue;
                }
                if (LbsUtil.distance(i, lngLat, confluentDistance)) {
                    temporaryMergeList.add(dto);
                    continue;
                }
                scatteredList.add(dto);
            }
            TwoTuple twoTuple = new TwoTuple((Object)temporaryMergeList, (Object)scatteredList);
            if (calculationDto == null || calculationDto.getTwoTuple() == null || CollectionUtil.isEmpty((Collection)((Collection)calculationDto.getTwoTuple().getFirst()))) {
                calculationDto.setUniqueKey(i);
                calculationDto.setTwoTuple(twoTuple);
            } else {
                int size = ((List)calculationDto.getTwoTuple().getFirst()).size();
                if (size < temporaryMergeList.size() && temporaryMergeList.size() >= 2) {
                    calculationDto.setUniqueKey(i);
                    calculationDto.setTwoTuple(twoTuple);
                }
            }
        });
        List first = (List)calculationDto.getTwoTuple().getFirst();
        if (!CollectionUtil.isNotEmpty((Collection)first)) {
            return mergeList;
        }
        String mergeCode = UUID.randomUUID().toString();
        first.forEach(a -> {
            a.setMergeCode(mergeCode);
            if (!mergedOrder.contains(a.getOutboundCode())) {
                mergedOrder.add(a.getOutboundCode());
                mergeList.add((FinLogisticsReportDto)a);
            }
        });
        List second = (List)calculationDto.getTwoTuple().getSecond();
        if (CollectionUtil.isEmpty((Collection)second) || second.size() <= 1) {
            return mergeList;
        }
        this.calculateExt(mergedOrder, second, mergeList, confluentDistance);
        return mergeList;
    }

    private Map<String, List<FinLogisticsReportDto>> calculate(List<FinLogisticsReportDto> reportDtos, BigDecimal confluentDistance) {
        HashMap<String, List<FinLogisticsReportDto>> groupMap = new HashMap<String, List<FinLogisticsReportDto>>();
        if (StringUtils.isNotEmpty((CharSequence)reportDtos.get(0).getLngLat())) {
            String lngLat = reportDtos.get(0).getLngLat();
            if (CollectionUtils.isNotEmpty(reportDtos)) {
                ArrayList<FinLogisticsReportDto> groupList = new ArrayList<FinLogisticsReportDto>();
                ArrayList<FinLogisticsReportDto> nonGroupList = new ArrayList<FinLogisticsReportDto>();
                ArrayList<FinLogisticsReportDto> exceptionGroupList = new ArrayList<FinLogisticsReportDto>();
                for (FinLogisticsReportDto dto : reportDtos) {
                    String[] al = lngLat.split(",");
                    if (StringUtils.isNotEmpty((CharSequence)dto.getLngLat())) {
                        String[] bl = dto.getLngLat().split(",");
                        String result = LbsUtil.distance(Double.parseDouble(al[0]), Double.parseDouble(al[1]), Double.parseDouble(bl[0]), Double.parseDouble(bl[1]));
                        if (StringUtils.isNotEmpty((CharSequence)result)) {
                            if (new BigDecimal(result).compareTo(confluentDistance) <= 0) {
                                groupList.add(dto);
                                continue;
                            }
                            nonGroupList.add(dto);
                            continue;
                        }
                        nonGroupList.add(dto);
                        continue;
                    }
                    exceptionGroupList.add(dto);
                }
                groupMap.put(LogisticDataTypeEnum.MERGE.getCode(), groupList);
                groupMap.put(LogisticDataTypeEnum.SCATTERED.getCode(), nonGroupList);
                groupMap.put(LogisticDataTypeEnum.EXCEPTION_TYPE.getCode(), exceptionGroupList);
            }
        } else {
            groupMap.put(LogisticDataTypeEnum.EXCEPTION_TYPE.getCode(), reportDtos);
        }
        return groupMap;
    }

    private FinLogisticsReportDto setAndReCalData(List<FinLogisticsReportDto> reportDtoList) {
        if (CollectionUtil.isEmpty(reportDtoList)) {
            return null;
        }
        FinLogisticsReportDto finLogisticsReportDto = new FinLogisticsReportDto();
        FinLogisticsReportDto reportDto = reportDtoList.get(0);
        BeanUtils.copyProperties((Object)reportDto, (Object)finLogisticsReportDto);
        finLogisticsReportDto.setId(null);
        BigDecimal totalBox = reportDtoList.stream().map(FinLogisticsReportDto::getBox).reduce(BigDecimal.ZERO, BigDecimal::add);
        finLogisticsReportDto.setTotalBox(totalBox);
        BigDecimal totalVolume = reportDtoList.stream().map(FinLogisticsReportDto::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
        finLogisticsReportDto.setTotalVolume(totalVolume);
        BigDecimal totalWeight = reportDtoList.stream().map(FinLogisticsReportDto::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        finLogisticsReportDto.setTotalWeight(totalWeight);
        finLogisticsReportDto.setBox(totalBox);
        finLogisticsReportDto.setVolume(totalVolume);
        finLogisticsReportDto.setWeight(totalWeight);
        finLogisticsReportDto.setOilPrice(null);
        finLogisticsReportDto.setTransportPrice(null);
        finLogisticsReportDto.setTransportAmount(null);
        finLogisticsReportDto.setMinCharge(null);
        finLogisticsReportDto.setDeliveryAmount(null);
        finLogisticsReportDto.setUnloadAmount(null);
        finLogisticsReportDto.setTotalTransportAmount(null);
        if (Objects.equals(finLogisticsReportDto.getChargeMode(), "6") || Objects.equals(finLogisticsReportDto.getChargeMode(), "7")) {
            finLogisticsReportDto.setTotalTransportAmount(BigDecimal.ZERO);
            finLogisticsReportDto.setTransportAmount(BigDecimal.ZERO);
            finLogisticsReportDto.setShareAmount(BigDecimal.ZERO);
            reportDtoList.forEach(i -> {
                i.setTotalTransportAmount(BigDecimal.ZERO);
                i.setTransportAmount(BigDecimal.ZERO);
                i.setShareAmount(BigDecimal.ZERO);
            });
        } else {
            FinLogisticsReportDto mergeCalculationDto = GateWayFactory.getGateWayService(finLogisticsReportDto.getChargeMode()).execute(finLogisticsReportDto);
            finLogisticsReportDto.setTotalVolume(totalVolume == null ? BigDecimal.ZERO : totalVolume);
            finLogisticsReportDto.setTotalBox(totalBox == null ? BigDecimal.ZERO : totalBox);
            finLogisticsReportDto.setTotalWeight(totalWeight == null ? BigDecimal.ZERO : totalWeight);
            BigDecimal transportPrice = mergeCalculationDto.getTransportPrice();
            finLogisticsReportDto.setTransportPrice(null);
            finLogisticsReportDto.setTransportPrice(transportPrice);
            BigDecimal transportAmount = mergeCalculationDto.getTransportAmount();
            finLogisticsReportDto.setTransportAmount(null);
            finLogisticsReportDto.setTransportAmount(transportAmount);
            BigDecimal minCharge = mergeCalculationDto.getMinCharge();
            finLogisticsReportDto.setMinCharge(null);
            if (minCharge != null) {
                finLogisticsReportDto.setMinCharge(minCharge);
            }
            BigDecimal deliveryAmount = mergeCalculationDto.getDeliveryAmount();
            finLogisticsReportDto.setDeliveryAmount(null);
            if (deliveryAmount != null) {
                finLogisticsReportDto.setDeliveryAmount(deliveryAmount);
            }
            finLogisticsReportDto.setTotalTransportAmount(mergeCalculationDto.getTotalTransportAmount());
            BigDecimal unloadAmount = mergeCalculationDto.getUnloadAmount();
            finLogisticsReportDto.setUnloadAmount(null);
            finLogisticsReportDto.setUnloadAmount(unloadAmount);
            BigDecimal oilPrice = mergeCalculationDto.getOilPrice();
            finLogisticsReportDto.setOilPrice(null);
            finLogisticsReportDto.setOilPrice(oilPrice);
            BigDecimal specialAmount = mergeCalculationDto.getSpecialAmount();
            finLogisticsReportDto.setSpecialAmount(null);
            finLogisticsReportDto.setSpecialAmount(specialAmount);
            finLogisticsReportDto.setPieceVolume(mergeCalculationDto.getPieceVolume());
            this.calculationShareRatioAndAmount(reportDtoList, finLogisticsReportDto);
        }
        finLogisticsReportDto.setFinLogisticsReportDtos(reportDtoList);
        return finLogisticsReportDto;
    }

    private FinLogisticsReportDto setAndReCalDataNew(List<FinLogisticsReportDto> reportDtoList) {
        FinLogisticsReportDto finLogisticsReportDto = new FinLogisticsReportDto();
        FinLogisticsReportDto reportDto = reportDtoList.get(0);
        BeanUtils.copyProperties((Object)reportDto, (Object)finLogisticsReportDto);
        finLogisticsReportDto.setId(null);
        BigDecimal totalBox = reportDtoList.stream().map(FinLogisticsReportDto::getBox).reduce(BigDecimal.ZERO, BigDecimal::add);
        finLogisticsReportDto.setTotalBox(totalBox);
        BigDecimal totalVolume = reportDtoList.stream().map(FinLogisticsReportDto::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
        finLogisticsReportDto.setTotalVolume(totalVolume);
        BigDecimal totalWeight = reportDtoList.stream().map(FinLogisticsReportDto::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        finLogisticsReportDto.setTotalWeight(totalWeight);
        finLogisticsReportDto.setBox(totalBox);
        finLogisticsReportDto.setVolume(totalVolume);
        finLogisticsReportDto.setWeight(totalWeight);
        finLogisticsReportDto.setOilPrice(null);
        finLogisticsReportDto.setTransportPrice(null);
        finLogisticsReportDto.setTransportAmount(null);
        finLogisticsReportDto.setMinCharge(null);
        finLogisticsReportDto.setDeliveryAmount(null);
        finLogisticsReportDto.setUnloadAmount(null);
        finLogisticsReportDto.setTotalTransportAmount(null);
        if (Objects.equals(finLogisticsReportDto.getChargeMode(), "6") || Objects.equals(finLogisticsReportDto.getChargeMode(), "7")) {
            finLogisticsReportDto.setTotalTransportAmount(BigDecimal.ZERO);
            finLogisticsReportDto.setTransportAmount(BigDecimal.ZERO);
            finLogisticsReportDto.setShareAmount(BigDecimal.ZERO);
            reportDtoList.forEach(i -> {
                i.setTotalTransportAmount(BigDecimal.ZERO);
                i.setTransportAmount(BigDecimal.ZERO);
                i.setShareAmount(BigDecimal.ZERO);
            });
        } else {
            FinLogisticsReportDto mergeCalculationDto = GateWayFactory.getGateWayService(finLogisticsReportDto.getChargeMode()).execute(finLogisticsReportDto);
            finLogisticsReportDto.setTotalVolume(totalVolume == null ? BigDecimal.ZERO : totalVolume);
            finLogisticsReportDto.setTotalBox(totalBox == null ? BigDecimal.ZERO : totalBox);
            finLogisticsReportDto.setTotalWeight(totalWeight == null ? BigDecimal.ZERO : totalWeight);
            BigDecimal transportPrice = mergeCalculationDto.getTransportPrice();
            finLogisticsReportDto.setTransportPrice(null);
            finLogisticsReportDto.setTransportPrice(transportPrice);
            BigDecimal transportAmount = mergeCalculationDto.getTransportAmount();
            finLogisticsReportDto.setTransportAmount(null);
            finLogisticsReportDto.setTransportAmount(transportAmount);
            BigDecimal minCharge = mergeCalculationDto.getMinCharge();
            finLogisticsReportDto.setMinCharge(null);
            if (minCharge != null) {
                finLogisticsReportDto.setMinCharge(minCharge);
            }
            BigDecimal deliveryAmount = mergeCalculationDto.getDeliveryAmount();
            finLogisticsReportDto.setDeliveryAmount(null);
            if (deliveryAmount != null) {
                finLogisticsReportDto.setDeliveryAmount(deliveryAmount);
            }
            finLogisticsReportDto.setTotalTransportAmount(mergeCalculationDto.getTotalTransportAmount());
            BigDecimal unloadAmount = mergeCalculationDto.getUnloadAmount();
            finLogisticsReportDto.setUnloadAmount(null);
            finLogisticsReportDto.setUnloadAmount(unloadAmount);
            BigDecimal oilPrice = mergeCalculationDto.getOilPrice();
            finLogisticsReportDto.setOilPrice(null);
            finLogisticsReportDto.setOilPrice(oilPrice);
            BigDecimal specialAmount = mergeCalculationDto.getSpecialAmount();
            finLogisticsReportDto.setSpecialAmount(null);
            finLogisticsReportDto.setSpecialAmount(specialAmount);
            finLogisticsReportDto.setPieceVolume(mergeCalculationDto.getPieceVolume());
            this.calculationShareRatioAndAmount(reportDtoList, finLogisticsReportDto);
        }
        finLogisticsReportDto.setFinLogisticsReportDtos(reportDtoList);
        return finLogisticsReportDto;
    }

    private void calculationShareRatioAndAmount(List<FinLogisticsReportDto> reportDtoList, FinLogisticsReportDto merge) {
        logger.info("\u8ba1\u7b97\u5206\u644a\u6bd4\u4f8b\u548c\u5206\u644a\u91d1\u989d {}\uff0c{}", (Object)JSON.toJSONString((Object)merge), (Object)JSON.toJSONString(reportDtoList));
        String chargeMode = merge.getChargeMode();
        switch (ChargeModeEnum.getChargeMode((Integer)Integer.valueOf(chargeMode))) {
            case VOLUME: 
            case VOLUME_TWO: {
                this.pieceVolumeChargingRatio(reportDtoList, merge);
                this.chargingAmount(reportDtoList, merge);
                break;
            }
            case TRANSPORT: 
            case MINIMUM: {
                logger.info("\u6309\u4f53\u79ef\u8ba1\u8d39\uff0c\u6309\u6700\u4f4e\u6536\u8d39\u65b9\u5f0f\u8ba1\u7b97\u6bd4\u4f8b\u53ca\u5206\u644a\u91d1\u989d");
                this.volumeChargingRatio(reportDtoList, merge);
                this.chargingAmount(reportDtoList, merge);
                break;
            }
            case WEIGHT: {
                this.weightChargingRatio(reportDtoList, merge);
                this.chargingAmount(reportDtoList, merge);
            }
        }
    }

    private void pieceVolumeChargingRatio(List<FinLogisticsReportDto> reportDtoList, FinLogisticsReportDto merge) {
        if (Objects.equals("piece", merge.getPieceVolume())) {
            this.pieceChargingRatio(reportDtoList, merge);
        }
        if (Objects.equals("volume", merge.getPieceVolume())) {
            this.volumeChargingRatio(reportDtoList, merge);
        }
    }

    private void minChargeRatio(List<FinLogisticsReportDto> reportDtoList) {
        BigDecimal allocatedRatio = BigDecimal.ZERO;
        for (int i = 0; i < reportDtoList.size(); ++i) {
            FinLogisticsReportDto dto = reportDtoList.get(i);
            if (i == reportDtoList.size() - 1) {
                dto.setRatio(BigDecimal.ONE.subtract(allocatedRatio));
                continue;
            }
            BigDecimal ratio = BigDecimal.ONE.divide(BigDecimal.valueOf(reportDtoList.size()), 20, 3);
            dto.setRatio(ratio);
            allocatedRatio = allocatedRatio.add(ratio);
        }
    }

    private void chargingAmount(List<FinLogisticsReportDto> reportDtoList, FinLogisticsReportDto merge) {
        BigDecimal allocatedTransportAmount = BigDecimal.ZERO;
        BigDecimal allocatedMinChargeAmount = BigDecimal.ZERO;
        BigDecimal allocatedDeliveryAmount = BigDecimal.ZERO;
        BigDecimal allocatedUnloadAmount = BigDecimal.ZERO;
        BigDecimal allocatedOilPrice = BigDecimal.ZERO;
        BigDecimal allocatedSpecialAmount = BigDecimal.ZERO;
        BigDecimal allocatedTotalTransportAmount = BigDecimal.ZERO;
        for (int i = 0; i < reportDtoList.size(); ++i) {
            TwoTuple<BigDecimal, BigDecimal> totalTransportAmount;
            TwoTuple<BigDecimal, BigDecimal> specialAmount;
            TwoTuple<BigDecimal, BigDecimal> oilPrice;
            TwoTuple<BigDecimal, BigDecimal> unloadAmount;
            TwoTuple<BigDecimal, BigDecimal> deliveryAmount;
            TwoTuple<BigDecimal, BigDecimal> minChargeAmount;
            FinLogisticsReportDto dto = reportDtoList.get(i);
            dto.setType(LogisticDocumentTypeEnum.MERGE.getCode().toString());
            dto.setTotalWeight(dto.getWeight());
            dto.setTotalVolume(dto.getVolume());
            dto.setTotalBox(dto.getBox());
            dto.setTransportAmount(null);
            dto.setShareAmount(null);
            dto.setMinCharge(null);
            dto.setDeliveryAmount(null);
            dto.setUnloadAmount(null);
            dto.setOilPrice(null);
            dto.setSpecialAmount(null);
            dto.setTotalTransportAmount(null);
            dto.setTransportPrice(merge.getTransportPrice());
            TwoTuple<BigDecimal, BigDecimal> transportAmount = this.chargingAmount(merge.getTransportAmount(), allocatedTransportAmount, reportDtoList.get(i).getRatio(), i == reportDtoList.size() - 1);
            if (transportAmount != null) {
                dto.setTransportAmount((BigDecimal)transportAmount.getFirst());
                allocatedTransportAmount = (BigDecimal)transportAmount.getSecond();
            }
            if ((minChargeAmount = this.chargingAmount(merge.getMinCharge(), allocatedMinChargeAmount, reportDtoList.get(i).getRatio(), i == reportDtoList.size() - 1)) != null) {
                dto.setMinCharge((BigDecimal)minChargeAmount.getFirst());
                allocatedMinChargeAmount = (BigDecimal)minChargeAmount.getSecond();
            }
            if ((deliveryAmount = this.chargingAmount(merge.getDeliveryAmount(), allocatedDeliveryAmount, reportDtoList.get(i).getRatio(), i == reportDtoList.size() - 1)) != null) {
                dto.setDeliveryAmount((BigDecimal)deliveryAmount.getFirst());
                allocatedDeliveryAmount = (BigDecimal)deliveryAmount.getSecond();
            }
            if ((unloadAmount = this.chargingAmount(merge.getUnloadAmount(), allocatedUnloadAmount, reportDtoList.get(i).getRatio(), i == reportDtoList.size() - 1)) != null) {
                dto.setUnloadAmount((BigDecimal)unloadAmount.getFirst());
                allocatedUnloadAmount = (BigDecimal)unloadAmount.getSecond();
            }
            if ((oilPrice = this.chargingAmount(merge.getOilPrice(), allocatedOilPrice, reportDtoList.get(i).getRatio(), i == reportDtoList.size() - 1)) != null) {
                dto.setOilPrice((BigDecimal)oilPrice.getFirst());
                allocatedOilPrice = (BigDecimal)oilPrice.getSecond();
            }
            if ((specialAmount = this.chargingAmount(merge.getSpecialAmount(), allocatedSpecialAmount, reportDtoList.get(i).getRatio(), i == reportDtoList.size() - 1)) != null) {
                dto.setSpecialAmount((BigDecimal)specialAmount.getFirst());
                allocatedSpecialAmount = (BigDecimal)specialAmount.getSecond();
            }
            if ((totalTransportAmount = this.chargingAmount(merge.getTotalTransportAmount(), allocatedTotalTransportAmount, reportDtoList.get(i).getRatio(), i == reportDtoList.size() - 1)) == null) continue;
            dto.setTotalTransportAmount((BigDecimal)totalTransportAmount.getFirst());
            allocatedTotalTransportAmount = (BigDecimal)totalTransportAmount.getSecond();
            dto.setShareAmount((BigDecimal)totalTransportAmount.getFirst());
        }
    }

    private TwoTuple<BigDecimal, BigDecimal> chargingAmount(BigDecimal totalAmount, BigDecimal allocatedAmount, BigDecimal ratio, boolean lastElement) {
        if (totalAmount == null || ratio == null) {
            return null;
        }
        if (lastElement) {
            return new TwoTuple((Object)totalAmount.subtract(allocatedAmount), (Object)totalAmount);
        }
        BigDecimal amount = totalAmount.multiply(ratio);
        allocatedAmount = allocatedAmount.add(amount);
        return new TwoTuple((Object)amount, (Object)allocatedAmount);
    }

    private void weightChargingRatio(List<FinLogisticsReportDto> reportDtoList, FinLogisticsReportDto merge) {
        BigDecimal mergeTotalWeight = merge.getWeight();
        if (mergeTotalWeight == null || mergeTotalWeight.compareTo(BigDecimal.ZERO) <= 0) {
            reportDtoList.forEach(i -> i.setRatio(BigDecimal.ZERO));
        }
        BigDecimal allocatedWeightRatio = BigDecimal.ZERO;
        for (int i2 = 1; i2 <= reportDtoList.size(); ++i2) {
            FinLogisticsReportDto dto = reportDtoList.get(i2 - 1);
            BigDecimal weight = dto.getWeight();
            if (weight == null) continue;
            if (i2 == reportDtoList.size()) {
                dto.setRatio(BigDecimal.ONE.subtract(allocatedWeightRatio));
                continue;
            }
            BigDecimal ratio = weight.divide(mergeTotalWeight, 20, 3);
            allocatedWeightRatio = allocatedWeightRatio.add(ratio);
            dto.setRatio(ratio);
        }
    }

    private void pieceChargingRatio(List<FinLogisticsReportDto> reportDtoList, FinLogisticsReportDto merge) {
        BigDecimal mergeTotalBox = merge.getBox();
        BigDecimal allocatedBoxRatio = BigDecimal.ZERO;
        for (int i = 1; i <= reportDtoList.size(); ++i) {
            FinLogisticsReportDto dto = reportDtoList.get(i - 1);
            BigDecimal box = dto.getBox();
            if (box == null) continue;
            if (i == reportDtoList.size()) {
                dto.setRatio(BigDecimal.ONE.subtract(allocatedBoxRatio));
                continue;
            }
            if (ObjectUtils.isNotEmpty((Object)mergeTotalBox) && mergeTotalBox.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal ratio = box.divide(mergeTotalBox, 20, 3);
                allocatedBoxRatio = allocatedBoxRatio.add(ratio);
                dto.setRatio(ratio);
                continue;
            }
            dto.setRatio(BigDecimal.ZERO);
        }
    }

    private void volumeChargingRatio(List<FinLogisticsReportDto> reportDtoList, FinLogisticsReportDto merge) {
        BigDecimal mergeTotalVolume = merge.getVolume();
        if (mergeTotalVolume == null || BigDecimal.ZERO.compareTo(mergeTotalVolume) <= 0) {
            reportDtoList.forEach(i -> i.setRatio(BigDecimal.ZERO));
        }
        BigDecimal allocatedVolumeRatio = BigDecimal.ZERO;
        for (int i2 = 1; i2 <= reportDtoList.size(); ++i2) {
            FinLogisticsReportDto dto = reportDtoList.get(i2 - 1);
            BigDecimal volume = dto.getVolume();
            if (volume == null) continue;
            if (i2 == reportDtoList.size()) {
                dto.setRatio(BigDecimal.ONE.subtract(allocatedVolumeRatio));
                continue;
            }
            BigDecimal ratio = volume.divide(mergeTotalVolume, 20, 3);
            allocatedVolumeRatio = allocatedVolumeRatio.add(ratio);
            dto.setRatio(ratio);
        }
    }

    private void setAbnormalCauses(FinLogisticsReportDto msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getAbnormalCauses())) {
            msgDto.setAbnormalCauses(errorMsg);
        } else {
            msgDto.setAbnormalCauses(String.format("%s\u3001%s", msgDto.getAbnormalCauses(), errorMsg));
        }
    }

    private void setNoBillReasonCauses(FinLogisticsReportDto msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getNoBillingReason())) {
            msgDto.setNoBillingReason(errorMsg);
        } else {
            msgDto.setNoBillingReason(String.format("%s\u3001%s", msgDto.getNoBillingReason(), errorMsg));
        }
    }

    private List<FinLogisticsReportDto> selectOutResultOrder(LogisticStatisticReqDto logisticStatisticReqDto) {
        logger.info("selectOutResultOrder\u7edf\u8ba1\u7269\u6d41\u8d39\u7528\u62a5\u8868\u5f85\u751f\u6210\u6570\u636e {}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        if (ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getStartTime()) || ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getEndTime())) {
            logger.info("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff0c\u5f00\u59cb/\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return new ArrayList<FinLogisticsReportDto>();
        }
        ArrayList<FinLogisticsReportDto> finLogisticsReportEos = new ArrayList<FinLogisticsReportDto>();
        logger.info("selectOutResultOrder\u67e5\u8be2\u7269\u6d41\u5546");
        Map<Object, Object> shipmentMap = Maps.newHashMap();
        List shipmentList = ((ExtQueryChainWrapper)this.shipmentEnterpriseDas.filter().eq((Object)"shipment_enterprise_type", (Object)1)).list(Integer.valueOf(1000));
        if (CollectionUtil.isNotEmpty((Collection)shipmentList)) {
            shipmentMap = shipmentList.stream().collect(Collectors.toMap(ShipmentEnterpriseEo::getShipmentEnterpriseCode, Function.identity(), (k1, k2) -> k1));
        }
        Map<String, PcpRegionEo> cityLevelMap = this.asyncCityLevel();
        logger.info("\u83b7\u53d6\u57ce\u5e02\u7b49\u7ea7\u4fe1\u606f {}", (Object)JSON.toJSONString(cityLevelMap));
        Map<String, List<LogisticsRecordEo>> logisticsTemplateMap = this.asyncLogisticsTemplateList();
        logger.info("\u83b7\u53d6\u7269\u6d41\u8d39\u7528\u6a21\u7248\u4fe1\u606f {}", (Object)JSON.toJSONString(logisticsTemplateMap));
        Map<String, OilLinkQueryRespDto> oilLinkMap = this.asyncOilLink(logisticStatisticReqDto.getStartTime(), logisticStatisticReqDto.getEndTime());
        logger.info("\u83b7\u53d6\u8054\u52a8\u6cb9\u4ef7 {}", (Object)JSON.toJSONString(oilLinkMap));
        List<FinLogisticDetailRespDto> detailRespDtoList = this.finLogisticDetailService.selectByDetail(logisticStatisticReqDto);
        Map detailRespDtoMap = detailRespDtoList.stream().collect(Collectors.toMap(FinLogisticDetailRespDto::getOutboundCode, Function.identity(), (v1, v2) -> v2));
        OutResultOrderReqDto filter = new OutResultOrderReqDto();
        filter.setCreateBeginTime(DateTimeUtils.parseDateTime(logisticStatisticReqDto.getStartTime()));
        filter.setCreateEndTime(DateTimeUtils.parseDateTime(logisticStatisticReqDto.getEndTime()));
        filter.setWarehouseCode(logisticStatisticReqDto.getWarehouseCode());
        filter.setShippingCompanyCode(logisticStatisticReqDto.getShippingCompanyCode());
        filter.setShippingType(logisticStatisticReqDto.getShippingType());
        filter.setPageNum(Integer.valueOf(1));
        filter.setPageSize(Integer.valueOf(5000));
        filter.setRelevanceNo(logisticStatisticReqDto.getRelevanceNo());
        filter.setDocumentNos(logisticStatisticReqDto.getDocumentNos());
        logger.info("selectOutResultOrder\u67e5\u8be2\u7269\u6d41\u5355\u636e\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)filter));
        List outResultOrderEoList = this.outResultOrderService.queryConsignmentList(filter).getList();
        while (CollectionUtil.isNotEmpty((Collection)outResultOrderEoList) && outResultOrderEoList.size() > 0) {
            if (CollectionUtils.isNotEmpty((Collection)outResultOrderEoList)) {
                HashSet logicCodes = Sets.newHashSet();
                HashSet orderNos = Sets.newHashSet();
                HashSet saleOrderNos = Sets.newHashSet();
                HashSet otherOrderNos = Sets.newHashSet();
                HashSet refundOrderNos = Sets.newHashSet();
                HashSet preOrderNos = Sets.newHashSet();
                outResultOrderEoList.forEach(i -> {
                    logicCodes.add(i.getInLogicWarehouseCode());
                    logicCodes.add(i.getOutLogicWarehouseCode());
                    if (transferOrderBusinessType.contains(i.getBusinessType())) {
                        orderNos.add(i.getRelevanceNo());
                    }
                    if (saleOrderBusinessType.contains(i.getBusinessType())) {
                        saleOrderNos.add(i.getRelevanceNo());
                    }
                    if (Objects.equals(i.getBusinessType(), CsPcpBusinessTypeEnum.OTHER_OUT.getCode())) {
                        otherOrderNos.add(i.getRelevanceNo());
                    }
                    if (refundOrderBusinessType.contains(i.getBusinessType())) {
                        refundOrderNos.add(i.getRelevanceNo());
                    }
                    preOrderNos.add(i.getPreOrderNo());
                });
                logger.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)logicCodes));
                List logicWarehouseEos = ((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"warehouse_code", new ArrayList(logicCodes))).list();
                Map whMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
                logger.info("\u67e5\u8be2\u8c03\u62e8\u5355 {}", (Object)JSON.toJSONString((Object)orderNos));
                Map<String, CsTransferOrderEo> transferOrderMap = this.queryTransferOrder(orderNos);
                logger.info("\u67e5\u9500\u552e\u8ba2\u5355 {}", (Object)JSON.toJSONString((Object)saleOrderNos));
                Map<String, SaleOrderEo> saleOrderEoMap = this.asyncQuerySaleOrder(saleOrderNos);
                logger.info("\u67e5\u9000\u8d27\u5355 {}", (Object)JSON.toJSONString((Object)refundOrderNos));
                Map<String, OutPlannedOrderEo> saleRefundEoMap = this.asyncQuerySaleRefundOrder(refundOrderNos);
                logger.info("\u67e5\u8be2\u5176\u4ed6\u51fa\u5e93\u5355 {}", (Object)JSON.toJSONString((Object)otherOrderNos));
                Map<String, CsOtherStorageOrderEo> otherOrderMap = this.asyncQueryOtherOrder(otherOrderNos);
                logger.info("\u83b7\u53d6\u6536\u83b7\u5730\u5740\u4fe1\u606f {}", (Object)preOrderNos);
                Map<String, OrderInfoVo> orderInfoVoMap = this.asyncQueryOrderInfo(preOrderNos);
                logger.info("\u67e5\u8be2\u8c03\u6574\u5355 {}", (Object)JSON.toJSONString((Object)orderNos));
                Map<String, AdjustmentInventoryEo> adjustmentInventoryEoMap = this.asyncQueryAdjustmentInventory(orderNos);
                for (OutResultOrderEo respDto : outResultOrderEoList) {
                    String remark;
                    LogicWarehouseEo logicWarehouseEo;
                    logger.info("selectOutResultOrder\u904d\u5386\u5904\u7406\u5355\u636e {}", (Object)JSON.toJSONString((Object)respDto));
                    FinLogisticsReportDto reportEo = new FinLogisticsReportDto();
                    reportEo.setStatus(Integer.valueOf(0));
                    reportEo.setType(LogisticDocumentTypeEnum.ORIGINAL.getCode().toString());
                    reportEo.setOutboundTime(respDto.getInOutTime());
                    reportEo.setOutboundCode(respDto.getDocumentNo());
                    reportEo.setWmsOutboundCode(respDto.getWmsOrderNo());
                    reportEo.setBusinessCode(respDto.getRelevanceNo());
                    reportEo.setWarehouseName(respDto.getOutPhysicsWarehouseName());
                    reportEo.setWarehouseCode(respDto.getOutPhysicsWarehouseCode());
                    reportEo.setWarehouseId(respDto.getOutPhysicsWarehouseCode());
                    reportEo.setLogisticCompany(respDto.getShippingCompany());
                    reportEo.setLogisticCompanyCode(respDto.getShippingCompanyCode());
                    reportEo.setLogisticId(respDto.getShippingCompanyCode());
                    reportEo.setTransportType(respDto.getShippingType());
                    reportEo.setTransportCode(respDto.getShippingCode());
                    reportEo.setBusinessType(respDto.getBusinessType());
                    reportEo.setWarehouseEnter(respDto.getInLogicWarehouseName());
                    reportEo.setWarehouseEnterCode(respDto.getInLogicWarehouseCode());
                    reportEo.setBookkeepingDate(DateTimeUtils.formatDate(respDto.getBizDate(), "yyyy-MM"));
                    reportEo.setOcsConsignmentNo(respDto.getOcsConsignmentNo());
                    reportEo.setCustomerStr(respDto.getCustomerStr());
                    reportEo.setOutNoticeCode(respDto.getOutNoticeCode());
                    FinLogisticDetailRespDto detailRespDto = (FinLogisticDetailRespDto)detailRespDtoMap.get(reportEo.getOutboundCode());
                    if (ObjectUtils.isEmpty((Object)detailRespDto)) {
                        detailRespDto = new FinLogisticDetailRespDto();
                        logger.info("\u6ca1\u6709\u5339\u914d\u5230\u65e7\u6570\u636e {}", (Object)reportEo.getOutboundCode());
                    }
                    reportEo.setSpecialAmount(detailRespDto.getSpecialAmount());
                    reportEo.setSpecialType(detailRespDto.getSpecialType());
                    if (ObjectUtils.isNotEmpty(orderInfoVoMap) && orderInfoVoMap.containsKey(respDto.getPreOrderNo())) {
                        OrderInfoVo orderInfoVo = orderInfoVoMap.get(respDto.getPreOrderNo());
                        logger.info("\u5339\u914d\u5730\u5740\u5ba2\u6237\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)orderInfoVo));
                        if (shipmentMap.containsKey(respDto.getShippingCompanyCode())) {
                            ShipmentEnterpriseEo shipmentEnterpriseEo = (ShipmentEnterpriseEo)shipmentMap.get(respDto.getShippingCompanyCode());
                            logger.info("\u5339\u914d\u7684\u7269\u6d41\u5546\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)shipmentEnterpriseEo));
                            if (StringUtils.isNotBlank((CharSequence)shipmentEnterpriseEo.getCustomerCode()) && Objects.equals(shipmentEnterpriseEo.getCustomerCode(), orderInfoVo.getCustomerCode())) {
                                logger.info("\u6bd4\u5bf9\u7269\u6d41\u8fd0\u8d39\u7ed3\u679c\u7684\u5ba2\u6237\u4fe1\u606f\u662f\u5426\u4e00\u81f4\uff0c\u4e00\u81f4\u5219\u4e0d\u8ba1\u8d39,\u51fa\u5e93\u7ed3\u679c\u5355\u53f7 {}", (Object)respDto.getDocumentNo());
                                continue;
                            }
                        }
                        reportEo.setCustomerName(orderInfoVo.getCustomerName());
                        reportEo.setProvince(orderInfoVo.getProvince());
                        reportEo.setProvinceCode(orderInfoVo.getProvinceCode());
                        reportEo.setCity(orderInfoVo.getCity());
                        reportEo.setCityCode(orderInfoVo.getCityCode());
                        reportEo.setArea(orderInfoVo.getArea());
                        reportEo.setAreaCode(orderInfoVo.getAreaCode());
                        reportEo.setHarvestAddress(orderInfoVo.getDetailAddress());
                        reportEo.setHarvestPeople(orderInfoVo.getPerson());
                        if (StringUtils.isNotBlank((CharSequence)detailRespDto.getProvince())) {
                            logger.info("\u4f7f\u7528\u4e45\u6570\u636e\u7701\u5e02\u533a\u5730\u5740\u4fe1\u606f");
                            reportEo.setProvince(detailRespDto.getProvince());
                            reportEo.setProvinceCode(detailRespDto.getProvinceCode());
                            reportEo.setCity(detailRespDto.getCity());
                            reportEo.setCityCode(detailRespDto.getCityCode());
                            reportEo.setArea(detailRespDto.getArea());
                            reportEo.setAreaCode(detailRespDto.getAreaCode());
                            reportEo.setHarvestAddress(detailRespDto.getHarvestAddress());
                        }
                        if (StringUtils.isBlank((CharSequence)reportEo.getHarvestAddress())) {
                            reportEo.setStatus(Integer.valueOf(1));
                            this.setAbnormalCauses(reportEo, "\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a");
                        } else {
                            GeoAddressInfo geoAddress = this.lbsUtil.getGeoAddressCache(reportEo.getHarvestAddress());
                            logger.info("\u83b7\u53d6\u7ecf\u7eac\u5ea6\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)geoAddress));
                            reportEo.setLngLat(geoAddress.getLocation());
                        }
                        if (StringUtils.isBlank((CharSequence)reportEo.getProvince())) {
                            reportEo.setStatus(Integer.valueOf(1));
                            this.setAbnormalCauses(reportEo, "\u7701\u4efd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isNotBlank((CharSequence)reportEo.getCityCode()) && cityLevelMap.containsKey(reportEo.getCityCode())) {
                            reportEo.setCityLevel(cityLevelMap.get(reportEo.getCityCode()).getCityLevel());
                        }
                    } else {
                        reportEo.setStatus(Integer.valueOf(1));
                        this.setAbnormalCauses(reportEo, "\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    logger.info("reportEo\u6570\u636e {}", (Object)JSON.toJSONString((Object)reportEo));
                    if (ObjectUtils.isNotEmpty((Object)reportEo.getOutboundTime()) && StringUtils.isNotBlank((CharSequence)reportEo.getWarehouseCode()) && StringUtils.isNotBlank((CharSequence)reportEo.getLogisticCompany()) && StringUtils.isNotBlank((CharSequence)reportEo.getTransportType())) {
                        LogisticRecordQueryRespDto logisticsTemplate = this.getLogisticsTemplateList(logisticsTemplateMap, reportEo);
                        if (ObjectUtils.isNotEmpty((Object)logisticsTemplate) && ObjectUtils.isNotEmpty((Object)logisticsTemplate.getId())) {
                            logger.info("\u5339\u914d\u7269\u6d41\u8d39\u7528\u6a21\u7248\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)logisticsTemplate));
                            reportEo.setChargeMode(logisticsTemplate.getChargeMode().toString());
                            reportEo.setLogisticsModeId(logisticsTemplate.getId());
                            reportEo.setLogisticsTemplate(logisticsTemplate);
                            reportEo.setLogisticsTemplateId(logisticsTemplate.getId());
                            reportEo.setContractOilPrice(logisticsTemplate.getContractOilPrice());
                        } else {
                            reportEo.setStatus(Integer.valueOf(1));
                            this.setAbnormalCauses(reportEo, "\u6a21\u677f\u5df2\u8fc7\u671f\u6216\u672a\u5339\u914d\u5230\u6709\u6548\u7684\u7269\u6d41\u8fd0\u8d39\u6a21\u677f");
                        }
                    } else {
                        if (reportEo.getOutboundTime() == null) {
                            this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u65f6\u95f4\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)reportEo.getWarehouseCode())) {
                            this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u7269\u7406\u4ed3\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)reportEo.getLogisticCompany())) {
                            this.setAbnormalCauses(reportEo, "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)reportEo.getTransportType())) {
                            this.setAbnormalCauses(reportEo, "\u627f\u8fd0\u65b9\u5f0f\u4e3a\u7a7a");
                        }
                        reportEo.setStatus(Integer.valueOf(1));
                    }
                    String oilLinkKey = reportEo.getWarehouseCode() + DateUtil.formatYM(reportEo.getOutboundTime());
                    if (oilLinkMap.containsKey(oilLinkKey)) {
                        reportEo.setOilLinkQueryRespDto(oilLinkMap.get(oilLinkKey));
                        if (ObjectUtils.isNotEmpty((Object)reportEo.getOilLinkQueryRespDto())) {
                            reportEo.setLinkOilPrice(reportEo.getOilLinkQueryRespDto().getAmount());
                        }
                    }
                    reportEo.setBottle(respDto.getTotalQuantity());
                    reportEo.setBox(respDto.getTotalCartons());
                    reportEo.setTotalBox(respDto.getTotalCartons());
                    reportEo.setVolume(respDto.getTotalVolume());
                    reportEo.setTotalVolume(respDto.getTotalVolume());
                    reportEo.setWeight(respDto.getTotalWeight());
                    reportEo.setTotalWeight(respDto.getTotalWeight());
                    if (StringUtils.isNotEmpty((CharSequence)respDto.getOutLogicWarehouseName())) {
                        reportEo.setWarehouseOut(respDto.getOutLogicWarehouseName());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)respDto.getOutLogicWarehouseName())) {
                        reportEo.setWarehouseOutCode(respDto.getOutLogicWarehouseCode());
                    }
                    if (StringUtils.isNotBlank((CharSequence)respDto.getOutLogicWarehouseCode()) && whMap.containsKey(respDto.getOutLogicWarehouseCode())) {
                        logicWarehouseEo = (LogicWarehouseEo)whMap.get(respDto.getOutLogicWarehouseCode());
                        reportEo.setOrganizationOut(logicWarehouseEo.getOrganizationName());
                        reportEo.setAmountAttribution(logicWarehouseEo.getOrganizationName());
                    }
                    if (StringUtils.isNotBlank((CharSequence)respDto.getInLogicWarehouseCode()) && whMap.containsKey(respDto.getInLogicWarehouseCode())) {
                        logicWarehouseEo = (LogicWarehouseEo)whMap.get(respDto.getInLogicWarehouseCode());
                        reportEo.setOrganizationEnter(logicWarehouseEo.getOrganizationName());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)respDto.getInLogicWarehouseName())) {
                        reportEo.setWarehouseEnter(respDto.getInLogicWarehouseName());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)respDto.getInLogicWarehouseCode())) {
                        reportEo.setWarehouseEnterCode(respDto.getInLogicWarehouseCode());
                    }
                    if (saleOrderBusinessType.contains(respDto.getBusinessType()) && saleOrderEoMap.containsKey(respDto.getRelevanceNo())) {
                        SaleOrderEo saleOrderEo = saleOrderEoMap.get(respDto.getRelevanceNo());
                        remark = saleOrderEo.getSellerRemark();
                        reportEo.setRemark(remark);
                        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getEasOrderNo())) {
                            reportEo.setEasNo(saleOrderEo.getEasOrderNo());
                        } else {
                            reportEo.setEasNo(saleOrderEo.getEasOutOrderNo());
                        }
                        reportEo.setBillingDate(DateTimeUtils.formatDate(saleOrderEo.getSaleCreateTime(), "yyyy-MM-dd"));
                        reportEo.setCustomerName(saleOrderEo.getCustomerName());
                    }
                    if (BusinessTypeEnum.OTHER_OUT.getCode().equals(respDto.getBusinessType()) || BusinessTypeEnum.OTHER_IN.getCode().equals(respDto.getBusinessType())) {
                        CsOtherStorageOrderEo otherStorageOrderEo = otherOrderMap.get(respDto.getRelevanceNo());
                        if (otherStorageOrderEo != null) {
                            reportEo.setEasNo(otherStorageOrderEo.getExternalOrderNo());
                            remark = otherStorageOrderEo.getRemark();
                            if (StringUtils.isBlank((CharSequence)remark)) {
                                remark = otherStorageOrderEo.getMessage();
                            }
                            reportEo.setRemark(remark);
                            reportEo.setBillingDate(DateTimeUtils.formatDate(otherStorageOrderEo.getCreateTime(), "yyyy-MM-dd"));
                            reportEo.setEasNo(otherStorageOrderEo.getExternalOrderNo());
                            reportEo.setCustomerName(otherStorageOrderEo.getCustomerName());
                        } else {
                            this.setAbnormalCauses(reportEo, "\u627e\u4e0d\u5230\u5355\u636e\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e\u4fe1\u606f");
                            reportEo.setStatus(Integer.valueOf(1));
                        }
                    }
                    if (refundOrderBusinessType.contains(respDto.getBusinessType()) && saleRefundEoMap.containsKey(respDto.getRelevanceNo())) {
                        OutPlannedOrderEo outPlannedOrderEo = saleRefundEoMap.get(respDto.getRelevanceNo());
                        remark = outPlannedOrderEo.getRemark();
                        reportEo.setRemark(remark);
                        reportEo.setBillingDate(DateTimeUtils.formatDate(outPlannedOrderEo.getCreateTime(), "yyyy-MM-dd"));
                        reportEo.setEasNo(outPlannedOrderEo.getPlatformOrderNo());
                    }
                    if (transferOrderBusinessType.contains(respDto.getBusinessType())) {
                        if (!transferOrderMap.containsKey(respDto.getRelevanceNo())) continue;
                        CsTransferOrderEo transferOrderEo = transferOrderMap.get(respDto.getRelevanceNo());
                        reportEo.setWarehouseEnter(transferOrderEo.getInLogicWarehouseName());
                        reportEo.setWarehouseEnterCode(transferOrderEo.getInLogicWarehouseCode());
                        reportEo.setOrganizationEnter(transferOrderEo.getInOrganization());
                        if (Objects.equals(transferOrderEo.getOutPhysicsWarehouseCode(), transferOrderEo.getInPhysicsWarehouseCode())) continue;
                        remark = transferOrderEo.getRemark();
                        reportEo.setBillingDate(DateTimeUtils.formatDate(transferOrderEo.getCreateTime(), "yyyy-MM-dd"));
                        if (orderInfoVoMap != null && orderInfoVoMap.containsKey(respDto.getPreOrderNo())) {
                            OrderInfoVo orderInfoVo = orderInfoVoMap.get(respDto.getPreOrderNo());
                            reportEo.setCustomerName(orderInfoVo.getCustomerName());
                        }
                        if (Objects.equals(transferOrderEo.getSourceSystem(), "PCP")) {
                            if (adjustmentInventoryEoMap.containsKey(transferOrderEo.getTransferOrderNo())) {
                                String externalOrderNo = adjustmentInventoryEoMap.get(transferOrderEo.getTransferOrderNo()).getExternalOrderNo();
                                reportEo.setEasNo(externalOrderNo);
                            } else {
                                reportEo.setEasNo(transferOrderEo.getPreOrderNo());
                            }
                        } else {
                            reportEo.setEasNo(transferOrderEo.getPreOrderNo());
                        }
                        reportEo.setRemark(remark);
                        finLogisticsReportEos.add(reportEo);
                        continue;
                    }
                    finLogisticsReportEos.add(reportEo);
                }
            }
            logger.info("\u67e5\u8be2\u4e0b\u4e00\u9875\u6570\u636e");
            filter.setPageNum(Integer.valueOf(filter.getPageNum() + 1));
            outResultOrderEoList = this.outResultOrderService.queryConsignmentList(filter).getList();
        }
        if (CollectionUtils.isEmpty(finLogisticsReportEos)) {
            return finLogisticsReportEos;
        }
        logger.info("\u67e5\u8be2\u8d39\u7528\u5f52\u5c5e");
        List<String> outCodes = finLogisticsReportEos.stream().map(FinLogisticsReportDto::getWarehouseOutCode).distinct().collect(Collectors.toList());
        List<String> inCodes = finLogisticsReportEos.stream().map(FinLogisticsReportDto::getWarehouseEnterCode).distinct().collect(Collectors.toList());
        Map<String, FeeAttributionConfigEo> feeAttributionConfigEoMap = this.asyncQueryFeeAttributionConfig(outCodes, inCodes);
        if (ObjectUtils.isNotEmpty(feeAttributionConfigEoMap)) {
            finLogisticsReportEos.forEach(i -> {
                FeeAttributionConfigEo one;
                String key;
                if (StringUtils.isNotBlank((CharSequence)i.getWarehouseEnterCode()) && StringUtils.isNotBlank((CharSequence)i.getWarehouseOutCode()) && feeAttributionConfigEoMap.containsKey(key = String.format("%s%s", i.getWarehouseOutCode(), i.getWarehouseEnterCode())) && (one = (FeeAttributionConfigEo)feeAttributionConfigEoMap.get(key)) != null) {
                    i.setAmountAttribution(one.getCostBelongOrgName());
                }
            });
        }
        this.buildLogisticsReportArea(finLogisticsReportEos);
        return finLogisticsReportEos;
    }

    private List<FinLogisticsReportDto> selectOutResultOrderNew(LogisticStatisticReqDto logisticStatisticReqDto) {
        logger.info("selectOutResultOrderNew\u7edf\u8ba1\u7269\u6d41\u8d39\u7528\u62a5\u8868\u5f85\u751f\u6210\u6570\u636e {}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        if (ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getStartTime()) || ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getEndTime())) {
            logger.info("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff0c\u5f00\u59cb/\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return new ArrayList<FinLogisticsReportDto>();
        }
        ArrayList<FinLogisticsReportDto> finLogisticsReportEos = new ArrayList<FinLogisticsReportDto>();
        logger.info("selectOutResultOrderNew\u67e5\u8be2\u7269\u6d41\u5546");
        Map<Object, Object> shipmentMap = Maps.newHashMap();
        List shipmentList = ((ExtQueryChainWrapper)this.shipmentEnterpriseDas.filter().eq((Object)"shipment_enterprise_type", (Object)1)).list(Integer.valueOf(1000));
        if (CollectionUtil.isNotEmpty((Collection)shipmentList)) {
            shipmentMap = shipmentList.stream().collect(Collectors.toMap(ShipmentEnterpriseEo::getShipmentEnterpriseCode, Function.identity(), (k1, k2) -> k1));
        }
        Map<String, PcpRegionEo> cityLevelMap = this.asyncCityLevel();
        logger.info("\u83b7\u53d6\u57ce\u5e02\u7b49\u7ea7\u4fe1\u606f {}", (Object)JSON.toJSONString(cityLevelMap));
        Map<String, List<LogisticsRecordEo>> logisticsTemplateMap = this.asyncLogisticsTemplateList();
        logger.info("\u83b7\u53d6\u7269\u6d41\u8d39\u7528\u6a21\u7248\u4fe1\u606f {}", (Object)JSON.toJSONString(logisticsTemplateMap));
        Map<String, OilLinkQueryRespDto> oilLinkMap = this.asyncOilLink(logisticStatisticReqDto.getStartTime(), logisticStatisticReqDto.getEndTime());
        logger.info("\u83b7\u53d6\u8054\u52a8\u6cb9\u4ef7 {}", (Object)JSON.toJSONString(oilLinkMap));
        List<FinLogisticDetailRespDto> detailRespDtoList = this.finLogisticDetailService.selectByDetail(logisticStatisticReqDto);
        Map detailRespDtoMap = detailRespDtoList.stream().collect(Collectors.toMap(FinLogisticDetailRespDto::getOutboundCode, Function.identity(), (v1, v2) -> v2));
        DailyDeliveryReportListQueryDto queryDto = new DailyDeliveryReportListQueryDto();
        queryDto.setOrderCreateTimeStart(DateTimeUtils.parseDateTime(logisticStatisticReqDto.getStartTime()));
        queryDto.setOrderCreateTimeEnd(DateTimeUtils.parseDateTime(logisticStatisticReqDto.getEndTime()));
        if (StringUtils.isNotBlank((CharSequence)logisticStatisticReqDto.getWarehouseCode())) {
            queryDto.setPhysicalWarehouseCode(Arrays.asList(logisticStatisticReqDto.getWarehouseCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)logisticStatisticReqDto.getShippingCompanyCode())) {
            queryDto.setShippingCompany(Arrays.asList(logisticStatisticReqDto.getShippingCompanyCode()));
        }
        ArrayList<String> queryOrderNos = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)logisticStatisticReqDto.getDocumentNos())) {
            queryOrderNos.addAll(logisticStatisticReqDto.getDocumentNos());
        }
        if (StringUtils.isNotBlank((CharSequence)logisticStatisticReqDto.getRelevanceNo())) {
            queryOrderNos.add(logisticStatisticReqDto.getRelevanceNo());
        }
        if (CollectionUtils.isNotEmpty(queryOrderNos)) {
            queryDto.setOrderNumber(String.join((CharSequence)",", queryOrderNos));
        }
        logger.info("selectOutResultOrderNew\u67e5\u8be2\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5355\u636e\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)queryDto));
        int pageNum = 1;
        List outResultOrderEoList = ((PageInfo)this.dailyDeliveryReportService.queryByPage(queryDto, Integer.valueOf(pageNum), Integer.valueOf(5000)).getData()).getList();
        while (CollectionUtil.isNotEmpty((Collection)outResultOrderEoList) && outResultOrderEoList.size() > 0) {
            if (CollectionUtils.isNotEmpty((Collection)outResultOrderEoList)) {
                HashSet logicCodes = Sets.newHashSet();
                HashSet orderNos = Sets.newHashSet();
                HashSet saleOrderNos = Sets.newHashSet();
                HashSet otherOrderNos = Sets.newHashSet();
                HashSet refundOrderNos = Sets.newHashSet();
                HashSet preOrderNos = Sets.newHashSet();
                outResultOrderEoList.forEach(i -> {
                    logicCodes.add(i.getInLogicWarehouseCode());
                    logicCodes.add(i.getLogicWarehouseCode());
                    otherOrderNos.add(i.getRelevanceNo());
                    orderNos.add(i.getRelevanceNo());
                    saleOrderNos.add(i.getRelevanceNo());
                    refundOrderNos.add(i.getRelevanceNo());
                    preOrderNos.add(i.getPreOrderNo());
                });
                logger.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)logicCodes));
                List logicWarehouseEos = ((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"warehouse_code", new ArrayList(logicCodes))).list();
                Map whMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
                logger.info("\u67e5\u8be2\u8c03\u62e8\u5355 {}", (Object)JSON.toJSONString((Object)orderNos));
                Map<String, CsTransferOrderEo> transferOrderMap = this.queryTransferOrder(orderNos);
                logger.info("\u67e5\u9500\u552e\u8ba2\u5355 {}", (Object)JSON.toJSONString((Object)saleOrderNos));
                Map<String, SaleOrderEo> saleOrderEoMap = this.asyncQuerySaleOrder(saleOrderNos);
                logger.info("\u67e5\u9000\u8d27\u5355 {}", (Object)JSON.toJSONString((Object)refundOrderNos));
                Map<String, OutPlannedOrderEo> saleRefundEoMap = this.asyncQuerySaleRefundOrder(refundOrderNos);
                logger.info("\u67e5\u8be2\u5176\u4ed6\u51fa\u5e93\u5355 {}", (Object)JSON.toJSONString((Object)otherOrderNos));
                Map<String, CsOtherStorageOrderEo> otherOrderMap = this.asyncQueryOtherOrder(otherOrderNos);
                logger.info("\u83b7\u53d6\u6536\u83b7\u5730\u5740\u4fe1\u606f {}", (Object)preOrderNos);
                Map<String, OrderInfoVo> orderInfoVoMap = this.asyncQueryOrderInfo(preOrderNos);
                logger.info("\u67e5\u8be2\u8c03\u6574\u5355 {}", (Object)JSON.toJSONString((Object)orderNos));
                Map<String, AdjustmentInventoryEo> adjustmentInventoryEoMap = this.asyncQueryAdjustmentInventory(orderNos);
                for (DailyDeliveryReportDto respDto : outResultOrderEoList) {
                    long currentTime = System.currentTimeMillis();
                    logger.info("selectOutResultOrderNew\u904d\u5386\u5904\u7406\u5355\u636e {}", (Object)JSON.toJSONString((Object)respDto));
                    FinLogisticsReportDto reportEo = new FinLogisticsReportDto();
                    try {
                        String remark;
                        LogicWarehouseEo logicWarehouseEo;
                        reportEo.setStatus(Integer.valueOf(0));
                        reportEo.setPlacedFlag(YesNoEnum.NO.getValue());
                        reportEo.setLinkDailyReportId(respDto.getId());
                        reportEo.setType(LogisticDocumentTypeEnum.ORIGINAL.getCode().toString());
                        reportEo.setOutboundTime(respDto.getOrderShippingTime());
                        reportEo.setOutboundCode(respDto.getDocumentNo());
                        reportEo.setWmsOutboundCode(respDto.getWmsOrderNo());
                        reportEo.setBusinessCode(respDto.getRelevanceNo());
                        reportEo.setWarehouseName(respDto.getPhysicalWarehouse());
                        reportEo.setWarehouseCode(respDto.getPhysicalWarehouseCode());
                        reportEo.setWarehouseId(respDto.getPhysicalWarehouseCode());
                        reportEo.setLogisticCompany(respDto.getShippingCompanyName());
                        reportEo.setLogisticCompanyCode(respDto.getShippingCompany());
                        reportEo.setLogisticId(respDto.getShippingCompany());
                        reportEo.setTransportType(respDto.getTransportStyle());
                        reportEo.setTransportCode(respDto.getConsignmentNo());
                        reportEo.setBusinessType(respDto.getBusinessType());
                        reportEo.setWarehouseEnter(respDto.getInPhysicalWarehouse());
                        reportEo.setWarehouseEnterCode(respDto.getInPhysicalWarehouseCode());
                        reportEo.setBookkeepingDate(DateTimeUtils.formatDate(respDto.getOrderCreateTime(), "yyyy-MM"));
                        reportEo.setOcsConsignmentNo(respDto.getRelevanceNo());
                        reportEo.setOutNoticeCode(respDto.getOutNoticeNo());
                        reportEo.setTransportNo(respDto.getTransportNo());
                        reportEo.setRemark(respDto.getRemark());
                        FinLogisticDetailRespDto detailRespDto = (FinLogisticDetailRespDto)detailRespDtoMap.get(reportEo.getOutboundCode());
                        if (ObjectUtils.isEmpty((Object)detailRespDto)) {
                            detailRespDto = new FinLogisticDetailRespDto();
                            logger.info("\u6ca1\u6709\u5339\u914d\u5230\u65e7\u6570\u636e {}", (Object)reportEo.getOutboundCode());
                        }
                        reportEo.setSpecialAmount(detailRespDto.getSpecialAmount());
                        reportEo.setSpecialType(detailRespDto.getSpecialType());
                        if (StringUtils.isBlank((CharSequence)reportEo.getTransportCode())) {
                            reportEo.setStatus(Integer.valueOf(1));
                            this.setAbnormalCauses(reportEo, "\u6258\u8fd0\u5355\u53f7\u4e3a\u7a7a");
                        }
                        if (shipmentMap.containsKey(respDto.getShippingCompany())) {
                            ShipmentEnterpriseEo shipmentEnterpriseEo = (ShipmentEnterpriseEo)shipmentMap.get(respDto.getShippingCompany());
                            logger.info("\u5339\u914d\u7684\u7269\u6d41\u5546\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)shipmentEnterpriseEo));
                            if (Objects.equals(shipmentEnterpriseEo.getShipmentEnterpriseType(), 1)) {
                                logger.info("\u7269\u6d41\u5546\u4e0d\u4e3a\u7269\u6d41\u7c7b\u578b\uff0c\u4e0d\u7ee7\u7eed\u63d2\u5165\u6570\u636e \u51fa\u5e93\u7ed3\u679c\u5355\u53f7 {}", (Object)respDto.getDocumentNo());
                                continue;
                            }
                            reportEo.setCustomerStr(shipmentEnterpriseEo.getCustomerCode());
                            if (StringUtils.isNotBlank((CharSequence)shipmentEnterpriseEo.getCustomerCode()) && StringUtils.isNotBlank((CharSequence)respDto.getReceivingCustomer()) && shipmentEnterpriseEo.getCustomerCode().contains(respDto.getReceivingCustomer())) {
                                logger.info("\u6bd4\u5bf9\u7269\u6d41\u8fd0\u8d39\u7ed3\u679c\u7684\u5ba2\u6237\u4fe1\u606f\u662f\u5426\u4e00\u81f4\uff0c\u4e00\u81f4\u5219\u4e0d\u8ba1\u8d39,\u51fa\u5e93\u7ed3\u679c\u5355\u53f7 {}", (Object)respDto.getDocumentNo());
                                if (reportEo.getBillingFeeFlag() == null) {
                                    reportEo.setBillingFeeFlag(YesNoEnum.NO.getValue());
                                    this.setNoBillReasonCauses(reportEo, "\u5355\u636e\u5ba2\u6237\u540d\u79f0\u4e0e\u627f\u8fd0\u5546\u540d\u79f0\u4e00\u81f4\uff0c\u4e0d\u5408\u5355\uff0c\u4e0d\u8ba1\u8d39");
                                }
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)respDto.getReceivingAddressProvince()) && StringUtils.isNotBlank((CharSequence)respDto.getReceivingAddress())) {
                            reportEo.setCustomerName(respDto.getReceivingCustomer());
                            reportEo.setProvince(respDto.getReceivingAddressProvince());
                            reportEo.setProvinceCode(respDto.getReceivingAddressProvinceCode());
                            reportEo.setCity(respDto.getReceivingAddressCity());
                            reportEo.setCityCode(respDto.getReceivingAddressCityCode());
                            reportEo.setArea(respDto.getReceivingAddressDistrict());
                            reportEo.setAreaCode(respDto.getReceivingAddressDistrictCode());
                            reportEo.setHarvestAddress(respDto.getReceivingAddress());
                            reportEo.setHarvestPeople(respDto.getReceivingCustomer());
                            if (StringUtils.isNotBlank((CharSequence)detailRespDto.getProvince())) {
                                logger.info("\u4f7f\u7528\u65e7\u6570\u636e\u7701\u5e02\u533a\u5730\u5740\u4fe1\u606f");
                                reportEo.setProvince(detailRespDto.getProvince());
                                reportEo.setProvinceCode(detailRespDto.getProvinceCode());
                                reportEo.setCity(detailRespDto.getCity());
                                reportEo.setCityCode(detailRespDto.getCityCode());
                                reportEo.setArea(detailRespDto.getArea());
                                reportEo.setAreaCode(detailRespDto.getAreaCode());
                                reportEo.setHarvestAddress(detailRespDto.getHarvestAddress());
                            }
                            if (StringUtils.isBlank((CharSequence)reportEo.getHarvestAddress())) {
                                reportEo.setStatus(Integer.valueOf(1));
                                this.setAbnormalCauses(reportEo, "\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a");
                            } else {
                                logger.info("\u5199\u6b7b\u7ecf\u7eac\u5ea6 116.2317,39.5427");
                                reportEo.setLngLat("116.2317,39.5427");
                            }
                            if (StringUtils.isBlank((CharSequence)reportEo.getProvince())) {
                                reportEo.setStatus(Integer.valueOf(1));
                                this.setAbnormalCauses(reportEo, "\u7701\u4efd\u4e3a\u7a7a");
                            }
                            if (StringUtils.isNotBlank((CharSequence)reportEo.getCityCode()) && cityLevelMap.containsKey(reportEo.getCityCode())) {
                                reportEo.setCityLevel(cityLevelMap.get(reportEo.getCityCode()).getCityLevel());
                            }
                        } else {
                            reportEo.setStatus(Integer.valueOf(1));
                            this.setAbnormalCauses(reportEo, "\u5730\u5740\u4fe1\u606f\u6709\u4e3a\u7a7a");
                        }
                        logger.info("reportEo\u6570\u636e {}", (Object)JSON.toJSONString((Object)reportEo));
                        if (ObjectUtils.isNotEmpty((Object)reportEo.getOutboundTime()) && StringUtils.isNotBlank((CharSequence)reportEo.getWarehouseCode()) && StringUtils.isNotBlank((CharSequence)reportEo.getLogisticCompany()) && StringUtils.isNotBlank((CharSequence)reportEo.getTransportType())) {
                            LogisticRecordQueryRespDto logisticsTemplate = this.getLogisticsTemplateList(logisticsTemplateMap, reportEo);
                            if (ObjectUtils.isNotEmpty((Object)logisticsTemplate) && ObjectUtils.isNotEmpty((Object)logisticsTemplate.getId())) {
                                logger.info("\u5339\u914d\u7269\u6d41\u8d39\u7528\u6a21\u7248\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)logisticsTemplate));
                                reportEo.setChargeMode(logisticsTemplate.getChargeMode().toString());
                                reportEo.setLogisticsModeId(logisticsTemplate.getId());
                                reportEo.setLogisticsTemplate(logisticsTemplate);
                                reportEo.setLogisticsTemplateId(logisticsTemplate.getId());
                                reportEo.setContractOilPrice(logisticsTemplate.getContractOilPrice());
                            } else {
                                reportEo.setStatus(Integer.valueOf(1));
                                this.setAbnormalCauses(reportEo, "\u6a21\u677f\u5df2\u8fc7\u671f\u6216\u672a\u5339\u914d\u5230\u6709\u6548\u7684\u7269\u6d41\u8fd0\u8d39\u6a21\u677f");
                            }
                        } else {
                            if (reportEo.getOutboundTime() == null) {
                                this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u65f6\u95f4\u4e3a\u7a7a");
                            }
                            if (StringUtils.isBlank((CharSequence)reportEo.getWarehouseCode())) {
                                this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u7269\u7406\u4ed3\u4e3a\u7a7a");
                            }
                            if (StringUtils.isBlank((CharSequence)reportEo.getLogisticCompany())) {
                                this.setAbnormalCauses(reportEo, "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
                            }
                            if (StringUtils.isBlank((CharSequence)reportEo.getTransportType())) {
                                this.setAbnormalCauses(reportEo, "\u627f\u8fd0\u65b9\u5f0f\u4e3a\u7a7a");
                            }
                            reportEo.setStatus(Integer.valueOf(1));
                        }
                        String oilLinkKey = reportEo.getWarehouseCode() + DateUtil.formatYM(reportEo.getOutboundTime());
                        if (oilLinkMap.containsKey(oilLinkKey)) {
                            reportEo.setOilLinkQueryRespDto(oilLinkMap.get(oilLinkKey));
                            if (ObjectUtils.isNotEmpty((Object)reportEo.getOilLinkQueryRespDto())) {
                                reportEo.setLinkOilPrice(reportEo.getOilLinkQueryRespDto().getAmount());
                            }
                        }
                        reportEo.setBottle(respDto.getTotalQuantity());
                        reportEo.setBox(respDto.getBillingCartons());
                        reportEo.setTotalBox(respDto.getBillingCartons());
                        reportEo.setVolume(respDto.getBillingVolume());
                        reportEo.setTotalVolume(respDto.getBillingVolume());
                        reportEo.setWeight(respDto.getBillingWeight());
                        reportEo.setTotalWeight(respDto.getBillingWeight());
                        if (StringUtils.isNotEmpty((CharSequence)respDto.getLogicWarehouse())) {
                            reportEo.setWarehouseOut(respDto.getLogicWarehouse());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)respDto.getLogicWarehouseCode())) {
                            reportEo.setWarehouseOutCode(respDto.getLogicWarehouseCode());
                        }
                        if (StringUtils.isNotBlank((CharSequence)respDto.getLogicWarehouseCode()) && whMap.containsKey(respDto.getLogicWarehouseCode())) {
                            logicWarehouseEo = (LogicWarehouseEo)whMap.get(respDto.getLogicWarehouseCode());
                            reportEo.setOrganizationOut(logicWarehouseEo.getOrganizationName());
                            reportEo.setAmountAttribution(logicWarehouseEo.getOrganizationName());
                        }
                        if (StringUtils.isNotBlank((CharSequence)respDto.getInLogicWarehouseCode()) && whMap.containsKey(respDto.getInLogicWarehouseCode())) {
                            logicWarehouseEo = (LogicWarehouseEo)whMap.get(respDto.getInLogicWarehouseCode());
                            reportEo.setOrganizationEnter(logicWarehouseEo.getOrganizationName());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)respDto.getInLogicWarehouse())) {
                            reportEo.setWarehouseEnter(respDto.getInLogicWarehouse());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)respDto.getInLogicWarehouseCode())) {
                            reportEo.setWarehouseEnterCode(respDto.getInLogicWarehouseCode());
                        }
                        if (saleOrderBusinessType.contains(respDto.getBusinessType()) && saleOrderEoMap.containsKey(respDto.getRelevanceNo())) {
                            SaleOrderEo saleOrderEo = saleOrderEoMap.get(respDto.getRelevanceNo());
                            if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getEasOrderNo())) {
                                reportEo.setEasNo(saleOrderEo.getEasOrderNo());
                            } else {
                                reportEo.setEasNo(saleOrderEo.getEasOutOrderNo());
                            }
                            reportEo.setBillingDate(DateTimeUtils.formatDate(saleOrderEo.getSaleCreateTime(), "yyyy-MM-dd"));
                            reportEo.setCustomerName(saleOrderEo.getCustomerName());
                        }
                        if (BusinessTypeEnum.OTHER_OUT.getCode().equals(respDto.getBusinessType()) || BusinessTypeEnum.OTHER_IN.getCode().equals(respDto.getBusinessType())) {
                            CsOtherStorageOrderEo otherStorageOrderEo = otherOrderMap.get(respDto.getRelevanceNo());
                            if (otherStorageOrderEo != null) {
                                reportEo.setEasNo(otherStorageOrderEo.getExternalOrderNo());
                                remark = otherStorageOrderEo.getRemark();
                                if (StringUtils.isBlank((CharSequence)remark)) {
                                    remark = otherStorageOrderEo.getMessage();
                                }
                                reportEo.setBillingDate(DateTimeUtils.formatDate(otherStorageOrderEo.getCreateTime(), "yyyy-MM-dd"));
                                reportEo.setEasNo(otherStorageOrderEo.getExternalOrderNo());
                                reportEo.setCustomerName(otherStorageOrderEo.getCustomerName());
                            } else {
                                this.setAbnormalCauses(reportEo, "\u627e\u4e0d\u5230\u5355\u636e\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e\u4fe1\u606f");
                                reportEo.setStatus(Integer.valueOf(1));
                            }
                        }
                        if (refundOrderBusinessType.contains(respDto.getBusinessType()) && saleRefundEoMap.containsKey(respDto.getRelevanceNo())) {
                            OutPlannedOrderEo outPlannedOrderEo = saleRefundEoMap.get(respDto.getRelevanceNo());
                            reportEo.setBillingDate(DateTimeUtils.formatDate(outPlannedOrderEo.getCreateTime(), "yyyy-MM-dd"));
                            reportEo.setEasNo(outPlannedOrderEo.getPlatformOrderNo());
                        }
                        if (transferOrderBusinessType.contains(respDto.getBusinessType()) && transferOrderMap.containsKey(respDto.getRelevanceNo())) {
                            CsTransferOrderEo transferOrderEo = transferOrderMap.get(respDto.getRelevanceNo());
                            reportEo.setWarehouseEnter(transferOrderEo.getInLogicWarehouseName());
                            reportEo.setWarehouseEnterCode(transferOrderEo.getInLogicWarehouseCode());
                            reportEo.setOrganizationEnter(transferOrderEo.getInOrganization());
                            if (!Objects.equals(transferOrderEo.getOutPhysicsWarehouseCode(), transferOrderEo.getInPhysicsWarehouseCode())) {
                                remark = transferOrderEo.getRemark();
                                reportEo.setBillingDate(DateTimeUtils.formatDate(transferOrderEo.getCreateTime(), "yyyy-MM-dd"));
                                if (orderInfoVoMap != null && orderInfoVoMap.containsKey(respDto.getPreOrderNo())) {
                                    OrderInfoVo orderInfoVo = orderInfoVoMap.get(respDto.getPreOrderNo());
                                    reportEo.setCustomerName(orderInfoVo.getCustomerName());
                                }
                                if (Objects.equals(transferOrderEo.getSourceSystem(), "PCP")) {
                                    if (adjustmentInventoryEoMap.containsKey(transferOrderEo.getTransferOrderNo())) {
                                        String externalOrderNo = adjustmentInventoryEoMap.get(transferOrderEo.getTransferOrderNo()).getExternalOrderNo();
                                        reportEo.setEasNo(externalOrderNo);
                                    } else {
                                        reportEo.setEasNo(transferOrderEo.getPreOrderNo());
                                    }
                                } else {
                                    reportEo.setEasNo(transferOrderEo.getPreOrderNo());
                                }
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)reportEo.getBusinessType()) && StringUtils.isNotBlank((CharSequence)reportEo.getWarehouseCode()) && reportEo.getBillingFeeFlag() == null) {
                            DailyDeliveryFeeFilterConfigMatchResultDto filterConfigMatchResultDto = this.dailyDeliveryFeeFilterConfigService.filterFee(respDto, DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode(), reportEo.getWarehouseCode(), reportEo.getBusinessType());
                            reportEo.setBillingFeeFlag(filterConfigMatchResultDto.isFilterResult() ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
                            this.setNoBillReasonCauses(reportEo, filterConfigMatchResultDto.getFilterFalseReason());
                        } else {
                            reportEo.setBillingFeeFlag(YesNoEnum.YES.getValue());
                            if (StringUtils.isBlank((CharSequence)reportEo.getBusinessType())) {
                                this.setAbnormalCauses(reportEo, "\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
                            }
                            if (StringUtils.isBlank((CharSequence)reportEo.getWarehouseCode())) {
                                this.setAbnormalCauses(reportEo, "\u7269\u7406\u4ed3\u7f16\u7801\u4e3a\u7a7a");
                            }
                            reportEo.setStatus(Integer.valueOf(1));
                        }
                        finLogisticsReportEos.add(reportEo);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        this.setAbnormalCauses(reportEo, "\u8f6c\u6362\u8fc7\u7a0b\u5f02\u5e38\uff1a" + e.getMessage());
                        reportEo.setStatus(Integer.valueOf(1));
                    }
                    logger.info("\u6570\u636e\u8f6c\u6362\u82b1\u8d39\u65f6\u957f {} {}ms", (Object)reportEo.getOutboundCode(), (Object)(System.currentTimeMillis() - currentTime));
                }
            }
            logger.info("\u67e5\u8be2\u4e0b\u4e00\u9875\u6570\u636e");
            outResultOrderEoList = ((PageInfo)this.dailyDeliveryReportService.queryByPage(queryDto, Integer.valueOf(++pageNum), Integer.valueOf(5000)).getData()).getList();
        }
        if (CollectionUtils.isEmpty(finLogisticsReportEos)) {
            return finLogisticsReportEos;
        }
        logger.info("\u67e5\u8be2\u8d39\u7528\u5f52\u5c5e");
        List<String> outCodes = finLogisticsReportEos.stream().map(FinLogisticsReportDto::getWarehouseOutCode).distinct().collect(Collectors.toList());
        List<String> inCodes = finLogisticsReportEos.stream().map(FinLogisticsReportDto::getWarehouseEnterCode).distinct().collect(Collectors.toList());
        Map<String, FeeAttributionConfigEo> feeAttributionConfigEoMap = this.asyncQueryFeeAttributionConfig(outCodes, inCodes);
        if (ObjectUtils.isNotEmpty(feeAttributionConfigEoMap)) {
            finLogisticsReportEos.forEach(i -> {
                FeeAttributionConfigEo one;
                String key;
                if (StringUtils.isNotBlank((CharSequence)i.getWarehouseEnterCode()) && StringUtils.isNotBlank((CharSequence)i.getWarehouseOutCode()) && feeAttributionConfigEoMap.containsKey(key = String.format("%s%s", i.getWarehouseOutCode(), i.getWarehouseEnterCode())) && (one = (FeeAttributionConfigEo)feeAttributionConfigEoMap.get(key)) != null) {
                    i.setAmountAttribution(one.getCostBelongOrgName());
                }
            });
        }
        this.buildLogisticsReportArea(finLogisticsReportEos);
        return finLogisticsReportEos;
    }

    private void buildLogisticsReportDate(List<FinLogisticsReportDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            logger.info("\u65e0\u6570\u636e\u5904\u7406");
            return;
        }
        logger.info("\u5339\u914d\u7269\u6d41\u8d39\u7528\u6a21\u7248\u3001\u7269\u6d41\u8d39\u7528\u6a21\u7248\u533a\u57df\u3001\u8054\u52a8\u6cb9\u4ef7 {}", (Object)JSON.toJSONString(dtoList));
        Map<String, List<LogisticsRecordEo>> logisticsTemplateMap = this.asyncLogisticsTemplateList();
        logger.info("\u83b7\u53d6\u7269\u6d41\u8d39\u7528\u6a21\u7248\u4fe1\u606f {}", (Object)JSON.toJSONString(logisticsTemplateMap));
        Map<String, OilLinkQueryRespDto> oilLinkMap = this.asyncOilLink(null, null);
        logger.info("\u83b7\u53d6\u8054\u52a8\u6cb9\u4ef7 {}", (Object)JSON.toJSONString(oilLinkMap));
        dtoList.forEach(dto -> {
            LogisticRecordQueryRespDto logisticsTemplate = this.getLogisticsTemplateList(logisticsTemplateMap, (FinLogisticsReportDto)dto);
            if (ObjectUtils.isNotEmpty((Object)logisticsTemplate) && ObjectUtils.isNotEmpty((Object)logisticsTemplate.getLogisticId())) {
                dto.setChargeMode(logisticsTemplate.getChargeMode().toString());
                dto.setLogisticsModeId(logisticsTemplate.getId());
                dto.setLogisticsTemplate(logisticsTemplate);
            } else {
                dto.setStatus(Integer.valueOf(1));
                this.setAbnormalCauses((FinLogisticsReportDto)dto, "\u5339\u914d\u4e0d\u5230\u6709\u6548\u7269\u6d41\u8d39\u7528\u6a21\u7248");
            }
            String oilLinkKey = dto.getWarehouseCode() + DateUtil.formatYM(dto.getOutboundTime());
            if (oilLinkMap.containsKey(oilLinkKey)) {
                dto.setOilLinkQueryRespDto((OilLinkQueryRespDto)oilLinkMap.get(oilLinkKey));
            }
        });
    }

    private void buildLogisticsReportArea(List<FinLogisticsReportDto> dtoList) {
        List appointAreaList;
        logger.info("\u5339\u914d\u7269\u6d41\u8d39\u7528\u6a21\u7248\u533a\u57df");
        if (CollectionUtils.isEmpty(dtoList)) {
            logger.info("\u65e0\u6570\u636e\u5904\u7406");
            return;
        }
        List logisticsModeIds = dtoList.stream().map(FinLogisticsReportDto::getLogisticsModeId).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(logisticsModeIds) && CollectionUtil.isNotEmpty((Collection)(appointAreaList = this.finLogisticDetailDas.queryAppointArea(logisticsModeIds)))) {
            Map map2 = appointAreaList.stream().filter(f -> StringUtils.isBlank((CharSequence)f.getArea())).collect(Collectors.toMap(m -> m.getTemplateId() + m.getProvince() + m.getCity(), Function.identity(), (k1, k2) -> k1));
            Map map3 = appointAreaList.stream().filter(f -> StringUtils.isBlank((CharSequence)f.getArea()) && StringUtils.isBlank((CharSequence)f.getCity())).collect(Collectors.toMap(m -> m.getTemplateId() + m.getProvince(), Function.identity(), (k1, k2) -> k1));
            logger.info("\u7269\u6d41\u8d39\u7528\u6a21\u7248\u533a\u57df\u4fe1\u606f {}", (Object)JSON.toJSONString(map2));
            dtoList.forEach(dto -> {
                if (ObjectUtils.isNotEmpty((Object)dto.getLogisticsModeId())) {
                    AppointAreaQueryRespDto areaDto = null;
                    String key = null;
                    if (ObjectUtils.isEmpty(areaDto)) {
                        key = dto.getProvince() + dto.getCity();
                        areaDto = (AppointAreaQueryRespDto)map2.get(dto.getLogisticsModeId() + key);
                    }
                    if (ObjectUtils.isEmpty(areaDto)) {
                        key = dto.getProvince();
                        areaDto = (AppointAreaQueryRespDto)map3.get(dto.getLogisticsModeId() + key);
                    }
                    dto.setAppointAreaQueryRespDto(areaDto);
                    if (ObjectUtils.isNotEmpty(areaDto)) {
                        dto.setLogisticsTemplateArea(key);
                    } else {
                        dto.setStatus(Integer.valueOf(1));
                        this.setAbnormalCauses((FinLogisticsReportDto)dto, "\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u533a\u57df");
                    }
                }
            });
        }
    }

    private Map<String, CsTransferOrderEo> queryTransferOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List<CsTransferOrderEo> eos = this.asyncQueryTransferOrder(orderNos);
        if (CollectionUtil.isEmpty(eos)) {
            return Maps.newHashMap();
        }
        return eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private List<CsTransferOrderEo> getTransferOrder(Set<String> orderNos) {
        List eos = ((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", orderNos)).list();
        return eos;
    }

    private List<CsTransferOrderEo> asyncQueryTransferOrder(Set<String> orderNos) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.getTransferOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u67e5\u8be2\u8c03\u62e8\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, InventorySupplierEo> asyncQueryPlannedOrderSupplier(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.queryPlannedOrderSupplier(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u67e5\u8be2\u8c03\u62e8\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, InventorySupplierEo> queryPlannedOrderSupplier(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List plannedOrderEos = ((ExtQueryChainWrapper)this.outPlannedOrderDas.filter().in((Object)"order_no", orderNos)).list();
        if (CollectionUtil.isEmpty((Collection)plannedOrderEos)) {
            return Maps.newHashMap();
        }
        Map<String, Long> map = plannedOrderEos.stream().filter(i -> i.getSupplierId() != null).collect(Collectors.toMap(OutPlannedOrderEo::getOrderNo, o -> o.getSupplierId(), (k1, k2) -> k1));
        if (CollectionUtil.isEmpty(map)) {
            return Maps.newHashMap();
        }
        List inventorySupplierEos = this.inventorySupplierDas.selectByIds(map.values().stream().collect(Collectors.toList()));
        if (CollectionUtil.isEmpty((Collection)inventorySupplierEos)) {
            return Maps.newHashMap();
        }
        HashMap supplierMap = Maps.newHashMap();
        Map inventorySupplierEoMap = inventorySupplierEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        map.forEach((orderNo, supplierId) -> {
            if (inventorySupplierEoMap.containsKey(supplierId)) {
                supplierMap.put(orderNo, inventorySupplierEoMap.get(supplierId));
            }
        });
        return supplierMap;
    }

    private Map<String, FeeAttributionConfigEo> asyncQueryFeeAttributionConfig(List<String> outCods, List<String> inCodes) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.queryFeeAttributionConfig(outCods, inCodes), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u8d39\u7528\u5f52\u5c5e\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, AdjustmentInventoryEo> asyncQueryAdjustmentInventory(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.queryQueryAdjustmentInventory(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u5f02\u6b65\u67e5\u8be2\u5728\u9014\u5e93\u5b58\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, AdjustmentInventoryEo> queryQueryAdjustmentInventory(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.adjustmentInventoryDas.filter().eq((Object)"source_type", (Object)"receiveResult")).eq((Object)"business_type", (Object)"in_transit_adjustment_out")).eq((Object)"adjustment_status", (Object)"completed")).in((Object)"relevance_no", orderNos)).list();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(AdjustmentInventoryEo::getRelevanceNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsOtherStorageOrderEo> asyncQueryOtherOrder(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.queryOtherOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u5176\u4ed6\u51fa\u5165\u5e93\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, OutNoticeOrderRespDto> asyncQueryOutNoticeOrder(Set<String> orderNos) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.outNoticeOrderService.queryByDocumentNos(orderNos), this.statisticsExecutor);
        try {
            List respDtos = future.get();
            if (CollectionUtil.isEmpty((Collection)respDtos)) {
                return Maps.newHashMap();
            }
            return respDtos.stream().collect(Collectors.toMap(OutNoticeOrderRespDto::getDocumentNo, Functions.identity(), (k1, k2) -> k1));
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u51fa\u5e93\u901a\u77e5\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, FeeAttributionConfigEo> queryFeeAttributionConfig(List<String> outCodes, List<String> inCodes) {
        if (CollectionUtil.isEmpty(outCodes) || CollectionUtil.isEmpty(inCodes)) {
            return Maps.newHashMap();
        }
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.feeAttributionConfigDas.filter().in((Object)"out_warehouse_code", outCodes)).in((Object)"in_warehouse_code", inCodes)).list();
        if (CollectionUtil.isEmpty((Collection)eos)) {
            return Maps.newHashMap();
        }
        return eos.stream().collect(Collectors.toMap(i -> String.format("%s%s", i.getOutWarehouseCode(), i.getInWarehouseCode()), j -> j, (k1, k2) -> k1));
    }

    private Map<String, CsOtherStorageOrderEo> queryOtherOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List saleOrderEos = ((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().in((Object)"storage_order_no", orderNos)).list();
        if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
            return Maps.newHashMap();
        }
        return saleOrderEos.stream().collect(Collectors.toMap(CsOtherStorageOrderEo::getStorageOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, OutPlannedOrderEo> querySaleRefundOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List saleOrderEos = ((ExtQueryChainWrapper)this.outPlannedOrderDas.filter().in((Object)"order_no", orderNos)).list();
        if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
            return Maps.newHashMap();
        }
        return saleOrderEos.stream().collect(Collectors.toMap(OutPlannedOrderEo::getOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, OutPlannedOrderEo> asyncQuerySaleRefundOrder(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.querySaleRefundOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u9500\u9000\u8d27\u5355\u552e\u8ba2\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, OrderInfoVo> asyncQueryOrderInfo(Set<String> orderNos) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.finLogisticsReportDas.queryOrderInfo(new ArrayList(orderNos)), this.statisticsExecutor);
        try {
            List orderInfoVos = future.get();
            if (CollectionUtil.isEmpty((Collection)orderInfoVos)) {
                return null;
            }
            return orderInfoVos.stream().collect(Collectors.toMap(OrderInfoVo::getOrderNo, Function.identity(), (k1, k2) -> k1));
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, SaleOrderEo> asyncQuerySaleOrder(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.querySaleOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, PcpRegionEo> asyncCityLevel() {
        Map<String, Object> cityLevelMap = new HashMap<String, PcpRegionEo>();
        List pcpRegionEos = ((ExtQueryChainWrapper)this.regionDas.filter().eq((Object)"level_id", (Object)1)).list();
        if (CollectionUtil.isNotEmpty((Collection)pcpRegionEos)) {
            cityLevelMap = pcpRegionEos.stream().collect(Collectors.toMap(PcpRegionEo::getCode, Function.identity(), (k1, k2) -> k1));
        }
        return cityLevelMap;
    }

    private Map<String, List<LogisticsRecordEo>> asyncLogisticsTemplateList() {
        List list = ((ExtQueryChainWrapper)this.logisticsRecordDas.filter().ne((Object)"status", (Object)3)).list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return list.stream().collect(Collectors.groupingBy(g -> g.getWarehouseId() + g.getLogisticCompany() + g.getTransportType()));
        }
        return new HashMap<String, List<LogisticsRecordEo>>();
    }

    private Map<String, OilLinkQueryRespDto> asyncOilLink(String startDate, String endDate) {
        List oilLinkQueryRespDtoList = this.finLogisticDetailDas.queryOilLinkList(startDate, endDate, null, null);
        if (CollectionUtils.isNotEmpty((Collection)oilLinkQueryRespDtoList)) {
            return oilLinkQueryRespDtoList.stream().collect(Collectors.toMap(m -> m.getWarehouseId() + DateUtil.formatYM(m.getLastTime()), Function.identity(), (k1, k2) -> k1));
        }
        return new HashMap<String, OilLinkQueryRespDto>();
    }

    private LogisticRecordQueryRespDto getLogisticsTemplateList(Map<String, List<LogisticsRecordEo>> map, FinLogisticsReportDto reportDto) {
        String key = reportDto.getWarehouseCode() + reportDto.getLogisticCompany() + reportDto.getTransportType();
        logger.info("\u5339\u914d\u7269\u6d41\u8d39\u7528\u6a21\u7248 {}", (Object)key);
        List<LogisticsRecordEo> list = map.get(key);
        LogisticRecordQueryRespDto respDto = new LogisticRecordQueryRespDto();
        if (CollectionUtil.isNotEmpty(list)) {
            logger.info("\u5339\u914d\u5230\u7684\u6a21\u7248\u5217\u8868 {}", (Object)JSON.toJSONString(list));
            for (LogisticsRecordEo eo : list) {
                if (reportDto.getOutboundTime().getTime() < eo.getStartTime().getTime() || reportDto.getOutboundTime().getTime() > eo.getEndTime().getTime()) continue;
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
                break;
            }
        }
        return respDto;
    }

    private Map<String, SaleOrderEo> querySaleOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List saleOrderEos = ((ExtQueryChainWrapper)this.saleOrderDas.filter().in((Object)"sale_order_no", orderNos)).list();
        if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
            return Maps.newHashMap();
        }
        return saleOrderEos.stream().collect(Collectors.toMap(SaleOrderEo::getSaleOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsWarehouseAddressEo> queryWarehouseAddress(List<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return Maps.newHashMap();
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reWarehouseAddressDas.filter().eq((Object)"valid_flag", (Object)"enable")).eq((Object)"warehouse_classify", (Object)"physics")).in((Object)"warehouse_code", codes)).list();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(CsWarehouseAddressEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
    }

    private CsOtherStorageOrderEo queryOtherStorageOrder(String orderNo) {
        return (CsOtherStorageOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().eq((Object)"storage_order_no", (Object)orderNo)).last("limit 1")).one();
    }

    private FeeAttributionConfigRespDto queryAttribution(String outCode, String inCode) {
        if (StringUtils.isEmpty((CharSequence)outCode) || StringUtils.isEmpty((CharSequence)inCode)) {
            return null;
        }
        FeeAttributionConfigDetailQueryReqDto reqDto = new FeeAttributionConfigDetailQueryReqDto();
        reqDto.setOutWarehouseCode(outCode);
        reqDto.setInWarehouseCode(inCode);
        RestResponse response = this.feeAttributionConfigApi.detailFeeAttributionConfig(reqDto);
        if ("0".equals(response.getResultCode())) {
            return (FeeAttributionConfigRespDto)response.getData();
        }
        return null;
    }

    private LogisticRecordQueryRespDto selectLogisticMode(String warehouseCode, String logisticCompany, String transportType, Date outWarehouseTime) {
        logger.info("selectLogisticMode====={},{},{},{}", new Object[]{warehouseCode, logisticCompany, transportType, outWarehouseTime});
        LogisticRecordExtReqDto queryReqDto = new LogisticRecordExtReqDto();
        queryReqDto.setWhCode(warehouseCode);
        queryReqDto.setLogisticCompany(logisticCompany);
        queryReqDto.setTransportType(transportType);
        queryReqDto.setOutWarehouseTime(outWarehouseTime);
        ArrayList list = Lists.newArrayList();
        list.add(queryReqDto);
        RestResponse response = this.logisticQueryApi.queryList((List)list);
        if ("0".equals(response.getResultCode()) && CollectionUtil.isNotEmpty((Collection)((Collection)response.getData())) && ((List)response.getData()).size() > 0) {
            return (LogisticRecordQueryRespDto)((List)response.getData()).get(0);
        }
        return null;
    }

    private Map<String, LogisticRecordQueryRespDto> asyncQueryLogisticModes(List<LogisticRecordExtReqDto> queryList) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.queryLogisticModes(queryList), this.statisticsExecutor);
        try {
            List respDtos = future.get();
            if (CollectionUtil.isEmpty((Collection)respDtos)) {
                return Maps.newHashMap();
            }
            HashMap map = Maps.newHashMap();
            for (LogisticRecordQueryRespDto respDto : respDtos) {
                String warehouseId = respDto.getWarehouseId();
                String logisticId = respDto.getLogisticId();
                String transportType = respDto.getTransportType();
                Date startTime = respDto.getStartTime();
                Date endTime = respDto.getEndTime();
                for (LogisticRecordExtReqDto reqDto : queryList) {
                    String whCode = reqDto.getWhCode();
                    String logisticCompany = reqDto.getLogisticCompany();
                    String transportType1 = reqDto.getTransportType();
                    Date outWarehouseTime = reqDto.getOutWarehouseTime();
                    String key = String.format("%s%s%s%s", whCode, logisticCompany, transportType1, outWarehouseTime);
                    if (!Objects.equals(warehouseId, whCode) || !Objects.equals(logisticId, logisticCompany) || !Objects.equals(transportType, transportType1) || endTime.getTime() <= outWarehouseTime.getTime() || startTime.getTime() > outWarehouseTime.getTime()) continue;
                    map.put(key, respDto);
                }
            }
            return map;
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private List<LogisticRecordQueryRespDto> queryLogisticModes(List<LogisticRecordExtReqDto> queryList) {
        RestResponse response = this.logisticQueryApi.queryList(queryList);
        if ("0".equals(response.getResultCode()) && CollectionUtil.isNotEmpty((Collection)((Collection)response.getData())) && ((List)response.getData()).size() > 0) {
            return (List)response.getData();
        }
        return Lists.newArrayList();
    }

    private LogisticRecordQueryRespDto queryLogisticMode(LogisticRecordExtReqDto queryReqDto) {
        ArrayList list = Lists.newArrayList();
        list.add(queryReqDto);
        RestResponse response = this.logisticQueryApi.queryList((List)list);
        if ("0".equals(response.getResultCode()) && CollectionUtil.isNotEmpty((Collection)((Collection)response.getData())) && ((List)response.getData()).size() > 0) {
            return (LogisticRecordQueryRespDto)((List)response.getData()).get(0);
        }
        return null;
    }

    private boolean judgeLogisticAppointArea(String province, String city, String area, String TemplateId) {
        AppointAreaQueryReqDto appointAreaQueryReqDto = new AppointAreaQueryReqDto();
        appointAreaQueryReqDto.setPageNum(Integer.valueOf(1));
        appointAreaQueryReqDto.setPageSize(Integer.valueOf(1000));
        appointAreaQueryReqDto.setTemplateId(TemplateId);
        RestResponse pageInfoRestResponse = this.logisticQueryApi.queryAppointAreaList(appointAreaQueryReqDto);
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
            for (AppointAreaQueryRespDto e : ((PageInfo)pageInfoRestResponse.getData()).getList()) {
                logger.info("\u6821\u9a8c\u6307\u5b9a\u533a\u57df\u5bf9\u8c61\uff1a{}", (Object)e);
                if (!Objects.equals(e.getProvince(), province) || !Objects.equals(e.getCity(), city) && !Objects.equals(e.getCity(), "") || !Objects.equals(e.getArea(), area) && !Objects.equals(e.getArea(), "")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        saleOrderBusinessType.add("common_order");
        saleOrderBusinessType.add("agency_order");
        saleOrderBusinessType.add("integral_order");
        saleOrderBusinessType.add("customer_refunding_order");
        saleOrderBusinessType.add("compensation_order");
        saleOrderBusinessType.add("replenishment_order");
        saleOrderBusinessType.add("quality_refunding_order");
        saleOrderBusinessType.add("replenish_order");
        saleOrderBusinessType.add("claim_reissue");
        saleOrderBusinessType.add("other_out_stock");
        saleOrderBusinessType.add("internal_distribution");
        saleOrderBusinessType.add("secondary_distribution");
        saleOrderBusinessType.add("child_direct_sales");
        saleOrderBusinessType.add("presale_order");
        saleOrderBusinessType.add("nutrition_integral");
        saleOrderBusinessType.add("activity_order");
        saleOrderBusinessType.add("baijian_direct_sales");
        refundOrderBusinessType.add("outsource_refund");
        refundOrderBusinessType.add("purchase_refund");
        transferOrderBusinessType.add("allot_out_only");
        transferOrderBusinessType.add("allot_out");
        transferOrderBusinessType.add("bc_allot");
        transferOrderBusinessType.add("maiyou_allot_out");
        transferOrderBusinessType.add("maiyou_bc_allot");
    }
}

