/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.InventoryDetailReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryDetailReportPageListRespDto;
import com.dtyunxi.tcbj.biz.service.IInventoryDetailReportService;
import com.dtyunxi.tcbj.dao.das.InventoryDetailReportDas;
import com.dtyunxi.tcbj.dao.das.LogicInventoryDas;
import com.dtyunxi.tcbj.dao.das.LogicInventorySnapDas;
import com.dtyunxi.tcbj.dao.das.LogicWarehouseDas;
import com.dtyunxi.tcbj.dao.das.RelWarehouseDas;
import com.dtyunxi.tcbj.dao.eo.InventoryDetailReportEo;
import com.dtyunxi.tcbj.dao.eo.LogicInventoryEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.RelWarehouseEo;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class InventoryDetailReportServiceImpl
implements IInventoryDetailReportService {
    private static Logger logger = LoggerFactory.getLogger(InventoryDetailReportServiceImpl.class);
    @Resource
    private InventoryDetailReportDas inventoryDetailReportDas;
    @Resource
    private LogicWarehouseDas logicWarehouseDas;
    @Resource
    private LogicInventorySnapDas logicInventorySnapDas;
    @Resource
    private RelWarehouseDas relWarehouseDas;
    @Resource
    private LogicInventoryDas logicInventoryDas;

    @Override
    public PageInfo<InventoryDetailReportPageListRespDto> queryInventoryDetailReport(InventoryDetailReportListPageReqDto dto) {
        ExtQueryChainWrapper filter = this.inventoryDetailReportDas.filter();
        if (!ObjectUtils.isEmpty((Object)dto.getExternalOrderNo())) {
            filter.like((Object)"external_order_no", (Object)("%" + dto.getExternalOrderNo() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getSourceSystem())) {
            filter.eq((Object)"source_system", (Object)dto.getSourceSystem());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getOrderType())) {
            filter.eq((Object)"order_type", (Object)dto.getOrderType());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getDocumentNo())) {
            filter.like((Object)"document_no", (Object)("%" + dto.getDocumentNo() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getOrderType())) {
            filter.eq((Object)"order_type", (Object)dto.getOrderType());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getBusinessOrderNo())) {
            filter.like((Object)"relevance_no", (Object)("%" + dto.getBusinessOrderNo() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getBusinessType())) {
            filter.eq((Object)"business_type", (Object)dto.getBusinessType());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getBusinessTypeList())) {
            filter.in((Object)"business_type", (Collection)dto.getBusinessTypeList());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getGoodsLongCode())) {
            filter.like((Object)"long_code", (Object)("%" + dto.getGoodsLongCode() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getGoodsName())) {
            filter.like((Object)"cargo_name", (Object)("%" + dto.getGoodsName() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getLogicalWarehouseCode())) {
            filter.like((Object)"logic_warehouse_code", (Object)("%" + dto.getLogicalWarehouseCode() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getLogicalWarehouseName())) {
            filter.like((Object)"logic_warehouse_name", (Object)("%" + dto.getLogicalWarehouseName() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCargoRightName())) {
            ExtQueryChainWrapper wrapper = this.logicWarehouseDas.filter();
            wrapper.like((Object)"organization_name", (Object)dto.getCargoRightName());
            List logicWarehouseCodes = wrapper.list().stream().map(LogicWarehouseEo::getWarehouseCode).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(logicWarehouseCodes)) {
                return new PageInfo();
            }
            filter.in((Object)"logic_warehouse_code", logicWarehouseCodes);
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getPhysicsWarehouseCodeList())) {
            List logicInventorySnapEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDas.filter().in((Object)"ref_warehouse_code", (Collection)dto.getPhysicsWarehouseCodeList())).eq((Object)"valid_flag", (Object)"enable")).eq((Object)"ref_warehouse_classify", (Object)"physics")).list();
            List warehouseCodeList = logicInventorySnapEos.stream().map(RelWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
            if (CollectionUtil.isEmpty(warehouseCodeList)) {
                return new PageInfo();
            }
            filter.in((Object)"logic_warehouse_code", warehouseCodeList);
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCreateTimeStart())) {
            filter.ge((Object)"notice_create_time", (Object)(dto.getCreateTimeStart() + " 00:00:00"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCreateTimeEnd())) {
            filter.le((Object)"notice_create_time", (Object)(dto.getCreateTimeEnd() + " 23:59:59"));
        }
        filter.orderByDesc((Object[])new String[]{"notice_create_time", "id"});
        PageInfo page = filter.page(dto.getPageNum(), dto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        if (ObjectUtils.isEmpty((Object)page) || CollectionUtil.isEmpty((Collection)page.getList())) {
            return pageInfo;
        }
        BeanUtils.copyProperties((Object)page, (Object)pageInfo, (String[])new String[]{"list"});
        List logicWarehouseCodes = page.getList().stream().map(InventoryDetailReportEo::getLogicWarehouseCode).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        List longCodes = page.getList().stream().map(InventoryDetailReportEo::getLongCode).collect(Collectors.toList());
        HashMap<String, String> orgNameMap = new HashMap<String, String>(logicWarehouseCodes.size());
        HashMap map = new HashMap(longCodes.size());
        HashMap snapEoMap = new HashMap(logicWarehouseCodes.size());
        if (CollectionUtil.isNotEmpty(logicWarehouseCodes)) {
            ExtQueryChainWrapper wrapper = this.logicWarehouseDas.filter();
            wrapper.in((Object)"warehouse_code", logicWarehouseCodes);
            orgNameMap.putAll(wrapper.list().stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, LogicWarehouseEo::getOrganizationName, (o, o1) -> o)));
            List logicInventorySnapEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDas.filter().in((Object)"warehouse_code", logicWarehouseCodes)).eq((Object)"valid_flag", (Object)"enable")).list();
            if (CollectionUtil.isNotEmpty((Collection)logicInventorySnapEos)) {
                Map inventorySnapEoMap = logicInventorySnapEos.stream().collect(Collectors.toMap(r -> r.getWarehouseCode(), Function.identity(), (k1, k2) -> k1));
                snapEoMap.putAll(inventorySnapEoMap);
            }
        }
        if (CollectionUtil.isNotEmpty(longCodes)) {
            ExtQueryChainWrapper queryChainWrapper = this.logicInventoryDas.filter();
            queryChainWrapper.in((Object)"sku_code", longCodes);
            List list = queryChainWrapper.list();
            Map listMap = list.stream().collect(Collectors.toMap(r -> r.getSkuCode() + "_" + r.getBatch() + "_" + r.getWarehouseCode(), Function.identity(), (k1, k2) -> k1));
            map.putAll(listMap);
        }
        pageInfo.setList(page.getList().stream().map(resp -> {
            InventoryDetailReportPageListRespDto respDto = new InventoryDetailReportPageListRespDto();
            respDto.setId(resp.getId());
            respDto.setStatisticsTime(resp.getStatisticsTime());
            respDto.setExternalOrderNo(resp.getExternalOrderNo());
            respDto.setSourceSystem(resp.getSourceSystem());
            respDto.setOrderType("in".equals(resp.getOrderType()) ? "\u5165\u5e93\u7ed3\u679c\u5355" : "\u51fa\u5e93\u7ed3\u679c\u5355");
            respDto.setBusinessType(resp.getBusinessType());
            respDto.setDocumentNo(resp.getDocumentNo());
            respDto.setBusinessOrderNo(resp.getRelevanceNo());
            respDto.setGoodsLongCode(resp.getLongCode());
            respDto.setGoodsName(resp.getCargoName());
            respDto.setBatch(resp.getBatch());
            respDto.setLogicalWarehouseCode(resp.getLogicWarehouseCode());
            respDto.setLogicalWarehouseName(resp.getLogicWarehouseName());
            String key = resp.getLongCode() + "_" + resp.getBatch() + "_" + resp.getLogicWarehouseCode();
            if (StringUtil.isNotBlank((String)resp.getLogicWarehouseCode())) {
                respDto.setCargoRightName((String)orgNameMap.get(resp.getLogicWarehouseCode()));
                if (snapEoMap.containsKey(resp.getLogicWarehouseCode())) {
                    RelWarehouseEo snapEo = (RelWarehouseEo)snapEoMap.get(resp.getLogicWarehouseCode());
                    respDto.setPhysicsWarehouseCode(snapEo.getRefWarehouseCode());
                    respDto.setPhysicsWarehouseName(snapEo.getRefWarehouseName());
                }
            }
            respDto.setCargoRightId(String.valueOf(resp.getOrganizationId()));
            respDto.setInventoryQuantity(resp.getQuantity());
            respDto.setProduceTime(resp.getProduceTime());
            respDto.setExpireTime(resp.getExpireTime());
            if (respDto.getProduceTime() == null && respDto.getExpireTime() == null && map.containsKey(key)) {
                respDto.setProduceTime(((LogicInventoryEo)map.get(key)).getProduceTime());
                respDto.setExpireTime(((LogicInventoryEo)map.get(key)).getExpireTime());
            }
            respDto.setCreateTime(resp.getNoticeCreateTime());
            return respDto;
        }).collect(Collectors.toList()));
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeJob(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DatePattern.DATETIME_PATTERN.getPattern());
        Date dayBegin = DateUtil.getDayBegin((Date)date);
        Date dayEnd = DateUtil.getDayEnd((Date)date);
        SimpleDateFormat sdf = new SimpleDateFormat(DatePattern.DATE_PATTERN.getPattern());
        String statisticsTime = sdf.format(dayBegin);
        Date statisticsDate = null;
        try {
            statisticsDate = sdf.parse(statisticsTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        InventoryDetailReportEo eo = new InventoryDetailReportEo();
        eo.setStatisticsTime(statisticsDate);
        List select = this.inventoryDetailReportDas.select((BaseEo)eo);
        if (!CollectionUtil.isEmpty((Collection)select)) {
            return;
        }
        List inventoryDetailReportEos = this.inventoryDetailReportDas.queryInventoryDetailReport(df.format(dayBegin), df.format(dayEnd));
        this.inventoryDetailReportDas.insertBatch(inventoryDetailReportEos);
    }
}

