/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.api.dto.request.SapPullRateLimitConfigReqDto;
import com.dtyunxi.tcbj.api.dto.response.SapPullRateLimitConfigRespDto;
import com.dtyunxi.tcbj.biz.config.SapPullRateLimitProperties;
import com.dtyunxi.tcbj.biz.service.ISapPullRateLimitConfigService;
import com.dtyunxi.tcbj.biz.service.ISapPullRateLimitService;
import com.dtyunxi.tcbj.biz.util.DictConfigUtil;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderApportionMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SapPullRateLimitConfigServiceImpl
implements ISapPullRateLimitConfigService {
    private static final Logger logger = LoggerFactory.getLogger(SapPullRateLimitConfigServiceImpl.class);
    @Resource
    private SapPullRateLimitProperties rateLimitProperties;
    @Resource
    private ISapPullRateLimitService sapPullRateLimitService;
    @Resource
    private SaleOrderApportionMapper saleOrderApportionMapper;
    @Resource
    private DictConfigUtil dictConfigUtil;

    @Override
    public SapPullRateLimitConfigRespDto getConfig() {
        logger.info("\u83b7\u53d6SAP\u62c9\u5355\u9650\u6d41\u914d\u7f6e");
        SapPullRateLimitConfigRespDto respDto = new SapPullRateLimitConfigRespDto();
        respDto.setEnabled(this.rateLimitProperties.getEnabled());
        respDto.setMaxOrdersPerHour(this.rateLimitProperties.getMaxOrdersPerHour());
        respDto.setEnableExtensionFilter(this.rateLimitProperties.getEnableExtensionFilter());
        int maxOrdersPerHour = this.rateLimitProperties.getMaxOrdersPerHour();
        int maxOrdersForTwoHours = maxOrdersPerHour * 2;
        respDto.setMaxOrdersForTwoHours(Integer.valueOf(maxOrdersForTwoHours));
        int currentExposedOrdersCount = this.sapPullRateLimitService.getExposedOrdersCount();
        respDto.setCurrentExposedOrdersCount(Integer.valueOf(currentExposedOrdersCount));
        int remainingQuota = Math.max(0, maxOrdersForTwoHours - currentExposedOrdersCount);
        respDto.setRemainingQuota(Integer.valueOf(remainingQuota));
        respDto.setPendingOrderCount(this.getPendingOrderCount());
        respDto.setPendingOrderCountByType(this.getPendingOrderCountByType());
        respDto.setExposedCountByType(this.getExposedCountByType());
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u914d\u7f6e: {}", (Object)JSON.toJSONString((Object)respDto));
        return respDto;
    }

    @Override
    public void updateConfig(SapPullRateLimitConfigReqDto reqDto) {
        logger.info("\u66f4\u65b0SAP\u62c9\u5355\u9650\u6d41\u914d\u7f6e: {}", (Object)JSON.toJSONString((Object)reqDto));
        if (reqDto.getMaxOrdersPerHour() != null && reqDto.getMaxOrdersPerHour() <= 0) {
            throw new BizException("-1", "maxOrdersPerHour\u5fc5\u987b\u5927\u4e8e0");
        }
        boolean dictUpdateSuccess = this.dictConfigUtil.updateSapPullRateLimitConfig(reqDto.getEnabled(), reqDto.getMaxOrdersPerHour(), reqDto.getEnableExtensionFilter());
        if (!dictUpdateSuccess) {
            logger.warn("\u5b57\u5178\u914d\u7f6e\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5728\u5b57\u5178\u7ba1\u7406\u754c\u9762\u66f4\u65b0\u3002\u914d\u7f6e\u4fe1\u606f\u5df2\u8bb0\u5f55\u5728\u65e5\u5fd7\u4e2d\u3002");
        }
        if (reqDto.getEnabled() != null) {
            this.rateLimitProperties.setEnabled(reqDto.getEnabled());
            logger.info("\u66f4\u65b0\u5185\u5b58\u914d\u7f6e - \u9650\u6d41\u5f00\u5173: {}", (Object)reqDto.getEnabled());
        }
        if (reqDto.getMaxOrdersPerHour() != null) {
            this.rateLimitProperties.setMaxOrdersPerHour(reqDto.getMaxOrdersPerHour());
            logger.info("\u66f4\u65b0\u5185\u5b58\u914d\u7f6e - \u6bcf\u5c0f\u65f6\u6700\u5927\u53ef\u62c9\u5355\u91cf: {}", (Object)reqDto.getMaxOrdersPerHour());
        }
        if (reqDto.getEnableExtensionFilter() != null) {
            this.rateLimitProperties.setEnableExtensionFilter(reqDto.getEnableExtensionFilter());
            logger.info("\u66f4\u65b0\u5185\u5b58\u914d\u7f6e - Extension\u5b57\u6bb5\u8fc7\u6ee4\u5f00\u5173: {}", (Object)reqDto.getEnableExtensionFilter());
        }
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u914d\u7f6e\u66f4\u65b0\u5b8c\u6210 - \u5b57\u5178\u66f4\u65b0: {}, \u5185\u5b58\u66f4\u65b0: \u6210\u529f", (Object)dictUpdateSuccess);
        if (!dictUpdateSuccess) {
            logger.info("\u63d0\u793a\uff1a\u8bf7\u5728\u5b57\u5178\u7ba1\u7406\u754c\u9762\u624b\u52a8\u66f4\u65b0\u5b57\u5178\u503c\uff0c\u4ee5\u786e\u4fdd\u914d\u7f6e\u6301\u4e45\u5316");
        }
    }

    @Override
    public void manualTrigger() {
        logger.info("\u624b\u52a8\u89e6\u53d1SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236");
        this.sapPullRateLimitService.manualTrigger();
    }

    @Override
    public Integer getPendingOrderCount() {
        return this.saleOrderApportionMapper.countPendingOrders();
    }

    private Map<String, Integer> getPendingOrderCountByType() {
        List list = this.saleOrderApportionMapper.countPendingOrdersByType();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map map : list) {
            String type = (String)map.get("type");
            Integer count = ((Number)map.get("count")).intValue();
            result.put(type, count);
        }
        return result;
    }

    private Map<String, Integer> getExposedCountByType() {
        List list = this.saleOrderApportionMapper.countExposedByType();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map map : list) {
            String type = (String)map.get("type");
            Integer count = ((Number)map.get("count")).intValue();
            result.put(type, count);
        }
        return result;
    }
}

