/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.TmsSignForStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.TmsSignForStatisticsRespDto;
import com.dtyunxi.tcbj.biz.service.IHomePageStatisticsAssistService;
import com.dtyunxi.tcbj.biz.service.ITmsSignForStatisticsService;
import com.dtyunxi.tcbj.dao.das.TmsSignForStatisticsDas;
import com.dtyunxi.tcbj.dao.eo.TmsSignForStatisticsEo;
import com.dtyunxi.tcbj.dao.vo.TmsSignForStatisticsVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TmsSignForStatisticsServiceImpl
implements ITmsSignForStatisticsService {
    @Resource
    private TmsSignForStatisticsDas tmsSignForStatisticsDas;
    @Resource
    private IHomePageStatisticsAssistService homePageStatisticsAssistService;

    @Override
    public Long addTmsSignForStatistics(TmsSignForStatisticsReqDto addReqDto) {
        TmsSignForStatisticsEo tmsSignForStatisticsEo = new TmsSignForStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)tmsSignForStatisticsEo);
        this.tmsSignForStatisticsDas.insert((BaseEo)tmsSignForStatisticsEo);
        return tmsSignForStatisticsEo.getId();
    }

    @Override
    public void modifyTmsSignForStatistics(TmsSignForStatisticsReqDto modifyReqDto) {
        TmsSignForStatisticsEo tmsSignForStatisticsEo = new TmsSignForStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)tmsSignForStatisticsEo);
        this.tmsSignForStatisticsDas.updateSelective((BaseEo)tmsSignForStatisticsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTmsSignForStatistics(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.tmsSignForStatisticsDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public TmsSignForStatisticsRespDto queryById(Long id) {
        this.syncTmsSignForStatistics();
        TmsSignForStatisticsEo tmsSignForStatisticsEo = (TmsSignForStatisticsEo)this.tmsSignForStatisticsDas.selectByPrimaryKey(id);
        TmsSignForStatisticsRespDto tmsSignForStatisticsRespDto = new TmsSignForStatisticsRespDto();
        DtoHelper.eo2Dto((BaseEo)tmsSignForStatisticsEo, (BaseVo)tmsSignForStatisticsRespDto);
        return tmsSignForStatisticsRespDto;
    }

    @Override
    public PageInfo<TmsSignForStatisticsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TmsSignForStatisticsReqDto tmsSignForStatisticsReqDto = (TmsSignForStatisticsReqDto)JSON.parseObject((String)filter, TmsSignForStatisticsReqDto.class);
        TmsSignForStatisticsEo tmsSignForStatisticsEo = new TmsSignForStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)tmsSignForStatisticsReqDto, (BaseEo)tmsSignForStatisticsEo);
        PageInfo eoPageInfo = this.tmsSignForStatisticsDas.selectPage((BaseEo)tmsSignForStatisticsEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TmsSignForStatisticsRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncTmsSignForStatistics() {
        List<TmsSignForStatisticsVo> vos = this.homePageStatisticsAssistService.queryTmsSignForStatistics();
        if (CollectionUtil.isEmpty(vos)) {
            return;
        }
        List<TmsSignForStatisticsEo> eoList = this.handleData(vos);
        this.save(eoList);
    }

    @Override
    public List<TmsSignForStatisticsRespDto> queryTmsSignForStatistics(String billType) {
        List eos = this.tmsSignForStatisticsDas.queryTmsSignForStatistics(billType);
        ArrayList<TmsSignForStatisticsRespDto> dtoList = new ArrayList<TmsSignForStatisticsRespDto>();
        DtoHelper.eoList2DtoList((Collection)eos, dtoList, TmsSignForStatisticsRespDto.class);
        return dtoList;
    }

    @Transactional(rollbackFor={Exception.class})
    private void save(List<TmsSignForStatisticsEo> eoList) {
        this.tmsSignForStatisticsDas.deleteAll();
        this.tmsSignForStatisticsDas.insertBatch(eoList);
    }

    private List<TmsSignForStatisticsEo> handleData(List<TmsSignForStatisticsVo> voList) {
        return voList.stream().map(i -> {
            TmsSignForStatisticsEo eo = new TmsSignForStatisticsEo();
            CubeBeanUtils.copyProperties((Object)eo, (Object)i, (String[])new String[0]);
            return eo;
        }).collect(Collectors.toList());
    }
}

