/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.job;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.api.dto.request.TaskQueryParamsDro;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="sortingExpenseReport")
@Scope(value="prototype")
public class SortingExpenseReportJob
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SortingExpenseReportJob.class);
    @Resource
    private ISortingExpenseService sortingExpenseService;

    public void before(TaskMsg taskMsg) {
        logger.info("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        try {
            logger.error("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5f00\u59cb");
            String content = taskMsg.getContent();
            TaskQueryParamsDro queryParamsDro = new TaskQueryParamsDro();
            logger.info("\u5206\u62e3\u8d39\u7528\u62a5\u8868content:{}", (Object)content);
            if (StringUtils.isNotBlank((CharSequence)content)) {
                queryParamsDro = (TaskQueryParamsDro)JSON.parseObject((String)content, TaskQueryParamsDro.class);
            }
            SimpleDateFormat df = new SimpleDateFormat(DatePattern.DATETIME_PATTERN.getPattern());
            Date dayBegin = SortingExpenseReportJob.getBeginDayOfYesterday();
            Date dayEnd = SortingExpenseReportJob.getEndDayOfYesterday();
            if (queryParamsDro != null && queryParamsDro.getStartTime() != null && queryParamsDro.getEndTime() != null) {
                dayBegin = queryParamsDro.getStartTime();
                dayEnd = queryParamsDro.getEndTime();
            }
            queryParamsDro.setStartDateStr(df.format(dayBegin));
            queryParamsDro.setEndDateStr(df.format(dayEnd));
            this.sortingExpenseService.executeJobNew(queryParamsDro);
        }
        catch (Exception e) {
            logger.error("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5f02\u5e38", (Throwable)e);
            return true;
        }
        return true;
    }

    public static Date getBeginDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayBegin());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getEndDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayEnd());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u7ed3\u675f");
    }
}

