/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.FinishedInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinishedInventoryCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinishedInventoryRespDto;
import com.dtyunxi.tcbj.biz.service.IFinishedInventoryService;
import com.dtyunxi.tcbj.dao.das.FinishedInventoryDas;
import com.dtyunxi.tcbj.dao.eo.FinishedInventoryEo;
import com.dtyunxi.tcbj.dao.mapper.FinishedInventoryMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinishedInventoryServiceImpl
implements IFinishedInventoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishedInventoryServiceImpl.class);
    @Resource
    private FinishedInventoryDas finishedInventoryDas;
    @Resource
    private FinishedInventoryMapper finishedInventoryMapper;

    @Override
    public Long addFinishedInventory(FinishedInventoryReqDto addReqDto) {
        FinishedInventoryEo finishedInventoryEo = new FinishedInventoryEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)finishedInventoryEo);
        this.finishedInventoryDas.insert((BaseEo)finishedInventoryEo);
        return finishedInventoryEo.getId();
    }

    @Override
    public void modifyFinishedInventory(FinishedInventoryReqDto modifyReqDto) {
        FinishedInventoryEo finishedInventoryEo = new FinishedInventoryEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)finishedInventoryEo);
        this.finishedInventoryDas.updateSelective((BaseEo)finishedInventoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeFinishedInventory(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.finishedInventoryDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public FinishedInventoryRespDto queryById(Long id) {
        FinishedInventoryEo finishedInventoryEo = (FinishedInventoryEo)this.finishedInventoryDas.selectByPrimaryKey(id);
        FinishedInventoryRespDto finishedInventoryRespDto = new FinishedInventoryRespDto();
        DtoHelper.eo2Dto((BaseEo)finishedInventoryEo, (BaseVo)finishedInventoryRespDto);
        return finishedInventoryRespDto;
    }

    @Override
    public PageInfo<FinishedInventoryRespDto> queryByPage(FinishedInventoryReqDto finishedInventoryReqDto) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtil.isNotBlank((String)finishedInventoryReqDto.getLongCode())) {
            wrapper.like((Object)"long_code", (Object)finishedInventoryReqDto.getLongCode());
        }
        if (StringUtil.isNotBlank((String)finishedInventoryReqDto.getCargoName())) {
            wrapper.like((Object)"cargo_name", (Object)finishedInventoryReqDto.getCargoName());
        }
        if (finishedInventoryReqDto.getStatisticalTimeStart() != null) {
            wrapper.ge((Object)"statistical_time", (Object)finishedInventoryReqDto.getStatisticalTimeStart());
        }
        if (finishedInventoryReqDto.getStatisticalTimeEnd() != null) {
            wrapper.le((Object)"statistical_time", (Object)finishedInventoryReqDto.getStatisticalTimeEnd());
        }
        wrapper.orderByDesc((Object)"statistical_time");
        wrapper.orderByAsc((Object)"long_code");
        PageHelper.startPage((int)finishedInventoryReqDto.getPageNum(), (int)finishedInventoryReqDto.getPageSize());
        List finishedInventoryEos = this.finishedInventoryMapper.selectList((Wrapper)wrapper);
        PageInfo info = new PageInfo(finishedInventoryEos);
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)dtoPageInfo, (String[])new String[]{"list"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)info.getList(), dtoList, FinishedInventoryRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<FinishedInventoryCountRespDto> queryChannelInventoryByCount(FinishedInventoryReqDto req) {
        return this.finishedInventoryDas.queryChannelInventoryByCount(req);
    }
}

