/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.finance.api.dto.request.logistic.RuleVolumeDto;
import com.dtyunxi.finance.api.dto.request.logistic.SeasonVolumeDto;
import com.dtyunxi.finance.api.dto.request.logistic.TemplateVolumeDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkQueryRespDto;
import com.dtyunxi.finance.api.exception.SeasonTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.biz.service.LogisticBaseService;
import com.dtyunxi.tcbj.biz.utils.BigDecimalUtil;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.biz.utils.LbsUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="gateway#12")
public class LogisticNumVolume2ServiceImpl
extends LogisticBaseService<FinLogisticsReportDto> {
    private static final Logger log = LoggerFactory.getLogger(LogisticNumVolume2ServiceImpl.class);
    @Resource
    private LbsUtil lbsUtil;

    @Override
    protected FinLogisticsReportDto handle(FinLogisticsReportDto request) {
        log.info("\u4f53\u79ef\u65b9\u5f0f\u7269\u6d41\u8d39\u7528\u8ba1\u7b97\uff1a{}", (Object)JSON.toJSONString((Object)request));
        FinLogisticsReportDto reportDto = new FinLogisticsReportDto();
        BeanUtils.copyProperties((Object)request, (Object)reportDto);
        reportDto.setUnloadAmount(null);
        reportDto.setDeliveryAmount(null);
        LogisticRecordQueryRespDto calTemplateDto = reportDto.getLogisticsTemplate();
        if (null != calTemplateDto && null != calTemplateDto.getId()) {
            reportDto.setTransportAmount(BigDecimal.ZERO);
            reportDto.setChargeMode(calTemplateDto.getChargeMode().toString());
            RuleVolumeDto ruleVolumeDto = (RuleVolumeDto)JSONObject.parseObject((String)calTemplateDto.getParams(), RuleVolumeDto.class);
            List volumeDtoList = ruleVolumeDto.getRule();
            OilLinkQueryRespDto linkQueryRespDto = request.getOilLinkQueryRespDto();
            log.info("\u4f18\u5316\u8054\u52a8\u8bbe\u7f6e:{}", (Object)JSON.toJSONString((Object)linkQueryRespDto));
            BigDecimal oilPriceRange = null;
            if (linkQueryRespDto != null && linkQueryRespDto.getAmount() != null && calTemplateDto.getContractOilPrice() != null && calTemplateDto.getContractOilPrice().compareTo(BigDecimal.ZERO) > 0) {
                oilPriceRange = linkQueryRespDto.getAmount().subtract(calTemplateDto.getContractOilPrice()).divide(calTemplateDto.getContractOilPrice(), 4, RoundingMode.DOWN);
            } else if (linkQueryRespDto != null) {
                BigDecimal amount = linkQueryRespDto.getAmount();
                if (amount == null) {
                    this.setAbnormalCauses(reportDto, "\u6cb9\u4ef7\u8054\u52a8\u8bbe\u7f6e\u4e2d\u5355\u4ef7\u4e3a\u7a7a");
                    reportDto.setStatus(Integer.valueOf(1));
                    log.info("\u672a\u8ba1\u7b97\u6cb9\u4ef7\u53d8\u5316\u5e45\u5ea6scope\u7684\u62a5\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)calTemplateDto));
                    return reportDto;
                }
            } else {
                this.setAbnormalCauses(reportDto, "\u6cb9\u4ef7\u8054\u52a8\u8bbe\u7f6e\u4e3a\u7a7a");
                reportDto.setStatus(Integer.valueOf(1));
                return reportDto;
            }
            BigDecimal scope = null;
            if (oilPriceRange != null) {
                reportDto.setRangeOilPrice(super.getRangeOilPrice(oilPriceRange));
                scope = super.setOilChangeData(oilPriceRange);
                reportDto.setAdjustOilPrice(scope);
            }
            log.info("\u672a\u8ba1\u7b97\u6cb9\u4ef7\u53d8\u5316\u5e45\u5ea6scope:{}", (Object)JSON.toJSONString(scope));
            if (scope == null && calTemplateDto.getContractOilPrice() != null) {
                this.setAbnormalCauses(reportDto, "\u672a\u5339\u914d\u5230\u6cb9\u4ef7\u6d6e\u52a8\u9636\u68af");
                reportDto.setStatus(Integer.valueOf(1));
            }
            AppointAreaQueryRespDto areaQueryRespDto = request.getAppointAreaQueryRespDto();
            log.info("areaQueryRespDto:{}", (Object)JSON.toJSONString((Object)areaQueryRespDto));
            if (areaQueryRespDto != null && StringUtils.isNotBlank((CharSequence)areaQueryRespDto.getParams())) {
                if (SeasonTypeEnum.COMMON.getType().equals(calTemplateDto.getSeasonType())) {
                    SeasonVolumeDto seasonVolumeDto = (SeasonVolumeDto)JSONObject.parseObject((String)areaQueryRespDto.getParams(), SeasonVolumeDto.class);
                    if (new BigDecimal(ruleVolumeDto.getTotalBox()).compareTo(request.getBox()) >= 0) {
                        reportDto.setTransportPrice(seasonVolumeDto.getBox());
                        reportDto.setTransportAmount(BigDecimalUtil.mul(seasonVolumeDto.getBox(), request.getBox()));
                        reportDto.setPieceVolume("piece");
                        reportDto.setCalUnitName("\u4ef6");
                    } else {
                        reportDto.setTransportPrice(seasonVolumeDto.getVolume01());
                        reportDto.setTransportAmount(BigDecimalUtil.mul(seasonVolumeDto.getVolume01(), request.getVolume()));
                        reportDto.setUnloadAmount(BigDecimalUtil.mul(request.getVolume(), null == calTemplateDto.getUnloadPrice() ? BigDecimal.ZERO : calTemplateDto.getUnloadPrice()));
                        reportDto.setPieceVolume("volume");
                        reportDto.setCalUnitName("\u4f53\u79ef");
                    }
                    reportDto.setDeliveryAmount(null == calTemplateDto.getDeliveryPrice() ? BigDecimal.ZERO : calTemplateDto.getDeliveryPrice());
                    reportDto.setMinCharge(BigDecimal.ZERO);
                } else {
                    TemplateVolumeDto templateVolumeDto = (TemplateVolumeDto)JSONObject.parseObject((String)areaQueryRespDto.getParams(), TemplateVolumeDto.class);
                    String moth = DateTimeUtils.getMonth(request.getOutboundTime());
                    if (calTemplateDto.getOffSeason().contains(moth)) {
                        if (new BigDecimal(ruleVolumeDto.getTotalBox()).compareTo(request.getBox()) > 0) {
                            reportDto.setTransportPrice(templateVolumeDto.getOff().getBox());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateVolumeDto.getOff().getBox(), request.getBox()));
                            reportDto.setPieceVolume("piece");
                            reportDto.setCalUnitName("\u4ef6");
                        } else {
                            reportDto.setTransportPrice(templateVolumeDto.getOff().getVolume01());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateVolumeDto.getOff().getVolume01(), request.getVolume()));
                            reportDto.setUnloadAmount(BigDecimalUtil.mul(request.getVolume(), null == calTemplateDto.getUnloadPrice() ? BigDecimal.ZERO : calTemplateDto.getUnloadPrice()));
                            reportDto.setPieceVolume("volume");
                            reportDto.setCalUnitName("\u4f53\u79ef");
                        }
                        reportDto.setMinCharge(BigDecimal.ZERO);
                    } else if (calTemplateDto.getPeakSeason().contains(moth)) {
                        if (new BigDecimal(ruleVolumeDto.getTotalBox()).compareTo(request.getBox()) > 0) {
                            reportDto.setTransportPrice(templateVolumeDto.getPeak().getBox());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateVolumeDto.getPeak().getBox(), request.getBox()));
                            reportDto.setPieceVolume("piece");
                        } else {
                            reportDto.setTransportPrice(templateVolumeDto.getPeak().getVolume01());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateVolumeDto.getPeak().getVolume01(), request.getVolume()));
                            reportDto.setUnloadAmount(BigDecimalUtil.mul(request.getVolume(), null == calTemplateDto.getUnloadPrice() ? BigDecimal.ZERO : calTemplateDto.getUnloadPrice()));
                            reportDto.setPieceVolume("volume");
                        }
                        reportDto.setMinCharge(BigDecimal.ZERO);
                    } else {
                        reportDto.setTransportPrice(BigDecimal.ZERO);
                        reportDto.setTransportAmount(BigDecimal.ZERO);
                        reportDto.setMinCharge(BigDecimal.ZERO);
                        this.setAbnormalCauses(reportDto, "\u672a\u5339\u914d\u5230\u6de1\u65fa\u5b63\u914d\u7f6e");
                        reportDto.setStatus(Integer.valueOf(1));
                    }
                    reportDto.setDeliveryAmount(null == calTemplateDto.getDeliveryPrice() ? BigDecimal.ZERO : calTemplateDto.getDeliveryPrice());
                }
            } else {
                this.setAbnormalCauses(reportDto, "\u672a\u5339\u914d\u5230\u7269\u6d41\u8fd0\u8d39\u6a21\u677f\u533a\u57df");
                reportDto.setStatus(Integer.valueOf(1));
            }
            if (scope != null && reportDto.getTransportAmount() != null) {
                log.info("\u672a\u8ba1\u7b97\u6cb9\u4ef7\u53d8\u5316\u5e45\u5ea6scope:{},{}", (Object)JSON.toJSONString((Object)reportDto.getTransportAmount()), (Object)scope);
                reportDto.setOilPrice(BigDecimalUtil.mul(scope, reportDto.getTransportAmount()));
            }
        } else {
            String address = request.getProvince();
            String city = request.getCity();
            String area = request.getArea();
            if (StringUtils.isNotBlank((CharSequence)city)) {
                address = address + city;
            }
            if (StringUtils.isNotBlank((CharSequence)area)) {
                address = address + area;
            }
            this.setAbnormalCauses(reportDto, String.format("\u6839\u636e\u7701\u5e02\u533a\u3010%s\u3011\u672a\u5339\u914d\u5230\u7269\u6d41\u8fd0\u8d39\u6a21\u677f\u533a\u57df", address));
            reportDto.setStatus(Integer.valueOf(1));
        }
        if (Objects.equals(reportDto.getStatus(), 0)) {
            BigDecimal totalTransportAmount = BigDecimal.ZERO;
            totalTransportAmount = reportDto.getOilPrice() != null && reportDto.getOilPrice().compareTo(BigDecimal.ZERO) > 0 ? totalTransportAmount.add(reportDto.getOilPrice()) : totalTransportAmount.add(reportDto.getTransportAmount());
            if (reportDto.getDeliveryAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportDto.getDeliveryAmount());
            }
            if (reportDto.getUnloadAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportDto.getUnloadAmount());
            }
            if (reportDto.getSpecialAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportDto.getSpecialAmount());
            }
            reportDto.setTotalTransportAmount(totalTransportAmount);
        }
        return reportDto;
    }
}

