/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDeliverQuantityReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDeliverQuantityRespDto;
import com.dtyunxi.tcbj.biz.service.IExpressCostDeliverQuantityService;
import com.dtyunxi.tcbj.biz.service.IExpressCostDetailService;
import com.dtyunxi.tcbj.dao.das.ExpressCostDeliverQuantityDas;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDeliverQuantityEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDetailEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExpressCostDeliverQuantityServiceImpl
implements IExpressCostDeliverQuantityService {
    private static final Logger logger = LoggerFactory.getLogger(ExpressCostDeliverQuantityServiceImpl.class);
    @Resource
    private ExpressCostDeliverQuantityDas expressCostDeliverQuantityDas;
    @Resource
    private IExpressCostDetailService expressCostDetailService;

    @Override
    public Long addExpressCostDeliverQuantity(ExpressCostDeliverQuantityReqDto addReqDto) {
        ExpressCostDeliverQuantityEo expressCostDeliverQuantityEo = new ExpressCostDeliverQuantityEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)expressCostDeliverQuantityEo);
        this.expressCostDeliverQuantityDas.insert((BaseEo)expressCostDeliverQuantityEo);
        return expressCostDeliverQuantityEo.getId();
    }

    @Override
    public void modifyExpressCostDeliverQuantity(ExpressCostDeliverQuantityReqDto modifyReqDto) {
        logger.info("\u4fee\u6539\u5feb\u9012\u8d39\u7528\u6708\u7edf\u8ba1\u53d1\u8d27\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto));
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)modifyReqDto.getId()), (String)"\u8bf7\u6c42id\u4e0d\u80fd\u4e3a\u7a7a");
        ExpressCostDeliverQuantityEo deliverQuantityEo = (ExpressCostDeliverQuantityEo)this.expressCostDeliverQuantityDas.selectByPrimaryKey(modifyReqDto.getId());
        deliverQuantityEo.setChargeNum(modifyReqDto.getChargeNum());
        deliverQuantityEo.setRemark(modifyReqDto.getRemark());
        this.expressCostDeliverQuantityDas.updateSelective((BaseEo)deliverQuantityEo);
        ExpressCostDeliverQuantityReqDto reqDto = (ExpressCostDeliverQuantityReqDto)BeanUtil.copyProperties((Object)deliverQuantityEo, ExpressCostDeliverQuantityReqDto.class, (String[])new String[0]);
        CompletableFuture.runAsync(() -> this.expressCostDetailService.updateByExpressCostDeliverQuantity(reqDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeExpressCostDeliverQuantity(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.expressCostDeliverQuantityDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ExpressCostDeliverQuantityRespDto queryById(Long id) {
        ExpressCostDeliverQuantityEo expressCostDeliverQuantityEo = (ExpressCostDeliverQuantityEo)this.expressCostDeliverQuantityDas.selectByPrimaryKey(id);
        ExpressCostDeliverQuantityRespDto expressCostDeliverQuantityRespDto = new ExpressCostDeliverQuantityRespDto();
        DtoHelper.eo2Dto((BaseEo)expressCostDeliverQuantityEo, (BaseVo)expressCostDeliverQuantityRespDto);
        return expressCostDeliverQuantityRespDto;
    }

    @Override
    public PageInfo<ExpressCostDeliverQuantityRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ExpressCostDeliverQuantityReqDto expressCostDeliverQuantityReqDto = (ExpressCostDeliverQuantityReqDto)JSON.parseObject((String)filter, ExpressCostDeliverQuantityReqDto.class);
        ExpressCostDeliverQuantityEo expressCostDeliverQuantityEo = new ExpressCostDeliverQuantityEo();
        DtoHelper.dto2Eo((BaseVo)expressCostDeliverQuantityReqDto, (BaseEo)expressCostDeliverQuantityEo);
        PageInfo eoPageInfo = this.expressCostDeliverQuantityDas.selectPage((BaseEo)expressCostDeliverQuantityEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ExpressCostDeliverQuantityRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ExpressCostDeliverQuantityRespDto> queryPage(ExpressCostDeliverQuantityReqDto reqDto) {
        logger.info("\u5feb\u9012\u8d39\u7528\u6708\u7edf\u8ba1\u53d1\u8d27\u91cf\u5206\u9875\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDeliverQuantityDas.filter().eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getBookkeepingMonth()), (Object)"bookkeeping_month", (Object)reqDto.getBookkeepingMonth())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getWarehouseCodeList()), (Object)"warehouse_code", (Collection)reqDto.getWarehouseCodeList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getLogisticCodeList()), (Object)"logistic_code", (Collection)reqDto.getLogisticCodeList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getTransportTypeList()), (Object)"transport_type", (Collection)reqDto.getTransportTypeList())).orderByDesc((Object)"update_time")).page(reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ExpressCostDeliverQuantityRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void addExpressCostDeliverQuantity(List<ExpressCostDeliverQuantityReqDto> reqDtoList) {
        logger.info("\u6279\u91cf\u65b0\u589e\u5feb\u9012\u8d39\u7528\u6708\u7edf\u8ba1\u53d1\u8d27\u91cf\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        List eoList = BeanUtil.copyToList(reqDtoList, ExpressCostDeliverQuantityEo.class);
        this.expressCostDeliverQuantityDas.insertBatch(eoList);
    }

    @Override
    public void addExpressCostDeliverQuantityByExpressDetail(List<ExpressCostDetailEo> expressCostDetailEoList) {
        logger.info("\u6839\u636e\u5feb\u9012\u660e\u7ec6\u4fe1\u606f\u751f\u6210\u6708\u53d1\u8d27\u7edf\u8ba1\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(expressCostDetailEoList));
        Map<Long, List<ExpressCostDetailEo>> detailMap = expressCostDetailEoList.stream().filter(f -> ObjectUtil.isNotEmpty((Object)f.getContractId())).collect(Collectors.groupingBy(ExpressCostDetailEo::getContractId));
        if (ObjectUtil.isEmpty(detailMap)) {
            logger.info("\u65e0\u6570\u636e\u9700\u7edf\u8ba1");
            return;
        }
        ExpressCostDetailEo costDetailEo = expressCostDetailEoList.get(0);
        List deliverQuantityEoList = ((ExtQueryChainWrapper)this.expressCostDeliverQuantityDas.filter().eq((Object)"bookkeeping_month", (Object)costDetailEo.getBookkeepingMonth())).list();
        if (CollectionUtil.isNotEmpty((Collection)deliverQuantityEoList)) {
            List ids = deliverQuantityEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.expressCostDeliverQuantityDas.logicDeleteByIds(ids);
        }
        ArrayList insertList = new ArrayList();
        detailMap.forEach((k, v) -> {
            ExpressCostDetailEo detailEo = (ExpressCostDetailEo)v.get(0);
            ExpressCostDeliverQuantityEo deliverQuantityEo = new ExpressCostDeliverQuantityEo();
            deliverQuantityEo.setBookkeepingMonth(detailEo.getBookkeepingMonth());
            deliverQuantityEo.setChargeNum(Integer.valueOf(v.size()));
            deliverQuantityEo.setStatNum(Integer.valueOf(v.size()));
            deliverQuantityEo.setLogisticCode(detailEo.getLogisticCode());
            deliverQuantityEo.setLogisticCompany(detailEo.getLogisticCompany());
            deliverQuantityEo.setWarehouseCode(detailEo.getWarehouseCode());
            deliverQuantityEo.setWarehouseName(detailEo.getWarehouseName());
            deliverQuantityEo.setTransportType(detailEo.getTransportType());
            insertList.add(deliverQuantityEo);
        });
        this.expressCostDeliverQuantityDas.insertBatch(insertList);
    }

    @Override
    public List<ExpressCostDeliverQuantityRespDto> queryList(ExpressCostDeliverQuantityReqDto reqDto) {
        logger.info("\u67e5\u8be2\u5feb\u9012\u8d39\u7528\u6708\u7edf\u8ba1\u53d1\u8d27\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ExpressCostDeliverQuantityEo queryEo = (ExpressCostDeliverQuantityEo)BeanUtil.copyProperties((Object)reqDto, ExpressCostDeliverQuantityEo.class, (String[])new String[0]);
        List deliverQuantityEoList = this.expressCostDeliverQuantityDas.selectList((BaseEo)queryEo);
        return BeanUtil.copyToList((Collection)deliverQuantityEoList, ExpressCostDeliverQuantityRespDto.class);
    }
}

