/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.BatchInversionReqDto;
import com.dtyunxi.tcbj.api.dto.request.PcpItemReqDto;
import com.dtyunxi.tcbj.api.dto.response.BatchInversionRespDto;
import com.dtyunxi.tcbj.api.dto.response.PcpItemRespDto;
import com.dtyunxi.tcbj.biz.service.IPcpItemService;
import com.dtyunxi.tcbj.dao.das.PcpItemDas;
import com.dtyunxi.tcbj.dao.eo.PcpItemEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PcpItemServiceImpl
implements IPcpItemService {
    @Resource
    private PcpItemDas pcpItemDas;

    @Override
    public Long addPcpItem(PcpItemReqDto addReqDto) {
        PcpItemEo pcpItemEo = new PcpItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)pcpItemEo);
        this.pcpItemDas.insert((BaseEo)pcpItemEo);
        return pcpItemEo.getId();
    }

    @Override
    public void modifyPcpItem(PcpItemReqDto modifyReqDto) {
        PcpItemEo pcpItemEo = new PcpItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)pcpItemEo);
        this.pcpItemDas.updateSelective((BaseEo)pcpItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePcpItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.pcpItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PcpItemRespDto queryById(Long id) {
        PcpItemEo pcpItemEo = (PcpItemEo)this.pcpItemDas.selectByPrimaryKey(id);
        PcpItemRespDto pcpItemRespDto = new PcpItemRespDto();
        DtoHelper.eo2Dto((BaseEo)pcpItemEo, (BaseVo)pcpItemRespDto);
        return pcpItemRespDto;
    }

    @Override
    public PageInfo<PcpItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PcpItemReqDto pcpItemReqDto = (PcpItemReqDto)JSON.parseObject((String)filter, PcpItemReqDto.class);
        PcpItemEo pcpItemEo = new PcpItemEo();
        DtoHelper.dto2Eo((BaseVo)pcpItemReqDto, (BaseEo)pcpItemEo);
        PageInfo eoPageInfo = this.pcpItemDas.selectPage((BaseEo)pcpItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PcpItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<BatchInversionRespDto> queryItemByBatchInversion(BatchInversionReqDto reqDto) {
        Page physicsInventoryRespVos = this.pcpItemDas.queryItemByBatchInversion(reqDto);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)physicsInventoryRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List physicsInventoryRespVoList = physicsInventoryRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)physicsInventoryRespVoList)) {
            respDtoPageInfo.setList(physicsInventoryRespVoList.stream().map(r -> {
                r.setWarehouseOnlineFlag(Objects.equals("on_line", r.getWarehouseOnlineFlag()) ? "\u7ebf\u4e0a" : "\u7ebf\u4e0b");
                return r;
            }).collect(Collectors.toList()));
        }
        return respDtoPageInfo;
    }
}

