/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.tcbj.api.dto.request.ChannelInventoryReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryQueryDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryQueryWithGiftPackageInfoDto;
import com.dtyunxi.tcbj.api.vo.ChannelInventoryReportRespVo;
import com.dtyunxi.tcbj.api.vo.InventoryRespVo;
import com.dtyunxi.tcbj.api.vo.InventoryRespWithGiftPackageInfoVo;
import com.dtyunxi.tcbj.biz.service.IInWarehouseService;
import com.dtyunxi.tcbj.dao.das.InWarehouseDas;
import com.dtyunxi.tcbj.dao.eo.InWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.ShInventoryPreemptionEo;
import com.dtyunxi.tcbj.dao.mapper.ShInventoryPreemptionMapper;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InWarehouseServiceImpl
implements IInWarehouseService {
    @Autowired
    InWarehouseDas inWarehouseDas;
    @Autowired
    ShInventoryPreemptionMapper shInventoryPreemptionMapper;

    @Override
    public InWarehouseEo queryById(Long id) {
        InWarehouseEo inWarehouseEo = (InWarehouseEo)this.inWarehouseDas.selectByPrimaryKey(id);
        return inWarehouseEo;
    }

    @Override
    public PageInfo<InventoryRespVo> queryInventoryPage(InventoryQueryDto queryDto) {
        return this.inWarehouseDas.queryInventoryPage(queryDto);
    }

    @Override
    public PageInfo<InventoryRespWithGiftPackageInfoVo> queryInventoryWithGiftPackageInfoPage(InventoryQueryWithGiftPackageInfoDto queryDto) {
        return this.inWarehouseDas.queryInventoryPageWithGiftPackageInfo(queryDto);
    }

    @Override
    public PageInfo<ChannelInventoryReportRespVo> queryChannelInventoryReportPage(ChannelInventoryReportQueryDto queryDto) {
        PageInfo voPageInfo = this.inWarehouseDas.queryChannelInventoryReportPage(queryDto);
        if (null == voPageInfo || CollectionUtils.isEmpty((Collection)voPageInfo.getList())) {
            return voPageInfo;
        }
        List voList = voPageInfo.getList();
        List channelWarehouseIds = voList.stream().map(ChannelInventoryReportRespVo::getChannelWarehouseId).distinct().collect(Collectors.toList());
        List cargoCodes = voList.stream().map(ChannelInventoryReportRespVo::getCargoCode).distinct().collect(Collectors.toList());
        List channelInventoryPreemptionEos = this.shInventoryPreemptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ShInventoryPreemptionEo.class).in(ShInventoryPreemptionEo::getWarehouseId, channelWarehouseIds)).in(ShInventoryPreemptionEo::getSkuCode, cargoCodes)).eq(ShInventoryPreemptionEo::getWarehouseClassify, (Object)CsWarehouseClassifyEnum.CHANNEL.getCode())).eq(ShInventoryPreemptionEo::getValid, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)channelInventoryPreemptionEos)) {
            List sourceNoList = channelInventoryPreemptionEos.stream().map(ShInventoryPreemptionEo::getSourceNo).distinct().collect(Collectors.toList());
            List virtualInventoryPreemptionEos = this.shInventoryPreemptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ShInventoryPreemptionEo.class).in(ShInventoryPreemptionEo::getSourceNo, sourceNoList)).in(ShInventoryPreemptionEo::getSkuCode, cargoCodes)).eq(ShInventoryPreemptionEo::getWarehouseClassify, (Object)CsWarehouseClassifyEnum.VIRTUAL.getCode())).eq(ShInventoryPreemptionEo::getValid, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            for (ChannelInventoryReportRespVo vo : voList) {
                Long channelWarehouseId = vo.getChannelWarehouseId();
                String cargoCode = vo.getCargoCode();
                BigDecimal virtualPreempt = BigDecimal.ZERO;
                List filterChannelInventoryPreemptionEos = channelInventoryPreemptionEos.stream().filter(o -> Objects.equals(o.getWarehouseId(), channelWarehouseId) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)cargoCode)).collect(Collectors.toList());
                for (ShInventoryPreemptionEo filterChannelInventoryPreemptionEo : filterChannelInventoryPreemptionEos) {
                    List filterVirtualInventoryPreemptionEos = virtualInventoryPreemptionEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSourceNo(), (CharSequence)filterChannelInventoryPreemptionEo.getSourceNo()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)cargoCode)).collect(Collectors.toList());
                    for (ShInventoryPreemptionEo filterVirtualInventoryPreemptionEo : filterVirtualInventoryPreemptionEos) {
                        virtualPreempt = BigDecimalUtils.add((BigDecimal)virtualPreempt, (BigDecimal)filterVirtualInventoryPreemptionEo.getPreemptNum());
                    }
                }
                vo.setVirtualPreempt(virtualPreempt);
                vo.setLogicOtherPreempt(BigDecimalUtils.subtract((BigDecimal)vo.getLogicPreempt(), (BigDecimal)vo.getLogicSalePreempt()));
                vo.setNotXyPreempt(BigDecimalUtils.subtract((BigDecimal)vo.getVirtualPreempt(), (BigDecimal)vo.getLogicSalePreempt()));
                vo.setLogicLessAvailable(BigDecimalUtils.subtract((BigDecimal)BigDecimalUtils.add((BigDecimal)vo.getLogicAvailable(), (BigDecimal)vo.getLogicLockInventory()), (BigDecimal)vo.getNotXyPreempt()));
                vo.setRemarkFlag(Integer.valueOf(0));
                if (BigDecimalUtils.ltZero((BigDecimal)vo.getChannelAvailable()).booleanValue()) {
                    vo.setRemark("\u903b\u8f91\u4ed3\u51fa\u5e93");
                    vo.setRemarkFlag(Integer.valueOf(1));
                    continue;
                }
                if (BigDecimalUtils.equals((BigDecimal)vo.getChannelAvailable(), (BigDecimal)vo.getLogicLessAvailable()).booleanValue()) continue;
                vo.setRemark("\u5f02\u5e38");
                vo.setRemarkFlag(Integer.valueOf(2));
            }
        }
        return voPageInfo;
    }
}

