/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.WarehouseTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.IntransitCargoQueryDto;
import com.dtyunxi.tcbj.api.dto.request.OutResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.RecentDeliveredReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsOutResultOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryInformationRespDto;
import com.dtyunxi.tcbj.api.dto.response.IntransitCargoRespDto;
import com.dtyunxi.tcbj.api.dto.response.OutResultOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.RecentDeliveredRespDto;
import com.dtyunxi.tcbj.biz.service.IOutResultOrderService;
import com.dtyunxi.tcbj.dao.das.ConsignmentOrderDas;
import com.dtyunxi.tcbj.dao.das.ConsignmentOrderDeliveryInfoDas;
import com.dtyunxi.tcbj.dao.das.ItemsDas;
import com.dtyunxi.tcbj.dao.das.OutResultOrderDas;
import com.dtyunxi.tcbj.dao.das.OutResultOrderDetailDas;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderDeliveryInfoEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderDetailEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderEo;
import com.dtyunxi.tcbj.dao.mapper.LogicWarehouseMapper;
import com.dtyunxi.tcbj.dao.mapper.OutResultOrderDetailMapper;
import com.dtyunxi.tcbj.dao.mapper.OutResultOrderMapper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutResultOrderServiceImpl
implements IOutResultOrderService {
    private static final Logger log = LoggerFactory.getLogger(OutResultOrderServiceImpl.class);
    @Resource
    private OutResultOrderDas outResultOrderDas;
    @Resource
    private OutResultOrderMapper outResultOrderMapper;
    @Resource
    private OutResultOrderDetailMapper outResultOrderDetailMapper;
    @Resource
    private ConsignmentOrderDas consignmentOrderDas;
    @Resource
    private ConsignmentOrderDeliveryInfoDas consignmentOrderDeliveryInfoDas;
    @Resource
    private OutResultOrderDetailDas outResultOrderDetailDas;
    @Resource
    private ItemsDas itemsDas;
    @Autowired
    IPcpDictApi pcpDictApi;
    @Autowired
    LogicWarehouseMapper logicWarehouseMapper;

    @Override
    public Long addOutResultOrder(OutResultOrderReqDto addReqDto) {
        OutResultOrderEo outResultOrderEo = new OutResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)outResultOrderEo);
        this.outResultOrderDas.insert((BaseEo)outResultOrderEo);
        return outResultOrderEo.getId();
    }

    @Override
    public void modifyOutResultOrder(OutResultOrderReqDto modifyReqDto) {
        OutResultOrderEo outResultOrderEo = new OutResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)outResultOrderEo);
        this.outResultOrderDas.updateSelective((BaseEo)outResultOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOutResultOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.outResultOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OutResultOrderRespDto queryById(Long id) {
        OutResultOrderEo outResultOrderEo = (OutResultOrderEo)this.outResultOrderDas.selectByPrimaryKey(id);
        OutResultOrderRespDto outResultOrderRespDto = new OutResultOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)outResultOrderEo, (BaseVo)outResultOrderRespDto);
        return outResultOrderRespDto;
    }

    @Override
    public PageInfo<OutResultOrderRespDto> queryByPage(OutResultOrderReqDto filter) {
        Page outResultOrderRespVos = this.outResultOrderDas.queryByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)outResultOrderRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List outResultOrderRespVoList = outResultOrderRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)outResultOrderRespVoList)) {
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)outResultOrderRespVoList, OutResultOrderRespDto.class);
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }

    @Override
    public PageInfo<OutResultOrderRespDto> queryByPageInResult(OutResultOrderReqDto filter) {
        Page outResultOrderRespVos = this.outResultOrderDas.queryByPageInResult(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)outResultOrderRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List outResultOrderRespVoList = outResultOrderRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)outResultOrderRespVoList)) {
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)outResultOrderRespVoList, OutResultOrderRespDto.class);
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }

    @Override
    public List<OutResultOrderRespDto> queryByWarehouse(List<String> warehouseCodes, Date detailDate) {
        Assert.notNull(warehouseCodes, (String)"0001", (String)"\u6307\u5b9a\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)detailDate, (String)"0001", (String)"\u6307\u5b9a\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        OutResultOrderEo outResultOrderEo = new OutResultOrderEo();
        outResultOrderEo.setWarehouseClassify(WarehouseTypeEnum.LOGIC.getKey());
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"warehouse_code", warehouseCodes));
        sqlFilters.add(SqlFilter.lt((String)"create_time", (Object)detailDate));
        sqlFilters.add(SqlFilter.gt((String)"create_time", (Object)DateUtil.offsetDay((Date)detailDate, (int)-1)));
        List collect = this.outResultOrderDas.select((BaseEo)outResultOrderEo);
        if (CollectionUtils.isNotEmpty((Collection)collect)) {
            ArrayList outResultOrderRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)collect, (Collection)outResultOrderRespDtos, OutResultOrderRespDto.class);
            List documentNos = collect.stream().map(c -> c.getDocumentNo()).collect(Collectors.toList());
            OutResultOrderDetailEo outResultOrderDetailEo = new OutResultOrderDetailEo();
            outResultOrderDetailEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"document_no", documentNos)}));
            List outResultOrderDetailEos = this.outResultOrderDetailDas.select((BaseEo)outResultOrderDetailEo);
            Assert.notNull((Object)outResultOrderDetailEos, (String)"0001", (String)"\u51fa\u5e93\u5355\u660e\u7ec6\u5b58\u5728\u5f02\u5e38");
            ArrayList outResultOrderDetailRespDtoList = Lists.newArrayList();
            for (OutResultOrderDetailEo resultOrderDetailEo : outResultOrderDetailEos) {
                CsOutResultOrderDetailRespDto respDto = new CsOutResultOrderDetailRespDto();
                BeanUtil.copyProperties((Object)resultOrderDetailEo, (Object)respDto, (String[])new String[0]);
                respDto.setLongCode(resultOrderDetailEo.getSkuCode());
                respDto.setCargoName(resultOrderDetailEo.getSkuName());
                outResultOrderDetailRespDtoList.add(respDto);
            }
            Map<String, List<CsOutResultOrderDetailRespDto>> mapGroupByDocumentNo = outResultOrderDetailRespDtoList.stream().collect(Collectors.groupingBy(CsOutResultOrderDetailRespDto::getDocumentNo));
            outResultOrderRespDtos.forEach(c -> {
                List orDefault = mapGroupByDocumentNo.getOrDefault(c.getDocumentNo(), null);
                Assert.notNull((Object)orDefault, (String)"0001", (String)(c.getDocumentNo() + "\u5165\u5e93\u5355\u660e\u7ec6\u5b58\u5728\u5f02\u5e38"));
                c.setDetailRespDtos(orDefault);
            });
            return outResultOrderRespDtos;
        }
        return null;
    }

    @Override
    public PageInfo<OutResultOrderEo> queryDataByPage(OutResultOrderReqDto filter) {
        PageHelper.startPage((int)filter.getPageNum(), (int)filter.getPageSize());
        PageInfo pageInfo = new PageInfo(this.outResultOrderDas.queryDataByPage(filter));
        return pageInfo;
    }

    @Override
    public Integer queryDataCount(OutResultOrderReqDto filter) {
        return this.outResultOrderDas.queryDataCount(filter);
    }

    @Override
    public PageInfo<RecentDeliveredRespDto> queryRecentDelivered(RecentDeliveredReqDto reqDto) {
        List outResultOrderEosList = this.outResultOrderDas.queryRecentDelivered(reqDto);
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(outResultOrderEosList);
        return pageInfo;
    }

    @Override
    public OutResultOrderRespDto queryByConsignNo(String consignNo, String cspNo) {
        return Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.outResultOrderDas.filter().eq((Object)"consignment_no", (Object)consignNo)).eq((Object)"external_order_no", (Object)cspNo)).list()).filter(CollectionUtils::isNotEmpty).map(l -> (OutResultOrderEo)l.get(0)).map(outResultOrderEo -> {
            OutResultOrderRespDto outResultOrderRespDto = (OutResultOrderRespDto)BeanUtil.copyProperties((Object)outResultOrderEo, OutResultOrderRespDto.class, (String[])new String[0]);
            outResultOrderRespDto.setDetailRespDtos(((ExtQueryChainWrapper)this.outResultOrderDetailDas.filter().eq((Object)"document_no", (Object)outResultOrderEo.getDocumentNo())).list().stream().map(r -> {
                CsOutResultOrderDetailRespDto csOutResultOrderDetailRespDto = new CsOutResultOrderDetailRespDto();
                BeanUtil.copyProperties((Object)r, (Object)csOutResultOrderDetailRespDto, (String[])new String[0]);
                csOutResultOrderDetailRespDto.setLongCode(r.getSkuCode());
                csOutResultOrderDetailRespDto.setCargoName(r.getSkuName());
                Map itemMap = this.itemsDas.queryItemByCode(r.getSkuCode());
                if (itemMap != null) {
                    csOutResultOrderDetailRespDto.setUnit((String)itemMap.get("specification"));
                    csOutResultOrderDetailRespDto.setBarCode((String)itemMap.get("bar_code"));
                }
                return csOutResultOrderDetailRespDto;
            }).collect(Collectors.toList()));
            return outResultOrderRespDto;
        }).orElse(null);
    }

    @Override
    public List<CsOutResultOrderDetailRespDto> queryCsOutResultByConsignNos(String consignNo, String cspNo) {
        ArrayList detailRespDtos = Lists.newArrayList();
        List resultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.outResultOrderDas.filter().eq((Object)"consignment_no", (Object)consignNo)).eq((Object)"external_order_no", (Object)cspNo)).ne((Object)"relevance_table_name", (Object)"cs_transfer_order")).list();
        if (CollectionUtils.isEmpty((Collection)resultOrderEoList)) {
            return detailRespDtos;
        }
        List documentNoList = resultOrderEoList.stream().map(OutResultOrderEo::getDocumentNo).collect(Collectors.toList());
        List detailEoList = ((ExtQueryChainWrapper)this.outResultOrderDetailDas.filter().in((Object)"document_no", documentNoList)).list();
        Map<String, List<OutResultOrderDetailEo>> orderDetailEoMap = detailEoList.stream().collect(Collectors.groupingBy(OutResultOrderDetailEo::getDocumentNo));
        resultOrderEoList.forEach(n -> {
            ArrayList csOutResultOrderDetailRespDtoList = Lists.newArrayList();
            List outResultOrderDetailEos = (List)orderDetailEoMap.get(n.getDocumentNo());
            if (CollectionUtils.isNotEmpty((Collection)outResultOrderDetailEos)) {
                for (OutResultOrderDetailEo outResultOrderDetailEo : outResultOrderDetailEos) {
                    CsOutResultOrderDetailRespDto detailRespDto = new CsOutResultOrderDetailRespDto();
                    BeanUtil.copyProperties((Object)outResultOrderDetailEo, (Object)detailRespDto, (String[])new String[0]);
                    detailRespDto.setLongCode(outResultOrderDetailEo.getSkuCode());
                    detailRespDto.setCargoName(outResultOrderDetailEo.getSkuName());
                    csOutResultOrderDetailRespDtoList.add(detailRespDto);
                }
            }
            detailRespDtos.addAll(csOutResultOrderDetailRespDtoList);
        });
        if (CollectionUtils.isNotEmpty((Collection)detailRespDtos)) {
            detailRespDtos.forEach(m -> {
                Map itemMap = this.itemsDas.queryItemByCode(m.getLongCode());
                if (itemMap != null) {
                    m.setUnit((String)itemMap.get("specification"));
                    m.setBarCode((String)itemMap.get("bar_code"));
                }
            });
        }
        return detailRespDtos;
    }

    @Override
    public List<DeliveryInformationRespDto> queryDeliveryInformation(String bussinessOrderNo) {
        List respDtos = this.consignmentOrderDas.queryDeliveryInformation(bussinessOrderNo);
        for (DeliveryInformationRespDto respDto : respDtos) {
            ConsignmentOrderDeliveryInfoEo deliveryInfoEo;
            List list;
            if (!StringUtils.isNotBlank((CharSequence)respDto.getTransferConsignmentNo()) || !CollectionUtils.isNotEmpty((Collection)(list = ((ExtQueryChainWrapper)this.consignmentOrderDeliveryInfoDas.filter().eq((Object)"consignment_no", (Object)respDto.getTransferConsignmentNo())).list())) || (deliveryInfoEo = (ConsignmentOrderDeliveryInfoEo)list.get(0)).getActualArriveTime() == null) continue;
            respDto.setBusinessActualArriveTime(deliveryInfoEo.getActualArriveTime());
        }
        return respDtos;
    }

    @Override
    public PageInfo<OutResultOrderRespDto> queryAnomalyPage(OutResultOrderReqDto outResultOrderReqDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(OutResultOrderEo::getOrderStatus, new Object[]{BaseOrderStatusEnum.ORO_HANG_UP.getCode(), BaseOrderStatusEnum.IRO_HANG_UP.getCode()})).eq(StringUtils.isNotBlank((CharSequence)outResultOrderReqDto.getBusinessType()), OutResultOrderEo::getBusinessType, (Object)outResultOrderReqDto.getBusinessType())).and(StringUtils.isNotBlank((CharSequence)outResultOrderReqDto.getDocumentNo()), qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.like(OutResultOrderEo::getDocumentNo, (Object)outResultOrderReqDto.getDocumentNo())).or()).like(OutResultOrderEo::getRelevanceNo, (Object)outResultOrderReqDto.getDocumentNo());
        })).orderByDesc(OutResultOrderEo::getOverChargeTime);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)outResultOrderReqDto.getPageNum().intValue(), (long)outResultOrderReqDto.getPageSize().intValue());
        com.baomidou.mybatisplus.extension.plugins.pagination.Page outResultOrderEoPage = (com.baomidou.mybatisplus.extension.plugins.pagination.Page)this.outResultOrderDas.getMapper().selectPage((IPage)page, (Wrapper)queryWrapper);
        PageInfo pageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)outResultOrderEoPage, (Object)pageInfo, (String[])new String[0]);
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)outResultOrderEoPage.getRecords())) {
            for (OutResultOrderEo record : outResultOrderEoPage.getRecords()) {
                OutResultOrderRespDto respDto = new OutResultOrderRespDto();
                BeanUtil.copyProperties((Object)record, (Object)respDto, (String[])new String[0]);
                list.add(respDto);
            }
        }
        pageInfo.setList((List)list);
        return pageInfo;
    }

    @Override
    public PageInfo<OutResultOrderEo> queryConsignmentList(OutResultOrderReqDto filter) {
        log.info("\u51fa\u5e93\u7ed3\u679c\u6258\u8fd0\u4fe1\u606fqueryConsignmentList\uff1a{}", (Object)JSON.toJSONString((Object)filter));
        PageHelper.startPage((int)filter.getPageNum(), (int)filter.getPageSize());
        return new PageInfo(this.outResultOrderDas.queryConsignmentList(filter));
    }

    @Override
    public List<IntransitCargoRespDto> queryIntransitCargoNum(IntransitCargoQueryDto queryDto) {
        DictDto switchDictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "IN_TRANSIT_INVENTORY_SWITCH"));
        log.info("queryIntransitCargoNum switchDictDto: {}", (Object)LogUtils.buildLogContent((Object)switchDictDto));
        if (null == switchDictDto || null == switchDictDto.getValue() || YesNoHelper.isNo((Integer)Integer.valueOf(switchDictDto.getValue()))) {
            return Lists.newArrayList();
        }
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "INVENTORY_AVAILABLE_IN_TRANSIT_DAY"));
        if (null == dictDto) {
            throw new BizException("\u5728\u9014\u914d\u7f6e\u5929\u6570\u67e5\u8be2\u4e0d\u5b58\u5728");
        }
        String jsonConfigStr = dictDto.getValue();
        if (StringUtils.isBlank((CharSequence)jsonConfigStr)) {
            throw new BizException("\u5728\u9014\u914d\u7f6e\u5929\u6570\u67e5\u8be2\u6ca1\u6709\u6709\u6548\u503c");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)jsonConfigStr);
        queryDto.setConfigStatus(jsonObject.getInteger("status"));
        if (null == queryDto.getConfigDay()) {
            Integer configDay = jsonObject.getInteger("day");
            queryDto.setConfigDay(configDay);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getIntransitWarehouseCodes())) {
            List intransitWarehouseEos = this.logicWarehouseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getWarehouseCode, (Collection)queryDto.getIntransitWarehouseCodes())).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (CollectionUtils.isEmpty((Collection)intransitWarehouseEos)) {
                throw new BizException("\u5728\u9014\u4ed3\u7f16\u7801\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u5728\u9014\u4ed3");
            }
            List logicWarehouseIds = intransitWarehouseEos.stream().map(LogicWarehouseEo::getSubordinateLogicWarehouseId).distinct().collect(Collectors.toList());
            List logicWarehouseEos = this.logicWarehouseMapper.selectBatchIds(logicWarehouseIds);
            if (CollectionUtils.isEmpty((Collection)logicWarehouseEos)) {
                throw new BizException("\u5728\u9014\u4ed3\u7f16\u7801\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u903b\u8f91\u4ed3");
            }
            List logicWarehouseCodes = logicWarehouseEos.stream().map(LogicWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
            queryDto.setLogicWarehouseCodes(logicWarehouseCodes);
        }
        return this.outResultOrderDas.queryIntransitCargoNum(queryDto);
    }
}

