/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeApportionDetailRespDto;
import com.dtyunxi.tcbj.biz.service.IStorageChargeApportionDetailService;
import com.dtyunxi.tcbj.dao.das.StorageChargeApportionDetailDas;
import com.dtyunxi.tcbj.dao.eo.StorageChargeApportionDetailEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class StorageChargeApportionDetailServiceImpl
implements IStorageChargeApportionDetailService {
    @Resource
    private StorageChargeApportionDetailDas storageChargeApportionDetailDas;

    @Override
    public Long addStorageChargeApportionDetail(StorageChargeApportionDetailReqDto addReqDto) {
        StorageChargeApportionDetailEo storageChargeApportionDetailEo = new StorageChargeApportionDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storageChargeApportionDetailEo);
        this.storageChargeApportionDetailDas.insert((BaseEo)storageChargeApportionDetailEo);
        return storageChargeApportionDetailEo.getId();
    }

    @Override
    public void modifyStorageChargeApportionDetail(StorageChargeApportionDetailReqDto modifyReqDto) {
        StorageChargeApportionDetailEo storageChargeApportionDetailEo = new StorageChargeApportionDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storageChargeApportionDetailEo);
        this.storageChargeApportionDetailDas.updateSelective((BaseEo)storageChargeApportionDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStorageChargeApportionDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storageChargeApportionDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StorageChargeApportionDetailRespDto queryById(Long id) {
        StorageChargeApportionDetailEo storageChargeApportionDetailEo = (StorageChargeApportionDetailEo)this.storageChargeApportionDetailDas.selectByPrimaryKey(id);
        StorageChargeApportionDetailRespDto storageChargeApportionDetailRespDto = new StorageChargeApportionDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)storageChargeApportionDetailEo, (BaseVo)storageChargeApportionDetailRespDto);
        return storageChargeApportionDetailRespDto;
    }

    @Override
    public PageInfo<StorageChargeApportionDetailRespDto> queryByPage(StorageChargeApportionDetailReqDto storageChargeApportionDetailReqDto) {
        if (storageChargeApportionDetailReqDto.getPageSize() == null) {
            storageChargeApportionDetailReqDto.setPageSize(Integer.valueOf(10000));
        }
        StorageChargeApportionDetailEo storageChargeApportionDetailEo = new StorageChargeApportionDetailEo();
        ArrayList sqlFilters = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)storageChargeApportionDetailReqDto.getStartRecordMonth())) {
            sqlFilters.add(SqlFilter.ge((String)"record_month", (Object)storageChargeApportionDetailReqDto.getStartRecordMonth()));
        }
        if (!ObjectUtils.isEmpty((Object)storageChargeApportionDetailReqDto.getEndRecordMonth())) {
            sqlFilters.add(SqlFilter.le((String)"record_month", (Object)storageChargeApportionDetailReqDto.getEndRecordMonth()));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionDetailReqDto.getOpLongCode())) {
            sqlFilters.add(SqlFilter.like((String)"op_long_code", (Object)("%" + storageChargeApportionDetailReqDto.getOpLongCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionDetailReqDto.getWarehouseName())) {
            sqlFilters.add(SqlFilter.like((String)"warehouse_name", (Object)("%" + storageChargeApportionDetailReqDto.getWarehouseName() + "%")));
        }
        if (CollectionUtil.isNotEmpty((Collection)storageChargeApportionDetailReqDto.getWarehouseCodeList())) {
            sqlFilters.add(SqlFilter.in((String)"warehouse_code", (Object)storageChargeApportionDetailReqDto.getWarehouseCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionDetailReqDto.getOpLongCode())) {
            sqlFilters.add(SqlFilter.like((String)"op_long_code", (Object)("%" + storageChargeApportionDetailReqDto.getOpLongCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionDetailReqDto.getItemName())) {
            sqlFilters.add(SqlFilter.like((String)"item_name", (Object)("%" + storageChargeApportionDetailReqDto.getItemName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionDetailReqDto.getBatch())) {
            sqlFilters.add(SqlFilter.like((String)"batch", (Object)("%" + storageChargeApportionDetailReqDto.getBatch() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionDetailReqDto.getApportionLogicWarehouseName())) {
            sqlFilters.add(SqlFilter.like((String)"apportion_logic_warehouse_name", (Object)("%" + storageChargeApportionDetailReqDto.getApportionLogicWarehouseName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionDetailReqDto.getBelongOrgName())) {
            sqlFilters.add(SqlFilter.like((String)"belong_org_name", (Object)("%" + storageChargeApportionDetailReqDto.getBelongOrgName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionDetailReqDto.getApportionOrgName())) {
            sqlFilters.add(SqlFilter.like((String)"apportion_org_name", (Object)("%" + storageChargeApportionDetailReqDto.getApportionOrgName() + "%")));
        }
        storageChargeApportionDetailEo.setOrderByDesc("create_time");
        storageChargeApportionDetailEo.setSqlFilters((List)sqlFilters);
        PageInfo eoPageInfo = this.storageChargeApportionDetailDas.selectPage((BaseEo)storageChargeApportionDetailEo, storageChargeApportionDetailReqDto.getPageNum(), storageChargeApportionDetailReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StorageChargeApportionDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<StorageChargeApportionDetailEo> getStorageChargeApportionDetailByBillTime(Date detailDate) {
        StorageChargeApportionDetailEo storageChargeApportionDetailEo = new StorageChargeApportionDetailEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.eq((String)"bill_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)detailDate)));
        storageChargeApportionDetailEo.setSqlFilters((List)sqlFilters);
        List apportionDetailEos = this.storageChargeApportionDetailDas.select((BaseEo)storageChargeApportionDetailEo);
        return apportionDetailEos;
    }

    @Override
    public List<StorageChargeApportionDetailEo> getStorageChargeApportionDetailByBillTime(Date startDate, Date endDate) {
        Assert.notNull((Object)startDate, (String)"0001", (String)"\u67e5\u8be2\u4ed3\u50a8\u5206\u644a\u660e\u7ec6\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff01\uff01\uff01");
        Assert.notNull((Object)endDate, (String)"0001", (String)"\u67e5\u8be2\u4ed3\u50a8\u5206\u644a\u660e\u7ec6\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\uff01\uff01\uff01");
        StorageChargeApportionDetailEo storageChargeApportionDetailEo = new StorageChargeApportionDetailEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.ge((String)"bill_time", (Object)startDate));
        sqlFilters.add(SqlFilter.lt((String)"bill_time", (Object)endDate));
        storageChargeApportionDetailEo.setSqlFilters((List)sqlFilters);
        List apportionDetailEos = this.storageChargeApportionDetailDas.select((BaseEo)storageChargeApportionDetailEo);
        return apportionDetailEos;
    }
}

