/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionTradeTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.CalculateStorageStatusEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.CsWarehouseTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.DeliveryResultOrderTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.IsExceptionStorageBill;
import com.dtyunxi.tcbj.api.dto.constant.enums.IsVerifyApportionEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.OperationStorageEnum;
import com.dtyunxi.tcbj.api.dto.request.AdjustStorageApportionDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.BizImportDataReqDto;
import com.dtyunxi.tcbj.api.dto.request.DeliveryResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.EsInventoryOperateLogListPageParams;
import com.dtyunxi.tcbj.api.dto.response.BizImportRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryResultOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryResultOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeApportionRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.EsInventoryOperateLogVO;
import com.dtyunxi.tcbj.api.dto.storageCharge.SyncApportionDataDto;
import com.dtyunxi.tcbj.api.vo.ImportStorageChargeDetailChangeVo;
import com.dtyunxi.tcbj.api.vo.LogicWarehouseReceiveRecordVo;
import com.dtyunxi.tcbj.biz.dto.SyncStorageDetailAndBillVo;
import com.dtyunxi.tcbj.biz.service.IDeliveryResultOrderService;
import com.dtyunxi.tcbj.biz.service.IStorageChargeApportionService;
import com.dtyunxi.tcbj.biz.service.IStorageChargeBillService;
import com.dtyunxi.tcbj.biz.service.IStorageChargeDetailService;
import com.dtyunxi.tcbj.biz.service.ITransferOrderService;
import com.dtyunxi.tcbj.biz.service.es.CsInventoryEsService;
import com.dtyunxi.tcbj.biz.service.impl.StorageChargeHelper;
import com.dtyunxi.tcbj.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.dao.das.FinStorageContractDas;
import com.dtyunxi.tcbj.dao.das.LogicInventorySnapDas;
import com.dtyunxi.tcbj.dao.das.StorageChargeDetailDas;
import com.dtyunxi.tcbj.dao.eo.FinStorageContractEo;
import com.dtyunxi.tcbj.dao.eo.LogicInventorySnapEo;
import com.dtyunxi.tcbj.dao.eo.StorageChargeBillEo;
import com.dtyunxi.tcbj.dao.eo.StorageChargeDetailEo;
import com.dtyunxi.tcbj.dao.mapper.LogicInventorySnapMapper;
import com.dtyunxi.tcbj.dao.mapper.StorageChargeApportionMapper;
import com.dtyunxi.tcbj.dao.mapper.StorageChargeDetailMapper;
import com.dtyunxi.tcbj.dao.vo.LogicInventorySnapVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageChargeDetailServiceImpl
implements IStorageChargeDetailService {
    private static final Logger log = LoggerFactory.getLogger(StorageChargeDetailServiceImpl.class);
    private final Logger LOGGER = LoggerFactory.getLogger(StorageChargeDetailServiceImpl.class);
    @Resource
    private StorageChargeDetailDas storageChargeDetailDas;
    @Resource
    private StorageChargeDetailMapper storageChargeDetailMapper;
    @Resource
    private IDeliveryResultOrderService deliveryResultOrderService;
    @Resource
    private IStorageChargeDetailService storageChargeDetailService;
    @Resource
    private IStorageChargeBillService storageChargeBillService;
    @Resource
    private StorageChargeHelper storageChargeHelper;
    @Resource
    private ITransferOrderService transferOrderService;
    @Resource
    private IStorageChargeApportionService storageChargeApportionService;
    @Resource
    private StorageChargeApportionMapper storageChargeApportionMapper;
    @Resource
    private CsInventoryEsService csInventoryEsService;
    @Resource
    private FinStorageContractDas finStorageContractDas;
    @Resource
    private LogicInventorySnapMapper logicInventorySnapMapper;
    @Resource
    private LogicInventorySnapDas logicInventorySnapDas;

    @Override
    public Long addStorageChargeDetail(StorageChargeDetailReqDto addReqDto) {
        StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storageChargeDetailEo);
        this.storageChargeDetailDas.insert((BaseEo)storageChargeDetailEo);
        return storageChargeDetailEo.getId();
    }

    @Override
    public void modifyStorageChargeDetail(StorageChargeDetailReqDto modifyReqDto) {
        StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storageChargeDetailEo);
        this.storageChargeDetailDas.updateSelective((BaseEo)storageChargeDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStorageChargeDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storageChargeDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StorageChargeDetailRespDto queryById(Long id) {
        StorageChargeDetailEo storageChargeDetailEo = (StorageChargeDetailEo)this.storageChargeDetailDas.selectByPrimaryKey(id);
        StorageChargeDetailRespDto storageChargeDetailRespDto = new StorageChargeDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)storageChargeDetailEo, (BaseVo)storageChargeDetailRespDto);
        return storageChargeDetailRespDto;
    }

    @Override
    public PageInfo<StorageChargeDetailRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StorageChargeDetailReqDto storageChargeDetailReqDto = (StorageChargeDetailReqDto)JSON.parseObject((String)filter, StorageChargeDetailReqDto.class);
        storageChargeDetailReqDto.setPageSize(pageSize);
        storageChargeDetailReqDto.setPageNum(pageNum);
        PageInfo dtoPageInfo = this.storageChargeDetailDas.queryByPage(storageChargeDetailReqDto);
        return dtoPageInfo;
    }

    private void extracted(StorageChargeDetailReqDto storageChargeDetailReqDto, StorageChargeDetailEo storageChargeDetailEo) {
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.gt((String)"end_inventory_num", (Object)0));
        if (!ObjectUtils.isEmpty((Object)storageChargeDetailReqDto.getStorageStartTime())) {
            sqlFilters.add(SqlFilter.ge((String)"storage_time", (Object)storageChargeDetailReqDto.getStorageStartTime()));
        }
        if (!ObjectUtils.isEmpty((Object)storageChargeDetailReqDto.getStorageEndTime())) {
            sqlFilters.add(SqlFilter.le((String)"storage_time", (Object)storageChargeDetailReqDto.getStorageEndTime()));
        }
        if (!ObjectUtils.isEmpty((Object)storageChargeDetailReqDto.getBillTime())) {
            Date billTime = DateUtil.parseDate((String)storageChargeDetailReqDto.getBillTime(), (String)"yyyy-MM");
            sqlFilters.add(SqlFilter.ge((String)"bill_time", (Object)billTime));
            sqlFilters.add(SqlFilter.lt((String)"bill_time", (Object)cn.hutool.core.date.DateUtil.offsetMonth((Date)billTime, (int)1)));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeDetailReqDto.getWarehouseName())) {
            sqlFilters.add(SqlFilter.like((String)"warehouse_name", (Object)("%" + storageChargeDetailReqDto.getWarehouseName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeDetailReqDto.getWarehouseCode())) {
            sqlFilters.add(SqlFilter.like((String)"warehouse_code", (Object)storageChargeDetailReqDto.getWarehouseCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeDetailReqDto.getOpLongCode())) {
            sqlFilters.add(SqlFilter.like((String)"op_long_code", (Object)("%" + storageChargeDetailReqDto.getOpLongCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeDetailReqDto.getItemName())) {
            sqlFilters.add(SqlFilter.like((String)"item_name", (Object)("%" + storageChargeDetailReqDto.getItemName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeDetailReqDto.getBatch())) {
            sqlFilters.add(SqlFilter.like((String)"batch", (Object)("%" + storageChargeDetailReqDto.getBatch() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeDetailReqDto.getLogicWarehouseCode())) {
            sqlFilters.add(SqlFilter.like((String)"logic_warehouse_code", (Object)("%" + storageChargeDetailReqDto.getLogicWarehouseCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeDetailReqDto.getLogicWarehouseName())) {
            sqlFilters.add(SqlFilter.like((String)"logic_warehouse_name", (Object)("%" + storageChargeDetailReqDto.getLogicWarehouseName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeDetailReqDto.getChargeOrgName())) {
            sqlFilters.add(SqlFilter.like((String)"charge_org_name", (Object)("%" + storageChargeDetailReqDto.getChargeOrgName() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)storageChargeDetailReqDto.getChargeOrgId())) {
            sqlFilters.add(SqlFilter.like((String)"charge_org_id", (Object)("%" + storageChargeDetailReqDto.getChargeOrgId() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)storageChargeDetailReqDto.getBelongOrgId())) {
            sqlFilters.add(SqlFilter.like((String)"belong_org_id", (Object)("%" + storageChargeDetailReqDto.getBelongOrgId() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)storageChargeDetailReqDto.getBelongOrgName())) {
            sqlFilters.add(SqlFilter.like((String)"belong_org_name", (Object)("%" + storageChargeDetailReqDto.getBelongOrgName() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)storageChargeDetailReqDto.getBizType())) {
            sqlFilters.add(SqlFilter.eq((String)"biz_type", (Object)storageChargeDetailReqDto.getBizType()));
        }
        if (ObjectUtils.isNotEmpty((Object)storageChargeDetailReqDto.getIsException())) {
            IsExceptionStorageBill isExceptionStorageBill = IsExceptionStorageBill.keyOfEnum((Integer)storageChargeDetailReqDto.getIsException());
            Assert.notNull((Object)isExceptionStorageBill, (String)"0001", (String)"\u662f\u5426\u5f02\u5e38\u5b58\u5728\u53c2\u6570\u5f02\u5e38\uff01\uff01\uff01");
            if (IsExceptionStorageBill.IS_EXCEPTION.equals((Object)isExceptionStorageBill)) {
                sqlFilters.add(SqlFilter.ne((String)"exception_info", (Object)"[]"));
            } else {
                sqlFilters.add(SqlFilter.eq((String)"exception_info", (Object)"[]"));
            }
        }
        storageChargeDetailEo.setOrderByDesc("storage_time");
        storageChargeDetailEo.setSqlFilters((List)sqlFilters);
    }

    @Override
    public void syncStorageChargeDetail(SyncStorageDetailAndBillVo detailAndBillVo) {
        this.LOGGER.info("\u4ed3\u50a8\u660e\u7ec6\u5e38\u89c4\u8ba1\u8d39\u751f\u6210\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)detailAndBillVo)));
        Date detailDate = detailAndBillVo.getStorageTime();
        SyncApportionDataDto syncApportionDataDto = this.buildSyncApportionDataDto(detailAndBillVo);
        List storageChargeDetailEos = this.storageChargeDetailMapper.sycStorageChargeDetail(syncApportionDataDto);
        if (CollectionUtils.isEmpty((Collection)storageChargeDetailEos)) {
            this.LOGGER.info("\u65e0\u9700\u8981\u751f\u6210\u7684\u6570\u636e");
            return;
        }
        this.LOGGER.info("\u4ed3\u50a8\u660e\u7ec6\u5e38\u89c4\u8ba1\u8d39\u751f\u6210\u7edf\u8ba1\u660e\u7ec6\u65f6\u95f4\uff1a{},\u6761\u6570\uff1a{}", (Object)cn.hutool.core.date.DateUtil.format((Date)detailDate, (String)"yyyy-MM-dd HH:mm:ss"), (Object)storageChargeDetailEos.size());
        List<StorageChargeDetailEo> isNotApportion = this.calculateDelivery(detailDate, storageChargeDetailEos, chargeDetailEos -> {
            DateTime dateTime = cn.hutool.core.date.DateUtil.offsetDay((Date)detailDate, (int)-1);
            Date billTime = DateUtil.getMonthBegin((Date)dateTime);
            chargeDetailEos.forEach(defaultInfo -> {
                defaultInfo.setStorageTime((Date)dateTime);
                defaultInfo.setBillTime(billTime);
                defaultInfo.setBizType(ApportionTradeTypeEnum.NORMAL_TRADE.getKey());
                defaultInfo.setCalculateStatus(CalculateStorageStatusEnum.DONE.getKey());
            });
            return this.calculateAndSetDefault((List<StorageChargeDetailEo>)chargeDetailEos);
        });
        this.storageChargeDetailService.insertBatch(isNotApportion);
    }

    private SyncApportionDataDto buildSyncApportionDataDto(SyncStorageDetailAndBillVo detailVo) {
        List contractEos;
        Date detailDate = detailVo.getStorageTime();
        SyncApportionDataDto syncApportionDataDto = new SyncApportionDataDto((List)Lists.newArrayList((Object[])this.storageChargeHelper.getPropertyRightOrganizationIds().split(",")), (List)Lists.newArrayList((Object[])this.storageChargeHelper.getPhysicsWarehouseCodes().split(",")), (List)Lists.newArrayList((Object[])new String[]{CsLogicWarehouseQualityEnum.QUALIFIED.getCode(), CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode(), CsLogicWarehouseQualityEnum.PENDING.getCode()}), (List)Lists.newArrayList((Object[])new String[]{CsWarehouseClassifyEnum.IN_TRANSIT.getCode()}), (List)Lists.newArrayList((Object[])new String[]{CsWarehouseTypeEnum.TCBJ_C.getCode()}), (Date)cn.hutool.core.date.DateUtil.offsetDay((Date)detailDate, (int)-1));
        if (CollectionUtil.isNotEmpty(detailVo.getLogicWarehouseCodes())) {
            syncApportionDataDto.setLogicWarehouseList(detailVo.getLogicWarehouseCodes());
        }
        if (CollectionUtil.isNotEmpty(detailVo.getOpLongCodes())) {
            syncApportionDataDto.setItemCodes(detailVo.getOpLongCodes());
        }
        if (CollectionUtil.isNotEmpty(detailVo.getBatchs())) {
            syncApportionDataDto.setBatchs(detailVo.getBatchs());
        }
        if (CollectionUtil.isNotEmpty((Collection)(contractEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finStorageContractDas.filter().eq((Object)"is_cancel", (Object)0)).ne((Object)"charge_mode", (Object)1)).last(String.format("and '%s' %s", cn.hutool.core.date.DateUtil.offsetDay((Date)detailDate, (int)-1), "BETWEEN  valid_start_time and valid_end_time"))).list()))) {
            List physicsWarehouseCodes = syncApportionDataDto.getPhysicsWarehouseCodes();
            physicsWarehouseCodes.addAll(contractEos.stream().map(FinStorageContractEo::getWarehouseCode).collect(Collectors.toSet()));
            syncApportionDataDto.setPhysicsWarehouseCodes(physicsWarehouseCodes);
        }
        return syncApportionDataDto;
    }

    @Override
    public void insertBatch(List<StorageChargeDetailEo> isApportion) {
        if (CollectionUtils.isNotEmpty(isApportion)) {
            int n = this.storageChargeDetailDas.insertBatch(isApportion);
        }
    }

    private List<StorageChargeDetailEo> calculateAndSetDefault(List<StorageChargeDetailEo> chargeDetailEos) {
        if (CollectionUtils.isEmpty(chargeDetailEos)) {
            return null;
        }
        Map<String, List<StorageChargeDetailEo>> mapGroupByWarehouseAndOpLongCode = chargeDetailEos.stream().collect(Collectors.groupingBy(detail -> detail.getStorageTime() + detail.getWarehouseCode() + detail.getOpLongCode() + detail.getBatch()));
        mapGroupByWarehouseAndOpLongCode.forEach((k, v) -> {
            int sum = v.stream().mapToInt(detail -> {
                Integer inventoryNum = StorageChargeHelper.getAllInventoryNum(detail.getAdjustType(), ObjectUtils.isEmpty((Object)detail.getInventoryNum()) || detail.getInventoryNum() == 0 ? detail.getEndInventoryNum() : detail.getInventoryNum(), detail.getAdjustDeliveryNum());
                detail.setInventoryNum(inventoryNum);
                return inventoryNum;
            }).sum();
            v.stream().forEach(storageChargeDetail -> this.calculateDetail((List<StorageChargeDetailEo>)v, sum, (StorageChargeDetailEo)storageChargeDetail));
        });
        return mapGroupByWarehouseAndOpLongCode.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void calculateDetail(List<StorageChargeDetailEo> v, int sum, StorageChargeDetailEo storageChargeDetail) {
        int endInventoryNum = ObjectUtils.isEmpty((Object)storageChargeDetail.getEndInventoryNum()) ? 0 : storageChargeDetail.getEndInventoryNum();
        int outDeliveryNum = ObjectUtils.isEmpty((Object)storageChargeDetail.getOutDeliveryNum()) ? 0 : storageChargeDetail.getOutDeliveryNum();
        int inDeliveryNum = ObjectUtils.isEmpty((Object)storageChargeDetail.getInDeliveryNum()) ? 0 : storageChargeDetail.getInDeliveryNum();
        HashSet<String> exceptionInfoSet = StorageChargeHelper.verifyStorageDetailException(storageChargeDetail.getZhTrayNum(), storageChargeDetail.getVolume(), storageChargeDetail.getPackingQuantity());
        storageChargeDetail.setExceptionInfo(JSON.toJSONString(exceptionInfoSet));
        storageChargeDetail.setZhTrayNum(ObjectUtils.isEmpty((Object)storageChargeDetail.getZhTrayNum()) ? IsExceptionStorageBill.IS_EXCEPTION.getVal() : storageChargeDetail.getZhTrayNum());
        storageChargeDetail.setInitialInventoryNum(Integer.valueOf(endInventoryNum + outDeliveryNum - inDeliveryNum));
        storageChargeDetail.setAllOutVolume(StorageChargeHelper.calculateAllOutVolume(storageChargeDetail.getVolume(), outDeliveryNum));
        int support = StorageChargeHelper.getSupport(sum, storageChargeDetail.getPackingQuantity(), storageChargeDetail.getZhTrayNum());
        storageChargeDetail.setAllDaySupport(Integer.valueOf(support));
        BigDecimal organizationSupport = StorageChargeHelper.calculateOrgSupport(v.indexOf(storageChargeDetail), v.size(), v, new BigDecimal(endInventoryNum), new BigDecimal(sum), new BigDecimal(support));
        storageChargeDetail.setOrganizationSupport(organizationSupport);
    }

    @Override
    public BizImportRespDto importStorageChargeDetail(BizImportDataReqDto<ImportStorageChargeDetailChangeVo> importDto) {
        try {
            this.LOGGER.info("\u5bfc\u5165\u53d8\u66f4\u4ed3\u50a8\u660e\u7ec6 params :{}", (Object)JSON.toJSONString(importDto));
            List excelImportResult = importDto.getExcelImportResult();
            ArrayList apportionDetailEos = Lists.newArrayList();
            this.verifyImportData(excelImportResult, apportionDetailEos);
            List needDealData = excelImportResult.stream().filter(c -> StringUtils.isBlank((CharSequence)c.getResult())).collect(Collectors.toList());
            List exportData = excelImportResult.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getResult())).collect(Collectors.toList());
            Integer importFailTotal = exportData.size();
            Integer importSuccessTotal = needDealData.size();
            Integer total = excelImportResult.size();
            this.LOGGER.info("\u3010\u5bfc\u5165\u4ed3\u50a8\u660e\u7ec6\u3011\u603b\u5bfc\u5165\u6570\u636e{}\u6761\uff0c\u5408\u6cd5\u6570\u636e{}\u6761\uff0c\u4e0d\u5408\u6cd5\u6570\u636e{}\u6761", new Object[]{total, importSuccessTotal, importFailTotal});
            if (CollectionUtils.isNotEmpty(needDealData)) {
                Map<String, ImportStorageChargeDetailChangeVo> collect = needDealData.stream().collect(Collectors.toMap(k -> k.getStorageTime() + k.getLogicWarehouseCode() + k.getOpLongCode() + k.getBatch(), v -> v, (k1, k2) -> k2));
                List<StorageChargeDetailEo> storageChargeDetailEoList = this.calculateStorage(apportionDetailEos, collect, resultList -> {
                    this.storageChargeDetailService.updateStorageChargeDetailBatch((List<StorageChargeDetailEo>)resultList);
                    return resultList;
                });
                this.syncBill(storageChargeDetailEoList);
            }
            String url = "";
            if (!CollectionUtils.isEmpty(exportData)) {
                String excelName = "\u4ed3\u50a8\u660e\u7ec6\u5bfc\u5165\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                try {
                    url = EasyPoiExportUtil.getExportUrl(exportData, ImportStorageChargeDetailChangeVo.class, null, excelName, "xls");
                    this.LOGGER.info("\u3010\u5bfc\u5165\u4ed3\u50a8\u660e\u7ec6\u3011\u5931\u8d25\u6587\u4ef6url : {}", (Object)url);
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5bfc\u5165\u4ed3\u50a8\u660e\u7ec6-\u9519\u8bef:{}", (Object)e.toString());
                    e.printStackTrace();
                }
            }
            return new BizImportRespDto(total, importSuccessTotal, importFailTotal, url);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
    }

    private void syncBill(List<StorageChargeDetailEo> storageChargeDetailEoList) {
        if ("true".equals(this.storageChargeHelper.getSyncBillSwitch())) {
            Map<Date, List<StorageChargeDetailEo>> mapGroupByStorageTime = storageChargeDetailEoList.stream().collect(Collectors.groupingBy(c -> c.getBillTime()));
            mapGroupByStorageTime.forEach((k, v) -> {
                List<StorageChargeBillEo> storageChargeBillEoList = this.storageChargeBillService.queryStorageChargeBillByBillDate((Date)k);
                if (CollectionUtils.isNotEmpty(storageChargeBillEoList)) {
                    CompletableFuture.runAsync(() -> {
                        List<String> warehouseCodes = v.stream().map(c -> c.getWarehouseCode()).collect(Collectors.toList());
                        this.storageChargeBillService.syncStorageChargeBill((Date)k, warehouseCodes);
                    }, StorageChargeHelper.storageExecutor);
                }
            });
        }
    }

    @Override
    public void adjustStorageApportionDetail(AdjustStorageApportionDetailReqDto detailReqDto) {
        this.LOGGER.info("\u8c03\u6574\u4ed3\u50a8\u660e\u7ec6param : {}", (Object)JSON.toJSONString((Object)detailReqDto));
        Assert.notNull((Object)detailReqDto.getDetailId(), (String)"0001", (String)"\u4ed3\u50a8\u660e\u7ec6ID\u4e3a\u7a7a\uff01\uff01\uff01");
        Assert.notNull((Object)detailReqDto.getAdjustDeliveryNum(), (String)"0001", (String)"\u4ed3\u50a8\u660e\u7ec6\u8c03\u6574\u6570\u91cf\u5b58\u5728\u5f02\u5e38\uff01\uff01\uff01");
        OperationStorageEnum operationStorageEnum = OperationStorageEnum.keyOfEnum((Integer)detailReqDto.getAdjustType());
        Assert.notNull((Object)operationStorageEnum, (String)"0001", (String)"\u4ed3\u50a8\u660e\u7ec6\u8c03\u6574\u65b9\u5f0f\u5b58\u5728\u5f02\u5e38\uff01\uff01\uff01");
        StorageChargeDetailRespDto storageChargeDetailRespDto = this.queryById(detailReqDto.getDetailId());
        Assert.notNull((Object)storageChargeDetailRespDto, (String)"0001", (String)"\u5f53\u524d\u8c03\u6574\u4ed3\u50a8\u660e\u7ec6\u4e0d\u5b58\u5728\uff01\uff01\uff01");
        storageChargeDetailRespDto.setAdjustType(operationStorageEnum.getKey());
        storageChargeDetailRespDto.setAdjustDeliveryNum(detailReqDto.getAdjustDeliveryNum());
        storageChargeDetailRespDto.setRemark(StringUtils.defaultString((String)detailReqDto.getRemark(), (String)""));
        StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo();
        CubeBeanUtils.copyProperties((Object)storageChargeDetailEo, (Object)storageChargeDetailRespDto, (String[])new String[0]);
        List<StorageChargeDetailEo> storageChargeDetailEos = this.calculateAndSetDefault(Arrays.asList(storageChargeDetailEo));
        this.storageChargeDetailService.updateStorageChargeDetailBatch(storageChargeDetailEos);
        this.syncBill(storageChargeDetailEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStorageChargeDetailBatch(List<StorageChargeDetailEo> storageChargeDetailEos) {
        Assert.notNull(storageChargeDetailEos, (String)"0001", (String)"\u4ed3\u50a8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        storageChargeDetailEos.forEach(c -> {
            int result = this.storageChargeDetailDas.update((BaseEo)c);
            Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u6279\u91cf\u66f4\u65b0\u5931\u8d25");
        });
    }

    @Override
    public List<StorageChargeDetailEo> getStorageChargeDetailEoByBillTime(Date startStorageTime, Date endStorageTime, List<String> warehouseCodes) {
        StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo();
        ArrayList sqlFilters = Lists.newArrayList();
        if (ObjectUtils.isNotEmpty((Object)startStorageTime)) {
            sqlFilters.add(SqlFilter.ge((String)"storage_time", (Object)startStorageTime));
        }
        if (ObjectUtils.isNotEmpty((Object)endStorageTime)) {
            sqlFilters.add(SqlFilter.le((String)"storage_time", (Object)endStorageTime));
        }
        if (CollectionUtils.isNotEmpty(warehouseCodes)) {
            sqlFilters.add(SqlFilter.in((String)"warehouse_code", warehouseCodes));
        }
        sqlFilters.add(SqlFilter.gt((String)"organization_support", (Object)BigDecimal.ZERO));
        sqlFilters.add(SqlFilter.eq((String)"dr", (Object)0));
        storageChargeDetailEo.setSqlFilters((List)sqlFilters);
        List detailEos = this.storageChargeDetailDas.select((BaseEo)storageChargeDetailEo);
        return detailEos;
    }

    private List<StorageChargeDetailEo> calculateStorage(List<StorageChargeDetailEo> apportionDetailEos, Map<String, ImportStorageChargeDetailChangeVo> collect, Function<List<StorageChargeDetailEo>, List<StorageChargeDetailEo>> func) {
        apportionDetailEos.forEach(apportionDetail -> {
            ImportStorageChargeDetailChangeVo importStorageChargeDetailChangeVo = (ImportStorageChargeDetailChangeVo)collect.get(apportionDetail.getStorageTime() + apportionDetail.getLogicWarehouseCode() + apportionDetail.getOpLongCode() + apportionDetail.getBatch());
            apportionDetail.setAdjustType(importStorageChargeDetailChangeVo.getAdjustType());
            apportionDetail.setAdjustDeliveryNum(importStorageChargeDetailChangeVo.getAdjustDeliveryNum());
            apportionDetail.setRemark(importStorageChargeDetailChangeVo.getRemark());
        });
        ArrayList allDetail = Lists.newArrayList();
        Map<String, List<StorageChargeDetailEo>> detailMap = apportionDetailEos.stream().collect(Collectors.groupingBy(c -> c.getStorageTime() + c.getWarehouseCode() + c.getOpLongCode() + c.getBatch()));
        detailMap.forEach((k, v) -> {
            StorageChargeDetailEo storageChargeDetailEo = (StorageChargeDetailEo)v.stream().findFirst().get();
            List ids = v.stream().map(c -> c.getId()).collect(Collectors.toList());
            StorageChargeDetailEo queryTarget = new StorageChargeDetailEo();
            queryTarget.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.ne((String)"id", ids)}));
            queryTarget.setStorageTime(storageChargeDetailEo.getStorageTime());
            queryTarget.setWarehouseCode(storageChargeDetailEo.getWarehouseCode());
            queryTarget.setOpLongCode(storageChargeDetailEo.getOpLongCode());
            queryTarget.setBatch(storageChargeDetailEo.getBatch());
            queryTarget.setBizType(ApportionTradeTypeEnum.NORMAL_TRADE.getKey());
            List storageChargeDetailList = this.storageChargeDetailDas.select((BaseEo)queryTarget);
            allDetail.addAll(storageChargeDetailList);
        });
        allDetail.addAll(apportionDetailEos);
        return func.apply(this.calculateAndSetDefault(allDetail));
    }

    private void verifyImportData(List<ImportStorageChargeDetailChangeVo> excelImportResult, List<StorageChargeDetailEo> apportionDetailEos) {
        for (ImportStorageChargeDetailChangeVo importStorageChargeDetailChangeVo : excelImportResult) {
            if (ObjectUtils.isEmpty((Object)importStorageChargeDetailChangeVo.getStorageTime()) || StringUtils.isBlank((CharSequence)importStorageChargeDetailChangeVo.getLogicWarehouseCode()) || StringUtils.isBlank((CharSequence)importStorageChargeDetailChangeVo.getOpLongCode()) || StringUtils.isBlank((CharSequence)importStorageChargeDetailChangeVo.getBatch()) || ObjectUtils.isEmpty((Object)importStorageChargeDetailChangeVo.getAdjustType()) || ObjectUtils.isEmpty((Object)importStorageChargeDetailChangeVo.getAdjustDeliveryNum())) {
                importStorageChargeDetailChangeVo.setResult("\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
                continue;
            }
            StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo();
            storageChargeDetailEo.setStorageTime(importStorageChargeDetailChangeVo.getStorageTime());
            storageChargeDetailEo.setLogicWarehouseCode(importStorageChargeDetailChangeVo.getLogicWarehouseCode());
            storageChargeDetailEo.setOpLongCode(importStorageChargeDetailChangeVo.getOpLongCode());
            storageChargeDetailEo.setBatch(importStorageChargeDetailChangeVo.getBatch());
            storageChargeDetailEo.setBizType(ApportionTradeTypeEnum.NORMAL_TRADE.getKey());
            StorageChargeDetailEo selectOne = (StorageChargeDetailEo)this.storageChargeDetailDas.selectOne((BaseEo)storageChargeDetailEo);
            if (ObjectUtils.isEmpty((Object)selectOne)) {
                importStorageChargeDetailChangeVo.setResult("\u5bfc\u5165\u4ed3\u50a8\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728");
                continue;
            }
            if (OperationStorageEnum.SUBTRACT.getKey().equals(importStorageChargeDetailChangeVo.getAdjustType()) && selectOne.getInventoryNum() < importStorageChargeDetailChangeVo.getAdjustDeliveryNum()) {
                importStorageChargeDetailChangeVo.setResult("\u8c03\u6574\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u603b\u6570");
                continue;
            }
            apportionDetailEos.add(selectOne);
        }
    }

    private List<StorageChargeDetailEo> calculateDelivery(Date detailDate, List<StorageChargeDetailEo> storageChargeDetailEos, Function<List<StorageChargeDetailEo>, List<StorageChargeDetailEo>> func) {
        if (CollectionUtils.isEmpty(storageChargeDetailEos)) {
            return null;
        }
        List<String> logicWarehouses = storageChargeDetailEos.stream().map(c -> c.getLogicWarehouseCode()).distinct().collect(Collectors.toList());
        List<DeliveryResultOrderRespDto> inDeliveryResultOrderRespDtos = this.deliveryResultOrderService.queryByWarehouse(logicWarehouses, detailDate, DeliveryResultOrderTypeEnum.RECEIVE);
        List<DeliveryResultOrderRespDto> outDeliveryResultOrderRespDtos = this.deliveryResultOrderService.queryByWarehouse(logicWarehouses, detailDate, DeliveryResultOrderTypeEnum.DELIVERY);
        if (CollectionUtils.isNotEmpty(inDeliveryResultOrderRespDtos)) {
            Map<String, List<DeliveryResultOrderRespDto>> inDeliveryResultOrderRespDtosMap = inDeliveryResultOrderRespDtos.stream().collect(Collectors.groupingBy(DeliveryResultOrderRespDto::getReceiveLogicWarehouseCode));
            storageChargeDetailEos.forEach(c -> {
                List orDefault = inDeliveryResultOrderRespDtosMap.getOrDefault(c.getLogicWarehouseCode(), Lists.newArrayList());
                if (CollectionUtils.isNotEmpty((Collection)orDefault)) {
                    List detailList = orDefault.stream().map(DeliveryResultOrderRespDto::getResultOrderDetailRespDtoList).collect(Collectors.toList());
                    Map<String, List<DeliveryResultOrderDetailRespDto>> mapGroupByCargoCode = detailList.stream().flatMap(Collection::stream).collect(Collectors.groupingBy(deliveryResultOrderDetailRespDto -> deliveryResultOrderDetailRespDto.getSkuCode() + deliveryResultOrderDetailRespDto.getBatch()));
                    List<DeliveryResultOrderDetailRespDto> deliveryResultOrderDetailRespDtos = mapGroupByCargoCode.getOrDefault(c.getOpLongCode() + c.getBatch(), Lists.newArrayList());
                    BigDecimal quantity = deliveryResultOrderDetailRespDtos.stream().filter(inResultOrderDetail -> inResultOrderDetail.getSkuCode().equals(c.getOpLongCode())).map(DeliveryResultOrderDetailRespDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    c.setInDeliveryNum(Integer.valueOf(quantity.intValue()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(outDeliveryResultOrderRespDtos)) {
            Map<String, List<DeliveryResultOrderRespDto>> outResultOrderMapGroupByWarehouseCode = outDeliveryResultOrderRespDtos.stream().collect(Collectors.groupingBy(DeliveryResultOrderRespDto::getDeliveryLogicWarehouseCode));
            storageChargeDetailEos.forEach(c -> {
                List orDefault = outResultOrderMapGroupByWarehouseCode.getOrDefault(c.getLogicWarehouseCode(), Lists.newArrayList());
                if (CollectionUtils.isNotEmpty((Collection)orDefault)) {
                    List detailList = orDefault.stream().map(DeliveryResultOrderRespDto::getResultOrderDetailRespDtoList).collect(Collectors.toList());
                    Map<String, List<DeliveryResultOrderDetailRespDto>> mapGroupByCargoCode = detailList.stream().flatMap(Collection::stream).collect(Collectors.groupingBy(deliveryResultOrderDetailRespDto -> deliveryResultOrderDetailRespDto.getSkuCode() + deliveryResultOrderDetailRespDto.getBatch()));
                    List<DeliveryResultOrderDetailRespDto> outResultOrderDetailRespDtoList = mapGroupByCargoCode.getOrDefault(c.getOpLongCode() + c.getBatch(), Lists.newArrayList());
                    BigDecimal quantity = outResultOrderDetailRespDtoList.stream().filter(inResultOrderDetail -> inResultOrderDetail.getSkuCode().equals(c.getOpLongCode())).map(DeliveryResultOrderDetailRespDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    c.setOutDeliveryNum(Integer.valueOf(quantity.intValue()));
                }
            });
        }
        return func.apply(storageChargeDetailEos);
    }

    @Override
    public Boolean createInnerTradeOrderDetail(String transferOrderNo) {
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setTransferOrderNo(transferOrderNo);
        List<TransferOrderRespDto> transferOrderRespDtos = this.transferOrderService.queryByTransferOrderReqDto(transferOrderReqDto);
        if (CollectionUtils.isEmpty(transferOrderRespDtos)) {
            return false;
        }
        TransferOrderRespDto transferOrderRespDto = (TransferOrderRespDto)transferOrderRespDtos.stream().findFirst().get();
        this.LOGGER.info("\u8c03\u62e8\u5355\uff1a{} => \u5185\u90e8\u4ea4\u6613\u8ba2\u5355\u660e\u7ec6 => {}", (Object)transferOrderNo, (Object)JSON.toJSONString((Object)transferOrderRespDto));
        List<String> orgIds = Arrays.asList(this.storageChargeHelper.getPropertyRightOrganizationIds().split(","));
        List<String> tradeOrderTypes = Arrays.asList(this.storageChargeHelper.getTransferOrderTypes().split(","));
        this.LOGGER.info("\u8c03\u62e8\u5355\u7c7b\u578b\uff1a{} => \u5185\u90e8\u4ea4\u6613\u8ba2\u5355", (Object)JSON.toJSONString(tradeOrderTypes));
        if (tradeOrderTypes.contains(transferOrderRespDto.getType()) && orgIds.contains(transferOrderRespDto.getOutOrganizationId().toString()) && !orgIds.contains(transferOrderRespDto.getInOrganizationId().toString())) {
            DeliveryResultOrderReqDto deliveryResultOrderReqDto = new DeliveryResultOrderReqDto();
            deliveryResultOrderReqDto.setOrderType(DeliveryResultOrderTypeEnum.DELIVERY.getKey());
            deliveryResultOrderReqDto.setRelevanceNos(Arrays.asList(transferOrderRespDto.getTransferOrderNo()));
            List<DeliveryResultOrderRespDto> deliveryResultOrderRespDtos = this.deliveryResultOrderService.queryDeliveryResultOrder(deliveryResultOrderReqDto);
            List deliveryResultOrderDetailRespDtos = deliveryResultOrderRespDtos.stream().map(deliveryResultOrderRespDto -> deliveryResultOrderRespDto.getResultOrderDetailRespDtoList()).flatMap(Collection::stream).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtils.isNotEmpty(deliveryResultOrderDetailRespDtos), (String)"0001", (String)(transferOrderRespDto.getTransferOrderNo() + "\u8c03\u62e8\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\uff01\uff01\uff01"));
            Map<String, List<DeliveryResultOrderDetailRespDto>> collect = deliveryResultOrderDetailRespDtos.stream().collect(Collectors.groupingBy(c -> c.getBatch() + c.getSkuCode()));
            Date endTime = DateUtil.getDayBegin((Date)transferOrderRespDto.getUpdateTime());
            collect.forEach((k, v) -> {
                BigDecimal reduce = v.stream().map(c -> c.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.LOGGER.info("\u63d2\u5165\u660e\u7ec6:{},\u660e\u7ec6\uff1a{}", k, (Object)JSONObject.toJSONString((Object)v));
                ArrayList details = Lists.newArrayList();
                this.calculateDeliveryResultAnother(transferOrderRespDto, details, endTime, reduce, (DeliveryResultOrderDetailRespDto)v.get(0));
                if (CollectionUtils.isNotEmpty((Collection)details)) {
                    this.LOGGER.info("\u63d2\u5165\u4ed3\u50a8\u8d26\u5355\u660e\u7ec6\uff1a{}\uff0c{}", (Object)transferOrderRespDto.getTransferOrderNo(), (Object)JSON.toJSONString((Object)details));
                    int insert = this.storageChargeDetailDas.insertBatch((List)details);
                    Assert.isTrue((insert > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u63d2\u5165\u4ed3\u50a8\u660e\u7ec6\u6570\u636e\u5931\u8d25\uff01\uff01\uff01");
                }
                try {
                    if (CollectionUtils.isNotEmpty((Collection)details)) {
                        details.forEach(d -> {
                            LogicInventorySnapEo eo = new LogicInventorySnapEo();
                            eo.setLongCode(d.getOpLongCode());
                            eo.setBatch(d.getBatch());
                            eo.setPhysicsWarehouseCode(d.getWarehouseCode());
                            String dateFormat = DateUtil.getDateFormat((Date)d.getStorageTime(), (String)"yyyy-MM-dd HH:mm:ss");
                            this.logicInventorySnapMapper.updateDayTotal(eo, dateFormat, dateFormat);
                        });
                    }
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5237\u65b0\u521a\u751f\u6210\u7684\u4ed3\u50a8\u660e\u7ec6\u7684\u5f53\u65e5\u603b\u677f\u6570\u53ca\u7ec4\u7ec7\u6240\u5360\u677f\u6570\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            });
        } else {
            this.LOGGER.info("\u975e\u5185\u90e8\u4ea4\u6613\u5355\u636e\uff0c\u4e0d\u8fdb\u884c\u5904\u7406");
        }
        return true;
    }

    @Override
    public void calculateStorageDetail() {
        this.LOGGER.info("calculateStorageDetail => \u91cd\u65b0\u8ba1\u7b97\u4ed3\u50a8\u660e\u7ec6 -> {}", (Object)System.currentTimeMillis());
        StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo();
        storageChargeDetailEo.setCalculateStatus(CalculateStorageStatusEnum.UN_FINISH.getKey());
        List storageChargeDetailList = this.storageChargeDetailDas.select((BaseEo)storageChargeDetailEo);
        if (CollectionUtils.isEmpty((Collection)storageChargeDetailList)) {
            return;
        }
        Map<String, List<StorageChargeDetailEo>> storageDetailMap = storageChargeDetailList.stream().collect(Collectors.groupingBy(detail -> detail.getStorageTime() + detail.getWarehouseCode() + detail.getOpLongCode() + detail.getBatch()));
        ArrayList resultList = Lists.newArrayList();
        storageDetailMap.forEach((key, val) -> {
            StorageChargeDetailEo detail = (StorageChargeDetailEo)val.stream().findFirst().get();
            StorageChargeDetailEo storageChargeDetail = new StorageChargeDetailEo();
            storageChargeDetail.setStorageTime(detail.getStorageTime());
            storageChargeDetail.setWarehouseCode(detail.getWarehouseCode());
            storageChargeDetail.setOpLongCode(detail.getOpLongCode());
            storageChargeDetail.setBatch(detail.getBatch());
            List chargeDetails = this.storageChargeDetailDas.select((BaseEo)storageChargeDetail);
            if (CollectionUtils.isNotEmpty((Collection)chargeDetails)) {
                resultList.addAll(chargeDetails);
            }
        });
        List<StorageChargeDetailEo> storageChargeDetailEos = this.calculateAndSetDefault(resultList);
        storageChargeDetailEos.stream().filter(c -> !c.getBizType().equals(ApportionTradeTypeEnum.NORMAL_TRADE.getKey())).forEach(c -> c.setCalculateStatus(CalculateStorageStatusEnum.FINISH.getKey()));
        this.storageChargeDetailService.updateStorageChargeDetailBatch(storageChargeDetailEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncStorageDetailAndBill(SyncStorageDetailAndBillVo vo) {
        this.LOGGER.info("[\u540c\u6b65\u66f4\u65b0\u4ed3\u50a8\u660e\u7ec6\u4e0e\u4ed3\u50a8\u8d26\u5355],\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)vo)));
        this.storageChargeDetailDas.logicDelByCondition(vo.getStorageTime(), vo.getLogicWarehouseCodes(), vo.getOpLongCodes(), vo.getBatchs());
        this.storageChargeDetailService.syncStorageChargeDetail(vo);
        StorageChargeDetailReqDto reqDto = new StorageChargeDetailReqDto();
        reqDto.setWarehouseCode(vo.getWarehouseCode());
        reqDto.setOpLongCode(vo.getOpLongCodes().get(0));
        reqDto.setBatch(vo.getBatchs().get(0));
        reqDto.setStorageTime(vo.getStorageTime());
        this.storageChargeDetailService.updateStorageDetailSupport(reqDto);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(StorageChargeDetailEo::getStorageTime, (Object)vo.getStorageTime())).in(StorageChargeDetailEo::getWarehouseCode, vo.getLogicWarehouseCodes())).in(StorageChargeDetailEo::getOpLongCode, vo.getOpLongCodes())).in(StorageChargeDetailEo::getBatch, vo.getBatchs());
        List<StorageChargeDetailEo> storageChargeDetailEos = this.storageChargeDetailDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)storageChargeDetailEos)) {
            storageChargeDetailEos = this.calculateAndSetDefault(storageChargeDetailEos);
            this.storageChargeDetailService.updateStorageChargeDetailBatch(storageChargeDetailEos);
            this.syncBill(storageChargeDetailEos);
        }
    }

    @Override
    public void updateStorageDetailSupport(StorageChargeDetailReqDto reqDto) {
        this.LOGGER.info("\u6839\u636e\u5e93\u5b58\u5feb\u7167\u66f4\u65b0\u4ed3\u50a8\u660e\u7ec6\u7684\u603b\u677f\u6570\u53ca\u7ec4\u7ec7\u6240\u5360\u677f\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        StorageChargeDetailEo eo = new StorageChargeDetailEo();
        eo.setWarehouseCode(reqDto.getWarehouseCode());
        eo.setOpLongCode(reqDto.getOpLongCode());
        eo.setBatch(reqDto.getBatch());
        eo.setStorageTime(reqDto.getStorageTime());
        eo.setStorageStartTime(reqDto.getStorageStartTime());
        eo.setStorageEndTime(reqDto.getStorageEndTime());
        if (ObjectUtils.isEmpty((Object)eo.getStorageTime()) && (ObjectUtils.isEmpty((Object)eo.getStorageStartTime()) || ObjectUtils.isEmpty((Object)eo.getStorageEndTime()))) {
            throw new BizException("-1", "\u66f4\u65b0\u603b\u677f\u6570\u53ca\u7ec4\u7ec7\u6240\u5360\u677f\u6570\u5f02\u5e38\uff0c\u8bf7\u6c42\u6709\u8bef");
        }
        this.storageChargeDetailDas.updateStorageDetailSupportBySnap(eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStorageDetailBySnap(SyncStorageDetailAndBillVo vo) {
        this.LOGGER.info("\u6839\u636e\u5feb\u7167\u53d8\u52a8\uff0c\u66f4\u65b0\u4ed3\u50a8\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)((Object)vo)));
        List snapEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventorySnapDas.filter().eq((Object)"dr", (Object)0)).eq((Object)"statistical_time", (Object)vo.getStorageTime())).in((Object)"physics_warehouse_code", new Object[]{vo.getWarehouseCode()})).in((Object)"long_code", vo.getOpLongCodes())).in(CollectionUtils.isNotEmpty(vo.getLogicWarehouseCodes()), (Object)"warehouse_code", vo.getLogicWarehouseCodes())).in((Object)"batch", vo.getBatchs())).list();
        if (CollectionUtils.isEmpty((Collection)snapEoList)) {
            this.LOGGER.info("\u627e\u4e0d\u5230\u5feb\u7167\u6570\u636e");
            return;
        }
        Map<String, List<LogicInventorySnapEo>> snapEoMap = snapEoList.stream().collect(Collectors.groupingBy(eo -> eo.getPhysicsWarehouseCode() + eo.getWarehouseCode() + eo.getLongCode() + eo.getBatch()));
        List storageChargeDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.storageChargeDetailDas.filter().eq((Object)"dr", (Object)0)).eq((Object)"storage_time", (Object)vo.getStorageTime())).in((Object)"warehouse_code", new Object[]{vo.getWarehouseCode()})).in((Object)"op_long_code", vo.getOpLongCodes())).in(CollectionUtils.isNotEmpty(vo.getLogicWarehouseCodes()), (Object)"logic_warehouse_code", vo.getLogicWarehouseCodes())).in((Object)"batch", vo.getBatchs())).list();
        if (CollectionUtils.isEmpty((Collection)storageChargeDetailEoList)) {
            this.LOGGER.info("\u65e0\u4ed3\u50a8\u660e\u7ec6\u9700\u8981\u66f4\u65b0");
            return;
        }
        storageChargeDetailEoList.stream().filter(d -> Objects.equals(d.getBizType(), ApportionTradeTypeEnum.NORMAL_TRADE.getKey())).forEach(d -> {
            List inventorySnapEoList = (List)snapEoMap.get(d.getWarehouseCode() + d.getLogicWarehouseCode() + d.getOpLongCode() + d.getBatch());
            if (CollectionUtils.isNotEmpty((Collection)inventorySnapEoList)) {
                LogicInventorySnapEo reqDto = (LogicInventorySnapEo)inventorySnapEoList.get(0);
                d.setEndInventoryNum(Integer.valueOf(reqDto.getBalance().intValue()));
                d.setZhTrayNum(Integer.valueOf(reqDto.getTrayNum().intValue()));
                d.setPackingQuantity(reqDto.getBigBox());
                d.setAllDaySupport(reqDto.getDayTotalBoard());
                BigDecimal organizationSupport = this.calculateOrganizationSupport(new BigDecimal(d.getEndInventoryNum()), reqDto.getDayTotalBalance(), new BigDecimal(reqDto.getDayTotalBoard()));
                d.setOrganizationSupport(organizationSupport);
                this.storageChargeDetailDas.updateSelective((BaseEo)d);
            }
        });
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u4ed3\u50a8\u660e\u7ec6\u8d39\u7528\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("\u5f52\u6863\u7684id:{}", (Object)JSON.toJSONString((Object)updateReqDto.getModuleRecordIdList()));
        log.info("\u5f52\u6863\u7684\u66f4\u65b0\u6807\u8bc6\u7b26:{}", (Object)JSON.toJSONString((Object)updateReqDto.getPlacedFlag()));
        StorageChargeDetailEo updateEo = new StorageChargeDetailEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List eos = this.storageChargeDetailDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = eos.stream().filter(eo -> eo.getPlacedFlag() == null || eo.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.storageChargeDetailDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        log.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }

    @Override
    public List<StorageChargeDetailRespDto> importPage(List<StorageChargeDetailReqDto> queryDtoList) {
        if (CollectionUtil.isEmpty(queryDtoList)) {
            return Lists.newArrayList();
        }
        List list = this.storageChargeDetailDas.importPage(queryDtoList);
        return list;
    }

    private void calculateDeliveryResult(TransferOrderRespDto transferOrderRespDto, List<StorageChargeDetailEo> details, Date endTime, BigDecimal reduce, DeliveryResultOrderDetailRespDto deliveryResultOrderDetailRespDto) {
        if (reduce.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        Date startTime = this.monthFirstDay(endTime);
        EsInventoryOperateLogVO inventoryOperateLog = this.queryInventoryOperateLog(transferOrderRespDto, deliveryResultOrderDetailRespDto);
        SyncApportionDataDto deliveryResultAllDto = new SyncApportionDataDto(startTime, endTime, Arrays.asList(deliveryResultOrderDetailRespDto.getSkuCode()), Arrays.asList(deliveryResultOrderDetailRespDto.getBatch()), Arrays.asList(transferOrderRespDto.getOutOrganizationId().toString()), Arrays.asList(this.storageChargeHelper.getPhysicsWarehouseCodes().split(",")), Arrays.asList(transferOrderRespDto.getOutPhysicsWarehouseCode()), Arrays.asList(CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode(), CsLogicWarehouseQualityEnum.QUALIFIED.getCode()));
        List logicWarehouseReceiveRecordList = this.storageChargeApportionMapper.queryLogicWarehouseReceiveRecord(deliveryResultAllDto);
        if (CollectionUtils.isEmpty((Collection)logicWarehouseReceiveRecordList)) {
            this.LOGGER.info("\u8fd1\u7ef4\u5ea6\u6536\u83b7\u7ed3\u679c\u5355\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            return;
        }
        List<LogicWarehouseReceiveRecordVo> logicWarehouseReceiveRecordVoList = this.calculateLogicWarehouseReceive(transferOrderRespDto, logicWarehouseReceiveRecordList);
        this.LOGGER.info("\u8ba1\u7b97\u8c03\u5165\u81f3\u6700\u521d\u662f\u4ed3\u5e93\u7684\u6d41\u6c34:{}", (Object)JSONObject.toJSONString(logicWarehouseReceiveRecordVoList));
        this.verify(reduce, logicWarehouseReceiveRecordVoList, inventoryOperateLog.getBeforeInventory());
        for (LogicWarehouseReceiveRecordVo record : logicWarehouseReceiveRecordVoList) {
            StorageChargeApportionRespDto apportion;
            if (record.getInDeliveryTime().after(endTime)) continue;
            BigDecimal apportionNum = new BigDecimal(record.getInventoryNum());
            BigDecimal result = reduce.subtract(apportionNum);
            Date inDeliveryTime = DateUtil.getDayBegin((Date)record.getInDeliveryTime());
            if (result.compareTo(BigDecimal.ZERO) > 0) {
                apportion = new StorageChargeApportionRespDto();
                CubeBeanUtils.copyProperties((Object)apportion, (Object)record, (String[])new String[0]);
                details.addAll(this.createStorageDetail(inDeliveryTime, endTime, transferOrderRespDto, apportionNum, apportion));
                reduce = result;
                continue;
            }
            apportion = new StorageChargeApportionRespDto();
            CubeBeanUtils.copyProperties((Object)apportion, (Object)record, (String[])new String[0]);
            details.addAll(this.createStorageDetail(inDeliveryTime, endTime, transferOrderRespDto, reduce, apportion));
            reduce = BigDecimal.ZERO;
            break;
        }
    }

    private void calculateDeliveryResultAnother(TransferOrderRespDto transferOrderRespDto, List<StorageChargeDetailEo> details, Date endTime, BigDecimal reduce, DeliveryResultOrderDetailRespDto detailRespDto) {
        this.LOGGER.info("\u5185\u90e8\u4ea4\u6613\u4ed3\u50a8\u8d26\u5355\u660e\u7ec6\u8865\u5168\uff1a{}", (Object)JSON.toJSONString((Object)transferOrderRespDto));
        SimpleDateFormat dtf = new SimpleDateFormat("MM-dd");
        if (dtf.format(endTime).equals("01-01")) {
            this.LOGGER.info("1\u67081\u53f7\u5b8c\u6210\u7684\u5185\u90e8\u4ea4\u6613\u4e0d\u8fdb\u884c\u5904\u7406");
            return;
        }
        if (transferOrderRespDto.getOutPhysicsWarehouseCode().equals("ZHK")) {
            this.LOGGER.info("\u73e0\u6d77\u4ed3\u4e0d\u8fdb\u884c\u5904\u7406");
            return;
        }
        LogicInventorySnapVo vo = new LogicInventorySnapVo();
        vo.setLongCode(detailRespDto.getSkuCode());
        vo.setBatch(detailRespDto.getBatch());
        vo.setStartStatisticalTime(this.monthFirstDayStr(endTime));
        vo.setEndStatisticalTime(this.beforeDay(endTime));
        vo.setPhysicsWarehouseCode(transferOrderRespDto.getOutPhysicsWarehouseCode());
        vo.setOrganizationIds(Arrays.asList(this.storageChargeHelper.getPropertyRightOrganizationIds().split(",")));
        this.LOGGER.info("\u67e5\u8be2\u5feb\u7167\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)vo));
        List logicInventorySnapVos = this.logicInventorySnapMapper.queryInventorySnapList(vo);
        if (CollectionUtil.isEmpty((Collection)logicInventorySnapVos)) {
            this.LOGGER.info("\u65e0\u5feb\u7167\u6570\u636e\uff0c\u65e0\u9700\u5904\u7406");
            return;
        }
        this.LOGGER.info("\u5feb\u7167\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)logicInventorySnapVos));
        for (LogicInventorySnapVo v : logicInventorySnapVos) {
            if (v.getSnapBalance().compareTo(BigDecimal.ZERO) <= 0 || v.getSnapBalance().compareTo(v.getCompleteBalance()) <= 0) continue;
            BigDecimal surplus = v.getSnapBalance().subtract(v.getCompleteBalance());
            if (surplus.compareTo(reduce) > 0) {
                surplus = reduce;
            }
            BigDecimal orgSupport = new BigDecimal(StorageChargeHelper.getSupport(surplus.intValue(), v.getBigRatio(), v.getZhTrayNum()));
            StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo(v.getStatisticalTime(), endTime, transferOrderRespDto.getInPhysicsWarehouseCode(), transferOrderRespDto.getInPhysicsWarehouseName(), v.getLongCode(), v.getCargoName(), v.getBatch(), transferOrderRespDto.getInLogicWarehouseCode(), transferOrderRespDto.getInLogicWarehouseName(), transferOrderRespDto.getInOrganizationId(), transferOrderRespDto.getInOrganization(), transferOrderRespDto.getInOrganizationId(), transferOrderRespDto.getInOrganization(), ApportionTradeTypeEnum.INNER_TRADE.getKey(), v.getZhTrayNum(), v.getBigRatio(), orgSupport, Integer.valueOf(surplus.intValue()), Integer.valueOf(orgSupport.setScale(0, RoundingMode.UP).intValue()), Integer.valueOf(surplus.intValue()), Integer.valueOf(surplus.intValue()), "", CalculateStorageStatusEnum.UN_FINISH.getKey());
            storageChargeDetailEo.setAllDaySupport(v.getDayTotalBoard());
            if (ObjectUtils.isNotEmpty((Object)v.getDayTotalBalance()) && v.getDayTotalBalance().compareTo(BigDecimal.ZERO) > 0 && ObjectUtils.isNotEmpty((Object)v.getDayTotalBoard()) && v.getDayTotalBoard() > 0) {
                BigDecimal multiply = this.calculateOrganizationSupport(new BigDecimal(storageChargeDetailEo.getEndInventoryNum()), v.getDayTotalBalance(), new BigDecimal(v.getDayTotalBoard()));
                storageChargeDetailEo.setOrganizationSupport(multiply);
            }
            details.add(storageChargeDetailEo);
        }
    }

    private BigDecimal calculateOrganizationSupport(BigDecimal endInventoryNum, BigDecimal dayTotalBalance, BigDecimal dayTotalBoard) {
        if (ObjectUtils.isNotEmpty((Object)endInventoryNum) && ObjectUtils.isNotEmpty((Object)dayTotalBalance) && ObjectUtils.isNotEmpty((Object)dayTotalBoard) && dayTotalBalance.compareTo(BigDecimal.ZERO) != 0) {
            return endInventoryNum.divide(dayTotalBalance, 6, RoundingMode.HALF_UP).multiply(dayTotalBoard);
        }
        return BigDecimal.ZERO;
    }

    private List<LogicWarehouseReceiveRecordVo> calculateLogicWarehouseReceive(TransferOrderRespDto transferOrderRespDto, List<LogicWarehouseReceiveRecordVo> logicWarehouseReceiveRecordList) {
        Map<String, List<LogicWarehouseReceiveRecordVo>> collect = logicWarehouseReceiveRecordList.stream().collect(Collectors.groupingBy(c -> c.getLogicWarehouseCode()));
        List<LogicWarehouseReceiveRecordVo> logicWarehouseReceiveRecordVoList = collect.get(transferOrderRespDto.getOutLogicWarehouseCode());
        LogicWarehouseReceiveRecordVo recordVo = logicWarehouseReceiveRecordList.stream().sorted(Comparator.comparing(c -> c.getInDeliveryTime())).findFirst().get();
        if (!recordVo.getLogicWarehouseCode().equals(transferOrderRespDto.getOutLogicWarehouseCode())) {
            this.LOGGER.info("\u4e0e\u5f53\u524d\u5185\u90e8\u4ea4\u6613\u8c03\u62e8\u5355\u51fa\u5e93\u4ed3\u5e93\u4ea7\u54c1\u6536\u8d27\u7ed3\u679c\u5355 \u51fa\u5e93\u903b\u8f91\u4ed3\u4e0d\u4e00\u81f4\uff0c\u5219\u5b58\u5728\u66f4\u9ad8\u4e00\u7ea7\u80a1\u4efd\u7684\u5165\u5e93\u8c03\u62e8\uff0c\u8c03\u62e8\u5355\u53f7\u4e3a:{}", (Object)transferOrderRespDto.getTransferOrderNo());
            List<LogicWarehouseReceiveRecordVo> logicWarehouseSourceReceiveVoList = collect.get(recordVo.getLogicWarehouseCode());
            Integer sum = logicWarehouseReceiveRecordVoList.stream().mapToInt(c -> c.getInventoryNum()).sum();
            this.validReceiveRecord(logicWarehouseSourceReceiveVoList, new BigDecimal(sum));
            return logicWarehouseSourceReceiveVoList;
        }
        return logicWarehouseReceiveRecordVoList;
    }

    private EsInventoryOperateLogVO queryInventoryOperateLog(TransferOrderRespDto transferOrderRespDto, DeliveryResultOrderDetailRespDto deliveryResultOrderDetailRespDto) {
        EsInventoryOperateLogListPageParams inventoryOperateLogListPageParams = new EsInventoryOperateLogListPageParams();
        inventoryOperateLogListPageParams.setBatch(deliveryResultOrderDetailRespDto.getBatch());
        inventoryOperateLogListPageParams.setItemLongCode(deliveryResultOrderDetailRespDto.getSkuCode());
        inventoryOperateLogListPageParams.setWarehouseCode(transferOrderRespDto.getOutLogicWarehouseCode());
        inventoryOperateLogListPageParams.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        inventoryOperateLogListPageParams.setChangeTypeList(Arrays.asList("balance"));
        inventoryOperateLogListPageParams.setSourceNo(transferOrderRespDto.getTransferOrderNo());
        inventoryOperateLogListPageParams.setPageNum(Integer.valueOf(1));
        inventoryOperateLogListPageParams.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<EsInventoryOperateLogVO> esInventoryOperateLogVOPageInfo = this.csInventoryEsService.queryInventoryOperateLogListPage(inventoryOperateLogListPageParams);
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)esInventoryOperateLogVOPageInfo.getList()), (String)"0001", (String)"\u5373\u65f6\u5e93\u5b58\u83b7\u53d6\u5f02\u5e38\uff01\uff01\uff01");
        return (EsInventoryOperateLogVO)esInventoryOperateLogVOPageInfo.getList().stream().findFirst().get();
    }

    private void verify(BigDecimal reduce, List<LogicWarehouseReceiveRecordVo> logicWarehouseReceiveRecordList, BigDecimal inventoryNum) {
        logicWarehouseReceiveRecordList = logicWarehouseReceiveRecordList.stream().sorted(Comparator.comparing(LogicWarehouseReceiveRecordVo::getInDeliveryTime)).collect(Collectors.toList());
        int sum = logicWarehouseReceiveRecordList.stream().mapToInt(c -> c.getInventoryNum()).sum();
        this.LOGGER.info("\u4ea4\u6613\u5e93\u5b58\u6570 => {}; \u5f53\u524d\u7ef4\u5ea6\u8c03\u62e8\u603b\u6570 => {}; \u5373\u65f6\u5e93\u5b58\u6570 => {}", new Object[]{reduce, sum, inventoryNum});
        BigDecimal result = inventoryNum.subtract(new BigDecimal(sum));
        if (result.compareTo(reduce) > 0) {
            logicWarehouseReceiveRecordList.clear();
            return;
        }
        if (result.compareTo(BigDecimal.ZERO) > 0 && result.compareTo(reduce) < 0) {
            reduce = reduce.subtract(result);
        } else {
            this.validReceiveRecord(logicWarehouseReceiveRecordList, inventoryNum);
        }
    }

    public void validReceiveRecord(List<LogicWarehouseReceiveRecordVo> logicWarehouseReceiveRecordList, BigDecimal inventoryNum) {
        BigDecimal sum = new BigDecimal(logicWarehouseReceiveRecordList.stream().mapToInt(c -> c.getInventoryNum()).sum());
        if (sum.compareTo(inventoryNum) > 0 && logicWarehouseReceiveRecordList.size() > 1) {
            BigDecimal sums = new BigDecimal(logicWarehouseReceiveRecordList.stream().skip(1L).mapToInt(c -> c.getInventoryNum()).sum());
            this.LOGGER.info("\u5254\u9664\u8c03\u62e8\u5355\u8c03\u8c03\u62e8\u6570,\u5f53\u524d\u5269\u4f59 => {},\u6d41\u6c34\u660e\u7ec6\u4e3a:{}", (Object)sums, (Object)JSONObject.toJSONString(logicWarehouseReceiveRecordList));
            if (inventoryNum.subtract(sums).compareTo(BigDecimal.ZERO) <= 0) {
                logicWarehouseReceiveRecordList.remove(0);
                this.validReceiveRecord(logicWarehouseReceiveRecordList, inventoryNum);
            } else {
                LogicWarehouseReceiveRecordVo recordVo = (LogicWarehouseReceiveRecordVo)logicWarehouseReceiveRecordList.stream().findFirst().get();
                recordVo.setInventoryNum(Integer.valueOf(inventoryNum.subtract(sums).intValue()));
            }
        }
    }

    private BigDecimal calculateApportionTradeDetail(TransferOrderRespDto transferOrderRespDto, List<StorageChargeDetailEo> details, Date endTime, BigDecimal reduce, DeliveryResultOrderDetailRespDto deliveryResultOrderDetailRespDto) {
        StorageChargeApportionReqDto storageChargeApportionReqDto = new StorageChargeApportionReqDto();
        storageChargeApportionReqDto.setPhysicsWarehouseCode(transferOrderRespDto.getOutPhysicsWarehouseCode());
        storageChargeApportionReqDto.setLogicWarehouseCode(transferOrderRespDto.getOutLogicWarehouseCode());
        storageChargeApportionReqDto.setBelongOrgId(transferOrderRespDto.getOutOrganizationId());
        storageChargeApportionReqDto.setBatch(deliveryResultOrderDetailRespDto.getBatch());
        storageChargeApportionReqDto.setOpLongCode(deliveryResultOrderDetailRespDto.getSkuCode());
        storageChargeApportionReqDto.setIsVerify(IsVerifyApportionEnum.IS_VERIFY.getKey());
        List<StorageChargeApportionRespDto> dtoList = this.storageChargeApportionService.queryStorageChargeApportionList(storageChargeApportionReqDto);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List<String> tradeOrderTypes = Arrays.asList(this.storageChargeHelper.getTransferOrderTypes().split(","));
            this.LOGGER.info("\u8c03\u62e8\u5355\u7c7b\u578b\uff1a{} => \u5185\u90e8\u4ea4\u6613\u8ba2\u5355", (Object)JSON.toJSONString(tradeOrderTypes));
            for (StorageChargeApportionRespDto apportion : dtoList) {
                Date startTime = DateUtil.addDays((Date)apportion.getEndRecordMonth(), (int)1);
                BigDecimal calculateResult = this.storageChargeApportionService.verifyApportion(startTime, endTime, tradeOrderTypes, apportion, IsVerifyApportionEnum.NOT_VERIFY);
                if (calculateResult.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.LOGGER.info("\u8c03\u62e8\u5355\u7c7b\u578b\uff1a{} ,reduce:{}=> \u5927\u4e8e0 \uff0c\u5219\u5f53\u524d\u5269\u4f59\u5206\u644a\u5b58\u5728\u7ed3\u4f59\u5e93\u5b58,\u5206\u644a\u7684\u6570\u636e:{}", new Object[]{calculateResult, reduce, JSONObject.toJSONString((Object)apportion)});
                BigDecimal result = reduce.subtract(calculateResult);
                if (result.compareTo(BigDecimal.ZERO) > 0) {
                    details.addAll(this.createStorageDetail(startTime, endTime, transferOrderRespDto, calculateResult, apportion));
                    reduce = result;
                    continue;
                }
                this.LOGGER.info("\u8c03\u62e8\u5355\u7c7b\u578b\uff1a{} ,reduce:{}=> \u5c0f\u4e8e0 \uff0c\u5219\u5f53\u524d\u5269\u4f59\u5206\u644a\u5b58\u5728\u7ed3\u4f59\u5e93\u5b58,\u5206\u644a\u7684\u6570\u636e:{}", new Object[]{calculateResult, reduce, JSONObject.toJSONString((Object)apportion)});
                details.addAll(this.createStorageDetail(startTime, endTime, transferOrderRespDto, reduce, apportion));
                reduce = BigDecimal.ZERO;
                break;
            }
        }
        return reduce;
    }

    private List<StorageChargeDetailEo> createStorageDetail(Date beginTime, Date endTime, TransferOrderRespDto transferOrderRespDto, BigDecimal reduce, StorageChargeApportionRespDto apportion) {
        ArrayList storageChargeDetailList = Lists.newArrayList();
        while (beginTime.getTime() < endTime.getTime()) {
            HashSet<String> exceptionInfoSet = StorageChargeHelper.verifyStorageDetailException(apportion.getZhTrayNum(), apportion.getVolume(), apportion.getBigRatio());
            BigDecimal orgSupport = new BigDecimal(StorageChargeHelper.getSupport(reduce.intValue(), apportion.getBigRatio(), apportion.getZhTrayNum()));
            StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo(beginTime, endTime, transferOrderRespDto.getInPhysicsWarehouseCode(), transferOrderRespDto.getInPhysicsWarehouseName(), apportion.getOpLongCode(), apportion.getItemName(), apportion.getBatch(), transferOrderRespDto.getInLogicWarehouseCode(), transferOrderRespDto.getInLogicWarehouseName(), transferOrderRespDto.getInOrganizationId(), transferOrderRespDto.getInOrganization(), transferOrderRespDto.getInOrganizationId(), transferOrderRespDto.getInOrganization(), ApportionTradeTypeEnum.INNER_TRADE.getKey(), apportion.getZhTrayNum(), apportion.getBigRatio(), orgSupport, Integer.valueOf(reduce.intValue()), Integer.valueOf(orgSupport.setScale(0, 0).intValue()), Integer.valueOf(reduce.intValue()), Integer.valueOf(reduce.intValue()), JSON.toJSONString(exceptionInfoSet), CalculateStorageStatusEnum.UN_FINISH.getKey());
            storageChargeDetailList.add(storageChargeDetailEo);
            beginTime = cn.hutool.core.date.DateUtil.offsetDay((Date)beginTime, (int)1);
        }
        return storageChargeDetailList;
    }

    private Date monthFirstDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private String monthFirstDayStr(Date date) {
        Date firstDay = this.monthFirstDay(date);
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd");
        return dtf.format(firstDay);
    }

    private String beforeDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd");
        return dtf.format(calendar.getTime());
    }
}

