/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.job;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.biz.service.IExpressCostDetailService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="expressCostReportJob")
@Scope(value="prototype")
public class ExpressCostReportJob
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(ExpressCostReportJob.class);
    @Resource
    private IExpressCostDetailService expressCostDetailService;

    public void before(TaskMsg taskMsg) {
        logger.info("\u5feb\u9012\u8fd0\u8d39\u62a5\u8868\u8c03\u5ea6\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            logger.error("\u751f\u6210\u5feb\u9012\u8fd0\u8d39\u62a5\u8868\u6570\u636e\u8c03\u5ea6\u5f00\u59cb");
            LogisticStatisticReqDto logisticStatisticReqDto = new LogisticStatisticReqDto();
            Long startTime = ExpressCostReportJob.getLastMonthStartTime();
            Long endTime = ExpressCostReportJob.getLastMonthEndTime();
            DateTimeFormatter ftf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String startTimeStr = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneId.systemDefault()));
            String endTimeStr = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(endTime), ZoneId.systemDefault()));
            logger.info("\u751f\u6210\u5feb\u9012\u8fd0\u8d39\u62a5\u8868startTimeStr:{}", (Object)startTimeStr);
            logger.info("\u751f\u6210\u5feb\u9012\u8fd0\u8d39\u62a5\u8868endTimeStr:{}", (Object)endTimeStr);
            logisticStatisticReqDto.setStartTime(startTimeStr);
            logisticStatisticReqDto.setEndTime(endTimeStr);
            this.expressCostDetailService.syncExpressCostData(logisticStatisticReqDto);
            logger.info("\u751f\u6210\u5feb\u9012\u8fd0\u8d39\u62a5\u8868logisticStatisticReqDto:{}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u5feb\u9012\u8fd0\u8d39\u62a5\u8868\u51fa\u9519", (Throwable)e);
            return true;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u5feb\u9012\u8fd0\u8d39\u62a5\u8868\u8c03\u5ea6\u7ed3\u675f");
    }

    public static Long getLastMonthStartTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static Long getLastMonthEndTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTimeInMillis();
    }
}

