/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.tcbj.api.dto.request.QualityInfoReqDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInfoDetailReqDto;
import com.dtyunxi.tcbj.biz.service.IQualityInfoService;
import com.dtyunxi.tcbj.dao.das.ItemExtendDas;
import com.dtyunxi.tcbj.dao.das.ReQualityInfoDetailDas;
import com.dtyunxi.tcbj.dao.eo.ItemExtendEo;
import com.dtyunxi.tcbj.dao.eo.QualityInfoDetailEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class QualityInfoServiceImpl
implements IQualityInfoService {
    private static final Logger log = LoggerFactory.getLogger(QualityInfoServiceImpl.class);
    @Resource
    private ReQualityInfoDetailDas qualityInfoDetailDas;
    @Resource
    private ItemExtendDas itemExtendDas;

    @Override
    public PageInfo<QualityInfoDetailReqDto> infoDetailPage(QualityInfoReqDto reqDto) {
        log.info("\u8d28\u68c0\u8f6c\u5408\u683c\u5217\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        PageInfo page = this.qualityInfoDetailDas.infoDetailPage(reqDto);
        log.info("page,\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)page));
        if (page == null || CollectionUtils.isEmpty((Collection)page.getList())) {
            return new PageInfo();
        }
        return this.resultWrapper(reqDto, (PageInfo<QualityInfoDetailEo>)page);
    }

    private PageInfo<QualityInfoDetailReqDto> resultWrapper(QualityInfoReqDto reqDto, PageInfo<QualityInfoDetailEo> page) {
        Map<String, String> itemMap = this.getItemMap(page.getList());
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties(page, (Object)result, (String[])new String[]{"list"});
        String passed = "passed";
        boolean isPass = StringUtil.isNotBlank((CharSequence)reqDto.getDischargedStatus()) && passed.equals(reqDto.getDischargedStatus());
        List longCodes = page.getList().stream().map(QualityInfoDetailEo::getLongCode).collect(Collectors.toList());
        List minPassBatch = this.qualityInfoDetailDas.getMinPassBatch(longCodes);
        Map<String, String> map = minPassBatch.stream().collect(Collectors.toMap(r -> (String)r.get("longCode"), r -> (String)r.get("minBatch")));
        List infoDetailReqDtos = page.getList().stream().map(eo -> {
            QualityInfoDetailReqDto dto = new QualityInfoDetailReqDto();
            BeanUtils.copyProperties((Object)eo, (Object)dto);
            Optional.ofNullable(eo.getPushWmsStatus()).filter(StringUtil::isNotBlank).ifPresent(r -> dto.setPushWmsStatus(Integer.parseInt(r) > 0 ? "1" : "0"));
            dto.setSpecification((String)itemMap.get(eo.getLongCode()));
            if (isPass) {
                dto.setBatchUpsideFlag(Integer.valueOf(0));
            } else {
                Integer batch = 0;
                if (eo.getBatch().length() >= 6) {
                    batch = Integer.valueOf(Optional.ofNullable(eo.getBatch().substring(0, 6)).orElse("0"));
                }
                dto.setBatchUpsideFlag(Integer.valueOf(Integer.valueOf(Optional.ofNullable(map.get(eo.getLongCode())).orElse("0")).compareTo(batch) > 0 ? 1 : 0));
            }
            if (StringUtil.isNotBlank((CharSequence)dto.getReportTime())) {
                long now = new Date().getTime();
                try {
                    long reportTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dto.getReportTime()).getTime() + 259200000L;
                    if (now > reportTime) {
                        dto.setDischargedFlag(Integer.valueOf(1));
                    } else if (now <= reportTime) {
                        dto.setDischargedFlag(Integer.valueOf(0));
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                dto.setDischargedFlag(Integer.valueOf(2));
            }
            if (dto.getProduceTime() != null) {
                long time = dto.getProduceTime().getTime() + 604800000L;
                long time3 = new Date().getTime();
                try {
                    if (StringUtil.isNotBlank((CharSequence)dto.getReportTime())) {
                        Date date1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dto.getReportTime());
                        long time1 = date1.getTime();
                        if (time > time1) {
                            dto.setDischargedReport(Integer.valueOf(0));
                        } else if (time <= time1) {
                            dto.setDischargedReport(Integer.valueOf(1));
                        }
                    } else if (time3 >= time && StringUtil.isEmpty((CharSequence)dto.getReportTime())) {
                        dto.setDischargedReport(Integer.valueOf(1));
                    } else if (time3 < time && StringUtil.isEmpty((CharSequence)dto.getReportTime())) {
                        dto.setDischargedReport(Integer.valueOf(0));
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            return dto;
        }).collect(Collectors.toList());
        result.setList(infoDetailReqDtos);
        return result;
    }

    private Map<String, String> getItemMap(List<QualityInfoDetailEo> list) {
        return Optional.of(list.stream().map(QualityInfoDetailEo::getLongCode).collect(Collectors.toSet())).filter(CollectionUtils::isNotEmpty).map(longCodes -> ((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"item_code", (Collection)longCodes)).list().stream().filter(i -> StringUtil.isNotBlank((CharSequence)i.getItemCode()) && StringUtil.isNotBlank((CharSequence)i.getSpecification())).collect(Collectors.toMap(ItemExtendEo::getItemCode, ItemExtendEo::getSpecification, (o, o1) -> o))).orElse(Maps.newHashMap());
    }

    private int checkDischarged(Date date) {
        if (date == null) {
            return 1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        return date.before(calendar.getTime()) ? 1 : 0;
    }
}

