/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl.express;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.biz.dto.express.PriceLadderInfoDto;
import com.dtyunxi.tcbj.biz.dto.express.SfKhCostChargeMode;
import com.dtyunxi.tcbj.biz.dto.express.SfKhTemplateDto;
import com.dtyunxi.tcbj.biz.service.impl.express.HandlerAbstractCostReportServiceImpl;
import com.dtyunxi.tcbj.dao.eo.ExpressCostAreaEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostContractEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDetailEo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractCostReportService_2")
public class SfKhTemplateServiceImpl
extends HandlerAbstractCostReportServiceImpl {
    @Override
    public ExpressCostDetailEo calculationData(ExpressCostDetailEo eo) {
        ExpressCostDetailEo returnEo = new ExpressCostDetailEo();
        BeanUtils.copyProperties((Object)eo, (Object)returnEo);
        ExpressCostContractEo contractEo = eo.getExpressCostContractEo();
        if (contractEo != null) {
            this.converWeight(returnEo, contractEo);
            this.setWeightRange(returnEo);
            if (StringUtils.isNotBlank((CharSequence)contractEo.getParams())) {
                String params = contractEo.getParams();
                SfKhCostChargeMode chargeModeInfo = (SfKhCostChargeMode)JSON.parseObject((String)params, SfKhCostChargeMode.class);
                this.calculationPremium(returnEo, contractEo);
                ExpressCostAreaEo expressCostAreaEo = this.getAppointArea(eo);
                if (expressCostAreaEo != null) {
                    if (ObjectUtils.isEmpty((Object)returnEo.getChargedWeight())) {
                        this.setAbnormalCauses(returnEo, "\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a");
                        return returnEo;
                    }
                    this.calculateFreight(returnEo, expressCostAreaEo, contractEo, chargeModeInfo);
                    this.setCalculationInfo(returnEo, contractEo, expressCostAreaEo);
                } else {
                    String address = eo.getProvince();
                    String city = eo.getCity();
                    String area = eo.getArea();
                    if (StringUtils.isNotBlank((CharSequence)city)) {
                        address = address + city;
                    }
                    if (StringUtils.isNotBlank((CharSequence)area)) {
                        address = address + area;
                    }
                    this.setAbnormalCauses(returnEo, String.format("\u6839\u636e\u7701\u5e02\u533a\u3010%s\u3011\u672a\u5339\u914d\u5230\u5feb\u9012\u8fd0\u8d39\u6a21\u677f\u533a\u57df", address));
                }
            } else {
                this.setAbnormalCauses(returnEo, "\u5408\u540c\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u7a7a");
            }
            this.calculationAmount(returnEo);
            this.calculateDiscount(returnEo, contractEo);
        } else {
            this.setAbnormalCauses(returnEo, "\u672a\u5339\u914d\u5230\u5feb\u9012\u8fd0\u8d39\u6a21\u677f");
        }
        super.calculateOcsSystemWeight(returnEo);
        return returnEo;
    }

    private void calculateDiscount(ExpressCostDetailEo returnEo, ExpressCostContractEo contractEo) {
        if (Objects.equals(1, returnEo.getAbnormal())) {
            return;
        }
        if (Objects.equals(1, contractEo.getDiscountType())) {
            if (contractEo.getPreferentialDiscount() != null) {
                returnEo.setTotalFreight(returnEo.getTotalFreight().multiply(contractEo.getPreferentialDiscount()));
                returnEo.setCalculateDiscountFlag(Boolean.valueOf(true));
            }
        } else if (Objects.equals(2, contractEo.getDiscountType())) {
            List priceLadderList;
            BigDecimal discountRate;
            String priceRange = contractEo.getPriceRange();
            if (returnEo.getCalculationTotalFreight() != null && StringUtils.isNotBlank((CharSequence)priceRange) && BigDecimal.ONE.compareTo(discountRate = this.getDiscountRate(priceLadderList = JSON.parseArray((String)priceRange, PriceLadderInfoDto.class), returnEo.getCalculationTotalFreight())) > 0) {
                returnEo.setTotalFreight(returnEo.getTotalFreight().multiply(discountRate));
                returnEo.setCalculateDiscountFlag(Boolean.valueOf(true));
            }
        }
    }

    private BigDecimal getDiscountRate(List<PriceLadderInfoDto> priceLadderList, BigDecimal calculationTotalFreight) {
        BigDecimal discountRate = BigDecimal.ONE;
        for (PriceLadderInfoDto priceLadder : priceLadderList) {
            if (priceLadder.getMaxPrice() == null) {
                if (calculationTotalFreight.compareTo(priceLadder.getMinPrice()) < 0) continue;
                discountRate = priceLadder.getDiscountRate();
                break;
            }
            if (calculationTotalFreight.compareTo(priceLadder.getMinPrice()) < 0 || calculationTotalFreight.compareTo(priceLadder.getMaxPrice()) >= 0) continue;
            discountRate = priceLadder.getDiscountRate();
            break;
        }
        return discountRate;
    }

    private void calculateFreight(ExpressCostDetailEo returnEo, ExpressCostAreaEo expressCostAreaEo, ExpressCostContractEo costContractEo, SfKhCostChargeMode chargeModeInfo) {
        BigDecimal weight = returnEo.getChargedWeight();
        String params = expressCostAreaEo.getParams();
        SfKhTemplateDto areaDto = (SfKhTemplateDto)JSON.parseObject((String)params, SfKhTemplateDto.class);
        if (weight.compareTo(chargeModeInfo.getFirstWeight()) <= 0) {
            BigDecimal firstWeightPrice = areaDto.getFirstWeight();
            returnEo.setFirstPrice(firstWeightPrice);
            returnEo.setFirstPricePer(firstWeightPrice);
        } else if (weight.compareTo(chargeModeInfo.getLimitsWeight()) >= 0) {
            BigDecimal firstPrice = areaDto.getFirstWeight();
            returnEo.setFirstPrice(firstPrice);
            returnEo.setFirstPricePer(firstPrice);
            BigDecimal firstWeight = chargeModeInfo.getFirstWeight();
            BigDecimal continuationPriceOne = chargeModeInfo.getLimitsWeight().subtract(firstWeight).multiply(areaDto.getContinuationWeightOne());
            returnEo.setContinuedOne(continuationPriceOne);
            returnEo.setContinuedOnePer(areaDto.getContinuationWeightOne());
            BigDecimal continuationPriceTwo = weight.subtract(chargeModeInfo.getLimitsWeight()).multiply(areaDto.getContinuationWeightTwo());
            returnEo.setContinuedTwo(continuationPriceTwo);
            returnEo.setContinuedTwoPer(areaDto.getContinuationWeightTwo());
        } else {
            BigDecimal firstPrice = areaDto.getFirstWeight();
            returnEo.setFirstPrice(firstPrice);
            returnEo.setFirstPricePer(firstPrice);
            BigDecimal firstWeight = chargeModeInfo.getFirstWeight();
            BigDecimal continuationPriceOne = weight.subtract(firstWeight).multiply(areaDto.getContinuationWeightOne());
            returnEo.setContinuedOne(continuationPriceOne);
            returnEo.setContinuedOnePer(areaDto.getContinuationWeightOne());
        }
    }
}

