/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.biz.config.SapPullRateLimitProperties;
import com.dtyunxi.tcbj.biz.service.ISapPullRateLimitService;
import com.dtyunxi.tcbj.dao.eo.SaleOrderApportionEo;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderApportionMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SapPullRateLimitServiceImpl
implements ISapPullRateLimitService {
    private static final Logger logger = LoggerFactory.getLogger(SapPullRateLimitServiceImpl.class);
    private static final int BATCH_SIZE = 200;
    @Resource
    private SapPullRateLimitProperties rateLimitProperties;
    @Resource
    private SaleOrderApportionMapper saleOrderApportionMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeRateLimit() {
        int batchCount;
        List batch;
        int i;
        List batches;
        if (!this.rateLimitProperties.getEnabled().booleanValue()) {
            logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7\u672c\u6b21\u8c03\u5ea6");
            return;
        }
        int maxOrdersPerHour = this.rateLimitProperties.getMaxOrdersPerHour();
        int currentExposedOrdersCount = this.getExposedOrdersCount();
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u914d\u7f6e: \u6bcf\u5c0f\u65f6\u6700\u5927{}\u5355", (Object)maxOrdersPerHour);
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5f53\u524d\u5df2\u66b4\u9732\u603b\u6570(extension.pullable='1'): {}\u5355", (Object)currentExposedOrdersCount);
        if (currentExposedOrdersCount > maxOrdersPerHour) {
            int exceedingCount = currentExposedOrdersCount - maxOrdersPerHour;
            logger.warn("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5f53\u524d\u5df2\u66b4\u9732\u603b\u6570({})\u8d85\u8fc7\u914d\u7f6e\u91cf({})\uff0c\u8d85\u51fa{}\u5355\uff0c\u5f00\u59cb\u5206\u6279\u6536\u56de", new Object[]{currentExposedOrdersCount, maxOrdersPerHour, exceedingCount});
            List exceedingOrders = this.saleOrderApportionMapper.selectExposedOrdersExceedingLimit(exceedingCount);
            if (CollectionUtil.isNotEmpty((Collection)exceedingOrders)) {
                List exceedingOrderIds = exceedingOrders.stream().map(BaseEo::getId).collect(Collectors.toList());
                int totalRevokedCount = 0;
                batches = CollUtil.split(exceedingOrderIds, (int)200);
                logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u8d85\u51fa\u90e8\u5206\u5171{}\u5355\uff0c\u5206\u4e3a{}\u6279\u5904\u7406\uff0c\u6bcf\u6279\u6700\u591a{}\u5355", new Object[]{exceedingOrderIds.size(), batches.size(), 200});
                for (i = 0; i < batches.size(); ++i) {
                    batch = (List)batches.get(i);
                    batchCount = this.saleOrderApportionMapper.batchSetExtensionPullable(batch, "0");
                    logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u7b2c{}/{}\u6279\u5904\u7406\u5b8c\u6210\uff0c\u672c\u6279\u8bbe\u7f6eextension.pullable='0'\u5171{}\u5355\uff0c\u7d2f\u8ba1{}\u5355", new Object[]{i + 1, batches.size(), batchCount, totalRevokedCount += batchCount});
                }
                logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5df2\u8bbe\u7f6e{}\u5355\u7684extension.pullable='0'\uff0c\u5171\u5904\u7406{}\u6279", (Object)totalRevokedCount, (Object)batches.size());
                currentExposedOrdersCount = this.getExposedOrdersCount();
                logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u6536\u56de\u540e\u5f53\u524d\u5df2\u66b4\u9732\u603b\u6570: {}\u5355, \u914d\u7f6e\u91cf: {}\u5355", (Object)currentExposedOrdersCount, (Object)maxOrdersPerHour);
            }
        }
        int remainingQuota = maxOrdersPerHour - currentExposedOrdersCount;
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5269\u4f59\u53ef\u66b4\u9732\u989d\u5ea6: {}\u5355", (Object)remainingQuota);
        if (remainingQuota <= 0) {
            logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5f53\u524d\u5df2\u66b4\u9732\u603b\u6570({})\u5df2\u8fbe\u5230\u914d\u7f6e\u91cf({})\uff0c\u4e0d\u518d\u66b4\u9732\u65b0\u5355\u636e", (Object)currentExposedOrdersCount, (Object)maxOrdersPerHour);
            return;
        }
        List pendingOrders = this.saleOrderApportionMapper.selectPendingOrdersForExposure(remainingQuota);
        if (CollectionUtil.isEmpty((Collection)pendingOrders)) {
            logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u6ca1\u6709\u5f85\u66b4\u9732\u7684\u5355\u636e");
            return;
        }
        List orderIds = pendingOrders.stream().map(BaseEo::getId).collect(Collectors.toList());
        int totalExposed = 0;
        batches = CollUtil.split(orderIds, (int)200);
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5f85\u66b4\u9732\u5355\u636e\u5171{}\u5355\uff0c\u5206\u4e3a{}\u6279\u5904\u7406\uff0c\u6bcf\u6279\u6700\u591a{}\u5355", new Object[]{orderIds.size(), batches.size(), 200});
        for (i = 0; i < batches.size(); ++i) {
            batch = (List)batches.get(i);
            batchCount = this.saleOrderApportionMapper.batchSetExtensionPullable(batch, "1");
            logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u7b2c{}/{}\u6279\u5904\u7406\u5b8c\u6210\uff0c\u672c\u6279\u8bbe\u7f6eextension.pullable='1'\u5171{}\u5355\uff0c\u7d2f\u8ba1{}\u5355", new Object[]{i + 1, batches.size(), batchCount, totalExposed += batchCount});
        }
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u672c\u6b21\u8bbe\u7f6eextension.pullable='1'\u7684\u8ba2\u5355\u6570\u91cf: {}", (Object)totalExposed);
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u66b4\u9732\u540e\u72b6\u6001: \u5f53\u524d\u5df2\u66b4\u9732\u603b\u6570: {}\u5355, \u914d\u7f6e\u91cf: {}\u5355", (Object)(currentExposedOrdersCount + totalExposed), (Object)maxOrdersPerHour);
        this.logOrderTypeStatistics(pendingOrders);
    }

    @Override
    public int calculateRemainingQuota() {
        int maxOrdersPerHour = this.rateLimitProperties.getMaxOrdersPerHour();
        int exposedCount = this.getExposedCountInLastHour();
        return Math.max(0, maxOrdersPerHour - exposedCount);
    }

    @Override
    public int getExposedCountInLastHour() {
        return this.saleOrderApportionMapper.countExposedInLastHour();
    }

    @Override
    public int getExposedOrdersCount() {
        return this.saleOrderApportionMapper.countExposedOrders();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int exposeOrders(List<Long> orderIds) {
        logger.warn("exposeOrders\u65b9\u6cd5\u5df2\u5e9f\u5f03\uff0c\u9650\u6d41\u63a7\u5236\u901a\u8fc7extension.pullable\u5b9e\u73b0");
        return 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualTrigger() {
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u624b\u52a8\u89e6\u53d1\u6267\u884c");
        this.executeRateLimit();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int revokeExposureStatus(List<Long> orderIds) {
        logger.warn("revokeExposureStatus\u65b9\u6cd5\u5df2\u5e9f\u5f03\uff0c\u9650\u6d41\u63a7\u5236\u901a\u8fc7extension.pullable\u5b9e\u73b0");
        return 0;
    }

    private void logOrderTypeStatistics(List<SaleOrderApportionEo> orders) {
        if (CollectionUtil.isEmpty(orders)) {
            return;
        }
        Map<String, Long> typeCountMap = orders.stream().collect(Collectors.groupingBy(order -> order.getType() != null ? order.getType() : "UNKNOWN", Collectors.counting()));
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u672c\u6b21\u66b4\u9732\u5355\u636e\u7c7b\u578b\u5206\u5e03: {}", typeCountMap);
    }
}

