/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticInfoStatusEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.OvertimeFlagEnum;
import com.dtyunxi.tcbj.api.dto.request.AllocationLogisticsQueryDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticsInReportQueryDto;
import com.dtyunxi.tcbj.api.dto.response.AllocationLogisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogisticsInReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogisticsStatisticsRespDto;
import com.dtyunxi.tcbj.biz.service.query.ILogisticsInReportService;
import com.dtyunxi.tcbj.biz.utils.DateUtils;
import com.dtyunxi.tcbj.dao.das.CsOtherStorageOrderDas;
import com.dtyunxi.tcbj.dao.das.FinLogisticsReportDas;
import com.dtyunxi.tcbj.dao.das.InventorySupplierDas;
import com.dtyunxi.tcbj.dao.das.LogisticInTransitDas;
import com.dtyunxi.tcbj.dao.das.OutNoticeOrderDas;
import com.dtyunxi.tcbj.dao.das.OutPlannedOrderDas;
import com.dtyunxi.tcbj.dao.das.OutResultOrderDas;
import com.dtyunxi.tcbj.dao.das.ReWarehouseAddressDas;
import com.dtyunxi.tcbj.dao.eo.CsShipmenetEnterpriseEo;
import com.dtyunxi.tcbj.dao.eo.CsWarehouseAddressEo;
import com.dtyunxi.tcbj.dao.eo.InventorySupplierEo;
import com.dtyunxi.tcbj.dao.eo.LogisticInTransitEo;
import com.dtyunxi.tcbj.dao.eo.OutNoticeOrderEo;
import com.dtyunxi.tcbj.dao.eo.OutPlannedOrderEo;
import com.dtyunxi.tcbj.dao.eo.es.CsOtherStorageOrderEo;
import com.dtyunxi.tcbj.dao.mapper.CsShipmenetEnterpriseMapper;
import com.dtyunxi.tcbj.dao.vo.OrderInfoVo;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import io.jsonwebtoken.lang.Collections;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogisticsInReportServiceImpl
implements ILogisticsInReportService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsInReportServiceImpl.class);
    @Resource
    private OutResultOrderDas outResultOrderDas;
    @Resource
    private LogisticInTransitDas logisticInTransitDas;
    @Resource
    private OutNoticeOrderDas outNoticeOrderDas;
    @Resource
    private ReWarehouseAddressDas reWarehouseAddressDas;
    @Resource
    private CsOtherStorageOrderDas otherStorageOrderDas;
    @Resource
    private OutPlannedOrderDas outPlannedOrderDas;
    @Resource
    private InventorySupplierDas inventorySupplierDas;
    @Resource
    private FinLogisticsReportDas finLogisticsReportDas;
    @Resource
    private ExecutorService statisticsExecutor;
    @Autowired
    CsShipmenetEnterpriseMapper shipmenetEnterpriseMapper;
    private static final List<String> SALE_ORDER_TYPE = Lists.newArrayList();
    private static final List<String> TRANSFER_ORDER_TYPE = Lists.newArrayList();
    private static final List<String> PRODUCTION_PROCUREMENT_ORDER_TYPE = Lists.newArrayList();
    private static final List<String> OTHER_ORDER_TYPE = Lists.newArrayList();

    @Override
    public RestResponse<PageInfo<LogisticsInReportRespDto>> getLogisticsInReportListPage(LogisticsInReportQueryDto logisticsInReportReqDto) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List csShipmenetEnterpriseEos;
        if (StringUtils.isNotBlank((CharSequence)logisticsInReportReqDto.getCreateTimeEnd())) {
            logisticsInReportReqDto.setCreateTimeEnd(String.format("%s %s", logisticsInReportReqDto.getCreateTimeEnd(), "23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)logisticsInReportReqDto.getEstimatedTimeEnd())) {
            logisticsInReportReqDto.setEstimatedTimeEnd(String.format("%s %s", logisticsInReportReqDto.getEstimatedTimeEnd(), "23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)logisticsInReportReqDto.getActualArrivalTimeEnd())) {
            logisticsInReportReqDto.setActualArrivalTimeEnd(String.format("%s %s", logisticsInReportReqDto.getActualArrivalTimeEnd(), "23:59:59"));
        }
        if (null == logisticsInReportReqDto.getShipmentEnterpriseType()) {
            logisticsInReportReqDto.setShipmentEnterpriseType(Integer.valueOf(1));
        }
        if (CollectionUtils.isEmpty((Collection)(csShipmenetEnterpriseEos = this.shipmenetEnterpriseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsShipmenetEnterpriseEo.class).eq(CsShipmenetEnterpriseEo::getShipmentEnterpriseType, (Object)logisticsInReportReqDto.getShipmentEnterpriseType())).eq(StringUtils.isNotBlank((CharSequence)logisticsInReportReqDto.getLogisticsCompany()), CsShipmenetEnterpriseEo::getShipmentEnterpriseCode, (Object)logisticsInReportReqDto.getLogisticsCompany())).eq(BaseEo::getDr, (Object)YesNoHelper.NO))))) {
            return new RestResponse((Object)new PageInfo());
        }
        List shipmentEnterpriseCodes = csShipmenetEnterpriseEos.stream().map(CsShipmenetEnterpriseEo::getShipmentEnterpriseCode).distinct().collect(Collectors.toList());
        logisticsInReportReqDto.setLogisticsCompanyList(shipmentEnterpriseCodes);
        Page page = this.outResultOrderDas.queryLogisticsInReportListPage(logisticsInReportReqDto);
        List respDtoList = page.getResult();
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            for (LogisticsInReportRespDto dto : respDtoList) {
                String status = dto.getStatus();
                dto.setStatus((String)LogisticInfoStatusEnum.map.get(status));
                dto.setOvertimeFlag((String)OvertimeFlagEnum.map.get(dto.getOvertimeStatus()));
                if (!StringUtils.isNotBlank((CharSequence)dto.getLogisticsNo()) || !StringUtils.isBlank((CharSequence)dto.getStatus())) continue;
                dto.setStatus(LogisticInfoStatusEnum.NO_MSG.getName());
            }
        }
        PageInfo result = new PageInfo();
        PropertyUtils.copyProperties((Object)result, (Object)page);
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            result.setList(respDtoList);
        }
        return new RestResponse((Object)result);
    }

    private Map<String, OrderInfoVo> asyncQueryOrderInfo(Set<String> orderNos) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.finLogisticsReportDas.queryOrderInfo(new ArrayList(orderNos)), this.statisticsExecutor);
        try {
            List orderInfoVos = future.get();
            if (CollectionUtil.isEmpty((Collection)orderInfoVos)) {
                return null;
            }
            return orderInfoVos.stream().collect(Collectors.toMap(OrderInfoVo::getOrderNo, Function.identity(), (k1, k2) -> k1));
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, InventorySupplierEo> queryPlannedOrderSupplier(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List plannedOrderEos = ((ExtQueryChainWrapper)this.outPlannedOrderDas.filter().in((Object)"order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)plannedOrderEos)) {
            return Maps.newHashMap();
        }
        Map<String, Long> map = plannedOrderEos.stream().filter(i -> i.getSupplierId() != null).collect(Collectors.toMap(OutPlannedOrderEo::getOrderNo, o -> o.getSupplierId(), (k1, k2) -> k1));
        if (CollectionUtil.isEmpty(map)) {
            return Maps.newHashMap();
        }
        List inventorySupplierEos = this.inventorySupplierDas.selectByIds((List)map.values());
        if (CollectionUtil.isEmpty((Collection)inventorySupplierEos)) {
            return Maps.newHashMap();
        }
        HashMap supplierMap = Maps.newHashMap();
        Map inventorySupplierEoMap = inventorySupplierEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        map.forEach((orderNo, supplierId) -> {
            if (inventorySupplierEoMap.containsKey(supplierId)) {
                supplierMap.put(orderNo, inventorySupplierEoMap.get(supplierId));
            }
        });
        return supplierMap;
    }

    private Map<String, CsWarehouseAddressEo> queryWarehouseAddress(List<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return null;
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reWarehouseAddressDas.filter().eq((Object)"valid_flag", (Object)"enable")).eq((Object)"warehouse_classify", (Object)"physics")).in((Object)"warehouse_code", codes)).list();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return list.stream().collect(Collectors.toMap(CsWarehouseAddressEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
    }

    private void handleOtherStorageShippingInformation(LogisticsInReportRespDto dto, Map<String, CsOtherStorageOrderEo> warehouseAddressMap) {
        if (Collections.isEmpty(warehouseAddressMap)) {
            return;
        }
        if (!warehouseAddressMap.containsKey(dto.getRelevanceNo())) {
            return;
        }
        CsOtherStorageOrderEo otherStorageOrderEo = warehouseAddressMap.get(dto.getRelevanceNo());
        if (StringUtils.isNotBlank((CharSequence)otherStorageOrderEo.getProvinceName())) {
            dto.setProvince(otherStorageOrderEo.getProvinceName());
        }
        if (StringUtils.isNotBlank((CharSequence)otherStorageOrderEo.getCityName())) {
            dto.setCity(otherStorageOrderEo.getCityName());
        }
        if (StringUtils.isNotBlank((CharSequence)otherStorageOrderEo.getAreaName())) {
            dto.setDistrict(otherStorageOrderEo.getAreaName());
        }
        dto.setConsignee(otherStorageOrderEo.getConsignee());
        dto.setAddress(otherStorageOrderEo.getAddress());
        dto.setPhone(otherStorageOrderEo.getPhone());
    }

    private void handleSupplierInfor(LogisticsInReportRespDto dto, Map<String, InventorySupplierEo> supplierEoMap) {
        if (Collections.isEmpty(supplierEoMap)) {
            return;
        }
        if (!supplierEoMap.containsKey(dto.getRelevanceNo())) {
            return;
        }
        InventorySupplierEo supplierEo = supplierEoMap.get(dto.getRelevanceNo());
        if (StringUtils.isNotBlank((CharSequence)supplierEo.getProvince())) {
            dto.setProvince(supplierEo.getProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)supplierEo.getCity())) {
            dto.setCity(supplierEo.getCity());
        }
        if (StringUtils.isNotBlank((CharSequence)supplierEo.getDistrict())) {
            dto.setDistrict(supplierEo.getDistrict());
        }
        dto.setConsignee(supplierEo.getLinkman());
        dto.setAddress(supplierEo.getAddress());
        dto.setPhone(supplierEo.getPhoneNum());
    }

    private void handleWarehouseShippingInformation(LogisticsInReportRespDto dto, Map<String, CsWarehouseAddressEo> warehouseAddressMap) {
        if (Collections.isEmpty(warehouseAddressMap)) {
            return;
        }
        if (!warehouseAddressMap.containsKey(dto.getInPhysicsWarehouseCode())) {
            return;
        }
        CsWarehouseAddressEo addressEo = warehouseAddressMap.get(dto.getInPhysicsWarehouseCode());
        dto.setConsignee(addressEo.getContacts());
        dto.setAddress(addressEo.getDetailAddress());
        dto.setPhone(addressEo.getPhone());
        if (StringUtils.isNotBlank((CharSequence)addressEo.getProvince())) {
            dto.setProvince(addressEo.getProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)addressEo.getProvince())) {
            dto.setCity(addressEo.getProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)addressEo.getDistrict())) {
            dto.setDistrict(addressEo.getDistrict());
        }
    }

    private void handleSaleOrderShippingInformation(LogisticsInReportRespDto dto, Map<String, OutNoticeOrderEo> saleOrderMap) {
        if (Collections.isEmpty(saleOrderMap)) {
            return;
        }
        if (!saleOrderMap.containsKey(dto.getPreOrderNo())) {
            return;
        }
        OutNoticeOrderEo outNoticeOrderEo = saleOrderMap.get(dto.getPreOrderNo());
        ContactDto jsonObject = (ContactDto)JSONObject.parseObject((String)outNoticeOrderEo.getExtension(), ContactDto.class);
        dto.setConsignee(jsonObject.getReciveName());
        dto.setAddress(jsonObject.getAddress());
        dto.setPhone(jsonObject.getPhone());
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getProvince())) {
            dto.setProvince(jsonObject.getProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getProvince())) {
            dto.setCity(jsonObject.getProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getDistrict())) {
            dto.setDistrict(jsonObject.getDistrict());
        }
    }

    private Map<String, OutNoticeOrderEo> queryOutNoticeOrderEo(List<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return null;
        }
        List eos = ((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().in((Object)"document_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)eos)) {
            return null;
        }
        return eos.stream().collect(Collectors.toMap(OutNoticeOrderEo::getDocumentNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsOtherStorageOrderEo> queryCsOtherStorageOrderEo(List<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return null;
        }
        List eos = ((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().in((Object)"storage_order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)eos)) {
            return null;
        }
        return eos.stream().collect(Collectors.toMap(CsOtherStorageOrderEo::getStorageOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private void setOvertimeFlag(LogisticsInReportRespDto dto) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> generateLogisticsInReport(String startDate, String endDate) {
        List list = this.outResultOrderDas.selectLogisticsInReportData(startDate, endDate);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (LogisticInTransitEo logisticInTransitEo : list) {
                this.logisticInTransitDas.insert((BaseEo)logisticInTransitEo);
            }
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<AllocationLogisticsRespDto>> getAllocationLogisticsPage(AllocationLogisticsQueryDto allocationLogisticsQueryDto) {
        Page page;
        List respDtoList;
        if (StringUtils.isNotBlank((CharSequence)allocationLogisticsQueryDto.getCreateTimeEnd())) {
            allocationLogisticsQueryDto.setCreateTimeEnd(String.format("%s %s", allocationLogisticsQueryDto.getCreateTimeEnd(), "23:59:59"));
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtoList = (page = this.outResultOrderDas.queryAllocationLogisticsPage(allocationLogisticsQueryDto)).getResult()))) {
            respDtoList.stream().forEach(i -> {
                if (!Objects.equals(i.getStatus(), "4")) {
                    i.setRealArriveimeStart(null);
                }
            });
            for (AllocationLogisticsRespDto dto : respDtoList) {
                String status = dto.getStatus();
                dto.setStatus((String)LogisticInfoStatusEnum.map.get(status));
            }
        }
        PageInfo result = new PageInfo();
        BeanUtil.copyProperties((Object)page, (Object)result, (String[])new String[0]);
        result.setList(respDtoList);
        return new RestResponse((Object)result);
    }

    @Override
    public List<LogisticsStatisticsRespDto> queryLogisticsStatistics(Integer type) {
        String beginDate = null;
        if (Objects.equals(1, type)) {
            beginDate = DateUtil.format((Date)DateUtil.addDay((Date)DateUtils.getStartTime(), (int)-7), (String)"yyyy-MM-dd HH:mm:ss");
        } else if (Objects.equals(2, type)) {
            beginDate = DateUtil.format((Date)DateUtil.addDay((Date)DateUtils.getStartTime(), (int)-30), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (beginDate == null) {
            return Lists.newArrayList();
        }
        List<LogisticsStatisticsRespDto> logisticsStatisticsRespDtos = this.outResultOrderDas.queryLogisticsStatistics(beginDate);
        logisticsStatisticsRespDtos = logisticsStatisticsRespDtos.stream().filter(e -> e.getErrorNum() != 0 || e.getOvertimeReceiptNum() != 0 || e.getOvertimeUnReceiptNum() != 0).collect(Collectors.toList());
        return logisticsStatisticsRespDtos;
    }

    @Override
    public RestResponse<PageInfo<LogisticsInReportRespDto>> queryLogisticsInReportDetailsPage(LogisticsInReportQueryDto logisticsInReportReqDto) {
        List csShipmenetEnterpriseEos;
        if (StringUtils.isNotBlank((CharSequence)logisticsInReportReqDto.getCreateTimeEnd())) {
            logisticsInReportReqDto.setCreateTimeEnd(String.format("%s %s", logisticsInReportReqDto.getCreateTimeEnd(), "23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)logisticsInReportReqDto.getEstimatedTimeEnd())) {
            logisticsInReportReqDto.setEstimatedTimeEnd(String.format("%s %s", logisticsInReportReqDto.getEstimatedTimeEnd(), "23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)logisticsInReportReqDto.getActualArrivalTimeEnd())) {
            logisticsInReportReqDto.setActualArrivalTimeEnd(String.format("%s %s", logisticsInReportReqDto.getActualArrivalTimeEnd(), "23:59:59"));
        }
        if (null == logisticsInReportReqDto.getShipmentEnterpriseType()) {
            logisticsInReportReqDto.setShipmentEnterpriseType(Integer.valueOf(1));
        }
        if (CollectionUtils.isEmpty((Collection)(csShipmenetEnterpriseEos = this.shipmenetEnterpriseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsShipmenetEnterpriseEo.class).eq(CsShipmenetEnterpriseEo::getShipmentEnterpriseType, (Object)logisticsInReportReqDto.getShipmentEnterpriseType())).eq(StringUtils.isNotBlank((CharSequence)logisticsInReportReqDto.getLogisticsCompany()), CsShipmenetEnterpriseEo::getShipmentEnterpriseCode, (Object)logisticsInReportReqDto.getLogisticsCompany())).eq(BaseEo::getDr, (Object)YesNoHelper.NO))))) {
            return new RestResponse((Object)new PageInfo());
        }
        List shipmentEnterpriseCodes = csShipmenetEnterpriseEos.stream().map(CsShipmenetEnterpriseEo::getShipmentEnterpriseCode).distinct().collect(Collectors.toList());
        logisticsInReportReqDto.setLogisticsCompanyList(shipmentEnterpriseCodes);
        PageInfo page = this.outResultOrderDas.queryLogisticsInReportDetailsPage(logisticsInReportReqDto);
        List respDtoList = page.getList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            respDtoList.stream().forEach(i -> {
                if (!Objects.equals(i.getStatus(), "4")) {
                    i.setRealArriveimeStart(null);
                }
            });
            for (LogisticsInReportRespDto dto : respDtoList) {
                String status = dto.getStatus();
                dto.setStatus((String)LogisticInfoStatusEnum.map.get(status));
                dto.setOvertimeFlag((String)OvertimeFlagEnum.map.get(dto.getOvertimeStatus()));
            }
        }
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)page, (Object)result, (String[])new String[]{"list"});
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            result.setList(respDtoList);
        }
        return new RestResponse((Object)result);
    }

    public static void main(String[] args) {
        Date preArriveimeStart = DateUtil.parse((String)"2022-08-01", (String)"yyyy-MM-dd");
        System.out.println(new Date().after(preArriveimeStart));
    }

    static {
        SALE_ORDER_TYPE.add("order_sales_out");
        SALE_ORDER_TYPE.add("order_sales_refund");
        SALE_ORDER_TYPE.add("nutrition_integral");
        SALE_ORDER_TYPE.add("claim_reissue");
        SALE_ORDER_TYPE.add("claim_posting");
        SALE_ORDER_TYPE.add("agency_order");
        SALE_ORDER_TYPE.add("shoppe_order");
        SALE_ORDER_TYPE.add("integral_order");
        SALE_ORDER_TYPE.add("replenishment_order");
        SALE_ORDER_TYPE.add("activity_order");
        SALE_ORDER_TYPE.add("customer_refunding_order");
        SALE_ORDER_TYPE.add("compensation_order");
        SALE_ORDER_TYPE.add("quality_refunding_order");
        SALE_ORDER_TYPE.add("replenish_order");
        SALE_ORDER_TYPE.add("common_order");
        SALE_ORDER_TYPE.add("share_goods_order");
        TRANSFER_ORDER_TYPE.add("allot_out");
        TRANSFER_ORDER_TYPE.add("allot_out_only");
        TRANSFER_ORDER_TYPE.add("allot_in_only");
        TRANSFER_ORDER_TYPE.add("allot_only_record");
        TRANSFER_ORDER_TYPE.add("internal_deal_return");
        TRANSFER_ORDER_TYPE.add("sale_return_internal_deal");
        TRANSFER_ORDER_TYPE.add("internal_deal");
        TRANSFER_ORDER_TYPE.add("inspection_qualified");
        TRANSFER_ORDER_TYPE.add("allot_lose_efficacy");
        TRANSFER_ORDER_TYPE.add("allot_bc_efficacy");
        TRANSFER_ORDER_TYPE.add("purchase");
        TRANSFER_ORDER_TYPE.add("outsource");
        TRANSFER_ORDER_TYPE.add("production");
        PRODUCTION_PROCUREMENT_ORDER_TYPE.add("purchase_refund");
        PRODUCTION_PROCUREMENT_ORDER_TYPE.add("outsource_refund");
        PRODUCTION_PROCUREMENT_ORDER_TYPE.add("product_repair");
        OTHER_ORDER_TYPE.add("other_in");
        OTHER_ORDER_TYPE.add("other_out");
    }
}

