/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingCostReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingCostReportUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingExpenseQueryDto;
import com.dtyunxi.tcbj.api.dto.request.SortingExpenseReqDto;
import com.dtyunxi.tcbj.api.dto.request.TaskQueryParamsDro;
import com.dtyunxi.tcbj.api.dto.response.DailyDeliveryFeeFilterExtConfigRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.SortingCostReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.SortingExpenseRespDto;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryFeeFilterExtConfigService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseService;
import com.dtyunxi.tcbj.dao.das.AdjustmentInventoryDas;
import com.dtyunxi.tcbj.dao.das.CsOtherStorageOrderDas;
import com.dtyunxi.tcbj.dao.das.FeeAttributionConfigDas;
import com.dtyunxi.tcbj.dao.das.ItemExtendDas;
import com.dtyunxi.tcbj.dao.das.LogicWarehouseDas;
import com.dtyunxi.tcbj.dao.das.OutNoticeOrderDas;
import com.dtyunxi.tcbj.dao.das.OutPlannedOrderDas;
import com.dtyunxi.tcbj.dao.das.OutResultOrderDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.das.ShipmentEnterpriseDas;
import com.dtyunxi.tcbj.dao.das.SortingContractDas;
import com.dtyunxi.tcbj.dao.das.SortingExpenseDas;
import com.dtyunxi.tcbj.dao.eo.AdjustmentInventoryEo;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.FeeAttributionConfigEo;
import com.dtyunxi.tcbj.dao.eo.ItemExtendEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.OutPlannedOrderEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.eo.ShipmentEnterpriseEo;
import com.dtyunxi.tcbj.dao.eo.SortingContractEo;
import com.dtyunxi.tcbj.dao.eo.SortingExpenseEo;
import com.dtyunxi.tcbj.dao.eo.es.CsOtherStorageOrderEo;
import com.dtyunxi.tcbj.dao.vo.LogicWarehouseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.SaleBusinessTypeEnum;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryFeeFilterConfigService;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportService;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SortingExpenseServiceImpl
implements ISortingExpenseService {
    private static final Logger log = LoggerFactory.getLogger(SortingExpenseServiceImpl.class);
    private final Logger LOGGER = LoggerFactory.getLogger(SortingExpenseServiceImpl.class);
    private final String SORTING_EXPENSE_LOCK_KEY = "SORTING_EXPENSE_LOCK_KEY";
    @Resource
    private SortingExpenseDas sortingExpenseDas;
    @Resource
    private FeeAttributionConfigDas feeAttributionConfigDas;
    @Resource
    private SortingContractDas sortingContractDas;
    @Resource
    private LogicWarehouseDas logicWarehouseDas;
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private SaleOrderDas saleOrderDas;
    @Resource
    private OutPlannedOrderDas outPlannedOrderDas;
    @Resource
    private IcsShipmenetEnterpriseQueryApi icsShipmenetEnterpriseQueryApi;
    @Resource
    private CsOtherStorageOrderDas otherStorageOrderDas;
    @Resource
    private AdjustmentInventoryDas adjustmentInventoryDas;
    @Resource
    private IDailyDeliveryFeeFilterConfigService dailyDeliveryFeeFilterConfigService;
    @Resource
    private IDailyDeliveryFeeFilterExtConfigService dailyDeliveryFeeFilterExtConfigService;
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;
    @Resource
    private IDailyDeliveryReportService deliveryReportService;
    @Resource
    private ExecutorService statisticsExecutor;
    @Resource
    private OutNoticeOrderDas outNoticeOrderDas;
    @Resource
    private OutResultOrderDas outResultOrderDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ShipmentEnterpriseDas shipmentEnterpriseDas;
    private static List<String> saleOrderBusinessType = Lists.newArrayList();
    private static List<String> transferOrderBusinessType = Lists.newArrayList();
    private static List<String> refundOrderBusinessType = Lists.newArrayList();

    @Override
    public PageInfo<SortingCostReportRespDto> getSortingCostReportListPage(SortingCostReportListPageReqDto dto) {
        Set<String> transferOrderNoList;
        List inWarehouseCodes;
        PageInfo page = this.sortingExpenseDas.getSortingCostReportListPage(dto);
        PageInfo pageInfo = new PageInfo();
        if (ObjectUtils.isEmpty((Object)page) || CollectionUtil.isEmpty((Collection)page.getList())) {
            return pageInfo;
        }
        List transferBizList = page.getList().stream().filter(o -> transferOrderBusinessType.contains(o.getBusinessType())).collect(Collectors.toList());
        Map<Object, Object> transferOrderEoMap = Maps.newHashMap();
        Map<Object, Object> transferInLogicWarehouseEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(transferBizList) && CollectionUtil.isNotEmpty(inWarehouseCodes = (transferOrderEoMap = this.queryTransferOrder(transferOrderNoList = transferBizList.stream().map(SortingExpenseRespDto::getRelevanceNo).collect(Collectors.toSet()))).values().stream().map(CsTransferOrderEo::getInLogicWarehouseCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList()))) {
            List inLogicWarehouseEos = this.logicWarehouseDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getWarehouseCode, inWarehouseCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            transferInLogicWarehouseEoMap = inLogicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        }
        Long abnormalNum = page.getList().stream().filter(item -> item.getAbnormal() == 1).count();
        BeanUtils.copyProperties((Object)page, (Object)pageInfo, (String[])new String[]{"list"});
        ArrayList respDtoList = Lists.newArrayList();
        for (SortingExpenseRespDto resp : page.getList()) {
            LogicWarehouseEo logicWarehouseEo;
            CsTransferOrderEo csTransferOrderEo;
            SortingCostReportRespDto respDto = new SortingCostReportRespDto();
            BeanUtils.copyProperties((Object)resp, (Object)respDto);
            respDto.setOutWarehouseTime(com.dtyunxi.util.DateUtil.format((Date)resp.getOutWarehouseTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            respDto.setWmsDocumentNo(resp.getWmsOrderNo());
            respDto.setDocumentNo(resp.getDocumentNo());
            respDto.setBusinessType(resp.getBusinessType());
            respDto.setOutWarehouse(resp.getOutLogicWarehouseName());
            respDto.setOutOrgName(resp.getOutOrganizationName());
            respDto.setInWarehouse(resp.getInLogicWarehouseName());
            respDto.setInOrgName(resp.getInOrganizationName());
            respDto.setCostAttribution(resp.getExpenseOrganizationName());
            respDto.setOutQuantity(ObjectUtils.isEmpty((Object)resp.getDoneQuantity()) ? null : String.valueOf(resp.getDoneQuantity().intValue()));
            respDto.setPackageNum(ObjectUtils.isEmpty((Object)resp.getBigRatio()) ? null : String.valueOf(resp.getBigRatio()));
            respDto.setSmallPackageNum(ObjectUtils.isEmpty((Object)resp.getSmallRatio()) ? null : String.valueOf(resp.getSmallRatio()));
            respDto.setLargeBox(ObjectUtils.isEmpty((Object)resp.getBigBoxNum()) ? null : String.valueOf(resp.getBigBoxNum().intValue()));
            respDto.setNumber(ObjectUtils.isEmpty((Object)resp.getBoxNum()) ? null : String.valueOf(resp.getBoxNum().intValue()));
            respDto.setSmallBox(ObjectUtils.isEmpty((Object)resp.getSmallBoxNum()) ? null : String.valueOf(resp.getSmallBoxNum().intValue()));
            respDto.setAdjustType(ObjectUtils.isEmpty((Object)resp.getAdjustType()) ? null : String.valueOf(resp.getAdjustType()));
            respDto.setPlatformAdjustAmount(ObjectUtils.isEmpty((Object)resp.getAdjustNum()) ? null : String.valueOf(resp.getAdjustNum().setScale(2, 4)));
            respDto.setRemark(resp.getAdjustRemarks());
            if (resp.getSortingNum() == null) {
                resp.setSortingNum(BigDecimal.ZERO);
            }
            Long adjustType = resp.getAdjustType();
            BigDecimal sortingNum = resp.getSortingNum();
            if (Objects.equals(1L, adjustType) && null != resp.getAdjustNum()) {
                sortingNum = sortingNum.add(resp.getAdjustNum());
            }
            if (Objects.equals(2L, adjustType) && null != resp.getAdjustNum()) {
                sortingNum = sortingNum.subtract(resp.getAdjustNum());
            }
            respDto.setTotalSortingFee(sortingNum.setScale(2, 4).toString());
            respDto.setImportUpdatePerson(resp.getImportUpdatePerson());
            if (!ObjectUtils.isEmpty((Object)resp.getImportUpdateTime())) {
                respDto.setImportUpdateTime(com.dtyunxi.util.DateUtil.format((Date)resp.getImportUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            respDto.setAbnormal(resp.getAbnormal());
            respDto.setAbnormalCauses(resp.getAbnormalCauses());
            respDto.setAbnormalNum(abnormalNum);
            respDto.setGoodsLongCode(resp.getLongCode());
            respDto.setGoodsName(resp.getCargoName());
            if (resp.getAbnormal() == null || Objects.equals(resp.getAbnormal(), 1)) {
                if (resp.getAdjustNum() == null) {
                    respDto.setPlatformAdjustAmount("/");
                }
                if (StringUtils.isBlank((CharSequence)resp.getAdjustRemarks())) {
                    respDto.setRemark("/");
                }
                respDto.setTotalSortingFee("/");
            }
            respDto.setExternalOrderNo(resp.getExternalOrderNo());
            respDto.setId(resp.getId());
            if (transferOrderBusinessType.contains(resp.getBusinessType()) && null != (csTransferOrderEo = (CsTransferOrderEo)transferOrderEoMap.get(resp.getRelevanceNo())) && null != (logicWarehouseEo = (LogicWarehouseEo)transferInLogicWarehouseEoMap.get(csTransferOrderEo.getInLogicWarehouseCode()))) {
                respDto.setInWarehouseCode(logicWarehouseEo.getWarehouseCode());
                respDto.setInWarehouse(logicWarehouseEo.getWarehouseName());
                respDto.setInOrgName(logicWarehouseEo.getOrganizationName());
            }
            respDto.setUpdateTime(resp.getUpdateTime());
            respDto.setUpdatePerson(resp.getUpdatePerson());
            respDtoList.add(respDto);
        }
        pageInfo.setList((List)respDtoList);
        return pageInfo;
    }

    private Map<String, SaleOrderEo> querySaleOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List saleOrderEos = ((ExtQueryChainWrapper)this.saleOrderDas.filter().in((Object)"sale_order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
            return Maps.newHashMap();
        }
        return saleOrderEos.stream().collect(Collectors.toMap(SaleOrderEo::getSaleOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, AdjustmentInventoryEo> asyncQueryAdjustmentInventory(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.queryQueryAdjustmentInventory(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u5f02\u6b65\u67e5\u8be2\u5728\u9014\u5e93\u5b58\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, AdjustmentInventoryEo> queryQueryAdjustmentInventory(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.adjustmentInventoryDas.filter().eq((Object)"source_type", (Object)"receiveResult")).eq((Object)"business_type", (Object)"in_transit_adjustment_out")).eq((Object)"adjustment_status", (Object)"completed")).in((Object)"relevance_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(AdjustmentInventoryEo::getRelevanceNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsOtherStorageOrderEo> queryOtherOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List saleOrderEos = ((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().in((Object)"storage_order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
            return Maps.newHashMap();
        }
        return saleOrderEos.stream().collect(Collectors.toMap(CsOtherStorageOrderEo::getStorageOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, OutPlannedOrderEo> querySaleRefundOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List saleOrderEos = ((ExtQueryChainWrapper)this.outPlannedOrderDas.filter().in((Object)"order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
            return Maps.newHashMap();
        }
        return saleOrderEos.stream().collect(Collectors.toMap(OutPlannedOrderEo::getOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsTransferOrderEo> queryTransferOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List<CsTransferOrderEo> eos = this.asyncQueryTransferOrder(orderNos);
        if (CollectionUtil.isEmpty(eos)) {
            return Maps.newHashMap();
        }
        return eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private List<CsTransferOrderEo> asyncQueryTransferOrder(Set<String> orderNos) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.getTransferOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u67e5\u8be2\u8c03\u62e8\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private List<CsTransferOrderEo> getTransferOrder(Set<String> orderNos) {
        List eos = ((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        return eos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeJobNew(TaskQueryParamsDro taskQueryParamsDro) {
        this.LOGGER.info("\u65b0\u5206\u62e3\u8d39\u7528\u62a5\u8868\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)taskQueryParamsDro));
        if (StringUtils.isBlank((CharSequence)taskQueryParamsDro.getStartDateStr()) && StringUtils.isBlank((CharSequence)taskQueryParamsDro.getEndDateStr()) && StringUtils.isBlank((CharSequence)taskQueryParamsDro.getDocumentNo()) && StringUtils.isBlank((CharSequence)taskQueryParamsDro.getLongCode())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        }
        List sortingExpenseOldList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().eq((Object)"dr", (Object)0)).ge(StringUtils.isNotBlank((CharSequence)taskQueryParamsDro.getStartDateStr()), (Object)"out_warehouse_time", (Object)taskQueryParamsDro.getStartDateStr())).le(StringUtils.isNotBlank((CharSequence)taskQueryParamsDro.getEndDateStr()), (Object)"out_warehouse_time", (Object)taskQueryParamsDro.getEndDateStr())).eq(StringUtils.isNotBlank((CharSequence)taskQueryParamsDro.getDocumentNo()), (Object)"document_no", (Object)taskQueryParamsDro.getDocumentNo())).eq(StringUtils.isNotBlank((CharSequence)taskQueryParamsDro.getLongCode()), (Object)"long_code", (Object)taskQueryParamsDro.getLongCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)sortingExpenseOldList)) {
            List delIds = sortingExpenseOldList.stream().map(BaseEo::getId).collect(Collectors.toList());
            log.info("\u5220\u9664\u4e45\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(delIds));
            this.sortingExpenseDas.logicDeleteByIds(delIds);
        }
        List shipmentList = ((ExtQueryChainWrapper)this.shipmentEnterpriseDas.filter().eq((Object)"dr", (Object)0)).list(Integer.valueOf(1000));
        Map shipmentMap = Optional.ofNullable(shipmentList).map(m -> shipmentList.stream().collect(Collectors.toMap(ShipmentEnterpriseEo::getShipmentEnterpriseCode, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        log.info("\u67e5\u8be2\u7269\u6d41\u5546\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)shipmentMap));
        List sortingExpenseEos = this.sortingExpenseDas.querySortingExpenseDataNew(taskQueryParamsDro);
        this.LOGGER.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEos));
        if (CollectionUtil.isEmpty((Collection)sortingExpenseEos)) {
            log.info("\u65e0\u6570\u636e\u9700\u8981\u751f\u6210");
            return;
        }
        HashSet whCodes = Sets.newHashSet();
        HashSet saleOrderNos = Sets.newHashSet();
        HashSet transferOrderNos = Sets.newHashSet();
        HashSet otherOrderNos = Sets.newHashSet();
        HashSet refundOrderNos = Sets.newHashSet();
        sortingExpenseEos.forEach(i -> {
            whCodes.add(i.getOutLogicWarehouseCode());
            String businessType = i.getBusinessType();
            if (SaleBusinessTypeEnum.internalSalesOrderTypes().containsKey(businessType) || SaleBusinessTypeEnum.nutritionistOrderTypes().containsKey(businessType)) {
                saleOrderNos.add(i.getRelevanceNo());
            } else if (refundOrderBusinessType.contains(businessType)) {
                refundOrderNos.add(i.getRelevanceNo());
            } else if (Objects.equals(businessType, CsPcpBusinessTypeEnum.OTHER_OUT.getCode())) {
                otherOrderNos.add(i.getRelevanceNo());
            } else if (transferOrderBusinessType.contains(businessType)) {
                transferOrderNos.add(i.getRelevanceNo());
            }
        });
        Map<String, CsTransferOrderEo> transferOrderMap = this.queryTransferOrder(transferOrderNos);
        Map<String, SaleOrderEo> saleOrderEoMap = this.querySaleOrder(saleOrderNos);
        Map<String, OutPlannedOrderEo> saleRefundEoMap = this.querySaleRefundOrder(refundOrderNos);
        Map<String, CsOtherStorageOrderEo> otherOrderMap = this.queryOtherOrder(otherOrderNos);
        Map<String, AdjustmentInventoryEo> adjustmentInventoryEoMap = this.asyncQueryAdjustmentInventory(transferOrderNos);
        List whLists = this.logicWarehouseDas.selectByWarehouse((List)Lists.newArrayList((Iterable)whCodes), "physics");
        Map whMap = whLists.stream().collect(Collectors.toMap(LogicWarehouseVo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        this.LOGGER.info("whMap______{}", (Object)JSON.toJSONString(whMap));
        List<DailyDeliveryFeeFilterExtConfigRespDto> feeFilter = this.dailyDeliveryFeeFilterExtConfigService.queryModuleCode(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
        log.info("\u67e5\u8be2\u5254\u9664\u8ba1\u8d39\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(feeFilter));
        Date time = new Date();
        ArrayList insertEos = Lists.newArrayList();
        for (SortingExpenseEo sortingExpenseEo : sortingExpenseEos) {
            Long num;
            log.info("\u5206\u62e3\u8d39\u7528\u751f\u6210\u5355\u636e\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
            sortingExpenseEo.setAbnormal(Integer.valueOf(0));
            sortingExpenseEo.setPlacedFlag(Integer.valueOf(0));
            sortingExpenseEo.setBillingFeeFlag(Integer.valueOf(1));
            sortingExpenseEo.setImportUpdateTime(time);
            sortingExpenseEo.setImportUpdatePerson("\u7cfb\u7edf");
            log.info("\u5982\u679c\u6ca1\u6709\u957f\u7f16\u7801,\u5373\u65e0\u5546\u54c1\u4fe1\u606f,\u4e0d\u8ba1\u8d39");
            if (null == sortingExpenseEo.getLongCode() || sortingExpenseEo.getLongCode().isEmpty()) {
                log.info("\u6ca1\u6709\u957f\u7f16\u7801,\u5373\u65e0\u5546\u54c1\u4fe1\u606f,\u4e0d\u8ba1\u8d39");
                sortingExpenseEo.setBillingFeeFlag(Integer.valueOf(0));
                sortingExpenseEo.setNoBillingReason("\u6ca1\u6709\u957f\u7f16\u7801,\u5373\u65e0\u5546\u54c1\u4fe1\u606f,\u4e0d\u8ba1\u8d39");
                insertEos.add(sortingExpenseEo);
                continue;
            }
            log.info("\u6821\u9a8c\u7269\u6d41\u5546\u7ba1\u7406\u5ba2\u6237\u4e0e\u5355\u636e\u5ba2\u6237\u662f\u5426\u4e00\u81f4\uff0c\u662f\u5219\u4e0d\u8ba1\u8d39");
            if (StringUtils.isNotBlank((CharSequence)sortingExpenseEo.getShipmentEnterpriseCode()) && StringUtils.isNotBlank((CharSequence)sortingExpenseEo.getCustomerName()) && ObjectUtils.isNotEmpty((Object)shipmentMap.containsKey(sortingExpenseEo.getShipmentEnterpriseCode())) && StringUtils.isNotBlank((CharSequence)((ShipmentEnterpriseEo)shipmentMap.get(sortingExpenseEo.getShipmentEnterpriseCode())).getCustomerName()) && ((ShipmentEnterpriseEo)shipmentMap.get(sortingExpenseEo.getShipmentEnterpriseCode())).getCustomerName().contains(sortingExpenseEo.getCustomerName())) {
                log.info("\u7269\u6d41\u5546\u7ba1\u7406\u5ba2\u6237\u4e0e\u5355\u636e\u5ba2\u6237\u662f\u4e00\u81f4\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u8d39\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)sortingExpenseEo), (Object)JSON.toJSONString(shipmentMap.get(sortingExpenseEo.getShipmentEnterpriseCode())));
                sortingExpenseEo.setBillingFeeFlag(Integer.valueOf(0));
                sortingExpenseEo.setNoBillingReason("\u7269\u6d41\u5546\u7ba1\u7406\u5ba2\u6237\u4e0e\u5355\u636e\u5ba2\u6237\u662f\u4e00\u81f4\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u8d39");
                insertEos.add(sortingExpenseEo);
                continue;
            }
            log.info("\u8ba1\u7b97\u5927\u7bb1\u3001\u5c0f\u7bb1\u3001\u4e2a\u6570,\u51fa\u5e93\u6570");
            BigDecimal doneQuantity = ObjectUtils.isEmpty((Object)sortingExpenseEo.getDoneQuantity()) ? BigDecimal.ZERO : sortingExpenseEo.getDoneQuantity();
            Long bigR = sortingExpenseEo.getBigRatio() == null ? 1L : sortingExpenseEo.getBigRatio();
            Long smallR = sortingExpenseEo.getSmallRatio() == null ? 1L : sortingExpenseEo.getSmallRatio();
            Long boxNum = num = Long.valueOf(doneQuantity.longValue());
            Long bigNum = 0L;
            Long smallNum = 0L;
            if (sortingExpenseEo.getBigRatio() != null && bigR != 0L) {
                bigNum = num / bigR;
                sortingExpenseEo.setBigBoxNum(BigDecimal.valueOf(bigNum));
                boxNum = num % bigR;
            }
            if (sortingExpenseEo.getSmallRatio() != null && smallR != 0L) {
                smallNum = boxNum / smallR;
                sortingExpenseEo.setSmallBoxNum(BigDecimal.valueOf(smallNum));
                boxNum = boxNum % smallR;
            }
            sortingExpenseEo.setBoxNum(BigDecimal.valueOf(boxNum));
            String inLogicWarehouseCode = sortingExpenseEo.getInLogicWarehouseCode();
            String outLogicWarehouseCode = sortingExpenseEo.getOutLogicWarehouseCode();
            FeeAttributionConfigEo example = new FeeAttributionConfigEo();
            example.setOutWarehouseCode(outLogicWarehouseCode);
            example.setInWarehouseCode(inLogicWarehouseCode);
            log.info("\u67e5\u8be2\u5206\u62e3\u8d39\u7528\u5408\u540c\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
            ExtQueryChainWrapper filter = this.sortingContractDas.filter();
            if (CollectionUtil.isNotEmpty(whMap) && whMap.get(outLogicWarehouseCode) != null) {
                filter.eq((Object)"physical_warehouse_code", (Object)((LogicWarehouseVo)whMap.get(outLogicWarehouseCode)).getRefWarehouseCode());
            } else {
                filter.eq((Object)"physical_warehouse_code", (Object)outLogicWarehouseCode);
            }
            filter.lt((Object)"sale_order_create_start_time", (Object)sortingExpenseEo.getOutWarehouseTime());
            filter.gt((Object)"sale_order_create_end_time", (Object)sortingExpenseEo.getOutWarehouseTime());
            filter.ne((Object)"status", (Object)4);
            List sortingContractEoList = filter.list();
            sortingExpenseEo.setAbnormal(Integer.valueOf(0));
            log.info("\u67e5\u8be2\u5206\u62e3\u5408\u540c\u7ed3\u679c:{}", (Object)sortingContractEoList);
            if (CollectionUtil.isEmpty((Collection)sortingContractEoList) || sortingExpenseEo.getBigRatio() == null || sortingExpenseEo.getSmallRatio() == null || sortingExpenseEo.getBigRatio() == 0L || sortingExpenseEo.getSmallRatio() == 0L) {
                if (CollectionUtil.isEmpty((Collection)sortingContractEoList)) {
                    this.setErrorMsg(sortingExpenseEo, "\u672a\u5339\u914d\u5230\u5408\u540c");
                }
                if (sortingExpenseEo.getBigRatio() == null) {
                    this.setErrorMsg(sortingExpenseEo, "\u5927\u7bb1\u7cfb\u6570\u4e3a\u7a7a");
                }
                if (sortingExpenseEo.getSmallRatio() == null) {
                    this.setErrorMsg(sortingExpenseEo, "\u5c0f\u7bb1\u74f6\u6570\u4e3a\u7a7a");
                }
                if (sortingExpenseEo.getBigRatio() != null && sortingExpenseEo.getBigRatio() == 0L) {
                    this.setErrorMsg(sortingExpenseEo, "\u5927\u7bb1\u7cfb\u6570\u4e3a0");
                }
                if (sortingExpenseEo.getSmallRatio() != null && sortingExpenseEo.getSmallRatio() == 0L) {
                    this.setErrorMsg(sortingExpenseEo, "\u5c0f\u7bb1\u74f6\u6570\u4e3a0");
                }
                sortingExpenseEo.setAbnormal(Integer.valueOf(1));
            } else {
                log.info("\u5f00\u59cb\u8ba1\u7b97\u5206\u62e3\u8d39");
                SortingContractEo sortingContractEo = (SortingContractEo)sortingContractEoList.get(0);
                BigDecimal largeBoxPrice = sortingContractEo.getLargeBoxPrice();
                BigDecimal smallBoxPrice = sortingContractEo.getSmallBoxPrice();
                BigDecimal singlePrice = sortingContractEo.getSinglePrice();
                BigDecimal sortingNum = BigDecimal.valueOf(bigNum).multiply(largeBoxPrice).add(BigDecimal.valueOf(smallNum).multiply(smallBoxPrice)).add(BigDecimal.valueOf(boxNum).multiply(singlePrice));
                sortingExpenseEo.setSortingNum(sortingNum);
            }
            String businessType = sortingExpenseEo.getBusinessType();
            String relevanceNo = sortingExpenseEo.getRelevanceNo();
            log.info("\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u548c\u5173\u8054\u5355\u53f7:{},{}", (Object)businessType, (Object)relevanceNo);
            if (SaleBusinessTypeEnum.internalSalesOrderTypes().containsKey(businessType) || SaleBusinessTypeEnum.nutritionistOrderTypes().containsKey(businessType)) {
                log.info("\u5f53\u524d\u5355\u636e\u7c7b\u578b\u4e3a -> \u5185\u90e8\u9500\u552e\u8ba2\u5355 \u6216 \u8425\u517b\u5bb6\u8ba2\u5355");
                if (saleOrderEoMap.containsKey(relevanceNo)) {
                    SaleOrderEo saleOrderEo = saleOrderEoMap.get(relevanceNo);
                    if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getEasOrderNo())) {
                        sortingExpenseEo.setExternalOrderNo(saleOrderEo.getEasOrderNo());
                    } else {
                        sortingExpenseEo.setExternalOrderNo(saleOrderEo.getEasOutOrderNo());
                    }
                    sortingExpenseEo.setExpenseOrganizationId(saleOrderEo.getOrganizationId().toString());
                    sortingExpenseEo.setExpenseOrganizationName(saleOrderEo.getOrganizationName());
                }
            } else if (transferOrderBusinessType.contains(businessType)) {
                if (transferOrderMap.containsKey(relevanceNo)) {
                    CsTransferOrderEo transferOrderEo = transferOrderMap.get(relevanceNo);
                    sortingExpenseEo.setExternalOrderNo(transferOrderEo.getPreOrderNo());
                    sortingExpenseEo.setInLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
                    sortingExpenseEo.setOutLogicWarehouseCode(transferOrderEo.getOutLogicWarehouseCode());
                }
            } else if (Objects.equals(businessType, CsPcpBusinessTypeEnum.OTHER_OUT.getCode())) {
                if (otherOrderMap.containsKey(relevanceNo)) {
                    CsOtherStorageOrderEo otherStorageOrderEo = otherOrderMap.get(relevanceNo);
                    sortingExpenseEo.setExternalOrderNo(otherStorageOrderEo.getExternalOrderNo());
                    String remark = otherStorageOrderEo.getRemark();
                    if (StringUtils.isBlank((CharSequence)remark)) {
                        remark = otherStorageOrderEo.getMessage();
                    }
                }
            } else if (refundOrderBusinessType.contains(businessType) && saleRefundEoMap.containsKey(relevanceNo)) {
                OutPlannedOrderEo outPlannedOrderEo = saleRefundEoMap.get(relevanceNo);
                sortingExpenseEo.setExternalOrderNo(outPlannedOrderEo.getPlatformOrderNo());
            }
            log.info("\u5254\u9664\u8ba1\u8d39\u6a21\u5757\u5224\u65ad\u662f\u5426\u8ba1\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
            DailyDeliveryFeeFilterExtConfigReqDto configReqDto = new DailyDeliveryFeeFilterExtConfigReqDto();
            configReqDto.setFilterPhysicalWarehouse(sortingExpenseEo.getOutPhysicsWarehouseCode());
            configReqDto.setFilterLogicWarehouse(sortingExpenseEo.getOutLogicWarehouseCode());
            configReqDto.setFilterBusinessType(sortingExpenseEo.getBusinessType());
            configReqDto.setLogisticsCompany(sortingExpenseEo.getShipmentEnterpriseName());
            configReqDto.setTransportStyle(sortingExpenseEo.getTransportStyle());
            configReqDto.setFilterInventoryOrg(sortingExpenseEo.getExpenseOrganizationName());
            boolean filterApplicable = this.dailyDeliveryFeeFilterExtConfigService.isFilterApplicable(feeFilter, configReqDto);
            if (filterApplicable) {
                log.info("\u547d\u4e2d\u5254\u9664\u8ba1\u8d39\u914d\u7f6e");
                sortingExpenseEo.setBillingFeeFlag(Integer.valueOf(0));
                sortingExpenseEo.setNoBillingReason("\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u547d\u4e2d");
                insertEos.add(sortingExpenseEo);
                continue;
            }
            if (null == sortingExpenseEo.getBillingFeeFlag() || sortingExpenseEo.getBillingFeeFlag() != 1) continue;
            if (Objects.equals(sortingExpenseEo.getBusinessType(), CsPcpBusinessTypeEnum.ALLOT_OUT.getCode())) {
                CsTransferOrderEo transferOrderEo;
                if (!transferOrderMap.containsKey(sortingExpenseEo.getRelevanceNo()) || Objects.equals((transferOrderEo = transferOrderMap.get(sortingExpenseEo.getRelevanceNo())).getOutPhysicsWarehouseCode(), transferOrderEo.getInPhysicsWarehouseCode())) continue;
                if (Objects.equals(transferOrderEo.getSourceSystem(), "PCP")) {
                    if (adjustmentInventoryEoMap.containsKey(transferOrderEo.getTransferOrderNo())) {
                        String externalOrderNo = adjustmentInventoryEoMap.get(transferOrderEo.getTransferOrderNo()).getExternalOrderNo();
                        sortingExpenseEo.setExternalOrderNo(externalOrderNo);
                    } else {
                        sortingExpenseEo.setExternalOrderNo(transferOrderEo.getPreOrderNo());
                    }
                } else {
                    sortingExpenseEo.setExternalOrderNo(transferOrderEo.getPreOrderNo());
                }
                insertEos.add(sortingExpenseEo);
                continue;
            }
            insertEos.add(sortingExpenseEo);
        }
        this.LOGGER.info("\u63d2\u5165\u524d\u5217\u8868:{}", (Object)JSON.toJSONString((Object)insertEos));
        if (CollectionUtil.isEmpty((Collection)insertEos)) {
            return;
        }
        this.sortingExpenseDas.insertBatch((List)insertEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeJob(TaskQueryParamsDro taskQueryParamsDro) {
        this.LOGGER.info("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)taskQueryParamsDro));
        if (StringUtils.isBlank((CharSequence)taskQueryParamsDro.getStartDateStr()) && StringUtils.isBlank((CharSequence)taskQueryParamsDro.getEndDateStr()) && StringUtils.isBlank((CharSequence)taskQueryParamsDro.getDocumentNo()) && StringUtils.isBlank((CharSequence)taskQueryParamsDro.getLongCode())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        }
        List sortingExpenseOldList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().eq((Object)"dr", (Object)0)).ge(StringUtils.isNotBlank((CharSequence)taskQueryParamsDro.getStartDateStr()), (Object)"out_warehouse_time", (Object)taskQueryParamsDro.getStartDateStr())).le(StringUtils.isNotBlank((CharSequence)taskQueryParamsDro.getEndDateStr()), (Object)"out_warehouse_time", (Object)taskQueryParamsDro.getEndDateStr())).eq(StringUtils.isNotBlank((CharSequence)taskQueryParamsDro.getDocumentNo()), (Object)"document_no", (Object)taskQueryParamsDro.getDocumentNo())).eq(StringUtils.isNotBlank((CharSequence)taskQueryParamsDro.getLongCode()), (Object)"long_code", (Object)taskQueryParamsDro.getLongCode())).list();
        Map<Object, Object> oldMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)sortingExpenseOldList)) {
            oldMap = sortingExpenseOldList.stream().collect(Collectors.toMap(o -> o.getDocumentNo() + o.getLongCode(), Function.identity(), (k1, k2) -> k1));
            List delIds = sortingExpenseOldList.stream().map(BaseEo::getId).collect(Collectors.toList());
            log.info("\u5220\u9664\u4e45\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(delIds));
            this.sortingExpenseDas.logicDeleteByIds(delIds);
        }
        List sortingExpenseEos = this.sortingExpenseDas.querySortingExpenseData(taskQueryParamsDro);
        this.LOGGER.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEos));
        if (CollectionUtil.isEmpty((Collection)sortingExpenseEos)) {
            log.info("\u65e0\u6570\u636e\u9700\u8981\u751f\u6210");
            return;
        }
        HashSet whCodes = Sets.newHashSet();
        HashSet saleOrderNos = Sets.newHashSet();
        HashSet transferOrderNos = Sets.newHashSet();
        HashSet otherOrderNos = Sets.newHashSet();
        HashSet refundOrderNos = Sets.newHashSet();
        sortingExpenseEos.forEach(i -> {
            whCodes.add(i.getOutLogicWarehouseCode());
            String businessType = i.getBusinessType();
            if (saleOrderBusinessType.contains(businessType)) {
                saleOrderNos.add(i.getRelevanceNo());
            } else if (refundOrderBusinessType.contains(businessType)) {
                refundOrderNos.add(i.getRelevanceNo());
            } else if (Objects.equals(businessType, CsPcpBusinessTypeEnum.OTHER_OUT.getCode())) {
                otherOrderNos.add(i.getRelevanceNo());
            } else if (transferOrderBusinessType.contains(businessType)) {
                transferOrderNos.add(i.getRelevanceNo());
            }
        });
        Map<String, CsTransferOrderEo> transferOrderMap = this.queryTransferOrder(transferOrderNos);
        Map<String, SaleOrderEo> saleOrderEoMap = this.querySaleOrder(saleOrderNos);
        Map<String, OutPlannedOrderEo> saleRefundEoMap = this.querySaleRefundOrder(refundOrderNos);
        Map<String, CsOtherStorageOrderEo> otherOrderMap = this.queryOtherOrder(otherOrderNos);
        Map<String, AdjustmentInventoryEo> adjustmentInventoryEoMap = this.asyncQueryAdjustmentInventory(transferOrderNos);
        List whLists = this.logicWarehouseDas.selectByWarehouse((List)Lists.newArrayList((Iterable)whCodes), "physics");
        Map whMap = whLists.stream().collect(Collectors.toMap(LogicWarehouseVo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        this.LOGGER.info("whMap______{}", (Object)JSON.toJSONString(whMap));
        Date time = new Date();
        ArrayList insertEos = Lists.newArrayList();
        Map<Object, Object> finalOldMap = oldMap;
        sortingExpenseEos.forEach(sortingExpenseEo -> {
            SortingExpenseEo se;
            CsTransferOrderEo transferOrderEo;
            FeeAttributionConfigEo feeAttributionConfigEo;
            Long num;
            log.info("\u5206\u62e3\u8d39\u7528\u751f\u6210\u5355\u636e\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
            sortingExpenseEo.setImportUpdateTime(time);
            sortingExpenseEo.setImportUpdatePerson("\u7cfb\u7edf");
            BigDecimal doneQuantity = ObjectUtils.isEmpty((Object)sortingExpenseEo.getDoneQuantity()) ? BigDecimal.ZERO : sortingExpenseEo.getDoneQuantity();
            Long bigR = sortingExpenseEo.getBigRatio() == null ? 1L : sortingExpenseEo.getBigRatio();
            Long smallR = sortingExpenseEo.getSmallRatio() == null ? 1L : sortingExpenseEo.getSmallRatio();
            Long boxNum = num = Long.valueOf(doneQuantity.longValue());
            Long bigNum = 0L;
            Long smallNum = 0L;
            if (sortingExpenseEo.getBigRatio() != null && bigR != 0L) {
                bigNum = num / bigR;
                sortingExpenseEo.setBigBoxNum(BigDecimal.valueOf(bigNum));
                boxNum = num % bigR;
            }
            if (sortingExpenseEo.getSmallRatio() != null && smallR != 0L) {
                smallNum = boxNum / smallR;
                sortingExpenseEo.setSmallBoxNum(BigDecimal.valueOf(smallNum));
                boxNum = boxNum % smallR;
            }
            sortingExpenseEo.setBoxNum(BigDecimal.valueOf(boxNum));
            String inLogicWarehouseCode = sortingExpenseEo.getInLogicWarehouseCode();
            String outLogicWarehouseCode = sortingExpenseEo.getOutLogicWarehouseCode();
            FeeAttributionConfigEo example = new FeeAttributionConfigEo();
            example.setOutWarehouseCode(outLogicWarehouseCode);
            example.setInWarehouseCode(inLogicWarehouseCode);
            sortingExpenseEo.setExpenseOrganizationId(sortingExpenseEo.getOutOrganizationId());
            sortingExpenseEo.setExpenseOrganizationName(sortingExpenseEo.getOutOrganizationName());
            if (!ObjectUtils.isEmpty((Object)inLogicWarehouseCode) && !ObjectUtils.isEmpty((Object)(feeAttributionConfigEo = (FeeAttributionConfigEo)this.feeAttributionConfigDas.selectOne((BaseEo)example)))) {
                sortingExpenseEo.setExpenseOrganizationId(feeAttributionConfigEo.getCostBelongOrgId());
                sortingExpenseEo.setExpenseOrganizationName(feeAttributionConfigEo.getCostBelongOrgName());
            }
            log.info("\u67e5\u8be2\u5206\u62e3\u8d39\u7528\u5408\u540c\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
            ExtQueryChainWrapper filter = this.sortingContractDas.filter();
            if (CollectionUtil.isNotEmpty((Map)whMap) && whMap.get(outLogicWarehouseCode) != null) {
                filter.eq((Object)"physical_warehouse_code", (Object)((LogicWarehouseVo)whMap.get(outLogicWarehouseCode)).getRefWarehouseCode());
            } else {
                filter.eq((Object)"physical_warehouse_code", (Object)outLogicWarehouseCode);
            }
            filter.lt((Object)"sale_order_create_start_time", (Object)sortingExpenseEo.getOutWarehouseTime());
            filter.gt((Object)"sale_order_create_end_time", (Object)sortingExpenseEo.getOutWarehouseTime());
            filter.ne((Object)"status", (Object)4);
            List sortingContractEoList = filter.list();
            sortingExpenseEo.setAbnormal(Integer.valueOf(0));
            if (CollectionUtil.isEmpty((Collection)sortingContractEoList) || sortingExpenseEo.getBigRatio() == null || sortingExpenseEo.getSmallRatio() == null || sortingExpenseEo.getBigRatio() == 0L || sortingExpenseEo.getSmallRatio() == 0L) {
                if (CollectionUtil.isEmpty((Collection)sortingContractEoList)) {
                    this.setErrorMsg((SortingExpenseEo)sortingExpenseEo, "\u672a\u5339\u914d\u5230\u5408\u540c");
                }
                if (sortingExpenseEo.getBigRatio() == null) {
                    this.setErrorMsg((SortingExpenseEo)sortingExpenseEo, "\u5927\u7bb1\u7cfb\u6570\u4e3a\u7a7a");
                }
                if (sortingExpenseEo.getSmallRatio() == null) {
                    this.setErrorMsg((SortingExpenseEo)sortingExpenseEo, "\u5c0f\u7bb1\u74f6\u6570\u4e3a\u7a7a");
                }
                if (sortingExpenseEo.getBigRatio() != null && sortingExpenseEo.getBigRatio() == 0L) {
                    this.setErrorMsg((SortingExpenseEo)sortingExpenseEo, "\u5927\u7bb1\u7cfb\u6570\u4e3a0");
                }
                if (sortingExpenseEo.getSmallRatio() != null && sortingExpenseEo.getSmallRatio() == 0L) {
                    this.setErrorMsg((SortingExpenseEo)sortingExpenseEo, "\u5c0f\u7bb1\u74f6\u6570\u4e3a0");
                }
                sortingExpenseEo.setAbnormal(Integer.valueOf(1));
            } else {
                SortingContractEo sortingContractEo = (SortingContractEo)sortingContractEoList.get(0);
                BigDecimal largeBoxPrice = sortingContractEo.getLargeBoxPrice();
                BigDecimal smallBoxPrice = sortingContractEo.getSmallBoxPrice();
                BigDecimal singlePrice = sortingContractEo.getSinglePrice();
                BigDecimal sortingNum = BigDecimal.valueOf(bigNum).multiply(largeBoxPrice).add(BigDecimal.valueOf(smallNum).multiply(smallBoxPrice)).add(BigDecimal.valueOf(boxNum).multiply(singlePrice));
                sortingExpenseEo.setSortingNum(sortingNum);
            }
            String businessType = sortingExpenseEo.getBusinessType();
            String relevanceNo = sortingExpenseEo.getRelevanceNo();
            if (saleOrderBusinessType.contains(businessType)) {
                if (saleOrderEoMap.containsKey(relevanceNo)) {
                    SaleOrderEo saleOrderEo = (SaleOrderEo)saleOrderEoMap.get(relevanceNo);
                    if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getEasOrderNo())) {
                        sortingExpenseEo.setExternalOrderNo(saleOrderEo.getEasOrderNo());
                    } else {
                        sortingExpenseEo.setExternalOrderNo(saleOrderEo.getEasOutOrderNo());
                    }
                    sortingExpenseEo.setAdjustRemarks(saleOrderEo.getSellerRemark());
                }
            } else if (transferOrderBusinessType.contains(businessType)) {
                if (transferOrderMap.containsKey(relevanceNo)) {
                    transferOrderEo = (CsTransferOrderEo)transferOrderMap.get(relevanceNo);
                    sortingExpenseEo.setAdjustRemarks(transferOrderEo.getRemark());
                    sortingExpenseEo.setExternalOrderNo(transferOrderEo.getPreOrderNo());
                    sortingExpenseEo.setInLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
                    sortingExpenseEo.setOutLogicWarehouseCode(transferOrderEo.getOutLogicWarehouseCode());
                }
            } else if (Objects.equals(businessType, CsPcpBusinessTypeEnum.OTHER_OUT.getCode())) {
                if (otherOrderMap.containsKey(relevanceNo)) {
                    CsOtherStorageOrderEo otherStorageOrderEo = (CsOtherStorageOrderEo)otherOrderMap.get(relevanceNo);
                    sortingExpenseEo.setExternalOrderNo(otherStorageOrderEo.getExternalOrderNo());
                    String remark = otherStorageOrderEo.getRemark();
                    if (StringUtils.isBlank((CharSequence)remark)) {
                        remark = otherStorageOrderEo.getMessage();
                    }
                    sortingExpenseEo.setAdjustRemarks(remark);
                }
            } else if (refundOrderBusinessType.contains(businessType) && saleRefundEoMap.containsKey(relevanceNo)) {
                OutPlannedOrderEo outPlannedOrderEo = (OutPlannedOrderEo)saleRefundEoMap.get(relevanceNo);
                sortingExpenseEo.setExternalOrderNo(outPlannedOrderEo.getPlatformOrderNo());
                sortingExpenseEo.setAdjustRemarks(outPlannedOrderEo.getRemark());
            }
            if (Objects.equals(sortingExpenseEo.getBusinessType(), CsPcpBusinessTypeEnum.ALLOT_OUT.getCode())) {
                if (transferOrderMap.containsKey(sortingExpenseEo.getRelevanceNo()) && !Objects.equals((transferOrderEo = (CsTransferOrderEo)transferOrderMap.get(sortingExpenseEo.getRelevanceNo())).getOutPhysicsWarehouseCode(), transferOrderEo.getInPhysicsWarehouseCode())) {
                    sortingExpenseEo.setAdjustRemarks(transferOrderEo.getRemark());
                    if (Objects.equals(transferOrderEo.getSourceSystem(), "PCP")) {
                        if (adjustmentInventoryEoMap.containsKey(transferOrderEo.getTransferOrderNo())) {
                            String externalOrderNo = ((AdjustmentInventoryEo)adjustmentInventoryEoMap.get(transferOrderEo.getTransferOrderNo())).getExternalOrderNo();
                            sortingExpenseEo.setExternalOrderNo(externalOrderNo);
                        } else {
                            sortingExpenseEo.setExternalOrderNo(transferOrderEo.getPreOrderNo());
                        }
                    } else {
                        sortingExpenseEo.setExternalOrderNo(transferOrderEo.getPreOrderNo());
                    }
                    sortingExpenseEo.setId(null);
                    log.info("\u6dfb\u52a0\u81f3\u961f\u5217\u524d\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
                    insertEos.add(sortingExpenseEo);
                }
            } else {
                sortingExpenseEo.setId(null);
                log.info("\u6dfb\u52a0\u81f3\u961f\u5217\u524d\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
                insertEos.add(sortingExpenseEo);
            }
            if (ObjectUtils.isNotEmpty((Object)(se = (SortingExpenseEo)finalOldMap.get(sortingExpenseEo.getDocumentNo() + sortingExpenseEo.getLongCode())))) {
                sortingExpenseEo.setAdjustRemarks(se.getAdjustRemarks());
                sortingExpenseEo.setAdjustType(se.getAdjustType());
                sortingExpenseEo.setAdjustNum(se.getAdjustNum());
            }
        });
        this.LOGGER.info("sortingExpenseDas.insertBatch:{}", (Object)JSON.toJSONString((Object)insertEos));
        if (CollectionUtil.isEmpty((Collection)insertEos)) {
            return;
        }
        log.info("\u63d2\u5165\u524d\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)insertEos));
        this.sortingExpenseDas.insertBatch((List)insertEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSortingExpense(List<TaskQueryParamsDro> queryParamsDroList) {
        log.info("\u6279\u91cf\u66f4\u65b0\u5206\u62e3\u8d39\u7528\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(queryParamsDroList));
        queryParamsDroList.forEach(this::executeJobNew);
    }

    private void setErrorMsg(SortingExpenseEo msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getAbnormalCauses())) {
            msgDto.setAbnormalCauses(errorMsg);
        } else {
            msgDto.setAbnormalCauses(String.format("%s\u3001%s", msgDto.getAbnormalCauses(), errorMsg));
        }
    }

    public static Date getBeginDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayBegin());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getEndDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayEnd());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    @Override
    @Async
    public void updateSortingExpense(Long contractId) {
        if (ObjectUtils.isEmpty((Object)MDC.get((String)"yes.req.requestId"))) {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        }
        this.LOGGER.info("\u66f4\u65b0\u5206\u62e3\u8d39\u7528\u62a5\u8868\u6570\u636e\uff1a{}", (Object)contractId);
        SortingContractEo sortingContractEo = (SortingContractEo)((ExtQueryChainWrapper)this.sortingContractDas.filter().eq((Object)"id", (Object)contractId)).one();
        if (sortingContractEo == null) {
            throw new BizException(String.format("\u5408\u540cid\u4e0d\u6b63\u786e\u3010%s\u3011", contractId));
        }
        this.LOGGER.info("\u5408\u540c\u6570\u636e:{}", (Object)JSON.toJSONString((Object)sortingContractEo));
        String physicalWarehouseCode = sortingContractEo.getPhysicalWarehouseCode();
        List logicWh = this.logicWarehouseDas.selectByWarehouse((List)Lists.newArrayList((Object[])new String[]{physicalWarehouseCode}), "logic");
        if (CollectionUtil.isEmpty((Collection)logicWh) || logicWh.size() < 1) {
            throw new BizException(String.format("\u7269\u7406\u4ed3\u5173\u8054\u903b\u8f91\u4ed3\u4e3a\u7a7a\uff0c\u7269\u7406\u4ed3\u7f16\u53f7\u3010%s\u3011", physicalWarehouseCode));
        }
        int page = 1;
        int size = 5000;
        List sortingExpenseEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().ge((Object)"out_warehouse_time", (Object)sortingContractEo.getSaleOrderCreateStartTime())).le((Object)"out_warehouse_time", (Object)sortingContractEo.getSaleOrderCreateEndTime())).in((Object)"out_logic_warehouse_code", (Collection)logicWh.stream().map(LogicWarehouseVo::getRefWarehouseCode).collect(Collectors.toList()))).page(Integer.valueOf(page), Integer.valueOf(size)).getList();
        while (CollectionUtil.isNotEmpty((Collection)sortingExpenseEos)) {
            Map<Object, Object> itemMap = Maps.newHashMap();
            List longItemCodes = sortingExpenseEos.stream().filter(i -> i.getBigRatio() == null || i.getSmallRatio() == null).distinct().map(SortingExpenseEo::getLongCode).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(longItemCodes)) {
                List items = ((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"item_code", longItemCodes)).list();
                itemMap = items.stream().collect(Collectors.toMap(ItemExtendEo::getItemCode, Function.identity(), (k1, k2) -> k1));
            }
            HashMap finalItemMap = itemMap;
            sortingExpenseEos.forEach(sortingExpenseEo -> {
                this.LOGGER.info("\u5904\u7406\u62a5\u8868\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
                if (sortingExpenseEo.getPlacedFlag() == 0) {
                    BigDecimal largeBoxPrice = sortingContractEo.getLargeBoxPrice();
                    BigDecimal smallBoxPrice = sortingContractEo.getSmallBoxPrice();
                    BigDecimal singlePrice = sortingContractEo.getSinglePrice();
                    Long smallRatio = sortingExpenseEo.getSmallRatio();
                    Long bigRatio = sortingExpenseEo.getBigRatio();
                    String longCode = sortingExpenseEo.getLongCode();
                    if ((smallRatio == null || Objects.equals(smallRatio, 0L) || bigRatio == null || Objects.equals(bigRatio, 0L)) && CollectionUtil.isNotEmpty((Map)finalItemMap) && finalItemMap.containsKey(longCode)) {
                        ItemExtendEo itemExtendRespDto = (ItemExtendEo)finalItemMap.get(longCode);
                        this.LOGGER.info("\u5339\u914d\u7684\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)itemExtendRespDto));
                        if (smallRatio == null || Objects.equals(smallRatio, 0L)) {
                            smallRatio = itemExtendRespDto.getSmallBox();
                            sortingExpenseEo.setSmallRatio(smallRatio);
                        }
                        if (bigRatio == null || Objects.equals(bigRatio, 0L)) {
                            bigRatio = itemExtendRespDto.getBigBox();
                            sortingExpenseEo.setBigRatio(bigRatio);
                        }
                    }
                    if (ObjectUtils.isNotEmpty((Object)sortingExpenseEo.getDoneQuantity()) && sortingExpenseEo.getDoneQuantity().compareTo(BigDecimal.ZERO) != 0 && ObjectUtils.isNotEmpty((Object)sortingExpenseEo.getBigRatio()) && !Objects.equals(sortingExpenseEo.getBigRatio(), 0L)) {
                        BigDecimal doneQuantity = ObjectUtils.isEmpty((Object)sortingExpenseEo.getDoneQuantity()) ? BigDecimal.ZERO : sortingExpenseEo.getDoneQuantity();
                        BigDecimal boxNum = BigDecimal.ZERO;
                        BigDecimal bigNum = BigDecimal.ZERO;
                        BigDecimal smallNum = BigDecimal.ZERO;
                        if (sortingExpenseEo.getBigRatio() != null) {
                            bigNum = doneQuantity.divide(new BigDecimal(sortingExpenseEo.getBigRatio()), 0, RoundingMode.DOWN);
                            sortingExpenseEo.setBigBoxNum(bigNum);
                        }
                        if (ObjectUtils.isNotEmpty((Object)sortingExpenseEo.getSmallRatio()) && !Objects.equals(sortingExpenseEo.getSmallRatio(), 0L)) {
                            if (sortingExpenseEo.getSmallRatio() != null) {
                                smallNum = doneQuantity.subtract(new BigDecimal(sortingExpenseEo.getBigRatio()).multiply(bigNum)).divide(new BigDecimal(sortingExpenseEo.getSmallRatio()), 0, RoundingMode.DOWN);
                                sortingExpenseEo.setSmallBoxNum(smallNum);
                            }
                            BigDecimal boxNumCalculate = new BigDecimal(sortingExpenseEo.getBigRatio()).multiply(bigNum);
                            BigDecimal boxNumCalculate2 = new BigDecimal(sortingExpenseEo.getSmallRatio()).multiply(smallNum);
                            boxNum = doneQuantity.subtract(boxNumCalculate).subtract(boxNumCalculate2);
                            sortingExpenseEo.setBoxNum(boxNum);
                            BigDecimal sortingNum = sortingExpenseEo.getBigBoxNum().multiply(largeBoxPrice).add(sortingExpenseEo.getSmallBoxNum().multiply(smallBoxPrice)).add(sortingExpenseEo.getBoxNum().multiply(singlePrice));
                            sortingExpenseEo.setSortingNum(sortingNum);
                        }
                    }
                    this.checkSortingExpenseAbnormal((SortingExpenseEo)sortingExpenseEo);
                    this.sortingExpenseDas.updateSelective((BaseEo)sortingExpenseEo);
                }
            });
            sortingExpenseEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().ge((Object)"out_warehouse_time", (Object)sortingContractEo.getSaleOrderCreateStartTime())).le((Object)"out_warehouse_time", (Object)sortingContractEo.getSaleOrderCreateEndTime())).in((Object)"out_logic_warehouse_code", (Collection)logicWh.stream().map(LogicWarehouseVo::getRefWarehouseCode).collect(Collectors.toList()))).page(Integer.valueOf(++page), Integer.valueOf(size)).getList();
        }
        this.LOGGER.info("\u66f4\u65b0\u5b8c\u6bd5\uff01");
    }

    private void checkSortingExpenseAbnormal(SortingExpenseEo eo) {
        eo.setAbnormalCauses("");
        this.setSortingExpenseAbnormal(ObjectUtils.isEmpty((Object)eo.getDoneQuantity()), eo, "\u51fa\u5e93\u6570\u91cf\u4e3a\u7a7a");
        this.setSortingExpenseAbnormal(ObjectUtils.isEmpty((Object)eo.getBigRatio()), eo, "\u88c5\u7bb1\u6570\u4e3a\u7a7a");
        this.setSortingExpenseAbnormal(ObjectUtils.isEmpty((Object)eo.getSmallRatio()), eo, "\u5c0f\u7bb1\u74f6\u6570\u4e3a\u7a7a");
        if (ObjectUtils.isNotEmpty((Object)eo.getDoneQuantity()) && ObjectUtils.isNotEmpty((Object)eo.getBigRatio())) {
            this.setSortingExpenseAbnormal(ObjectUtils.isEmpty((Object)eo.getBigBoxNum()), eo, "\u5927\u7bb1\u6570\u8ba1\u7b97\u5f02\u5e38");
            if (ObjectUtils.isNotEmpty((Object)eo.getSmallRatio()) && ObjectUtils.isNotEmpty((Object)eo.getBigBoxNum())) {
                this.setSortingExpenseAbnormal(ObjectUtils.isEmpty((Object)eo.getSmallBoxNum()), eo, "\u5c0f\u7bb1\u6570\u8ba1\u7b97\u5f02\u5e38");
                if (ObjectUtils.isNotEmpty((Object)eo.getSmallBoxNum())) {
                    this.setSortingExpenseAbnormal(ObjectUtils.isEmpty((Object)eo.getBoxNum()), eo, "\u4e2a\u6570\u8ba1\u7b97\u5f02\u5e38");
                }
            }
        }
        if (ObjectUtils.isNotEmpty((Object)eo.getBoxNum())) {
            this.setSortingExpenseAbnormal(ObjectUtils.isEmpty((Object)eo.getSortingNum()), eo, "\u5206\u62e3\u8d39\u8ba1\u7b97\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)eo.getAbnormalCauses())) {
            eo.setAbnormal(Integer.valueOf(0));
            return;
        }
        eo.setAbnormalCauses(eo.getAbnormalCauses().substring(1));
        eo.setAbnormal(Integer.valueOf(1));
    }

    private void setSortingExpenseAbnormal(boolean ifSet, SortingExpenseEo eo, String msg) {
        if (ifSet) {
            eo.setAbnormalCauses(eo.getAbnormalCauses() + "\u3001" + msg);
        }
    }

    @Override
    public SortingExpenseRespDto getSortingExpenseByOutWarehouseTimeAndDocumentNo(String outWarehouseTime, String documentNo, String goodsLongCode) {
        SortingExpenseEo one = (SortingExpenseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().eq((Object)"out_warehouse_time", (Object)outWarehouseTime)).eq((Object)"document_no", (Object)documentNo)).eq((Object)"long_code", (Object)goodsLongCode)).one();
        SortingExpenseRespDto sortingExpenseRespDto = new SortingExpenseRespDto();
        if (one == null) {
            return sortingExpenseRespDto;
        }
        BeanUtils.copyProperties((Object)one, (Object)sortingExpenseRespDto);
        return sortingExpenseRespDto;
    }

    @Override
    public void bathImportUpdate(List<SortingExpenseReqDto> updateList) {
        updateList.forEach(sortingExpenseReqDto -> {
            SortingExpenseEo eo = new SortingExpenseEo();
            BeanUtils.copyProperties((Object)sortingExpenseReqDto, (Object)eo);
            eo.setImportUpdateTime(new Date());
            this.sortingExpenseDas.updateSelective((BaseEo)eo);
        });
    }

    @Override
    public List<SortingExpenseRespDto> getSortingExpenseByList(List<SortingExpenseQueryDto> queryDtoList) {
        if (CollectionUtil.isEmpty(queryDtoList)) {
            return Lists.newArrayList();
        }
        List sortingExpenseEos = this.sortingExpenseDas.querySortingExpense(queryDtoList);
        if (CollectionUtil.isEmpty((Collection)sortingExpenseEos)) {
            return Lists.newArrayList();
        }
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)sortingExpenseEos, (Collection)dtoList, SortingExpenseRespDto.class);
        return dtoList;
    }

    @Override
    public void edit(SortingExpenseReqDto reqDto) {
        SortingExpenseEo eo = this.check(reqDto);
        this.sortingExpenseDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void editByImport(SortingExpenseReqDto reqDto) {
        log.info("\u6839\u636e\u5bfc\u5165\u7f16\u8f91\u5206\u62e3\u8d39\u7528\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)reqDto.getId()), (String)"\u8bf7\u6c42id\u4e0d\u80fd\u4e3a\u7a7a");
        SortingExpenseEo eo = (SortingExpenseEo)this.sortingExpenseDas.selectByPrimaryKey(reqDto.getId());
        SortingExpenseEo updEo = (SortingExpenseEo)BeanUtil.copyProperties((Object)reqDto, SortingExpenseEo.class, (String[])new String[0]);
        updEo.setId(eo.getId());
        this.sortingExpenseDas.updateSelective((BaseEo)updEo);
    }

    @Override
    public void addByImport(List<SortingExpenseReqDto> reqDtoList) {
        log.info("\u6839\u636e\u5bfc\u5165\u65b0\u589e\u5206\u62e3\u8d39\u7528\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        ArrayList eoList = new ArrayList();
        CubeBeanUtils.copyCollection(eoList, reqDtoList, SortingExpenseEo.class);
        this.sortingExpenseDas.insertBatch(eoList);
    }

    @Override
    public ReInsuranceBillCountDto querySortingCount(SortingCostReportListPageReqDto sortingCostReportListPageReqDto) {
        if (StringUtils.isNotBlank((CharSequence)sortingCostReportListPageReqDto.getOutWarehouseEndTime()) && StringUtils.isNotBlank((CharSequence)sortingCostReportListPageReqDto.getOutWarehouseStartTime())) {
            String startTime = sortingCostReportListPageReqDto.getOutWarehouseStartTime() + " 00:00:00";
            String endTime = sortingCostReportListPageReqDto.getOutWarehouseEndTime() + " 23:59:59";
            sortingCostReportListPageReqDto.setOutWarehouseStartTime(startTime);
            sortingCostReportListPageReqDto.setOutWarehouseEndTime(endTime);
        }
        return this.sortingExpenseDas.querySortingCount(sortingCostReportListPageReqDto);
    }

    private SortingExpenseEo check(SortingExpenseReqDto reqDto) {
        BigDecimal sortingNum;
        if (reqDto == null || reqDto.getId() == null || reqDto.getId() <= 0L) {
            throw new BizException("\u7f16\u8f91\u5206\u62e3\u8d39\u7528Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SortingExpenseEo sortingExpenseEo = (SortingExpenseEo)this.sortingExpenseDas.selectByPrimaryKey(reqDto.getId());
        if (sortingExpenseEo == null) {
            throw new BizException("\u7f16\u8f91\u5206\u62e3\u8d39\u7528Id\u4e0d\u6b63\u786e");
        }
        BigDecimal bigDecimal = sortingNum = sortingExpenseEo.getSortingNum() == null ? BigDecimal.ZERO : sortingExpenseEo.getSortingNum();
        if (reqDto.getAdjustType() != null) {
            sortingExpenseEo.setAdjustType(reqDto.getAdjustType());
            if (Objects.equals(reqDto.getAdjustType(), 2L)) {
                BigDecimal adjustNum = sortingExpenseEo.getAdjustNum();
                if (reqDto.getAdjustNum() != null) {
                    adjustNum = reqDto.getAdjustNum();
                }
                if (sortingNum.compareTo(adjustNum) == -1) {
                    throw new BizException("\u51cf\u5c11\u8d39\u7528\u8d39\u4e0d\u80fd\u5927\u4e8e\u5408\u8ba1\u5206\u62e3\u8d39");
                }
            }
        }
        if (reqDto.getAdjustNum() != null) {
            sortingExpenseEo.setAdjustNum(reqDto.getAdjustNum());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAdjustRemarks())) {
            sortingExpenseEo.setAdjustRemarks(reqDto.getAdjustRemarks());
        }
        return sortingExpenseEo;
    }

    @Override
    public SortingExpenseRespDto getByGroup(SortingCostReportUpdateReqDto dto) {
        SortingExpenseEo one = (SortingExpenseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().eq((Object)"dr", (Object)0)).eq(StringUtils.isNotBlank((CharSequence)dto.getDocumentNo()), (Object)"document_no", (Object)dto.getDocumentNo())).eq(StringUtils.isNotBlank((CharSequence)dto.getLongCode()), (Object)"long_code", (Object)dto.getLongCode())).list().get(0);
        if (null != one.getPlacedFlag() && one.getPlacedFlag() == 0) {
            SortingExpenseRespDto d = new SortingExpenseRespDto();
            BeanUtils.copyProperties((Object)one, (Object)d);
            return d;
        }
        return null;
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u5206\u62e3\u8d39\u7528\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        SortingExpenseEo updateEo = new SortingExpenseEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List eos = this.sortingExpenseDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = eos.stream().filter(eo -> eo.getPlacedFlag() == null || eo.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.sortingExpenseDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        log.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByIds(List<Long> ids) {
        log.info("\u6839\u636eid\u5220\u9664\u5206\u62e3\u8d39\u7528\uff1a{}", ids);
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().in((Object)"id", ids)).eq((Object)"placed_flag", (Object)1)).list();
        AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)list), (String)"\u5b58\u5728\u5df2\u5f52\u6863\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
        this.sortingExpenseDas.logicDeleteByIds(ids);
    }

    static {
        saleOrderBusinessType.add("common_order");
        saleOrderBusinessType.add("agency_order");
        saleOrderBusinessType.add("integral_order");
        saleOrderBusinessType.add("customer_refunding_order");
        saleOrderBusinessType.add("compensation_order");
        saleOrderBusinessType.add("replenishment_order");
        saleOrderBusinessType.add("quality_refunding_order");
        saleOrderBusinessType.add("replenish_order");
        saleOrderBusinessType.add("claim_reissue");
        saleOrderBusinessType.add("other_out_stock");
        saleOrderBusinessType.add("internal_distribution");
        saleOrderBusinessType.add("secondary_distribution");
        saleOrderBusinessType.add("child_direct_sales");
        saleOrderBusinessType.add("presale_order");
        saleOrderBusinessType.add("nutrition_integral");
        saleOrderBusinessType.add("activity_order");
        refundOrderBusinessType.add("outsource_refund");
        refundOrderBusinessType.add("purchase_refund");
        transferOrderBusinessType.add("allot_out_only");
        transferOrderBusinessType.add("allot_out");
        transferOrderBusinessType.add("bc_allot");
    }
}

