/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.api.dto.request.CalculationDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.biz.utils.GeoAddressInfo;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LbsUtil {
    private static final Logger log = LoggerFactory.getLogger(LbsUtil.class);
    private static Logger logger = LoggerFactory.getLogger(LbsUtil.class);
    private final String GD_COORDINATE_CACHE_KEY = "GD_COORDINATE_CACHE_KEY";
    @Resource
    private ICacheService cacheService;
    @Value(value="${report.geo.key:2778775d0ec03a7534289ac50eb587c0}")
    private String key;
    private static final String SPECIAL_CHARACTERS = "\u00b7  @ # \uffe5 % \u2026 & * \uff08\uff09 - =   {  } |  , \u201d \u201c \uff1a \u300b \u300a  \uff1f?";
    private static final String SPECIAL_CHARACTERS2 = "[{|@#\\[\\]!\uffe5$%\u2026^&*(),.\u00b7\uff1f=?\u300b \u300a\uff1a\\\":\\{\\}\\|<>/\u3010\u3011\u2460\u2461\u2462\u2463\u2464\u2465\u2466\u2467\u2468\u2469~\\-\u4e00]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendGet(String url) {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            String urlNameString = url;
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public String getRegeoUrl(String location) {
        return "http://restapi.amap.com/v3/geocode/regeo?location=" + location + "&key=" + this.key;
    }

    public String getAddressNameByGeocoder(String location) {
        String jsonString = this.sendGet(this.getRegeoUrl(location));
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        String addressName = jsonObject.getJSONObject("regeocode").getString("formatted_address");
        return addressName;
    }

    public String getDistanceUrl(String origins, String destination) {
        String urlString = "http://restapi.amap.com/v3/distance?type=0&origins=" + origins + "&destination=" + destination + "&key=" + this.key;
        return urlString;
    }

    public String getDistance(String origins, String destination) {
        String jsonString = this.sendGet(this.getDistanceUrl(origins, destination));
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        String distance = jsonObject.getJSONArray("results").getJSONObject(0).getString("distance");
        return distance;
    }

    public static String distance(double centerLon, double centerLat, double targetLon, double targetLat) {
        double jl_jd = 102834.74258026089;
        double jl_wd = 111712.69150641056;
        double b = Math.abs((centerLat - targetLat) * jl_jd);
        double a = Math.abs((centerLon - targetLon) * jl_wd);
        return Math.sqrt(a * a + b * b) + "";
    }

    public Object getGeographyInfoByAddress(String address) {
        String GD_URL = "https://restapi.amap.com/v3/geocode/geo?key=" + this.key + "&address=";
        log.info("\u9ad8\u5fb7\u63a5\u53e3key:{}", (Object)this.key);
        String result = "";
        try {
            String line;
            URL url = new URL(GD_URL + address);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            connection.disconnect();
            HashMap map = (HashMap)JSON.parseObject((String)sb.toString(), HashMap.class);
            Object geocodes = map.get("geocodes");
            return geocodes != null ? ((JSONObject)((JSONArray)geocodes).get(0)).get((Object)"location") : "";
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ecf\u7eac\u5ea6\u5931\u8d25:{}", (Throwable)e);
            return result;
        }
    }

    public String handleAddress(String address) {
        try {
            char[] chars;
            int last;
            int index;
            String regEx = "[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(address);
            String trim = m.replaceAll("").trim();
            if (StringUtils.isNotBlank((CharSequence)trim)) {
                address = address.substring(0, address.indexOf(trim.substring(0, 1)));
            }
            if (address.contains("(") && address.contains(")")) {
                index = address.indexOf("(");
                last = address.indexOf(")");
                if (last > index) {
                    String source = address;
                    address = address.substring(0, index) + source.substring(last + 1);
                }
            }
            if (address.contains("\uff08") && address.contains(")")) {
                index = address.indexOf("(");
                last = address.indexOf(")");
                if (last > index) {
                    String source1 = address;
                    address = address.substring(0, index) + source1.substring(last + 1);
                }
            }
            for (char aChar : chars = address.toCharArray()) {
                String s3 = String.valueOf(aChar);
                if (!SPECIAL_CHARACTERS.contains(s3)) continue;
                address = address.replace(s3, "");
            }
        }
        catch (Exception e) {
            log.error("\u5730\u5740\u5904\u7406\u9519\u8bef:{}", (Object)address);
            return address;
        }
        return address;
    }

    public String handleAddressExt(String address) {
        log.info("\u5904\u7406\u5730\u5740\u4fe1\u606f\uff1a{}", (Object)address);
        String handleAddress = address;
        Matcher matcher = Pattern.compile("[0-9]").matcher(handleAddress);
        if (matcher.find()) {
            int start = matcher.start();
            handleAddress = handleAddress.substring(0, start);
        }
        handleAddress = handleAddress.replaceAll(SPECIAL_CHARACTERS2, "");
        handleAddress = handleAddress.replaceAll("null", "");
        log.info("\u5904\u7406\u5730\u5740\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)handleAddress);
        return handleAddress;
    }

    public GeoAddressInfo getGeoAddress(String address) {
        String GD_URL = "https://restapi.amap.com/v3/geocode/geo?key=" + this.key + "&address=";
        GeoAddressInfo geoAddressInfo = new GeoAddressInfo();
        try {
            String line;
            URL url = new URL(GD_URL + address);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            connection.disconnect();
            HashMap map = (HashMap)JSON.parseObject((String)sb.toString(), HashMap.class);
            log.info("\u9ad8\u5fb7\u63a5\u53e3\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)map));
            Object geocodes = map.get("geocodes");
            Object status = map.get("status");
            Object infocode = map.get("infocode");
            if (Objects.equals(status, "0") && Objects.equals(infocode, "10021")) {
                Thread.sleep(100L);
                return this.getGeoAddress(address);
            }
            if (geocodes != null) {
                geoAddressInfo = (GeoAddressInfo)JSON.toJavaObject((JSON)((JSON)((JSONArray)geocodes).get(0)), GeoAddressInfo.class);
            }
            geoAddressInfo.setAddress(address);
            return geoAddressInfo;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ecf\u7eac\u5ea6\u5931\u8d25:{}", (Throwable)e);
            return geoAddressInfo;
        }
    }

    public GeoAddressInfo getGeoAddressCache(String address) {
        log.info("\u8bf7\u6c42\u9ad8\u5fb7\u7ecf\u7eac\u5ea6\uff1a{}", (Object)address);
        address = address.replaceAll("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\\d]", "");
        log.info("\u53bb\u6389\u4e2d\u6587\u6570\u5b57\u53ca\u963f\u62c9\u4f2f\u6570\u5b57\uff1a{}", (Object)address);
        GeoAddressInfo info = (GeoAddressInfo)this.cacheService.getCache("GD_COORDINATE_CACHE_KEY", address, GeoAddressInfo.class);
        if (ObjectUtils.isNotEmpty((Object)info)) {
            log.info("\u53d6\u7f13\u5b58\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)info));
            this.cacheService.setCache("GD_COORDINATE_CACHE_KEY", address, (Object)info, 31536000);
            return info;
        }
        GeoAddressInfo geoAddress = this.getGeoAddress(this.handleAddressExt(address));
        if (ObjectUtils.isNotEmpty((Object)geoAddress) && StringUtils.isNotBlank((CharSequence)geoAddress.getLocation())) {
            log.info("\u5b58\u5165\u7f13\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)geoAddress));
            this.cacheService.setCache("GD_COORDINATE_CACHE_KEY", address, (Object)geoAddress, 31536000);
        }
        return geoAddress;
    }

    public static GeoAddressInfo getGeoAddress1(String address) {
        String GD_URL = "https://restapi.amap.com/v3/geocode/geo?key=2778775d0ec03a7534289ac50eb587c0&address=";
        GeoAddressInfo geoAddressInfo = new GeoAddressInfo();
        try {
            String line;
            URL url = new URL(GD_URL + address);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            connection.disconnect();
            HashMap map = (HashMap)JSON.parseObject((String)sb.toString(), HashMap.class);
            log.info("\u9ad8\u5fb7\u63a5\u53e3\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)map));
            Object geocodes = map.get("geocodes");
            Object status = map.get("status");
            Object infocode = map.get("infocode");
            if (Objects.equals(status, "0") && Objects.equals(infocode, "10021")) {
                return LbsUtil.getGeoAddress1(address);
            }
            if (geocodes != null) {
                geoAddressInfo = (GeoAddressInfo)JSON.toJavaObject((JSON)((JSON)((JSONArray)geocodes).get(0)), GeoAddressInfo.class);
            }
            geoAddressInfo.setAddress(address);
            return geoAddressInfo;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ecf\u7eac\u5ea6\u5931\u8d25:{}", (Throwable)e);
            return geoAddressInfo;
        }
    }

    public static boolean distance(String center, String target, BigDecimal distance) {
        logger.info("\u8ba1\u7b97\u7ecf\u7eac\u5ea6\u76f8\u8ddd\u8ddd\u79bb\u662f\u5426\u5728\u4e00\u5b9a\u8303\u56f4\u5185\uff1a{}\uff0c{}\uff0c{}", new Object[]{center, target, distance});
        double jl_jd = 102834.74258026089;
        double jl_wd = 111712.69150641056;
        String[] centerStr = center.split(",");
        String[] targetStr = target.split(",");
        double centerLat = Double.parseDouble(centerStr[1]);
        double centerLon = Double.parseDouble(centerStr[0]);
        double targetLat = Double.parseDouble(targetStr[1]);
        double targetLon = Double.parseDouble(targetStr[0]);
        double b = Math.abs((centerLat - targetLat) * jl_jd);
        double a = Math.abs((centerLon - targetLon) * jl_wd);
        return new BigDecimal(Math.sqrt(a * a + b * b)).compareTo(distance) <= 0;
    }

    public static void main(String[] args) {
        System.out.println(LbsUtil.distance("121.049884,31.186794", "121.049884,31.186794", new BigDecimal("2000")));
    }

    private static List<FinLogisticsReportDto> calculateExt(Set<String> mergedOrder, List<FinLogisticsReportDto> list, List<FinLogisticsReportDto> mergeList, BigDecimal confluentDistance, List<FinLogisticsReportDto> mergeList1) {
        Map<String, List<FinLogisticsReportDto>> map = list.stream().collect(Collectors.groupingBy(FinLogisticsReportDto::getLngLat));
        CalculationDto calculationDto = new CalculationDto();
        map.keySet().forEach(i -> {
            ArrayList temporaryMergeList = Lists.newArrayList();
            ArrayList scatteredList = Lists.newArrayList();
            for (FinLogisticsReportDto dto : list) {
                String lngLat = dto.getLngLat();
                if (Objects.equals(i, lngLat)) {
                    temporaryMergeList.add(dto);
                    continue;
                }
                if (LbsUtil.distance(i, lngLat, confluentDistance)) {
                    temporaryMergeList.add(dto);
                    continue;
                }
                scatteredList.add(dto);
            }
            TwoTuple twoTuple = new TwoTuple((Object)temporaryMergeList, (Object)scatteredList);
            if (calculationDto == null || calculationDto.getTwoTuple() == null || CollectionUtil.isEmpty((Collection)((Collection)calculationDto.getTwoTuple().getFirst()))) {
                calculationDto.setUniqueKey(i);
                calculationDto.setTwoTuple(twoTuple);
            } else {
                int size = ((List)calculationDto.getTwoTuple().getFirst()).size();
                if (size < temporaryMergeList.size() && temporaryMergeList.size() >= 2) {
                    calculationDto.setUniqueKey(i);
                    calculationDto.setTwoTuple(twoTuple);
                }
            }
        });
        List first = (List)calculationDto.getTwoTuple().getFirst();
        List second = (List)calculationDto.getTwoTuple().getSecond();
        if (!CollectionUtil.isNotEmpty((Collection)first)) {
            mergeList1 = second;
            return mergeList;
        }
        String mergeCode = UUID.randomUUID().toString();
        first.forEach(a -> {
            a.setMergeCode(mergeCode);
            if (!mergedOrder.contains(a.getOutboundCode())) {
                mergedOrder.add(a.getOutboundCode());
                mergeList.add((FinLogisticsReportDto)a);
            }
        });
        if (CollectionUtil.isEmpty((Collection)second) || second.size() <= 1) {
            mergeList1 = second;
            return mergeList;
        }
        LbsUtil.calculateExt(mergedOrder, second, mergeList, confluentDistance, mergeList1);
        return mergeList;
    }
}

