/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.request.PcpCustomerAreaListReqDto;
import com.dtyunxi.tcbj.biz.service.ICustomerAreaService;
import com.dtyunxi.tcbj.dao.das.CustomerAreaDas;
import com.dtyunxi.tcbj.dao.das.RCustomerRegionDas;
import com.dtyunxi.tcbj.dao.eo.CustomerAreaEo;
import com.dtyunxi.tcbj.dao.eo.RCustomerRegionEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaTreeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaTreeRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

@Service
public class CustomerAreaServiceImpl
implements ICustomerAreaService {
    public static final String DEFAULT_CODE = "0";
    @Resource
    private CustomerAreaDas customerAreaDas;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private IContext context;

    @Override
    public PageInfo<CustomerAreaRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PcpCustomerAreaListReqDto customerAreaListReqDto = (PcpCustomerAreaListReqDto)JSON.parseObject((String)filter, PcpCustomerAreaListReqDto.class);
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        CubeBeanUtils.copyProperties((Object)customerAreaEo, (Object)customerAreaListReqDto, (String[])new String[0]);
        PageInfo eoPageInfo = this.customerAreaDas.selectPage((BaseEo)customerAreaEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)eoPageInfo.getList(), CustomerAreaRespDto.class);
        dtoPageInfo.setList((List)dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerAreaRespDto queryById(Long id) {
        CustomerAreaEo customerAreaEo = (CustomerAreaEo)this.customerAreaDas.selectByPrimaryKey(id);
        CustomerAreaRespDto customerAreaRespDto = new CustomerAreaRespDto();
        CubeBeanUtils.copyProperties((Object)customerAreaRespDto, (Object)customerAreaEo, (String[])new String[0]);
        return customerAreaRespDto;
    }

    @Override
    public List<CustomerAreaRespDto> queryAreaByCustomerId(Long customerId) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"customer_id", (Object)customerId));
        RCustomerRegionEo selectEo = new RCustomerRegionEo();
        selectEo.setSqlFilters(sqlFilters);
        List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
        if (CollectionUtils.isEmpty((Collection)customerRegionEos)) {
            return Lists.newArrayList();
        }
        List regionCodes = customerRegionEos.stream().map(RCustomerRegionEo::getRegionCode).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(CustomerAreaEo::getCode, regionCodes);
        wrapper.orderByAsc(CustomerAreaEo::getSort);
        List list = this.customerAreaDas.getMapper().selectList((Wrapper)wrapper);
        return list.stream().map(item -> (CustomerAreaRespDto)item.toDto(CustomerAreaRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public List<CustomerAreaRespDto> queryForList(CustomerAreaListReqDto customerAreaListReqDto) {
        List ids;
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        DtoHelper.dto2Eo((BaseVo)customerAreaListReqDto, (BaseEo)customerAreaEo);
        this.setCommon(customerAreaEo, customerAreaListReqDto);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List codes = customerAreaListReqDto.getCodes();
        if (CollUtil.isNotEmpty((Collection)codes)) {
            queryWrapper.in(CustomerAreaEo::getCode, (Collection)codes);
        }
        if (CollUtil.isNotEmpty((Collection)(ids = customerAreaListReqDto.getIds()))) {
            queryWrapper.in(BaseEo::getId, (Collection)ids);
        }
        queryWrapper.orderByAsc(CustomerAreaEo::getSort);
        List list = this.customerAreaDas.getMapper().selectList((Wrapper)queryWrapper);
        return list.stream().map(item -> (CustomerAreaRespDto)item.toDto(CustomerAreaRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public List<String> querySubCodeAll(CustomerAreaListReqDto customerAreaListReqDto) {
        HashSet<String> codeSet = new HashSet<String>();
        List<CustomerAreaRespDto> customerAreaRespDtos = this.queryForList(customerAreaListReqDto);
        for (CustomerAreaRespDto item : customerAreaRespDtos) {
            codeSet.add(item.getCode());
            List<CustomerAreaEo> list = this.getCustomerArea(item.getTopId(), item.getLevel());
            if (CollUtil.isEmpty(list)) continue;
            Integer level = item.getLevel();
            Map<Integer, List<CustomerAreaEo>> levelMap = list.stream().collect(Collectors.groupingBy(CustomerAreaEo::getLevel));
            this.setCode(levelMap, codeSet, level, item.getCode());
        }
        return ListUtil.toList(codeSet);
    }

    @Override
    public List<CustomerAreaTreeRespDto> queryForTree(CustomerAreaTreeReqDto customerAreaTreeReqDto) {
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        this.setCommon(customerAreaEo, customerAreaTreeReqDto);
        List areaList = this.customerAreaDas.select((BaseEo)customerAreaEo);
        if (CollUtil.isEmpty((Collection)areaList)) {
            return ListUtil.empty();
        }
        return this.getTreeList(areaList, DEFAULT_CODE);
    }

    private List<CustomerAreaTreeRespDto> getTreeList(List<CustomerAreaEo> areaList, String parentCode) {
        ArrayList<CustomerAreaTreeRespDto> areaTreeRespDtoList = new ArrayList<CustomerAreaTreeRespDto>();
        Map<String, List<CustomerAreaEo>> areaMap = areaList.stream().sorted(Comparator.comparing(CustomerAreaEo::getSort)).collect(Collectors.groupingBy(CustomerAreaEo::getParentCode));
        DtoHelper.eoList2DtoList((Collection)areaMap.get(parentCode), areaTreeRespDtoList, CustomerAreaTreeRespDto.class);
        areaMap.remove(parentCode);
        this.getChildArea(areaTreeRespDtoList, areaMap);
        return areaTreeRespDtoList;
    }

    private void getChildArea(List<CustomerAreaTreeRespDto> areaGroupTreeRespDtoList, Map<String, List<CustomerAreaEo>> areaGroupMap) {
        areaGroupTreeRespDtoList.forEach(areaGroupTreeDto -> {
            List areaGroupEoList = (List)areaGroupMap.get(areaGroupTreeDto.getCode());
            if (CollectionUtils.isNotEmpty((Collection)areaGroupEoList)) {
                List<CustomerAreaTreeRespDto> areaGroupChildrenDtoList = areaGroupEoList.stream().sorted(Comparator.comparing(CustomerAreaEo::getSort)).map(item -> (CustomerAreaTreeRespDto)item.toDto(CustomerAreaTreeRespDto.class)).collect(Collectors.toList());
                areaGroupTreeDto.setChildren(areaGroupChildrenDtoList);
                areaGroupMap.remove(areaGroupTreeDto.getCode());
                this.getChildArea(areaGroupChildrenDtoList, areaGroupMap);
            }
        });
    }

    private List<CustomerAreaEo> getCustomerArea(Long topId, Integer level) {
        CustomerAreaEo subCustomerAreaEo = new CustomerAreaEo();
        subCustomerAreaEo.setDr(0);
        subCustomerAreaEo.setTopId(topId);
        QueryWrapper queryWrapper = new QueryWrapper((Object)subCustomerAreaEo);
        queryWrapper.gt((Object)"level", (Object)level);
        queryWrapper.orderByAsc((Object)"sort");
        List list = this.customerAreaDas.getMapper().selectList((Wrapper)queryWrapper);
        return list;
    }

    private void setCode(Map<Integer, List<CustomerAreaEo>> levelMap, Set<String> codeSet, Integer level, String code) {
        Integer n = level;
        Integer n2 = level = Integer.valueOf(level + 1);
        if (levelMap.containsKey(level)) {
            List<CustomerAreaEo> customerAreaEos = levelMap.get(level);
            customerAreaEos.forEach(item -> {
                if (Objects.equals(code, item.getParentCode())) {
                    codeSet.add(item.getCode());
                    this.setCode(levelMap, codeSet, item.getLevel(), item.getCode());
                }
            });
        }
    }

    private <DTO extends BaseReqDto> void setCommon(CustomerAreaEo customerAreaEo, DTO dto) {
        customerAreaEo.setTenantId(Objects.nonNull(dto.getTenantId()) ? dto.getTenantId() : this.context.tenantId());
        customerAreaEo.setInstanceId(Objects.nonNull(dto.getInstanceId()) ? dto.getInstanceId() : this.context.instanceId());
    }
}

