/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.InspectionReleaseConstant;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseLogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOperateLogReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseRecordReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionHasReleaseTransferRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseLogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOperateLogRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseRecordRespDto;
import com.dtyunxi.tcbj.biz.service.IInspectionReleaseOrderService;
import com.dtyunxi.tcbj.dao.das.InspectionReleaseOperateLogDas;
import com.dtyunxi.tcbj.dao.das.InspectionReleaseOrderDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.InspectionReleaseOrderEo;
import com.dtyunxi.tcbj.dao.mapper.InspectionReleaseOrderMapper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionReleaseOrderServiceImpl
implements IInspectionReleaseOrderService {
    private static final Logger log = LoggerFactory.getLogger(InspectionReleaseOrderServiceImpl.class);
    @Resource
    private InspectionReleaseOrderDas inspectionReleaseOrderDas;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private InspectionReleaseOperateLogDas inspectionReleaseOperateLogDas;
    @Autowired
    InspectionReleaseOrderMapper inspectionReleaseOrderMapper;

    @Override
    public Long addInspectionReleaseOrder(InspectionReleaseOrderReqDto addReqDto) {
        InspectionReleaseOrderEo inspectionReleaseOrderEo = new InspectionReleaseOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inspectionReleaseOrderEo);
        this.inspectionReleaseOrderDas.insert((BaseEo)inspectionReleaseOrderEo);
        return inspectionReleaseOrderEo.getId();
    }

    @Override
    public void modifyInspectionReleaseOrder(InspectionReleaseOrderReqDto modifyReqDto) {
        InspectionReleaseOrderEo inspectionReleaseOrderEo = new InspectionReleaseOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inspectionReleaseOrderEo);
        this.inspectionReleaseOrderDas.updateSelective((BaseEo)inspectionReleaseOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInspectionReleaseOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inspectionReleaseOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InspectionReleaseOrderRespDto queryById(Long id) {
        InspectionReleaseOrderEo inspectionReleaseOrderEo = (InspectionReleaseOrderEo)this.inspectionReleaseOrderDas.selectByPrimaryKey(id);
        InspectionReleaseOrderRespDto inspectionReleaseOrderRespDto = new InspectionReleaseOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)inspectionReleaseOrderEo, (BaseVo)inspectionReleaseOrderRespDto);
        return inspectionReleaseOrderRespDto;
    }

    @Override
    public PageInfo<InspectionReleaseOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InspectionReleaseOrderReqDto inspectionReleaseOrderReqDto = (InspectionReleaseOrderReqDto)JSON.parseObject((String)filter, InspectionReleaseOrderReqDto.class);
        InspectionReleaseOrderEo inspectionReleaseOrderEo = new InspectionReleaseOrderEo();
        DtoHelper.dto2Eo((BaseVo)inspectionReleaseOrderReqDto, (BaseEo)inspectionReleaseOrderEo);
        PageInfo eoPageInfo = this.inspectionReleaseOrderDas.selectPage((BaseEo)inspectionReleaseOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InspectionReleaseOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<InspectionReleaseRecordRespDto> queryPage(InspectionReleaseRecordReqDto dto) {
        List eos;
        PageInfo page = this.inspectionReleaseOrderDas.queryPage(dto);
        List dtos = page.getList();
        List executeTransferNos = dtos.stream().map(InspectionReleaseRecordRespDto::getExecuteTransferNo).collect(Collectors.toList());
        HashMap executeTransferNoMap = new HashMap();
        List inspectionTransferNos = dtos.stream().map(InspectionReleaseRecordRespDto::getInspectionTransferNo).collect(Collectors.toList());
        HashMap inspectionTransferNoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(executeTransferNos) && CollectionUtil.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", executeTransferNos)).list()))) {
            Map transferNoMap = eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, Function.identity(), (k1, k2) -> k1));
            executeTransferNoMap.putAll(transferNoMap);
        }
        if (CollectionUtil.isNotEmpty(inspectionTransferNos) && CollectionUtil.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", inspectionTransferNos)).list()))) {
            Map map = eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, Function.identity(), (k1, k2) -> k1));
            inspectionTransferNoMap.putAll(map);
        }
        for (InspectionReleaseRecordRespDto respDto : dtos) {
            CsTransferOrderEo eo;
            if (StringUtils.isNotBlank((CharSequence)respDto.getExecuteTransferNo()) && executeTransferNoMap.containsKey(respDto.getExecuteTransferNo())) {
                eo = (CsTransferOrderEo)executeTransferNoMap.get(respDto.getExecuteTransferNo());
                respDto.setExecuteTransferNoStatus(eo.getOrderStatus());
                respDto.setOutLogicWarehouseName(eo.getOutLogicWarehouseName());
                respDto.setOutLogicWarehouseCode(eo.getOutLogicWarehouseCode());
                respDto.setInLogicWarehouseName(eo.getInLogicWarehouseName());
                respDto.setInLogicWarehouseCode(eo.getInLogicWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)respDto.getInspectionTransferNo()) && inspectionTransferNoMap.containsKey(respDto.getInspectionTransferNo())) {
                eo = (CsTransferOrderEo)inspectionTransferNoMap.get(respDto.getInspectionTransferNo());
                respDto.setInspectionTransferNoStatus(eo.getOrderStatus());
            }
            respDto.setStatusName((String)InspectionReleaseConstant.TASK_STATUS.valueMap.get(respDto.getStatus()));
            respDto.setTaskTypeName((String)InspectionReleaseConstant.TASK_ITEM_TYPE.valueMap.get(respDto.getTaskType()));
        }
        page.setList(dtos);
        return page;
    }

    @Override
    public InspectionReleaseCountRespDto queryPageCount(InspectionReleaseRecordReqDto dto) {
        return this.inspectionReleaseOrderDas.queryPageCount(dto);
    }

    @Override
    public PageInfo<InspectionReleaseLogicInventoryRespDto> queryInspectionReleasePage(InspectionReleaseLogicInventoryReqDto reqDto) {
        log.info("queryInspectionReleasePage: {}", (Object)JSON.toJSONString((Object)reqDto));
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new PageInfo(this.inspectionReleaseOrderMapper.queryInspectionRelease(reqDto));
    }

    @Override
    public Long queryInspectionReleaseCount(InspectionReleaseLogicInventoryReqDto reqDto) {
        if (Objects.equals(reqDto.getOver3DaysNotRelease(), true) || Objects.equals(reqDto.getOver2DaysNotSubmit(), true)) {
            return 0L;
        }
        log.info("queryInspectionReleaseCount: {}", (Object)JSON.toJSONString((Object)reqDto));
        return this.inspectionReleaseOrderMapper.queryInspectionReleaseCount(reqDto);
    }

    @Override
    public List<InspectionHasReleaseTransferRespDto> queryHasReleaseTransferList(String longCode, String batch) {
        if (StringUtils.isBlank((CharSequence)longCode) || StringUtils.isBlank((CharSequence)batch)) {
            throw new CsInventoryException("\u8d27\u54c1\u7f16\u7801\u548c\u6279\u6b21\u5fc5\u987b\u540c\u65f6\u5b58\u5728", new Object[0]);
        }
        return this.inspectionReleaseOrderMapper.queryHasReleaseTransferList(longCode, batch);
    }

    @Override
    public PageInfo<InspectionReleaseOperateLogRespDto> queryByLogPage(InspectionReleaseOperateLogReqDto dto) {
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionReleaseOperateLogDas.filter().like(StringUtils.isNotBlank((CharSequence)dto.getSkuCode()), (Object)"sku_code", (Object)dto.getSkuCode())).like(StringUtils.isNotBlank((CharSequence)dto.getSkuName()), (Object)"sku_name", (Object)dto.getSkuName())).like(StringUtils.isNotBlank((CharSequence)dto.getBatch()), (Object)"batch", (Object)dto.getBatch())).like(StringUtils.isNotBlank((CharSequence)dto.getCreatePerson()), (Object)"create_person", (Object)dto.getCreatePerson())).like(StringUtils.isNotBlank((CharSequence)dto.getDesc()), (Object)"description", (Object)dto.getDesc())).eq(StringUtils.isNotBlank((CharSequence)dto.getOperate()), (Object)"operate", (Object)dto.getOperate())).ge(StringUtils.isNotBlank((CharSequence)dto.getStartTime()), (Object)"create_time", (Object)dto.getStartTime())).le(StringUtils.isNotBlank((CharSequence)dto.getEndTime()), (Object)"create_time", (Object)dto.getEndTime())).orderByDesc((Object)"create_time")).page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InspectionReleaseOperateLogRespDto.class);
        for (InspectionReleaseOperateLogRespDto respDto : dtoList) {
            if (!StringUtils.isBlank((CharSequence)respDto.getCreatePerson())) continue;
            respDto.setCreatePerson("system");
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

