/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.apiimpl.query;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DeliveryResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderResultReqDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryResultOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderResultOfFinanceDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderResultOfFinanceRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleResultOrderRespDto;
import com.dtyunxi.tcbj.api.query.IDeliveryResultOrderQueryApi;
import com.dtyunxi.tcbj.biz.service.IDeliveryResultOrderService;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.enums.DictEnum;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeliveryResultOrderQueryApiImpl
implements IDeliveryResultOrderQueryApi {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryResultOrderQueryApiImpl.class);
    @Resource
    private IDeliveryResultOrderService deliveryResultOrderService;
    @Resource
    private IPcpDictApi pcpDictApi;

    public RestResponse<DeliveryResultOrderRespDto> queryById(Long id) {
        return new RestResponse((Object)this.deliveryResultOrderService.queryById(id));
    }

    public RestResponse<PageInfo<DeliveryResultOrderRespDto>> queryByPage(DeliveryResultOrderReqDto filter) {
        return new RestResponse(this.deliveryResultOrderService.queryByPage(filter));
    }

    public RestResponse<PageInfo<SaleOrderResultOfFinanceRespDto>> querySaleOrderResultInfoPage(SaleOrderResultReqDto reqDto) {
        Date parse;
        String date;
        String value;
        logger.info("\u8d22\u52a1\u4e2d\u53f0\u62c9\u5355\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getDocumentNo()) && (value = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DictEnum.FINANCE_PULL_ORDER_API_CONTROL.getCode()).getData()).map(DictDto::getValue).orElse("0")).equals("1") && ObjectUtil.isNotEmpty((Object)(date = ((DictDto)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DictEnum.FINANCE_PULL_ORDER_API_CONTROL_DATE.getCode()).getData()).getValue())) && new Date().compareTo(parse = DateUtil.parse((String)date, (String)DatePattern.DATETIME_PATTERN.getPattern())) >= 0) {
            reqDto.setIfExcludeKmh(Integer.valueOf(1));
        }
        return new RestResponse(this.deliveryResultOrderService.querySaleOrderResultInfoPage(reqDto));
    }

    public RestResponse<PageInfo<SaleResultOrderRespDto>> querySaleReceiveDeliveryResultInfoPage(SaleOrderResultReqDto reqDto) {
        Date parse;
        String date;
        String value;
        logger.info("\u8fdb\u9500\u5b58\u62c9\u5355\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getRelevanceNo()) && StringUtils.isBlank((CharSequence)reqDto.getPlatformOrderNo()) && (value = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DictEnum.STOCK_SELL_STORAGE_API_CONTROL.getCode()).getData()).map(DictDto::getValue).orElse("0")).equals("1") && ObjectUtil.isNotEmpty((Object)(date = ((DictDto)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DictEnum.STOCK_SELL_STORAGE_API_CONTROL_DATE.getCode()).getData()).getValue())) && new Date().compareTo(parse = DateUtil.parse((String)date, (String)DatePattern.DATETIME_PATTERN.getPattern())) >= 0) {
            reqDto.setIfExcludeKmh(Integer.valueOf(1));
        }
        return new RestResponse(this.deliveryResultOrderService.querySaleReceiveDeliveryResultInfoPage(reqDto));
    }

    public RestResponse<Void> saleOrderDetailApportion(List<String> saleOrders) {
        saleOrders.forEach(saleOrder -> this.deliveryResultOrderService.saleOrderDetailApportion((String)saleOrder));
        return RestResponse.VOID;
    }

    public RestResponse<Void> orderDetailApportionBase(List<String> saleOrders, String type) {
        saleOrders.forEach(saleOrder -> this.deliveryResultOrderService.orderDetailApportionBase((String)saleOrder, type));
        return RestResponse.VOID;
    }

    public RestResponse<List<SaleOrderResultOfFinanceDetailRespDto>> queryOrderDetailApportion(List<String> documentNos) {
        return new RestResponse(this.deliveryResultOrderService.queryOrderDetailApportion(documentNos));
    }

    public RestResponse<Void> orderDetailApportionRetry() {
        this.deliveryResultOrderService.orderDetailApportionRetry();
        return RestResponse.VOID;
    }

    public RestResponse<List<SaleOrderResultOfFinanceDetailRespDto>> easTransferOrderApportion(String transferOrderNo, String documentNo) {
        return new RestResponse(this.deliveryResultOrderService.easTransferOrderApportion(transferOrderNo, documentNo));
    }
}

