/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.response.OrganizationInfoExtTemporaryDto;
import com.dtyunxi.tcbj.biz.service.IUserExtV2Service;
import com.dtyunxi.tcbj.dao.das.UserDas;
import com.dtyunxi.tcbj.dao.eo.OrganizationEo;
import com.dtyunxi.tcbj.dao.eo.OrganizationInfoEo;
import com.dtyunxi.tcbj.dao.mapper.OrganizationInfoMapper;
import com.dtyunxi.tcbj.dao.mapper.OrganizationMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

@Service
public class UserExtV2ServiceImpl
implements IUserExtV2Service {
    @Resource
    private UserDas userDas;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private OrganizationInfoMapper organizationInfoMapper;

    @Override
    public List<Long> queryUserByName(String name) {
        return this.userDas.queryUserByName(name);
    }

    @Override
    public List<OrganizationInfoExtTemporaryDto> queryOrgInfoByOrgId(List<Long> orgIdList) {
        QueryWrapper orgEo = new QueryWrapper();
        orgEo.in((Object)"id", orgIdList);
        orgEo.eq((Object)"dr", (Object)0);
        List organizationEos = this.organizationMapper.selectList((Wrapper)orgEo);
        if (CollectionUtils.isEmpty((Collection)organizationEos)) {
            return Lists.newArrayList();
        }
        Map orgMap = organizationEos.stream().collect(Collectors.toMap(OrganizationEo::getCode, Function.identity()));
        List orgCodeList = organizationEos.stream().map(OrganizationEo::getCode).distinct().collect(Collectors.toList());
        QueryWrapper orgInfoEo = new QueryWrapper();
        orgInfoEo.in((Object)"org_code", orgCodeList);
        orgInfoEo.eq((Object)"dr", (Object)0);
        List orgInfoList = this.organizationInfoMapper.selectList((Wrapper)orgInfoEo);
        if (CollectionUtils.isEmpty((Collection)orgInfoList)) {
            return Lists.newArrayList();
        }
        Map orgInfoMap = orgInfoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)orgInfoList, OrganizationInfoExtTemporaryDto.class);
        for (OrganizationInfoExtTemporaryDto infoExtDto : dtoList) {
            OrganizationInfoEo infoEo;
            if (!orgMap.isEmpty() && orgMap.containsKey(infoExtDto.getOrgCode())) {
                infoExtDto.setOrgId(((OrganizationEo)orgMap.get(infoExtDto.getOrgCode())).getId());
            }
            if (!ObjectUtils.isNotEmpty((Object)(infoEo = (OrganizationInfoEo)orgInfoMap.get(infoExtDto.getId())).getBusinessTermType())) continue;
            infoExtDto.setBusinessTermType(String.valueOf(infoEo.getBusinessTermType()));
        }
        return dtoList;
    }
}

