/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.biz.service.IStringCheckResultService;
import com.dtyunxi.tcbj.dao.eo.StringCheckResultEo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="STRING_CODE_LOG_SYNC")
public class StringCodeLogSyncProcess
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(StringCodeLogSyncProcess.class);
    @Resource
    private IStringCheckResultService stringCheckResultService;

    public MessageResponse process(String message) {
        log.info("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684\u4e32\u7801\u65e5\u5fd7\uff0cmessage\uff1a{}", (Object)message);
        try {
            List list = JSON.parseArray((String)message, StringCheckResultEo.class);
            this.stringCheckResultService.batchSave(list.stream().peek(p -> p.setStringCodeStr(Optional.ofNullable(p.getStringCodeList()).map(l -> String.join((CharSequence)",", l)).orElse(""))).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684\u4e32\u7801\u65e5\u5fd7\u5931\u8d25\uff1a", (Throwable)e);
            return MessageResponse.ERROR;
        }
        log.info("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684\u4e32\u7801\u65e5\u5fd7\u5b8c\u6bd5");
        return MessageResponse.SUCCESS;
    }
}

