/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.data.redis.core.CustomStringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="TRANSFER_COMPLETE")
public class InnerTradeOrderNoticeProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InnerTradeOrderNoticeProcessor.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private CustomStringRedisTemplate stringRedisTemplate;

    public MessageResponse process(MessageVo message) {
        LOGGER.info("CreateStorageTraderDetailProcess\uff1amessageVo{}", (Object)JSON.toJSONString((Object)message));
        try {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            String preOrderNo = (String)JSON.parseObject((String)message.getData().toString(), String.class);
            this.stringRedisTemplate.opsForList().rightPush((Object)(this.cacheService.getDefaultGroup() + ":" + "innerTradeOrderNotice"), (Object)preOrderNo);
            LOGGER.info("CreateStorageTraderDetailProcess,end");
        }
        catch (Exception e) {
            LOGGER.info("\u6d88\u606f\u961f\u5217\u76d1\u542c\u8c03\u62e8\u5355\u521b\u5efa\u5206\u644a\u4ea4\u6613\u660e\u7ec6\u5931\u8d25,\u4fe1\u606f\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }
}

