/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportPollNumDto;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportQueryDto;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticDocumentTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.AgainCalculateReqDto;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigLogDataDto;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigReqDto;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDeliverQuantityReqDto;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.api.dto.request.OutResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.DailyDeliveryFeeFilterExtConfigRespDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.OutNoticeOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.biz.dto.express.PriceLadderInfoDto;
import com.dtyunxi.tcbj.biz.service.AbstractCostReportService;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryFeeFilterExtConfigService;
import com.dtyunxi.tcbj.biz.service.IExpressCostConfigService;
import com.dtyunxi.tcbj.biz.service.IExpressCostDeliverQuantityService;
import com.dtyunxi.tcbj.biz.service.IExpressCostDetailService;
import com.dtyunxi.tcbj.biz.service.IOutNoticeOrderService;
import com.dtyunxi.tcbj.biz.service.IOutResultOrderService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.biz.utils.GeoAddressInfo;
import com.dtyunxi.tcbj.biz.utils.LbsUtil;
import com.dtyunxi.tcbj.dao.das.AdjustmentInventoryDas;
import com.dtyunxi.tcbj.dao.das.CsOtherStorageOrderDas;
import com.dtyunxi.tcbj.dao.das.ExpressCostAreaDas;
import com.dtyunxi.tcbj.dao.das.ExpressCostContractDas;
import com.dtyunxi.tcbj.dao.das.ExpressCostDetailDas;
import com.dtyunxi.tcbj.dao.das.ExpressCostReportDas;
import com.dtyunxi.tcbj.dao.das.FeeAttributionConfigDas;
import com.dtyunxi.tcbj.dao.das.FinLogisticsReportDas;
import com.dtyunxi.tcbj.dao.das.InventorySupplierDas;
import com.dtyunxi.tcbj.dao.das.LogicWarehouseDas;
import com.dtyunxi.tcbj.dao.das.OutNoticeOrderDas;
import com.dtyunxi.tcbj.dao.das.OutPlannedOrderDas;
import com.dtyunxi.tcbj.dao.das.PcpRegionDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.das.ReWarehouseAddressDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.das.ShipmentEnterpriseDas;
import com.dtyunxi.tcbj.dao.eo.AdjustmentInventoryEo;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.CsWarehouseAddressEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostAreaEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostContractEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDetailEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostReportEo;
import com.dtyunxi.tcbj.dao.eo.FeeAttributionConfigEo;
import com.dtyunxi.tcbj.dao.eo.InventorySupplierEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.OutPlannedOrderEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderEo;
import com.dtyunxi.tcbj.dao.eo.PcpRegionEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.eo.ShipmentEnterpriseEo;
import com.dtyunxi.tcbj.dao.eo.es.CsOtherStorageOrderEo;
import com.dtyunxi.tcbj.dao.vo.ExpressCostQueryPo;
import com.dtyunxi.tcbj.dao.vo.OrderInfoVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShipmentLogisticsTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportDomain;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.entity.MasterOrderDifferenceDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.MasterOrderDifferenceDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryFeeFilterConfigMatchResultDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryFeeFilterConfigService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ExpressCostDetailServiceImpl
implements IExpressCostDetailService {
    private static final Logger log = LoggerFactory.getLogger(ExpressCostDetailServiceImpl.class);
    @Resource
    private ExpressCostDetailDas expressCostDetailDas;
    @Resource
    private ExpressCostReportDas expressCostReportDas;
    @Resource
    private ShipmentEnterpriseDas shipmentEnterpriseDas;
    @Resource
    private IOutResultOrderService outResultOrderService;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private ExecutorService statisticsExecutor;
    @Resource
    private OutPlannedOrderDas outPlannedOrderDas;
    @Resource
    private InventorySupplierDas inventorySupplierDas;
    @Resource
    private SaleOrderDas saleOrderDas;
    @Resource
    private CsOtherStorageOrderDas otherStorageOrderDas;
    @Resource
    private AdjustmentInventoryDas adjustmentInventoryDas;
    @Resource
    private FinLogisticsReportDas finLogisticsReportDas;
    @Resource
    private FeeAttributionConfigDas feeAttributionConfigDas;
    @Resource
    private PcpRegionDas regionDas;
    @Resource
    private IOutNoticeOrderService outNoticeOrderService;
    @Resource
    private LbsUtil lbsUtil;
    @Resource
    private LogicWarehouseDas logicWarehouseDas;
    @Resource
    private OutNoticeOrderDas outNoticeOrderDas;
    @Resource
    private ReWarehouseAddressDas reWarehouseAddressDas;
    @Resource
    private ExpressCostContractDas expressCostContractDas;
    @Resource
    private ExpressCostAreaDas expressCostAreaDas;
    @Resource
    private IDailyDeliveryReportDomain dailyDeliveryReportDomain;
    @Resource
    private IDailyDeliveryFeeFilterConfigService dailyDeliveryFeeFilterConfigService;
    @Resource
    private IExpressCostConfigService expressCostConfigService;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;
    @Resource
    private IDailyDeliveryFeeFilterConfigService feeFilterService;
    @Resource
    private IExpressCostDeliverQuantityService expressCostDeliverQuantityService;
    @Autowired
    private ILockService lockService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDailyDeliveryFeeFilterExtConfigService dailyDeliveryFeeFilterExtConfigService;
    private static List<String> saleOrderBusinessType = Lists.newArrayList();
    private static List<String> transferOrderBusinessType = Lists.newArrayList();
    private static List<String> refundOrderBusinessType = Lists.newArrayList();
    private static List<String> YYJ_BUSINESS_TYPE = Lists.newArrayList();
    private static final String MAP_SERVICE_NAME = "abstractCostReportService";
    @Autowired
    private Map<String, AbstractCostReportService> mapService;
    public static ThreadPoolExecutor expressCostExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 4, 120L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public Long addExpressCostDetail(ExpressCostDetailReqDto addReqDto) {
        ExpressCostDetailEo expressCostDetailEo = new ExpressCostDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)expressCostDetailEo);
        this.expressCostDetailDas.insert((BaseEo)expressCostDetailEo);
        return expressCostDetailEo.getId();
    }

    @Override
    public void modifyExpressCostDetail(ExpressCostDetailReqDto modifyReqDto) {
        AssertUtil.isTrue((modifyReqDto.getId() != null ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ExpressCostDetailEo eo = (ExpressCostDetailEo)this.expressCostDetailDas.selectByPrimaryKey(modifyReqDto.getId());
        AssertUtil.isTrue((boolean)ObjectUtil.isNotEmpty((Object)eo), (String)"\u8be5id\u4e0d\u5b58\u5728");
        ExpressCostDetailEo expressCostDetailEo = new ExpressCostDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)expressCostDetailEo);
        if (modifyReqDto.getExpressWeight() != null) {
            expressCostDetailEo.setExpressWeight(modifyReqDto.getExpressWeight().setScale(5, 4));
        }
        expressCostDetailEo.setId(modifyReqDto.getId());
        this.expressCostDetailDas.updateSelective((BaseEo)expressCostDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeExpressCostDetail(Long id) {
        ExpressCostDetailEo eo = (ExpressCostDetailEo)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().eq((Object)"id", (Object)id)).one();
        if (eo != null) {
            this.expressCostDetailDas.logicDeleteById(eo.getId());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ExpressCostDetailEo::getReportId, (Object)eo.getReportId());
            int count = this.expressCostDetailDas.count((Wrapper)queryWrapper);
            if (count == 0) {
                this.expressCostReportDas.logicDeleteById(eo.getReportId());
            }
        }
    }

    @Override
    public ExpressCostDetailRespDto queryById(Long id) {
        ExpressCostDetailEo expressCostDetailEo = (ExpressCostDetailEo)this.expressCostDetailDas.selectByPrimaryKey(id);
        ExpressCostDetailRespDto expressCostDetailRespDto = new ExpressCostDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)expressCostDetailEo, (BaseVo)expressCostDetailRespDto);
        return expressCostDetailRespDto;
    }

    @Override
    public PageInfo<ExpressCostDetailRespDto> queryByPage(ExpressCostReportQueryDto queryDto) {
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        if (ObjectUtil.isNotEmpty((Object)queryDto.getEndTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(queryDto.getEndTime());
            calendar.add(11, 23);
            calendar.add(12, 59);
            calendar.add(13, 59);
            queryDto.setEndTime(calendar.getTime());
        }
        queryDto.setLogisticCodeList(this.getCarrierCodeList());
        PageInfo dtoPageInfo = new PageInfo(this.expressCostDetailDas.queryPage(queryDto));
        if (Objects.isNull(dtoPageInfo) || CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            return dtoPageInfo;
        }
        dtoPageInfo.getList().forEach(o -> {
            if (ObjectUtils.isEmpty((Object)o.getAdjustmentType())) {
                o.setRemark(null);
            }
            if (StringUtils.isBlank((CharSequence)o.getInWarehouseCode())) {
                o.setInOrgCode(null);
            }
        });
        return dtoPageInfo;
    }

    @Override
    public ReInsuranceBillCountDto queryExpressCount(ExpressCostReportQueryDto queryDto) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (ObjectUtil.isNotEmpty((Object)queryDto.getStartTime()) && ObjectUtil.isNotEmpty((Object)queryDto.getEndTime())) {
            String begin = dateFormat.format(queryDto.getStartTime()) + " 00:00:00";
            String end = dateFormat.format(queryDto.getEndTime()) + " 23:59:59";
            try {
                Date timeBegin = simpleDateFormat.parse(begin);
                Date timeEnd = simpleDateFormat.parse(end);
                queryDto.setStartTime(timeBegin);
                queryDto.setEndTime(timeEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        queryDto.setLogisticCodeList(this.getCarrierCodeList());
        ReInsuranceBillCountDto reInsuranceBillCountDto = this.expressCostDetailDas.queryExpressCount(queryDto);
        ExpressCostReportQueryDto queryDifferenceDto = (ExpressCostReportQueryDto)BeanUtil.copyProperties((Object)queryDto, ExpressCostReportQueryDto.class, (String[])new String[0]);
        queryDifferenceDto.setPageNum(Integer.valueOf(1));
        queryDifferenceDto.setPageSize(Integer.valueOf(1));
        PageInfo<MasterOrderDifferenceDto> masterOrderDifferenceDtoPageInfo = this.queryPageMasterOrderDifference(queryDifferenceDto);
        reInsuranceBillCountDto.setMasterOrderDifferenceTotal(new BigDecimal(masterOrderDifferenceDtoPageInfo.getTotal()));
        return reInsuranceBillCountDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(ExpressCostDetailReqDto modifyReqDto) {
        this.checkParams(modifyReqDto);
        if (modifyReqDto.getMergeFlag().booleanValue()) {
            String adjustmentType;
            ExpressCostReportEo eo = (ExpressCostReportEo)((ExtQueryChainWrapper)this.expressCostReportDas.filter().eq((Object)"id", (Object)modifyReqDto.getEditId())).one();
            if (eo == null) {
                throw new BizException("\u5408\u5355\u7f16\u8f91ID\u4e0d\u6b63\u786e");
            }
            List detailEoList = ((ExtQueryChainWrapper)this.expressCostDetailDas.filter().eq((Object)"report", (Object)modifyReqDto.getEditId())).list(Integer.valueOf(10000));
            if (CollectionUtil.isEmpty((Collection)detailEoList)) {
                throw new BizException("\u5408\u5355\u7f16\u8f91ID\u4e0d\u6b63\u786e");
            }
            BigDecimal totalFreight = Optional.ofNullable(eo.getTotalFreight()).orElse(BigDecimal.ZERO);
            BigDecimal oldAdjustmentAmount = Optional.ofNullable(eo.getAdjustmentAmount()).orElse(BigDecimal.ZERO);
            String oldAdjustmentType = null;
            if (StringUtils.isNotBlank((CharSequence)eo.getAdjustmentType())) {
                oldAdjustmentType = eo.getAdjustmentType();
                if (Objects.equals(oldAdjustmentType, "1")) {
                    totalFreight = totalFreight.subtract(oldAdjustmentAmount);
                }
                if (Objects.equals(oldAdjustmentType, "2")) {
                    totalFreight = totalFreight.add(oldAdjustmentAmount);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(adjustmentType = modifyReqDto.getAdjustmentType()))) {
                if (Objects.equals(adjustmentType, "1")) {
                    totalFreight = totalFreight.add(modifyReqDto.getAdjustmentAmount());
                }
                if (Objects.equals(adjustmentType, "2")) {
                    totalFreight = totalFreight.subtract(modifyReqDto.getAdjustmentAmount());
                }
            }
            eo.setAdjustmentAmount(eo.getAdjustmentAmount());
            eo.setAdjustmentType(eo.getAdjustmentType());
            eo.setRemark(eo.getRemark());
            eo.setTotalFreight(totalFreight);
            this.adjustmentAmount(modifyReqDto, detailEoList);
            this.totalFreight(eo, detailEoList);
            this.expressCostReportDas.update((BaseEo)eo);
            detailEoList.forEach(i -> this.expressCostDetailDas.update((BaseEo)i));
        } else {
            String adjustmentType;
            ExpressCostDetailEo detailEo = (ExpressCostDetailEo)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().eq((Object)"id", (Object)modifyReqDto.getEditId())).one();
            if (detailEo == null) {
                throw new BizException("\u7f16\u8f91ID\u4e0d\u6b63\u786e");
            }
            ExpressCostReportEo eo = (ExpressCostReportEo)((ExtQueryChainWrapper)this.expressCostReportDas.filter().eq((Object)"id", (Object)detailEo.getReportId())).one();
            if (eo == null) {
                throw new BizException("\u7f16\u8f91ID\u4e0d\u6b63\u786e");
            }
            BigDecimal totalFreight = Optional.ofNullable(detailEo.getTotalFreight()).orElse(BigDecimal.ZERO);
            BigDecimal oldAdjustmentAmount = Optional.ofNullable(detailEo.getAdjustmentAmount()).orElse(BigDecimal.ZERO);
            String oldAdjustmentType = null;
            if (StringUtils.isNotBlank((CharSequence)detailEo.getAdjustmentType())) {
                oldAdjustmentType = detailEo.getAdjustmentType();
                if (Objects.equals(oldAdjustmentType, "1")) {
                    totalFreight = totalFreight.subtract(oldAdjustmentAmount);
                }
                if (Objects.equals(oldAdjustmentType, "2")) {
                    totalFreight = totalFreight.add(oldAdjustmentAmount);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(adjustmentType = modifyReqDto.getAdjustmentType()))) {
                if (Objects.equals(adjustmentType, "1")) {
                    totalFreight = totalFreight.add(modifyReqDto.getAdjustmentAmount());
                }
                if (Objects.equals(adjustmentType, "2")) {
                    totalFreight = totalFreight.subtract(modifyReqDto.getAdjustmentAmount());
                }
            }
            if (BigDecimal.ZERO.compareTo(totalFreight) > 0) {
                throw new BizException("\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u4f7f\u8fd0\u8d39\u5408\u8ba1\u5c0f\u4e8e0");
            }
            eo.setAdjustmentType(adjustmentType);
            detailEo.setAdjustmentType(adjustmentType);
            eo.setAdjustmentAmount(modifyReqDto.getAdjustmentAmount());
            detailEo.setAdjustmentAmount(modifyReqDto.getAdjustmentAmount());
            detailEo.setTotalFreight(totalFreight);
            eo.setTotalFreight(totalFreight);
            eo.setRemark(modifyReqDto.getRemark());
            detailEo.setRemark(modifyReqDto.getRemark());
            this.expressCostReportDas.update((BaseEo)eo);
            this.expressCostDetailDas.update((BaseEo)detailEo);
        }
    }

    @Override
    public void syncExpressCostData(LogisticStatisticReqDto reqDto) {
        log.info("\u751f\u6210\u5feb\u9012\u8d39\u7528\u6570\u636e\uff0c\u79fb\u9664\u65e7\u6570\u636e\u540e\u5728\u66f4\u65b0\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List pastDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().ge((Object)"outbound_time", (Object)reqDto.getStartTime())).le((Object)"outbound_time", (Object)reqDto.getEndTime())).list();
        List<ExpressCostDetailEo> eos = this.queryExpressCostDetailListNew(reqDto, pastDetailEoList);
        if (CollectionUtil.isEmpty(eos)) {
            return;
        }
        log.info("\u540c\u6b65\u5feb\u8d39\u6570\u636e\u6761\u6570:{}", (Object)eos.size());
        this.calculationSave(eos);
        this.expressCostDeliverQuantityService.addExpressCostDeliverQuantityByExpressDetail(eos);
        if (CollectionUtil.isNotEmpty((Collection)pastDetailEoList)) {
            List ids = pastDetailEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            ListUtils.partition(ids, (int)1000).forEach(slice -> this.expressCostDetailDas.logicDeleteByIds(slice));
            List reportIds = pastDetailEoList.stream().map(ExpressCostDetailEo::getReportId).collect(Collectors.toList());
            ListUtils.partition(reportIds, (int)1000).forEach(slice -> this.expressCostReportDas.logicDeleteByIds(slice));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void splitExpressCostDetail(Long reportId) {
        ExpressCostReportEo reportEo = (ExpressCostReportEo)((ExtQueryChainWrapper)this.expressCostReportDas.filter().eq((Object)"id", (Object)reportId)).one();
        if (reportEo == null) {
            throw new BizException("\u53c2\u6570reportId\u4e0d\u6b63\u786e");
        }
        List<ExpressCostDetailEo> eos = this.asyncQueryDetail(reportId);
        if (CollectionUtil.isEmpty(eos)) {
            throw new BizException("\u53c2\u6570reportId\u4e0d\u6b63\u786e");
        }
        this.removeData(eos, reportEo);
        ExpressCostContractEo contractEo = this.getExpressCostContractEo(eos.get(0));
        ArrayList saveEos = Lists.newArrayList();
        eos.forEach(i -> {
            this.setValue((ExpressCostDetailEo)i, contractEo, null);
            saveEos.add(this.getCommonService(i.getChargeMode()).calculationData((ExpressCostDetailEo)i));
        });
        this.saveData(saveEos);
    }

    @Override
    public void againCalculate(AgainCalculateReqDto reqDto) {
        ExpressCostContractEo contractEo = (ExpressCostContractEo)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)reqDto.getContractId())).one();
        if (contractEo == null) {
            throw new BizException("\u5408\u540cID\u4e0d\u6b63\u786e");
        }
        CompletableFuture.runAsync(() -> this.syncAgainCalculate(reqDto, contractEo));
    }

    @Override
    public void againCalculateDocumentNo(AgainCalculateReqDto reqDto) {
        String requestId = ServiceContext.getContext().getRequestId();
        if (StringUtils.isEmpty((CharSequence)reqDto.getDocumentNo())) {
            return;
        }
        List eos = ((ExtQueryChainWrapper)this.expressCostDetailDas.filter().eq((Object)"outbound_code", (Object)reqDto.getDocumentNo())).list();
        if (CollectionUtil.isEmpty((Collection)eos)) {
            return;
        }
        if (((ExpressCostDetailEo)eos.get(0)).getContractId() == null) {
            return;
        }
        ExpressCostContractEo contractEo = (ExpressCostContractEo)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", (Object)((ExpressCostDetailEo)eos.get(0)).getContractId())).one();
        if (contractEo == null) {
            throw new BizException("\u5408\u540cID\u4e0d\u6b63\u786e");
        }
        expressCostExecutor.execute(() -> {
            MDC.put((String)"yes.req.requestId", (String)requestId);
            this.deleteData(eos);
            eos.parallelStream().forEach(i -> this.setValue((ExpressCostDetailEo)i, contractEo, null));
            this.calculationSave(eos);
        });
    }

    @Override
    public ExpressCostReportPollNumDto modifyPollQuery(ExpressCostReportPollNumDto queryDto) {
        this.checkQueryParams(queryDto);
        queryDto.setChargeMode(Integer.valueOf(1));
        String[] split = queryDto.getUpdateMonth().split("-");
        String time = String.format("%s 23:59:59", this.getLastDayOfMonth(Integer.valueOf(split[0]), Integer.valueOf(split[1])));
        Integer count = this.getQueryParams(queryDto, time).count();
        queryDto.setStatisticsPollNum(count);
        return queryDto;
    }

    @Override
    public void modifyPoll(ExpressCostReportPollNumDto modifyPoll) {
        if (modifyPoll.getModifyPollNum() == null || modifyPoll.getModifyPollNum() < 1) {
            throw new BizException("\u4fee\u6539\u7968\u6570\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a0");
        }
        this.checkQueryParams(modifyPoll);
        String[] split = modifyPoll.getUpdateMonth().split("-");
        String time = String.format("%s 23:59:59", this.getLastDayOfMonth(Integer.valueOf(split[0]), Integer.valueOf(split[1])));
        ExpressCostContractEo contractEo = this.checkContract(modifyPoll, time);
        List<ExpressCostDetailEo> eos = this.asyncQueryExpressCostDetailEo(this.getQueryParams(modifyPoll, time));
        if (CollectionUtil.isEmpty(eos)) {
            log.info("\u4fee\u6539\u7968\u6570-\u672a\u67e5\u5230\u5feb\u9012\u8d39\u6570\u636e");
            return;
        }
        CompletableFuture.runAsync(() -> this.modifyPollNum(contractEo, eos, modifyPoll.getModifyPollNum()));
    }

    @Override
    public List<ExpressCostDetailRespDto> queryListByOrders(List<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Lists.newArrayList();
        }
        List eos = ((ExtQueryChainWrapper)this.expressCostDetailDas.filter().in((Object)"outbound_code", orderNos)).list(Integer.valueOf(orderNos.size()));
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)respDtos, ExpressCostDetailRespDto.class);
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdate(List<ExpressCostDetailReqDto> updateList) {
        if (CollectionUtil.isEmpty(updateList)) {
            return;
        }
        List eos = ((ExtQueryChainWrapper)this.expressCostDetailDas.filter().in((Object)"id", (Collection)updateList.stream().map(ExpressCostDetailReqDto::getId).collect(Collectors.toList()))).list(Integer.valueOf(updateList.size()));
        Map eoMap = eos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (ExpressCostDetailReqDto dto : updateList) {
            if (!eoMap.containsKey(dto.getId())) continue;
            ExpressCostDetailEo eo = (ExpressCostDetailEo)eoMap.get(dto.getId());
            this.calculationAmount(eo, dto);
            this.expressCostDetailDas.update((BaseEo)eo);
        }
    }

    @Override
    public void batchInsert(List<ExpressCostDetailReqDto> updateList) {
        if (CollectionUtil.isEmpty(updateList)) {
            return;
        }
        this.setFreightOrg(updateList);
        for (ExpressCostDetailReqDto dto : updateList) {
            ExpressCostDetailEo eo = new ExpressCostDetailEo();
            BeanUtils.copyProperties((Object)dto, (Object)eo);
            this.calculationAmount(eo, dto);
            ExpressCostReportEo expressCostReportEo = new ExpressCostReportEo();
            BeanUtils.copyProperties((Object)eo, (Object)expressCostReportEo);
            this.expressCostReportDas.insert((BaseEo)expressCostReportEo);
            eo.setReportId(expressCostReportEo.getId());
            this.expressCostDetailDas.insert((BaseEo)eo);
        }
    }

    @Override
    public String delete(LogisticStatisticReqDto reqDto) {
        log.info("\u5220\u9664\u5feb\u9012\u8d39\u7528\u62a5\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.expressCostDetailDas.deleteExpressCostDetailAndReport(reqDto);
        return "\u6267\u884c\u5b8c\u6210";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importBatchUpdate(List<ExpressCostDetailReqDto> updateList) {
        log.info("\u5bfc\u5165\u6279\u91cf\u66f4\u65b0\uff1a{}", (Object)JSON.toJSONString(updateList));
        List outboundCodeList = updateList.stream().map(ExpressCostDetailReqDto::getOutboundCode).collect(Collectors.toList());
        Map updateMap = updateList.stream().collect(Collectors.toMap(ExpressCostDetailReqDto::getOutboundCode, Function.identity(), (a1, a2) -> a2));
        List detailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().in((Object)"outbound_code", outboundCodeList)).eq((Object)"dr", (Object)0)).list();
        if (ObjectUtils.isEmpty((Object)detailEoList)) {
            log.info("\u65e0\u5bf9\u5e94\u7684\u5355\u636e");
            return;
        }
        List reportIds = detailEoList.stream().map(ExpressCostDetailEo::getReportId).collect(Collectors.toList());
        List reportEoList = this.expressCostReportDas.selectByIds(reportIds);
        Map reportEoMap = reportEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (a1, a2) -> a2));
        detailEoList.forEach(detail -> {
            ExpressCostReportEo reportEo;
            ExpressCostDetailReqDto dto = (ExpressCostDetailReqDto)updateMap.get(detail.getOutboundCode());
            if (ObjectUtil.isNotEmpty((Object)dto)) {
                if (StringUtils.isNotBlank((CharSequence)dto.getExpressNo())) {
                    detail.setExpressNo(dto.getExpressNo());
                }
                if (ObjectUtil.isNotEmpty((Object)dto.getExpressWeight())) {
                    detail.setExpressWeight(dto.getExpressWeight());
                }
                if (ObjectUtil.isNotEmpty((Object)dto.getReturnFee())) {
                    detail.setReturnFee(dto.getReturnFee());
                }
                if (ObjectUtil.isNotEmpty((Object)dto.getIncrementFreight())) {
                    detail.setIncrementFreight(dto.getIncrementFreight());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getAdjustmentType())) {
                    detail.setAdjustmentType(dto.getAdjustmentType());
                }
                if (ObjectUtil.isNotEmpty((Object)dto.getAdjustmentAmount())) {
                    detail.setAdjustmentAmount(dto.getAdjustmentAmount());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getRemark())) {
                    detail.setRemark(dto.getRemark());
                }
                this.expressCostDetailDas.updateSelective((BaseEo)detail);
            }
            if (ObjectUtil.isNotEmpty((Object)(reportEo = (ExpressCostReportEo)reportEoMap.get(detail.getReportId())))) {
                reportEo.setExpressNo(detail.getExpressNo());
                reportEo.setExpressWeight(detail.getExpressWeight());
                reportEo.setIncrementFreight(detail.getIncrementFreight());
                reportEo.setAdjustmentType(detail.getAdjustmentType());
                reportEo.setAdjustmentAmount(detail.getAdjustmentAmount());
                reportEo.setRemark(detail.getRemark());
                this.expressCostReportDas.updateSelective((BaseEo)reportEo);
            }
        });
    }

    @Override
    public List<ExpressCostDetailRespDto> queryList(ExpressCostDetailReqDto reqDto) {
        log.info("\u5feb\u9012\u8d39\u7528\u62a5\u8868\u5217\u8868\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List detailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().eq(StringUtils.isNotBlank((CharSequence)reqDto.getOutboundCode()), (Object)"outbound_code", (Object)reqDto.getOutboundCode())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getExpressNo()), (Object)"express_no", (Object)reqDto.getExpressNo())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getEasNo()), (Object)"eas_no", (Object)reqDto.getEasNo())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getOutboundCodeList()), (Object)"outbound_code", (Collection)reqDto.getOutboundCodeList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getEasNoList()), (Object)"eas_no", (Collection)reqDto.getEasNoList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getExpressNoList()), (Object)"express_no", (Collection)reqDto.getExpressNoList())).list();
        return BeanUtil.copyToList((Collection)detailEoList, ExpressCostDetailRespDto.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateExpressBackRemake(List<ExpressCostDetailReqDto> reqDtoList) {
        log.info("\u66f4\u65b0\u5feb\u9012\u56de\u4f20\u91cd\u91cf\u5355\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        BigDecimal differenceValue = this.expressCostConfigService.queryDifferenceValue();
        List<ExpressCostDetailEo> detailEoList = reqDtoList.stream().map(dto -> {
            ExpressCostDetailEo costDetailEo = (ExpressCostDetailEo)this.expressCostDetailDas.selectByPrimaryKey(dto.getId());
            AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)costDetailEo), (String)"\u627e\u4e0d\u5230\u8d39\u7528\u6570\u636e");
            costDetailEo.setExpressBackRemake(dto.getExpressBackRemake());
            if (ObjectUtil.isNotEmpty((Object)costDetailEo.getWeight())) {
                costDetailEo.setWeightDifference(costDetailEo.getExpressBackRemake().subtract(costDetailEo.getWeight()).abs());
            }
            if (ObjectUtil.isNotEmpty((Object)differenceValue) && ObjectUtil.isNotEmpty((Object)costDetailEo.getWeightDifference())) {
                if (costDetailEo.getWeightDifference().compareTo(differenceValue) > 0) {
                    costDetailEo.setChargedWeight(null);
                    if (StringUtils.isNotBlank((CharSequence)costDetailEo.getAbnormalCauses())) {
                        costDetailEo.setAbnormalCauses(costDetailEo.getAbnormalCauses() + "\uff1b\u91cd\u91cf\u5dee\u5f02\u5df2\u8d85\u51fa\u5dee\u5f02\u914d\u7f6e" + differenceValue);
                    } else {
                        costDetailEo.setAbnormalCauses("\u91cd\u91cf\u5dee\u5f02\u5df2\u8d85\u51fa\u5dee\u5f02\u914d\u7f6e" + differenceValue);
                    }
                } else {
                    log.info("\u56de\u4f20\u91cd\u91cf\u56de\u663e\u6210\u8ba1\u8d39\u91cd\u91cf");
                    costDetailEo.setChargedWeight(costDetailEo.getExpressBackRemake());
                    if (Objects.equals("\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a", costDetailEo.getAbnormalCauses())) {
                        log.info("\u5f02\u5e38\u539f\u56e0\u53ea\u6709\u201c\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a\u201d\uff0c\u5219\u8f6c\u4e3a\u6b63\u5e38\u5355\u636e");
                        costDetailEo.setAbnormal(Integer.valueOf(0));
                        costDetailEo.setAbnormalCauses(null);
                    }
                }
            }
            log.info("\u5c1d\u8bd5\u5339\u914d\u5feb\u9012\u8d39\u7528\u6a21\u677f......");
            if (!(ObjectUtils.isEmpty((Object)costDetailEo.getWarehouseCode()) || ObjectUtils.isEmpty((Object)costDetailEo.getLogisticCode()) || ObjectUtils.isEmpty((Object)costDetailEo.getTransportType()) || ObjectUtils.isEmpty((Object)costDetailEo.getOutboundTime()) || ObjectUtils.isEmpty((Object)costDetailEo.getChargeMode()))) {
                List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"warehouse_code", (Object)costDetailEo.getWarehouseCode())).eq((Object)"logistic_code", (Object)costDetailEo.getLogisticCode())).eq((Object)"transport_type", (Object)CsShipmentLogisticsTypeEnum.getEnumByName((String)costDetailEo.getTransportType()).getType())).eq((Object)"charge_mode", (Object)costDetailEo.getChargeMode())).eq((Object)"dr", (Object)0)).notIn((Object)"status", new Object[]{"3", "4"})).list();
                log.info("\u83b7\u53d6\u5230\u5f53\u524d\u5feb\u9012\u8d39\u7528\u62a5\u8868\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)list));
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    ExpressCostContractEo expressCostContractEo = (ExpressCostContractEo)list.get(0);
                    long outboundTime = costDetailEo.getOutboundTime().getTime();
                    if (outboundTime >= expressCostContractEo.getStartTime().getTime() && outboundTime < expressCostContractEo.getEndTime().getTime()) {
                        costDetailEo.setExpressCostContractEo(expressCostContractEo);
                    }
                }
            }
            log.info("\u5339\u914d\u5feb\u9012\u8d39\u7528\u6a21\u677f\u7ed3\u675f");
            return costDetailEo;
        }).collect(Collectors.toList());
        log.info("\u66f4\u65b0\u5feb\u9012\u56de\u4f20\u91cd\u91cf\u5355\uff0c\u91cd\u65b0\u8ba1\u8d39");
        this.recalculateByImport(detailEoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateChargedWeight(List<ExpressCostDetailReqDto> reqDtoList) {
        List contractDetailEoList;
        log.info("\u66f4\u65b0\u8ba1\u8d39\u91cd\u91cf\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        List ids = reqDtoList.stream().map(ExpressCostDetailReqDto::getId).collect(Collectors.toList());
        List expressCostDetailEoList = this.expressCostDetailDas.selectByIds(ids);
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)expressCostDetailEoList), (String)"\u627e\u4e0d\u5230\u8be6\u60c5\u4fe1\u606f");
        log.info("\u82e5\u66f4\u65b0\u7684\u660e\u7ec6\u4e3a\u6a21\u72482\u7684\u660e\u7ec6\uff0c\u5219\u9700\u8981\u83b7\u53d6\u540c\u6708\u4efd\u540c\u6a21\u7248\u7684\u6570\u636e\u4e00\u8d77\u66f4\u65b0");
        List contractIds = expressCostDetailEoList.stream().filter(f -> ObjectUtil.isNotEmpty((Object)f.getContractId()) && ObjectUtil.isNotEmpty((Object)f.getChargeMode()) && f.getChargeMode() == 2).map(ExpressCostDetailEo::getContractId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(contractIds) && CollectionUtils.isNotEmpty((Collection)(contractDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().in((Object)"contract_id", contractIds)).eq((Object)"bookkeeping_month", (Object)((ExpressCostDetailEo)expressCostDetailEoList.get(0)).getBookkeepingMonth())).notIn((Object)"id", (Collection)expressCostDetailEoList.stream().map(BaseEo::getId).collect(Collectors.toList()))).list()))) {
            expressCostDetailEoList.addAll(contractDetailEoList);
        }
        Map reqDtoMap = reqDtoList.stream().collect(Collectors.toMap(ExpressCostDetailReqDto::getId, Function.identity(), (v1, v2) -> v2));
        expressCostDetailEoList.forEach(costDetailEo -> {
            log.info("\u5f53\u524d\u7f16\u8f91\u5feb\u9012\u8d39\u7528\u62a5\u8868\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)costDetailEo));
            ExpressCostDetailReqDto dto = (ExpressCostDetailReqDto)reqDtoMap.get(costDetailEo.getId());
            if (ObjectUtil.isNotEmpty((Object)dto)) {
                log.info("\u8c03\u6574\u8d39\u7528\uff1a{}", (Object)JSON.toJSONString((Object)dto));
                costDetailEo.setChargedWeight(dto.getChargedWeight());
                costDetailEo.setVolumeRemark(dto.getVolumeRemark());
            }
            if (costDetailEo.getAbnormalCauses() != null) {
                if (Objects.equals("\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a", costDetailEo.getAbnormalCauses())) {
                    log.info("\u5f02\u5e38\u539f\u56e0\u53ea\u6709\u201c\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a\u201d\uff0c\u5219\u8f6c\u4e3a\u6b63\u5e38\u5355\u636e");
                    costDetailEo.setAbnormal(Integer.valueOf(0));
                    costDetailEo.setAbnormalCauses(null);
                } else if (costDetailEo.getAbnormalCauses().contains("\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a")) {
                    costDetailEo.setAbnormal(Integer.valueOf(0));
                    costDetailEo.setAbnormalCauses(costDetailEo.getAbnormalCauses().replace("\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a\uff1b", "").replace("\uff1b\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a", "").replace("\u3001\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a", "").replace("\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a", ""));
                }
            }
            log.info("\u5c1d\u8bd5\u5339\u914d\u5feb\u9012\u8d39\u7528\u6a21\u677f......");
            if (!(ObjectUtils.isEmpty((Object)costDetailEo.getWarehouseCode()) || ObjectUtils.isEmpty((Object)costDetailEo.getLogisticCode()) || ObjectUtils.isEmpty((Object)costDetailEo.getTransportType()) || ObjectUtils.isEmpty((Object)costDetailEo.getOutboundTime()) || ObjectUtils.isEmpty((Object)costDetailEo.getChargeMode()))) {
                List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"warehouse_code", (Object)costDetailEo.getWarehouseCode())).eq((Object)"logistic_code", (Object)costDetailEo.getLogisticCode())).eq((Object)"transport_type", (Object)CsShipmentLogisticsTypeEnum.getEnumByName((String)costDetailEo.getTransportType()).getType())).eq((Object)"charge_mode", (Object)costDetailEo.getChargeMode())).eq((Object)"dr", (Object)0)).notIn((Object)"status", new Object[]{"3", "4"})).list();
                log.info("\u83b7\u53d6\u5230\u5f53\u524d\u5feb\u9012\u8d39\u7528\u62a5\u8868\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)list));
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    long outboundTime = costDetailEo.getOutboundTime().getTime();
                    for (ExpressCostContractEo expressCostContractEo : list) {
                        if (outboundTime < expressCostContractEo.getStartTime().getTime() || outboundTime >= expressCostContractEo.getEndTime().getTime()) continue;
                        costDetailEo.setExpressCostContractEo(expressCostContractEo);
                        costDetailEo.setContractId(expressCostContractEo.getId());
                        costDetailEo.setChargeMode(expressCostContractEo.getChargeMode());
                        break;
                    }
                }
            }
            log.info("\u5339\u914d\u5feb\u9012\u8d39\u7528\u6a21\u677f\u7ed3\u675f");
        });
        log.info("\u66f4\u65b0\u8ba1\u8d39\u91cd\u91cf\uff0c\u91cd\u65b0\u8ba1\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)expressCostDetailEoList));
        this.recalculateByImport(expressCostDetailEoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void ignoreRepeat(List<ExpressCostDetailReqDto> reqDtoList) {
        log.info("\u5ffd\u7565\u91cd\u590d\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        List ids = reqDtoList.stream().map(ExpressCostDetailReqDto::getId).collect(Collectors.toList());
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty(ids), (String)"\u8bf7\u6c42\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        List detailEoList = this.expressCostDetailDas.selectByIds(ids);
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)detailEoList), (String)"\u627e\u4e0d\u5230\u9700\u8981\u4fee\u6539\u7684\u6570\u636e");
        detailEoList.forEach(eo -> {
            ExpressCostDetailEo updEo = new ExpressCostDetailEo();
            updEo.setId(eo.getId());
            updEo.setIfRepeat(Integer.valueOf(0));
            this.expressCostDetailDas.updateSelective((BaseEo)updEo);
        });
    }

    @Override
    public PageInfo<MasterOrderDifferenceDto> queryPageMasterOrderDifference(ExpressCostReportQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u603b\u5355\u5dee\u5f02\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        queryDto.setLogisticCodeList(this.getCarrierCodeList());
        return this.expressCostDetailDas.queryPageMasterOrderDifference(queryDto);
    }

    @Override
    public PageInfo<MasterOrderDifferenceDetailDto> queryPageMasterOrderDifferenceDetail(MasterOrderDifferenceDetailDto dto) {
        log.info("\u5206\u9875\u67e5\u8be2\u603b\u5355\u5dee\u5f02\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        return this.expressCostDetailDas.queryPageMasterOrderDifferenceDetail(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchRemoveExpressCostDetail(List<Long> ids) {
        log.info("\u6279\u91cf\u5220\u9664\u5feb\u9012\u8d39\u7528\u62a5\u8868\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString(ids));
        List detailEoList = this.expressCostDetailDas.selectByIds(ids);
        if (CollectionUtil.isNotEmpty((Collection)detailEoList)) {
            detailEoList.forEach(detailEo -> {
                this.expressCostDetailDas.logicDeleteById(detailEo.getId());
                if (ObjectUtil.isNotEmpty((Object)detailEo.getReportId())) {
                    this.expressCostReportDas.logicDeleteById(detailEo.getReportId());
                }
            });
        }
    }

    @Override
    public void generateExpressCostData(LogisticStatisticReqDto reqDto) {
        log.info("\u751f\u6210\u5feb\u9012\u62a5\u8868\u6570\u636e\uff08\u4f1a\u5220\u9664\u4e45\u6570\u636e\uff09\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        Boolean flag = this.cacheService.setIfAbsent("generateExpressCostData", (Object)true, 3600);
        if (flag.booleanValue()) {
            try {
                this.syncExpressCostData(reqDto);
            }
            finally {
                this.cacheService.delCache("generateExpressCostData");
            }
        } else {
            throw new BizException("-1", "\u64cd\u4f5c\u751f\u6210\u5feb\u9012\u8d39\u7528\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u5feb\u9012\u8d39\u7528\u8d39\u7528\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        ExpressCostDetailEo updateEo = new ExpressCostDetailEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List eos = this.expressCostDetailDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = eos.stream().filter(eo -> eo.getPlacedFlag() == null || eo.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.expressCostDetailDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        log.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }

    @Override
    public void editCost(ExpressCostDetailReqDto reqDto) {
        log.info("\u7f16\u8f91\u5176\u4ed6\u8d39\u7528\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)reqDto.getId()), (String)"\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a");
        ExpressCostDetailEo detailEo = (ExpressCostDetailEo)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().eq((Object)"id", (Object)reqDto.getId())).one();
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)detailEo), (String)("\u627e\u4e0d\u5230\u8d39\u7528\u4fe1\u606f\uff1a" + reqDto.getId()));
        if (ObjectUtil.isNotEmpty((Object)detailEo.getChargeMode()) && detailEo.getChargeMode() == 2) {
            this.updateTotalFreightForMT(detailEo, reqDto);
        } else {
            detailEo.setPackingFreight(reqDto.getPackingFreight());
            detailEo.setReturnFee(reqDto.getReturnFee());
            detailEo.setIncrementFreight(reqDto.getIncrementFreight());
            detailEo.setInsureAmount(reqDto.getInsureAmount());
            detailEo.setPremium(reqDto.getPremium());
            detailEo.setAdjustmentType(reqDto.getAdjustmentType());
            detailEo.setAdjustmentAmount(reqDto.getAdjustmentAmount());
            detailEo.setRemark(reqDto.getRemark());
            detailEo.setTotalFreight(BigDecimal.ZERO);
            this.calculationTotalFreightBase(detailEo);
        }
        this.expressCostDetailDas.update((BaseEo)detailEo);
    }

    private void updateTotalFreightForMT(ExpressCostDetailEo detailEo, ExpressCostDetailReqDto reqDto) {
        BigDecimal totalFreight;
        log.info("\u6a21\u72482\u66f4\u65b0\u5176\u4ed6\u8d39\u7528\uff0c\u8ba1\u7b97\u603b\u8fd0\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)detailEo));
        BigDecimal bigDecimal = totalFreight = ObjectUtil.isNotEmpty((Object)detailEo.getTotalFreight()) ? detailEo.getTotalFreight() : BigDecimal.ZERO;
        if (ObjectUtil.isNotEmpty((Object)detailEo.getPackingFreight())) {
            totalFreight = totalFreight.subtract(detailEo.getPackingFreight());
        }
        if (ObjectUtil.isNotEmpty((Object)detailEo.getReturnFee())) {
            totalFreight = totalFreight.subtract(detailEo.getReturnFee());
        }
        if (ObjectUtil.isNotEmpty((Object)detailEo.getIncrementFreight())) {
            totalFreight = totalFreight.subtract(detailEo.getIncrementFreight());
        }
        if (ObjectUtil.isNotEmpty((Object)detailEo.getInsureAmount())) {
            totalFreight = totalFreight.subtract(detailEo.getInsureAmount());
        }
        if (ObjectUtil.isNotEmpty((Object)detailEo.getPremium())) {
            totalFreight = totalFreight.subtract(detailEo.getPremium());
        }
        if (ObjectUtil.isNotEmpty((Object)detailEo.getAdjustmentAmount()) && detailEo.getAdjustmentType().equals("1")) {
            totalFreight = totalFreight.subtract(detailEo.getAdjustmentAmount());
        }
        if (ObjectUtil.isNotEmpty((Object)detailEo.getAdjustmentAmount()) && !detailEo.getAdjustmentType().equals("1")) {
            totalFreight = totalFreight.add(detailEo.getAdjustmentAmount());
        }
        detailEo.setPackingFreight(reqDto.getPackingFreight());
        detailEo.setReturnFee(reqDto.getReturnFee());
        detailEo.setIncrementFreight(reqDto.getIncrementFreight());
        detailEo.setInsureAmount(reqDto.getInsureAmount());
        detailEo.setPremium(reqDto.getPremium());
        detailEo.setAdjustmentType(reqDto.getAdjustmentType());
        detailEo.setAdjustmentAmount(reqDto.getAdjustmentAmount());
        detailEo.setRemark(reqDto.getRemark());
        totalFreight = totalFreight.add(ObjectUtil.isNotEmpty((Object)detailEo.getPackingFreight()) ? detailEo.getPackingFreight() : BigDecimal.ZERO);
        totalFreight = totalFreight.add(ObjectUtil.isNotEmpty((Object)detailEo.getReturnFee()) ? detailEo.getReturnFee() : BigDecimal.ZERO);
        totalFreight = totalFreight.add(ObjectUtil.isNotEmpty((Object)detailEo.getIncrementFreight()) ? detailEo.getIncrementFreight() : BigDecimal.ZERO);
        totalFreight = totalFreight.add(ObjectUtil.isNotEmpty((Object)detailEo.getInsureAmount()) ? detailEo.getInsureAmount() : BigDecimal.ZERO);
        totalFreight = totalFreight.add(ObjectUtil.isNotEmpty((Object)detailEo.getPremium()) ? detailEo.getPremium() : BigDecimal.ZERO);
        if (ObjectUtil.isNotEmpty((Object)detailEo.getAdjustmentAmount()) && detailEo.getAdjustmentType().equals("1")) {
            totalFreight = totalFreight.add(detailEo.getAdjustmentAmount());
        }
        if (ObjectUtil.isNotEmpty((Object)detailEo.getAdjustmentAmount()) && !detailEo.getAdjustmentType().equals("1")) {
            totalFreight = totalFreight.subtract(detailEo.getAdjustmentAmount());
        }
        detailEo.setTotalFreight(totalFreight);
    }

    @Override
    public void updateByExpressCostDeliverQuantity(ExpressCostDeliverQuantityReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)MDC.get((String)"yes.req.requestId"))) {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
        }
        log.info("\u66f4\u65b0\u660e\u7ec6\u4fe1\u606f\uff08\u6839\u636e\u6708\u53d1\u8d27\u7edf\u8ba1\u53d8\u52a8\u66f4\u65b0\uff09\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List detailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().eq((Object)"bookkeeping_month", (Object)reqDto.getBookkeepingMonth())).eq((Object)"warehouse_code", (Object)reqDto.getWarehouseCode())).eq((Object)"logistic_code", (Object)reqDto.getLogisticCode())).eq((Object)"transport_type", (Object)reqDto.getTransportType())).list();
        if (CollectionUtil.isEmpty((Collection)detailEoList)) {
            log.info("\u65e0\u660e\u7ec6\u9700\u8981\u5904\u7406");
            return;
        }
        ExpressCostDetailEo costDetailEo = (ExpressCostDetailEo)detailEoList.get(0);
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"warehouse_code", (Object)costDetailEo.getWarehouseCode())).eq((Object)"logistic_code", (Object)costDetailEo.getLogisticCode())).eq((Object)"transport_type", (Object)CsShipmentLogisticsTypeEnum.getEnumByName((String)costDetailEo.getTransportType()).getType())).eq((Object)"charge_mode", (Object)costDetailEo.getChargeMode())).eq((Object)"dr", (Object)0)).notIn((Object)"status", new Object[]{"3", "4"})).list();
        log.info("\u83b7\u53d6\u5230\u5f53\u524d\u5feb\u9012\u8d39\u7528\u62a5\u8868\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)list));
        ExpressCostContractEo contractEo = new ExpressCostContractEo();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ExpressCostContractEo expressCostContractEo = (ExpressCostContractEo)list.get(0);
            long outboundTime = costDetailEo.getOutboundTime().getTime();
            if (outboundTime >= expressCostContractEo.getStartTime().getTime() && outboundTime < expressCostContractEo.getEndTime().getTime()) {
                costDetailEo.setExpressCostContractEo(expressCostContractEo);
                contractEo = expressCostContractEo;
            }
        }
        if (ObjectUtil.isNotEmpty((Object)contractEo)) {
            for (ExpressCostDetailEo detail : detailEoList) {
                detail.setContractId(contractEo.getId());
                detail.setExpressCostContractEo(contractEo);
                detail.setChargeMode(contractEo.getChargeMode());
            }
        }
        this.recalculateByImport(detailEoList);
    }

    @Override
    public Long addExpressCostDetailByImport(List<ExpressCostDetailReqDto> reqDtoList) {
        log.info("\u6839\u636e\u5bfc\u5165\u65b0\u589e\u5feb\u9012\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        if (CollectionUtil.isNotEmpty(reqDtoList)) {
            reqDtoList.forEach(reqDto -> {
                ExpressCostDetailEo eo = (ExpressCostDetailEo)BeanUtil.copyProperties((Object)reqDto, ExpressCostDetailEo.class, (String[])new String[0]);
                eo.setContinuedOnePer(reqDto.getContinuedOnePre());
                eo.setContinuedTwoPer(reqDto.getContinuedTwoPre());
                eo.setContinuedThreePer(reqDto.getContinuedThreePre());
                eo.setContinuedFourPer(reqDto.getContinuedFourPre());
                eo.setFirstPricePer(reqDto.getFirstPricePre());
                eo.setBillType(LogisticDocumentTypeEnum.ORIGINAL.getCode());
                ExpressCostReportEo expressCostReportEo = new ExpressCostReportEo();
                BeanUtils.copyProperties((Object)eo, (Object)expressCostReportEo);
                this.expressCostReportDas.insert((BaseEo)expressCostReportEo);
                eo.setReportId(expressCostReportEo.getId());
                this.expressCostDetailDas.insert((BaseEo)eo);
            });
        }
        return null;
    }

    @Override
    public void updExpressCostDetailByImport(ExpressCostDetailReqDto reqDto) {
        ExpressCostReportEo reportEo;
        log.info("\u6839\u636e\u5bfc\u5165\u66f4\u65b0\u5feb\u9012\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)reqDto.getId()), (String)"\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a");
        ExpressCostDetailEo detailEo = (ExpressCostDetailEo)this.expressCostDetailDas.selectByPrimaryKey(reqDto.getId());
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)detailEo), (String)"\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
        ExpressCostDetailEo insertEo = (ExpressCostDetailEo)BeanUtil.copyProperties((Object)reqDto, ExpressCostDetailEo.class, (String[])new String[0]);
        insertEo.setId(reqDto.getId());
        insertEo.setContinuedOnePer(reqDto.getContinuedOnePre());
        insertEo.setContinuedTwoPer(reqDto.getContinuedTwoPre());
        insertEo.setContinuedThreePer(reqDto.getContinuedThreePre());
        insertEo.setContinuedFourPer(reqDto.getContinuedFourPre());
        insertEo.setFirstPricePer(reqDto.getFirstPricePre());
        this.expressCostDetailDas.updateSelective((BaseEo)insertEo);
        if (ObjectUtil.isNotEmpty((Object)detailEo.getReportId()) && ObjectUtil.isNotEmpty((Object)(reportEo = (ExpressCostReportEo)this.expressCostReportDas.selectByPrimaryKey(detailEo.getReportId())))) {
            ExpressCostReportEo costReportEo = (ExpressCostReportEo)BeanUtil.copyProperties((Object)reqDto, ExpressCostReportEo.class, (String[])new String[0]);
            costReportEo.setId(reportEo.getId());
            this.expressCostReportDas.updateSelective((BaseEo)costReportEo);
        }
    }

    private void recalculateByImport(List<ExpressCostDetailEo> detailEoList) {
        log.info("\u91cd\u65b0\u8ba1\u7b97\uff08\u7528\u4e8e\u5feb\u9012\u56de\u4f20\u91cd\u91cf\u5bfc\u5165\u3001\u8ba1\u8d39\u91cd\u91cf\u5bfc\u5165\u540e\u6570\u636e\u53d8\u66f4\u91cd\u65b0\u8ba1\u8d39\uff09\uff1a{}", (Object)JSON.toJSONString(detailEoList));
        this.deleteData(detailEoList);
        detailEoList.forEach(eo -> {
            eo.setId(null);
            eo.setReportId(null);
            eo.setFirstPrice(null);
            eo.setFirstPricePer(null);
            eo.setContinuedOne(null);
            eo.setContinuedOnePer(null);
            eo.setContinuedTwo(null);
            eo.setContinuedTwoPer(null);
            eo.setContinuedThree(null);
            eo.setContinuedThreePer(null);
            eo.setContinuedFour(null);
            eo.setContinuedFourPer(null);
            eo.setContinuedFreight(null);
            eo.setRelevanceNo(eo.getBusinessCode());
            eo.setUpdateTime(null);
            eo.setUpdatePerson(null);
        });
        this.calculationSave(detailEoList);
    }

    @Override
    public List<ExpressCostDetailRespDto> queryListByExpressOrders(List<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Lists.newArrayList();
        }
        List eos = ((ExtQueryChainWrapper)this.expressCostDetailDas.filter().in((Object)"express_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)respDtos, ExpressCostDetailRespDto.class);
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void recalculateVotes(String yearMoth) {
        String endTime;
        TwoTuple<String, String> time = this.getTime(yearMoth);
        String startTime = (String)time.getFirst();
        Map<Long, List<ExpressCostDetailEo>> map = this.getCalculationData(startTime, endTime = (String)time.getSecond());
        if (CollectionUtil.isEmpty(map)) {
            log.info("\u8ba1\u7b97\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        map.forEach((contractId, details) -> {
            ExpressCostContractEo contractEo = (ExpressCostContractEo)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", contractId)).one();
            Map<String, List<ExpressCostDetailEo>> groupMap = details.stream().collect(Collectors.groupingBy(ExpressCostDetailEo::getWarehouseCode));
            groupMap.forEach((warehouseCode, eos) -> {
                Integer pullNum = this.queryPullNum(startTime, endTime, 1, (String)warehouseCode);
                if (pullNum < 2 || eos.size() < 2) {
                    log.info("\u6309\u4ed3\u5e93\u5206\u7ec4\u540e\u7968\u6570\u5c11\u4e8e\u4e24\u7968\u4e0d\u9700\u8981\u91cd\u65b0\u8ba1\u7b97");
                    return;
                }
                this.deleteData((List<ExpressCostDetailEo>)eos);
                eos.forEach(i -> this.setValue((ExpressCostDetailEo)i, contractEo, pullNum));
                this.calculationSave((List<ExpressCostDetailEo>)eos);
            });
        });
    }

    @Override
    public void recalculateDiscount(String yearMoth) {
        String endTime;
        TwoTuple<String, String> time = this.getTime(yearMoth);
        String startTime = (String)time.getFirst();
        List<ExpressCostDetailEo> details = this.queryDetail(startTime, endTime = (String)time.getSecond(), 2);
        if (CollectionUtil.isEmpty(details) || details.size() < 2) {
            log.info("\u91cd\u65b0\u8ba1\u7b97\u6298\u6263\u5355\u636e\u5c11\u4e8e\u4e24\u5355\u4e0d\u9700\u8981\u91cd\u65b0\u8ba1\u7b97");
            return;
        }
        BigDecimal totalFreight = this.queryTotalFreight(startTime, endTime, 2);
        if (totalFreight == null || totalFreight.compareTo(BigDecimal.ZERO) <= 0) {
            log.info("\u91cd\u65b0\u8ba1\u7b97\u6298\u6263\u5355\u636e\u603b\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u4e0d\u9700\u8981\u91cd\u65b0\u8ba1\u7b97");
            return;
        }
        Map<Long, List<ExpressCostDetailEo>> map = details.stream().filter(i -> i.getContractId() != null).collect(Collectors.groupingBy(ExpressCostDetailEo::getContractId));
        map.forEach((contractId, eos) -> {
            ExpressCostContractEo contractEo = (ExpressCostContractEo)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"id", contractId)).one();
            if (contractEo.getDiscountType() != null && Objects.equals(2, contractEo.getDiscountType())) {
                this.deleteData((List<ExpressCostDetailEo>)eos);
                eos.forEach(i -> {
                    this.setValue((ExpressCostDetailEo)i, contractEo, null);
                    i.setCalculationTotalFreight(totalFreight);
                });
                this.calculationSave((List<ExpressCostDetailEo>)eos);
            }
        });
    }

    private Map<Long, List<ExpressCostDetailEo>> getCalculationData(String startTime, String endTime) {
        List<ExpressCostDetailEo> details = this.queryDetail(startTime, endTime, 1);
        if (CollectionUtil.isEmpty(details) || details.size() < 2) {
            log.info("\u5355\u636e\u5c11\u4e8e\u4e24\u5355\u4e0d\u9700\u8981\u91cd\u65b0\u8ba1\u7b97");
            return null;
        }
        return details.stream().filter(i -> i.getContractId() != null).collect(Collectors.groupingBy(ExpressCostDetailEo::getContractId));
    }

    private Integer queryPullNum(String startTime, String endTime, Integer chargeMode, String warehouseCode) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().ge((Object)"create_time", (Object)startTime)).le((Object)"create_time", (Object)endTime)).eq((Object)"charge_mode", (Object)chargeMode)).eq((Object)"warehouse_code", (Object)warehouseCode)).count();
    }

    private BigDecimal queryTotalFreight(String startTime, String endTime, Integer chargeMode) {
        return this.expressCostDetailDas.queryTotalFreight(startTime, endTime, chargeMode);
    }

    private List<ExpressCostDetailEo> queryDetail(String startTime, String endTime, Integer chargeMode) {
        ArrayList dtoList = Lists.newArrayList();
        Integer pageNum = 1;
        while (true) {
            PageInfo page;
            if ((page = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().ge((Object)"create_time", (Object)startTime)).le((Object)"create_time", (Object)endTime)).ne((Object)"bill_type", (Object)3)).eq((Object)"charge_mode", (Object)chargeMode)).page(pageNum, Integer.valueOf(10000))) != null && CollectionUtil.isNotEmpty((Collection)page.getList())) {
                ArrayList list = Lists.newArrayList();
                dtoList.addAll(list);
            }
            if (page == null || CollectionUtil.isEmpty((Collection)page.getList()) || page.getList().size() < 10000) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        if (CollectionUtil.isEmpty((Collection)dtoList)) {
            return null;
        }
        return dtoList;
    }

    private TwoTuple<String, String> getTime(String yearMoth) {
        String startTime = "";
        String endTime = "";
        if (StringUtils.isBlank((CharSequence)yearMoth)) {
            startTime = DateTimeUtils.getBeforeFirstMonthDate();
            endTime = DateTimeUtils.getBeforeLastMonthDate();
        } else {
            startTime = String.format("%s 01 00:00:00", yearMoth);
            endTime = String.format("%s 31 23:59:59", yearMoth);
        }
        TwoTuple twoTuple = new TwoTuple((Object)startTime, (Object)endTime);
        return twoTuple;
    }

    private void setFreightOrg(List<ExpressCostDetailReqDto> updateList) {
        HashSet outCodes = Sets.newHashSet();
        HashSet inCodes = Sets.newHashSet();
        updateList.forEach(i -> {
            if (StringUtils.isNotBlank((CharSequence)i.getOutWarehouseCode()) && StringUtils.isNotBlank((CharSequence)i.getInWarehouseCode())) {
                outCodes.add(i.getOutWarehouseCode());
                inCodes.add(i.getInWarehouseCode());
            }
        });
        Map<String, FeeAttributionConfigEo> feeAttributionConfigEoMap = this.asyncQueryFeeAttributionConfig(outCodes, inCodes);
        updateList.forEach(i -> {
            FeeAttributionConfigEo one;
            String key;
            if (StringUtils.isNotBlank((CharSequence)i.getInWarehouseCode()) && StringUtils.isNotBlank((CharSequence)i.getOutWarehouseCode()) && feeAttributionConfigEoMap.containsKey(key = String.format("%s%s", i.getOutWarehouseCode(), i.getInWarehouseCode())) && (one = (FeeAttributionConfigEo)feeAttributionConfigEoMap.get(key)) != null) {
                i.setFreightOrg(one.getCostBelongOrgName());
            }
            if (StringUtils.isBlank((CharSequence)i.getFreightOrg())) {
                i.setFreightOrg(i.getOutOrg());
            }
        });
    }

    private void calculationAmount(ExpressCostDetailEo eo, ExpressCostDetailReqDto dto) {
        BigDecimal totalFreight;
        eo.setAdjustmentType(dto.getAdjustmentType());
        eo.setAdjustmentAmount(dto.getAdjustmentAmount());
        eo.setReturnFee(dto.getReturnFee());
        eo.setIncrementFreight(dto.getIncrementFreight());
        eo.setRemark(dto.getRemark());
        BigDecimal bigDecimal = totalFreight = eo.getFirstPrice() != null ? eo.getFirstPrice() : BigDecimal.ZERO;
        if (eo.getContinuedFreight() != null) {
            totalFreight = totalFreight.add(eo.getContinuedFreight());
        }
        if (eo.getFloatAmount() != null) {
            totalFreight = totalFreight.add(eo.getFloatAmount());
        }
        if (eo.getPackingFreight() != null) {
            totalFreight = totalFreight.add(eo.getPackingFreight());
        }
        if (eo.getReturnFee() != null) {
            totalFreight = totalFreight.add(eo.getReturnFee());
        }
        if (eo.getIncrementFreight() != null) {
            totalFreight = totalFreight.add(eo.getIncrementFreight());
        }
        if (eo.getPremium() != null) {
            totalFreight = totalFreight.add(eo.getPremium());
        }
        if (eo.getAdjustmentAmount() != null) {
            totalFreight = Objects.equals(eo.getAdjustmentType(), "1") ? totalFreight.add(eo.getAdjustmentAmount()) : totalFreight.subtract(eo.getAdjustmentAmount());
        }
        eo.setTotalFreight(totalFreight);
    }

    @Transactional(rollbackFor={Exception.class})
    private void modifyPollNum(ExpressCostContractEo contractEo, List<ExpressCostDetailEo> eos, Integer modifyPollNum) {
        this.deleteData(eos);
        eos.forEach(i -> this.setValue((ExpressCostDetailEo)i, contractEo, modifyPollNum));
        this.calculationSave(eos);
    }

    private List<ExpressCostDetailEo> asyncQueryExpressCostDetailEo(ExtQueryChainWrapper<ExpressCostDetailEo> filter) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.queryExpressCostDetailEo(filter), this.statisticsExecutor);
        try {
            List list = future.get();
            if (CollectionUtil.isEmpty((Collection)list)) {
                return null;
            }
            return list;
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u5feb\u9012\u8d26\u5355\u8be6\u60c5\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private List<ExpressCostDetailEo> queryExpressCostDetailEo(ExtQueryChainWrapper<ExpressCostDetailEo> filter) {
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList eos = Lists.newArrayList();
        while (true) {
            PageInfo page;
            List list;
            if (CollectionUtil.isNotEmpty((Collection)(list = (page = filter.page(pageNum, pageSize)).getList()))) {
                eos.addAll(list);
            }
            if (CollectionUtil.isEmpty((Collection)list) || list.size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        return eos;
    }

    private ExpressCostContractEo checkContract(ExpressCostReportPollNumDto modifyPoll, String time) {
        ExpressCostContractEo contractEo = (ExpressCostContractEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostContractDas.filter().eq((Object)"warehouse_code", (Object)modifyPoll.getWarehouseCode())).eq((Object)"logistic_code", (Object)modifyPoll.getLogisticCode())).eq((Object)"transport_type", (Object)modifyPoll.getTransportType())).eq((Object)"charge_mode", (Object)1)).ne((Object)"status", (Object)3)).and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.or(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"start_time", (Object)modifyPoll.getUpdateMonth())).ge((Object)"end_time", (Object)modifyPoll.getUpdateMonth());
            })).or(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"start_time", (Object)time)).ge((Object)"end_time", (Object)time);
            })).or(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"end_time", (Object)time)).ge((Object)"start_time", (Object)modifyPoll.getUpdateMonth());
            });
        })).last("limit 1")).one();
        if (contractEo == null) {
            throw new BizException("\u67e5\u4e0d\u5230\u5bf9\u5e94\u5408\u540c\u6570\u636e");
        }
        return contractEo;
    }

    private ExtQueryChainWrapper<ExpressCostDetailEo> getQueryParams(ExpressCostReportPollNumDto queryDto, String time) {
        Date monthBegin = DateUtil.getMonthBegin((Date)DateUtil.parseDate((String)time, (String)"yyyy-MM-dd HH:mm:ss"));
        return (ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().in(CollectionUtils.isNotEmpty((Collection)queryDto.getDocumentNos()), (Object)"outbound_code", (Collection)queryDto.getDocumentNos())).eq((Object)"charge_mode", (Object)queryDto.getChargeMode())).ge((Object)"outbound_time", (Object)monthBegin)).le((Object)"outbound_time", (Object)time)).eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode())).eq((Object)"logistic_code", (Object)queryDto.getLogisticCode())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getTransportType()), (Object)"transport_type", (Object)String.valueOf(CsShipmentLogisticsTypeEnum.getDescByType((Integer)Integer.valueOf(queryDto.getTransportType()))));
    }

    private void checkQueryParams(ExpressCostReportPollNumDto queryDto) {
        if (StringUtils.isBlank((CharSequence)queryDto.getWarehouseCode())) {
            throw new BizException("\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)queryDto.getLogisticCode())) {
            throw new BizException("\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)queryDto.getTransportType())) {
            throw new BizException("\u7269\u627f\u8fd0\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)queryDto.getUpdateMonth())) {
            throw new BizException("\u66f4\u65b0\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String getLastDayOfMonth(Integer year, Integer month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return DateTimeUtils.formatDate(cal.getTime(), "yyyy-MM-dd");
    }

    @Transactional(rollbackFor={Exception.class})
    private void syncAgainCalculate(AgainCalculateReqDto reqDto, ExpressCostContractEo contractEo) {
        log.info("\u5feb\u9012\u8fd0\u8d39\u66f4\u65b0\u5408\u540c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        try {
            List<ExpressCostDetailEo> eos = this.queryExpressCostDetailEo(contractEo, reqDto.getAbnormal());
            if (CollectionUtil.isEmpty(eos)) {
                return;
            }
            this.deleteData(eos);
            eos.forEach(i -> this.setValue((ExpressCostDetailEo)i, contractEo, null));
            this.calculationSave(eos);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8d26\u5355\u51fa\u9519", (Throwable)e);
        }
    }

    private void deleteData(List<ExpressCostDetailEo> eos) {
        HashSet ids = Sets.newHashSet();
        eos.forEach(i -> {
            ids.add(i.getReportId());
            this.expressCostDetailDas.logicDeleteById(i.getId());
        });
        this.expressCostReportDas.logicDeleteByIds(new ArrayList(ids));
    }

    @Transactional(rollbackFor={Exception.class})
    private void calculationSave(List<ExpressCostDetailEo> eos) {
        TwoTuple<List<ExpressCostDetailEo>, List<ExpressCostDetailEo>> twoTuple = this.calculationData(eos);
        List correctDataList = (List)twoTuple.getFirst();
        List abnormalDataList = (List)twoTuple.getSecond();
        this.saveData(abnormalDataList);
        this.saveData(correctDataList);
    }

    public List<ExpressCostDetailEo> queryExpressCostDetailEo(ExpressCostContractEo contractEo, Boolean abnormal) {
        ArrayList dtoList = Lists.newArrayList();
        Integer pageNum = 1;
        while (true) {
            PageInfo page;
            ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().ge((Object)"outbound_time", (Object)contractEo.getStartTime())).le((Object)"outbound_time", (Object)contractEo.getEndTime())).eq((Object)"warehouse_code", (Object)contractEo.getWarehouseCode())).eq(StringUtils.isNotBlank((CharSequence)contractEo.getTransportType()), (Object)"transport_type", (Object)String.valueOf(CsShipmentLogisticsTypeEnum.getDescByType((Integer)Integer.valueOf(contractEo.getTransportType()))))).eq((Object)"logistic_code", (Object)contractEo.getLogisticCode());
            if (abnormal.booleanValue()) {
                filter.eq((Object)"abnormal", (Object)1);
            }
            if ((page = filter.page(pageNum, Integer.valueOf(10000))) == null || CollectionUtil.isEmpty((Collection)page.getList())) break;
            dtoList.addAll(page.getList());
            if (page.getList().size() < 10000) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        if (CollectionUtil.isEmpty((Collection)dtoList)) {
            return null;
        }
        return dtoList;
    }

    private void setValue(ExpressCostDetailEo i, ExpressCostContractEo contractEo, Integer modifyPollNum) {
        i.setWeightRange(null);
        i.setFirstPrice(null);
        i.setContinuedOne(null);
        i.setContinuedTwo(null);
        i.setContinuedThree(null);
        i.setContinuedFour(null);
        i.setFloatAmount(null);
        i.setContinuedFreight(null);
        i.setReturnFee(null);
        i.setPremium(null);
        i.setInsureAmount(null);
        i.setTotalFreight(null);
        i.setId(null);
        i.setReportId(null);
        i.setExpressCostContractEo(contractEo);
        i.setAbnormal(Integer.valueOf(0));
        i.setAbnormalCauses(null);
        i.setPackingFreight(null);
        if (contractEo != null) {
            i.setChargeMode(contractEo.getChargeMode());
        }
        if (modifyPollNum != null) {
            i.setPollNum(modifyPollNum);
        }
        i.setCalculationWeight(null);
        i.setVolumeWeight(null);
    }

    private ExpressCostContractEo getExpressCostContractEo(ExpressCostDetailEo eo) {
        ExpressCostContractEo contractEo = null;
        if (eo.getOutboundTime() != null && StringUtils.isNotBlank((CharSequence)eo.getWarehouseCode()) && StringUtils.isNotBlank((CharSequence)eo.getLogisticCode()) && StringUtils.isNotBlank((CharSequence)eo.getTransportType())) {
            ExpressCostQueryPo reqDto = new ExpressCostQueryPo();
            reqDto.setWhCode(eo.getWarehouseCode());
            reqDto.setLogisticCompany(eo.getLogisticCode());
            reqDto.setTransportType(eo.getTransportType());
            reqDto.setOutWarehouseTime(eo.getOutboundTime());
            ArrayList queryList = Lists.newArrayList();
            List<ExpressCostContractEo> expressCostContractEos = this.queryExpressCostModes(queryList);
            if (CollectionUtil.isNotEmpty(expressCostContractEos)) {
                contractEo = expressCostContractEos.get(0);
            }
        }
        return contractEo;
    }

    private void removeData(List<ExpressCostDetailEo> detailRespDtoList, ExpressCostReportEo reportEo) {
        HashSet reportIds = Sets.newHashSet();
        detailRespDtoList.forEach(i -> this.expressCostDetailDas.delete((BaseEo)i));
        this.expressCostReportDas.delete((BaseEo)reportEo);
    }

    private List<ExpressCostDetailEo> asyncQueryDetail(Long reportId) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.queryDetail(reportId), this.statisticsExecutor);
        try {
            List eos = future.get();
            if (CollectionUtil.isEmpty((Collection)eos)) {
                return null;
            }
            return eos;
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private List<ExpressCostDetailEo> queryDetail(Long reportId) {
        ArrayList eoList = Lists.newArrayList();
        Integer pageNum = 1;
        Integer pageSize = 1000;
        while (true) {
            PageInfo page;
            if (CollectionUtil.isNotEmpty((Collection)(page = ((ExtQueryChainWrapper)this.expressCostDetailDas.filter().eq((Object)"report_id", (Object)reportId)).page(pageNum, pageSize)).getList())) {
                eoList.addAll(page.getList());
            }
            if (page == null || CollectionUtil.isEmpty((Collection)page.getList()) || page.getList().size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        return eoList;
    }

    private void saveData(List<ExpressCostDetailEo> eoList) {
        if (CollectionUtil.isNotEmpty(eoList)) {
            eoList.forEach(eo -> {
                eo.setBillType(LogisticDocumentTypeEnum.ORIGINAL.getCode());
                ExpressCostReportEo expressCostReportEo = new ExpressCostReportEo();
                BeanUtils.copyProperties((Object)eo, (Object)expressCostReportEo);
                this.expressCostReportDas.insert((BaseEo)expressCostReportEo);
                eo.setReportId(expressCostReportEo.getId());
                this.expressCostDetailDas.insert((BaseEo)eo);
            });
        }
    }

    private void saveMergeData(List<ExpressCostDetailEo> eoList) {
        if (CollectionUtil.isNotEmpty(eoList)) {
            eoList.forEach(eo -> {
                eo.setBillType(LogisticDocumentTypeEnum.ORIGINAL.getCode());
                ExpressCostReportEo expressCostReportEo = new ExpressCostReportEo();
                BeanUtils.copyProperties((Object)eo, (Object)expressCostReportEo);
                this.expressCostReportDas.insert((BaseEo)expressCostReportEo);
                List details = eo.getDetails();
                details.forEach(i -> {
                    i.setReportId(expressCostReportEo.getId());
                    i.setBillType(LogisticDocumentTypeEnum.MERGE.getCode());
                });
                this.expressCostDetailDas.insertBatch(details);
            });
        }
    }

    private TwoTuple<List<ExpressCostDetailEo>, List<ExpressCostDetailEo>> mergeData(List<ExpressCostDetailEo> correctDataList) {
        log.info("\u5408\u5e76\u6570\u636emergeData\uff1a{}", (Object)JSON.toJSONString(correctDataList));
        ArrayList mergeAllDataList = Lists.newArrayList();
        ArrayList singleAllDataList = Lists.newArrayList();
        Map<String, List<ExpressCostDetailEo>> groupMap = correctDataList.stream().collect(Collectors.groupingBy(ExpressCostDetailEo::getUniqueKey));
        groupMap.forEach((key, value) -> {
            List singleDataList;
            TwoTuple<List<ExpressCostDetailEo>, List<ExpressCostDetailEo>> calculateData = this.calculateDistance((List<ExpressCostDetailEo>)value, new BigDecimal(1000));
            List mergeDataList = (List)calculateData.getFirst();
            if (CollectionUtil.isNotEmpty((Collection)mergeDataList)) {
                if (mergeDataList.size() > 1) {
                    ExpressCostDetailEo eo = this.secondaryCalculation(mergeDataList);
                    mergeAllDataList.add(eo);
                } else {
                    singleAllDataList.add(mergeDataList.get(0));
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(singleDataList = (List)calculateData.getSecond()))) {
                singleAllDataList.addAll(singleDataList);
            }
        });
        return new TwoTuple((Object)mergeAllDataList, (Object)singleAllDataList);
    }

    private ExpressCostDetailEo secondaryCalculation(List<ExpressCostDetailEo> mergeDataList) {
        ExpressCostDetailEo eo = new ExpressCostDetailEo();
        ExpressCostDetailEo expressCostDetailEo = mergeDataList.get(0);
        BeanUtils.copyProperties((Object)expressCostDetailEo, (Object)eo);
        this.setValue(eo, null, null);
        BigDecimal totalWeight = mergeDataList.stream().map(o -> Optional.ofNullable(o.getCalculationWeight()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        eo.setWeight(totalWeight);
        ExpressCostDetailEo calculationEo = this.getCommonService(eo.getChargeMode()).calculationData(eo);
        this.calculationShareRatioAndAmount(mergeDataList, calculationEo);
        calculationEo.setDetails(mergeDataList);
        return calculationEo;
    }

    private void calculationShareRatioAndAmount(List<ExpressCostDetailEo> mergeDataList, ExpressCostDetailEo merge) {
        this.chargingRatio(mergeDataList, merge.getWeight());
        BigDecimal allocatedFirstPrice = BigDecimal.ZERO;
        BigDecimal allocatedPrice1 = BigDecimal.ZERO;
        BigDecimal allocatedPrice2 = BigDecimal.ZERO;
        BigDecimal allocatedPrice3 = BigDecimal.ZERO;
        BigDecimal allocatedPrice4 = BigDecimal.ZERO;
        BigDecimal allocatedContinuedFreight = BigDecimal.ZERO;
        BigDecimal allocatedFloatAmount = BigDecimal.ZERO;
        BigDecimal allocatedPackingFreight = BigDecimal.ZERO;
        BigDecimal allocatedTotalFreight = BigDecimal.ZERO;
        for (int i = 0; i < mergeDataList.size(); ++i) {
            ExpressCostDetailEo eo = mergeDataList.get(0);
            eo.setWeightRange(merge.getWeightRange());
            TwoTuple<BigDecimal, BigDecimal> firstPrice = this.chargingAmount(merge.getFirstPrice(), allocatedFirstPrice, eo.getRatio(), i == mergeDataList.size() - 1);
            eo.setFirstPrice(null);
            if (firstPrice != null) {
                eo.setFirstPrice((BigDecimal)firstPrice.getFirst());
                allocatedFirstPrice = (BigDecimal)firstPrice.getSecond();
            }
            TwoTuple<BigDecimal, BigDecimal> price1 = this.chargingAmount(merge.getContinuedOne(), allocatedPrice1, eo.getRatio(), i == mergeDataList.size() - 1);
            eo.setContinuedOne(null);
            if (price1 != null) {
                eo.setContinuedOne((BigDecimal)price1.getFirst());
                allocatedPrice1 = (BigDecimal)price1.getSecond();
            }
            TwoTuple<BigDecimal, BigDecimal> price2 = this.chargingAmount(merge.getContinuedTwo(), allocatedPrice2, eo.getRatio(), i == mergeDataList.size() - 1);
            eo.setContinuedTwo(null);
            if (price2 != null) {
                eo.setContinuedTwo((BigDecimal)price2.getFirst());
                allocatedPrice2 = (BigDecimal)price2.getSecond();
            }
            TwoTuple<BigDecimal, BigDecimal> price3 = this.chargingAmount(merge.getContinuedThree(), allocatedPrice3, eo.getRatio(), i == mergeDataList.size() - 1);
            eo.setContinuedThree(null);
            if (price3 != null) {
                eo.setContinuedThree((BigDecimal)price3.getFirst());
                allocatedPrice3 = (BigDecimal)price3.getSecond();
            }
            TwoTuple<BigDecimal, BigDecimal> price4 = this.chargingAmount(merge.getContinuedFour(), allocatedPrice4, eo.getRatio(), i == mergeDataList.size() - 1);
            eo.setContinuedFour(null);
            if (price4 != null) {
                eo.setContinuedFour((BigDecimal)price4.getFirst());
                allocatedPrice4 = (BigDecimal)price4.getSecond();
            }
            TwoTuple<BigDecimal, BigDecimal> continuedFreight = this.chargingAmount(merge.getContinuedFreight(), allocatedContinuedFreight, eo.getRatio(), i == mergeDataList.size() - 1);
            eo.setContinuedFreight(null);
            if (continuedFreight != null) {
                eo.setContinuedFreight((BigDecimal)continuedFreight.getFirst());
                allocatedContinuedFreight = (BigDecimal)continuedFreight.getSecond();
            }
            TwoTuple<BigDecimal, BigDecimal> floatAmount = this.chargingAmount(merge.getFloatAmount(), allocatedFloatAmount, eo.getRatio(), i == mergeDataList.size() - 1);
            eo.setFloatAmount(null);
            if (floatAmount != null) {
                eo.setFloatAmount((BigDecimal)floatAmount.getFirst());
                allocatedFloatAmount = (BigDecimal)floatAmount.getSecond();
            }
            TwoTuple<BigDecimal, BigDecimal> packingFreight = this.chargingAmount(merge.getPackingFreight(), allocatedPackingFreight, eo.getRatio(), i == mergeDataList.size() - 1);
            eo.setPackingFreight(null);
            if (packingFreight != null) {
                eo.setPackingFreight((BigDecimal)packingFreight.getFirst());
                allocatedPackingFreight = (BigDecimal)packingFreight.getSecond();
            }
            TwoTuple<BigDecimal, BigDecimal> totalFreight = this.chargingAmount(merge.getPackingFreight(), allocatedTotalFreight, eo.getRatio(), i == mergeDataList.size() - 1);
            eo.setTotalFreight(null);
            if (totalFreight == null) continue;
            eo.setTotalFreight((BigDecimal)totalFreight.getFirst());
            allocatedTotalFreight = (BigDecimal)totalFreight.getSecond();
        }
    }

    private TwoTuple<BigDecimal, BigDecimal> chargingAmount(BigDecimal totalAmount, BigDecimal allocatedAmount, BigDecimal ratio, boolean lastElement) {
        if (totalAmount == null || ratio == null) {
            return null;
        }
        if (lastElement) {
            return new TwoTuple((Object)totalAmount.subtract(allocatedAmount), (Object)totalAmount);
        }
        BigDecimal amount = totalAmount.multiply(ratio);
        allocatedAmount = allocatedAmount.add(amount);
        return new TwoTuple((Object)amount, (Object)allocatedAmount);
    }

    private void chargingRatio(List<ExpressCostDetailEo> mergeDataList, BigDecimal weight) {
        if (weight == null || BigDecimal.ZERO.compareTo(weight) <= 0) {
            mergeDataList.forEach(i -> i.setRatio(BigDecimal.ZERO));
            return;
        }
        BigDecimal allocatedWeightRatio = BigDecimal.ZERO;
        for (int i2 = 1; i2 <= mergeDataList.size(); ++i2) {
            ExpressCostDetailEo eo = mergeDataList.get(i2 - 1);
            BigDecimal calculationWeight = eo.getCalculationWeight();
            if (calculationWeight == null) continue;
            if (i2 == mergeDataList.size()) {
                eo.setRatio(BigDecimal.ONE.subtract(allocatedWeightRatio));
                continue;
            }
            BigDecimal ratio = calculationWeight.divide(allocatedWeightRatio, 6, 3);
            allocatedWeightRatio = allocatedWeightRatio.add(ratio);
            eo.setRatio(ratio);
        }
    }

    private TwoTuple<List<ExpressCostDetailEo>, List<ExpressCostDetailEo>> calculateDistance(List<ExpressCostDetailEo> eoList, BigDecimal confluentDistance) {
        ArrayList combinationDataList = Lists.newArrayList();
        ArrayList singleDataList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(eoList)) {
            return new TwoTuple((Object)combinationDataList, eoList);
        }
        String calculateLngLat = this.getCalculateLngLat(eoList);
        if (StringUtils.isBlank((CharSequence)calculateLngLat)) {
            return new TwoTuple((Object)combinationDataList, eoList);
        }
        String[] al = calculateLngLat.split(",");
        for (ExpressCostDetailEo eo : eoList) {
            if (StringUtils.isNotBlank((CharSequence)eo.getLngLat())) {
                String[] bl = eo.getLngLat().split(",");
                String result = LbsUtil.distance(Double.parseDouble(al[0]), Double.parseDouble(al[1]), Double.parseDouble(bl[0]), Double.parseDouble(bl[1]));
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    if (new BigDecimal(result).compareTo(confluentDistance) <= 0) {
                        combinationDataList.add(eo);
                        continue;
                    }
                    singleDataList.add(eo);
                    continue;
                }
                singleDataList.add(eo);
                continue;
            }
            singleDataList.add(eo);
        }
        return new TwoTuple((Object)combinationDataList, (Object)singleDataList);
    }

    private String getCalculateLngLat(List<ExpressCostDetailEo> eoList) {
        for (ExpressCostDetailEo eo : eoList) {
            if (!StringUtils.isNotBlank((CharSequence)eo.getLngLat())) continue;
            return eo.getLngLat();
        }
        return null;
    }

    private AbstractCostReportService getCommonService(Integer changeMode) {
        AbstractCostReportService commonService = this.mapService.get(String.format("%s_%s", MAP_SERVICE_NAME, changeMode));
        log.info("-----------changeMode:", (Object)String.format("%s_%s", MAP_SERVICE_NAME, changeMode));
        log.info("\u83b7\u53d6\u5230\u7684commonService:{}", (Object)commonService);
        if (Objects.isNull(commonService)) {
            commonService = this.mapService.get(MAP_SERVICE_NAME);
        }
        return commonService;
    }

    private TwoTuple<List<ExpressCostDetailEo>, List<ExpressCostDetailEo>> calculationData(List<ExpressCostDetailEo> eos) {
        if (CollectionUtil.isEmpty(eos)) {
            return null;
        }
        ArrayList correctDataList = Lists.newArrayList();
        ArrayList abnormalDataList = Lists.newArrayList();
        for (ExpressCostDetailEo i : eos) {
            log.info("\u8ba1\u7b97\u6570\u636ecalculationData\uff1a{}", (Object)JSON.toJSONString((Object)i));
            if (StringUtils.isNotBlank((CharSequence)i.getTransportType()) && (i.getTransportType().equals(com.dtyunxi.tcbj.dao.Constants.CsShipmentLogisticsTypeEnum.ZT.getDesc()) || i.getTransportType().equals(com.dtyunxi.tcbj.dao.Constants.CsShipmentLogisticsTypeEnum.DF.getDesc()))) {
                log.info("\u81ea\u63d0\u3001\u5230\u4ed8 \u4e0d\u53c2\u4e0e\u8ba1\u7b97\uff0c\u76f8\u5173\u91d1\u989d\u8bbe\u7f6e\u4e3a0");
                i.setAbnormal(Integer.valueOf(0));
                i.setAbnormalCauses(null);
                i.setBillingFeeFlag(Integer.valueOf(0));
                this.defaultZero(i);
                correctDataList.add(i);
                continue;
            }
            if (ObjectUtil.isNotEmpty((Object)i.getBillingFeeFlag()) && i.getBillingFeeFlag().equals(YesNoEnum.NO.getValue())) {
                log.info("\u4e0d\u53c2\u4e0e\u8ba1\u8d39\u5355\u636e\u4e0d\u8ba1\u8d39");
                i.setAbnormal(Integer.valueOf(0));
                i.setAbnormalCauses(null);
                this.defaultZero(i);
                correctDataList.add(i);
                continue;
            }
            Integer abnormal = i.getAbnormal();
            if (Objects.equals(0, abnormal)) {
                log.info("\u6a21\u7248\u8ba1\u7b97");
                correctDataList.add(this.getCommonService(i.getChargeMode()).calculationData(i));
                continue;
            }
            log.info("\u5f02\u5e38\u5355\u636e");
            abnormalDataList.add(i);
        }
        this.calculationTemplateTwoSpecialDiscount(correctDataList);
        return new TwoTuple((Object)correctDataList, (Object)abnormalDataList);
    }

    private void calculationTemplateTwoSpecialDiscount(List<ExpressCostDetailEo> detailEoList) {
        log.info("\u8ba1\u7b97\u6a21\u7248\u4e8c\u4f18\u60e0\u6298\u6263\uff1a{}", (Object)JSON.toJSONString(detailEoList));
        Map<Long, List<ExpressCostDetailEo>> contractMap = detailEoList.stream().filter(f -> ObjectUtil.isNotEmpty((Object)f.getContractId()) && ObjectUtil.isNotEmpty((Object)f.getChargeMode()) && f.getChargeMode() == 2).collect(Collectors.groupingBy(ExpressCostDetailEo::getContractId));
        if (ObjectUtil.isEmpty(contractMap)) {
            return;
        }
        contractMap.forEach((k, v) -> {
            BigDecimal specialDiscount = BigDecimal.ONE;
            ExpressCostContractEo contractEo = ((ExpressCostDetailEo)v.get(0)).getExpressCostContractEo();
            if (Objects.equals(1, contractEo.getDiscountType())) {
                if (contractEo.getPreferentialDiscount() != null) {
                    specialDiscount = contractEo.getPreferentialDiscount();
                }
            } else if (Objects.equals(2, contractEo.getDiscountType()) && StringUtils.isNotBlank((CharSequence)contractEo.getPriceRange())) {
                List priceLadderList = JSON.parseArray((String)contractEo.getPriceRange(), PriceLadderInfoDto.class);
                BigDecimal totalReduce = BigDecimal.ZERO;
                for (ExpressCostDetailEo detail2 : v) {
                    if (ObjectUtil.isNotEmpty((Object)detail2.getFirstPrice())) {
                        totalReduce = totalReduce.add(detail2.getFirstPrice());
                    }
                    if (!ObjectUtil.isNotEmpty((Object)detail2.getContinuedFreight())) continue;
                    totalReduce = totalReduce.add(detail2.getContinuedFreight());
                }
                specialDiscount = this.getDiscountRate(priceLadderList, totalReduce);
            }
            BigDecimal finalSpecialDiscount = specialDiscount;
            v.forEach(detail -> {
                detail.setCalculateDiscountFlag(Boolean.valueOf(true));
                this.calculationTotalFreight((ExpressCostDetailEo)detail, finalSpecialDiscount);
            });
        });
    }

    private void calculationTotalFreight(ExpressCostDetailEo eo, BigDecimal specialDiscount) {
        log.info("\u8ba1\u7b97\u6a21\u72482\u5355\u636e\u8fd0\u8d39\u5408\u8ba1\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)eo), (Object)specialDiscount);
        if (Objects.equals(0, eo.getAbnormal())) {
            BigDecimal continuedFreight = BigDecimal.ZERO;
            if (eo.getContinuedOne() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedOne());
            }
            if (eo.getContinuedTwo() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedTwo());
            }
            if (eo.getContinuedThree() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedThree());
            }
            if (eo.getContinuedFour() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedFour());
            }
            if (continuedFreight.compareTo(BigDecimal.ZERO) > 0) {
                eo.setContinuedFreight(continuedFreight);
            }
            BigDecimal totalFreight = eo.getFirstPrice() != null ? eo.getFirstPrice() : BigDecimal.ZERO;
            totalFreight = totalFreight.add(continuedFreight);
            totalFreight = totalFreight.multiply(specialDiscount);
            if (eo.getFloatAmount() != null) {
                totalFreight = totalFreight.add(eo.getFloatAmount());
            }
            if (eo.getPackingFreight() != null) {
                totalFreight = totalFreight.add(eo.getPackingFreight());
            }
            if (eo.getReturnFee() != null) {
                totalFreight = totalFreight.add(eo.getReturnFee());
            }
            if (eo.getIncrementFreight() != null) {
                totalFreight = totalFreight.add(eo.getIncrementFreight());
            }
            if (eo.getPremium() != null) {
                totalFreight = totalFreight.add(eo.getPremium());
            }
            if (eo.getInsureAmount() != null) {
                totalFreight = totalFreight.add(eo.getInsureAmount());
            }
            if (eo.getAdjustmentAmount() != null) {
                totalFreight = Objects.equals(eo.getAdjustmentType(), "1") ? totalFreight.add(eo.getAdjustmentAmount()) : totalFreight.subtract(eo.getAdjustmentAmount());
            }
            if (totalFreight.compareTo(BigDecimal.ZERO) > 0) {
                eo.setTotalFreight(totalFreight);
            }
        }
    }

    private void calculationTotalFreightBase(ExpressCostDetailEo eo) {
        if (Objects.equals(0, eo.getAbnormal())) {
            BigDecimal totalFreight;
            BigDecimal continuedFreight = BigDecimal.ZERO;
            if (eo.getContinuedOne() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedOne());
            }
            if (eo.getContinuedTwo() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedTwo());
            }
            if (eo.getContinuedThree() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedThree());
            }
            if (eo.getContinuedFour() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedFour());
            }
            if (continuedFreight.compareTo(BigDecimal.ZERO) > 0) {
                eo.setContinuedFreight(continuedFreight);
            }
            BigDecimal bigDecimal = totalFreight = eo.getFirstPrice() != null ? eo.getFirstPrice() : BigDecimal.ZERO;
            if (eo.getContinuedFreight() != null) {
                totalFreight = totalFreight.add(eo.getContinuedFreight());
            }
            if (eo.getFloatAmount() != null) {
                totalFreight = totalFreight.add(eo.getFloatAmount());
            }
            if (eo.getPackingFreight() != null) {
                totalFreight = totalFreight.add(eo.getPackingFreight());
            }
            if (eo.getReturnFee() != null) {
                totalFreight = totalFreight.add(eo.getReturnFee());
            }
            if (eo.getIncrementFreight() != null) {
                totalFreight = totalFreight.add(eo.getIncrementFreight());
            }
            if (eo.getPremium() != null) {
                totalFreight = totalFreight.add(eo.getPremium());
            }
            if (eo.getInsureAmount() != null) {
                totalFreight = totalFreight.add(eo.getInsureAmount());
            }
            if (eo.getAdjustmentAmount() != null) {
                totalFreight = Objects.equals(eo.getAdjustmentType(), "1") ? totalFreight.add(eo.getAdjustmentAmount()) : totalFreight.subtract(eo.getAdjustmentAmount());
            }
            if (totalFreight.compareTo(BigDecimal.ZERO) > 0) {
                eo.setTotalFreight(totalFreight);
            }
        }
    }

    private BigDecimal getDiscountRate(List<PriceLadderInfoDto> priceLadderList, BigDecimal calculationTotalFreight) {
        log.info("\u83b7\u53d6\u4f18\u60e0\u6298\u6263\uff1a{}\uff0c{}", (Object)JSON.toJSONString(priceLadderList), (Object)calculationTotalFreight);
        BigDecimal discountRate = BigDecimal.ONE;
        for (PriceLadderInfoDto priceLadder : priceLadderList) {
            if (priceLadder.getMaxPrice() == null) {
                if (calculationTotalFreight.compareTo(priceLadder.getMinPrice()) < 0) continue;
                discountRate = priceLadder.getDiscountRate();
                break;
            }
            if (calculationTotalFreight.compareTo(priceLadder.getMinPrice()) < 0 || calculationTotalFreight.compareTo(priceLadder.getMaxPrice()) >= 0) continue;
            discountRate = priceLadder.getDiscountRate();
            break;
        }
        return discountRate;
    }

    private void defaultZero(ExpressCostDetailEo i) {
        i.setFirstPrice(BigDecimal.ZERO);
        i.setContinuedOne(BigDecimal.ZERO);
        i.setContinuedTwo(BigDecimal.ZERO);
        i.setContinuedThree(BigDecimal.ZERO);
        i.setContinuedFour(BigDecimal.ZERO);
        i.setContinuedFreight(BigDecimal.ZERO);
        i.setFloatAmount(BigDecimal.ZERO);
        i.setPackingFreight(BigDecimal.ZERO);
        i.setReturnFee(BigDecimal.ZERO);
        i.setIncrementFreight(BigDecimal.ZERO);
        i.setInsureAmount(BigDecimal.ZERO);
        i.setPremium(BigDecimal.ZERO);
        i.setTotalFreight(BigDecimal.ZERO);
        i.setExpressBackRemake(BigDecimal.ZERO);
        i.setChargedWeight(BigDecimal.ZERO);
    }

    private List<ExpressCostDetailEo> queryExpressCostDetailListNew(LogisticStatisticReqDto queryDto, List<ExpressCostDetailEo> pastDetailEoList) {
        ArrayList list = Lists.newArrayList();
        log.info("\u5feb\u9012\u8d39\u7528\u62a5\u8868\u5355\u636e\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        AssertUtil.isFalse((ObjectUtil.isEmpty((Object)queryDto.getStartTime()) || ObjectUtil.isEmpty((Object)queryDto.getEndTime()) ? 1 : 0) != 0, (String)"\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        Map pastDetailEoMap = Optional.ofNullable(pastDetailEoList).map(m -> pastDetailEoList.stream().collect(Collectors.toMap(ExpressCostDetailEo::getLinkDailyReportId, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        DailyDeliveryReportDto queryReportDto = new DailyDeliveryReportDto();
        queryReportDto.setOrderShippingTimeStart(DateTimeUtils.parseDateTime(queryDto.getStartTime()));
        queryReportDto.setOrderShippingTimeEnd(DateTimeUtils.parseDateTime(queryDto.getEndTime()));
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShippingType())) {
            queryReportDto.setTransportStyleCode(queryDto.getShippingType());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShippingCompanyCode())) {
            queryReportDto.setShippingCompany(queryDto.getShippingCompanyCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getRelevanceNo())) {
            queryReportDto.setRelevanceNo(queryDto.getRelevanceNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getDocumentNo())) {
            queryReportDto.setOutResultNo(queryDto.getDocumentNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getDocumentNos())) {
            queryReportDto.setOutResultNoList(queryDto.getDocumentNos());
        }
        log.info("\u83b7\u53d6\u5feb\u9012\u5546");
        List shipmentList = ((ExtQueryChainWrapper)this.shipmentEnterpriseDas.filter().eq((Object)"shipment_enterprise_type", (Object)2)).list();
        Map shipmentListMap = Optional.ofNullable(shipmentList).map(m -> m.stream().collect(Collectors.toMap(ShipmentEnterpriseEo::getShipmentEnterpriseCode, Function.identity(), (v1, v2) -> v1))).orElse(new HashMap());
        if (CollectionUtil.isNotEmpty((Collection)shipmentList)) {
            queryReportDto.setShippingCompanyList(shipmentList.stream().map(ShipmentEnterpriseEo::getShipmentEnterpriseCode).collect(Collectors.toList()));
        }
        int startNum = 1;
        int queryNum = 5000;
        queryReportDto.setPageNum(Integer.valueOf(startNum));
        queryReportDto.setPageSize(Integer.valueOf(queryNum));
        while (true) {
            log.info("queryExpressCostDetailList\u5355\u636e\u67e5\u8be2\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)queryReportDto));
            PageInfo respDtoPageInfo = this.dailyDeliveryReportDomain.queryMainOrder(queryReportDto);
            List eoList = respDtoPageInfo.getList();
            if (CollectionUtil.isEmpty((Collection)eoList)) break;
            log.info("queryExpressCostDetailList\u7ed3\u679c\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)eoList));
            HashSet logicCodes = Sets.newHashSet();
            HashSet inPhysicsWarehouseCodes = Sets.newHashSet();
            HashSet orderNos = Sets.newHashSet();
            HashSet procurementOrderNos = Sets.newHashSet();
            HashSet saleOrderNos = Sets.newHashSet();
            HashSet otherOrderNos = Sets.newHashSet();
            HashSet refundOrderNos = Sets.newHashSet();
            HashSet outCodes = Sets.newHashSet();
            HashSet inCodes = Sets.newHashSet();
            HashSet peOrderNos = Sets.newHashSet();
            HashSet preOrderNos = Sets.newHashSet();
            ArrayList queryList = Lists.newArrayList();
            eoList.forEach(i -> {
                logicCodes.add(i.getInLogicWarehouseCode());
                logicCodes.add(i.getLogicWarehouseCode());
                if (StringUtils.isNotBlank((CharSequence)i.getInPhysicalWarehouseCode())) {
                    inPhysicsWarehouseCodes.add(i.getInPhysicalWarehouseCode());
                }
                if (transferOrderBusinessType.contains(i.getBusinessType())) {
                    orderNos.add(i.getRelevanceNo());
                }
                if (refundOrderBusinessType.contains(i.getBusinessType())) {
                    procurementOrderNos.add(i.getRelevanceNo());
                }
                if (saleOrderBusinessType.contains(i.getBusinessType())) {
                    saleOrderNos.add(i.getRelevanceNo());
                }
                if (Objects.equals(i.getBusinessType(), CsPcpBusinessTypeEnum.OTHER_OUT.getCode())) {
                    otherOrderNos.add(i.getRelevanceNo());
                }
                if (refundOrderBusinessType.contains(i.getBusinessType())) {
                    refundOrderNos.add(i.getRelevanceNo());
                }
                peOrderNos.add(i.getPreOrderNo());
                preOrderNos.add(i.getPreOrderNo());
                if (i.getOrderShippingTime() != null && StringUtils.isNotBlank((CharSequence)i.getPhysicalWarehouseCode()) && StringUtils.isNotBlank((CharSequence)i.getShippingCompany()) && StringUtils.isNotBlank((CharSequence)i.getTransportStyleCode())) {
                    ExpressCostQueryPo reqDto = new ExpressCostQueryPo();
                    reqDto.setWhCode(i.getPhysicalWarehouseCode());
                    reqDto.setLogisticCompany(i.getShippingCompany());
                    reqDto.setTransportType(i.getTransportStyleCode());
                    reqDto.setOutWarehouseTime(i.getOrderShippingTime());
                    queryList.add(reqDto);
                }
                log.info("queryList\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)queryList));
            });
            Map<String, CsWarehouseAddressEo> whAddressMap = this.queryWarehouseAddress(new ArrayList<String>(inPhysicsWarehouseCodes));
            Map<String, CsTransferOrderEo> transferOrderMap = this.queryTransferOrder(orderNos);
            Map<String, InventorySupplierEo> supplierEoMap = this.asyncQueryPlannedOrderSupplier(procurementOrderNos);
            Map<String, SaleOrderEo> saleOrderEoMap = this.asyncQuerySaleOrder(saleOrderNos);
            Map<String, OutPlannedOrderEo> saleRefundEoMap = this.asyncQuerySaleRefundOrder(refundOrderNos);
            Map<String, CsOtherStorageOrderEo> otherOrderMap = this.asyncQueryOtherOrder(otherOrderNos);
            List logicWarehouseEos = ((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"warehouse_code", new ArrayList(logicCodes))).list(Integer.valueOf(logicCodes.size()));
            Map whMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            Map<String, OutNoticeOrderRespDto> outNoticeOrderRespDtoMap = this.asyncQueryOutNoticeOrder(preOrderNos);
            Map<String, ExpressCostContractEo> recordMap = this.asyncQueryExpressCostModes(queryList);
            log.info("\u5f02\u6b65\u67e5\u4e0b\u5408\u540c\u6570\u636e\uff1a{}", (Object)(ObjectUtils.isEmpty(recordMap) ? "\u65e0\u6570\u636e" : JSON.toJSONString(recordMap)));
            Map<String, OrderInfoVo> orderInfoVoMap = this.asyncQueryOrderInfo(preOrderNos);
            Map<String, AdjustmentInventoryEo> adjustmentInventoryEoMap = this.asyncQueryAdjustmentInventory(orderNos);
            List<DailyDeliveryFeeFilterExtConfigRespDto> outFilter = this.dailyDeliveryFeeFilterExtConfigService.queryModuleCode(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode());
            log.info("\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u8fc7\u6ee4\uff1a{}", (Object)JSON.toJSONString(outFilter));
            for (DailyDeliveryReportDto respDto : eoList) {
                String customerName;
                List customerNameList;
                String remark;
                PcpRegionEo one;
                log.info("\u904d\u5386\u660e\u7ec6\u5355\u636e\uff0c\u5904\u7406\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
                ExpressCostDetailEo reportEo = new ExpressCostDetailEo();
                if (StringUtils.isNotBlank((CharSequence)respDto.getWmsOrderType()) && respDto.getWmsOrderType().equals("\u5408\u5355\u751f\u6210")) {
                    reportEo.setWmsMergeDocumentNo(respDto.getWmsMergeDocumentNo());
                }
                reportEo.setExpressNo(respDto.getTransportNo());
                reportEo.setConsignmentNo(respDto.getConsignmentNo());
                reportEo.setAbnormal(Integer.valueOf(0));
                reportEo.setBillType(LogisticDocumentTypeEnum.ORIGINAL.getCode());
                reportEo.setOutboundTime(respDto.getOrderShippingTime());
                reportEo.setOutboundCode(respDto.getOutResultNo());
                reportEo.setWmsOutboundCode(respDto.getDocumentNo());
                reportEo.setBusinessCode(respDto.getRelevanceNo());
                reportEo.setWarehouseName(respDto.getPhysicalWarehouse());
                reportEo.setWarehouseCode(respDto.getPhysicalWarehouseCode());
                reportEo.setLogisticCompany(respDto.getShippingCompanyName());
                reportEo.setLogisticCode(respDto.getShippingCompany());
                reportEo.setTransportType(respDto.getTransportStyle());
                reportEo.setBusinessType(respDto.getBusinessType());
                reportEo.setInWarehouseName(respDto.getInLogicWarehouse());
                reportEo.setInWarehouseCode(respDto.getInLogicWarehouseCode());
                reportEo.setBookkeepingMonth(DateTimeUtils.formatDate(respDto.getOrderShippingTime(), "yyyy-MM"));
                reportEo.setPieceNum(Long.valueOf(respDto.getTotalCartons().longValue()));
                reportEo.setRelevanceNo(respDto.getRelevanceNo());
                reportEo.setConsignee(respDto.getReceivingPerson());
                reportEo.setPhone(respDto.getReceivingPersonPhone());
                reportEo.setCustomerName(respDto.getReceivingCustomer());
                reportEo.setEasNo(respDto.getEasOrderNo());
                reportEo.setLinkDailyReportId(respDto.getId());
                reportEo.setBillingDate(DateUtil.getDateFormat((Date)respDto.getOrderCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                reportEo.setE3No(respDto.getE3No());
                reportEo.setOutNoticeNo(respDto.getOutNoticeNo());
                reportEo.setBeginDeliverProvince(respDto.getStartProvince());
                reportEo.setBeginDeliverCityCode(respDto.getStartProvinceCode());
                reportEo.setBeginDeliverCity(respDto.getStartCity());
                reportEo.setBeginDeliverCityCode(respDto.getStartCityCode());
                reportEo.setMasterOrder(respDto.getMasterOrder());
                reportEo.setShopCode(respDto.getShopCode());
                reportEo.setShopName(respDto.getShopName());
                reportEo.setIfRepeat(Integer.valueOf(0));
                reportEo.setBillingFeeFlag(YesNoEnum.YES.getValue());
                if (ObjectUtil.isNotEmpty((Object)respDto.getLogisticsOrderNoRepeatId())) {
                    reportEo.setIfRepeat(Integer.valueOf(1));
                }
                reportEo.setEasNo(respDto.getEasOrderNo());
                if (StringUtils.isNotBlank((CharSequence)respDto.getWmsOrderType()) && respDto.getWmsOrderType().equals("\u5408\u5355\u751f\u6210") && StringUtils.isNotBlank((CharSequence)respDto.getWmsMergeDocumentNo())) {
                    log.info("\u67e5\u8be2\u5408\u5355\u751f\u6210\u5bf9\u5e94\u7684\u5b50\u5355\u7684eas\u5355\u53f7\uff1a{}", (Object)respDto.getWmsMergeDocumentNo());
                    DailyDeliveryReportDto reportDto = this.dailyDeliveryReportDomain.queryChildOrders(respDto.getWmsMergeDocumentNo());
                    if (ObjectUtil.isNotEmpty((Object)reportDto)) {
                        reportEo.setEasNo(reportDto.getEasOrderNo());
                        reportEo.setBusinessCode(reportDto.getRelevanceNo());
                        reportEo.setOutboundCode(reportDto.getOutResultNo());
                        reportEo.setOutNoticeNo(reportDto.getOutNoticeNo());
                    }
                }
                if (YYJ_BUSINESS_TYPE.contains(respDto.getBusinessType())) {
                    reportEo.setNutritionistOrder(Boolean.valueOf(true));
                }
                if (orderInfoVoMap != null && orderInfoVoMap.containsKey(respDto.getPreOrderNo())) {
                    OrderInfoVo orderInfoVo = orderInfoVoMap.get(respDto.getPreOrderNo());
                    reportEo.setProvince(orderInfoVo.getProvince());
                    reportEo.setCity(orderInfoVo.getCity());
                    reportEo.setArea(orderInfoVo.getArea());
                    reportEo.setAddress(orderInfoVo.getDetailAddress());
                } else if (StringUtils.isNotBlank((CharSequence)respDto.getReceivingAddress()) || StringUtils.isNotBlank((CharSequence)respDto.getReceivingAddressProvince()) || StringUtils.isNotBlank((CharSequence)respDto.getReceivingAddressCityCode()) || StringUtils.isNotBlank((CharSequence)respDto.getReceivingAddressDistrict())) {
                    reportEo.setProvince(respDto.getReceivingAddressProvince());
                    reportEo.setCity(respDto.getReceivingAddressCity());
                    reportEo.setArea(respDto.getReceivingAddressDistrict());
                    reportEo.setAddress(respDto.getReceivingAddress());
                }
                if (StringUtils.isNotEmpty((CharSequence)reportEo.getAddress())) {
                    GeoAddressInfo geoAddress = this.lbsUtil.getGeoAddressCache(reportEo.getAddress());
                    log.info("\u83b7\u53d6\u7ecf\u7eac\u5ea6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)geoAddress));
                    reportEo.setLngLat(geoAddress.getLocation());
                    if (StringUtils.isBlank((CharSequence)reportEo.getProvince())) {
                        reportEo.setProvince(geoAddress.getProvince());
                    }
                    if (StringUtils.isBlank((CharSequence)reportEo.getCity())) {
                        reportEo.setCity(geoAddress.getCity());
                    }
                    if (StringUtils.isBlank((CharSequence)reportEo.getArea())) {
                        reportEo.setArea(geoAddress.getDistrict());
                    }
                }
                if (StringUtils.isBlank((CharSequence)reportEo.getProvince())) {
                    reportEo.setAbnormal(Integer.valueOf(1));
                    this.setAbnormalCauses(reportEo, "\u7701\u4efd\u4e3a\u7a7a");
                } else if (reportEo.getProvince().contains("\u5e02")) {
                    reportEo.setProvince(reportEo.getProvince().replace("\u5e02", ""));
                }
                if (StringUtils.isNotBlank((CharSequence)reportEo.getProvince()) && StringUtils.isNotBlank((CharSequence)reportEo.getCity()) && StringUtils.isBlank((CharSequence)reportEo.getArea()) && (one = (PcpRegionEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.regionDas.filter().likeRight((Object)"name", (Object)reportEo.getCity())).likeRight((Object)"parent_name", (Object)reportEo.getProvince())).last("limit 1")).one()) != null) {
                    reportEo.setCityLevel(one.getCityLevel());
                }
                if (StringUtils.isNotBlank((CharSequence)reportEo.getProvince()) && StringUtils.isNotBlank((CharSequence)reportEo.getCity()) && StringUtils.isNotBlank((CharSequence)reportEo.getArea()) && (one = (PcpRegionEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.regionDas.filter().likeRight((Object)"name", (Object)reportEo.getArea())).likeRight((Object)"parent_name", (Object)reportEo.getCity())).last("limit 1")).one()) != null) {
                    reportEo.setCityLevel(one.getCityLevel());
                }
                if (StringUtils.isBlank((CharSequence)reportEo.getProvince()) && StringUtils.isBlank((CharSequence)reportEo.getCity()) && StringUtils.isBlank((CharSequence)reportEo.getArea()) && StringUtils.isBlank((CharSequence)reportEo.getAddress())) {
                    reportEo.setAbnormal(Integer.valueOf(1));
                    this.setAbnormalCauses(reportEo, "\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)respDto.getPhysicalWarehouseCode())) {
                    log.info("\u8be5\u6570\u636e\u7269\u7406\u4ed3\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)respDto));
                    continue;
                }
                if (respDto.getOrderShippingTime() != null && StringUtils.isNotBlank((CharSequence)respDto.getPhysicalWarehouseCode()) && StringUtils.isNotBlank((CharSequence)respDto.getShippingCompany()) && StringUtils.isNotBlank((CharSequence)respDto.getTransportStyleCode())) {
                    String key = String.format("%s%s%s", respDto.getPhysicalWarehouseCode(), respDto.getShippingCompany(), respDto.getTransportStyleCode());
                    log.info("\u5339\u914d\u5feb\u9012\u6a21\u7248key\uff1a{}\uff0c{}", (Object)respDto.getDocumentNo(), (Object)key);
                    ExpressCostContractEo eo = recordMap.get(key);
                    log.info("\u5feb\u9012\u6a21\u677f====={}", (Object)JSON.toJSONString((Object)eo));
                    if (null != eo && null != eo.getId()) {
                        log.info("\u6a21\u7248\u6570\u636e\uff1a{}\uff0c{}", (Object)respDto.getDocumentNo(), (Object)JSON.toJSONString((Object)eo));
                        reportEo.setChargeMode(eo.getChargeMode());
                        reportEo.setContractId(eo.getId());
                        reportEo.setExpressCostContractEo(eo);
                        reportEo.setLogisticCompany(eo.getLogisticCompany());
                    } else {
                        reportEo.setAbnormal(Integer.valueOf(1));
                        reportEo.setFirstPrice(new BigDecimal("-1"));
                        reportEo.setContinuedOne(new BigDecimal("-1"));
                        reportEo.setContinuedTwo(new BigDecimal("-1"));
                        reportEo.setContinuedThree(new BigDecimal("-1"));
                        reportEo.setContinuedFour(new BigDecimal("-1"));
                        reportEo.setContinuedFreight(new BigDecimal("-1"));
                        reportEo.setTotalFreight(new BigDecimal("-1"));
                        this.setAbnormalCauses(reportEo, "\u6a21\u677f\u5df2\u8fc7\u671f\u6216\u672a\u5339\u914d\u5230\u6709\u6548\u7684\u5feb\u9012\u8d39\u7528\u6a21\u677f");
                    }
                } else {
                    if (respDto.getOrderShippingTime() == null) {
                        this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u65f6\u95f4\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)respDto.getPhysicalWarehouseCode())) {
                        this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u7269\u7406\u4ed3\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)respDto.getShippingCompany())) {
                        this.setAbnormalCauses(reportEo, "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)respDto.getTransportStyleCode())) {
                        this.setAbnormalCauses(reportEo, "\u627f\u8fd0\u65b9\u5f0f\u4e3a\u7a7a");
                    }
                    reportEo.setAbnormal(Integer.valueOf(1));
                }
                reportEo.setVolume(respDto.getTotalVolume());
                reportEo.setWeight(respDto.getTotalWeight());
                if (StringUtils.isNotEmpty((CharSequence)respDto.getLogicWarehouse())) {
                    reportEo.setOutWarehouseName(respDto.getLogicWarehouse());
                }
                if (StringUtils.isNotEmpty((CharSequence)respDto.getLogicWarehouseCode())) {
                    reportEo.setOutWarehouseCode(respDto.getLogicWarehouseCode());
                }
                if (StringUtils.isNotBlank((CharSequence)respDto.getLogicWarehouseCode()) && whMap != null && whMap.containsKey(respDto.getLogicWarehouseCode())) {
                    LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)whMap.get(respDto.getLogicWarehouseCode());
                    reportEo.setOutOrg(logicWarehouseEo.getOrganizationName());
                    if (logicWarehouseEo.getOrganizationId() != null) {
                        reportEo.setInOrgCode(logicWarehouseEo.getOrganizationId().toString());
                    }
                    reportEo.setFreightOrg(logicWarehouseEo.getOrganizationName());
                }
                if (saleOrderBusinessType.contains(reportEo.getBusinessType())) {
                    OutNoticeOrderRespDto orderRespDto;
                    if (saleOrderEoMap.containsKey(respDto.getRelevanceNo())) {
                        SaleOrderEo saleOrderEo = saleOrderEoMap.get(respDto.getRelevanceNo());
                        remark = saleOrderEo.getSellerRemark();
                        reportEo.setRemark(remark);
                        reportEo.setBillingDate(DateTimeUtils.formatDate(saleOrderEo.getSaleCreateTime(), "yyyy-MM-dd"));
                        reportEo.setCustomerName(saleOrderEo.getCustomerName());
                    }
                    if ((orderRespDto = outNoticeOrderRespDtoMap.get(respDto.getPreOrderNo())) != null) {
                        ContactDto jsonObject = (ContactDto)JSONObject.parseObject((String)orderRespDto.getExtension(), ContactDto.class);
                        reportEo.setConsignee(jsonObject.getReciveName());
                    }
                }
                if (BusinessTypeEnum.OTHER_OUT.getCode().equals(respDto.getBusinessType()) || BusinessTypeEnum.OTHER_IN.getCode().equals(respDto.getBusinessType())) {
                    CsOtherStorageOrderEo otherStorageOrderEo = otherOrderMap.get(respDto.getRelevanceNo());
                    if (otherStorageOrderEo != null) {
                        remark = otherStorageOrderEo.getRemark();
                        if (StringUtils.isBlank((CharSequence)remark)) {
                            remark = otherStorageOrderEo.getMessage();
                        }
                        reportEo.setRemark(remark);
                        reportEo.setBillingDate(DateTimeUtils.formatDate(otherStorageOrderEo.getCreateTime(), "yyyy-MM-dd"));
                        reportEo.setCustomerName(otherStorageOrderEo.getCustomerName());
                        reportEo.setConsignee(otherStorageOrderEo.getConsignee());
                    } else {
                        this.setAbnormalCauses(reportEo, "\u6536\u8d27\u5730\u5740\u4e3a\u7a7a");
                        reportEo.setAbnormal(Integer.valueOf(1));
                    }
                }
                if (refundOrderBusinessType.contains(respDto.getBusinessType()) && saleRefundEoMap.containsKey(respDto.getRelevanceNo())) {
                    OutPlannedOrderEo outPlannedOrderEo = saleRefundEoMap.get(respDto.getRelevanceNo());
                    remark = outPlannedOrderEo.getRemark();
                    reportEo.setRemark(remark);
                    reportEo.setBillingDate(DateTimeUtils.formatDate(outPlannedOrderEo.getCreateTime(), "yyyy-MM-dd"));
                    InventorySupplierEo inventorySupplierEo = supplierEoMap.get(respDto.getRelevanceNo());
                    reportEo.setConsignee(inventorySupplierEo.getLinkman());
                }
                if (transferOrderBusinessType.contains(respDto.getBusinessType()) && transferOrderMap.containsKey(respDto.getRelevanceNo())) {
                    if (whAddressMap.containsKey(respDto.getInPhysicalWarehouseCode())) {
                        CsWarehouseAddressEo addressEo = whAddressMap.get(respDto.getInPhysicalWarehouseCode());
                        reportEo.setConsignee(addressEo.getContacts());
                    }
                    CsTransferOrderEo transferOrderEo = transferOrderMap.get(respDto.getRelevanceNo());
                    reportEo.setInWarehouseName(transferOrderEo.getInLogicWarehouseName());
                    reportEo.setInWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
                    reportEo.setInOrg(transferOrderEo.getInOrganization());
                    if (transferOrderEo.getInOrganizationId() != null) {
                        reportEo.setInOrgCode(transferOrderEo.getInOrganizationId().toString());
                    }
                    if (!Objects.equals(transferOrderEo.getOutPhysicsWarehouseCode(), transferOrderEo.getInPhysicsWarehouseCode())) {
                        remark = transferOrderEo.getRemark();
                        reportEo.setBillingDate(DateTimeUtils.formatDate(transferOrderEo.getCreateTime(), "yyyy-MM-dd"));
                        if (orderInfoVoMap != null && orderInfoVoMap.containsKey(respDto.getPreOrderNo())) {
                            OrderInfoVo orderInfoVo = orderInfoVoMap.get(respDto.getPreOrderNo());
                            reportEo.setEasNo(orderInfoVo.getEasNo());
                            reportEo.setCustomerName(orderInfoVo.getCustomerName());
                        }
                        if (Objects.equals(transferOrderEo.getSourceSystem(), "EAS")) {
                            if (adjustmentInventoryEoMap.containsKey(transferOrderEo.getTransferOrderNo())) {
                                String externalOrderNo = adjustmentInventoryEoMap.get(transferOrderEo.getTransferOrderNo()).getExternalOrderNo();
                                reportEo.setEasNo(externalOrderNo);
                            }
                        } else {
                            reportEo.setEasNo(transferOrderEo.getPreOrderNo());
                        }
                        reportEo.setRemark(remark);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)reportEo.getBusinessType()) && StringUtils.isNotBlank((CharSequence)reportEo.getWarehouseCode()) && reportEo.getBillingFeeFlag() == null) {
                    DailyDeliveryReportDto deliveryReportDto = new DailyDeliveryReportDto();
                    CubeBeanUtils.copyProperties((Object)deliveryReportDto, (Object)respDto, (String[])new String[0]);
                    DailyDeliveryFeeFilterConfigMatchResultDto filterConfigMatchResultDto = this.dailyDeliveryFeeFilterConfigService.filterFee(deliveryReportDto, DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode(), reportEo.getWarehouseCode(), reportEo.getBusinessType());
                    reportEo.setBillingFeeFlag(filterConfigMatchResultDto.isFilterResult() ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
                    this.setNoBillReasonCauses(reportEo, filterConfigMatchResultDto.getFilterFalseReason());
                }
                if (StringUtils.isNotBlank((CharSequence)reportEo.getCustomerName()) && StringUtils.isNotBlank((CharSequence)reportEo.getLogisticCode()) && shipmentListMap.containsKey(reportEo.getLogisticCode()) && StringUtils.isNotBlank((CharSequence)((ShipmentEnterpriseEo)shipmentListMap.get(reportEo.getLogisticCode())).getCustomerName()) && (customerNameList = Arrays.stream((customerName = ((ShipmentEnterpriseEo)shipmentListMap.get(reportEo.getLogisticCode())).getCustomerName()).split(",")).collect(Collectors.toList())).contains(reportEo.getCustomerName())) {
                    reportEo.setBillingFeeFlag(YesNoEnum.NO.getValue());
                    this.setNoBillReasonCauses(reportEo, "\u7d22\u8d54\u4e0d\u8ba1\u8d39");
                }
                String warehouseCode = Optional.ofNullable(reportEo.getWarehouseCode()).orElse("");
                String businessType = Optional.ofNullable(reportEo.getBusinessType()).orElse("");
                if (pastDetailEoMap.containsKey(reportEo.getLinkDailyReportId())) {
                    ExpressCostDetailEo pastDetailEo = (ExpressCostDetailEo)pastDetailEoMap.get(reportEo.getLinkDailyReportId());
                    reportEo.setExpressBackRemake(pastDetailEo.getExpressBackRemake());
                    reportEo.setChargedWeight(pastDetailEo.getChargedWeight());
                    reportEo.setVolumeRemark(pastDetailEo.getVolumeRemark());
                    reportEo.setReturnFee(pastDetailEo.getReturnFee());
                    reportEo.setInsureAmount(pastDetailEo.getInsureAmount());
                    reportEo.setPremium(pastDetailEo.getPremium());
                    reportEo.setAdjustmentType(pastDetailEo.getAdjustmentType());
                    reportEo.setAdjustmentAmount(pastDetailEo.getAdjustmentAmount());
                    reportEo.setRemark(pastDetailEo.getRemark());
                    reportEo.setFreightOrg(StringUtils.isNotBlank((CharSequence)pastDetailEo.getFreightOrg()) ? pastDetailEo.getFreightOrg() : reportEo.getFreightOrg());
                    reportEo.setFreightOrgCode(StringUtils.isNotBlank((CharSequence)pastDetailEo.getFreightOrgCode()) ? pastDetailEo.getFreightOrg() : reportEo.getFreightOrgCode());
                }
                DailyDeliveryFeeFilterExtConfigReqDto configReqDto = new DailyDeliveryFeeFilterExtConfigReqDto();
                configReqDto.setFilterPhysicalWarehouse(reportEo.getWarehouseCode());
                configReqDto.setFilterLogicWarehouse(reportEo.getOutWarehouseCode());
                configReqDto.setFilterBusinessType(reportEo.getBusinessType());
                configReqDto.setLogisticsCompany(reportEo.getLogisticCompany());
                configReqDto.setTransportStyle(reportEo.getTransportType());
                configReqDto.setFilterInventoryOrg(reportEo.getOutOrg());
                boolean filterApplicable = this.dailyDeliveryFeeFilterExtConfigService.isFilterApplicable(outFilter, configReqDto);
                if (filterApplicable) {
                    log.info("\u547d\u4e2d\u5254\u9664\u8ba1\u8d39\u914d\u7f6e");
                    reportEo.setBillingFeeFlag(Integer.valueOf(0));
                    this.setNoBillReasonCauses(reportEo, "\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u547d\u4e2d");
                }
                list.add(reportEo);
            }
            list.forEach(i -> {
                outCodes.add(i.getOutWarehouseCode());
                inCodes.add(i.getInWarehouseCode());
            });
            Map<String, FeeAttributionConfigEo> feeAttributionConfigEoMap = this.asyncQueryFeeAttributionConfig(outCodes, inCodes);
            list.forEach(i -> {
                FeeAttributionConfigEo one;
                String key;
                if (StringUtils.isNotBlank((CharSequence)i.getInWarehouseCode()) && StringUtils.isNotBlank((CharSequence)i.getOutWarehouseCode()) && feeAttributionConfigEoMap.containsKey(key = String.format("%s%s", i.getOutWarehouseCode(), i.getInWarehouseCode())) && (one = (FeeAttributionConfigEo)feeAttributionConfigEoMap.get(key)) != null) {
                    i.setFreightOrg(one.getCostBelongOrgName());
                }
            });
            queryReportDto.setPageNum(Integer.valueOf(queryReportDto.getPageNum() + 1));
        }
        log.info("\u65e0\u6570\u636e");
        this.buildExpressCostArea(list);
        return list;
    }

    private boolean isFilterApplicable(String warehouseCode, String businessType, DailyDeliveryFeeFilterConfigMatchResultDto outFilter) {
        boolean warehouseCodeMatch = StringUtils.isNotBlank((CharSequence)warehouseCode) && outFilter.getWarehouseCodeList().contains(warehouseCode);
        boolean businessTypeMatch = StringUtils.isNotBlank((CharSequence)businessType) && outFilter.getBizTypeCodeList().contains(businessType);
        return warehouseCodeMatch || businessTypeMatch;
    }

    private boolean isFilterApplicable(ExpressCostDetailEo detailEo, List<DailyDeliveryFeeFilterExtConfigRespDto> configRespDtoList) {
        boolean result = true;
        for (DailyDeliveryFeeFilterExtConfigRespDto config : configRespDtoList) {
            List collect;
            result = true;
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterPhysicalWarehouseDataList())) {
                if (StringUtils.isBlank((CharSequence)detailEo.getWarehouseCode())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterPhysicalWarehouseDataList().stream().filter(f -> f.getCode().equals(detailEo.getWarehouseCode())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterLogicWarehouseDataList())) {
                if (StringUtils.isBlank((CharSequence)detailEo.getOutWarehouseCode())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterLogicWarehouseDataList().stream().filter(f -> f.getCode().equals(detailEo.getOutWarehouseCode())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterBusinessTypeDataList())) {
                if (StringUtils.isBlank((CharSequence)detailEo.getBusinessType())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterBusinessTypeDataList().stream().filter(f -> f.getCode().equals(detailEo.getBusinessType())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterInventoryOrgDataList())) {
                if (StringUtils.isBlank((CharSequence)detailEo.getFreightOrgCode())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterInventoryOrgDataList().stream().filter(f -> f.getCode().equals(detailEo.getFreightOrgCode())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterLogisticsDataList())) {
                if (StringUtils.isBlank((CharSequence)detailEo.getLogisticCode()) || StringUtils.isBlank((CharSequence)detailEo.getTransportType())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterLogisticsDataList().stream().filter(f -> f.getLogCode().equals(detailEo.getLogisticCode())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
                List collect1 = collect.stream().map(DailyDeliveryFeeFilterExtConfigLogDataDto::getCarrierList).flatMap(Collection::stream).filter(f -> f.getCode().equals(detailEo.getTransportType())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect1)) {
                    result = false;
                    continue;
                }
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    private List<ExpressCostDetailEo> queryExpressCostDetailList(LogisticStatisticReqDto queryDto) {
        log.info("\u5feb\u9012\u8d39\u7528\u62a5\u8868\u5355\u636e\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        ArrayList list = Lists.newArrayList();
        OutResultOrderReqDto filter = new OutResultOrderReqDto();
        if (queryDto != null && null != queryDto.getStartTime() && null != queryDto.getEndTime()) {
            filter.setCreateBeginTime(DateTimeUtils.parseDateTime(queryDto.getStartTime()));
            filter.setCreateEndTime(DateTimeUtils.parseDateTime(queryDto.getEndTime()));
        } else {
            String time = DateTimeUtils.getYesterdayTime();
            String startTime = DateTimeUtils.getDayBegin(time);
            String endTime = DateTimeUtils.getDayEnd(time);
            filter.setCreateBeginTime(DateTimeUtils.parseDateTime(startTime));
            filter.setCreateEndTime(DateTimeUtils.parseDateTime(endTime));
        }
        log.info("\u83b7\u53d6\u5feb\u9012\u5546");
        List shipmentList = ((ExtQueryChainWrapper)this.shipmentEnterpriseDas.filter().eq((Object)"shipment_enterprise_type", (Object)2)).list();
        if (CollectionUtil.isNotEmpty((Collection)shipmentList)) {
            filter.setShippingCompanyCodes(shipmentList.stream().map(ShipmentEnterpriseEo::getShipmentEnterpriseCode).collect(Collectors.toList()));
        }
        filter.setShippingType(queryDto.getShippingType());
        filter.setShippingCompanyCode(queryDto.getShippingCompanyCode());
        filter.setRelevanceNo(queryDto.getRelevanceNo());
        filter.setDocumentNo(queryDto.getDocumentNo());
        filter.setDocumentNos(queryDto.getDocumentNos());
        int startNum = 1;
        int queryNum = 1000;
        while (true) {
            filter.setPageNum(Integer.valueOf(startNum));
            filter.setPageSize(Integer.valueOf(queryNum));
            log.info("queryExpressCostDetailList\u5355\u636e\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)filter));
            PageInfo<OutResultOrderEo> respDtoPageInfo = this.outResultOrderService.queryConsignmentList(filter);
            List eoList = respDtoPageInfo.getList();
            if (CollectionUtils.isNotEmpty((Collection)eoList)) {
                log.info("queryExpressCostDetailList\u7ed3\u679c\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)eoList));
                HashSet logicCodes = Sets.newHashSet();
                HashSet inPhysicsWarehouseCodes = Sets.newHashSet();
                HashSet orderNos = Sets.newHashSet();
                HashSet procurementOrderNos = Sets.newHashSet();
                HashSet saleOrderNos = Sets.newHashSet();
                HashSet otherOrderNos = Sets.newHashSet();
                HashSet refundOrderNos = Sets.newHashSet();
                HashSet outCodes = Sets.newHashSet();
                HashSet inCodes = Sets.newHashSet();
                HashSet peOrderNos = Sets.newHashSet();
                HashSet preOrderNos = Sets.newHashSet();
                ArrayList queryList = Lists.newArrayList();
                eoList.forEach(i -> {
                    logicCodes.add(i.getInLogicWarehouseCode());
                    logicCodes.add(i.getOutLogicWarehouseCode());
                    if (StringUtils.isNotBlank((CharSequence)i.getInPhysicsWarehouseCode())) {
                        inPhysicsWarehouseCodes.add(i.getInPhysicsWarehouseCode());
                    }
                    if (transferOrderBusinessType.contains(i.getBusinessType())) {
                        orderNos.add(i.getRelevanceNo());
                    }
                    if (refundOrderBusinessType.contains(i.getBusinessType())) {
                        procurementOrderNos.add(i.getRelevanceNo());
                    }
                    if (saleOrderBusinessType.contains(i.getBusinessType())) {
                        saleOrderNos.add(i.getRelevanceNo());
                    }
                    if (Objects.equals(i.getBusinessType(), CsPcpBusinessTypeEnum.OTHER_OUT.getCode())) {
                        otherOrderNos.add(i.getRelevanceNo());
                    }
                    if (refundOrderBusinessType.contains(i.getBusinessType())) {
                        refundOrderNos.add(i.getRelevanceNo());
                    }
                    peOrderNos.add(i.getPreOrderNo());
                    preOrderNos.add(i.getPreOrderNo());
                    if (i.getInOutTime() != null && StringUtils.isNotBlank((CharSequence)i.getOutPhysicsWarehouseCode()) && StringUtils.isNotBlank((CharSequence)i.getShippingCompanyCode()) && StringUtils.isNotBlank((CharSequence)i.getShippingType())) {
                        ExpressCostQueryPo reqDto = new ExpressCostQueryPo();
                        reqDto.setWhCode(i.getOutPhysicsWarehouseCode());
                        reqDto.setLogisticCompany(i.getShippingCompanyCode());
                        CsShipmentLogisticsTypeEnum csShipmentLogisticsTypeEnum = CsShipmentLogisticsTypeEnum.getEnumByName((String)i.getShippingType());
                        if (csShipmentLogisticsTypeEnum != null) {
                            reqDto.setTransportType(csShipmentLogisticsTypeEnum.getType() + "");
                        }
                        reqDto.setOutWarehouseTime(i.getInOutTime());
                        queryList.add(reqDto);
                    }
                });
                Map<String, CsWarehouseAddressEo> whAddressMap = this.queryWarehouseAddress(new ArrayList<String>(inPhysicsWarehouseCodes));
                Map<String, CsTransferOrderEo> transferOrderMap = this.queryTransferOrder(orderNos);
                Map<String, InventorySupplierEo> supplierEoMap = this.asyncQueryPlannedOrderSupplier(procurementOrderNos);
                Map<String, SaleOrderEo> saleOrderEoMap = this.asyncQuerySaleOrder(saleOrderNos);
                Map<String, OutPlannedOrderEo> saleRefundEoMap = this.asyncQuerySaleRefundOrder(refundOrderNos);
                Map<String, CsOtherStorageOrderEo> otherOrderMap = this.asyncQueryOtherOrder(otherOrderNos);
                List logicWarehouseEos = ((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"warehouse_code", new ArrayList(logicCodes))).list(Integer.valueOf(logicCodes.size()));
                Map whMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
                Map<String, OutNoticeOrderRespDto> outNoticeOrderRespDtoMap = this.asyncQueryOutNoticeOrder(preOrderNos);
                Map<String, ExpressCostContractEo> recordMap = this.asyncQueryExpressCostModes(queryList);
                log.info("\u5f02\u6b65\u67e5\u4e0b\u5408\u540c\u6570\u636e\uff1a{}", (Object)(ObjectUtils.isEmpty(recordMap) ? "\u65e0\u6570\u636e" : JSON.toJSONString(recordMap)));
                Map<String, OrderInfoVo> orderInfoVoMap = this.asyncQueryOrderInfo(preOrderNos);
                Map<String, AdjustmentInventoryEo> adjustmentInventoryEoMap = this.asyncQueryAdjustmentInventory(orderNos);
                for (OutResultOrderEo respDto : eoList) {
                    String remark;
                    log.info("\u904d\u5386\u660e\u7ec6\u5355\u636e\uff0c\u5904\u7406\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
                    ExpressCostDetailEo reportEo = new ExpressCostDetailEo();
                    reportEo.setAbnormal(Integer.valueOf(0));
                    reportEo.setBillType(LogisticDocumentTypeEnum.ORIGINAL.getCode());
                    reportEo.setOutboundTime(respDto.getInOutTime());
                    reportEo.setOutboundCode(respDto.getDocumentNo());
                    reportEo.setWmsOutboundCode(respDto.getWmsOrderNo());
                    reportEo.setBusinessCode(respDto.getRelevanceNo());
                    reportEo.setWarehouseName(respDto.getOutPhysicsWarehouseName());
                    reportEo.setWarehouseCode(respDto.getOutPhysicsWarehouseCode());
                    reportEo.setLogisticCompany(respDto.getShippingCompany());
                    reportEo.setLogisticCode(respDto.getShippingCompanyCode());
                    reportEo.setTransportType(respDto.getShippingType());
                    reportEo.setExpressNo(respDto.getShippingCode());
                    reportEo.setBusinessType(respDto.getBusinessType());
                    reportEo.setInWarehouseName(respDto.getInLogicWarehouseName());
                    reportEo.setInWarehouseCode(respDto.getInLogicWarehouseCode());
                    reportEo.setBookkeepingMonth(DateTimeUtils.formatDate(respDto.getUpdateTime(), "yyyy-MM"));
                    reportEo.setPieceNum(Long.valueOf(respDto.getTotalCartons().longValue()));
                    reportEo.setRelevanceNo(respDto.getRelevanceNo());
                    if (YYJ_BUSINESS_TYPE.contains(respDto.getBusinessType())) {
                        reportEo.setNutritionistOrder(Boolean.valueOf(true));
                    }
                    if (orderInfoVoMap != null && orderInfoVoMap.containsKey(respDto.getPreOrderNo())) {
                        PcpRegionEo one;
                        OrderInfoVo orderInfoVo = orderInfoVoMap.get(respDto.getPreOrderNo());
                        reportEo.setCustomerName(orderInfoVo.getCustomerName());
                        reportEo.setProvince(orderInfoVo.getProvince());
                        reportEo.setCity(orderInfoVo.getCity());
                        reportEo.setArea(orderInfoVo.getArea());
                        reportEo.setAddress(orderInfoVo.getDetailAddress());
                        if (StringUtils.isNotEmpty((CharSequence)reportEo.getAddress())) {
                            GeoAddressInfo geoAddress = this.lbsUtil.getGeoAddressCache(reportEo.getAddress());
                            log.info("\u83b7\u53d6\u7ecf\u7eac\u5ea6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)geoAddress));
                            reportEo.setLngLat(geoAddress.getLocation());
                            if (StringUtils.isBlank((CharSequence)reportEo.getProvince())) {
                                reportEo.setProvince(geoAddress.getProvince());
                            }
                            if (StringUtils.isBlank((CharSequence)reportEo.getCity())) {
                                reportEo.setCity(geoAddress.getCity());
                            }
                            if (StringUtils.isBlank((CharSequence)reportEo.getArea())) {
                                reportEo.setArea(geoAddress.getDistrict());
                            }
                        }
                        if (StringUtils.isBlank((CharSequence)reportEo.getProvince())) {
                            reportEo.setAbnormal(Integer.valueOf(1));
                            this.setAbnormalCauses(reportEo, "\u7701\u4efd\u4e3a\u7a7a");
                        } else if (reportEo.getProvince().contains("\u5e02")) {
                            reportEo.setProvince(reportEo.getProvince().replace("\u5e02", ""));
                        }
                        if (StringUtils.isNotBlank((CharSequence)reportEo.getProvince()) && StringUtils.isNotBlank((CharSequence)reportEo.getCity()) && StringUtils.isBlank((CharSequence)reportEo.getArea()) && (one = (PcpRegionEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.regionDas.filter().likeRight((Object)"name", (Object)reportEo.getCity())).likeRight((Object)"parent_name", (Object)reportEo.getProvince())).last("limit 1")).one()) != null) {
                            reportEo.setCityLevel(one.getCityLevel());
                        }
                        if (StringUtils.isNotBlank((CharSequence)reportEo.getProvince()) && StringUtils.isNotBlank((CharSequence)reportEo.getCity()) && StringUtils.isNotBlank((CharSequence)reportEo.getArea()) && (one = (PcpRegionEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.regionDas.filter().likeRight((Object)"name", (Object)reportEo.getArea())).likeRight((Object)"parent_name", (Object)reportEo.getCity())).last("limit 1")).one()) != null) {
                            reportEo.setCityLevel(one.getCityLevel());
                        }
                    } else {
                        reportEo.setAbnormal(Integer.valueOf(1));
                        this.setAbnormalCauses(reportEo, "\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)respDto.getOutPhysicsWarehouseCode())) {
                        log.info("\u8be5\u6570\u636e\u7269\u7406\u4ed3\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)respDto));
                        continue;
                    }
                    if (respDto.getInOutTime() != null && StringUtils.isNotBlank((CharSequence)respDto.getOutPhysicsWarehouseCode()) && StringUtils.isNotBlank((CharSequence)respDto.getShippingCompanyCode()) && StringUtils.isNotBlank((CharSequence)respDto.getShippingType())) {
                        String shippingType = "";
                        CsShipmentLogisticsTypeEnum csShipmentLogisticsTypeEnum = CsShipmentLogisticsTypeEnum.getEnumByName((String)respDto.getShippingType());
                        if (csShipmentLogisticsTypeEnum != null) {
                            shippingType = csShipmentLogisticsTypeEnum.getType() + "";
                        }
                        String key = String.format("%s%s%s", respDto.getOutPhysicsWarehouseCode(), respDto.getShippingCompanyCode(), shippingType);
                        log.info("\u5339\u914d\u5feb\u9012\u6a21\u7248key\uff1a{}\uff0c{}", (Object)respDto.getDocumentNo(), (Object)key);
                        ExpressCostContractEo eo = recordMap.get(key);
                        log.info("\u5feb\u9012\u6a21\u677f====={}", (Object)JSON.toJSONString((Object)eo));
                        if (null != eo && null != eo.getId()) {
                            log.info("\u6a21\u7248\u6570\u636e\uff1a{}\uff0c{}", (Object)respDto.getDocumentNo(), (Object)JSON.toJSONString((Object)eo));
                            reportEo.setChargeMode(eo.getChargeMode());
                            reportEo.setContractId(eo.getId());
                            reportEo.setExpressCostContractEo(eo);
                            reportEo.setLogisticCompany(eo.getLogisticCompany());
                        } else {
                            reportEo.setAbnormal(Integer.valueOf(1));
                            reportEo.setFirstPrice(new BigDecimal("-1"));
                            reportEo.setContinuedOne(new BigDecimal("-1"));
                            reportEo.setContinuedTwo(new BigDecimal("-1"));
                            reportEo.setContinuedThree(new BigDecimal("-1"));
                            reportEo.setContinuedFour(new BigDecimal("-1"));
                            reportEo.setContinuedFreight(new BigDecimal("-1"));
                            reportEo.setTotalFreight(new BigDecimal("-1"));
                            this.setAbnormalCauses(reportEo, "\u6a21\u677f\u5df2\u8fc7\u671f\u6216\u672a\u5339\u914d\u5230\u6709\u6548\u7684\u5feb\u9012\u8d39\u7528\u6a21\u677f");
                        }
                    } else {
                        if (respDto.getInOutTime() == null) {
                            this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u65f6\u95f4\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)respDto.getOutPhysicsWarehouseCode())) {
                            this.setAbnormalCauses(reportEo, "\u51fa\u5e93\u7269\u7406\u4ed3\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)respDto.getShippingCompanyCode())) {
                            this.setAbnormalCauses(reportEo, "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)respDto.getShippingType())) {
                            this.setAbnormalCauses(reportEo, "\u627f\u8fd0\u65b9\u5f0f\u4e3a\u7a7a");
                        }
                        reportEo.setAbnormal(Integer.valueOf(1));
                    }
                    reportEo.setVolume(respDto.getTotalVolume());
                    reportEo.setWeight(respDto.getTotalWeight());
                    if (StringUtils.isNotEmpty((CharSequence)respDto.getOutLogicWarehouseName())) {
                        reportEo.setOutWarehouseName(respDto.getOutLogicWarehouseName());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)respDto.getOutLogicWarehouseName())) {
                        reportEo.setOutWarehouseCode(respDto.getOutLogicWarehouseCode());
                    }
                    if (StringUtils.isNotBlank((CharSequence)respDto.getOutLogicWarehouseCode()) && whMap != null && whMap.containsKey(respDto.getOutLogicWarehouseCode())) {
                        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)whMap.get(respDto.getOutLogicWarehouseCode());
                        reportEo.setOutOrg(logicWarehouseEo.getOrganizationName());
                        if (logicWarehouseEo.getOrganizationId() != null) {
                            reportEo.setInOrgCode(logicWarehouseEo.getOrganizationId().toString());
                        }
                        reportEo.setFreightOrg(logicWarehouseEo.getOrganizationName());
                    }
                    if (saleOrderBusinessType.contains(reportEo.getBusinessType())) {
                        OutNoticeOrderRespDto orderRespDto;
                        if (saleOrderEoMap.containsKey(respDto.getRelevanceNo())) {
                            SaleOrderEo saleOrderEo = saleOrderEoMap.get(respDto.getRelevanceNo());
                            remark = saleOrderEo.getSellerRemark();
                            reportEo.setRemark(remark);
                            if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getEasOrderNo())) {
                                reportEo.setEasNo(saleOrderEo.getEasOrderNo());
                            } else {
                                reportEo.setEasNo(saleOrderEo.getEasOutOrderNo());
                            }
                            reportEo.setBillingDate(DateTimeUtils.formatDate(saleOrderEo.getSaleCreateTime(), "yyyy-MM-dd"));
                            reportEo.setEasNo(saleOrderEo.getEasOrderNo());
                            reportEo.setCustomerName(saleOrderEo.getCustomerName());
                        }
                        if ((orderRespDto = outNoticeOrderRespDtoMap.get(respDto.getPreOrderNo())) != null) {
                            ContactDto jsonObject = (ContactDto)JSONObject.parseObject((String)orderRespDto.getExtension(), ContactDto.class);
                            reportEo.setConsignee(jsonObject.getReciveName());
                        }
                    }
                    if (BusinessTypeEnum.OTHER_OUT.getCode().equals(respDto.getBusinessType()) || BusinessTypeEnum.OTHER_IN.getCode().equals(respDto.getBusinessType())) {
                        CsOtherStorageOrderEo otherStorageOrderEo = otherOrderMap.get(respDto.getRelevanceNo());
                        if (otherStorageOrderEo != null) {
                            reportEo.setEasNo(otherStorageOrderEo.getExternalOrderNo());
                            remark = otherStorageOrderEo.getRemark();
                            if (StringUtils.isBlank((CharSequence)remark)) {
                                remark = otherStorageOrderEo.getMessage();
                            }
                            reportEo.setRemark(remark);
                            reportEo.setBillingDate(DateTimeUtils.formatDate(otherStorageOrderEo.getCreateTime(), "yyyy-MM-dd"));
                            reportEo.setEasNo(otherStorageOrderEo.getExternalOrderNo());
                            reportEo.setCustomerName(otherStorageOrderEo.getCustomerName());
                            reportEo.setConsignee(otherStorageOrderEo.getConsignee());
                        } else {
                            this.setAbnormalCauses(reportEo, "\u6536\u8d27\u5730\u5740\u4e3a\u7a7a");
                            reportEo.setAbnormal(Integer.valueOf(1));
                        }
                    }
                    if (refundOrderBusinessType.contains(respDto.getBusinessType()) && saleRefundEoMap.containsKey(respDto.getRelevanceNo())) {
                        OutPlannedOrderEo outPlannedOrderEo = saleRefundEoMap.get(respDto.getRelevanceNo());
                        remark = outPlannedOrderEo.getRemark();
                        reportEo.setRemark(remark);
                        reportEo.setBillingDate(DateTimeUtils.formatDate(outPlannedOrderEo.getCreateTime(), "yyyy-MM-dd"));
                        reportEo.setEasNo(outPlannedOrderEo.getPlatformOrderNo());
                        InventorySupplierEo inventorySupplierEo = supplierEoMap.get(respDto.getRelevanceNo());
                        reportEo.setConsignee(inventorySupplierEo.getLinkman());
                    }
                    if (transferOrderBusinessType.contains(respDto.getBusinessType())) {
                        if (!transferOrderMap.containsKey(respDto.getRelevanceNo())) continue;
                        if (whAddressMap.containsKey(respDto.getInPhysicsWarehouseCode())) {
                            CsWarehouseAddressEo addressEo = whAddressMap.get(respDto.getInPhysicsWarehouseCode());
                            reportEo.setConsignee(addressEo.getContacts());
                        }
                        CsTransferOrderEo transferOrderEo = transferOrderMap.get(respDto.getRelevanceNo());
                        reportEo.setInWarehouseName(transferOrderEo.getInLogicWarehouseName());
                        reportEo.setInWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
                        reportEo.setInOrg(transferOrderEo.getInOrganization());
                        if (transferOrderEo.getInOrganizationId() != null) {
                            reportEo.setInOrgCode(transferOrderEo.getInOrganizationId().toString());
                        }
                        if (Objects.equals(transferOrderEo.getOutPhysicsWarehouseCode(), transferOrderEo.getInPhysicsWarehouseCode())) continue;
                        remark = transferOrderEo.getRemark();
                        reportEo.setBillingDate(DateTimeUtils.formatDate(transferOrderEo.getCreateTime(), "yyyy-MM-dd"));
                        if (orderInfoVoMap != null && orderInfoVoMap.containsKey(respDto.getPreOrderNo())) {
                            OrderInfoVo orderInfoVo = orderInfoVoMap.get(respDto.getPreOrderNo());
                            reportEo.setEasNo(orderInfoVo.getEasNo());
                            reportEo.setCustomerName(orderInfoVo.getCustomerName());
                        }
                        if (Objects.equals(transferOrderEo.getSourceSystem(), "EAS")) {
                            if (adjustmentInventoryEoMap.containsKey(transferOrderEo.getTransferOrderNo())) {
                                String externalOrderNo = adjustmentInventoryEoMap.get(transferOrderEo.getTransferOrderNo()).getExternalOrderNo();
                                reportEo.setEasNo(externalOrderNo);
                            }
                        } else {
                            reportEo.setEasNo(transferOrderEo.getPreOrderNo());
                        }
                        reportEo.setRemark(remark);
                        list.add(reportEo);
                        continue;
                    }
                    list.add(reportEo);
                }
                list.forEach(i -> {
                    outCodes.add(i.getOutWarehouseCode());
                    inCodes.add(i.getInWarehouseCode());
                });
                Map<String, FeeAttributionConfigEo> feeAttributionConfigEoMap = this.asyncQueryFeeAttributionConfig(outCodes, inCodes);
                list.forEach(i -> {
                    FeeAttributionConfigEo one;
                    String key;
                    if (StringUtils.isNotBlank((CharSequence)i.getInWarehouseCode()) && StringUtils.isNotBlank((CharSequence)i.getOutWarehouseCode()) && feeAttributionConfigEoMap.containsKey(key = String.format("%s%s", i.getOutWarehouseCode(), i.getInWarehouseCode())) && (one = (FeeAttributionConfigEo)feeAttributionConfigEoMap.get(key)) != null) {
                        i.setFreightOrg(one.getCostBelongOrgName());
                    }
                });
            }
            if (respDtoPageInfo == null || CollectionUtil.isEmpty((Collection)respDtoPageInfo.getList()) || respDtoPageInfo.getList().size() < queryNum) break;
            ++startNum;
        }
        this.buildExpressCostArea(list);
        return list;
    }

    private void buildExpressCostArea(List<ExpressCostDetailEo> list) {
        log.info("\u5339\u914d\u5feb\u9012\u6a21\u7248\u533a\u57df\uff1a{}", (Object)JSON.toJSONString(list));
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List contractIds = list.stream().map(ExpressCostDetailEo::getContractId).distinct().collect(Collectors.toList());
        ExpressCostAreaEo queryEo = new ExpressCostAreaEo();
        queryEo.setSqlFilters((List)com.google.common.collect.Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"contract_id", contractIds)}));
        List expressCostAreaEos = this.expressCostAreaDas.select((BaseEo)queryEo);
        if (CollectionUtil.isEmpty((Collection)expressCostAreaEos)) {
            log.info("\u6ca1\u6709\u6a21\u7248\u533a\u57df");
            return;
        }
        Map map = expressCostAreaEos.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getArea()) && StringUtils.isNotBlank((CharSequence)f.getCity())).collect(Collectors.toMap(m -> m.getContractId().toString() + m.getProvince() + m.getCity() + m.getArea(), Function.identity(), (k1, k2) -> k1));
        log.info("\u7701\u5e02\u533a\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString(map));
        Map map2 = expressCostAreaEos.stream().filter(f -> StringUtils.isBlank((CharSequence)f.getArea())).collect(Collectors.toMap(m -> m.getContractId().toString() + m.getProvince() + m.getCity(), Function.identity(), (k1, k2) -> k1));
        log.info("\u7701\u5e02\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString(map2));
        Map map3 = expressCostAreaEos.stream().filter(f -> StringUtils.isBlank((CharSequence)f.getArea()) && StringUtils.isBlank((CharSequence)f.getCity())).collect(Collectors.toMap(m -> m.getContractId().toString() + m.getProvince(), Function.identity(), (k1, k2) -> k1));
        log.info("\u7701\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString(map3));
        list.forEach(dto -> {
            log.info("buildExpressCostArea\u5339\u914d\u533a\u57df\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            if (ObjectUtil.isNotEmpty((Object)dto.getContractId())) {
                ExpressCostAreaEo areaDto = null;
                String key = dto.getProvince() + dto.getCity() + dto.getArea();
                areaDto = (ExpressCostAreaEo)map.get(dto.getContractId().toString() + key);
                if (ObjectUtil.isEmpty((Object)areaDto)) {
                    key = dto.getProvince() + dto.getCity();
                    areaDto = (ExpressCostAreaEo)map2.get(dto.getContractId().toString() + key);
                }
                if (ObjectUtil.isEmpty((Object)areaDto)) {
                    key = dto.getProvince();
                    log.info("\u901a\u8fc7\u7701\u5339\u914d\uff1a{}", (Object)(dto.getContractId().toString() + key));
                    areaDto = (ExpressCostAreaEo)map3.get(dto.getContractId().toString() + key);
                }
                dto.setExpressCostAreaEo(areaDto);
                if (ObjectUtil.isEmpty((Object)areaDto)) {
                    dto.setAbnormal(Integer.valueOf(1));
                    this.setAbnormalCauses((ExpressCostDetailEo)dto, "\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u6a21\u7248\u533a\u57df");
                }
            }
        });
    }

    private Map<String, PcpRegionEo> asyncCityLevel() {
        Map<String, Object> cityLevelMap = new HashMap<String, PcpRegionEo>();
        List pcpRegionEos = ((ExtQueryChainWrapper)this.regionDas.filter().eq((Object)"level_id", (Object)1)).list();
        if (CollectionUtil.isNotEmpty((Collection)pcpRegionEos)) {
            cityLevelMap = pcpRegionEos.stream().collect(Collectors.toMap(PcpRegionEo::getCode, Function.identity(), (k1, k2) -> k1));
        }
        return cityLevelMap;
    }

    private Map<String, FeeAttributionConfigEo> queryFeeAttributionConfig(Set<String> outCodes, Set<String> inCodes) {
        if (CollectionUtil.isEmpty(outCodes) || CollectionUtil.isEmpty(inCodes)) {
            return Maps.newHashMap();
        }
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.feeAttributionConfigDas.filter().in((Object)"out_warehouse_code", outCodes)).in((Object)"in_warehouse_code", inCodes)).list();
        if (CollectionUtil.isEmpty((Collection)eos)) {
            return Maps.newHashMap();
        }
        return eos.stream().collect(Collectors.toMap(i -> String.format("%s%s", i.getOutWarehouseCode(), i.getInWarehouseCode()), j -> j, (k1, k2) -> k1));
    }

    private Map<String, FeeAttributionConfigEo> asyncQueryFeeAttributionConfig(Set<String> outCods, Set<String> inCodes) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.queryFeeAttributionConfig(outCods, inCodes), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u8d39\u7528\u5f52\u5c5e\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private void setAbnormalCauses(ExpressCostDetailEo eo, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)eo.getAbnormalCauses())) {
            eo.setAbnormalCauses(errorMsg);
        } else {
            eo.setAbnormalCauses(String.format("%s\u3001%s", eo.getAbnormalCauses(), errorMsg));
        }
    }

    private void setNoBillReasonCauses(ExpressCostDetailEo msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getNoBillingReason())) {
            msgDto.setNoBillingReason(errorMsg);
        } else {
            msgDto.setNoBillingReason(String.format("%s\u3001%s", msgDto.getNoBillingReason(), errorMsg));
        }
    }

    private Map<String, OutPlannedOrderEo> querySaleRefundOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List saleOrderEos = ((ExtQueryChainWrapper)this.outPlannedOrderDas.filter().in((Object)"order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
            return Maps.newHashMap();
        }
        return saleOrderEos.stream().collect(Collectors.toMap(OutPlannedOrderEo::getOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsOtherStorageOrderEo> queryOtherOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List saleOrderEos = ((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().in((Object)"storage_order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
            return Maps.newHashMap();
        }
        return saleOrderEos.stream().collect(Collectors.toMap(CsOtherStorageOrderEo::getStorageOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, OutNoticeOrderRespDto> asyncQueryOutNoticeOrder(Set<String> orderNos) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.outNoticeOrderService.queryByDocumentNos(orderNos), this.statisticsExecutor);
        try {
            List respDtos = future.get();
            if (CollectionUtil.isEmpty((Collection)respDtos)) {
                return Maps.newHashMap();
            }
            return respDtos.stream().collect(Collectors.toMap(OutNoticeOrderRespDto::getDocumentNo, Functions.identity(), (k1, k2) -> k1));
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u51fa\u5e93\u901a\u77e5\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, AdjustmentInventoryEo> asyncQueryAdjustmentInventory(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.queryQueryAdjustmentInventory(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u5f02\u6b65\u67e5\u8be2\u5728\u9014\u5e93\u5b58\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, AdjustmentInventoryEo> queryQueryAdjustmentInventory(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.adjustmentInventoryDas.filter().eq((Object)"source_type", (Object)"receiveResult")).eq((Object)"business_type", (Object)"in_transit_adjustment_out")).eq((Object)"adjustment_status", (Object)"completed")).in((Object)"relevance_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(AdjustmentInventoryEo::getRelevanceNo, Function.identity(), (k1, k2) -> k1));
    }

    private List<ExpressCostContractEo> queryExpressCostModes(List<ExpressCostQueryPo> queryList) {
        List expressCostContractEos = this.expressCostContractDas.queryList(queryList);
        if (CollectionUtil.isNotEmpty((Collection)expressCostContractEos)) {
            return expressCostContractEos;
        }
        return Lists.newArrayList();
    }

    private Map<String, ExpressCostContractEo> asyncQueryExpressCostModes(List<ExpressCostQueryPo> queryList) {
        log.info("\u5f02\u6b65\u67e5\u4e0b\u8d39\u7528\u6a21\u677f\uff1a{}", (Object)JSON.toJSONString(queryList));
        List<ExpressCostContractEo> future = this.queryExpressCostModes(queryList);
        try {
            List<ExpressCostContractEo> respDtos = future;
            if (CollectionUtil.isEmpty(respDtos)) {
                log.info("asyncQueryExpressCostModes\u65e0\u6570\u636e\uff0c\u76f4\u63a5\u8fd4\u56de");
                return Maps.newHashMap();
            }
            HashMap map = Maps.newHashMap();
            for (ExpressCostContractEo respDto : respDtos) {
                String warehouseId = respDto.getWarehouseCode();
                String logisticId = respDto.getLogisticCode();
                String transportType = respDto.getTransportType();
                Date startTime = respDto.getStartTime();
                Date endTime = respDto.getEndTime();
                for (ExpressCostQueryPo reqDto : queryList) {
                    String whCode = reqDto.getWhCode();
                    String logisticCompany = reqDto.getLogisticCompany();
                    String transportType1 = reqDto.getTransportType();
                    Date outWarehouseTime = reqDto.getOutWarehouseTime();
                    String key = String.format("%s%s%s", whCode, logisticCompany, transportType1);
                    if (!Objects.equals(warehouseId, whCode) || !Objects.equals(logisticId, logisticCompany) || !Objects.equals(transportType, transportType1) || endTime.getTime() <= outWarehouseTime.getTime() || startTime.getTime() > outWarehouseTime.getTime()) continue;
                    map.put(key, respDto);
                }
            }
            return map;
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u5feb\u9012\u5408\u540c\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, OrderInfoVo> asyncQueryOrderInfo(Set<String> orderNos) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.finLogisticsReportDas.queryOrderInfo(new ArrayList(orderNos)), this.statisticsExecutor);
        try {
            List orderInfoVos = future.get();
            if (CollectionUtil.isEmpty((Collection)orderInfoVos)) {
                return null;
            }
            return orderInfoVos.stream().collect(Collectors.toMap(OrderInfoVo::getOrderNo, Function.identity(), (k1, k2) -> k1));
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, CsOtherStorageOrderEo> asyncQueryOtherOrder(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.queryOtherOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u5176\u4ed6\u51fa\u5165\u5e93\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, OutPlannedOrderEo> asyncQuerySaleRefundOrder(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.querySaleRefundOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u9500\u9000\u8d27\u5355\u552e\u8ba2\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, SaleOrderEo> asyncQuerySaleOrder(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.querySaleOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, SaleOrderEo> querySaleOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List saleOrderEos = ((ExtQueryChainWrapper)this.saleOrderDas.filter().in((Object)"sale_order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
            return Maps.newHashMap();
        }
        return saleOrderEos.stream().collect(Collectors.toMap(SaleOrderEo::getSaleOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, InventorySupplierEo> asyncQueryPlannedOrderSupplier(Set<String> orderNos) {
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> this.queryPlannedOrderSupplier(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u67e5\u8be2\u8c03\u62e8\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private Map<String, InventorySupplierEo> queryPlannedOrderSupplier(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List plannedOrderEos = ((ExtQueryChainWrapper)this.outPlannedOrderDas.filter().in((Object)"order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        if (CollectionUtil.isEmpty((Collection)plannedOrderEos)) {
            return Maps.newHashMap();
        }
        Map<String, Long> map = plannedOrderEos.stream().filter(i -> i.getSupplierId() != null).collect(Collectors.toMap(OutPlannedOrderEo::getOrderNo, o -> o.getSupplierId(), (k1, k2) -> k1));
        if (CollectionUtil.isEmpty(map)) {
            return Maps.newHashMap();
        }
        List inventorySupplierEos = this.inventorySupplierDas.selectByIds(map.values().stream().collect(Collectors.toList()));
        if (CollectionUtil.isEmpty((Collection)inventorySupplierEos)) {
            return Maps.newHashMap();
        }
        HashMap supplierMap = Maps.newHashMap();
        Map inventorySupplierEoMap = inventorySupplierEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        map.forEach((orderNo, supplierId) -> {
            if (inventorySupplierEoMap.containsKey(supplierId)) {
                supplierMap.put(orderNo, inventorySupplierEoMap.get(supplierId));
            }
        });
        return supplierMap;
    }

    private Map<String, CsWarehouseAddressEo> queryWarehouseAddress(List<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return Maps.newHashMap();
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reWarehouseAddressDas.filter().eq((Object)"valid_flag", (Object)"enable")).eq((Object)"warehouse_classify", (Object)"physics")).in((Object)"warehouse_code", codes)).list();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(CsWarehouseAddressEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsTransferOrderEo> queryTransferOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List<CsTransferOrderEo> eos = this.asyncQueryTransferOrder(orderNos);
        if (CollectionUtil.isEmpty(eos)) {
            return Maps.newHashMap();
        }
        return eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private List<CsTransferOrderEo> getTransferOrder(Set<String> orderNos) {
        List eos = ((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        return eos;
    }

    private List<CsTransferOrderEo> asyncQueryTransferOrder(Set<String> orderNos) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.getTransferOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u67e5\u8be2\u8c03\u62e8\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private void totalFreight(ExpressCostReportEo editReqDto, List<ExpressCostDetailEo> detailEos) {
        BigDecimal totalTransportAmount = editReqDto.getTotalFreight();
        if (totalTransportAmount != null) {
            BigDecimal shareAmount = BigDecimal.ZERO;
            for (int i = 0; i < detailEos.size(); ++i) {
                ExpressCostDetailEo eo = detailEos.get(i);
                if (i == detailEos.size() - 1) {
                    eo.setTotalFreight(totalTransportAmount.subtract(shareAmount));
                    continue;
                }
                if (eo.getRatio() == null) continue;
                BigDecimal lineSpecialAmount = totalTransportAmount.multiply(eo.getRatio());
                eo.setTotalFreight(lineSpecialAmount);
                shareAmount = shareAmount.add(lineSpecialAmount);
            }
        }
    }

    private void adjustmentAmount(ExpressCostDetailReqDto editReqDto, List<ExpressCostDetailEo> detailEos) {
        BigDecimal specialAmount = editReqDto.getAdjustmentAmount();
        if (specialAmount == null) {
            detailEos.forEach(i -> {
                i.setAdjustmentAmount(null);
                i.setAdjustmentType(editReqDto.getAdjustmentType());
                i.setRemark(editReqDto.getRemark());
            });
        } else {
            BigDecimal shareAmount = BigDecimal.ZERO;
            for (int i2 = 0; i2 < detailEos.size(); ++i2) {
                ExpressCostDetailEo eo = detailEos.get(i2);
                if (i2 == detailEos.size() - 1) {
                    eo.setAdjustmentAmount(specialAmount.subtract(shareAmount));
                } else {
                    if (eo.getRatio() == null) continue;
                    BigDecimal lineSpecialAmount = specialAmount.multiply(eo.getRatio());
                    eo.setAdjustmentAmount(lineSpecialAmount);
                    shareAmount = shareAmount.add(lineSpecialAmount);
                }
                eo.setAdjustmentType(editReqDto.getAdjustmentType());
                eo.setRemark(editReqDto.getRemark());
            }
        }
    }

    private void checkParams(ExpressCostDetailReqDto modifyReqDto) {
        if ((StringUtils.isNotBlank((CharSequence)modifyReqDto.getAdjustmentType()) || modifyReqDto.getAdjustmentAmount() != null) && (StringUtils.isBlank((CharSequence)modifyReqDto.getAdjustmentType()) || modifyReqDto.getAdjustmentAmount() == null)) {
            throw new BizException("\u8c03\u6574\u7c7b\u578b\u548c\u8c03\u6574\u8d39\u7528\u5fc5\u987b\u540c\u65f6\u586b\u5199");
        }
    }

    private List<String> getCarrierCodeList() {
        CsShipmenetEnterpriseQueryDto csShipmenetEnterpriseQueryDto = new CsShipmenetEnterpriseQueryDto();
        csShipmenetEnterpriseQueryDto.setPageNum(Integer.valueOf(1));
        csShipmenetEnterpriseQueryDto.setPageSize(Integer.valueOf(100));
        csShipmenetEnterpriseQueryDto.setShipmentEnterpriseStatus(Long.valueOf(1L));
        csShipmenetEnterpriseQueryDto.setShipmentEnterpriseType(Long.valueOf(2L));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csShipmenetEnterpriseQueryApi.queryByPage(csShipmenetEnterpriseQueryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            return respDtoPageInfo.getList().stream().map(CsShipmenetEnterpriseRespDto::getShipmentEnterpriseCode).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static {
        saleOrderBusinessType.add("common_order");
        saleOrderBusinessType.add("agency_order");
        saleOrderBusinessType.add("integral_order");
        saleOrderBusinessType.add("customer_refunding_order");
        saleOrderBusinessType.add("compensation_order");
        saleOrderBusinessType.add("replenishment_order");
        saleOrderBusinessType.add("quality_refunding_order");
        saleOrderBusinessType.add("replenish_order");
        saleOrderBusinessType.add("claim_reissue");
        saleOrderBusinessType.add("other_out_stock");
        saleOrderBusinessType.add("internal_distribution");
        saleOrderBusinessType.add("secondary_distribution");
        saleOrderBusinessType.add("CHILD_DIRECT_SALES");
        saleOrderBusinessType.add("PRESALE_ORDER");
        saleOrderBusinessType.add("nutrition_integral");
        saleOrderBusinessType.add("activity_order");
        YYJ_BUSINESS_TYPE.add("activity_order");
        YYJ_BUSINESS_TYPE.add("nutrition_integral");
        YYJ_BUSINESS_TYPE.add("replenishment_order");
        refundOrderBusinessType.add("outsource_refund");
        refundOrderBusinessType.add("purchase_refund");
        transferOrderBusinessType.add("allot_out_only");
        transferOrderBusinessType.add("allot_out");
        transferOrderBusinessType.add("maiyou_allot_out");
        transferOrderBusinessType.add("maiyou_bc_allot");
    }
}

