/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.schedule;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.api.dto.InitDataReqDto;
import com.dtyunxi.tcbj.biz.service.ILogicInventorySnapService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="logicInventoryWmsBalanceSnapTask")
@Scope(value="prototype")
public class LogicInventoryWmsBalanceSnapTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryWmsBalanceSnapTask.class);
    @Autowired
    private ILogicInventorySnapService logicInventorySnapService;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u4ed3\u50a8\u5feb\u7167WMS\u5e93\u5b58\u548c\u5dee\u5f02\u5e93\u5b58\u66f4\u65b0\u8c03\u5ea6\u542f\u52a8");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            InitDataReqDto initDataReqDto = new InitDataReqDto();
            if (StringUtils.isNotBlank((CharSequence)taskMsg.getContent())) {
                initDataReqDto = (InitDataReqDto)JSON.parseObject((String)taskMsg.getContent(), InitDataReqDto.class);
            }
            Date date = initDataReqDto.getDate() != null ? DateUtil.getDayBegin((Date)initDataReqDto.getDate()) : DateUtil.getDayBegin((Date)DateUtil.addDays((Date)new Date(), (int)-1));
            initDataReqDto.setDate(date);
            String dateFormat = DateUtil.getDateFormat((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            this.logicInventorySnapService.wmsBalanceSnapUpdate(dateFormat, dateFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6267\u884c\u5f02\u5e38:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u4ed3\u50a8\u5feb\u7167WMS\u5e93\u5b58\u548c\u5dee\u5f02\u5e93\u5b58\u66f4\u65b0\u8c03\u5ea6\u7ed3\u675f");
    }
}

