/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.google.common.base.Objects;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.ShInventoryPageQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.RelShareInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.ShInventoryPreemptionRespDto;
import com.dtyunxi.tcbj.biz.service.IChannelInventoryService;
import com.dtyunxi.tcbj.dao.das.ChannelInventoryDas;
import com.dtyunxi.tcbj.dao.eo.RelVirtualWarehouseEo;
import com.dtyunxi.tcbj.dao.mapper.RelVirtualWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.domain.share.IDgChannelInventoryDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgChannelWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgInventoryPreemptionDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgVirtualInventoryDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgVirtualWarehouseDomain;
import com.yunxi.dg.base.center.report.eo.share.DgChannelWarehouseEo;
import com.yunxi.dg.base.center.report.eo.share.DgInventoryPreemptionEo;
import com.yunxi.dg.base.center.report.eo.share.DgVirtualInventoryEo;
import com.yunxi.dg.base.center.report.eo.share.DgVirtualWarehouseEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelInventoryServiceImpl
implements IChannelInventoryService {
    private static final Logger log = LoggerFactory.getLogger(ChannelInventoryServiceImpl.class);
    @Autowired
    IDgChannelInventoryDomain dgChannelInventoryDomain;
    @Autowired
    IDgInventoryPreemptionDomain dgInventoryPreemptionDomain;
    @Autowired
    IDgChannelWarehouseDomain dgChannelWarehouseDomain;
    @Autowired
    RelVirtualWarehouseMapper relVirtualWarehouseMapper;
    @Autowired
    IDgVirtualInventoryDomain dgVirtualInventoryDomain;
    @Autowired
    IDgVirtualWarehouseDomain dgVirtualWarehouseDomain;
    @Autowired
    ChannelInventoryDas channelInventoryDas;

    @Override
    public PageInfo<ShInventoryPreemptionRespDto> queryPreemptionPage(ShInventoryPageQueryReqDto inventoryPageQueryReqDto) {
        log.info("queryPreemptionPage==>\u5171\u4eab\u5e93\u5b58\u5bf9\u5916\u7b2c\u4e09\u65b9\u66b4\u9732\u63a5\u53e3,\u67e5\u8be2\u5e93\u5b58\u9884\u5360\u4fe1\u606f,csInventoryPageQueryReqDto:{}", JSONObject.toJSON((Object)inventoryPageQueryReqDto));
        this.checkParams(inventoryPageQueryReqDto);
        QueryWrapper<DgInventoryPreemptionEo> queryWrapper = this.buildQueryWrapper(inventoryPageQueryReqDto);
        PageHelper.startPage((int)inventoryPageQueryReqDto.getPageNum(), (int)inventoryPageQueryReqDto.getPageSize());
        List csInventoryPreemptionEoList = this.dgInventoryPreemptionDomain.getMapper().selectList(queryWrapper);
        if (CollectionUtils.isEmpty((Collection)csInventoryPreemptionEoList)) {
            return new PageInfo();
        }
        List respDtoList = csInventoryPreemptionEoList.stream().map(e -> {
            ShInventoryPreemptionRespDto csInventoryPreemptionRespDto = new ShInventoryPreemptionRespDto();
            CubeBeanUtils.copyProperties((Object)csInventoryPreemptionRespDto, (Object)e, (String[])new String[0]);
            return csInventoryPreemptionRespDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(csInventoryPreemptionEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(respDtoList);
        return result;
    }

    @Override
    public List<RelShareInventoryRespDto> queryRelVirtualInventory(String channelWarehouseCode, String cargoCode) {
        List virtualWarehouseIds;
        List virtualWarehouseEos;
        AssertUtil.assertNotBlank((String)channelWarehouseCode, (String)"\u6e20\u9053\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)cargoCode, (String)"\u8d27\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List channelWarehouseEos = this.dgChannelWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)channelWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty((Collection)channelWarehouseEos, (String)"\u6e20\u9053\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (channelWarehouseEos.size() > 1) {
            throw new BizException("\u6e20\u9053\u4ed3\u7f16\u7801\u4e0d\u552f\u4e00");
        }
        DgChannelWarehouseEo channelWarehouseEo = (DgChannelWarehouseEo)channelWarehouseEos.get(0);
        List relVirtualWarehouseEos = this.relVirtualWarehouseMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"channel_warehouse_id", (Object)channelWarehouseEo.getId())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            return Lists.newArrayList();
        }
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)relVirtualWarehouseEos)) {
            map.putAll(relVirtualWarehouseEos.stream().collect(Collectors.toMap(RelVirtualWarehouseEo::getVirtualWarehouseId, RelVirtualWarehouseEo::getShareRatio, (o, o1) -> o)));
        }
        if (CollectionUtils.isEmpty((Collection)(virtualWarehouseEos = this.dgVirtualWarehouseDomain.selectByIds(virtualWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).distinct().collect(Collectors.toList()))))) {
            return Lists.newArrayList();
        }
        List virtualInventoryEos = this.dgVirtualInventoryDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_id", virtualWarehouseIds)).eq((Object)"sku_code", (Object)cargoCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (null == virtualInventoryEos) {
            virtualInventoryEos = Lists.newArrayList();
        }
        ArrayList relShareInventoryRespList = Lists.newArrayList();
        for (DgVirtualWarehouseEo virtualWarehouseEo : virtualWarehouseEos) {
            RelShareInventoryRespDto dto = new RelShareInventoryRespDto();
            BigDecimal shareInventory = BigDecimal.ZERO;
            DgVirtualInventoryEo virtualInventoryEo = virtualInventoryEos.stream().filter(o -> Objects.equal((Object)o.getWarehouseId(), (Object)virtualWarehouseEo.getId())).findFirst().orElse(null);
            dto.setAvailable(BigDecimal.ZERO);
            dto.setBalance(BigDecimal.ZERO);
            dto.setPreempt(BigDecimal.ZERO);
            if (null != virtualInventoryEo) {
                dto.setAvailable(virtualInventoryEo.getAvailable());
                dto.setBalance(virtualInventoryEo.getBalance());
                dto.setPreempt(virtualInventoryEo.getPreempt());
            }
            if (StringUtils.isNotEmpty((CharSequence)String.valueOf(virtualWarehouseEo.getId()))) {
                dto.setShareRatio((BigDecimal)map.get(virtualWarehouseEo.getId()));
            }
            dto.setId(virtualWarehouseEo.getId());
            dto.setShareWarehouseCode(virtualWarehouseEo.getWarehouseCode());
            dto.setShareWarehouseName(virtualWarehouseEo.getWarehouseName());
            dto.setShareWarehouseType("to_channel");
            dto.setShareWarehouseTypeName("\u4f9b\u8d27\u4ed3");
            dto.setCargoCode(cargoCode);
            dto.setReceiveWarehouseCode(channelWarehouseEo.getWarehouseCode());
            relShareInventoryRespList.add(dto);
        }
        return relShareInventoryRespList;
    }

    @Override
    public PageInfo<LogicInventoryRespDto> queryLogicInventory(LogicInventoryReqDto logicInventoryReqDto) {
        PageInfo pageInfo = this.channelInventoryDas.queryLogicInventory(logicInventoryReqDto);
        return pageInfo;
    }

    @Override
    public List<RelShareInventoryRespDto> queryLogicBatchInventory(String logicWarehouseCode, String cargoCode) {
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)logicWarehouseCode), (String)"\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)cargoCode), (String)"\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LogicInventoryReqDto logicInventoryReqDto = new LogicInventoryReqDto();
        logicInventoryReqDto.setWarehouseCode(logicWarehouseCode);
        logicInventoryReqDto.setItemLongCode(cargoCode);
        List dtos = this.channelInventoryDas.queryLogicBatchInventory(logicInventoryReqDto);
        return dtos;
    }

    private void checkParams(ShInventoryPageQueryReqDto csInventoryPageQueryReqDto) {
        String code = "1000";
        Assert.isTrue((null != csInventoryPageQueryReqDto ? 1 : 0) != 0, (String)code, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseClassify = csInventoryPageQueryReqDto.getWarehouseClassify();
        if (StringUtils.isNotBlank((CharSequence)warehouseClassify)) {
            Assert.isTrue((null != CsWarehouseClassifyEnum.getByCode((String)warehouseClassify) ? 1 : 0) != 0, (String)code, (String)"\u4ed3\u5e93\u5206\u7c7b\u53c2\u6570\u6709\u8bef");
        }
    }

    private QueryWrapper<DgInventoryPreemptionEo> buildQueryWrapper(ShInventoryPageQueryReqDto csInventoryPageQueryReqDto) {
        return (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query((Object)new DgInventoryPreemptionEo()).eq((Object)"dr", (Object)YesNoEnum.NO.getValue())).eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode())).eq(StringUtils.isNotEmpty((CharSequence)csInventoryPageQueryReqDto.getWarehouseClassify()), (Object)"warehouse_classify", (Object)csInventoryPageQueryReqDto.getWarehouseClassify())).in(CollectionUtils.isNotEmpty((Collection)csInventoryPageQueryReqDto.getWarehouseCodeList()), (Object)"warehouse_code", (Collection)csInventoryPageQueryReqDto.getWarehouseCodeList())).in(CollectionUtils.isNotEmpty((Collection)csInventoryPageQueryReqDto.getBatchList()), (Object)"batch", (Collection)csInventoryPageQueryReqDto.getBatchList())).in(CollectionUtils.isNotEmpty((Collection)csInventoryPageQueryReqDto.getSkuCodeList()), (Object)"sku_code", (Collection)csInventoryPageQueryReqDto.getSkuCodeList())).orderByDesc((Object)"create_time");
    }
}

