/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.utils;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.util.JdbcUtils;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.mapping.BoundSql;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtil.class);
    private static final Set<String> COUNT_TABLE_ALIAS_SET = new HashSet<String>(16);

    public static String appendDataLimit(String originSql, String conditionStr) {
        return SqlUtil.appendAndCondition(originSql, conditionStr);
    }

    public static String appendAndCondition(String sql, String whereConditionStr) {
        return SqlUtil.appendCondition(sql, whereConditionStr, SQLBinaryOperator.BooleanAnd);
    }

    public static String appendCondition(String sql, String whereConditionStr, SQLBinaryOperator sqlBinaryOperator) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)JdbcUtils.MYSQL);
        List stmtList = parser.parseStatementList();
        SQLStatement stmt = (SQLStatement)stmtList.get(0);
        if (stmt instanceof SQLSelectStatement) {
            SQLExprParser constraintsParser = SQLParserUtils.createExprParser((String)whereConditionStr, (DbType)JdbcUtils.MYSQL, (SQLParserFeature[])new SQLParserFeature[0]);
            SQLExpr constraintsExpr = constraintsParser.expr();
            SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
            SQLSelect sqlselect = selectStmt.getSelect();
            SQLSelectQueryBlock query = (SQLSelectQueryBlock)sqlselect.getQuery();
            SQLExpr whereExpr = query.getWhere();
            if (whereExpr == null) {
                query.setWhere(constraintsExpr);
            } else {
                SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr(whereExpr, sqlBinaryOperator, constraintsExpr);
                query.setWhere((SQLExpr)newWhereExpr);
            }
            sqlselect.setQuery((SQLSelectQuery)query);
            sql = sqlselect.toString();
        }
        return sql;
    }

    public static String getTableAlias(String tableName, String selectSql) {
        SQLSelectQueryBlock query = SqlUtil.getSqlSelectQueryBlock(selectSql);
        SQLTableSource tableSource = query.getFrom().findTableSource(tableName);
        if (null == tableSource) {
            return null;
        }
        String alias = tableSource.computeAlias();
        return tableName.equalsIgnoreCase(alias) ? "" : alias;
    }

    public static boolean isPageHelperCountQuery(String sql) {
        SQLSelectQueryBlock query = SqlUtil.getSqlSelectQueryBlock(sql);
        String outAlias = query.getFrom().computeAlias();
        return COUNT_TABLE_ALIAS_SET.contains(outAlias);
    }

    public static String getRealSql(String originSql) {
        SQLSelectQueryBlock query = SqlUtil.getSqlSelectQueryBlock(originSql);
        String outAlias = query.getFrom().computeAlias();
        if (COUNT_TABLE_ALIAS_SET.contains(outAlias)) {
            SQLSubqueryTableSource subQueryTableSource = (SQLSubqueryTableSource)query.getFrom();
            return subQueryTableSource.getSelect().toString();
        }
        return originSql;
    }

    public static String addTableAlias(String tableName, String tableAlias, String selectSql) {
        SQLSelectQueryBlock query = SqlUtil.getSqlSelectQueryBlock(selectSql);
        query.getFrom().findTableSource(tableName).setAlias(tableAlias);
        return query.toString();
    }

    private static SQLSelectQueryBlock getSqlSelectQueryBlock(String selectSql) {
        MySqlStatementParser parser = new MySqlStatementParser(selectSql);
        SQLStatement stmt = parser.parseStatement();
        SQLSelect sqlSelect = ((SQLSelectStatement)stmt).getSelect();
        return (SQLSelectQueryBlock)sqlSelect.getQuery();
    }

    public static String commonRule2Sql(String commonRule, String mainTableName) {
        commonRule = commonRule.toUpperCase().replace(mainTableName.toUpperCase() + ".", "mt_alias_sub.");
        return (" exists( select 1 from " + mainTableName + " mt_alias_sub where " + commonRule + " and mt_alias_sub.id=MAIN_TABLE_ALIAS.id) ").toUpperCase();
    }

    public static String getCommonRuleSubQuery(String commonRule, String mainTableName) {
        commonRule = commonRule.toUpperCase().replace(mainTableName.toUpperCase() + ".", "mt_alias_sub.");
        return (" select 1 from " + mainTableName + " mt_alias_sub where " + commonRule + " and mt_alias_sub.id=MAIN_TABLE_ALIAS.id ").toUpperCase();
    }

    public static String getCommonRuleConditon(String commonRule, String mainTableName) {
        return commonRule.toUpperCase().replace(mainTableName.toUpperCase() + ".", "MAIN_TABLE_ALIAS.");
    }

    public static String joinRule2Sql(Map.Entry<String, Map<String, String>> refTableMapEntry, List<String> joinRuleList) {
        String joinRule;
        String mainTableField = refTableMapEntry.getKey();
        String refTableName = refTableMapEntry.getValue().keySet().iterator().next().toUpperCase();
        String refTableAlias = refTableName + "_fks";
        String refTableField = refTableMapEntry.getValue().get(refTableName.toLowerCase());
        Iterator<String> var6 = joinRuleList.iterator();
        do {
            if (var6.hasNext()) continue;
            return null;
        } while (!(joinRule = var6.next()).contains(refTableName));
        joinRule = joinRule.replace(refTableName, refTableAlias);
        return (" exists ( select 1 from " + refTableName + " " + refTableAlias + " where " + joinRule + " and " + refTableAlias + "." + refTableField + "=MAIN_TABLE_ALIAS." + mainTableField + ")").toUpperCase();
    }

    public static String getSimpleCountSql(String sql, String name) {
        return "select count(" + name + ") from (" + sql + ") tmp_count";
    }

    public static void appendSql(BoundSql boundSql, String originalSql) throws NoSuchFieldException, IllegalAccessException {
        Field field = boundSql.getClass().getDeclaredField("sql");
        field.setAccessible(true);
        field.set(boundSql, originalSql);
    }

    static {
        COUNT_TABLE_ALIAS_SET.add("table_count");
        COUNT_TABLE_ALIAS_SET.add("tmp_count");
    }
}

