/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.scheduled;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowRefundTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SettlementAlternateRefundDisposeEvent")
@Scope(value="prototype")
public class SettlementAlternateRefundDisposeEvent
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SettlementAlternateRefundDisposeEvent.class);
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private ISettlementService settlementService;
    @Resource
    private DingdingSender dingdingSender;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
    }

    public boolean execute(TaskMsg taskMsg) {
        List list;
        logger.info("\u5728\u7ebf\u652f\u4ed8\u9694\u5929\u9000\u6b3e\u7ed3\u679c\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)taskMsg.getContent()));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TradeSettlementFlowEo::getTradeType, (Object)SettlementFlowTradeTypeEnum.PAY_REFUND.getCode());
        queryWrapper.eq(TradeSettlementFlowEo::getRefundType, (Object)SettlementFlowRefundTypeEnum.OFFLINE_BALANCE.getCode());
        queryWrapper.eq(TradeSettlementFlowEo::getTradeStatus, (Object)SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        if (StringUtils.isNotBlank((CharSequence)taskMsg.getContent())) {
            queryWrapper.eq(TradeSettlementFlowEo::getTradeNo, (Object)taskMsg.getContent());
        }
        if (CollectionUtil.isEmpty((Collection)(list = this.tradeSettlementFlowDas.list((Wrapper)queryWrapper)))) {
            logger.info("\u65e0\u4ea4\u6613\u9700\u8981\u5904\u7406");
            return true;
        }
        list.forEach(trade -> {
            try {
                TradeSettlementFlowRespDto respDto = new TradeSettlementFlowRespDto();
                DtoHelper.eo2Dto((BaseEo)trade, (BaseVo)respDto);
                this.settlementService.alternateRefundDispose(respDto);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.scheduled.SettlementAlternateRefundDisposeEvent\uff0c\u5728\u7ebf\u652f\u4ed8\u9694\u5929\u9000\u6b3e\u7ed3\u679c\u5904\u7406\u5f02\u5e38\uff1a" + trade.getId());
            }
        });
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

