/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SafeMobileReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SafeMobileRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISafeMobileService;
import com.dtyunxi.tcbj.center.settlement.dao.das.SafeMobileDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SafeMobileEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.identity.api.v3.IVerifyCodeApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SafeMobileServiceImpl
implements ISafeMobileService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer MOBILE_VERIFY_TYPE = 2;
    @Resource
    private SafeMobileDas safeMobileDas;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IVerifyCodeApi verifyCodeApi;

    @Override
    public Long addOrModifySafeMobile(SafeMobileReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getCardCode(), (String)"cardCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getMobileCode(), (String)"mobileCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getUniqueId(), (String)"uniqueId\u9a8c\u8bc1\u7801\u540e\u53f0\u751f\u6210\u65f6\u8fd4\u56de\u7684\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        OrgAndOrgInfoRespDto orgInfo = this.getOrgInfo(addReqDto.getOrgId());
        if (!StringUtils.equals((String)addReqDto.getCardCode(), (String)orgInfo.getOrganizationInfoDto().getLegalCardNum())) {
            this.logger.info("\u3010\u5b89\u5168\u624b\u673a\u3011\u8eab\u4efd\u8bc1\u53f7\u6709\u8bef\uff1a\u8f93\u5165\u7684\u624b\u673a\u53f7\u4e3a\uff1a{}\uff0c\u6863\u6848\u4e2d\u7684\u6cd5\u4eba\u624b\u673a\u53f7\u4e3a\uff1a{}", (Object)addReqDto.getCardCode(), (Object)orgInfo.getOrganizationInfoDto().getLegalCardNum());
            throw SettlementExceptionCode.CARDCODE_ERROR.getException();
        }
        RestResponse restResponse = this.verifyCodeApi.checkVerifyCode(addReqDto.getMobileCode(), addReqDto.getUniqueId(), MOBILE_VERIFY_TYPE);
        Boolean verifyResult = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        if (!verifyResult.booleanValue()) {
            throw SettlementExceptionCode.MOBIL_NOT_EXIT.getException();
        }
        SafeMobileEo safeMobileEo = new SafeMobileEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)safeMobileEo);
        if (addReqDto.getId() == null) {
            safeMobileEo.setOrgInfoId(orgInfo.getOrganizationInfoDto().getId());
            this.safeMobileDas.insert((BaseEo)safeMobileEo);
        } else {
            this.safeMobileDas.updateSelective((BaseEo)safeMobileEo);
        }
        return safeMobileEo.getId();
    }

    private OrgAndOrgInfoRespDto getOrgInfo(Long orgId) {
        RestResponse orgInfoRespDtoRestResp = this.organizationQueryApi.queryOrgAndOrgInfo(orgId);
        OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)orgInfoRespDtoRestResp);
        AssertUtils.notNull((Object)orgInfoRespDto, (String)String.format("\u7ec4\u7ec7\u4fe1\u606f\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", orgId));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationInfoDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationInfoDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", orgId));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", orgId));
        return orgInfoRespDto;
    }

    @Override
    public void modifyStSafeMobile(SafeMobileReqDto modifyReqDto) {
        SafeMobileEo safeMobileEo = new SafeMobileEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)safeMobileEo);
        this.safeMobileDas.updateSelective((BaseEo)safeMobileEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStSafeMobile(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.safeMobileDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SafeMobileRespDto queryById(Long orgId) {
        AssertUtils.notNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        OrgAndOrgInfoRespDto orgInfo = this.getOrgInfo(orgId);
        SafeMobileEo queryEo = new SafeMobileEo();
        queryEo.setOrgInfoId(orgInfo.getOrganizationInfoDto().getId());
        queryEo.setOrgId(orgId);
        SafeMobileEo safeMobileEo = (SafeMobileEo)this.safeMobileDas.selectOne((BaseEo)queryEo);
        SafeMobileRespDto safeMobileRespDto = new SafeMobileRespDto();
        DtoHelper.eo2Dto((BaseEo)safeMobileEo, (BaseVo)safeMobileRespDto);
        safeMobileRespDto.setCardCode(orgInfo.getOrganizationInfoDto().getLegalCardNum());
        return safeMobileRespDto;
    }

    @Override
    public PageInfo<SafeMobileRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SafeMobileReqDto safeMobileReqDto = (SafeMobileReqDto)JSON.parseObject((String)filter, SafeMobileReqDto.class);
        SafeMobileEo safeMobileEo = new SafeMobileEo();
        DtoHelper.dto2Eo((BaseVo)safeMobileReqDto, (BaseEo)safeMobileEo);
        PageInfo eoPageInfo = this.safeMobileDas.selectPage((BaseEo)safeMobileEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SafeMobileRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

