/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICiticApi;
import com.dtyunxi.tcbj.api.dto.request.CiticUserBindCardReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticBankCodesQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticResDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticBankTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticCardBindTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticRspCodeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticUserIdTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticUserTypeEnum;
import com.dtyunxi.tcbj.api.query.ICiticQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.BankNoTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.DrCommonEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettleAccBindCardStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettleAccRegiStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountBindCardReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountPasswordReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.CardInfoRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountBindCardRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountBindCardService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountPasswordService;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountBindCardDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountRegisterRelationDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountBindCardEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountRegisterRecordEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountRegisterRelationEo;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.SettlementAccountBindCardMapper;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.SettlementAccountRegisterRecordMapper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SettlementAccountBindCardServiceImpl
implements ISettlementAccountBindCardService {
    private static final Logger logger = LoggerFactory.getLogger(SettlementAccountBindCardServiceImpl.class);
    @Resource
    private SettlementAccountBindCardDas settlementAccountBindCardDas;
    @Resource
    private SettlementAccountRegisterRelationDas relationDas;
    @Resource
    private SettlementAccountRegisterRecordMapper recordMapper;
    @Resource
    private SettlementAccountBindCardDas bindCardDas;
    @Resource
    private ICiticApi iCiticApi;
    @Resource
    private ICiticQueryApi iCiticQueryApi;
    @Resource
    private ISettlementAccountPasswordService passwordService;
    @Resource
    private IOrganizationQueryApi iOrganizationQueryApi;
    @Resource
    private SettlementAccountBindCardMapper bindCardMapper;
    @Value(value="${citic.mock:false}")
    boolean citicMock;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Long addSettlementAccountBindCard(SettlementAccountBindCardReqDto addReqDto) {
        Pattern pattern;
        SettlementAccountBindCardEo bindCardEo = new SettlementAccountBindCardEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)bindCardEo);
        if (StringUtils.isEmpty((CharSequence)bindCardEo.getAccountNo())) {
            throw new BizException("\u7ed3\u7b97\u8d26\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SettlementAccountRegisterRelationEo seachRelationEo = new SettlementAccountRegisterRelationEo();
        seachRelationEo.setAccountNo(bindCardEo.getAccountNo());
        seachRelationEo.setRegisterStatus(SettleAccRegiStatusEnum.SUCCESS.getCode());
        SettlementAccountRegisterRelationEo resRelationEo = (SettlementAccountRegisterRelationEo)this.relationDas.selectOne((BaseEo)seachRelationEo);
        if (resRelationEo == null || resRelationEo.getId() == null) {
            throw new BizException("\u8be5\u7ed3\u7b97\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u6ce8\u9500\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8fdb\u884c\u7ed1\u5361");
        }
        List eoLists = this.bindCardMapper.queryBindCardNumByAccNo(bindCardEo.getAccountNo());
        int curMonAccNo = 0;
        SimpleDateFormat format = new SimpleDateFormat("YYYYMM");
        String curMon = format.format(new Date());
        for (SettlementAccountBindCardEo eo : eoLists) {
            if (!curMon.equals(format.format(eo.getCreateTime()))) continue;
            ++curMonAccNo;
        }
        if (curMonAccNo > 10) {
            throw new BizException("\u7ed3\u7b97\u8d26\u6237\u5728\u4e00\u4e2a\u6708\u5185\u6700\u5927\u7ed1\u5361\u6b21\u6570\u4e3a10");
        }
        SettlementAccountRegisterRecordEo recordEo = this.recordMapper.queryMaxTimeByRelationId(resRelationEo.getId());
        if (StringUtils.isEmpty((CharSequence)bindCardEo.getBankAccount())) {
            throw new BizException("\u94f6\u884c\u8d26\u53f7\u5fc5\u586b");
        }
        SettlementAccountBindCardEo searchBindCardEo = new SettlementAccountBindCardEo();
        searchBindCardEo.setBankAccount(bindCardEo.getBankAccount());
        searchBindCardEo.setBindStatus(SettleAccBindCardStatusEnum.SUCCESS.getCode());
        List isExistBindEoList = this.bindCardDas.selectList((BaseEo)searchBindCardEo);
        if (isExistBindEoList != null && isExistBindEoList.size() > 0) {
            throw new BizException("\u8be5\u94f6\u884c\u5361\u53f7\u5df2\u7ed1\u5b9a\u767b\u8bb0\u7c3f\uff0c\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a");
        }
        if (!StringUtils.isEmpty((CharSequence)bindCardEo.getMobile()) && !(pattern = Pattern.compile("[1]\\d{10}$")).matcher(bindCardEo.getMobile()).matches()) {
            throw new BizException("\u8bf7\u586b\u519911\u4f4d\u6b63\u786e\u624b\u673a\u53f7\u7801");
        }
        if (StringUtils.isEmpty((CharSequence)bindCardEo.getUnionCode())) {
            throw new BizException("\u8bf7\u9009\u62e9\u94f6\u884c\u5f00\u6237\u652f\u884c");
        }
        if (StringUtils.isEmpty((CharSequence)bindCardEo.getBankType())) {
            throw new BizException("\u94f6\u884c\u8d26\u6237\u7c7b\u578b\u5fc5\u586b");
        }
        bindCardEo.setAccountName(recordEo.getLegalName());
        if (CiticUserTypeEnum.INDIVIDUAL_BUSINESS.getKey().equals(recordEo.getRegisterType().toString()) && CiticBankTypeEnum.fromCode((String)bindCardEo.getBankType()).getType().equals(BankNoTypeEnum.PRIVATE.getCode())) {
            bindCardEo.setIdType(CiticUserIdTypeEnum.ID_CARD.key);
            bindCardEo.setIdCode(recordEo.getLegalIdCard());
            bindCardEo.setAccountName(recordEo.getLegalName());
        } else {
            bindCardEo.setIdType(recordEo.getCardType());
            bindCardEo.setIdCode(recordEo.getCardCode());
            bindCardEo.setAccountName(recordEo.getRegisterName());
        }
        if (CiticUserTypeEnum.CORP.getKey().equals(recordEo.getRegisterType().toString())) {
            if (CiticBankTypeEnum.provideCompany().get(bindCardEo.getBankType()) == null) {
                throw new BizException("\u5f53\u524d\u767b\u8bb0\u7c3f\u4e3a\u4f01\u4e1a\u7c7b\u578b\uff0c\u4e0d\u80fd\u9009\u62e9\u5bf9\u79c1\u8d26\u53f7");
            }
        } else if (CiticUserTypeEnum.PERSONAL.getKey().equals(recordEo.getRegisterType().toString())) {
            if (CiticBankTypeEnum.providePerson().get(bindCardEo.getBankType()) == null) {
                throw new BizException("\u5f53\u524d\u767b\u8bb0\u7c3f\u4e3a\u4e2a\u4eba\u7c7b\u578b\uff0c\u4e0d\u80fd\u9009\u62e9\u5bf9\u516c\u8d26\u53f7");
            }
            if (StringUtils.isEmpty((CharSequence)bindCardEo.getMobile())) {
                throw new BizException("\u5f53\u524d\u767b\u8bb0\u7c3f\u4e3a\u4e2a\u4eba\u7c7b\u578b\uff0c\u624b\u673a\u53f7\u5fc5\u586b");
            }
        }
        if (StringUtils.isEmpty((CharSequence)bindCardEo.getIdCode()) || StringUtils.isEmpty((CharSequence)bindCardEo.getIdType())) {
            throw new BizException("\u8bc1\u4ef6\u7c7b\u578b\u6216\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        bindCardEo.setBindAccountNo(resRelationEo.getBindAccountNo());
        bindCardEo.setCustomerName(recordEo.getRegisterName());
        bindCardEo.setRelationId(resRelationEo.getId());
        String user = (String)ServiceContext.getContext().getKeys().get("yes.req.userId");
        bindCardEo.setCreatePerson(user);
        bindCardEo.setUpdatePerson(user);
        if (!this.citicMock) {
            List bankDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iCiticQueryApi.bankCodesQuery(bindCardEo.getUnionCode(), null));
            if (bankDtoList == null || bankDtoList.size() != 1) throw new BizException("\u8054\u884c\u53f7\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            bindCardEo.setUnionBankName(((CiticBankCodesQueryResDto)bankDtoList.get(0)).getBankName());
        } else {
            logger.info("\u4e2d\u4fe1\u94f6\u884cMOCK\u6321\u677f\u5f00\u542f\uff0c\u8df3\u8fc7iCiticQueryApi.bankCodesQuery\u63a5\u53e3");
        }
        CiticUserBindCardReqDto citicReqDto = new CiticUserBindCardReqDto();
        citicReqDto.setUserId(bindCardEo.getBindAccountNo());
        citicReqDto.setOpType(CiticCardBindTypeEnum.BIND.key);
        citicReqDto.setPanNum(bindCardEo.getUnionCode());
        citicReqDto.setAcctNm(bindCardEo.getAccountName());
        citicReqDto.setPan(bindCardEo.getBankAccount());
        citicReqDto.setUserIdType(bindCardEo.getIdType());
        citicReqDto.setBankCardNo(bindCardEo.getIdCode());
        citicReqDto.setAcctType(bindCardEo.getBankType());
        citicReqDto.setBankPhone(bindCardEo.getMobile());
        if (!this.citicMock) {
            RestResponse userBindCardResp = this.iCiticApi.userBindCard(citicReqDto);
            if (!"0".equals(userBindCardResp.getResultCode())) {
                throw new BizException(userBindCardResp.getResultCode(), userBindCardResp.getResultMsg());
            }
            if (!((CiticResDto)userBindCardResp.getData()).getRspCode().equals(CiticRspCodeEnum.SUCCESS.key)) {
                if (!((CiticResDto)userBindCardResp.getData()).getRspCode().equals("ME048")) throw new BizException(((CiticResDto)userBindCardResp.getData()).getRspCode(), ((CiticResDto)userBindCardResp.getData()).getRspMsg());
                throw new BizException(((CiticResDto)userBindCardResp.getData()).getRspCode(), "\u5df2\u8d85\u8fc7\u767b\u8bb0\u7c3f\u6700\u5927\u5141\u8bb8\u7ed1\u5361\u6570\uff0c\u8bf7\u5148\u89e3\u7ed1\u5f53\u524d\u767b\u8bb0\u7c3f\u5176\u4ed6\u5361\u540e\u518d\u7ed1\u5b9a\u8be5\u94f6\u884c\u5361");
            }
        }
        bindCardEo.setBindStatus(SettleAccBindCardStatusEnum.SUCCESS.getCode());
        this.settlementAccountBindCardDas.insert((BaseEo)bindCardEo);
        return bindCardEo.getId();
    }

    @Override
    public void modifySettlementAccountBindCard(SettlementAccountBindCardReqDto modifyReqDto) {
        if (modifyReqDto.getId() == null) {
            throw new BizException("\u5f53\u524d\u5361id\u4e0d\u5b58\u5728\uff0c\u4e0d\u9700\u89e3\u7ed1");
        }
        SettlementAccountBindCardRespDto unbindDto = this.queryById(modifyReqDto.getId());
        if (unbindDto == null || unbindDto.getId() == null) {
            throw new BizException("\u5f53\u524d\u5361\u4e0d\u5b58\u5728\uff0c\u4e0d\u9700\u89e3\u7ed1");
        }
        if (!SettleAccBindCardStatusEnum.SUCCESS.getCode().equals(unbindDto.getBindStatus())) {
            throw new BizException("\u5f53\u524d\u5361\u975e\u7ed1\u5361\u72b6\u6001\uff0c\u4e0d\u9700\u89e3\u7ed1");
        }
        if (StringUtils.isEmpty((CharSequence)modifyReqDto.getPayPassword())) {
            throw new BizException("\u8bf7\u8f93\u5165\u652f\u4ed8\u5bc6\u7801");
        }
        SettlementAccountRegisterRelationEo relationEo = (SettlementAccountRegisterRelationEo)this.relationDas.selectByPrimaryKey(unbindDto.getRelationId());
        OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)this.iOrganizationQueryApi.queryOrgAndOrgInfo(relationEo.getOrganizationId()).getData();
        SettlementAccountPasswordReqDto passwordReqDto = new SettlementAccountPasswordReqDto();
        passwordReqDto.setUserPassword(modifyReqDto.getPayPassword());
        passwordReqDto.setOrgId(relationEo.getOrganizationId());
        passwordReqDto.setOrgCode(orgInfoRespDto.getOrganizationInfoDto().getOrgCode());
        passwordReqDto.setOrgInfoId(orgInfoRespDto.getOrganizationInfoDto().getId());
        if (!this.passwordService.checkPasswork(passwordReqDto).booleanValue()) {
            throw new BizException("\u652f\u4ed8\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        CiticUserBindCardReqDto citicReqDto = new CiticUserBindCardReqDto();
        citicReqDto.setUserId(unbindDto.getBindAccountNo());
        citicReqDto.setOpType(CiticCardBindTypeEnum.UNBIND.key);
        citicReqDto.setPanNum(unbindDto.getUnionCode());
        citicReqDto.setAcctNm(unbindDto.getAccountName());
        citicReqDto.setPan(unbindDto.getBankAccount());
        citicReqDto.setUserIdType(unbindDto.getIdType());
        citicReqDto.setBankCardNo(unbindDto.getIdCode());
        citicReqDto.setAcctType(unbindDto.getBankType());
        citicReqDto.setBankPhone(unbindDto.getMobile());
        if (!this.citicMock) {
            RestResponse userBindCardResp = this.iCiticApi.userBindCard(citicReqDto);
            if (!"0".equals(userBindCardResp.getResultCode())) {
                throw new BizException(userBindCardResp.getResultCode(), userBindCardResp.getResultMsg());
            }
            if (!((CiticResDto)userBindCardResp.getData()).getRspCode().equals(CiticRspCodeEnum.SUCCESS.key) && !((CiticResDto)userBindCardResp.getData()).getRspCode().equals("JU217")) {
                throw new BizException(((CiticResDto)userBindCardResp.getData()).getRspCode(), ((CiticResDto)userBindCardResp.getData()).getRspMsg());
            }
        } else {
            logger.info("\u4e2d\u4fe1\u94f6\u884cMOCK\u6321\u677f\u5f00\u542f\uff0c\u8df3\u8fc7 iCiticApi.userBindCard \u63a5\u53e3");
        }
        SettlementAccountBindCardEo bindCardEo = new SettlementAccountBindCardEo();
        bindCardEo.setId(unbindDto.getId());
        bindCardEo.setBindStatus(SettleAccBindCardStatusEnum.UNBIND.getCode());
        bindCardEo.setDr(DrCommonEnum.YES.getCode());
        String user = (String)ServiceContext.getContext().getKeys().get("yes.req.userId");
        bindCardEo.setUpdatePerson(user);
        bindCardEo.setUpdateTime(new Date());
        this.settlementAccountBindCardDas.updateSelective((BaseEo)bindCardEo);
    }

    @Override
    public void modifySettlementAccountBindCard2(SettlementAccountBindCardReqDto modifyReqDto) {
        if (modifyReqDto.getId() == null) {
            throw new BizException("\u5f53\u524d\u5361id\u4e0d\u5b58\u5728\uff0c\u4e0d\u9700\u89e3\u7ed1");
        }
        SettlementAccountBindCardRespDto unbindDto = this.queryById(modifyReqDto.getId());
        if (unbindDto == null || unbindDto.getId() == null) {
            throw new BizException("\u5f53\u524d\u5361\u4e0d\u5b58\u5728\uff0c\u4e0d\u9700\u89e3\u7ed1");
        }
        if (!SettleAccBindCardStatusEnum.SUCCESS.getCode().equals(unbindDto.getBindStatus())) {
            throw new BizException("\u5f53\u524d\u5361\u975e\u7ed1\u5361\u72b6\u6001\uff0c\u4e0d\u9700\u89e3\u7ed1");
        }
        CiticUserBindCardReqDto citicReqDto = new CiticUserBindCardReqDto();
        citicReqDto.setUserId(unbindDto.getBindAccountNo());
        citicReqDto.setOpType(CiticCardBindTypeEnum.UNBIND.key);
        citicReqDto.setPanNum(unbindDto.getUnionCode());
        citicReqDto.setAcctNm(unbindDto.getAccountName());
        citicReqDto.setPan(unbindDto.getBankAccount());
        citicReqDto.setUserIdType(unbindDto.getIdType());
        citicReqDto.setBankCardNo(unbindDto.getIdCode());
        citicReqDto.setAcctType(unbindDto.getBankType());
        citicReqDto.setBankPhone(unbindDto.getMobile());
        RestResponse userBindCardResp = this.iCiticApi.userBindCard(citicReqDto);
        if (!"0".equals(userBindCardResp.getResultCode())) {
            throw new BizException(userBindCardResp.getResultCode(), userBindCardResp.getResultMsg());
        }
        if (!((CiticResDto)userBindCardResp.getData()).getRspCode().equals(CiticRspCodeEnum.SUCCESS.key) && !((CiticResDto)userBindCardResp.getData()).getRspCode().equals("JU217")) {
            throw new BizException(((CiticResDto)userBindCardResp.getData()).getRspCode(), ((CiticResDto)userBindCardResp.getData()).getRspMsg());
        }
        SettlementAccountBindCardEo bindCardEo = new SettlementAccountBindCardEo();
        bindCardEo.setId(unbindDto.getId());
        bindCardEo.setBindStatus(SettleAccBindCardStatusEnum.UNBIND.getCode());
        bindCardEo.setDr(DrCommonEnum.YES.getCode());
        String user = (String)ServiceContext.getContext().getKeys().get("yes.req.userId");
        bindCardEo.setUpdatePerson(user);
        bindCardEo.setUpdateTime(new Date());
        this.settlementAccountBindCardDas.updateSelective((BaseEo)bindCardEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSettlementAccountBindCard(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.settlementAccountBindCardDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SettlementAccountBindCardRespDto queryById(Long id) {
        SettlementAccountBindCardEo settlementAccountBindCardEo = (SettlementAccountBindCardEo)this.settlementAccountBindCardDas.selectByPrimaryKey(id);
        SettlementAccountBindCardRespDto settlementAccountBindCardRespDto = new SettlementAccountBindCardRespDto();
        DtoHelper.eo2Dto((BaseEo)settlementAccountBindCardEo, (BaseVo)settlementAccountBindCardRespDto);
        if (settlementAccountBindCardEo != null) {
            settlementAccountBindCardRespDto.setIdTypeName(CiticUserIdTypeEnum.getLabel((String)settlementAccountBindCardEo.getIdType()));
            settlementAccountBindCardRespDto.setBankTypeMap(CiticBankTypeEnum.provideHome());
        }
        return settlementAccountBindCardRespDto;
    }

    @Override
    public PageInfo<SettlementAccountBindCardRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SettlementAccountBindCardReqDto settlementAccountBindCardReqDto = (SettlementAccountBindCardReqDto)JSON.parseObject((String)filter, SettlementAccountBindCardReqDto.class);
        SettlementAccountBindCardEo settlementAccountBindCardEo = new SettlementAccountBindCardEo();
        DtoHelper.dto2Eo((BaseVo)settlementAccountBindCardReqDto, (BaseEo)settlementAccountBindCardEo);
        PageInfo eoPageInfo = this.settlementAccountBindCardDas.selectPage((BaseEo)settlementAccountBindCardEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SettlementAccountBindCardRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<SettlementAccountBindCardRespDto> queryListByAccount(SettlementAccountBindCardReqDto dto) {
        if (ObjectUtils.isEmpty((Object)dto) || StringUtils.isEmpty((CharSequence)dto.getAccountNo())) {
            throw new BizException("\u7ed3\u7b97\u8d26\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SettlementAccountBindCardEo settlementAccountBindCardEo = new SettlementAccountBindCardEo();
        settlementAccountBindCardEo.setAccountNo(dto.getAccountNo());
        if (StringUtils.isNotEmpty((CharSequence)dto.getBindStatus())) {
            settlementAccountBindCardEo.setBindStatus(dto.getBindStatus());
        }
        List select = this.settlementAccountBindCardDas.select((BaseEo)settlementAccountBindCardEo);
        ArrayList<SettlementAccountBindCardRespDto> dtoList = new ArrayList<SettlementAccountBindCardRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, dtoList, SettlementAccountBindCardRespDto.class);
        return dtoList;
    }

    @Override
    public SettlementAccountBindCardRespDto queryForBindCardByAccount(String accountNo) {
        if (StringUtils.isEmpty((CharSequence)accountNo)) {
            throw new BizException("\u7ed3\u7b97\u8d26\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SettlementAccountRegisterRelationEo seachRelationEo = new SettlementAccountRegisterRelationEo();
        seachRelationEo.setAccountNo(accountNo);
        seachRelationEo.setRegisterStatus(SettleAccRegiStatusEnum.SUCCESS.getCode());
        SettlementAccountRegisterRelationEo resRelationEo = (SettlementAccountRegisterRelationEo)this.relationDas.selectOne((BaseEo)seachRelationEo);
        if (resRelationEo == null || resRelationEo.getId() == null) {
            throw new BizException("\u8be5\u7ed3\u7b97\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u6ce8\u9500\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8fdb\u884c\u7ed1\u5361");
        }
        SettlementAccountRegisterRecordEo recordEo = this.recordMapper.queryMaxTimeByRelationId(resRelationEo.getId());
        SettlementAccountBindCardRespDto bindCardRespDto = new SettlementAccountBindCardRespDto();
        bindCardRespDto.setAccountNo(accountNo);
        bindCardRespDto.setBindAccountNo(resRelationEo.getBindAccountNo());
        bindCardRespDto.setMobile(recordEo.getPhone());
        bindCardRespDto.setCustomerName(recordEo.getRegisterName());
        bindCardRespDto.setAccountName(recordEo.getRegisterName());
        bindCardRespDto.setIdType(recordEo.getCardType());
        bindCardRespDto.setIdCode(recordEo.getCardCode());
        bindCardRespDto.setIdTypeName(CiticUserIdTypeEnum.getLabel((String)recordEo.getCardType()));
        if (CiticUserTypeEnum.CORP.getKey().equals(recordEo.getRegisterType().toString())) {
            bindCardRespDto.setBankTypeMap(CiticBankTypeEnum.provideCompany());
        } else if (CiticUserTypeEnum.PERSONAL.getKey().equals(recordEo.getRegisterType().toString())) {
            bindCardRespDto.setBankTypeMap(CiticBankTypeEnum.providePerson());
        } else {
            bindCardRespDto.setBankTypeMap(CiticBankTypeEnum.provideHome());
            bindCardRespDto.setIdType("");
            bindCardRespDto.setIdCode("");
            bindCardRespDto.setIdTypeName("");
            bindCardRespDto.setAccountName("");
            bindCardRespDto.setRegisterType(recordEo.getRegisterType());
            ArrayList<CardInfoRespDto> cardList = new ArrayList<CardInfoRespDto>();
            for (String bankType : bindCardRespDto.getBankTypeMap().keySet()) {
                CardInfoRespDto cardInfoRespDto = new CardInfoRespDto();
                cardInfoRespDto.setBankTypeCode(bankType);
                if (CiticBankTypeEnum.fromCode((String)bankType).getType().equals(BankNoTypeEnum.PRIVATE.getCode())) {
                    cardInfoRespDto.setCardTypeCode(CiticUserIdTypeEnum.ID_CARD.key);
                    cardInfoRespDto.setCardTypeName(CiticUserIdTypeEnum.ID_CARD.label);
                    cardInfoRespDto.setCardNo(recordEo.getLegalIdCard());
                    cardInfoRespDto.setAccountName(recordEo.getLegalName());
                } else {
                    cardInfoRespDto.setCardTypeCode(recordEo.getCardType());
                    cardInfoRespDto.setCardTypeName(CiticUserIdTypeEnum.getLabel((String)recordEo.getCardType()));
                    cardInfoRespDto.setCardNo(recordEo.getCardCode());
                    cardInfoRespDto.setAccountName(recordEo.getRegisterName());
                }
                cardList.add(cardInfoRespDto);
            }
            bindCardRespDto.setCardList(cardList);
        }
        return bindCardRespDto;
    }
}

